/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.params;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.extension.params.HtmlParameterStats;

public class ParamsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final int COLUMN_COUNT = 7;
    private final Vector<String> columnNames = new Vector(7);
    private List<HtmlParameterStats> paramStats;
    private int lastAddedRow;
    private int lastEditedRow;

    public ParamsTableModel() {
        this.columnNames.add(Constant.messages.getString("params.table.header.type"));
        this.columnNames.add(Constant.messages.getString("params.table.header.name"));
        this.columnNames.add(Constant.messages.getString("params.table.header.used"));
        this.columnNames.add(Constant.messages.getString("params.table.header.numvals"));
        this.columnNames.add(Constant.messages.getString("params.table.header.pcchange"));
        this.columnNames.add(Constant.messages.getString("params.table.header.flags"));
        this.columnNames.add(Constant.messages.getString("params.table.header.values"));
        this.paramStats = Collections.synchronizedList(new ArrayList());
        this.lastAddedRow = -1;
        this.lastEditedRow = -1;
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public int getRowCount() {
        return this.paramStats.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames.get(col);
    }

    public List<String> getColumnNames() {
        return new ArrayList<String>(this.columnNames);
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object obj = null;
        if (row >= this.paramStats.size()) {
            return null;
        }
        HtmlParameterStats param = this.paramStats.get(row);
        switch (col) {
            case 0: {
                obj = Constant.messages.getString("params.type." + param.getType().name());
                break;
            }
            case 1: {
                obj = param.getName();
                break;
            }
            case 2: {
                obj = param.getTimesUsed();
                break;
            }
            case 3: {
                obj = param.getValues().size();
                break;
            }
            case 4: {
                obj = this.getPercentChange(param);
                break;
            }
            case 5: {
                obj = param.getAllFlags();
                break;
            }
            case 6: {
                obj = param.getValuesSummary();
            }
        }
        return obj;
    }

    private int getPercentChange(HtmlParameterStats param) {
        if (param.getValues().size() == 1) {
            return 0;
        }
        return param.getValues().size() * 100 / param.getTimesUsed();
    }

    public HtmlParameterStats getHtmlParameterStatsAtRow(int row) {
        return this.paramStats.get(row);
    }

    public synchronized void addHtmlParameterStats(HtmlParameterStats param) {
        this.lastAddedRow = -1;
        for (int i = 0; i < this.paramStats.size(); ++i) {
            int cmp = param.compareTo(this.paramStats.get(i));
            if (cmp < 0) {
                this.paramStats.add(i, param);
                this.fireTableRowsInserted(i, i);
                this.lastAddedRow = i;
                return;
            }
            if (cmp != 0) continue;
            this.lastAddedRow = i;
            return;
        }
        this.paramStats.add(param);
        this.fireTableRowsInserted(this.paramStats.size() - 1, this.paramStats.size() - 1);
        this.lastAddedRow = this.paramStats.size() - 1;
    }

    public int getLastAddedRow() {
        return this.lastAddedRow;
    }

    public int getLastEditedRow() {
        return this.lastEditedRow;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public Class<? extends Object> getColumnClass(int c) {
        switch (c) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Integer.class;
            }
            case 3: {
                return Integer.class;
            }
            case 4: {
                return Integer.class;
            }
            case 5: {
                return String.class;
            }
            case 6: {
                return String.class;
            }
        }
        return null;
    }

    public void removeAllElements() {
        this.paramStats.clear();
    }
}

