/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.custompages;

import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.zaproxy.zap.extension.custompages.ContextCustomPagePanel;
import org.zaproxy.zap.extension.custompages.CustomPage;
import org.zaproxy.zap.extension.custompages.CustomPageMatcherLocation;
import org.zaproxy.zap.extension.custompages.DefaultCustomPage;
import org.zaproxy.zap.extension.custompages.DialogAddCustomPage;
import org.zaproxy.zap.extension.custompages.PopupFlagCustomPageIndicatorMenu;
import org.zaproxy.zap.extension.stdmenus.PopupContextMenuItemFactory;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.ContextDataFactory;
import org.zaproxy.zap.view.AbstractContextPropertiesPanel;
import org.zaproxy.zap.view.ContextPanelFactory;
import org.zaproxy.zap.view.popup.PopupMenuItemContext;
import org.zaproxy.zap.view.popup.PopupMenuItemSiteNodeContextMenuFactory;

public class ExtensionCustomPages
extends ExtensionAdaptor {
    public static final String NAME = "ExtensionCustomPages";
    public static final String CONTEXT_CONFIG_CUSTOM_PAGES = "context.custompages";
    public static final String CONTEXT_CONFIG_CUSTOM_PAGE = "context.custompages.page";
    public static final List<Integer> AUTH_HTTP_STATUS_CODES = Collections.unmodifiableList(Arrays.asList(401, 403));
    private static final int TYPE_CUSTOM_PAGE = 600;
    private static final Logger LOGGER = LogManager.getLogger(ExtensionCustomPages.class);
    protected static final String PREFIX = "custompages";
    private CustomPagesUtility customPagesUtility;
    private Map<Integer, ContextCustomPagePanel> customPagePanelsMap;
    private PopupContextMenuItemFactory popupFlagCustomPageIndicatorMenuFactory;
    private PopupMenuItemSiteNodeContextMenuFactory popupFlagCustomPageUrlMenuFactory;

    public ExtensionCustomPages() {
        this.setName(NAME);
    }

    @Override
    public void init() {
        super.init();
        this.customPagesUtility = new CustomPagesUtility();
        this.customPagePanelsMap = new HashMap<Integer, ContextCustomPagePanel>();
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("custompages.name");
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        extensionHook.addSessionListener(this.customPagesUtility);
        this.getModel().addContextDataFactory(this.customPagesUtility);
        if (this.getView() != null) {
            this.getView().addContextPanelFactory(this.customPagesUtility);
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupFlagCustomPageIndicatorMenu());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupFlagCustomPageUrlMenu());
        }
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("custompages.desc");
    }

    private PopupContextMenuItemFactory getPopupFlagCustomPageIndicatorMenu() {
        if (this.popupFlagCustomPageIndicatorMenuFactory == null) {
            this.popupFlagCustomPageIndicatorMenuFactory = new PopupContextMenuItemFactory("dd - " + Constant.messages.getString("context.flag.popup")){
                private static final long serialVersionUID = 2453839120088204123L;

                @Override
                public ExtensionPopupMenuItem getContextMenu(Context context, String parentMenu) {
                    return new PopupFlagCustomPageIndicatorMenu(context);
                }
            };
        }
        return this.popupFlagCustomPageIndicatorMenuFactory;
    }

    private PopupMenuItemSiteNodeContextMenuFactory getPopupFlagCustomPageUrlMenu() {
        if (this.popupFlagCustomPageUrlMenuFactory == null) {
            this.popupFlagCustomPageUrlMenuFactory = new PopupMenuItemSiteNodeContextMenuFactory(Constant.messages.getString("context.flag.popup")){
                private static final long serialVersionUID = 8927418764L;

                @Override
                public PopupMenuItemContext getContextMenu(final Context context, String parentMenu) {
                    return new PopupMenuItemContext(context, parentMenu, Constant.messages.getString("custompages.popup.url", context.getName())){
                        private static final long serialVersionUID = 1967885623005183801L;

                        @Override
                        public void performAction(SiteNode sn) {
                            DialogAddCustomPage dialogAddCustomPage = this.getDialogAddCustomPage(context, sn.getHistoryReference().getURI().toString());
                            dialogAddCustomPage.setVisible(true);
                            context.addCustomPage(dialogAddCustomPage.getCustomPage());
                        }

                        private DialogAddCustomPage getDialogAddCustomPage(Context currentContext, String url) {
                            DialogAddCustomPage dialogAddCustomPage = new DialogAddCustomPage((Window)ExtensionCustomPages.this.getView().getMainFrame());
                            dialogAddCustomPage.setWorkingContext(currentContext);
                            dialogAddCustomPage.getCustomPagePageMatcherLocationsCombo().setSelectedItem(CustomPageMatcherLocation.URL.getName());
                            dialogAddCustomPage.getPageMatcherTextField().setText(url);
                            return dialogAddCustomPage;
                        }
                    };
                }
            };
        }
        return this.popupFlagCustomPageUrlMenuFactory;
    }

    private class CustomPagesUtility
    implements ContextPanelFactory,
    ContextDataFactory,
    SessionChangedListener {
        private CustomPagesUtility() {
        }

        @Override
        public void loadContextData(Session session, Context context) {
            try {
                List<String> encodedCustomPages = session.getContextDataStrings(context.getId(), 600);
                for (String e : encodedCustomPages) {
                    DefaultCustomPage cp = DefaultCustomPage.decode(context.getId(), e);
                    context.addCustomPage(cp);
                }
            }
            catch (Exception ex) {
                LOGGER.error("Unable to load CustomPages.", (Throwable)ex);
            }
        }

        @Override
        public void persistContextData(Session session, Context context) {
            try {
                ArrayList<String> encodedCustomPages = new ArrayList<String>();
                if (context != null) {
                    for (CustomPage cp : context.getCustomPages()) {
                        encodedCustomPages.add(DefaultCustomPage.encode(cp));
                    }
                    session.setContextData(context.getId(), 600, encodedCustomPages);
                }
            }
            catch (Exception ex) {
                LOGGER.error("Unable to persist CustomPages", (Throwable)ex);
            }
        }

        @Override
        public void exportContextData(Context ctx, Configuration config) {
            if (ctx != null) {
                for (CustomPage cp : ctx.getCustomPages()) {
                    config.addProperty(ExtensionCustomPages.CONTEXT_CONFIG_CUSTOM_PAGE, (Object)DefaultCustomPage.encode(cp));
                }
            }
        }

        @Override
        public void importContextData(Context ctx, Configuration config) {
            List list = config.getList(ExtensionCustomPages.CONTEXT_CONFIG_CUSTOM_PAGE);
            for (Object o : list) {
                DefaultCustomPage cp = DefaultCustomPage.decode(ctx.getId(), o.toString());
                ctx.addCustomPage(cp);
            }
        }

        @Override
        public AbstractContextPropertiesPanel getContextPanel(Context ctx) {
            ContextCustomPagePanel panel = ExtensionCustomPages.this.customPagePanelsMap.get(ctx.getId());
            if (panel == null) {
                panel = new ContextCustomPagePanel(ctx.getId());
                ExtensionCustomPages.this.customPagePanelsMap.put(ctx.getId(), panel);
            }
            return panel;
        }

        @Override
        public void discardContexts() {
            ExtensionCustomPages.this.customPagePanelsMap.clear();
        }

        @Override
        public void discardContext(Context ctx) {
            ExtensionCustomPages.this.customPagePanelsMap.remove(ctx.getId());
        }

        @Override
        public void sessionChanged(Session session) {
        }

        @Override
        public void sessionAboutToChange(Session session) {
        }

        @Override
        public void sessionScopeChanged(Session session) {
        }

        @Override
        public void sessionModeChanged(Control.Mode mode) {
        }
    }
}

