/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import javax.management.ObjectName;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class SocketProperties {
    private static final Log log = LogFactory.getLog(SocketProperties.class);
    private static final StringManager sm = StringManager.getManager(SocketProperties.class);
    protected int processorCache = 0;
    protected int eventCache = 0;
    protected boolean directBuffer = false;
    protected boolean directSslBuffer = false;
    protected Integer rxBufSize = null;
    protected Integer txBufSize = null;
    protected int appReadBufSize = 8192;
    protected int appWriteBufSize = 8192;
    protected int bufferPool = -2;
    protected int bufferPoolSize = -2;
    protected Boolean tcpNoDelay = Boolean.TRUE;
    protected Boolean soKeepAlive = null;
    protected Boolean ooBInline = null;
    protected Boolean soReuseAddress = null;
    protected Boolean soLingerOn = null;
    protected Integer soLingerTime = null;
    protected Integer soTimeout = 20000;
    protected Integer performanceConnectionTime = null;
    protected Integer performanceLatency = null;
    protected Integer performanceBandwidth = null;
    protected long timeoutInterval = 1000L;
    protected int unlockTimeout = 250;
    private ObjectName oname = null;

    public void setProperties(Socket socket) throws SocketException {
        if (this.rxBufSize != null) {
            socket.setReceiveBufferSize(this.rxBufSize);
        }
        if (this.txBufSize != null) {
            socket.setSendBufferSize(this.txBufSize);
        }
        if (this.ooBInline != null) {
            socket.setOOBInline(this.ooBInline);
        }
        if (this.soKeepAlive != null) {
            socket.setKeepAlive(this.soKeepAlive);
        }
        if (this.performanceConnectionTime != null && this.performanceLatency != null && this.performanceBandwidth != null) {
            socket.setPerformancePreferences(this.performanceConnectionTime, this.performanceLatency, this.performanceBandwidth);
        }
        if (this.soReuseAddress != null) {
            socket.setReuseAddress(this.soReuseAddress);
        }
        if (this.soLingerOn != null && this.soLingerTime != null) {
            socket.setSoLinger(this.soLingerOn, this.soLingerTime);
        }
        if (this.soTimeout != null && this.soTimeout >= 0) {
            socket.setSoTimeout(this.soTimeout);
        }
        if (this.tcpNoDelay != null) {
            try {
                socket.setTcpNoDelay(this.tcpNoDelay);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
    }

    public void setProperties(ServerSocket serverSocket) throws SocketException {
        if (this.rxBufSize != null) {
            serverSocket.setReceiveBufferSize(this.rxBufSize);
        }
        if (this.performanceConnectionTime != null && this.performanceLatency != null && this.performanceBandwidth != null) {
            serverSocket.setPerformancePreferences(this.performanceConnectionTime, this.performanceLatency, this.performanceBandwidth);
        }
        if (this.soReuseAddress != null) {
            serverSocket.setReuseAddress(this.soReuseAddress);
        }
        if (this.soTimeout != null && this.soTimeout >= 0) {
            serverSocket.setSoTimeout(this.soTimeout);
        }
    }

    public void setProperties(AsynchronousSocketChannel asynchronousSocketChannel) throws IOException {
        if (this.rxBufSize != null) {
            asynchronousSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, this.rxBufSize);
        }
        if (this.txBufSize != null) {
            asynchronousSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, this.txBufSize);
        }
        if (this.soKeepAlive != null) {
            asynchronousSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, this.soKeepAlive);
        }
        if (this.soReuseAddress != null) {
            asynchronousSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, this.soReuseAddress);
        }
        if (this.soLingerOn != null && this.soLingerOn.booleanValue() && this.soLingerTime != null) {
            asynchronousSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_LINGER, this.soLingerTime);
        }
        if (this.tcpNoDelay != null) {
            asynchronousSocketChannel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, this.tcpNoDelay);
        }
    }

    public void setProperties(AsynchronousServerSocketChannel asynchronousServerSocketChannel) throws IOException {
        if (this.rxBufSize != null) {
            asynchronousServerSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, this.rxBufSize);
        }
        if (this.soReuseAddress != null) {
            asynchronousServerSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, this.soReuseAddress);
        }
    }

    public boolean getDirectBuffer() {
        return this.directBuffer;
    }

    public boolean getDirectSslBuffer() {
        return this.directSslBuffer;
    }

    public boolean getOoBInline() {
        return this.ooBInline;
    }

    public int getPerformanceBandwidth() {
        return this.performanceBandwidth;
    }

    public int getPerformanceConnectionTime() {
        return this.performanceConnectionTime;
    }

    public int getPerformanceLatency() {
        return this.performanceLatency;
    }

    public int getRxBufSize() {
        return this.rxBufSize;
    }

    public boolean getSoKeepAlive() {
        return this.soKeepAlive;
    }

    public boolean getSoLingerOn() {
        return this.soLingerOn;
    }

    public int getSoLingerTime() {
        return this.soLingerTime;
    }

    public boolean getSoReuseAddress() {
        return this.soReuseAddress;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public int getTxBufSize() {
        return this.txBufSize;
    }

    public int getBufferPool() {
        return this.bufferPool;
    }

    public int getBufferPoolSize() {
        return this.bufferPoolSize;
    }

    public int getEventCache() {
        return this.eventCache;
    }

    public int getAppReadBufSize() {
        return this.appReadBufSize;
    }

    public int getAppWriteBufSize() {
        return this.appWriteBufSize;
    }

    public int getProcessorCache() {
        return this.processorCache;
    }

    public long getTimeoutInterval() {
        return this.timeoutInterval;
    }

    public int getDirectBufferPool() {
        return this.bufferPool;
    }

    public void setPerformanceConnectionTime(int n) {
        this.performanceConnectionTime = n;
    }

    public void setTxBufSize(int n) {
        this.txBufSize = n;
    }

    public void setTcpNoDelay(boolean bl) {
        this.tcpNoDelay = bl;
    }

    public void setSoTimeout(int n) {
        this.soTimeout = n;
    }

    public void setSoReuseAddress(boolean bl) {
        this.soReuseAddress = bl;
    }

    public void setSoLingerTime(int n) {
        this.soLingerTime = n;
    }

    public void setSoKeepAlive(boolean bl) {
        this.soKeepAlive = bl;
    }

    public void setRxBufSize(int n) {
        this.rxBufSize = n;
    }

    public void setPerformanceLatency(int n) {
        this.performanceLatency = n;
    }

    public void setPerformanceBandwidth(int n) {
        this.performanceBandwidth = n;
    }

    public void setOoBInline(boolean bl) {
        this.ooBInline = bl;
    }

    public void setDirectBuffer(boolean bl) {
        this.directBuffer = bl;
    }

    public void setDirectSslBuffer(boolean bl) {
        this.directSslBuffer = bl;
    }

    public void setSoLingerOn(boolean bl) {
        this.soLingerOn = bl;
    }

    public void setBufferPool(int n) {
        this.bufferPool = n;
    }

    public void setBufferPoolSize(int n) {
        this.bufferPoolSize = n;
    }

    public void setEventCache(int n) {
        this.eventCache = n;
    }

    public void setAppReadBufSize(int n) {
        this.appReadBufSize = n;
    }

    public void setAppWriteBufSize(int n) {
        this.appWriteBufSize = n;
    }

    public void setProcessorCache(int n) {
        this.processorCache = n;
    }

    public void setTimeoutInterval(long l) {
        this.timeoutInterval = l;
    }

    public void setDirectBufferPool(int n) {
        this.bufferPool = n;
    }

    public int getUnlockTimeout() {
        return this.unlockTimeout;
    }

    public void setUnlockTimeout(int n) {
        if (n > 0) {
            this.unlockTimeout = n;
        } else {
            log.warn((Object)sm.getString("socketProperties.negativeUnlockTimeout"));
        }
    }

    public int getActualBufferPool(int n) {
        int n2;
        if (this.bufferPool != -2) {
            return this.bufferPool;
        }
        if (this.bufferPoolSize == -1) {
            return -1;
        }
        if (this.bufferPoolSize == 0) {
            return 0;
        }
        long l = this.bufferPoolSize;
        if (l == -2L) {
            long l2 = Runtime.getRuntime().maxMemory();
            if (l2 > Integer.MAX_VALUE) {
                l = l2 / 32L;
            } else {
                return 0;
            }
        }
        if ((n2 = this.appReadBufSize + this.appWriteBufSize + n) == 0) {
            return 0;
        }
        long l3 = l / (long)n2;
        if (l3 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l3;
    }

    void setObjectName(ObjectName objectName) {
        this.oname = objectName;
    }

    ObjectName getObjectName() {
        return this.oname;
    }
}

