/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Canvas3D;
import javax.media.j3d.DrawingSurfaceObject;
import javax.media.j3d.NativeDrawable;

class DrawingSurfaceObjectAWT
extends DrawingSurfaceObject {
    private long nativeDS = 0L;
    private long dsi = 0L;
    private boolean doLastUnlock = false;
    private boolean xineramaDisabled = false;
    private long display = 0L;
    private int screenID = 0;
    private static long nativeAWT = 0L;

    private native boolean lockAWT(long var1);

    private native void unlockAWT(long var1);

    private static native void lockGlobal(long var0);

    private static native void unlockGlobal(long var0);

    private native long getDrawingSurfaceAWT(Canvas3D var1, long var2);

    private native long getDrawingSurfaceInfo(long var1);

    private static native void freeResource(long var0, long var2, long var4);

    private native int getDrawingSurfaceWindowIdAWT(Canvas3D var1, long var2, long var4, long var6, int var8, boolean var9);

    DrawingSurfaceObjectAWT(Canvas3D canvas3D, long l, long l2, int n, boolean bl) {
        super(canvas3D);
        nativeAWT = l;
        this.display = l2;
        this.screenID = n;
        this.xineramaDisabled = bl;
    }

    synchronized boolean renderLock() {
        if (this.onScreen) {
            if (this.nativeDS == 0L) {
                return false;
            }
            if (this.lockAWT(this.nativeDS)) {
                this.gotDsiLock = true;
                return true;
            }
            return false;
        }
        this.gotDsiLock = true;
        DrawingSurfaceObjectAWT.lockGlobal(nativeAWT);
        return true;
    }

    synchronized void unLock() {
        if (this.gotDsiLock) {
            if (this.onScreen) {
                if (this.nativeDS != 0L) {
                    this.unlockAWT(this.nativeDS);
                    this.gotDsiLock = false;
                    if (this.doLastUnlock) {
                        this.nativeDS = 0L;
                        this.dsi = 0L;
                        this.doLastUnlock = false;
                    }
                }
            } else {
                DrawingSurfaceObjectAWT.unlockGlobal(nativeAWT);
                this.gotDsiLock = false;
            }
        }
    }

    synchronized void getDrawingSurfaceObjectInfo() {
        if (this.nativeDS != 0L && this.dsi != 0L) {
            DrawingSurfaceObjectAWT.freeResource(nativeAWT, this.nativeDS, this.dsi);
            this.nativeDS = 0L;
            this.dsi = 0L;
        }
        this.nativeDS = this.getDrawingSurfaceAWT(this.canvas, nativeAWT);
        if (this.nativeDS != 0L) {
            this.dsi = this.getDrawingSurfaceInfo(this.nativeDS);
            if (this.dsi != 0L) {
                long l = this.getDrawingSurfaceWindowIdAWT(this.canvas, this.nativeDS, this.dsi, this.display, this.screenID, this.xineramaDisabled);
                this.canvas.drawable = new NativeDrawable(l);
            }
        }
    }

    synchronized void invalidate() {
        if (this.gotDsiLock && this.nativeDS != 0L) {
            this.doLastUnlock = true;
        } else {
            this.nativeDS = 0L;
            this.dsi = 0L;
        }
    }

    static void freeDrawingSurface(Object object) {
        long[] lArray = (long[])object;
        DrawingSurfaceObjectAWT.freeResource(nativeAWT, lArray[0], lArray[1]);
    }

    long getDSI() {
        return this.dsi;
    }

    long getDS() {
        return this.nativeDS;
    }
}

