# rpacket - a low-level OpenPGP packet handling and inspection tool

`rpacket` is a special purpose tool for low-level operations on OpenPGP packets.

It currently supports two operations: `split` and `dump`. Both commands accept both armored and binary OpenPGP data.

## rpacket split

This operation take OpenPGP data and produces a set of files, one per OpenPGP packet.

For example, we can get Linus Torvald's certificate and split it, like this:

```
$ wget "http://pgpkeys.eu/pks/lookup?op=get&search=0xabaf11c65a2970b130abe3c479be3e4300411886" -O torvalds.cert
[..]
$ rpacket split torvalds.cert
```

As a result, a set of files is produced from the original file `torvalds.cert`, like this:

```
$ ls -l
-rw-r--r--. 1 user user 144763 Apr 10 19:51 torvalds.cert
-rw-r--r--. 1 user user    272 Apr 10 19:52 torvalds.cert-000-PublicKey
-rw-r--r--. 1 user user    638 Apr 10 19:52 torvalds.cert-001-Signature
-rw-r--r--. 1 user user    638 Apr 10 19:52 torvalds.cert-002-Signature
-rw-r--r--. 1 user user    639 Apr 10 19:52 torvalds.cert-003-Signature
-rw-r--r--. 1 user user    639 Apr 10 19:52 torvalds.cert-004-Signature
-rw-r--r--. 1 user user     38 Apr 10 19:52 torvalds.cert-005-UserId
-rw-r--r--. 1 user user    337 Apr 10 19:52 torvalds.cert-006-Signature
-rw-r--r--. 1 user user    123 Apr 10 19:52 torvalds.cert-007-Signature
-rw-r--r--. 1 user user    543 Apr 10 19:52 torvalds.cert-008-Signature
-rw-r--r--. 1 user user    570 Apr 10 19:52 torvalds.cert-009-Signature
-rw-r--r--. 1 user user     96 Apr 10 19:52 torvalds.cert-010-Signature
[..]
```

## rpacket dump

This command prints a textual representation of the information in OpenPGP data.

For example, we can use it to inspect the first packet of the split set we produced above:

```
$ rpacket dump torvalds.cert-000-PublicKey
PublicKey(
    PublicKey {
        packet_version: New,
        version: V4,
        algorithm: RSA,
        created_at: 2011-09-20T21:41:38Z,
        expiration: None,
        public_params: PublicParams::RSA {
            n: Mpi(a49fe68e2e6b1aab57a351c5c200e5e43b7c3b7a22ea8d1ff38932f6299df4a7b6f13fc713517bdf33b7f013b127a820a48e2db9c76c6ca0a5c1f00954b302046141423aea63d813ac56627faca656edf0af29338af8182e2a379b0f135b82689fdfd6df4a71c35ab5bcdf67f91eb626667edafd5c920d015dba5f0697f47a82ce8f1c96e08e3b7e2bb3f1e9c41531536f63f54159dbc0d737243bfe21ea07f791659937e5a5abcc2ffe9c5fb7c433345830787f68e5b8f8b6743ec0c08b08b883b2012e55ac28380920ddd44cba0214a222a804ac3b6f6d6af558e9e237b346f7220ba62ce241944851b5663227dcca58ddfdf1677cae630af143c25c03b293),
            e: Mpi(010001),
        },
    },
)
```
