#include "TROOT.h"
#include "TGeoNode.h"
#include "TGeoVolume.h"
#include "TGeoManager.h"
#include "TVirtualGeoPainter.h"

////////////////////////////////////////////////////////////////////////////////

class iterplugin : public TGeoIteratorPlugin {
public:
   iterplugin() : TGeoIteratorPlugin(), fColor(kGreen), fReplica(1) {}
   ~iterplugin() override {}
   // Process current node
   void ProcessNode() override;
   void Select(Int_t replica, Int_t color)
   {
      fReplica = replica;
      fColor = color;
   }

   Int_t fColor;   // Current color
   Int_t fReplica; // replica number (1 to 4)

   ClassDefOverride(iterplugin, 0) // A simple user iterator plugin that changes volume color
};

void iterplugin::ProcessNode()
{
   if (!fIterator)
      return;
   TString path;
   fIterator->GetPath(path);
   if (!path.Contains(Form("REPLICA_%d", fReplica)))
      return;
   Int_t level = fIterator->GetLevel();
   TGeoVolume *vol = fIterator->GetNode(level)->GetVolume();
   vol->SetLineColor(fColor);
}
