# ValidationFailure
<span class="source-link">[[Source]](src/constrained_types/constrained.md#L-0-5)</span>

Collection of validation errors.


```pony
class val ValidationFailure
```

## Constructors

### create
<span class="source-link">[[Source]](src/constrained_types/constrained.md#L-0-11)</span>


```pony
new ref create(
  e: (String val | None val) = reference)
: ValidationFailure ref^
```
#### Parameters

*   e: ([String](builtin-String.md) val | [None](builtin-None.md) val) = reference

#### Returns

* [ValidationFailure](constrained_types-ValidationFailure.md) ref^

---

## Public Functions

### apply
<span class="source-link">[[Source]](src/constrained_types/constrained.md#L-0-16)</span>


Add an error to the failure.


```pony
fun ref apply(
  e: String val)
: None val
```
#### Parameters

*   e: [String](builtin-String.md) val

#### Returns

* [None](builtin-None.md) val

---

### errors
<span class="source-link">[[Source]](src/constrained_types/constrained.md#L-0-22)</span>


Get list of validation errors.


```pony
fun box errors()
: this->Array[String val] ref
```

#### Returns

* this->[Array](builtin-Array.md)\[[String](builtin-String.md) val\] ref

---

