#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.20';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CNTH',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoG5XII',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoR6',
	'Image::ExifTool::Canon::CameraInfoR6m2',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCalib2',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorCoefs2',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData10',
	'Image::ExifTool::Canon::ColorData11',
	'Image::ExifTool::Canon::ColorData12',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorData9',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LevelInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::LogInfo',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::RawBurstInfo',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::Canon::WBInfo',
	'Image::ExifTool::Canon::uuid',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DJI::XMP',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::AFCSettings',
	'Image::ExifTool::FujiFilm::DriveSettings',
	'Image::ExifTool::FujiFilm::FocusSettings',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::FujiFilm::PrioritySettings',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GIF::Extensions',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::ColorSpec',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type5',
	'Image::ExifTool::Kodak::Type6',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::MacOS::MDItem',
	'Image::ExifTool::MacOS::XAttr',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Microsoft::Xtra',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2V0100',
	'Image::ExifTool::Nikon::AFInfo2V0101',
	'Image::ExifTool::Nikon::AFInfo2V0200',
	'Image::ExifTool::Nikon::AFInfo2V0300',
	'Image::ExifTool::Nikon::AFInfo2V0400',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::AutoCaptureInfo',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::BracketingInfoD500',
	'Image::ExifTool::Nikon::BracketingInfoD810',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceB',
	'Image::ExifTool::Nikon::ColorBalanceC',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::ColorBalanceUnknown2',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::DistortionInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0106',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::FlashInfo0300',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::HDRInfo2',
	'Image::ExifTool::Nikon::ISOAutoInfoD810',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::IntervalInfoD6',
	'Image::ExifTool::Nikon::IntervalInfoZ7II',
	'Image::ExifTool::Nikon::JPGInfoD500',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LensData0402',
	'Image::ExifTool::Nikon::LensData0403',
	'Image::ExifTool::Nikon::LensData0800',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MakerNotes0x51',
	'Image::ExifTool::Nikon::MakerNotes0x56',
	'Image::ExifTool::Nikon::MenuSettingsD850',
	'Image::ExifTool::Nikon::MenuSettingsZ6III',
	'Image::ExifTool::Nikon::MenuSettingsZ7II',
	'Image::ExifTool::Nikon::MenuSettingsZ8',
	'Image::ExifTool::Nikon::MenuSettingsZ8v1',
	'Image::ExifTool::Nikon::MenuSettingsZ8v2',
	'Image::ExifTool::Nikon::MenuSettingsZ9',
	'Image::ExifTool::Nikon::MenuSettingsZ9v3',
	'Image::ExifTool::Nikon::MenuSettingsZ9v4',
	'Image::ExifTool::Nikon::MoreSettingsD850',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::MultiExposure2',
	'Image::ExifTool::Nikon::Offset13InfoZ9',
	'Image::ExifTool::Nikon::OrientationInfo',
	'Image::ExifTool::Nikon::OtherInfoD500',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PictureControl3',
	'Image::ExifTool::Nikon::PortraitInfoZ7II',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::RotationInfoD500',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::SeqInfoD6',
	'Image::ExifTool::Nikon::SeqInfoZ9',
	'Image::ExifTool::Nikon::SettingsInfoD810',
	'Image::ExifTool::Nikon::ShootingMenuD500',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::VignetteInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD850',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::NikonCustom::SettingsZ6III',
	'Image::ExifTool::NikonCustom::SettingsZ8',
	'Image::ExifTool::NikonCustom::SettingsZ9',
	'Image::ExifTool::NikonCustom::SettingsZ9v4',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::DSA',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::FocusInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Leica9',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::Panasonic::TimeInfo',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CAFPointInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::LevelInfoK3III',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::AudioKeys',
	'Image::ExifTool::QuickTime::ItemList',
	'Image::ExifTool::QuickTime::ItemPropCont',
	'Image::ExifTool::QuickTime::Keys',
	'Image::ExifTool::QuickTime::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::QuickTime::UserData',
	'Image::ExifTool::QuickTime::VideoKeys',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Reconyx::Type2',
	'Image::ExifTool::Reconyx::Type3',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::OrientationInfo',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sigma::WBSettings',
	'Image::ExifTool::Sigma::WBSettings2',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::HiddenInfo',
	'Image::ExifTool::Sony::ISOInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MeterInfo9',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::SR2SubIFD',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag2010i',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050a',
	'Image::ExifTool::Sony::Tag9050b',
	'Image::ExifTool::Sony::Tag9050c',
	'Image::ExifTool::Sony::Tag9050d',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9404c',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag9406b',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::ACDSeeRegions',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Device',
	'Image::ExifTool::XMP::ExifTool',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GAudio',
	'Image::ExifTool::XMP::GCamera',
	'Image::ExifTool::XMP::GContainer',
	'Image::ExifTool::XMP::GCreations',
	'Image::ExifTool::XMP::GDepth',
	'Image::ExifTool::XMP::GFocus',
	'Image::ExifTool::XMP::GImage',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GSpherical',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::HDRGainMap',
	'Image::ExifTool::XMP::LImage',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apdi',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::crd',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::hdr',
	'Image::ExifTool::XMP::hdrgm',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::panorama',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::pdfx',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 115 => 0x69 },
	'about' => { 552 => 'about' },
	'aboutcvterm' => { 542 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 542 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 542 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 542 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 542 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'absolutealtitude' => { 122 => 'AbsoluteAltitude' },
	'abspeakaudiofilepath' => { 558 => 'absPeakAudioFilePath' },
	'academicfield' => { 548 => 'academicField' },
	'acceleration' => { 125 => 0x9404, 535 => 'Acceleration' },
	'accelerationtracking' => { 90 => 0x518 },
	'accelerationvector' => { 1 => 0x8 },
	'accelerometer' => { 432 => 0x3 },
	'accelerometerdata' => { 421 => 'vrot' },
	'accelerometerx' => { 358 => 0x8d },
	'accelerometery' => { 358 => 0x8e },
	'accelerometerz' => { 358 => 0x8c },
	'accessoryserialnumber' => { 358 => 0x54 },
	'accessorytype' => { 358 => 0x53 },
	'acdseeregion' => { 501 => [\'Regions','RegionsRegionList'] },
	'acdseeregionalgarea' => { 501 => [\'Regions','RegionsRegionListALGArea'] },
	'acdseeregionalgareah' => { 501 => [\'Regions','RegionsRegionListALGAreaH'] },
	'acdseeregionalgareaw' => { 501 => [\'Regions','RegionsRegionListALGAreaW'] },
	'acdseeregionalgareax' => { 501 => [\'Regions','RegionsRegionListALGAreaX'] },
	'acdseeregionalgareay' => { 501 => [\'Regions','RegionsRegionListALGAreaY'] },
	'acdseeregionappliedtodimensions' => { 501 => [\'Regions','RegionsAppliedToDimensions'] },
	'acdseeregionappliedtodimensionsh' => { 501 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'acdseeregionappliedtodimensionsunit' => { 501 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'acdseeregionappliedtodimensionsw' => { 501 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'acdseeregiondlyarea' => { 501 => [\'Regions','RegionsRegionListDLYArea'] },
	'acdseeregiondlyareah' => { 501 => [\'Regions','RegionsRegionListDLYAreaH'] },
	'acdseeregiondlyareaw' => { 501 => [\'Regions','RegionsRegionListDLYAreaW'] },
	'acdseeregiondlyareax' => { 501 => [\'Regions','RegionsRegionListDLYAreaX'] },
	'acdseeregiondlyareay' => { 501 => [\'Regions','RegionsRegionListDLYAreaY'] },
	'acdseeregionname' => { 501 => [\'Regions','RegionsRegionListName'] },
	'acdseeregionnameassigntype' => { 501 => [\'Regions','RegionsRegionListNameAssignType'] },
	'acdseeregiontype' => { 501 => [\'Regions','RegionsRegionListType'] },
	'actionadvised' => { 138 => 0x2a },
	'activearea' => { 125 => 0xc68d },
	'actived-lighting' => { 246 => 0x22, 304 => 0x24 },
	'actived-lightingmode' => { 304 => 0x25 },
	'adaptervoltage' => { 145 => 0x407 },
	'addaspectratioinfo' => { 90 => 0x80e },
	'addiptcinformation' => { 90 => 0x815 },
	'additionalmodelinformation' => { 542 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 90 => 0x80f, 91 => 0x11, 92 => 0x13, 95 => 0x14 },
	'address' => { 168 => 'Address' },
	'adjustmentmode' => { 439 => 0x15 },
	'adlbracketingstep' => { 208 => 0x17 },
	'adlbracketingtype' => { 208 => 0x18 },
	'adobe' => { 126 => 'Adobe' },
	'adultcontentwarning' => { 344 => 'AdultContentWarning', 551 => 'adultContentWarning' },
	'advancedfilter' => { 133 => 0x1201 },
	'advancedraw' => { 306 => 0x76a43203 },
	'advancedscenetype' => { 358 => 0x3d },
	'advisory' => { 556 => 'Advisory' },
	'ae_iso' => { 366 => 0x2, 367 => 0x4, 368 => 0x12 },
	'aeaperture' => { 366 => 0x1, 367 => 0x3, 368 => 0x11 },
	'aeaperturesteps' => { 366 => 0x8, 367 => 0xb },
	'aeaverage' => { 1 => 0x6 },
	'aebautocancel' => { 90 => 0x104 },
	'aebbracketvalue' => { 82 => 0x11 },
	'aebracketingsteps' => { 208 => 0xf, 209 => 0xf, 286 => 0x174c },
	'aebsequence' => { 90 => 0x105 },
	'aebsequenceautocancel' => { 88 => 0x9, 89 => 0x9, 91 => 0x8, 92 => 0x9, 95 => 0x9, 96 => 0x7 },
	'aebshotcount' => { 90 => 0x106 },
	'aebxv' => { 366 => 0x4, 367 => 0x6 },
	'aeerror' => { 367 => 0x8 },
	'aeexposuretime' => { 366 => 0x0, 367 => 0x2, 368 => 0x10 },
	'aelbutton' => { 191 => 0x45 },
	'aelexposureindicator' => { 191 => 0x51 },
	'aelock' => { 191 => 0x5b, 315 => '4.2', 324 => '4.2', 334 => 0x201, 395 => 0x48, 449 => 0x40, 450 => 0x40, 451 => [0x86,0x286] },
	'aelockbutton' => { 313 => '16.1', 315 => '4.1', 318 => '15.1', 319 => '16.1', 320 => '16.1', 322 => '30.1', 323 => '16.1', 324 => '4.1', 326 => '17.1', 328 => '17.1' },
	'aelockbuttonplusdials' => { 313 => '16.2', 322 => '32.1', 326 => '44.1' },
	'aelockformb-d80' => { 328 => '3.1' },
	'aelockmetermodeafterfocus' => { 90 => 0x114 },
	'aematrix' => { 1 => 0x2 },
	'aemaxaperture' => { 366 => 0x9, 367 => 0x10, 368 => 0x1c },
	'aemaxaperture2' => { 366 => 0xa, 367 => 0x11, 368 => 0x1d },
	'aemeteringmode' => { 366 => 0xc },
	'aemeteringmode2' => { 366 => '13.1' },
	'aemeteringsegments' => { 194 => 0x628, 395 => 0x209 },
	'aemicroadjustment' => { 90 => 0x110 },
	'aeminaperture' => { 366 => 0xb, 367 => 0x12, 368 => 0x1e },
	'aeminexposuretime' => { 366 => 0x5, 367 => 0x13, 368 => 0x1f },
	'aeprogrammode' => { 366 => 0x6 },
	'aeprojectlink' => { 529 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 529 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 529 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 529 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 529 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 529 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 37 => 0x21 },
	'aestable' => { 1 => 0x4 },
	'aestheticscore' => { 347 => 'aesthetic_score' },
	'aetarget' => { 1 => 0x5 },
	'aewhitebalance' => { 366 => 0xd },
	'aexv' => { 366 => 0x3, 367 => 0x5 },
	'af-assistilluminator' => { 329 => 0x1a, 330 => 0x19, 331 => 0x19, 332 => 0x19 },
	'af-cfocusdisplay' => { 330 => 0x234, 331 => 0x234, 332 => 0x24c },
	'af-cpriority' => { 134 => '0.2' },
	'af-cpriorityselection' => { 313 => '1.1', 314 => '1.1', 316 => '1.1', 317 => '1.1', 319 => '0.1', 320 => '0.1', 321 => '0.1', 322 => '1.1', 323 => '0.1', 326 => '1.1', 327 => '1.1', 329 => 0x3, 330 => 0x3, 331 => 0x3, 332 => 0x3 },
	'af-csetting' => { 130 => 0x0 },
	'af-cspeedtrackingsensitivity' => { 130 => '0.2' },
	'af-ctrackingsensitivity' => { 130 => '0.1' },
	'af-czoneareaswitching' => { 130 => '0.3' },
	'af-onbutton' => { 316 => '70.1', 317 => '70.1', 327 => '70.1' },
	'af-onformb-d10' => { 313 => '3.3', 322 => '3.2' },
	'af-onformb-d11' => { 323 => '2.2' },
	'af-onformb-d12' => { 326 => '50.1' },
	'af-onoutoffocusrelease' => { 329 => 0x10, 330 => 0x10, 331 => 0x10, 332 => 0x10 },
	'af-spriority' => { 134 => '0.1' },
	'af-spriorityselection' => { 313 => '1.2', 314 => '1.2', 316 => '1.2', 317 => '1.2', 321 => '0.2', 322 => '1.2', 323 => '0.2', 326 => '1.2', 327 => '1.2', 329 => 0x5, 330 => 0x5, 331 => 0x5, 332 => 0x5 },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 313 => '2.1', 314 => '2.1', 316 => '78.3', 317 => '78.3', 322 => '2.1', 326 => '2.1', 327 => '78.3', 329 => 0xf, 330 => 0xf, 331 => 0xf, 332 => 0xf },
	'afadjustment' => { 395 => 0x72, 404 => 0x267 },
	'afandmeteringbuttons' => { 90 => 0x701 },
	'afaperture' => { 239 => 0x5, 240 => 0x5, 244 => 0x5 },
	'afareaheight' => { 200 => 0x1a, 201 => 0x50, 203 => 0x34, 204 => 0x48 },
	'afareaillumination' => { 191 => 0x4b, 324 => '15.3' },
	'afareainitialheight' => { 261 => 0xbeb },
	'afareainitialwidth' => { 261 => 0xbea },
	'afareainitialxposition' => { 261 => 0xbe8 },
	'afareainitialyposition' => { 261 => 0xbe9 },
	'afareamode' => { 132 => '0.3', 187 => 0x33, 191 => 0xe, 199 => 0x0, 200 => 0x5, 201 => 0x5, 202 => 0x5, 203 => 0x5, 204 => 0x5, 250 => 0x340, 252 => 0x224, 255 => 0x210, 256 => 0x224, 257 => 0x224, 358 => 0xf, 429 => 0x1205, 442 => [0xa,0x3a], 449 => 0x11, 450 => 0x10, 451 => 0x24, 463 => 0xb043, 489 => 0x17 },
	'afareamodesetting' => { 315 => '11.1', 318 => '0.1', 324 => '16.1', 328 => '2.1', 463 => 0x201c },
	'afareapointsize' => { 132 => '0.4' },
	'afareas' => { 334 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 90 => 0x51b },
	'afareasize' => { 358 => 0xde },
	'afareawidth' => { 200 => 0x18, 201 => 0x4e, 203 => 0x32, 204 => 0x46 },
	'afareaxposition' => { 200 => 0x14, 201 => 0x4a, 203 => 0x2e, 204 => 0x42, 429 => 0x1203 },
	'afareaxposition1' => { 429 => 0x1201 },
	'afareayposition' => { 200 => 0x16, 201 => 0x4c, 203 => 0x30, 204 => 0x44, 429 => 0x1204 },
	'afareayposition1' => { 429 => 0x1202 },
	'afareazonesize' => { 132 => '0.5' },
	'afassist' => { 88 => 0x5, 96 => 0x5, 191 => 0x48, 313 => '2.5', 315 => '0.2', 318 => '0.2', 319 => '1.1', 320 => '1.1', 321 => '1.3', 322 => '2.4', 323 => '1.3', 324 => '0.2', 326 => '2.4', 328 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 90 => 0x50e, 91 => 0x4, 92 => 0x5, 93 => 0x4, 94 => 0x4, 95 => 0x5 },
	'afassistlamp' => { 358 => 0x31 },
	'afbuttonpressed' => { 451 => [0x83,0x283] },
	'afconfidence' => { 1 => 0x3d },
	'afconfigtool' => { 2 => 0x1 },
	'afcoordinatesavailable' => { 203 => 0x7, 204 => 0x7 },
	'afdefocus' => { 369 => 0x6 },
	'afdetectionmethod' => { 200 => 0x4, 201 => 0x4, 203 => 0x4, 204 => 0x4 },
	'afduringliveview' => { 90 => 0x511 },
	'affinea' => { 521 => 'AffineA' },
	'affineb' => { 521 => 'AffineB' },
	'affinec' => { 521 => 'AffineC' },
	'affined' => { 521 => 'AffineD' },
	'affinetune' => { 205 => 0x0, 253 => 0x6b0, 254 => 0x6c0, 255 => 0x5b0, 256 => 0x5e0, 257 => 0x5f8, 334 => 0x306 },
	'affinetuneadj' => { 205 => 0x2, 279 => 0x2d1, 280 => 0x2dc, 334 => 0x307 },
	'affinetuneadjtele' => { 205 => 0x3 },
	'affinetuneindex' => { 205 => 0x1 },
	'affinex' => { 521 => 'AffineX' },
	'affiney' => { 521 => 'AffineY' },
	'afhold' => { 369 => 0x1fd },
	'afilluminator' => { 449 => 0x29, 463 => 0xb044 },
	'afimageheight' => { 200 => 0x12, 201 => 0x48, 203 => 0x2c, 204 => 0x40 },
	'afimagewidth' => { 200 => 0x10, 201 => 0x46, 203 => 0x2a, 204 => 0x3e },
	'afintegrationtime' => { 369 => 0x7 },
	'afmeasureddepth' => { 1 => 0x38 },
	'afmicroadj' => { 442 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 446 => 0x131 },
	'afmicroadjregisteredlenses' => { 446 => '305.1' },
	'afmicroadjustment' => { 90 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 446 => 0x130 },
	'afmode' => { 119 => 0x3009, 133 => 0x1022, 187 => 0x16, 439 => 0x5 },
	'afmoderestrictions' => { 314 => '50.3', 316 => '48.3', 317 => '48.3', 326 => '48.3', 327 => '48.3' },
	'afonaelockbuttonswitch' => { 90 => 0x702 },
	'afonbutton' => { 313 => '3.1', 314 => '47.1', 329 => 0x87, 330 => 0x83, 331 => 0x83, 332 => 0x83 },
	'afperformance' => { 1 => 0x23 },
	'afpoint' => { 37 => 0x13, 118 => 0x18, 187 => 0x15, 199 => 0x1, 337 => 0x308, 439 => 0x1f, 442 => [0x37,0x7], 446 => 0x19, 447 => 0x18, 448 => [0x18,0x20] },
	'afpointactivationarea' => { 89 => 0x11, 95 => 0x11 },
	'afpointareaexpansion' => { 90 => 0x508 },
	'afpointatshutterrelease' => { 442 => [0x39,0x9] },
	'afpointautoselection' => { 90 => 0x50b },
	'afpointbrightness' => { 90 => 0x50d, 313 => '2.4', 314 => '46.5', 316 => '2.2', 317 => '2.2', 326 => '2.3', 327 => '2.2' },
	'afpointdetails' => { 337 => 0x31b },
	'afpointdisplayduringfocus' => { 2 => 0x10, 90 => 0x50c },
	'afpointillumination' => { 89 => 0xa, 313 => '2.3', 314 => '46.2', 316 => '47.2', 317 => '47.2', 321 => '1.2', 322 => '2.3', 323 => '1.2', 326 => '47.2', 327 => '47.2', 328 => '2.4' },
	'afpointinfocus' => { 442 => [0x38,0x8] },
	'afpointmode' => { 375 => 0x3 },
	'afpointposition' => { 119 => 0x2021, 358 => 0x4d },
	'afpointregistration' => { 88 => 0x7 },
	'afpoints' => { 190 => 0x10 },
	'afpointsel' => { 329 => 0xb, 330 => 0xb, 331 => 0xb, 332 => 0xb },
	'afpointselected' => { 191 => 0xd, 334 => 0x305, 395 => 0xe, 446 => 0x15, 447 => 0x14, 448 => [0x14,0x1c], 463 => 0x201e },
	'afpointselected2' => { 375 => 0x4 },
	'afpointselection' => { 89 => 0xb, 313 => '1.3', 314 => '1.3', 322 => '1.3', 326 => '1.3', 327 => '1.3' },
	'afpointselectionmethod' => { 90 => 0x50f, 91 => 0xc, 92 => 0xd, 95 => 0xd },
	'afpointsetting' => { 449 => 0x12, 450 => 0x11 },
	'afpointsinfocus' => { 82 => 0xe, 199 => 0x2, 201 => 0x30, 369 => 0xb, 395 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 19 => 0x38 },
	'afpointspotmetering' => { 89 => 0xd },
	'afpointsselected' => { 200 => 0x1c, 201 => 0x1c, 369 => 0x12a, 498 => 0x4 },
	'afpointsunknown' => { 369 => 0x18f },
	'afpointsunknown1' => { 369 => 0x0 },
	'afpointsunknown2' => { 369 => 0x2 },
	'afpointsused' => { 200 => 0x8, 201 => [0x1c,0x8], 202 => 0x8, 203 => 0xa, 204 => 0xa, 442 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpointvalues' => { 369 => 0x14 },
	'afpredictor' => { 369 => 0x4 },
	'afresponse' => { 246 => 0xad },
	'afresult' => { 339 => 0x1038 },
	'afsearch' => { 334 => 0x303 },
	'afsensoractive' => { 187 => 0x1 },
	'afstable' => { 1 => 0x7 },
	'afstatus' => { 429 => 0x1200 },
	'afstatus_00_b4' => { 445 => 0x0 },
	'afstatus_01_c4' => { 445 => 0x2 },
	'afstatus_02_d4' => { 445 => 0x4 },
	'afstatus_03_e4' => { 445 => 0x6 },
	'afstatus_04_f4' => { 445 => 0x8 },
	'afstatus_05_g4' => { 445 => 0xa },
	'afstatus_06_h4' => { 445 => 0xc },
	'afstatus_07_b3' => { 445 => 0xe },
	'afstatus_08_c3' => { 445 => 0x10 },
	'afstatus_09_d3' => { 445 => 0x12 },
	'afstatus_10_e3' => { 445 => 0x14 },
	'afstatus_11_f3' => { 445 => 0x16 },
	'afstatus_12_g3' => { 445 => 0x18 },
	'afstatus_13_h3' => { 445 => 0x1a },
	'afstatus_14_b2' => { 445 => 0x1c },
	'afstatus_15_c2' => { 445 => 0x1e },
	'afstatus_16_d2' => { 445 => 0x20 },
	'afstatus_17_e2' => { 445 => 0x22 },
	'afstatus_18_f2' => { 445 => 0x24 },
	'afstatus_19_g2' => { 445 => 0x26 },
	'afstatus_20_h2' => { 445 => 0x28 },
	'afstatus_21_c1' => { 445 => 0x2a },
	'afstatus_22_d1' => { 445 => 0x2c },
	'afstatus_23_e1' => { 445 => 0x2e },
	'afstatus_24_f1' => { 445 => 0x30 },
	'afstatus_25_g1' => { 445 => 0x32 },
	'afstatus_26_a7_vertical' => { 445 => 0x34 },
	'afstatus_27_a6_vertical' => { 445 => 0x36 },
	'afstatus_28_a5_vertical' => { 445 => 0x38 },
	'afstatus_29_c7_vertical' => { 445 => 0x3a },
	'afstatus_30_c6_vertical' => { 445 => 0x3c },
	'afstatus_31_c5_vertical' => { 445 => 0x3e },
	'afstatus_32_e7_vertical' => { 445 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 445 => 0x42 },
	'afstatus_34_e5_vertical' => { 445 => 0x44 },
	'afstatus_35_g7_vertical' => { 445 => 0x46 },
	'afstatus_36_g6_vertical' => { 445 => 0x48 },
	'afstatus_37_g5_vertical' => { 445 => 0x4a },
	'afstatus_38_i7_vertical' => { 445 => 0x4c },
	'afstatus_39_i6_vertical' => { 445 => 0x4e },
	'afstatus_40_i5_vertical' => { 445 => 0x50 },
	'afstatus_41_a7' => { 445 => 0x52 },
	'afstatus_42_b7' => { 445 => 0x54 },
	'afstatus_43_c7' => { 445 => 0x56 },
	'afstatus_44_d7' => { 445 => 0x58 },
	'afstatus_45_e7' => { 445 => 0x5a },
	'afstatus_46_f7' => { 445 => 0x5c },
	'afstatus_47_g7' => { 445 => 0x5e },
	'afstatus_48_h7' => { 445 => 0x60 },
	'afstatus_49_i7' => { 445 => 0x62 },
	'afstatus_50_a6' => { 445 => 0x64 },
	'afstatus_51_b6' => { 445 => 0x66 },
	'afstatus_52_c6' => { 445 => 0x68 },
	'afstatus_53_d6' => { 445 => 0x6a },
	'afstatus_54_e6_center' => { 445 => 0x6c },
	'afstatus_55_f6' => { 445 => 0x6e },
	'afstatus_56_g6' => { 445 => 0x70 },
	'afstatus_57_h6' => { 445 => 0x72 },
	'afstatus_58_i6' => { 445 => 0x74 },
	'afstatus_59_a5' => { 445 => 0x76 },
	'afstatus_60_b5' => { 445 => 0x78 },
	'afstatus_61_c5' => { 445 => 0x7a },
	'afstatus_62_d5' => { 445 => 0x7c },
	'afstatus_63_e5' => { 445 => 0x7e },
	'afstatus_64_f5' => { 445 => 0x80 },
	'afstatus_65_g5' => { 445 => 0x82 },
	'afstatus_66_h5' => { 445 => 0x84 },
	'afstatus_67_i5' => { 445 => 0x86 },
	'afstatus_68_c11' => { 445 => 0x88 },
	'afstatus_69_d11' => { 445 => 0x8a },
	'afstatus_70_e11' => { 445 => 0x8c },
	'afstatus_71_f11' => { 445 => 0x8e },
	'afstatus_72_g11' => { 445 => 0x90 },
	'afstatus_73_b10' => { 445 => 0x92 },
	'afstatus_74_c10' => { 445 => 0x94 },
	'afstatus_75_d10' => { 445 => 0x96 },
	'afstatus_76_e10' => { 445 => 0x98 },
	'afstatus_77_f10' => { 445 => 0x9a },
	'afstatus_78_g10' => { 445 => 0x9c },
	'afstatus_79_h10' => { 445 => 0x9e },
	'afstatus_80_b9' => { 445 => 0xa0 },
	'afstatus_81_c9' => { 445 => 0xa2 },
	'afstatus_82_d9' => { 445 => 0xa4 },
	'afstatus_83_e9' => { 445 => 0xa6 },
	'afstatus_84_f9' => { 445 => 0xa8 },
	'afstatus_85_g9' => { 445 => 0xaa },
	'afstatus_86_h9' => { 445 => 0xac },
	'afstatus_87_b8' => { 445 => 0xae },
	'afstatus_88_c8' => { 445 => 0xb0 },
	'afstatus_89_d8' => { 445 => 0xb2 },
	'afstatus_90_e8' => { 445 => 0xb4 },
	'afstatus_91_f8' => { 445 => 0xb6 },
	'afstatus_92_g8' => { 445 => 0xb8 },
	'afstatus_93_h8' => { 445 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 445 => 0xbc },
	'afstatusactivesensor' => { 187 => 0x2, 442 => [0x4,0x3b], 446 => 0x1e, 447 => 0x1b, 448 => [0x1b,0x21] },
	'afstatusbottom' => { 187 => 0x8, 446 => 0x2a, 447 => 0x21, 448 => 0x21 },
	'afstatusbottom-left' => { 187 => 0x12, 447 => 0x2b, 448 => 0x2b },
	'afstatusbottom-right' => { 187 => 0x6, 447 => 0x1f, 448 => 0x1f },
	'afstatusbottomassist-left' => { 446 => 0x28 },
	'afstatusbottomassist-right' => { 446 => 0x2c },
	'afstatusbottomhorizontal' => { 443 => 0x10, 444 => 0x1c },
	'afstatusbottomvertical' => { 443 => 0x16, 444 => 0x26 },
	'afstatuscenter-10' => { 446 => 0x34 },
	'afstatuscenter-11' => { 446 => 0x36 },
	'afstatuscenter-12' => { 446 => 0x38 },
	'afstatuscenter-14' => { 446 => 0x3c },
	'afstatuscenter-7' => { 446 => 0x2e },
	'afstatuscenter-9' => { 446 => 0x32 },
	'afstatuscenter-horizontal' => { 446 => 0x30 },
	'afstatuscenter-vertical' => { 446 => 0x3a },
	'afstatuscenterf2-8' => { 446 => 0x4c },
	'afstatuscenterhorizontal' => { 187 => 0x2f, 443 => 0xc, 444 => 0x18, 447 => 0x2f, 448 => 0x2f },
	'afstatuscentervertical' => { 187 => 0xc, 443 => 0x14, 444 => 0x22, 447 => 0x25, 448 => 0x25 },
	'afstatusfarleft' => { 443 => 0x6, 446 => 0x26 },
	'afstatusfarlefthorizontal' => { 444 => 0x4 },
	'afstatusfarleftvertical' => { 444 => 0x12 },
	'afstatusfarright' => { 443 => 0x18, 446 => 0x44 },
	'afstatusfarrighthorizontal' => { 444 => 0x2c },
	'afstatusfarrightvertical' => { 444 => 0x34 },
	'afstatusleft' => { 187 => 0x2d, 443 => 0x2, 446 => 0x22, 447 => 0x2d, 448 => 0x2d },
	'afstatuslefthorizontal' => { 444 => 0x6 },
	'afstatusleftvertical' => { 444 => 0xe },
	'afstatuslower-left' => { 443 => 0x4, 446 => 0x24 },
	'afstatuslower-lefthorizontal' => { 444 => 0xa },
	'afstatuslower-leftvertical' => { 444 => 0x10 },
	'afstatuslower-middle' => { 443 => 0x22, 444 => 0x24 },
	'afstatuslower-right' => { 443 => 0x1e, 446 => 0x4a },
	'afstatuslower-righthorizontal' => { 444 => 0x32 },
	'afstatuslower-rightvertical' => { 444 => 0x3a },
	'afstatuslowerfarleft' => { 444 => 0x8 },
	'afstatuslowerfarright' => { 444 => 0x30 },
	'afstatusmiddlehorizontal' => { 187 => 0xa, 447 => 0x23, 448 => 0x23 },
	'afstatusnearleft' => { 443 => 0xe, 444 => 0x1a },
	'afstatusnearright' => { 443 => 0xa, 444 => 0x16 },
	'afstatusright' => { 187 => 0x31, 443 => 0x1c, 446 => 0x48, 447 => 0x31, 448 => 0x31 },
	'afstatusrighthorizontal' => { 444 => 0x2e },
	'afstatusrightvertical' => { 444 => 0x38 },
	'afstatustop' => { 187 => 0xe, 446 => 0x40, 447 => 0x27, 448 => 0x27 },
	'afstatustop-left' => { 187 => 0x10, 447 => 0x29, 448 => 0x29 },
	'afstatustop-right' => { 187 => 0x4, 447 => 0x1d, 448 => 0x1d },
	'afstatustopassist-left' => { 446 => 0x3e },
	'afstatustopassist-right' => { 446 => 0x42 },
	'afstatustophorizontal' => { 443 => 0x8, 444 => 0x14 },
	'afstatustopvertical' => { 443 => 0x12, 444 => 0x1e },
	'afstatusupper-left' => { 443 => 0x0, 446 => 0x20 },
	'afstatusupper-lefthorizontal' => { 444 => 0x2 },
	'afstatusupper-leftvertical' => { 444 => 0xc },
	'afstatusupper-middle' => { 443 => 0x20, 444 => 0x20 },
	'afstatusupper-right' => { 443 => 0x1a, 446 => 0x46 },
	'afstatusupper-righthorizontal' => { 444 => 0x2a },
	'afstatusupper-rightvertical' => { 444 => 0x36 },
	'afstatusupperfarleft' => { 444 => 0x0 },
	'afstatusupperfarright' => { 444 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'afsubjectdetection' => { 358 => 0xe9 },
	'aftracking' => { 463 => 0x2021 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 442 => 0x2 },
	'afwithshutter' => { 449 => 0x2a },
	'aggregateissuenumber' => { 548 => 'aggregateIssueNumber' },
	'aggregationtype' => { 548 => 'aggregationType' },
	'agreement' => { 551 => 'agreement' },
	'ah2greeninterpolationthreshold' => { 145 => 0xe4e },
	'airplanemode' => { 250 => 0x9c0, 253 => 0x722, 254 => 0x732, 255 => 0x624, 256 => 0x654, 257 => 0x6bc },
	'aiservocontinuousshooting' => { 89 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 90 => 0x519 },
	'aiservoimagepriority' => { 90 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 90 => 0x51a },
	'aiservotrackingmethod' => { 90 => 0x504 },
	'aiservotrackingsensitivity' => { 89 => 0x14, 90 => 0x502 },
	'aisubjecttrackingmode' => { 334 => 0x309 },
	'album' => { 413 => ['albm',"\xa9alb"], 415 => 'album', 421 => ['albm',"\xa9alb"], 558 => 'album' },
	'albumartist' => { 186 => 'WM/AlbumArtist', 413 => 'aART', 421 => 'albr' },
	'albumcoverurl' => { 186 => 'WM/AlbumCoverURL' },
	'albumid' => { 413 => 'plID' },
	'albumtitle' => { 186 => 'WM/AlbumTitle' },
	'alreadyapplied' => { 528 => 'AlreadyApplied', 530 => 'AlreadyApplied' },
	'alternatetitle' => { 548 => 'alternateTitle' },
	'alternatetitlea-lang' => { 548 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 548 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 548 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 207 => 0x6 },
	'alttapename' => { 558 => 'altTapeName' },
	'alttextaccessibility' => { 541 => 'AltTextAccessibility' },
	'alttimecode' => { 558 => 'altTimecode' },
	'alttimecodetimeformat' => { 558 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 558 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 558 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambientinfrared' => { 425 => 0x5c },
	'ambientlight' => { 425 => 0x5e },
	'ambienttemperature' => { 125 => 0x9400, 423 => 0x14, 424 => 0x46, 425 => 0x50, 489 => 0x4, 535 => 'Temperature' },
	'ambienttemperaturefahrenheit' => { 423 => 0x13, 424 => 0x44, 425 => 0x4e },
	'analogbalance' => { 125 => 0xc627 },
	'analogcaptureiso' => { 145 => 0x89e },
	'analogisotable' => { 145 => 0x89d },
	'androidcapturefps' => { 415 => 'com.android.capture.fps' },
	'androidmake' => { 415 => 'com.android.manufacturer' },
	'androidmodel' => { 415 => 'com.android.model' },
	'androidversion' => { 415 => 'com.android.version' },
	'angleadj' => { 109 => 0x10003, 115 => 0x8b },
	'angleinforoll' => { 524 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 524 => 'AngleInfoYaw' },
	'anti-blur' => { 463 => 0xb04b },
	'antialiasstrength' => { 125 => 0xc632 },
	'antiflicker' => { 61 => 0x20 },
	'aperturelock' => { 314 => '38.2', 316 => '38.2', 317 => '38.2', 326 => '38.2', 327 => '38.2', 329 => 0xbc, 330 => 0xb8, 331 => 0xb8, 332 => 0xb8 },
	'aperturemode' => { 421 => 'apmd' },
	'aperturerange' => { 90 => 0x10d },
	'apertureringuse' => { 375 => '1.4' },
	'aperturesetting' => { 191 => 0x7, 449 => 0x30, 450 => 0x29, 451 => 0x1 },
	'aperturevalue' => { 99 => 0x2, 125 => 0x9202, 339 => 0x1002, 404 => 0x401, 534 => 'ApertureValue' },
	'appinfo' => { 504 => 'AppInfo' },
	'appinfoapplication' => { 504 => [\'AppInfo','AppInfoApplication'] },
	'appinfoitemuri' => { 504 => [\'AppInfo','AppInfoItemURI'] },
	'appinfoversion' => { 504 => [\'AppInfo','AppInfoVersion'] },
	'apple_0x004e' => { 1 => 0x4e },
	'apple_0x004f' => { 1 => 0x4f },
	'apple_0x0054' => { 1 => 0x54 },
	'apple_0x005a' => { 1 => 0x5a },
	'applekeywords' => { 343 => 'AAPL:Keywords' },
	'applephotosvariationidentifier' => { 415 => 'apple.photos.variation-identifier' },
	'applestoreaccount' => { 413 => 'apID' },
	'applestoreaccounttype' => { 413 => 'akID' },
	'applestorecatalogid' => { 413 => 'cnID' },
	'applestorecountry' => { 413 => 'sfID' },
	'applicationkeystring' => { 145 => 0x400 },
	'applicationnotes' => { 125 => 0x2bc, 363 => 0x2bc },
	'applicationrecordversion' => { 138 => 0x0 },
	'applyautomatically' => { 348 => 'ApplyAutomatically' },
	'applyshootingmeteringmode' => { 90 => 0x10e },
	'approved' => { 536 => 'Approved' },
	'approvedby' => { 536 => 'ApprovedBy' },
	'approximatefnumber' => { 353 => 0x313, 360 => 0x3406 },
	'approximatefocusdistance' => { 525 => 'ApproximateFocusDistance' },
	'appversion' => { 540 => 'AppVersion' },
	'aps-csizecapture' => { 482 => 0x114, 483 => [0x114,0x1eb,0x1ee,0x21a,0x21c] },
	'aquahsl' => { 109 => 0x20914 },
	'armidentifier' => { 139 => 0x78 },
	'armversion' => { 139 => 0x7a },
	'arranger' => { 413 => "\xa9arg", 421 => "\xa9arg" },
	'arrangerkeywords' => { 421 => "\xa9ark" },
	'artdirector' => { 413 => "\xa9ard" },
	'artfilter' => { 334 => 0x529 },
	'artfiltereffect' => { 334 => 0x52f },
	'artist' => { 125 => 0x13b, 347 => 'Artist', 363 => 0x13b, 395 => 0x22e, 413 => "\xa9ART", 415 => 'artist', 421 => "\xa9ART", 554 => 'Artist', 558 => 'artist' },
	'artistid' => { 413 => 'atID' },
	'artmode' => { 119 => 0x301b },
	'artmodeparameters' => { 119 => 0x310b },
	'artwork' => { 415 => 'artwork' },
	'artworkcircadatecreated' => { 542 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontentdescription' => { 542 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworkcontributiondescription' => { 542 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 542 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 542 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 542 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 542 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 542 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 542 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 542 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 542 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 542 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 542 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworksource' => { 542 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 542 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 542 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 542 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 542 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 338 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 338 => 0x1112, 395 => 0x80, 449 => 0x55, 450 => 0x55, 451 => 0xa, 476 => [0x192c,0x1a88], 477 => 0x192c, 478 => 0x1958, 479 => 0x192c, 480 => 0x188c },
	'assetid' => { 516 => 'AssetID' },
	'asshoticcprofile' => { 125 => 0xc68f },
	'asshotneutral' => { 125 => 0xc628 },
	'asshotpreprofilematrix' => { 125 => 0xc690 },
	'asshotprofilename' => { 125 => 0xc6f6 },
	'asshotwhitexy' => { 125 => 0xc629 },
	'assignbktbutton' => { 313 => '4.2', 314 => '16.1', 316 => '16.1', 317 => '16.1', 326 => '16.1', 327 => '16.1' },
	'assignfuncbutton' => { 90 => 0x70b },
	'assignmb-d17af-onbutton' => { 317 => '79.1' },
	'assignmb-d17funcbutton' => { 317 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 317 => '68.1' },
	'assignmb-d18af-onbutton' => { 327 => '79.1' },
	'assignmb-d18funcbutton' => { 327 => '67.1' },
	'assignmb-d18funcbuttonplusdials' => { 327 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 316 => '75.1', 317 => '75.1', 327 => '75.1' },
	'assignmoviefunc2button' => { 316 => '82.1', 317 => '82.1', 327 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 316 => '75.2', 317 => '75.2', 327 => '75.2' },
	'assignmovierecordbutton' => { 314 => '43.2', 326 => '45.1', 329 => 0x9f, 330 => 0x9b, 331 => 0x9b, 332 => 0x9b },
	'assignmovierecordbuttonplusdials' => { 316 => '45.1', 317 => '45.1', 327 => '45.1' },
	'assignmoviesubselector' => { 316 => '74.1', 317 => '74.1', 327 => '74.1' },
	'assignmoviesubselectorplusdials' => { 316 => '76.1', 317 => '76.1', 327 => '76.1' },
	'assignremotefnbutton' => { 314 => '54.1', 326 => '51.1' },
	'assistbuttonfunction' => { 88 => 0xd },
	'atcaptureusercrop' => { 145 => 0x943 },
	'attributionname' => { 526 => 'attributionName' },
	'attributionurl' => { 526 => 'attributionURL' },
	'audio' => { 358 => 0x20 },
	'audiobitrate' => { 72 => 0x6c, 542 => 'audioBitRate' },
	'audiobitratemode' => { 542 => 'audioBitRateMode' },
	'audiobitspersample' => { 542 => 'audioBitsPerSample' },
	'audiobutton' => { 331 => 0x17b, 332 => 0x193 },
	'audiobuttonplaybackmode' => { 331 => 0x1b9, 332 => 0x1d1 },
	'audiochannelcount' => { 542 => 'audioChannelCount' },
	'audiochannels' => { 72 => 0x70 },
	'audiochanneltype' => { 558 => 'audioChannelType' },
	'audiocompression' => { 90 => 0x816, 162 => 'Compression' },
	'audiocompressor' => { 558 => 'audioCompressor' },
	'audiodata' => { 507 => 'Data' },
	'audioduration' => { 138 => 0x99 },
	'audiogain' => { 412 => 'player.movie.audio.gain', 415 => 'player.movie.audio.gain' },
	'audiomimetype' => { 507 => 'Mime' },
	'audiomoddate' => { 558 => 'audioModDate' },
	'audiooutcue' => { 138 => 0x9a },
	'audiosamplerate' => { 72 => 0x6e, 558 => 'audioSampleRate' },
	'audiosampletype' => { 558 => 'audioSampleType' },
	'audiosamplingrate' => { 138 => 0x97 },
	'audiosamplingresolution' => { 138 => 0x98 },
	'audiotype' => { 138 => 0x96 },
	'author' => { 164 => 'Author', 343 => 'Author', 347 => 'Author', 411 => 'Author', 413 => ['auth',"\xa9aut"], 415 => 'author', 421 => 'auth', 522 => 'author', 544 => 'Author', 556 => 'Author' },
	'authorsposition' => { 546 => 'AuthorsPosition' },
	'authorurl' => { 186 => 'WM/AuthorURL' },
	'autoafpointcolortracking' => { 90 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 385 => '0.1' },
	'autobracket' => { 439 => 0x19 },
	'autobracketing' => { 133 => 0x1100, 395 => 0x18, 429 => 0x1007 },
	'autobracketingmode' => { 325 => '12.3' },
	'autobracketingset' => { 325 => '12.1' },
	'autobracketmodem' => { 313 => '21.2', 314 => '13.3', 316 => '13.2', 317 => '13.2', 322 => '26.2', 326 => '13.3', 327 => '13.2', 329 => 0x63, 330 => 0x5f, 331 => 0x5f, 332 => 0x5f },
	'autobracketorder' => { 191 => 0x43, 313 => '21.3', 314 => '13.2', 316 => '13.1', 317 => '13.1', 322 => '26.3', 323 => '12.2', 324 => '2.2', 325 => '12.2', 326 => '13.2', 327 => '13.1', 328 => '13.2', 329 => 0x65, 330 => 0x61, 331 => 0x61, 332 => 0x61 },
	'autobracketset' => { 313 => '21.1', 314 => '13.1', 318 => '11.1', 319 => '12.1', 320 => '12.1', 322 => '26.1', 323 => '12.1', 324 => '2.1', 326 => '13.1', 328 => '13.1' },
	'autobrightness' => { 528 => 'AutoBrightness', 530 => 'AutoBrightness' },
	'autocapturecriteria' => { 206 => 0x1 },
	'autocapturecriteriamotiondirection' => { 206 => 0x5f },
	'autocapturecriteriamotionsize' => { 206 => 0x64 },
	'autocapturecriteriamotionspeed' => { 206 => 0x63 },
	'autocapturecriteriasubjectsize' => { 206 => 0x69 },
	'autocapturecriteriasubjecttype' => { 206 => 0x6a },
	'autocapturedframe' => { 206 => 0x0 },
	'autocapturedistancefar' => { 206 => 0x4a },
	'autocapturedistancenear' => { 206 => 0x4e },
	'autocapturepreset' => { 257 => 0x746 },
	'autocapturerecordingtime' => { 206 => 0x37 },
	'autocapturewaittime' => { 206 => 0x38 },
	'autocontrast' => { 528 => 'AutoContrast', 530 => 'AutoContrast' },
	'autodistortioncontrol' => { 220 => 0x4, 250 => 0x2cf, 251 => 0x143 },
	'autodynamicrange' => { 133 => 0x140b },
	'autoexposure' => { 528 => 'AutoExposure', 530 => 'AutoExposure' },
	'autoexposurebracketing' => { 82 => 0x10 },
	'autoflashisosensitivity' => { 316 => '38.5', 317 => '38.5', 327 => '38.5', 329 => 0x5f, 330 => 0x5b, 331 => 0x5b, 332 => 0x5b },
	'autofocus' => { 337 => 0x209 },
	'autofocusmoderestrictions' => { 330 => 0x107, 331 => 0x107, 332 => 0x11d },
	'autofp' => { 324 => '7.3', 328 => '31.4' },
	'autoiso' => { 82 => 0x1, 119 => 0x3008, 250 => 0x288, 252 => 0x152, 255 => 0x142, 256 => 0x156, 257 => 0x156, 315 => '1.1', 324 => '1.1' },
	'autoisomax' => { 315 => '1.2', 324 => '1.2' },
	'autoisominshutterspeed' => { 315 => '1.3', 324 => '1.3' },
	'autolateralca' => { 528 => 'AutoLateralCA', 530 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 16 => 0xbe, 17 => 0xbf, 20 => 0xbf, 67 => 0x2, 90 => 0x204, 109 => 0x20500, 115 => 0x6f },
	'autolightingoptimizeron' => { 109 => '0x20500.0', 115 => 0x6e },
	'autoportraitframed' => { 463 => 0x2016 },
	'autoredeye' => { 306 => 0xfe28a44f },
	'autorotate' => { 82 => 0x1b },
	'autoshadows' => { 528 => 'AutoShadows', 530 => 'AutoShadows' },
	'autotone' => { 528 => 'AutoTone', 530 => 'AutoTone' },
	'autotonedigest' => { 528 => 'AutoToneDigest', 530 => 'AutoToneDigest' },
	'autotonedigestnosat' => { 528 => 'AutoToneDigestNoSat', 530 => 'AutoToneDigestNoSat' },
	'autowhiteversion' => { 528 => 'AutoWhiteVersion', 530 => 'AutoWhiteVersion' },
	'auxiliaryimagetype' => { 523 => 'AuxiliaryImageType' },
	'auxiliarylens' => { 246 => 0x82 },
	'avaperturesetting' => { 375 => 0x13 },
	'averageblacklevel' => { 49 => 0xe7, 51 => 0xfb, 52 => 0x114, 53 => 0x146 },
	'averagelv' => { 194 => 0x38 },
	'avsettingwithoutlens' => { 90 => 0x707 },
	'azimuth' => { 172 => 'Azimuth' },
	'babyage' => { 358 => [0x8010,0x33] },
	'babyname' => { 358 => 0x66 },
	'backgroundalpha' => { 553 => 'bgalpha' },
	'balance' => { 412 => 'player.movie.audio.balance', 415 => 'player.movie.audio.balance' },
	'baseexposurecompensation' => { 375 => 0x15 },
	'baseiso' => { 82 => 0x2, 103 => 0x101c, 145 => 0x903, 360 => 0x312a, 495 => 0x6 },
	'baseisodaylight' => { 145 => 0x910 },
	'baseisoflash' => { 145 => 0x913 },
	'baseisofluorescent' => { 145 => 0x912 },
	'baseisotungsten' => { 145 => 0x911 },
	'baselineexposure' => { 125 => 0xc62a },
	'baselineexposureoffset' => { 125 => 0xc7a5 },
	'baselinenoise' => { 125 => 0xc62b },
	'baselinesharpness' => { 125 => 0xc62c },
	'baserenditionishdr' => { 539 => 'BaseRenditionIsHDR' },
	'baseurl' => { 556 => 'BaseURL' },
	'bass' => { 412 => 'player.movie.audio.bass', 415 => 'player.movie.audio.bass' },
	'batterylevel' => { 358 => 0x38, 449 => 0x51, 453 => 0xc, 454 => 0x4, 455 => 0x4, 496 => 0x7, 497 => 0x5 },
	'batterylevel2' => { 497 => 0x7 },
	'batterylevelgrip1' => { 496 => 0x6 },
	'batterylevelgrip2' => { 496 => 0x8 },
	'batteryorder' => { 313 => '12.5', 322 => '13.2', 323 => '2.1', 326 => '3.1' },
	'batterystate' => { 191 => 0x60, 449 => 0x50, 455 => 0x14 },
	'batterytemperature' => { 453 => 0x1, 455 => 0x2, 496 => 0x5 },
	'batterytype' => { 69 => 0x38, 425 => 0x66 },
	'batteryunknown' => { 453 => 0x2, 455 => 0x0 },
	'batteryvoltage' => { 145 => 0x408, 423 => 0x2a, 424 => 0x49, 425 => 0x62, 453 => 0x8 },
	'batteryvoltage1' => { 455 => 0x6 },
	'batteryvoltage2' => { 455 => 0x8 },
	'batteryvoltageavg' => { 425 => 0x64 },
	'bayergreensplit' => { 125 => 0xc62d },
	'bayerpattern' => { 144 => 0xf902, 195 => 0x17 },
	'beatsperminute' => { 413 => 'tmpo' },
	'beatspliceparams' => { 558 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 558 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 558 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 558 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 558 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 558 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 313 => '13.1', 314 => '5.4', 315 => '0.1', 318 => '2.1', 319 => '3.1', 320 => '3.1', 322 => '10.1', 324 => '0.1', 326 => '5.5', 328 => '4.1' },
	'beeppitch' => { 323 => '3.1' },
	'beepvolume' => { 323 => '4.5' },
	'bestqualityscale' => { 125 => 0xc65c },
	'bestshotmode' => { 119 => 0x3007 },
	'bitdepth' => { 169 => 'BitDepth', 195 => 0x11, 272 => 0x41 },
	'bitspercomponent' => { 140 => 0x87 },
	'bitspersample' => { 125 => 0x102, 363 => 0xa, 554 => 'BitsPerSample' },
	'blackacquirerows' => { 145 => 0x18ba },
	'blacklevel' => { 125 => [0x7310,0xc61a], 217 => 0x20, 246 => 0x3d, 339 => [0x401,0x1012], 404 => 0x21d, 470 => [0x7300,0x7310] },
	'blacklevel2' => { 338 => 0x600, 342 => 0x600 },
	'blacklevelblue' => { 363 => 0x1e },
	'blacklevelbottom' => { 145 => 0x3f0 },
	'blackleveldata' => { 404 => 0x223 },
	'blackleveldeltah' => { 125 => 0xc61b },
	'blackleveldeltav' => { 125 => 0xc61c },
	'blacklevelgreen' => { 363 => 0x1d },
	'blacklevelred' => { 363 => 0x1c },
	'blacklevelrepeatdim' => { 125 => 0xc619 },
	'blacklevelrough' => { 145 => 0x40e },
	'blacklevelroughafter' => { 145 => 0x416 },
	'blacklevels' => { 38 => 0x1d },
	'blackleveltop' => { 145 => 0x3ef },
	'blackpoint' => { 395 => 0x200 },
	'blacks2012' => { 528 => 'Blacks2012', 530 => 'Blacks2012' },
	'blacksadj' => { 500 => 0x9018 },
	'bleachbypasstoning' => { 395 => 0x7f },
	'blockshotafresponse' => { 316 => '1.5', 317 => '1.5', 327 => '1.5', 329 => 0x7, 330 => 0x7, 331 => 0x7, 332 => 0x7 },
	'blogtitle' => { 548 => 'blogTitle' },
	'blogurl' => { 548 => 'blogURL' },
	'bluebalance' => { 339 => 0x1018, 363 => 0x12, 395 => 0x1b },
	'bluecurvelimits' => { 114 => 0x1fe },
	'bluecurvepoints' => { 113 => 0x79, 114 => 0x1d4 },
	'bluehsl' => { 109 => 0x20915 },
	'bluehue' => { 528 => 'BlueHue', 530 => 'BlueHue' },
	'bluesaturation' => { 528 => 'BlueSaturation', 530 => 'BlueSaturation' },
	'bluratinfinity' => { 512 => 'BlurAtInfinity' },
	'blurcontrol' => { 395 => 0x82 },
	'blurwarning' => { 133 => 0x1300 },
	'bodybatteryadload' => { 372 => 0x3 },
	'bodybatteryadnoload' => { 372 => 0x2 },
	'bodybatterypercent' => { 372 => 0x3 },
	'bodybatterystate' => { 372 => ['1.1',0x2] },
	'bodybatteryvoltage' => { 372 => 0x4 },
	'bodybatteryvoltage1' => { 372 => 0x2 },
	'bodybatteryvoltage2' => { 372 => 0x4 },
	'bodybatteryvoltage3' => { 372 => 0x6 },
	'bodybatteryvoltage4' => { 372 => 0x8 },
	'bodyfirmware' => { 430 => 0x0 },
	'bodyfirmwareversion' => { 335 => 0x104, 336 => 0x100, 339 => 0x104 },
	'bodyserialnumber' => { 430 => 0x10 },
	'bookedition' => { 548 => 'bookEdition' },
	'bootloaderversion' => { 424 => 0x26 },
	'bracketbutton' => { 254 => 0x808, 257 => 0x80c },
	'bracketbuttonplaybackmode' => { 254 => 0x810, 257 => 0x816 },
	'bracketincrement' => { 250 => 0x34a, 252 => 0x22e, 255 => 0x21a, 256 => 0x22e, 257 => 0x22e },
	'bracketmode' => { 61 => 0x3 },
	'bracketprogram' => { 250 => 0x348, 252 => 0x22c, 255 => 0x218, 256 => 0x22c, 257 => 0x22c },
	'bracketsequence' => { 119 => 0x301d },
	'bracketset' => { 250 => 0x346, 252 => 0x22a, 255 => 0x216, 256 => 0x22a, 257 => 0x22a },
	'bracketsettings' => { 358 => 0x45 },
	'bracketshotnumber' => { 61 => 0x5, 375 => 0x9, 460 => 0x2b },
	'bracketshotnumber2' => { 460 => 0x2d },
	'bracketstep' => { 188 => 0xe },
	'bracketvalue' => { 61 => 0x4 },
	'brightness' => { 125 => 0xfe53, 163 => 'Brightness', 183 => 'Brightness', 188 => 0x2c, 264 => 0x34, 265 => 0x39, 266 => 0x41, 415 => 'player.movie.visual.brightness', 423 => 0x25, 425 => 0x54, 449 => 0x22, 463 => 0x2007, 528 => 'Brightness', 530 => 'Brightness' },
	'brightnessadj' => { 114 => 0x114, 299 => 0x0, 309 => 0x2d, 500 => 0x8018 },
	'brightnessvalue' => { 125 => 0x9203, 194 => [0x691,0x49c3], 339 => 0x1003, 468 => 0x1e, 472 => 0x1140, 473 => 0x1140, 474 => 0x111c, 475 => 0x1198, 476 => 0x1174, 477 => 0x102c, 478 => 0x224, 479 => 0x224, 480 => 0x219, 534 => 'BrightnessValue' },
	'buildnumber' => { 198 => 0x5500 },
	'bulbduration' => { 82 => 0x18 },
	'burstcount' => { 145 => 0x40d },
	'burstgroupid' => { 248 => 0x4 },
	'burstid' => { 508 => 'BurstID' },
	'burstmode' => { 147 => 0xa, 358 => 0x2a },
	'burstmode2' => { 147 => 0x18 },
	'burstprimary' => { 508 => 'BurstPrimary' },
	'burstshot' => { 439 => 0x34 },
	'burstspeed' => { 358 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 90 => 0x70a },
	'bwadjustment' => { 133 => 0x1049 },
	'bwfilter' => { 188 => 0x2a, 196 => 0x39 },
	'bwmagentagreen' => { 133 => 0x104b },
	'bwmode' => { 339 => 0x203 },
	'by-line' => { 138 => 0x50 },
	'by-linetitle' => { 138 => 0x55 },
	'bytecount' => { 548 => 'byteCount' },
	'c14configuration' => { 145 => 0x1964 },
	'cacheversion' => { 125 => 0xc7aa },
	'cafgridsize' => { 373 => '1.1' },
	'calibratedfocallength' => { 122 => 'CalibratedFocalLength' },
	'calibratedopticalcenterx' => { 122 => 'CalibratedOpticalCenterX' },
	'calibratedopticalcentery' => { 122 => 'CalibratedOpticalCenterY' },
	'calibration' => { 439 => [0x24,0x30] },
	'calibrationhistory' => { 145 => 0x9c9 },
	'calibrationilluminant1' => { 125 => 0xc65a },
	'calibrationilluminant2' => { 125 => 0xc65b },
	'calibrationilluminant3' => { 125 => 0xcd31 },
	'calibrationversion' => { 145 => 0x9c6 },
	'callforimage' => { 516 => 'CallForImage' },
	'camera' => { 504 => [\'Cameras','CamerasCamera'] },
	'cameraangle' => { 421 => 'angl', 558 => 'cameraAngle' },
	'cameraappinfo' => { 504 => [\'Cameras','CamerasCameraAppInfo'] },
	'cameraappinfoapplication' => { 504 => [\'Cameras','CamerasCameraAppInfoApplication'] },
	'cameraappinfoitemuri' => { 504 => [\'Cameras','CamerasCameraAppInfoItemURI'] },
	'cameraappinfoversion' => { 504 => [\'Cameras','CamerasCameraAppInfoVersion'] },
	'cameraburstid' => { 510 => 'CameraBurstID' },
	'cameracalibration' => { 439 => 0x11f },
	'cameracalibration1' => { 125 => 0xc623 },
	'cameracalibration2' => { 125 => 0xc624 },
	'cameracalibration3' => { 125 => 0xcd32 },
	'cameracalibrationsig' => { 125 => 0xc6f3 },
	'cameracolorcalibration01' => { 39 => 0x0, 40 => 0x0 },
	'cameracolorcalibration02' => { 39 => 0x4, 40 => 0x5 },
	'cameracolorcalibration03' => { 39 => 0x8, 40 => 0xa },
	'cameracolorcalibration04' => { 39 => 0xc, 40 => 0xf },
	'cameracolorcalibration05' => { 39 => 0x10, 40 => 0x14 },
	'cameracolorcalibration06' => { 39 => 0x14, 40 => 0x19 },
	'cameracolorcalibration07' => { 39 => 0x18, 40 => 0x1e },
	'cameracolorcalibration08' => { 39 => 0x1c, 40 => 0x23 },
	'cameracolorcalibration09' => { 39 => 0x20, 40 => 0x28 },
	'cameracolorcalibration10' => { 39 => 0x24, 40 => 0x2d },
	'cameracolorcalibration11' => { 39 => 0x28, 40 => 0x32 },
	'cameracolorcalibration12' => { 39 => 0x2c, 40 => 0x37 },
	'cameracolorcalibration13' => { 39 => 0x30, 40 => 0x3c },
	'cameracolorcalibration14' => { 39 => 0x34, 40 => 0x41 },
	'cameracolorcalibration15' => { 39 => 0x38, 40 => 0x46 },
	'cameradepthmap' => { 504 => [\'Cameras','CamerasCameraDepthMap'] },
	'cameradepthmapconfidenceuri' => { 504 => [\'Cameras','CamerasCameraDepthMapConfidenceURI'] },
	'cameradepthmapdepthuri' => { 504 => [\'Cameras','CamerasCameraDepthMapDepthURI'] },
	'cameradepthmapfar' => { 504 => [\'Cameras','CamerasCameraDepthMapFar'] },
	'cameradepthmapfocaltable' => { 504 => [\'Cameras','CamerasCameraDepthMapFocalTable'] },
	'cameradepthmapfocaltableentrycount' => { 504 => [\'Cameras','CamerasCameraDepthMapFocalTableEntryCount'] },
	'cameradepthmapformat' => { 504 => [\'Cameras','CamerasCameraDepthMapFormat'] },
	'cameradepthmapitemsemantic' => { 504 => [\'Cameras','CamerasCameraDepthMapItemSemantic'] },
	'cameradepthmapmeasuretype' => { 504 => [\'Cameras','CamerasCameraDepthMapMeasureType'] },
	'cameradepthmapnear' => { 504 => [\'Cameras','CamerasCameraDepthMapNear'] },
	'cameradepthmapsoftware' => { 504 => [\'Cameras','CamerasCameraDepthMapSoftware'] },
	'cameradepthmapunits' => { 504 => [\'Cameras','CamerasCameraDepthMapUnits'] },
	'cameradirection' => { 415 => 'direction.facing' },
	'camerae-mountversion' => { 499 => 0xb },
	'cameraelevationangle' => { 125 => 0x9405, 535 => 'CameraElevationAngle' },
	'camerafilename' => { 516 => 'CameraFilename' },
	'camerafirmware' => { 125 => 0xa439, 535 => 'CameraFirmware' },
	'cameraid' => { 339 => 0x209, 421 => 'cmid', 438 => 0x209 },
	'cameraidentifier' => { 422 => 'camera.identifier' },
	'cameraimage' => { 504 => [\'Cameras','CamerasCameraImage'] },
	'cameraimageitemsemantic' => { 504 => [\'Cameras','CamerasCameraImageItemSemantic'] },
	'cameraimageitemuri' => { 504 => [\'Cameras','CamerasCameraImageItemURI'] },
	'cameraimagingmodel' => { 504 => [\'Cameras','CamerasCameraImagingModel'] },
	'cameraimagingmodeldistortion' => { 504 => [\'Cameras','CamerasCameraImagingModelDistortion'] },
	'cameraimagingmodeldistortioncount' => { 504 => [\'Cameras','CamerasCameraImagingModelDistortionCount'] },
	'cameraimagingmodelfocallengthx' => { 504 => [\'Cameras','CamerasCameraImagingModelFocalLengthX'] },
	'cameraimagingmodelfocallengthy' => { 504 => [\'Cameras','CamerasCameraImagingModelFocalLengthY'] },
	'cameraimagingmodelimageheight' => { 504 => [\'Cameras','CamerasCameraImagingModelImageHeight'] },
	'cameraimagingmodelimagewidth' => { 504 => [\'Cameras','CamerasCameraImagingModelImageWidth'] },
	'cameraimagingmodelpixelaspectratio' => { 504 => [\'Cameras','CamerasCameraImagingModelPixelAspectRatio'] },
	'cameraimagingmodelprincipalpointx' => { 504 => [\'Cameras','CamerasCameraImagingModelPrincipalPointX'] },
	'cameraimagingmodelprincipalpointy' => { 504 => [\'Cameras','CamerasCameraImagingModelPrincipalPointY'] },
	'cameraimagingmodelskew' => { 504 => [\'Cameras','CamerasCameraImagingModelSkew'] },
	'cameraiso' => { 37 => 0x10 },
	'cameralabel' => { 125 => 0xc7a1, 558 => 'cameraLabel' },
	'cameralightestimate' => { 504 => [\'Cameras','CamerasCameraLightEstimate'] },
	'cameralightestimatecolorcorrectionb' => { 504 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionB'] },
	'cameralightestimatecolorcorrectiong' => { 504 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionG'] },
	'cameralightestimatecolorcorrectionr' => { 504 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionR'] },
	'cameralightestimatepixelintensity' => { 504 => [\'Cameras','CamerasCameraLightEstimatePixelIntensity'] },
	'cameramakemodel' => { 516 => 'CameraMakeModel' },
	'cameramodel' => { 404 => 0x410, 558 => 'cameraModel' },
	'cameramodelid' => { 183 => 'CameraModelID' },
	'cameramodelrestriction' => { 528 => 'CameraModelRestriction', 530 => 'CameraModelRestriction' },
	'cameramotion' => { 415 => 'direction.motion' },
	'cameramove' => { 558 => 'cameraMove' },
	'cameraorientation' => { 7 => 0x30, 9 => 0x7d, 11 => 0x30, 13 => 0x35, 14 => 0x30, 15 => 0x30, 16 => 0x31, 17 => 0x31, 18 => 0x35, 19 => 0x27, 20 => 0x31, 21 => 0x7d, 22 => 0x38, 23 => [0x36,0x3a], 24 => 0x7d, 25 => 0x83, 26 => 0x84, 27 => 0x96, 28 => 0x35, 29 => 0x96, 358 => 0x8f, 394 => 0x1, 399 => 0x1, 404 => 0x100, 455 => [0x16,0x18], 486 => 0x28, 487 => 0x24, 488 => 0x29 },
	'cameraowner' => { 148 => 0xc353 },
	'cameraparameters' => { 339 => 0x2050 },
	'camerapicturestyle' => { 28 => 0xaf },
	'camerapitch' => { 121 => 0x9, 421 => "\xa9gpt" },
	'camerapointcloud' => { 504 => [\'Cameras','CamerasCameraPointCloud'] },
	'camerapointcloudmetric' => { 504 => [\'Cameras','CamerasCameraPointCloudMetric'] },
	'camerapointcloudpointcloud' => { 504 => [\'Cameras','CamerasCameraPointCloudPointCloud'] },
	'camerapointcloudpoints' => { 504 => [\'Cameras','CamerasCameraPointCloudPoints'] },
	'camerapose' => { 504 => [\'Cameras','CamerasCameraPose'] },
	'cameraposepositionx' => { 504 => [\'Cameras','CamerasCameraPosePositionX'] },
	'cameraposepositiony' => { 504 => [\'Cameras','CamerasCameraPosePositionY'] },
	'cameraposepositionz' => { 504 => [\'Cameras','CamerasCameraPosePositionZ'] },
	'cameraposerotationw' => { 504 => [\'Cameras','CamerasCameraPoseRotationW'] },
	'cameraposerotationx' => { 504 => [\'Cameras','CamerasCameraPoseRotationX'] },
	'cameraposerotationy' => { 504 => [\'Cameras','CamerasCameraPoseRotationY'] },
	'cameraposerotationz' => { 504 => [\'Cameras','CamerasCameraPoseRotationZ'] },
	'cameraposetimestamp' => { 504 => [\'Cameras','CamerasCameraPoseTimestamp'] },
	'cameraprofile' => { 528 => 'CameraProfile', 530 => 'CameraProfile' },
	'cameraprofiledigest' => { 528 => 'CameraProfileDigest', 530 => 'CameraProfileDigest' },
	'cameraprofiles' => { 546 => 'CameraProfiles' },
	'cameraprofilesaperturevalue' => { 546 => [\'CameraProfiles','CameraProfilesApertureValue'] },
	'cameraprofilesauthor' => { 546 => [\'CameraProfiles','CameraProfilesAuthor'] },
	'cameraprofilesautoscale' => { 546 => [\'CameraProfiles','CameraProfilesAutoScale'] },
	'cameraprofilescameraprettyname' => { 546 => [\'CameraProfiles','CameraProfilesCameraPrettyName'] },
	'cameraprofilescamerarawprofile' => { 546 => [\'CameraProfiles','CameraProfilesCameraRawProfile'] },
	'cameraprofilesfocallength' => { 546 => [\'CameraProfiles','CameraProfilesFocalLength'] },
	'cameraprofilesfocusdistance' => { 546 => [\'CameraProfiles','CameraProfilesFocusDistance'] },
	'cameraprofileslens' => { 546 => [\'CameraProfiles','CameraProfilesLens'] },
	'cameraprofileslensprettyname' => { 546 => [\'CameraProfiles','CameraProfilesLensPrettyName'] },
	'cameraprofilesmake' => { 546 => [\'CameraProfiles','CameraProfilesMake'] },
	'cameraprofilesmodel' => { 546 => [\'CameraProfiles','CameraProfilesModel'] },
	'cameraprofilesperspectivemodel' => { 546 => [\'CameraProfiles','CameraProfilesPerspectiveModel'] },
	'cameraprofilesperspectivemodelimagexcenter' => { 546 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageXCenter'] },
	'cameraprofilesperspectivemodelimageycenter' => { 546 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageYCenter'] },
	'cameraprofilesperspectivemodelradialdistortparam1' => { 546 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam1'] },
	'cameraprofilesperspectivemodelradialdistortparam2' => { 546 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam2'] },
	'cameraprofilesperspectivemodelradialdistortparam3' => { 546 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam3'] },
	'cameraprofilesperspectivemodelscalefactor' => { 546 => [\'CameraProfiles','CameraProfilesPerspectiveModelScaleFactor'] },
	'cameraprofilesperspectivemodelversion' => { 546 => [\'CameraProfiles','CameraProfilesPerspectiveModelVersion'] },
	'cameraprofilesprofilename' => { 546 => [\'CameraProfiles','CameraProfilesProfileName'] },
	'cameraprofilessensorformatfactor' => { 546 => [\'CameraProfiles','CameraProfilesSensorFormatFactor'] },
	'cameraprofilesuniquecameramodel' => { 546 => [\'CameraProfiles','CameraProfilesUniqueCameraModel'] },
	'camerarawcolortone' => { 115 => 0xe1 },
	'camerarawcontrast' => { 115 => 0xe3 },
	'camerarawhighlightpoint' => { 115 => 0xe6 },
	'camerarawlinear' => { 115 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 115 => 0xe8 },
	'camerarawoutputshadowpoint' => { 115 => 0xe9 },
	'camerarawsaturation' => { 115 => 0xe2 },
	'camerarawshadowpoint' => { 115 => 0xe7 },
	'camerarawsharpness' => { 115 => 0xe5 },
	'cameraroll' => { 121 => 0xb, 421 => "\xa9grl" },
	'cameras' => { 504 => 'Cameras' },
	'cameraserialnumber' => { 125 => 0xc62f, 185 => 'CameraSerialNumber', 516 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 334 => 0x0 },
	'cameratemperature' => { 7 => 0x18, 9 => 0x1b, 11 => 0x18, 13 => 0x19, 14 => 0x18, 15 => 0x18, 16 => 0x19, 17 => 0x19, 18 => 0x19, 19 => 0x17, 20 => 0x19, 21 => 0x1b, 22 => 0x19, 23 => 0x19, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x1b, 28 => 0x19, 29 => 0x1b, 31 => [0x87,0x91], 32 => [0x99,0x9f,0xa4,0xa8,0x105], 36 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 82 => 0xc, 145 => 0x406, 338 => 0x1306, 353 => 0x320, 360 => 0x3402, 395 => 0x47, 436 => 0x43, 490 => 0x5 },
	'cameratemperature4' => { 400 => 0x14 },
	'cameratemperature5' => { 400 => 0x16 },
	'cameratemperaturerangemax' => { 127 => 0x5 },
	'cameratemperaturerangemin' => { 127 => 0x6 },
	'cameratrait' => { 504 => [\'Cameras','CamerasCameraTrait'] },
	'cameratype' => { 1 => 0x2e, 82 => 0x1a, 339 => 0x207 },
	'cameratype2' => { 335 => 0x100 },
	'cameravendorinfo' => { 504 => [\'Cameras','CamerasCameraVendorInfo'] },
	'cameravendorinfomanufacturer' => { 504 => [\'Cameras','CamerasCameraVendorInfoManufacturer'] },
	'cameravendorinfomodel' => { 504 => [\'Cameras','CamerasCameraVendorInfoModel'] },
	'cameravendorinfonotes' => { 504 => [\'Cameras','CamerasCameraVendorInfoNotes'] },
	'camerayaw' => { 121 => 0xa, 421 => "\xa9gyw" },
	'camreverse' => { 122 => 'CamReverse' },
	'canondr4' => { 126 => 'CanonDR4' },
	'canonexposuremode' => { 37 => 0x14 },
	'canonfiledescription' => { 103 => 0x805 },
	'canonfilelength' => { 69 => 0xe },
	'canonfirmwareversion' => { 69 => 0x7, 103 => 0x80b },
	'canonflashinfo' => { 103 => 0x1028 },
	'canonflashmode' => { 37 => 0x4 },
	'canonimagesize' => { 10 => 0x39, 37 => 0xa },
	'canonimagetype' => { 69 => 0x6, 103 => 0x815 },
	'canonlogversion' => { 68 => 0xb },
	'canonmodelid' => { 69 => 0x10, 103 => 0x1834 },
	'canonvrd' => { 126 => 'CanonVRD' },
	'caption' => { 522 => 'caption' },
	'caption-abstract' => { 138 => 0x78 },
	'captionsauthornames' => { 533 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 533 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 546 => 'CaptionWriter' },
	'captureframerate' => { 119 => 0x4001 },
	'captureheightnormal' => { 145 => 0x1839 },
	'capturelook' => { 145 => 0xc48 },
	'capturemode' => { 422 => 'com.apple.photos.captureMode' },
	'capturesoftware' => { 514 => 'CaptureSoftware' },
	'capturewidthnormal' => { 145 => 0x1838 },
	'capturewidthtest' => { 145 => 0x1842 },
	'cardshutterlock' => { 191 => 0x49 },
	'casioimagesize' => { 119 => 0x9 },
	'catalogsets' => { 138 => 0xff, 506 => 'CatalogSets', 520 => 'CatalogSets' },
	'categories' => { 69 => 0x23, 522 => 'categories' },
	'category' => { 138 => 0xf, 186 => 'WM/Category', 333 => 0x30, 413 => 'catg', 546 => 'Category' },
	'cbcrgain' => { 436 => 0xa036 },
	'cbcrgaindefault' => { 436 => 0xa035 },
	'cbcrmatrix' => { 436 => 0xa034 },
	'cbcrmatrixdefault' => { 436 => 0xa033 },
	'ccdboardversion' => { 353 => 0x331 },
	'ccdscanmode' => { 339 => 0x1039 },
	'ccdsensitivity' => { 295 => 0x6 },
	'ccdversion' => { 353 => 0x330 },
	'ccvavgluminancenits' => { 538 => 'ccv_avg_luminance_nits' },
	'ccvmaxluminancenits' => { 538 => 'ccv_max_luminance_nits' },
	'ccvminluminancenits' => { 538 => 'ccv_min_luminance_nits' },
	'ccvprimariesxy' => { 538 => 'ccv_primaries_xy' },
	'ccvwhitexy' => { 538 => 'ccv_white_xy' },
	'cellglobalid' => { 527 => 'cgi' },
	'celllength' => { 125 => 0x109 },
	'cellr' => { 527 => 'r' },
	'celltowerid' => { 527 => 'cellid' },
	'cellwidth' => { 125 => 0x108 },
	'centerafarea' => { 324 => '15.1' },
	'centerfocuspoint' => { 328 => '2.2' },
	'centerpixel' => { 145 => 0x40c },
	'centerweightedareasize' => { 313 => '7.1', 314 => '8.1', 316 => '8.1', 317 => '8.1', 321 => '7.1', 322 => '5.1', 323 => '7.1', 324 => '6.3', 326 => '8.1', 327 => '8.1', 328 => '8.1', 329 => 0x21, 330 => 0x1f, 331 => 0x1f, 332 => 0x1f },
	'certificate' => { 562 => 'Certificate' },
	'cfainterpolationalgorithm' => { 145 => 0xe60 },
	'cfainterpolationmetric' => { 145 => 0xe61 },
	'cfaoffsetcols' => { 145 => 0xc71 },
	'cfaoffsetrows' => { 145 => 0xc6f },
	'cfapattern' => { 125 => 0xa302, 363 => 0x9, 534 => 'CFAPattern' },
	'cfapattern2' => { 125 => 0x828e },
	'cfapatterncolumns' => { 534 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 534 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 534 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 125 => 0x828d },
	'cfazipperfixthreshold' => { 145 => 0xe62 },
	'channel' => { 548 => 'channel' },
	'channela-lang' => { 548 => [\'channel','channelA-lang'] },
	'channelchannel' => { 548 => [\'channel','channelChannel'] },
	'channels' => { 162 => 'Channels' },
	'channelsubchannel1' => { 548 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 548 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 548 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 548 => [\'channel','channelSubchannel4'] },
	'chapterlist' => { 421 => 'chpl' },
	'checkmark' => { 109 => 0x10101, 114 => 0x26a },
	'checkmark2' => { 115 => 0x8e },
	'childfontfiles' => { 563 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 313 => '10.3', 314 => '11.2', 330 => 0x10b, 331 => 0x10b, 332 => 0x121 },
	'chromablurradius' => { 125 => 0xc631 },
	'chromanoisecolorspace' => { 145 => 0xe6d },
	'chromanoiseedgemapthresh' => { 145 => 0xe6c },
	'chromanoisehighfthresh' => { 145 => 0xe6a },
	'chromanoiselowfthresh' => { 145 => 0xe6b },
	'chromaticaberration' => { 109 => 0x20703, 115 => 0x66, 436 => 0xa051 },
	'chromaticaberrationb' => { 528 => 'ChromaticAberrationB', 530 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 109 => 0x20708, 115 => 0x6b },
	'chromaticaberrationcorr' => { 84 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 125 => 0x7034, 384 => 0x1, 500 => 0x900d },
	'chromaticaberrationcorrparams' => { 125 => 0x7035, 494 => 0x66a, 495 => [0x37c,0x384,0x39c,0x3b0,0x3b8] },
	'chromaticaberrationon' => { 109 => '0x20703.0', 115 => 0x62 },
	'chromaticaberrationr' => { 528 => 'ChromaticAberrationR', 530 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 109 => 0x20707, 115 => 0x6a },
	'chromaticaberrationsetting' => { 85 => 0x6 },
	'chrominancenoisereduction' => { 109 => 0x20601, 115 => 0x5e, 439 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 115 => 0x60 },
	'circadatecreated' => { 542 => 'CircaDateCreated' },
	'circgradbasedcorractive' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrblacks2012' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'] },
	'circgradbasedcorrbrightness' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrcorrectionname' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'] },
	'circgradbasedcorrcorrectionsyncid' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'] },
	'circgradbasedcorrdefringe' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrdehaze' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'] },
	'circgradbasedcorrexposure' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'] },
	'circgradbasedcorrluminancenoise' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskinputdigest' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'circgradbasedcorrmaskleft' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmaskactive' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'circgradbasedcorrmaskmaskblendmode' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmaskdigest' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'circgradbasedcorrmaskmaskinverted' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'circgradbasedcorrmaskmaskname' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'] },
	'circgradbasedcorrmaskmasks' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'] },
	'circgradbasedcorrmaskmasksalpha' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'circgradbasedcorrmaskmasksangle' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'circgradbasedcorrmaskmasksbottom' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'circgradbasedcorrmaskmaskscentervalue' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'circgradbasedcorrmaskmaskscenterweight' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'circgradbasedcorrmaskmasksdabs' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'circgradbasedcorrmaskmasksfeather' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'circgradbasedcorrmaskmasksflipped' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'circgradbasedcorrmaskmasksflow' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'circgradbasedcorrmaskmasksfullx' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'circgradbasedcorrmaskmasksfully' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'circgradbasedcorrmaskmasksinputdigest' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'circgradbasedcorrmaskmasksleft' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'circgradbasedcorrmaskmasksmaskactive' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'circgradbasedcorrmaskmasksmaskblendmode' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmasksmaskdigest' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'circgradbasedcorrmaskmasksmaskinverted' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'circgradbasedcorrmaskmasksmaskname' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'circgradbasedcorrmaskmasksmasksubtype' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksmasksyncid' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'circgradbasedcorrmaskmasksmaskversion' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'circgradbasedcorrmaskmasksmidpoint' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'circgradbasedcorrmaskmasksorigin' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'circgradbasedcorrmaskmasksperimetervalue' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'circgradbasedcorrmaskmasksradius' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'circgradbasedcorrmaskmasksreferencepoint' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'circgradbasedcorrmaskmasksright' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'circgradbasedcorrmaskmasksroundness' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'circgradbasedcorrmaskmaskssizex' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'circgradbasedcorrmaskmaskssizey' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'circgradbasedcorrmaskmaskstop' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'circgradbasedcorrmaskmasksubtype' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksvalue' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'circgradbasedcorrmaskmasksversion' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'circgradbasedcorrmaskmaskswhat' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'circgradbasedcorrmaskmaskswholeimagearea' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'circgradbasedcorrmaskmasksx' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'] },
	'circgradbasedcorrmaskmasksy' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'] },
	'circgradbasedcorrmaskmasksyncid' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'circgradbasedcorrmaskmaskszerox' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'circgradbasedcorrmaskmaskszeroy' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'circgradbasedcorrmaskmaskversion' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'circgradbasedcorrmaskmidpoint' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskorigin' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'] },
	'circgradbasedcorrmaskperimetervalue' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskrange' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'circgradbasedcorrmaskrangeareamodels' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrmaskrangeareamodelscolorsampleinfo' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrmaskrangeareamodelscomponents' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrmaskrangecoloramount' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrmaskrangedepthfeather' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrmaskrangedepthmax' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrmaskrangedepthmin' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrmaskrangeinvert' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'circgradbasedcorrmaskrangelumfeather' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrmaskrangeluminancedepthsampleinfo' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrmaskrangelummax' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrmaskrangelummin' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrmaskrangelumrange' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrmaskrangesampletype' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrmaskrangetype' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'circgradbasedcorrmaskrangeversion' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'circgradbasedcorrmaskreferencepoint' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'circgradbasedcorrmaskright' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskwholeimagearea' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'circgradbasedcorrmaskx' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrrangemask' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'] },
	'circgradbasedcorrrangemaskareamodels' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrrangemaskareamodelscolorsampleinfo' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrrangemaskareamodelscomponents' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrrangemaskcoloramount' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrrangemaskdepthfeather' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrrangemaskdepthmax' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrrangemaskdepthmin' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrrangemaskinvert' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'circgradbasedcorrrangemasklumfeather' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrrangemaskluminancedepthsampleinfo' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrrangemasklummax' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrrangemasklummin' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrrangemasklumrange' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrrangemasksampletype' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrrangemasktype' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'] },
	'circgradbasedcorrrangemaskversion' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'circgradbasedcorrsaturation' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'] },
	'circgradbasedcorrshadows2012' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtexture' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'] },
	'circgradbasedcorrtint' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrtoninghue' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrtoningsaturation' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrwhat' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circgradbasedcorrwhites2012' => { 528 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'], 530 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'] },
	'circulargradientbasedcorrections' => { 528 => 'CircularGradientBasedCorrections', 530 => 'CircularGradientBasedCorrections' },
	'city' => { 138 => 0x5a, 168 => 'City', 358 => 0x6d, 546 => 'City' },
	'city2' => { 358 => 0x80 },
	'clarity' => { 37 => 0x33, 133 => 0x100f, 265 => 0x35, 266 => 0x3d, 463 => 0x2036, 528 => 'Clarity', 530 => 'Clarity' },
	'clarity2012' => { 528 => 'Clarity2012', 530 => 'Clarity2012' },
	'claritycontrol' => { 395 => 0x96 },
	'classification' => { 421 => 'clsf' },
	'classifystate' => { 138 => 0xe1 },
	'clearretouch' => { 358 => 0x7c },
	'clearretouchvalue' => { 358 => 0xa3 },
	'client' => { 558 => 'client' },
	'clientname' => { 536 => 'ClientName' },
	'clipboardaspectratio' => { 528 => 'ClipboardAspectRatio', 530 => 'ClipboardAspectRatio' },
	'clipboardorientation' => { 528 => 'ClipboardOrientation', 530 => 'ClipboardOrientation' },
	'clipfilename' => { 421 => 'clfn' },
	'clipid' => { 421 => 'clid' },
	'clmodeshootingspeed' => { 313 => '10.2', 314 => '11.3', 316 => '11.2', 317 => '11.2', 322 => '11.2', 323 => '10.2', 326 => '11.2', 327 => '11.2', 328 => '11.1', 329 => 0x3f, 330 => 0x3b, 331 => 0x3b, 332 => 0x3b },
	'cluster' => { 528 => 'Cluster', 530 => 'Cluster' },
	'cmcontrast' => { 342 => 0x2022 },
	'cmddialsreverserotation' => { 329 => 0xbe, 330 => 0xba, 331 => 0xba, 332 => 0xba },
	'cmexposurecompensation' => { 342 => 0x2000 },
	'cmhue' => { 342 => 0x2021 },
	'cmsaturation' => { 342 => 0x2020 },
	'cmsharpness' => { 342 => 0x2023 },
	'cmwhitebalance' => { 342 => 0x2001 },
	'cmwhitebalancecomp' => { 342 => 0x2002 },
	'cmwhitebalancegraypoint' => { 342 => 0x2010 },
	'codec' => { 176 => 'Codec' },
	'codedcharacterset' => { 139 => 0x5a },
	'codeversion' => { 421 => 'cver' },
	'collection' => { 347 => 'Collection' },
	'collectionname' => { 177 => [\'Collections','CollectionsCollectionName'], 421 => 'coll' },
	'collections' => { 177 => 'Collections', 522 => 'collections' },
	'collectionuri' => { 177 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 415 => 'player.movie.visual.color', 547 => 'color' },
	'coloraberrationcontrol' => { 306 => 0xc89224b },
	'coloradjustment' => { 439 => 0x14 },
	'coloradjustmentmode' => { 438 => 0x210 },
	'coloranta' => { 563 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 563 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 563 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 563 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 563 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 563 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 563 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 563 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 563 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 563 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 563 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 563 => 'Colorants' },
	'colorantswatchname' => { 563 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 563 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 563 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 563 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 163 => 'ColorBalance' },
	'colorbalanceadj' => { 306 => 0x76a43202 },
	'colorbalanceblue' => { 188 => 0x1e },
	'colorbalancegreen' => { 188 => 0x1d },
	'colorbalancered' => { 188 => 0x1c },
	'colorbalanceversion' => { 216 => 0x4, 217 => 0x4, 218 => 0x0, 219 => 0x0 },
	'colorblur' => { 115 => 0x65 },
	'colorbluron' => { 109 => 0x20704 },
	'colorbooster' => { 306 => 0x5f0e7d23 },
	'colorboostlevel' => { 300 => 0x1 },
	'colorboosttype' => { 300 => 0x0 },
	'colorchromeeffect' => { 133 => 0x1048 },
	'colorchromefxblue' => { 133 => 0x104e },
	'colorclass' => { 406 => 0xde, 407 => 'ColorClass' },
	'colorcompensationfilter' => { 191 => [0x3a,0x5f], 193 => 0x111, 463 => 0xb022 },
	'colorcompensationfiltercustom' => { 449 => 0xd, 450 => 0xc },
	'colorcompensationfilterset' => { 449 => 0x8, 450 => 0x7, 451 => 0x18, 468 => 0xf },
	'colorcontrol' => { 339 => 0x102b },
	'colorcorrection' => { 500 => 0x8015 },
	'colorcorrectionmatrix' => { 1 => 0x3e },
	'colorcreatoreffect' => { 334 => 0x532 },
	'colordataversion' => { 44 => 0x0, 45 => 0x0, 46 => 0x0, 48 => 0x0, 49 => 0x0, 50 => 0x0, 51 => 0x0, 52 => 0x0, 53 => 0x0, 54 => 0x0 },
	'coloreffect' => { 358 => 0x28 },
	'colorfilter' => { 118 => 0x17, 119 => 0x3017, 188 => 0x29, 196 => [0x38,0x4d,0x4f], 402 => 0x17 },
	'colorgain' => { 272 => 0x51 },
	'colorgradeblending' => { 528 => 'ColorGradeBlending', 530 => 'ColorGradeBlending' },
	'colorgradeglobalhue' => { 528 => 'ColorGradeGlobalHue', 530 => 'ColorGradeGlobalHue' },
	'colorgradegloballum' => { 528 => 'ColorGradeGlobalLum', 530 => 'ColorGradeGlobalLum' },
	'colorgradeglobalsat' => { 528 => 'ColorGradeGlobalSat', 530 => 'ColorGradeGlobalSat' },
	'colorgradehighlightlum' => { 528 => 'ColorGradeHighlightLum', 530 => 'ColorGradeHighlightLum' },
	'colorgrademidtonehue' => { 528 => 'ColorGradeMidtoneHue', 530 => 'ColorGradeMidtoneHue' },
	'colorgrademidtonelum' => { 528 => 'ColorGradeMidtoneLum', 530 => 'ColorGradeMidtoneLum' },
	'colorgrademidtonesat' => { 528 => 'ColorGradeMidtoneSat', 530 => 'ColorGradeMidtoneSat' },
	'colorgradeshadowlum' => { 528 => 'ColorGradeShadowLum', 530 => 'ColorGradeShadowLum' },
	'colorhue' => { 109 => 0x20900, 246 => 0x8d },
	'colorimetricreference' => { 125 => 0xc6bf },
	'colorlabel' => { 533 => 'ColorLabel' },
	'colormatrix' => { 68 => 0xa, 338 => 0x200, 339 => 0x1011, 436 => 0xa030 },
	'colormatrix1' => { 125 => 0xc621, 404 => 0x106 },
	'colormatrix2' => { 125 => 0xc622, 342 => 0x200, 404 => 0x226 },
	'colormatrix3' => { 125 => 0xcd33 },
	'colormatrixa' => { 395 => 0x203 },
	'colormatrixa2' => { 395 => 0x21c },
	'colormatrixadobergb' => { 436 => 0xa032 },
	'colormatrixb' => { 395 => 0x204 },
	'colormatrixb2' => { 395 => 0x21d },
	'colormatrixnumber' => { 339 => 0x1019 },
	'colormatrixsrgb' => { 436 => 0xa031 },
	'colormode' => { 119 => 0x3015, 133 => 0x1210, 147 => 0x66, 188 => 0x28, 191 => 0x16, 193 => 0x101, 194 => 0x36, 196 => 0x7, 246 => 0x3, 295 => 0x4, 358 => 0x32, 439 => 0x2c, 463 => 0xb029, 546 => 'ColorMode' },
	'colormoirereduction' => { 109 => 0x20670, 307 => 0x15 },
	'colormoirereductionmode' => { 307 => 0x5 },
	'colormoirereductionon' => { 109 => '0x20670.0' },
	'colornoisereduction' => { 500 => 0x8029, 528 => 'ColorNoiseReduction', 530 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 528 => 'ColorNoiseReductionDetail', 530 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 307 => 0x18 },
	'colornoisereductionsharpness' => { 307 => 0x1c },
	'colornoisereductionsmoothness' => { 528 => 'ColorNoiseReductionSmoothness', 530 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 129 => 0x2 },
	'colorprofile' => { 188 => 0x33 },
	'colorprofilesettings' => { 334 => 0x539 },
	'colorrepresentation' => { 140 => 0x3c },
	'colorsaturationadj' => { 109 => 0x20305 },
	'colorsequence' => { 140 => 0x41 },
	'colorspace' => { 55 => 0x3, 69 => 0xb4, 103 => 0x10b4, 125 => 0xa001, 142 => 0x3, 169 => 'ColorSpace', 189 => 0x2f, 190 => 0x25, 191 => 0x17, 246 => 0x1e, 334 => 0x507, 395 => 0x37, 436 => 0xa011, 439 => 0xb, 449 => 0x1b, 450 => 0x83, 451 => 0xe, 468 => 0x6, 534 => 'ColorSpace' },
	'colorspace2' => { 68 => 0x9 },
	'colorspecapproximation' => { 142 => 0x2 },
	'colorspecdata' => { 142 => 0x3 },
	'colorspecmethod' => { 142 => 0x0 },
	'colorspecprecedence' => { 142 => 0x1 },
	'colortempasshot' => { 41 => 0x4, 42 => 0x7, 43 => 0x1d, 44 => 0x59, 45 => 0x6d, 46 => 0x6d, 47 => 0x26, 48 => 0x43, 51 => 0x43, 52 => 0x43, 53 => 0x43, 54 => 0x4b },
	'colortempauto' => { 41 => 0x9, 42 => 0xf, 43 => 0x22, 44 => 0x5e, 45 => 0x72, 47 => 0x1c, 48 => 0x48, 51 => 0x48, 52 => 0x48, 53 => 0x48, 54 => 0x50 },
	'colortempcloudy' => { 41 => 0x22, 42 => 0x37, 43 => 0x31, 44 => 0xa4, 45 => 0xdb, 46 => 0x7c, 47 => 0x35, 48 => 0x5c, 51 => 0x75, 52 => 0x8e, 53 => 0x93, 54 => 0x96, 395 => 0x55 },
	'colortempcustom' => { 48 => 0x84 },
	'colortempcustom1' => { 43 => 0x45 },
	'colortempcustom2' => { 43 => 0x4a },
	'colortempdaylight' => { 41 => 0x18, 42 => 0x27, 43 => 0x27, 44 => 0x9a, 45 => 0xd1, 46 => 0x72, 47 => 0x2b, 48 => 0x52, 51 => 0x6b, 52 => 0x84, 53 => 0x89, 54 => 0x8c, 395 => 0x53 },
	'colortemperature' => { 1 => 0x2d, 7 => 0x73, 8 => [0x48,0x4e], 9 => 0xc0, 10 => 0x37, 11 => 0x62, 12 => 0x37, 13 => 0x7c, 14 => 0x73, 15 => 0x73, 16 => 0x77, 17 => 0x73, 18 => 0x7c, 19 => 0x58, 20 => 0x73, 21 => 0xc0, 22 => 0x7f, 23 => 0x7d, 24 => 0xc0, 25 => 0xc6, 26 => 0xc7, 27 => 0x135, 28 => 0x7b, 29 => 0x13a, 69 => 0xae, 79 => 0x9, 103 => 0x10ae, 133 => 0x1005, 145 => 0x846, 163 => 'ColorTemperature', 189 => [0x6e,0x49], 190 => 0x3f, 191 => [0x39,0x5e], 193 => 0x10b, 196 => [0x3c,0x4c,0x4e], 353 => 0x321, 395 => 0x50, 429 => 0x1308, 463 => 0xb021, 528 => 'Temperature', 530 => 'Temperature' },
	'colortemperatureadj' => { 500 => 0x8013 },
	'colortemperatureauto' => { 246 => 0x4f },
	'colortemperaturebg' => { 339 => 0x1013 },
	'colortemperaturecustom' => { 449 => 0xc, 450 => 0xb },
	'colortemperaturerg' => { 339 => 0x1014 },
	'colortemperatureset' => { 449 => 0x7, 450 => 0x6 },
	'colortemperaturesetting' => { 191 => 0x25, 451 => 0x17, 468 => 0xe },
	'colortempflash' => { 41 => 0x36, 42 => 0x57, 43 => 0x40, 44 => 0xb8, 45 => 0xef, 46 => 0x8b, 47 => 0x49, 48 => 0x70, 51 => 0x89, 52 => 0xa2, 53 => 0xa7, 54 => 0xaa, 395 => 0x5a },
	'colortempflashdata' => { 48 => 0x24a },
	'colortempfluorescent' => { 41 => 0x2c, 42 => 0x47, 43 => 0x3b, 44 => 0xae, 45 => 0xe5, 46 => 0x86, 47 => 0x3f, 48 => 0x66, 51 => 0x7f, 52 => 0x98, 53 => 0x9d, 54 => 0xa0 },
	'colortempfluorescentd' => { 395 => 0x57 },
	'colortempfluorescentn' => { 395 => 0x58 },
	'colortempfluorescentw' => { 395 => 0x59 },
	'colortempkelvin' => { 41 => 0x31, 42 => 0x4f, 44 => 0xb3, 45 => 0xea, 47 => 0x44, 48 => 0x6b, 51 => 0x84, 52 => 0x9d, 53 => 0xa2, 54 => 0xa5, 358 => 0x44, 429 => 0x1307 },
	'colortempmeasured' => { 41 => 0xe, 42 => 0x17, 44 => 0x63, 45 => 0x77, 48 => 0x4d, 51 => 0x4d, 52 => 0x4d, 53 => 0x4d, 54 => 0x55 },
	'colortemppc1' => { 47 => 0x94, 48 => 0x75 },
	'colortemppc2' => { 47 => 0x99, 48 => 0x7a },
	'colortemppc3' => { 47 => 0x9e, 48 => 0x7f },
	'colortempshade' => { 41 => 0x1d, 42 => 0x2f, 43 => 0x2c, 44 => 0x9f, 45 => 0xd6, 46 => 0x77, 47 => 0x30, 48 => 0x57, 51 => 0x70, 52 => 0x89, 53 => 0x8e, 54 => 0x91, 395 => 0x54 },
	'colortemptungsten' => { 41 => 0x27, 42 => 0x3f, 43 => 0x36, 44 => 0xa9, 45 => 0xe0, 46 => 0x81, 47 => 0x3a, 48 => 0x61, 51 => 0x7a, 52 => 0x93, 53 => 0x98, 54 => 0x9b, 395 => 0x56 },
	'colortempunknown' => { 41 => 0x13, 42 => 0x1f, 44 => 0x68, 45 => 0x7c, 47 => 0x21, 51 => 0x52, 52 => 0x52, 53 => 0x52, 54 => 0x5a },
	'colortempunknown10' => { 41 => 0x63, 42 => 0x9f, 44 => 0x95, 45 => 0xa9, 46 => 0xb8, 47 => 0x76, 51 => 0xa2, 52 => 0x7f, 53 => 0x7f, 54 => 0x87 },
	'colortempunknown11' => { 41 => 0x68, 42 => 0xa7, 44 => 0xbd, 45 => [0xae,0xb3], 46 => 0xbd, 47 => 0x7b, 51 => 0xa7, 52 => 0xa7, 53 => 0x84, 54 => 0xaf },
	'colortempunknown12' => { 41 => 0x6d, 42 => 0xaf, 44 => 0xc2, 45 => 0xb8, 46 => 0xc2, 47 => 0x80, 51 => 0xac, 52 => 0xac, 53 => 0xac, 54 => 0xb4 },
	'colortempunknown13' => { 41 => 0x72, 42 => 0xb7, 44 => 0xc7, 45 => 0xbd, 46 => 0xc7, 47 => 0x85, 51 => 0xb1, 52 => 0xb1, 53 => 0xb1, 54 => 0xb9 },
	'colortempunknown14' => { 44 => 0xcc, 45 => 0xc2, 46 => 0xcc, 47 => 0x8a, 51 => 0xb6, 52 => 0xb6, 53 => 0xb6, 54 => 0xbe },
	'colortempunknown15' => { 44 => 0xd1, 45 => 0xc7, 46 => 0xd1, 47 => 0x8f, 51 => 0xbb, 52 => 0xbb, 53 => 0xbb, 54 => 0xc3 },
	'colortempunknown16' => { 44 => 0xd6, 45 => 0xcc, 46 => 0xd6, 47 => 0xa3, 52 => 0xc0, 53 => 0xc0, 54 => 0xc8 },
	'colortempunknown17' => { 44 => 0xdb, 45 => 0xf4, 46 => 0xdb, 52 => 0xc5, 53 => 0xc5, 54 => 0xcd },
	'colortempunknown18' => { 44 => 0xe0, 45 => 0xf9, 46 => 0xe0, 52 => 0xca, 53 => 0xca, 54 => 0xd2 },
	'colortempunknown19' => { 44 => 0xe5, 45 => 0xfe, 46 => 0xe5, 52 => 0xcf, 53 => 0xcf, 54 => 0xd7 },
	'colortempunknown2' => { 41 => 0x3b, 42 => 0x5f, 44 => 0x6d, 45 => 0x81, 46 => 0x90, 47 => 0x4e, 51 => 0x57, 52 => 0x57, 53 => 0x57, 54 => 0x5f },
	'colortempunknown20' => { 44 => 0xea, 45 => 0x103, 46 => 0xea, 52 => 0xd4, 53 => 0xd4, 54 => 0xdc },
	'colortempunknown21' => { 44 => 0xef, 45 => 0x108, 46 => 0xef, 53 => 0xd9, 54 => 0xe1 },
	'colortempunknown22' => { 44 => 0xf4, 45 => 0x10d, 46 => 0xf4, 53 => 0xde, 54 => 0xe6 },
	'colortempunknown23' => { 44 => 0xf9, 45 => 0x112, 46 => 0xf9, 53 => 0xe3, 54 => 0xeb },
	'colortempunknown24' => { 44 => 0xfe, 45 => 0x117, 46 => 0xfe, 53 => 0xe8, 54 => 0xf0 },
	'colortempunknown25' => { 44 => 0x103, 45 => 0x11c, 46 => 0x103, 53 => 0xed, 54 => 0xf5 },
	'colortempunknown26' => { 44 => 0x108, 45 => 0x121, 46 => 0x108, 53 => 0xf2, 54 => 0xfa },
	'colortempunknown27' => { 44 => 0x10d, 45 => 0x126, 46 => 0x10d, 53 => 0xf7, 54 => 0xff },
	'colortempunknown28' => { 44 => 0x112, 46 => 0x112, 53 => 0xfc, 54 => 0x104 },
	'colortempunknown29' => { 44 => 0x117, 46 => 0x117, 53 => 0x101, 54 => 0x109 },
	'colortempunknown3' => { 41 => 0x40, 42 => 0x67, 44 => 0x72, 45 => 0x86, 46 => 0x95, 47 => 0x53, 51 => 0x5c, 52 => 0x5c, 53 => 0x5c, 54 => 0x64 },
	'colortempunknown30' => { 46 => 0x11c, 53 => 0x106 },
	'colortempunknown31' => { 46 => 0x121 },
	'colortempunknown32' => { 46 => 0x126 },
	'colortempunknown33' => { 46 => 0x12b },
	'colortempunknown4' => { 41 => 0x45, 42 => 0x6f, 44 => 0x77, 45 => 0x8b, 46 => 0x9a, 47 => 0x58, 51 => 0x61, 52 => 0x61, 53 => 0x61, 54 => 0x69 },
	'colortempunknown5' => { 41 => 0x4a, 42 => 0x77, 44 => 0x7c, 45 => 0x90, 46 => 0x9f, 47 => 0x5d, 51 => 0x66, 52 => 0x66, 53 => 0x66, 54 => 0x6e },
	'colortempunknown6' => { 41 => 0x4f, 42 => 0x7f, 44 => 0x81, 45 => 0x95, 46 => 0xa4, 47 => 0x62, 51 => 0x8e, 52 => 0x6b, 53 => 0x6b, 54 => 0x73 },
	'colortempunknown7' => { 41 => 0x54, 42 => 0x87, 44 => 0x86, 45 => 0x9a, 46 => 0xa9, 47 => 0x67, 51 => 0x93, 52 => 0x70, 53 => 0x70, 54 => 0x78 },
	'colortempunknown8' => { 41 => 0x59, 42 => 0x8f, 44 => 0x8b, 45 => 0x9f, 46 => 0xae, 47 => 0x6c, 51 => 0x98, 52 => 0x75, 53 => 0x75, 54 => 0x7d },
	'colortempunknown9' => { 41 => 0x5e, 42 => 0x97, 44 => 0x90, 45 => 0xa4, 46 => 0xb3, 47 => 0x71, 51 => 0x9d, 52 => 0x7a, 53 => 0x7a, 54 => 0x82 },
	'colortint' => { 357 => 0x35c },
	'colortone' => { 10 => 0x6f, 12 => 0x77, 37 => 0x2a, 55 => 0x2, 68 => 0x8 },
	'colortoneadj' => { 109 => 0x20304, 114 => 0x11e },
	'colortoneauto' => { 76 => 0x9c },
	'colortonefaithful' => { 19 => 0x107, 75 => 0x6c, 76 => 0x6c },
	'colortonelandscape' => { 19 => 0x105, 75 => 0x3c, 76 => 0x3c },
	'colortonemonochrome' => { 75 => 0x84, 76 => 0x84 },
	'colortoneneutral' => { 19 => 0x106, 75 => 0x54, 76 => 0x54 },
	'colortoneportrait' => { 19 => 0x104, 75 => 0x24, 76 => 0x24 },
	'colortonestandard' => { 19 => 0x103, 75 => 0xc, 76 => 0xc },
	'colortoneuserdef1' => { 19 => 0x109, 75 => 0x9c, 76 => 0xb4 },
	'colortoneuserdef2' => { 19 => 0x10a, 75 => 0xb4, 76 => 0xcc },
	'colortoneuserdef3' => { 19 => 0x10b, 75 => 0xcc, 76 => 0xe4 },
	'columninterleavefactor' => { 125 => 0xcd43 },
	'comlenblksize' => { 145 => 0xfde8 },
	'commanddialframeadvancezoom' => { 257 => 0x804 },
	'commanddialplaybackmode' => { 330 => 0x1cb, 331 => 0x1cb, 332 => 0x1e3 },
	'commanddials' => { 324 => '5.1' },
	'commanddialsaperturesetting' => { 313 => '17.3', 314 => '18.3', 316 => '18.3', 317 => '18.3', 322 => '33.3', 323 => '17.3', 326 => '18.3', 327 => '18.3' },
	'commanddialschangemainsub' => { 313 => '17.2', 314 => '18.1', 316 => '18.1', 317 => '18.1', 322 => '33.2', 323 => '17.2', 326 => '18.1', 327 => '18.1' },
	'commanddialsmenuandplayback' => { 313 => '17.4', 314 => '18.2', 316 => '18.2', 317 => '18.2', 322 => '33.4', 323 => '17.4', 326 => '18.2', 327 => '18.2' },
	'commanddialsreverserotation' => { 313 => '17.1', 314 => '6.4', 316 => '6.2', 317 => '6.2', 318 => '16.2', 319 => '17.2', 322 => '33.1', 323 => '17.1', 326 => '6.2', 327 => '6.2', 328 => '18.1' },
	'commanddialvideoplaybackmode' => { 330 => 0x1cd, 332 => 0x1e5 },
	'commanderchannel' => { 324 => '10.2', 325 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 324 => '13.1', 325 => '31.1' },
	'commandergroupa_ttlcomp' => { 328 => '32.1' },
	'commandergroupamanualoutput' => { 324 => '13.2', 325 => '28.2' },
	'commandergroupamode' => { 324 => '11.2', 325 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 324 => '14.1', 325 => '32.1' },
	'commandergroupb_ttlcomp' => { 328 => '33.1' },
	'commandergroupbmanualoutput' => { 324 => '14.2', 325 => '29.2' },
	'commandergroupbmode' => { 324 => '11.3', 325 => '29.1' },
	'commanderinternalflash' => { 324 => '11.1', 325 => '27.1' },
	'commanderinternalmanualoutput' => { 324 => '12.2', 325 => '27.2' },
	'commanderinternalttlchannel' => { 322 => '18.2' },
	'commanderinternalttlcomp' => { 324 => '12.1', 325 => '30.2', 328 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 322 => '20.1', 323 => '26.1' },
	'commanderinternalttlcompgroupa' => { 322 => '21.1', 323 => '27.1' },
	'commanderinternalttlcompgroupb' => { 322 => '22.1', 323 => '28.1' },
	'comment' => { 0 => 0x2, 126 => 'Comment', 164 => 'Comment', 347 => 'Comment', 413 => "\xa9cmt", 415 => 'comment', 421 => "\xa9cmt" },
	'compass' => { 432 => 0x4 },
	'compatiblebrands' => { 415 => 'compatible_brands' },
	'compatibleversion' => { 528 => 'CompatibleVersion', 530 => 'CompatibleVersion' },
	'compilation' => { 413 => 'cpil' },
	'compimageimagespersequence' => { 535 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfImagesInSequences'] },
	'compimagemaxexposureall' => { 535 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfAll'] },
	'compimagemaxexposureused' => { 535 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfUsed'] },
	'compimageminexposureall' => { 535 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfAll'] },
	'compimageminexposureused' => { 535 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfUsed'] },
	'compimagenumsequences' => { 535 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfSequences'] },
	'compimagesumexposureall' => { 535 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfAll'] },
	'compimagesumexposureused' => { 535 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfUsed'] },
	'compimagetotalexposureperiod' => { 535 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesTotalExposurePeriod'] },
	'compimagevalues' => { 535 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesValues'] },
	'complianceprofile' => { 548 => 'complianceProfile' },
	'componentsconfiguration' => { 125 => 0x9101, 169 => 'Components', 534 => 'ComponentsConfiguration' },
	'componentversion' => { 103 => 0x80c },
	'composer' => { 186 => 'WM/Composer', 413 => ["\xa9com","\xa9wrt"], 421 => ["\xa9com","\xa9wrt"], 558 => 'composer' },
	'composerid' => { 413 => 'cmID' },
	'composerkeywords' => { 421 => "\xa9cok" },
	'compositeimage' => { 125 => 0xa460, 535 => 'CompositeImage' },
	'compositeimagecount' => { 125 => 0xa461, 535 => 'CompositeImageCount' },
	'compositeimageexposuretimes' => { 125 => 0xa462, 535 => 'CompositeImageExposureTimes' },
	'composition' => { 516 => 'Composition' },
	'compositionadjust' => { 393 => '0.1' },
	'compositionadjustrotation' => { 393 => 0x7 },
	'compositionadjustx' => { 393 => 0x5 },
	'compositionadjusty' => { 393 => 0x6 },
	'compressedbitsperpixel' => { 125 => 0x9102, 534 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 193 => 0x40, 339 => 0x40 },
	'compression' => { 125 => 0x103, 363 => 0xb, 554 => 'Compression' },
	'compressionfactor' => { 334 => 0x50d },
	'compressionformat' => { 68 => 0x4 },
	'compressionratio' => { 169 => 'Compression', 339 => 0x1034 },
	'compressorversion' => { 421 => 'CNCV' },
	'condadobvfactor' => { 145 => 0xf3e },
	'condadodaybvthresh' => { 145 => 0xf3c },
	'condadodayoffsets' => { 145 => 0xf42 },
	'condadofluoffsets' => { 145 => 0xf44 },
	'condadofluthresh' => { 145 => 0xf41 },
	'condadoillfactor' => { 145 => 0xf3f },
	'condadoneurange' => { 145 => 0xf3d },
	'condadotunoffsets' => { 145 => 0xf43 },
	'condadotunthresh' => { 145 => 0xf40 },
	'conductor' => { 186 => 'WM/Conductor', 413 => "\xa9con" },
	'confidence' => { 511 => 'Confidence' },
	'confidencelevel' => { 524 => 'ConfidenceLevel' },
	'confidencemime' => { 511 => 'ConfidenceMime' },
	'constrainedcropheight' => { 114 => 0x266, 406 => 0xd6 },
	'constrainedcropwidth' => { 114 => 0x262, 406 => 0xd5 },
	'contact' => { 138 => 0x76 },
	'contactinfo' => { 528 => 'ContactInfo', 530 => 'ContactInfo', 547 => 'contactInfo' },
	'container' => { 504 => 'Container' },
	'containerdirectory' => { 504 => [\'Container','ContainerDirectory'], 509 => 'Directory' },
	'containerdirectoryitem' => { 504 => [\'Container','ContainerDirectoryItem'] },
	'containerdirectoryitemdatauri' => { 504 => [\'Container','ContainerDirectoryItemDataURI'] },
	'containerdirectoryitemlength' => { 504 => [\'Container','ContainerDirectoryItemLength'] },
	'containerdirectoryitemmime' => { 504 => [\'Container','ContainerDirectoryItemMime'] },
	'containerdirectoryitempadding' => { 504 => [\'Container','ContainerDirectoryItemPadding'] },
	'containerformat' => { 542 => 'ContainerFormat' },
	'containerformatidentifier' => { 542 => [\'ContainerFormat','ContainerFormatIdentifier'] },
	'containerformatname' => { 542 => [\'ContainerFormat','ContainerFormatName'] },
	'contentcreatedate' => { 413 => "\xa9day", 421 => ['@day',"\xa9day"] },
	'contentdistributor' => { 186 => 'WM/ContentDistributor' },
	'contentdistributorid' => { 421 => 'cdis' },
	'contentid' => { 421 => 'ccid' },
	'contentidentifier' => { 1 => 0x11, 415 => 'content.identifier' },
	'contentlocationcode' => { 138 => 0x1a },
	'contentlocationname' => { 138 => 0x1b },
	'contenttype' => { 548 => 'contentType' },
	'continuousbracketing' => { 191 => 0x20 },
	'continuousdrive' => { 37 => 0x5 },
	'continuousmodedisplay' => { 329 => 0x55, 330 => 0x51, 331 => 0x51, 332 => 0x51 },
	'continuousmodeliveview' => { 327 => '77.2' },
	'continuousshootingspeed' => { 90 => 0x610 },
	'continuousshotlimit' => { 90 => 0x611 },
	'contrast' => { 10 => 0x73, 12 => 0x75, 37 => 0xd, 118 => 0xc, 119 => [0x3012,0x20], 125 => [0xa408,0xfe54], 133 => [0x1004,0x1006], 163 => 'Contrast', 183 => 'Contrast', 188 => 0x20, 189 => 0x31, 190 => 0x27, 191 => 0x19, 196 => 0x2, 264 => 0x33, 265 => 0x37, 266 => 0x3f, 339 => 0x1029, 358 => 0x39, 360 => 0x300a, 395 => 0x20, 402 => 0xc, 415 => 'player.movie.visual.contrast', 423 => 0x24, 425 => 0x52, 429 => 0x1012, 439 => 0xd, 449 => 0x1d, 450 => 0x1a, 463 => 0x2004, 528 => 'Contrast', 530 => 'Contrast', 534 => 'Contrast' },
	'contrast2012' => { 528 => 'Contrast2012', 530 => 'Contrast2012' },
	'contrastadj' => { 109 => 0x20303, 114 => 0x115, 309 => 0x2c, 500 => 0x8017 },
	'contrastauto' => { 76 => 0x90 },
	'contrastcurve' => { 246 => 0x8c },
	'contrastdetectafarea' => { 395 => 0x231 },
	'contrastdetectafinfocus' => { 200 => 0x1c, 201 => [0x1c,0x52] },
	'contrastfaithful' => { 19 => 0xec, 75 => 0x60, 76 => 0x60 },
	'contrasthighlight' => { 395 => 0x6d },
	'contrasthighlightshadowadj' => { 395 => 0x6f },
	'contrastlandscape' => { 19 => 0xea, 75 => 0x30, 76 => 0x30 },
	'contrastmode' => { 358 => 0x2c },
	'contrastmonochrome' => { 19 => 0xed, 75 => 0x78, 76 => 0x78 },
	'contrastneutral' => { 19 => 0xeb, 75 => 0x48, 76 => 0x48 },
	'contrastportrait' => { 19 => 0xe9, 75 => 0x18, 76 => 0x18 },
	'contrastsetting' => { 334 => 0x505, 342 => 0x1012, 451 => 0x10, 468 => 0x8 },
	'contrastshadow' => { 395 => 0x6e },
	'contraststandard' => { 19 => 0xe8, 75 => 0x0, 76 => 0x0 },
	'contrastuserdef1' => { 19 => 0xee, 75 => 0x90, 76 => 0xa8 },
	'contrastuserdef2' => { 19 => 0xef, 75 => 0xa8, 76 => 0xc0 },
	'contrastuserdef3' => { 19 => 0xf0, 75 => 0xc0, 76 => 0xd8 },
	'contributedmedia' => { 558 => 'contributedMedia' },
	'contributedmediaduration' => { 558 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 558 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 558 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 558 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 558 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 558 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 558 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 558 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 558 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 558 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 531 => 'contributor', 542 => 'Contributor' },
	'contributoridentifier' => { 542 => [\'Contributor','ContributorIdentifier'] },
	'contributorname' => { 542 => [\'Contributor','ContributorName'] },
	'contributorrole' => { 542 => [\'Contributor','ContributorRole'] },
	'contributors' => { 164 => 'Contributors' },
	'controldialset' => { 191 => 0x46 },
	'controlledvocabularyterm' => { 542 => 'CVterm' },
	'controllerboardversion' => { 353 => 0x332 },
	'controlmode' => { 82 => 0x12 },
	'controlringresponse' => { 329 => 0x1cf, 330 => 0x1d5, 331 => 0x1d5, 332 => 0x1ed },
	'controlringrotation' => { 90 => 0x712 },
	'conversionlens' => { 335 => 0x403, 358 => 0x35 },
	'converter' => { 125 => 0xfe4d, 295 => 0xb, 528 => 'Converter', 530 => 'Converter' },
	'converttograyscale' => { 528 => 'ConvertToGrayscale', 530 => 'ConvertToGrayscale' },
	'cookingequipment' => { 550 => 'cookingEquipment' },
	'cookingmethod' => { 550 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 125 => 0x8298, 164 => 'Copyright', 347 => 'Copyright', 363 => 0x8298, 395 => 0x22f, 411 => 'Copyright', 413 => ['cprt',"\xa9cpy"], 415 => 'copyright', 421 => ['cprt',"\xa9cpy"], 528 => 'Copyright', 530 => 'Copyright', 544 => 'Copyright', 551 => 'copyright', 554 => 'Copyright', 558 => 'copyright' },
	'copyrightflag' => { 409 => 0x40a },
	'copyrightnotice' => { 138 => 0x74 },
	'copyrightowner' => { 344 => 'CopyrightOwner' },
	'copyrightownerid' => { 344 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 344 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 344 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 344 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 344 => 'CopyrightStatus' },
	'copyrightyear' => { 542 => 'CopyrightYear', 548 => 'copyrightYear' },
	'coringfilter' => { 338 => 0x310, 339 => 0x102d, 342 => 0x310 },
	'coringvalues' => { 338 => 0x311, 342 => 0x311 },
	'corporateentity' => { 548 => 'corporateEntity' },
	'correctionalreadyapplied' => { 348 => 'CorrectionAlreadyApplied' },
	'correlatedcolortemp' => { 357 => 0x35b },
	'country' => { 168 => 'Country', 358 => 0x69, 546 => 'Country' },
	'country-primarylocationcode' => { 138 => 0x64 },
	'country-primarylocationname' => { 138 => 0x65 },
	'countrycode' => { 245 => 0x5, 407 => 'CountryCode', 541 => 'CountryCode' },
	'course' => { 550 => 'course' },
	'coverage' => { 531 => 'coverage' },
	'coverart' => { 413 => 'covr' },
	'coverdate' => { 548 => 'coverDate' },
	'coverdisplaydate' => { 548 => 'coverDisplayDate' },
	'coveruri' => { 421 => 'cvru' },
	'cpufirmwareversion' => { 395 => 0x28 },
	'crc32' => { 532 => 'crc32' },
	'createdate' => { 125 => 0x9004, 164 => 'CreateDate', 343 => 'CreationDate', 347 => 'create-date', 411 => 'CreationDate', 418 => 0x1, 556 => 'CreateDate' },
	'creationdate' => { 415 => 'creationdate', 544 => 'CreationDate', 548 => 'creationDate' },
	'creationtime' => { 347 => 'Creation Time', 415 => 'creation_time' },
	'creativestyle' => { 449 => 0x1a, 450 => 0x18, 460 => 0x41, 463 => 0xb020, 495 => 0x4a },
	'creativestylesetting' => { 451 => 0xf, 468 => 0x7 },
	'creativestylewaschanged' => { 500 => 0x8001 },
	'creator' => { 343 => 'Creator', 411 => 'Creator', 531 => 'creator', 542 => 'Creator', 544 => 'Creator' },
	'creatoraddress' => { 541 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 185 => 'CreatorAppId' },
	'creatorcity' => { 541 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 541 => 'CreatorContactInfo' },
	'creatorcountry' => { 541 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoridentifier' => { 542 => [\'Creator','CreatorIdentifier'] },
	'creatoridentity' => { 407 => 'CreatorIdentity' },
	'creatorname' => { 542 => [\'Creator','CreatorName'] },
	'creatoropenwithuioptions' => { 185 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 541 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 541 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatorrole' => { 542 => [\'Creator','CreatorRole'] },
	'creatortool' => { 556 => 'CreatorTool' },
	'creatorworkemail' => { 541 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 541 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 541 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 138 => 0x6e, 546 => 'Credit' },
	'creditline' => { 551 => 'creditLine' },
	'creditlinereq' => { 561 => 'CreditLineReq' },
	'creditlinerequired' => { 344 => 'CreditLineRequired' },
	'cropactive' => { 107 => 0x0, 114 => 0x244 },
	'cropangle' => { 107 => 0x8, 528 => 'CropAngle', 530 => 'CropAngle' },
	'croparea' => { 246 => 0x45, 500 => 0x9011 },
	'cropaspectratio' => { 109 => 0x30101, 114 => 0x260 },
	'cropaspectratiocustom' => { 109 => 0x30102 },
	'cropbottom' => { 129 => 0x9, 301 => 0x36, 363 => 0x31, 406 => 0xdc, 528 => 'CropBottom', 530 => 'CropBottom' },
	'cropbottommargin' => { 57 => 0x3 },
	'cropcircleactive' => { 115 => 0xd6 },
	'cropcircleradius' => { 115 => 0xd9 },
	'cropcirclex' => { 115 => 0xd7 },
	'cropcircley' => { 115 => 0xd8 },
	'cropconstraintowarp' => { 528 => 'CropConstrainToWarp', 530 => 'CropConstrainToWarp' },
	'cropflag' => { 133 => 0x1051 },
	'croph' => { 521 => 'CropH' },
	'cropheight' => { 107 => 0x6, 114 => 0x24c, 338 => 0x615, 342 => 0x615, 528 => 'CropHeight', 530 => 'CropHeight' },
	'crophispeed' => { 246 => 0x1b },
	'cropleft' => { 114 => 0x246, 129 => 0x6, 301 => 0x1e, 338 => 0x612, 342 => 0x612, 363 => 0x30, 406 => 0xd9, 528 => 'CropLeft', 530 => 'CropLeft' },
	'cropleftmargin' => { 57 => 0x0 },
	'cropmode' => { 133 => 0x104d, 429 => 0x1018 },
	'croporiginalheight' => { 107 => 0xb },
	'croporiginalwidth' => { 107 => 0xa },
	'cropoutputheight' => { 301 => 0xce },
	'cropoutputheightinches' => { 301 => 0x96 },
	'cropoutputpixels' => { 301 => 0xd6 },
	'cropoutputresolution' => { 301 => 0xb6 },
	'cropoutputscale' => { 301 => 0xbe },
	'cropoutputwidth' => { 301 => 0xc6 },
	'cropoutputwidthinches' => { 301 => 0x8e },
	'croppedareaimageheightpixels' => { 514 => 'CroppedAreaImageHeightPixels', 515 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 514 => 'CroppedAreaImageWidthPixels', 515 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 514 => 'CroppedAreaLeftPixels', 515 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 514 => 'CroppedAreaTopPixels', 515 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 429 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 429 => 0x1603 },
	'cropping' => { 500 => 0x9010 },
	'cropright' => { 129 => 0x8, 301 => 0x2e, 363 => 0x32, 406 => 0xdb, 528 => 'CropRight', 530 => 'CropRight' },
	'croprightmargin' => { 57 => 0x1 },
	'croprotatedoriginalheight' => { 107 => 0x2 },
	'croprotatedoriginalwidth' => { 107 => 0x1 },
	'croprotation' => { 107 => 0x7, 129 => 0xb },
	'cropscaledresolution' => { 301 => 0x9e },
	'cropsize' => { 133 => 0x1053 },
	'cropsourceresolution' => { 301 => 0xae },
	'croptop' => { 114 => 0x248, 129 => 0x7, 301 => 0x26, 338 => 0x613, 342 => 0x613, 363 => 0x2f, 406 => 0xda, 528 => 'CropTop', 530 => 'CropTop' },
	'croptopleft' => { 133 => 0x1052 },
	'croptopmargin' => { 57 => 0x2 },
	'cropunit' => { 528 => 'CropUnit', 530 => 'CropUnit' },
	'cropunits' => { 528 => 'CropUnits', 530 => 'CropUnits' },
	'cropw' => { 521 => 'CropW' },
	'cropwidth' => { 107 => 0x5, 114 => 0x24a, 338 => 0x614, 342 => 0x614, 528 => 'CropWidth', 530 => 'CropWidth' },
	'cropx' => { 107 => 0x3, 521 => 'CropX' },
	'cropy' => { 107 => 0x4, 521 => 'CropY' },
	'crossprocess' => { 395 => 0x7b },
	'crossprocessparams' => { 395 => 0x235 },
	'cuisine' => { 550 => 'cuisine' },
	'currenticcprofile' => { 125 => 0xc691 },
	'currentpreprofilematrix' => { 125 => 0xc692 },
	'currentversion' => { 500 => 0xd000 },
	'curve0x' => { 521 => 'Curve0x' },
	'curve0y' => { 521 => 'Curve0y' },
	'curve1x' => { 521 => 'Curve1x' },
	'curve1y' => { 521 => 'Curve1y' },
	'curve2x' => { 521 => 'Curve2x' },
	'curve2y' => { 521 => 'Curve2y' },
	'curve3x' => { 521 => 'Curve3x' },
	'curve3y' => { 521 => 'Curve3y' },
	'curve4x' => { 521 => 'Curve4x' },
	'curve4y' => { 521 => 'Curve4y' },
	'curves' => { 306 => 0x76a43201 },
	'custom1' => { 344 => 'Custom1' },
	'custom10' => { 344 => 'Custom10' },
	'custom2' => { 344 => 'Custom2' },
	'custom3' => { 344 => 'Custom3' },
	'custom4' => { 344 => 'Custom4' },
	'custom5' => { 344 => 'Custom5' },
	'custom6' => { 344 => 'Custom6' },
	'custom7' => { 344 => 'Custom7' },
	'custom8' => { 344 => 'Custom8' },
	'custom9' => { 344 => 'Custom9' },
	'customcolortone' => { 115 => 0x4c },
	'customcontrast' => { 115 => 0x4e },
	'customcontrols' => { 90 => 0x70c },
	'customdefaultunsharpfineness' => { 115 => 0xbe },
	'customdefaultunsharpstrength' => { 115 => 0xbc },
	'customdefaultunsharpthreshold' => { 115 => 0xc0 },
	'customilluminant' => { 145 => 0x405 },
	'customizedials' => { 90 => 0x715 },
	'customlinear' => { 115 => 0x4f },
	'customoutputhighlightpoint' => { 115 => 0x53 },
	'customoutputshadowpoint' => { 115 => 0x54 },
	'custompicturestyle' => { 109 => 0x10021 },
	'custompicturestyledata' => { 109 => 0xf0500 },
	'custompicturestylefilename' => { 69 => 0x4010 },
	'customrawhighlight' => { 115 => 0x7c },
	'customrawhighlightpoint' => { 115 => 0x51 },
	'customrawshadow' => { 115 => 0x85 },
	'customrawshadowpoint' => { 115 => 0x52 },
	'customrendered' => { 125 => 0xa401, 198 => 0x6420, 534 => 'CustomRendered' },
	'customsaturation' => { 115 => 0x4d, 334 => 0x503 },
	'customsettingsalldefault' => { 313 => '0.2', 322 => '0.2' },
	'customsettingsbank' => { 313 => '0.1', 314 => '0.1', 316 => '0.1', 317 => '0.1', 322 => '0.1', 326 => '0.2', 327 => '0.2', 330 => 0x1, 331 => 0x1, 332 => 0x1 },
	'customsharpness' => { 115 => 0x50 },
	'customunsharpmaskfineness' => { 115 => 0xb8 },
	'customunsharpmaskstrength' => { 115 => 0xb6 },
	'customunsharpmaskthreshold' => { 115 => 0xba },
	'customwb_rblevels' => { 468 => 0x1a },
	'customwb_rgblevels' => { 450 => 0x8, 451 => 0x19 },
	'customwbbluelevel' => { 191 => 0x36 },
	'customwberror' => { 191 => 0x37 },
	'customwbgreenlevel' => { 191 => 0x35 },
	'customwbredlevel' => { 191 => 0x34 },
	'customwbsetting' => { 191 => 0x26 },
	'cx' => { 421 => '_cx_' },
	'cy' => { 421 => '_cy_' },
	'd-lightinghq' => { 306 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 302 => 0x2 },
	'd-lightinghqhighlight' => { 302 => 0x1 },
	'd-lightinghqselected' => { 306 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 302 => 0x0 },
	'd-lightinghs' => { 306 => 0xce5554aa },
	'd-lightinghsadjustment' => { 303 => 0x0 },
	'd-lightinghscolorboost' => { 303 => 0x1 },
	'd-rangeoptimizerhighlight' => { 500 => 0x8024 },
	'd-rangeoptimizermode' => { 500 => 0x8022 },
	'd-rangeoptimizershadow' => { 500 => 0x802d },
	'd-rangeoptimizervalue' => { 500 => 0x8023 },
	'darkblacksegrows' => { 145 => 0x18d8 },
	'darkfocusenvironment' => { 358 => 0x8003 },
	'darkframecountfactor' => { 145 => 0xc85 },
	'darkframelongexposure' => { 145 => 0xc84 },
	'darkframeshortexposure' => { 145 => 0xc83 },
	'darkpedestal' => { 145 => 0xc7f },
	'datacompressionmethod' => { 140 => 0x6e },
	'dataimprint' => { 188 => 0x34 },
	'datamining' => { 344 => 'DataMining' },
	'dataonscreen' => { 542 => 'DataOnScreen' },
	'dataonscreenregion' => { 542 => [\'DataOnScreen','DataOnScreenRegion'] },
	'dataonscreenregiond' => { 542 => [\'DataOnScreen','DataOnScreenRegionD'] },
	'dataonscreenregionh' => { 542 => [\'DataOnScreen','DataOnScreenRegionH'] },
	'dataonscreenregiontext' => { 542 => [\'DataOnScreen','DataOnScreenRegionText'] },
	'dataonscreenregionunit' => { 542 => [\'DataOnScreen','DataOnScreenRegionUnit'] },
	'dataonscreenregionw' => { 542 => [\'DataOnScreen','DataOnScreenRegionW'] },
	'dataonscreenregionx' => { 542 => [\'DataOnScreen','DataOnScreenRegionX'] },
	'dataonscreenregiony' => { 542 => [\'DataOnScreen','DataOnScreenRegionY'] },
	'datascaling' => { 395 => 0x3d },
	'date' => { 395 => 0x6, 531 => 'date' },
	'dateacquired' => { 185 => 'DateAcquired', 186 => '{2CBAA8F5-D81F-47CA-B17A-F8D822300131} 100' },
	'datecreated' => { 138 => 0x37, 546 => 'DateCreated' },
	'datedisplayformat' => { 298 => 0x3 },
	'dateidentified' => { 124 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 318 => '4.2' },
	'daterecieved' => { 548 => 'dateRecieved' },
	'datesent' => { 139 => 0x46 },
	'datestampmode' => { 69 => 0x1c, 246 => 0x9d },
	'datetime' => { 522 => 'datetime', 554 => 'DateTime' },
	'datetimedigitized' => { 534 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 106 => 0x0, 125 => 0x9003, 161 => 0x14, 164 => 'OriginalDate', 416 => 'IDIT', 421 => 'date', 423 => 0xb, 424 => 0x3b, 425 => 0x3e, 534 => 'DateTimeOriginal' },
	'datetimestamp' => { 147 => 0x64 },
	'datetimeutc' => { 334 => 0x908 },
	'daylightsavings' => { 83 => 0x3, 298 => 0x2 },
	'dayofweek' => { 424 => 0x42, 425 => 0x4a },
	'dccontinent' => { 124 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 124 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 124 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 124 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 124 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 124 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 124 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 124 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 124 => 'Event' },
	'dcfootprintspatialfit' => { 124 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 124 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 124 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 124 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 124 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 124 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 124 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 124 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 124 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 124 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 124 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 124 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 124 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 124 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 124 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 124 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 124 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 124 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 124 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 124 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 124 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 124 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 124 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 124 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 124 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 124 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 124 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 124 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 124 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 124 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 124 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 124 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 124 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 124 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 124 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 124 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcverticaldatum' => { 124 => [\'dctermsLocation','dctermsLocationVerticalDatum'] },
	'dcwaterbody' => { 124 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 172 => 'Declination' },
	'decposition' => { 188 => 0x32 },
	'defaultautogray' => { 528 => 'DefaultAutoGray', 530 => 'DefaultAutoGray' },
	'defaultautotone' => { 528 => 'DefaultAutoTone', 530 => 'DefaultAutoTone' },
	'defaultblackrender' => { 125 => 0xc7a6 },
	'defaultcroporigin' => { 125 => 0xc61f },
	'defaultcropsize' => { 125 => 0xc620 },
	'defaulteraseoption' => { 90 => 0x813 },
	'defaultscale' => { 125 => 0xc61e },
	'defaultsspecifictoiso' => { 528 => 'DefaultsSpecificToISO', 530 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 528 => 'DefaultsSpecificToSerial', 530 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 125 => 0xc7b5 },
	'defectisocode' => { 145 => 0x90f },
	'defringe' => { 528 => 'Defringe', 530 => 'Defringe' },
	'defringegreenamount' => { 528 => 'DefringeGreenAmount', 530 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 528 => 'DefringeGreenHueHi', 530 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 528 => 'DefringeGreenHueLo', 530 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 528 => 'DefringePurpleAmount', 530 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 528 => 'DefringePurpleHueHi', 530 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 528 => 'DefringePurpleHueLo', 530 => 'DefringePurpleHueLo' },
	'dehaze' => { 528 => 'Dehaze', 530 => 'Dehaze' },
	'deletedimagecount' => { 246 => 0xa6, 277 => 0x6e },
	'deprecatedon' => { 526 => 'deprecatedOn' },
	'depthbasedcorrcorrectionactive' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionActive'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionActive'] },
	'depthbasedcorrcorrectionamount' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionAmount'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionAmount'] },
	'depthbasedcorrcorrectionsyncid' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionSyncID'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionSyncID'] },
	'depthbasedcorrections' => { 528 => 'DepthBasedCorrections', 530 => 'DepthBasedCorrections' },
	'depthbasedcorrlocalcorrecteddepth' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCorrectedDepth'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCorrectedDepth'] },
	'depthbasedcorrlocalcurverefinesaturation' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCurveRefineSaturation'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCurveRefineSaturation'] },
	'depthbasedcorrmask' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasks'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasks'] },
	'depthbasedcorrmaskalpha' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAlpha'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAlpha'] },
	'depthbasedcorrmaskangle' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAngle'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAngle'] },
	'depthbasedcorrmaskbottom' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksBottom'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksBottom'] },
	'depthbasedcorrmaskcentervalue' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterValue'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterValue'] },
	'depthbasedcorrmaskcenterweight' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterWeight'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterWeight'] },
	'depthbasedcorrmaskdabs' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksDabs'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksDabs'] },
	'depthbasedcorrmaskfeather' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFeather'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFeather'] },
	'depthbasedcorrmaskflipped' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlipped'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlipped'] },
	'depthbasedcorrmaskflow' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlow'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlow'] },
	'depthbasedcorrmaskfullx' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullX'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullX'] },
	'depthbasedcorrmaskfully' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullY'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullY'] },
	'depthbasedcorrmaskinputdigest' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksInputDigest'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksInputDigest'] },
	'depthbasedcorrmaskleft' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksLeft'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksLeft'] },
	'depthbasedcorrmaskmaskactive' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskActive'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskActive'] },
	'depthbasedcorrmaskmaskblendmode' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskBlendMode'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'depthbasedcorrmaskmaskdigest' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskDigest'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskDigest'] },
	'depthbasedcorrmaskmaskinverted' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskInverted'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskInverted'] },
	'depthbasedcorrmaskmaskname' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskName'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskName'] },
	'depthbasedcorrmaskmasks' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasks'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasks'] },
	'depthbasedcorrmaskmasksalpha' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAlpha'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'depthbasedcorrmaskmasksangle' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAngle'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAngle'] },
	'depthbasedcorrmaskmasksbottom' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksBottom'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksBottom'] },
	'depthbasedcorrmaskmaskscentervalue' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterValue'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'depthbasedcorrmaskmaskscenterweight' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterWeight'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'depthbasedcorrmaskmasksdabs' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksDabs'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksDabs'] },
	'depthbasedcorrmaskmasksfeather' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFeather'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFeather'] },
	'depthbasedcorrmaskmasksflipped' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlipped'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'depthbasedcorrmaskmasksflow' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlow'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlow'] },
	'depthbasedcorrmaskmasksfullx' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullX'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullX'] },
	'depthbasedcorrmaskmasksfully' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullY'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullY'] },
	'depthbasedcorrmaskmasksinputdigest' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksInputDigest'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'depthbasedcorrmaskmasksleft' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksLeft'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksLeft'] },
	'depthbasedcorrmaskmasksmaskactive' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskActive'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'depthbasedcorrmaskmasksmaskblendmode' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'depthbasedcorrmaskmasksmaskdigest' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskDigest'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'depthbasedcorrmaskmasksmaskinverted' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskInverted'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'depthbasedcorrmaskmasksmaskname' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskName'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'depthbasedcorrmaskmasksmasksubtype' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSubType'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'depthbasedcorrmaskmasksmasksyncid' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'depthbasedcorrmaskmasksmaskversion' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskVersion'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'depthbasedcorrmaskmasksmidpoint' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMidpoint'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'depthbasedcorrmaskmasksorigin' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksOrigin'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'depthbasedcorrmaskmasksperimetervalue' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'depthbasedcorrmaskmasksradius' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRadius'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRadius'] },
	'depthbasedcorrmaskmasksreferencepoint' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksReferencePoint'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'depthbasedcorrmaskmasksright' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRight'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRight'] },
	'depthbasedcorrmaskmasksroundness' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRoundness'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'depthbasedcorrmaskmaskssizex' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeX'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'depthbasedcorrmaskmaskssizey' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeY'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'depthbasedcorrmaskmaskstop' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksTop'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksTop'] },
	'depthbasedcorrmaskmasksubtype' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSubType'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSubType'] },
	'depthbasedcorrmaskmasksvalue' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskValue'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'depthbasedcorrmaskmasksversion' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksVersion'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksVersion'] },
	'depthbasedcorrmaskmaskswhat' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWhat'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWhat'] },
	'depthbasedcorrmaskmaskswholeimagearea' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'depthbasedcorrmaskmasksx' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksX'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksX'] },
	'depthbasedcorrmaskmasksy' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksY'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksY'] },
	'depthbasedcorrmaskmasksyncid' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSyncID'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'depthbasedcorrmaskmaskszerox' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroX'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'depthbasedcorrmaskmaskszeroy' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroY'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'depthbasedcorrmaskmaskversion' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskVersion'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskVersion'] },
	'depthbasedcorrmaskmidpoint' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMidpoint'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMidpoint'] },
	'depthbasedcorrmaskorigin' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksOrigin'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksOrigin'] },
	'depthbasedcorrmaskperimetervalue' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksPerimeterValue'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'depthbasedcorrmaskradius' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRadius'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRadius'] },
	'depthbasedcorrmaskrange' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'depthbasedcorrmaskrangeareamodels' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'depthbasedcorrmaskrangeareamodelscolorsampleinfo' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'depthbasedcorrmaskrangeareamodelscomponents' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'depthbasedcorrmaskrangecoloramount' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'depthbasedcorrmaskrangedepthfeather' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'depthbasedcorrmaskrangedepthmax' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'depthbasedcorrmaskrangedepthmin' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'depthbasedcorrmaskrangeinvert' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'depthbasedcorrmaskrangelumfeather' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'depthbasedcorrmaskrangeluminancedepthsampleinfo' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'depthbasedcorrmaskrangelummax' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'depthbasedcorrmaskrangelummin' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'depthbasedcorrmaskrangelumrange' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'depthbasedcorrmaskrangesampletype' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'depthbasedcorrmaskrangetype' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'depthbasedcorrmaskrangeversion' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'depthbasedcorrmaskreferencepoint' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksReferencePoint'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksReferencePoint'] },
	'depthbasedcorrmaskright' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRight'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRight'] },
	'depthbasedcorrmaskroundness' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRoundness'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRoundness'] },
	'depthbasedcorrmasksizex' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeX'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeX'] },
	'depthbasedcorrmasksizey' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeY'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeY'] },
	'depthbasedcorrmasktop' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksTop'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksTop'] },
	'depthbasedcorrmaskvalue' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskValue'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskValue'] },
	'depthbasedcorrmaskversion' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksVersion'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksVersion'] },
	'depthbasedcorrmaskwhat' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWhat'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWhat'] },
	'depthbasedcorrmaskwholeimagearea' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWholeImageArea'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'depthbasedcorrmaskx' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksX'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksX'] },
	'depthbasedcorrmasky' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksY'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksY'] },
	'depthbasedcorrmaskzerox' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroX'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroX'] },
	'depthbasedcorrmaskzeroy' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroY'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroY'] },
	'depthbasedcorrwhat' => { 528 => [\'DepthBasedCorrections','DepthBasedCorrectionsWhat'], 530 => [\'DepthBasedCorrections','DepthBasedCorrectionsWhat'] },
	'depthfar' => { 125 => 0xc7eb },
	'depthformat' => { 125 => 0xc7e9 },
	'depthimage' => { 511 => 'Data' },
	'depthmapinfo' => { 528 => 'DepthMapInfo', 530 => 'DepthMapInfo' },
	'depthmapinfobasehighlightguideinputdigest' => { 528 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideInputDigest'], 530 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideInputDigest'] },
	'depthmapinfobasehighlightguidetable' => { 528 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideTable'], 530 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideTable'] },
	'depthmapinfobasehighlightguideversion' => { 528 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideVersion'], 530 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideVersion'] },
	'depthmapinfobaselayereddepthinputdigest' => { 528 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthInputDigest'], 530 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthInputDigest'] },
	'depthmapinfobaselayereddepthtable' => { 528 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthTable'], 530 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthTable'] },
	'depthmapinfobaselayereddepthversion' => { 528 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthVersion'], 530 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthVersion'] },
	'depthmapinfobaserawdepthinputdigest' => { 528 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthInputDigest'], 530 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthInputDigest'] },
	'depthmapinfobaserawdepthtable' => { 528 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthTable'], 530 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthTable'] },
	'depthmapinfobaserawdepthversion' => { 528 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthVersion'], 530 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthVersion'] },
	'depthmapinfodepthsource' => { 528 => [\'DepthMapInfo','DepthMapInfoDepthSource'], 530 => [\'DepthMapInfo','DepthMapInfoDepthSource'] },
	'depthmeasuretype' => { 125 => 0xc7ed },
	'depthnear' => { 125 => 0xc7ea },
	'depthunits' => { 125 => 0xc7ec },
	'derivedfrom' => { 559 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 559 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 559 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 559 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 559 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 559 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 559 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 559 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 559 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 559 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 559 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 559 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 559 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 559 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 559 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 559 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 559 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 559 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 559 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 559 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 559 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 559 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 559 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 559 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 186 => 'Description', 347 => 'Description', 413 => ['desc','dscp',"\xa9des"], 415 => 'description', 421 => 'dscp', 528 => 'Description', 530 => 'Description', 531 => 'description', 556 => 'Description' },
	'destination' => { 139 => 0x5 },
	'destinationcity' => { 395 => 0x24, 401 => 0x3 },
	'destinationcitycode' => { 402 => 0x1001 },
	'destinationdst' => { 395 => 0x26, 401 => '0.3' },
	'developmentdynamicrange' => { 133 => 0x1403 },
	'deviantmatrixcustom' => { 145 => 0x7de },
	'deviantmatrixdaylight' => { 145 => 0x7da },
	'deviantmatrixflash' => { 145 => 0x7dd },
	'deviantmatrixfluorescent' => { 145 => 0x7dc },
	'deviantmatrixtungsten' => { 145 => 0x7db },
	'deviantwhitecustom' => { 145 => 0x842 },
	'deviantwhitedaylight' => { 145 => 0x83e },
	'deviantwhiteflash' => { 145 => 0x841 },
	'deviantwhitefluorescent' => { 145 => 0x840 },
	'deviantwhitetungsten' => { 145 => 0x83f },
	'device' => { 548 => 'device' },
	'devicesettingdescription' => { 534 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 534 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 534 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 534 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 436 => 0x2 },
	'dewarpdata' => { 122 => 'DewarpData' },
	'dewarpflag' => { 122 => 'DewarpFlag' },
	'dialdirectiontvav' => { 90 => 0x706 },
	'dietaryneeds' => { 550 => 'dietaryNeeds' },
	'diffractioncompensation' => { 235 => 0x20e, 250 => 0x2ce, 251 => 0x142, 252 => 0x1b2, 255 => 0x1a2, 256 => 0x1b6, 257 => 0x1b6 },
	'diffractioncorrection' => { 358 => 0xbc, 384 => 0x3 },
	'diffractioncorrectionon' => { 109 => 0x2070b },
	'digitalcreationdate' => { 138 => 0x3e },
	'digitalcreationtime' => { 138 => 0x3f },
	'digitaldeehighlightadj' => { 272 => 0x202 },
	'digitaldeeshadowadj' => { 272 => 0x200 },
	'digitaldeethreshold' => { 272 => 0x201 },
	'digitalfilter' => { 439 => 0x59 },
	'digitalfilter01' => { 381 => 0x5 },
	'digitalfilter02' => { 381 => 0x16 },
	'digitalfilter03' => { 381 => 0x27 },
	'digitalfilter04' => { 381 => 0x38 },
	'digitalfilter05' => { 381 => 0x49 },
	'digitalfilter06' => { 381 => 0x5a },
	'digitalfilter07' => { 381 => 0x6b },
	'digitalfilter08' => { 381 => 0x7c },
	'digitalfilter09' => { 381 => 0x8d },
	'digitalfilter10' => { 381 => 0x9e },
	'digitalfilter11' => { 381 => 0xaf },
	'digitalfilter12' => { 381 => 0xc0 },
	'digitalfilter13' => { 381 => 0xd1 },
	'digitalfilter14' => { 381 => 0xe2 },
	'digitalfilter15' => { 381 => 0xf3 },
	'digitalfilter16' => { 381 => 0x104 },
	'digitalfilter17' => { 381 => 0x115 },
	'digitalfilter18' => { 381 => 0x126 },
	'digitalfilter19' => { 381 => 0x137 },
	'digitalfilter20' => { 381 => 0x148 },
	'digitalgain' => { 79 => 0xb },
	'digitalgem' => { 230 => 0x0 },
	'digitalice' => { 272 => 0x100 },
	'digitalimageguid' => { 542 => 'DigImageGUID' },
	'digitallensoptimizer' => { 67 => 0xa },
	'digitallensoptimizersetting' => { 85 => 0x9 },
	'digitalroc' => { 269 => 0x0 },
	'digitalsourcefiletype' => { 542 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 542 => 'DigitalSourceType' },
	'digitalzoom' => { 37 => 0xc, 118 => 0xa, 133 => 0x1044, 147 => 0x68, 158 => 0x22, 159 => 0x1e, 163 => 'DigitalZoom', 188 => 0xc, 246 => 0x86, 295 => 0xa, 339 => 0x204, 395 => 0x1e, 402 => 0xa, 438 => 0x204, 486 => 0x12, 487 => 0x12 },
	'digitalzoomon' => { 438 => 0x21b },
	'digitalzoomratio' => { 125 => 0xa404, 474 => 0x200, 476 => 0x21c, 534 => 'DigitalZoomRatio' },
	'director' => { 186 => 'WM/Director', 413 => "\xa9dir", 415 => 'director', 421 => "\xa9dir", 558 => 'director' },
	'directorphotography' => { 558 => 'directorPhotography' },
	'directory' => { 126 => 'Directory' },
	'directoryindex' => { 7 => 0x137, 9 => 0x2dc, 11 => 0x17e, 13 => 0x238, 14 => 0x13f, 15 => 0x133, 16 => 0x1df, 17 => 0x1a7, 18 => 0x1f0, 19 => 0xcc, 20 => 0x1c7, 21 => 0x298, 22 => 0x1e7, 23 => 0x1e5, 24 => [0x27c,0x280], 25 => 0x2b6, 26 => 0x2bf, 28 => 0x1f7, 29 => 0x4ba, 30 => 0xb21 },
	'directoryindex2' => { 21 => 0x29c },
	'directoryitem' => { 509 => [\'Directory','DirectoryItem'] },
	'directoryitemlabel' => { 509 => [\'Directory','DirectoryItemLabel'] },
	'directoryitemlength' => { 509 => [\'Directory','DirectoryItemLength'] },
	'directoryitemmime' => { 509 => [\'Directory','DirectoryItemMime'] },
	'directoryitempadding' => { 509 => [\'Directory','DirectoryItemPadding'] },
	'directoryitemsemantic' => { 509 => [\'Directory','DirectoryItemSemantic'] },
	'directoryitemuri' => { 509 => [\'Directory','DirectoryItemURI'] },
	'directorynumber' => { 223 => 0x3, 425 => 0x12 },
	'disableautocreation' => { 508 => 'DisableAutoCreation' },
	'disablesuggestedaction' => { 508 => 'DisableSuggestedAction' },
	'disclaimer' => { 347 => 'Disclaimer' },
	'discnumber' => { 558 => 'discNumber' },
	'dishtype' => { 550 => 'dishType' },
	'disknumber' => { 413 => 'disk' },
	'dispbutton' => { 257 => 0x7d4, 330 => 0x2ab },
	'displayallafpoints' => { 90 => 0x514 },
	'displayaperture' => { 37 => 0x23 },
	'displayedunitsx' => { 410 => 0x2 },
	'displayedunitsy' => { 410 => 0x6 },
	'displayname' => { 415 => 'displayname', 547 => 'displayName' },
	'distance1' => { 147 => 0x28 },
	'distance2' => { 147 => 0x2c },
	'distance3' => { 147 => 0x30 },
	'distance4' => { 147 => 0x34 },
	'distortion' => { 436 => 0xa050 },
	'distortioncompensation' => { 500 => 0x8040 },
	'distortioncontrol' => { 277 => 0x10 },
	'distortioncorrection' => { 84 => 0x3, 109 => 0x20705, 115 => 0x67, 125 => 0x7036, 221 => 0x4, 334 => 0x50b, 362 => '7.1', 384 => 0x0, 494 => 0x601, 495 => 0x5b },
	'distortioncorrection2' => { 338 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 525 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 109 => '0x20705.0', 115 => 0x63 },
	'distortioncorrectionsetting' => { 85 => 0x7, 463 => 0x2013 },
	'distortioncorrectionvalue' => { 84 => 0x9 },
	'distortioncorrectionversion' => { 221 => 0x0 },
	'distortioncorrparams' => { 125 => 0x7037, 473 => 0x1a23, 476 => 0x1870, 478 => 0x189c, 479 => 0x18cc, 480 => 0x17d0, 494 => 0x6ca, 495 => 0x64 },
	'distortioncorrparamsnumber' => { 476 => 0x1899, 478 => 0x18c5, 479 => 0x18f5, 480 => 0x17f9 },
	'distortioncorrparamspresent' => { 476 => 0x1898, 478 => 0x18c4, 479 => 0x18f4, 480 => 0x17f8, 482 => 0x10b, 483 => 0x10b, 494 => 0x600, 495 => 0x5a },
	'distortioneffect' => { 109 => 0x20709 },
	'distortionn' => { 362 => 0xc },
	'distortionparam02' => { 362 => 0x2 },
	'distortionparam04' => { 362 => 0x4 },
	'distortionparam08' => { 362 => 0x8 },
	'distortionparam09' => { 362 => 0x9 },
	'distortionparam11' => { 362 => 0xb },
	'distortionscale' => { 362 => 0x5 },
	'distributor' => { 548 => 'distributor' },
	'distributorproductid' => { 547 => 'distributorProductID' },
	'dloon' => { 109 => '0x20706.0', 115 => 0xdc },
	'dlosetting' => { 109 => 0x20706, 115 => 0xdd },
	'dlosettingapplied' => { 108 => 0x4 },
	'dloshootingdistance' => { 115 => 0xde },
	'dloversion' => { 108 => 0x5 },
	'dmcomment' => { 558 => 'comment' },
	'dmdithermatrix' => { 145 => 0xc7a },
	'dmdithermatrixheight' => { 145 => 0xc7c },
	'dmdithermatrixwidth' => { 145 => 0xc7b },
	'dngadobedata' => { 125 => 0xc634 },
	'dngbackwardversion' => { 125 => 0xc613 },
	'dngignoresidecars' => { 528 => 'DNGIgnoreSidecars', 530 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 125 => 0xc630 },
	'dngprivatedata' => { 125 => 0xc634 },
	'dngversion' => { 125 => 0xc612 },
	'document' => { 347 => 'Document' },
	'documentancestors' => { 546 => 'DocumentAncestors' },
	'documenthistory' => { 138 => 0xe7 },
	'documentid' => { 559 => 'DocumentID' },
	'documentname' => { 125 => 0x10d },
	'documentnotes' => { 138 => 0xe6 },
	'doi' => { 548 => 'doi' },
	'dopesheet' => { 542 => 'Dopesheet' },
	'dopesheetlink' => { 542 => 'DopesheetLink' },
	'dopesheetlinklink' => { 542 => [\'DopesheetLink','DopesheetLinkLink'] },
	'dopesheetlinklinkqualifier' => { 542 => [\'DopesheetLink','DopesheetLinkLinkQualifier'] },
	'doublingmicrovolts' => { 145 => 0xc82 },
	'dpp' => { 522 => 'dpp' },
	'dprawbokehshift' => { 109 => 0x20b20 },
	'dprawbokehshiftarea' => { 109 => 0x20b21 },
	'dprawghostingreductionarea' => { 109 => 0x20b30 },
	'dprawmicroadjustbackfront' => { 109 => 0x20b10 },
	'dprawmicroadjuststrength' => { 109 => 0x20b12 },
	'dr4cameramodel' => { 110 => 0x3 },
	'drangepriority' => { 133 => 0x1443 },
	'drangepriorityauto' => { 133 => 0x1444 },
	'drangepriorityfixed' => { 133 => 0x1445 },
	'drivemode' => { 119 => 0x3103, 131 => '0.1', 188 => 0x6, 191 => 0x1e, 194 => 0xe, 198 => 0x64d0, 334 => 0x600, 395 => 0x34, 429 => 0x1002, 439 => 0x3, 449 => 0x4, 450 => 0x7e, 451 => 0x34 },
	'drivemode2' => { 191 => 0xa, 375 => 0x7, 460 => 0xe, 468 => 0x1 },
	'drivemodesetting' => { 451 => 0x4 },
	'drivespeed' => { 131 => '0.2' },
	'dspfirmwareversion' => { 395 => 0x27 },
	'dualpixelraw' => { 67 => 0xb },
	'duration' => { 72 => 0x6a, 162 => 'Duration', 176 => 'Duration', 550 => 'duration', 558 => 'duration' },
	'durationscale' => { 558 => [\'duration','durationScale'] },
	'durationvalue' => { 558 => [\'duration','durationValue'] },
	'dustremovaldata' => { 69 => 0x97 },
	'dxcropalert' => { 252 => 0x250, 255 => 0x23c, 256 => 0x250, 257 => 0x250 },
	'dynamicafarea' => { 313 => '1.4', 322 => '1.4' },
	'dynamicafareasize' => { 250 => 0x370, 252 => 0x254, 255 => 0x240, 256 => 0x254, 257 => 0x254 },
	'dynamicareaafassist' => { 329 => 0x18, 330 => 0x18, 331 => 0x18, 332 => 0x18 },
	'dynamicareaafdisplay' => { 314 => '46.1', 316 => '47.1', 317 => '47.1', 326 => '47.1', 327 => '47.1' },
	'dynamicrange' => { 133 => 0x1400 },
	'dynamicrangeboost' => { 358 => 0xee },
	'dynamicrangeexpansion' => { 395 => 0x69, 429 => 0x100e },
	'dynamicrangemax' => { 114 => 0x7c },
	'dynamicrangemin' => { 114 => 0x7a },
	'dynamicrangeoptimizer' => { 191 => 0x15, 463 => [0xb025,0xb04f], 472 => 0x1144, 473 => [0x1144,0x324], 474 => [0x1120,0x300], 475 => [0x119c,0x37c], 476 => [0x1178,0x328], 477 => [0x1030,0x50], 478 => [0x228,0x50], 479 => [0x228,0x50], 480 => [0x21b,0x4e] },
	'dynamicrangeoptimizerbracket' => { 460 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 449 => 0x19, 450 => 0x17, 451 => 0xd, 460 => 0x79, 468 => 0x5 },
	'dynamicrangeoptimizermode' => { 194 => 0x15, 449 => 0x18, 450 => 0x16, 460 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 191 => 0x27, 451 => 0xc, 468 => 0x4 },
	'dynamicrangesetting' => { 133 => 0x1402 },
	'e-dialinprogram' => { 375 => '1.3' },
	'earliestageorloweststage' => { 124 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 124 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 124 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 124 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 124 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'earthpos' => { 504 => 'EarthPos' },
	'earthposaltitude' => { 504 => [\'EarthPos','EarthPosAltitude'] },
	'earthposlatitude' => { 504 => [\'EarthPos','EarthPosLatitude'] },
	'earthposlongitude' => { 504 => [\'EarthPos','EarthPosLongitude'] },
	'earthposrotationw' => { 504 => [\'EarthPos','EarthPosRotationW'] },
	'earthposrotationx' => { 504 => [\'EarthPos','EarthPosRotationX'] },
	'earthposrotationy' => { 504 => [\'EarthPos','EarthPosRotationY'] },
	'earthposrotationz' => { 504 => [\'EarthPos','EarthPosRotationZ'] },
	'earthpostimestamp' => { 504 => [\'EarthPos','EarthPosTimestamp'] },
	'easyexposurecomp' => { 328 => '6.1' },
	'easyexposurecompensation' => { 313 => '6.4', 314 => '6.5', 316 => '6.3', 317 => '6.3', 321 => '5.1', 322 => '4.4', 323 => '5.2', 326 => '6.3', 327 => '6.3', 329 => 0x1f, 330 => 0x1d, 331 => 0x1d, 332 => 0x1d },
	'easymode' => { 37 => 0xb },
	'edgemapslope' => { 145 => 0x930 },
	'edgemapx1' => { 145 => 0x931 },
	'edgemapx2' => { 145 => 0x932 },
	'edgemapx3' => { 145 => 0x934 },
	'edgemapx4' => { 145 => 0x935 },
	'edgenoisereduction' => { 307 => 0x4, 500 => 0x8028 },
	'edit1' => { 421 => "\xa9ed1" },
	'edit2' => { 421 => "\xa9ed2" },
	'edit3' => { 421 => "\xa9ed3" },
	'edit4' => { 421 => "\xa9ed4" },
	'edit5' => { 421 => "\xa9ed5" },
	'edit6' => { 421 => "\xa9ed6" },
	'edit7' => { 421 => "\xa9ed7" },
	'edit8' => { 421 => "\xa9ed8" },
	'edit9' => { 421 => "\xa9ed9" },
	'edition' => { 548 => 'edition' },
	'editorialupdate' => { 138 => 0x8 },
	'editstatus' => { 138 => 0x7, 407 => 'EditStatus', 522 => 'EditStatus' },
	'editversionname' => { 306 => 0x3d136244 },
	'effectivelv' => { 395 => 0x2d },
	'effectivemaxaperture' => { 239 => 0x12, 240 => 0x13, 244 => 0x14 },
	'eissn' => { 548 => 'eIssn' },
	'electricalblackcolumns' => { 145 => 0x1810 },
	'electronicfront-curtainshutter' => { 316 => '5.2', 317 => '5.2', 326 => '5.3', 327 => '5.2' },
	'electronicfrontcurtainshutter' => { 463 => 0x201a },
	'elevation' => { 172 => 'Elevation' },
	'email' => { 164 => 'EMail' },
	'embargodate' => { 551 => 'embargoDate' },
	'embdencrightsexpr' => { 542 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 542 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 542 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 542 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 546 => 'EmbeddedXMPDigest' },
	'emissivity' => { 127 => 0x3 },
	'emptyslotrelease' => { 250 => 0x98c, 253 => 0x723, 254 => 0x733, 255 => 0x625, 256 => 0x655, 257 => 0x6bd },
	'enablechromanoisereduction' => { 145 => 0xe6e },
	'enablesharpening' => { 145 => 0x92e },
	'encodedby' => { 186 => 'WM/EncodedBy', 413 => "\xa9enc" },
	'encodedwith' => { 415 => 'Encoded_With' },
	'encoder' => { 413 => "\xa9too", 415 => 'encoder', 421 => "\xa9too" },
	'encoderid' => { 421 => "\xa9enc" },
	'encodingtime' => { 186 => 'WM/EncodingTime' },
	'encryptionkey' => { 436 => 0xa020 },
	'endingpage' => { 548 => 'endingPage' },
	'enduser' => { 344 => 'EndUser' },
	'enduserid' => { 344 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 344 => [\'EndUser','EndUserEndUserName'] },
	'energysavingmode' => { 250 => 0x992, 253 => 0x746, 254 => 0x756, 255 => 0x648, 256 => 0x678, 257 => 0x6e0 },
	'engineer' => { 558 => 'engineer' },
	'enhancedarktones' => { 299 => 0x8 },
	'enhancedenoisealreadyapplied' => { 525 => 'EnhanceDenoiseAlreadyApplied' },
	'enhancedenoiselumaamount' => { 525 => 'EnhanceDenoiseLumaAmount' },
	'enhancedenoiseversion' => { 525 => 'EnhanceDenoiseVersion' },
	'enhancedetailsalreadyapplied' => { 525 => 'EnhanceDetailsAlreadyApplied' },
	'enhancedetailsversion' => { 525 => 'EnhanceDetailsVersion' },
	'enhancement' => { 118 => 0x16, 119 => 0x3016 },
	'enhanceparams' => { 125 => 0xc7ee },
	'enhancer' => { 338 => 0x300 },
	'enhancervalues' => { 338 => 0x301 },
	'enhancesuperresolutionalreadyapplied' => { 525 => 'EnhanceSuperResolutionAlreadyApplied' },
	'enhancesuperresolutionscale' => { 525 => 'EnhanceSuperResolutionScale' },
	'enhancesuperresolutionversion' => { 525 => 'EnhanceSuperResolutionVersion' },
	'envelopenumber' => { 139 => 0x28 },
	'envelopepriority' => { 139 => 0x3c },
	'enveloperecordversion' => { 139 => 0x0 },
	'episode' => { 542 => 'Episode' },
	'episodeglobaluniqueid' => { 413 => 'egid' },
	'episodeidentifier' => { 542 => [\'Episode','EpisodeIdentifier'] },
	'episodename' => { 542 => [\'Episode','EpisodeName'] },
	'episodenumber' => { 542 => [\'Episode','EpisodeNumber'] },
	'epsonimageheight' => { 339 => 0x20c },
	'epsonimagewidth' => { 339 => 0x20b },
	'epsonsoftware' => { 339 => 0x20d },
	'equipmentinstitution' => { 503 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 503 => 'EquipmentManufacturer' },
	'equipmentversion' => { 335 => 0x0 },
	'ettlii' => { 90 => 0x304, 91 => 0xd, 92 => 0xe, 93 => 0x7, 94 => 0x7, 95 => 0xe },
	'event' => { 506 => 'Event', 520 => 'Event', 542 => 'Event', 548 => 'event' },
	'eventalias' => { 547 => 'eventAlias' },
	'eventdate' => { 124 => [\'Event','EventEventDate'] },
	'eventday' => { 124 => [\'Event','EventDay'] },
	'eventearliestdate' => { 124 => [\'Event','EventEarliestDate'] },
	'eventend' => { 547 => 'eventEnd' },
	'eventenddayofyear' => { 124 => [\'Event','EventEndDayOfYear'] },
	'eventeventtype' => { 124 => [\'Event','EventEventType'] },
	'eventfieldnotes' => { 124 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 124 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 124 => [\'Event','EventHabitat'] },
	'eventid' => { 124 => [\'Event','EventEventID'], 542 => 'EventId' },
	'eventlatestdate' => { 124 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 124 => [\'Event','EventMonth'] },
	'eventnumber' => { 423 => 0x9, 424 => 0x37, 425 => 0x3a },
	'eventparenteventid' => { 124 => [\'Event','EventParentEventID'] },
	'eventremarks' => { 124 => [\'Event','EventEventRemarks'] },
	'eventsamplesizeunit' => { 124 => [\'Event','EventSampleSizeUnit'] },
	'eventsamplesizevalue' => { 124 => [\'Event','EventSampleSizeValue'] },
	'eventsamplingeffort' => { 124 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 124 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 547 => 'eventStart' },
	'eventstartdayofyear' => { 124 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 547 => 'eventSubtype' },
	'eventtime' => { 124 => [\'Event','EventEventTime'] },
	'eventtype' => { 547 => 'eventType' },
	'eventverbatimeventdate' => { 124 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 124 => [\'Event','EventYear'] },
	'evfgrid' => { 329 => 0x15f, 330 => 0x165, 331 => 0x165, 332 => 0x17d },
	'evfimageframe' => { 329 => 0x15e, 330 => 0x164, 331 => 0x164, 332 => 0x17c },
	'evfreleaseindicator' => { 330 => 0x24f, 331 => 0x24f, 332 => 0x267 },
	'evfwarmdisplaybrightness' => { 330 => 0x24d, 331 => 0x24d, 332 => 0x265 },
	'evfwarmdisplaymode' => { 330 => 0x24b, 331 => 0x24b, 332 => 0x263 },
	'evsteps' => { 375 => '1.2', 377 => 0x0 },
	'evstepsize' => { 318 => '5.1', 319 => '6.1', 320 => '6.1', 324 => '0.7' },
	'exclusivecoverage' => { 516 => 'ExclusiveCoverage' },
	'exclusivityenddate' => { 551 => 'exclusivityEndDate' },
	'excursiontolerance' => { 140 => 0x82 },
	'executiveproducer' => { 413 => "\xa9xpd" },
	'exif' => { 126 => 'EXIF' },
	'exifbyteorder' => { 126 => 'ExifByteOrder' },
	'exifcamerainfo' => { 138 => 0xe8 },
	'exifimageheight' => { 125 => 0xa003, 534 => 'PixelYDimension' },
	'exifimagewidth' => { 125 => 0xa002, 534 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 126 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 125 => 0x9000, 534 => 'ExifVersion' },
	'exitpupilposition' => { 239 => 0x4, 240 => 0x4, 244 => 0x4 },
	'expirationdate' => { 138 => 0x25, 551 => 'expirationDate' },
	'expirationtime' => { 138 => 0x26 },
	'exposure' => { 125 => 0xfe51, 528 => 'Exposure', 530 => 'Exposure' },
	'exposure2012' => { 528 => 'Exposure2012', 530 => 'Exposure2012' },
	'exposureadj' => { 304 => 0x0 },
	'exposureadj2' => { 304 => 0x12 },
	'exposureadjust' => { 439 => 0xc },
	'exposurebracketingindicatorlast' => { 191 => 0x52 },
	'exposurebracketshotnumber' => { 194 => 0x2d, 460 => 0x2f },
	'exposurebracketstepsize' => { 375 => 0x8 },
	'exposurebracketvalue' => { 246 => 0x19 },
	'exposurecompautocancel' => { 90 => 0x113 },
	'exposurecompensation' => { 82 => 0x6, 99 => 0x0, 125 => 0x9204, 147 => 0x24, 163 => 'ExposureComp', 183 => 'ExposureCompensation', 188 => 0xd, 189 => 0x53, 190 => 0x1e, 194 => 0x49c0, 339 => 0x1006, 395 => 0x16, 404 => 0x402, 436 => 0xa013, 439 => [0xc,0x35,0x4d], 472 => 0x114c, 473 => 0x114c, 474 => 0x1128, 476 => 0x1180, 477 => 0x1038, 478 => 0x230, 479 => 0x230, 480 => 0x223, 534 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 468 => [0x24,0x26,0x2a] },
	'exposurecompensationbutton' => { 257 => 0x794 },
	'exposurecompensationmode' => { 191 => 0x47, 194 => 0x2a },
	'exposurecompensationset' => { 449 => 0x3, 450 => 0x3, 451 => 0x3, 468 => 0x1e },
	'exposurecompensationsetting' => { 191 => 0x1 },
	'exposurecompstepsize' => { 313 => '6.3', 314 => '7.3', 316 => '7.3', 317 => '7.3', 322 => '4.3', 326 => '7.3', 327 => '7.3' },
	'exposurecontrolstep' => { 321 => '6.1', 323 => '6.1' },
	'exposurecontrolstepsize' => { 313 => '6.2', 314 => '7.1', 316 => '7.1', 317 => '7.1', 322 => '4.2', 326 => '7.1', 327 => '7.1', 328 => '7.1', 329 => 0x1d, 330 => 0x1b, 331 => 0x1b, 332 => 0x1b },
	'exposurecount' => { 133 => 0x1032 },
	'exposuredelay' => { 257 => 0x800, 330 => 0x2f1 },
	'exposuredelaymode' => { 313 => '10.1', 314 => '11.1', 316 => '11.1', 317 => '11.1', 318 => '9.1', 319 => '10.1', 320 => '10.1', 322 => '10.4', 323 => '10.1', 324 => '6.4', 326 => '11.1', 327 => '11.1', 328 => '11.2' },
	'exposuredifference' => { 246 => 0xe },
	'exposuregaincustom' => { 145 => 0x89c },
	'exposuregaindaylight' => { 145 => 0x898 },
	'exposuregainflash' => { 145 => 0x89b },
	'exposuregainfluorescent' => { 145 => 0x89a },
	'exposuregaintungsten' => { 145 => 0x899 },
	'exposureindex' => { 125 => 0xa215, 534 => 'ExposureIndex' },
	'exposureindicator' => { 191 => 0x50 },
	'exposurelevelincrements' => { 88 => 0x6, 89 => 0x6, 90 => 0x101, 91 => 0x5, 92 => 0x6, 93 => 0x5, 94 => 0x5, 95 => 0x6, 96 => 0x4, 449 => 0x58, 450 => 0x58 },
	'exposurelockused' => { 514 => 'ExposureLockUsed' },
	'exposuremode' => { 125 => 0xa402, 163 => 'ExposureMode', 188 => 0x1, 189 => 0xa, 190 => 0x0, 191 => 0x0, 194 => 0x34, 334 => 0x200, 355 => 0x40d, 439 => 0x8, 463 => 0xb041, 534 => 'ExposureMode' },
	'exposuremodeinmanual' => { 90 => 0x10b },
	'exposureprogram' => { 125 => 0x8822, 429 => 0x1001, 442 => [0x17e,0x43], 449 => 0x3c, 450 => 0x3c, 451 => 0x5, 455 => 0x14, 460 => 0x3f, 468 => 0x2, 472 => 0x1175, 473 => 0x1179, 474 => 0x1155, 475 => 0x11d1, 476 => 0x11ad, 477 => 0x1065, 478 => 0x25d, 479 => 0x25d, 480 => 0x24c, 491 => 0xb, 492 => 0xc, 493 => 0xb, 495 => 0x48, 534 => 'ExposureProgram' },
	'exposureshift' => { 334 => 0x203 },
	'exposurestandardadjustment' => { 463 => 0x202d },
	'exposuretime' => { 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x4, 31 => 0x6, 32 => 0x7, 82 => 0x16, 125 => 0x829a, 144 => 0xfd05, 147 => 0x20, 149 => 0xfa24, 151 => 0xf104, 154 => 0x12, 156 => 0x38, 158 => 0x14, 159 => 0x10, 161 => 0x10, 163 => 'ExposureTime', 188 => 0x9, 189 => 0x35, 190 => 0x48, 191 => 0x8, 194 => 0x49b8, 395 => 0x12, 436 => 0xa018, 439 => [0x32,0x4a], 449 => 0x0, 450 => 0x0, 468 => [0x21,0x23,0x27], 495 => 0x10, 534 => 'ExposureTime' },
	'exposuretime2' => { 439 => [0x33,0x4b] },
	'exposuretuning' => { 246 => 0x1c },
	'exposurevalue' => { 145 => 0x3 },
	'exposurewarning' => { 133 => 0x1302 },
	'exrauto' => { 133 => 0x1033 },
	'exrmode' => { 133 => 0x1034 },
	'extdescraccessibility' => { 541 => 'ExtDescrAccessibility' },
	'extendedmenubanks' => { 252 => 0x120, 255 => 0x114, 256 => 0x124, 257 => 0x124 },
	'extendedshutterspeeds' => { 329 => 0xf2, 330 => 0x102, 331 => 0x102, 332 => 0x118 },
	'extendedwbdetect' => { 334 => 0x902 },
	'extender' => { 335 => 0x301 },
	'extenderfirmwareversion' => { 335 => 0x304 },
	'extendermagnification' => { 165 => 'Magnification' },
	'extendermake' => { 165 => 'Make' },
	'extendermodel' => { 165 => 'Model', 335 => 0x303 },
	'extenderserialnumber' => { 165 => 'SerialNumber', 335 => 0x302 },
	'extenderstatus' => { 392 => 0x3 },
	'externalflash' => { 337 => 0x1201 },
	'externalflashae1' => { 339 => 0x101f },
	'externalflashae1_0' => { 339 => 0x101b },
	'externalflashae2' => { 339 => 0x1020 },
	'externalflashae2_0' => { 339 => 0x101c },
	'externalflashbounce' => { 337 => 0x1204, 339 => 0x1026, 382 => 0x1a },
	'externalflashcompensation' => { 226 => 0x1b },
	'externalflashexposurecomp' => { 246 => 0x17, 382 => 0x19 },
	'externalflashfirmware' => { 224 => 0x6, 225 => 0x6, 226 => 0x6, 227 => 0x6, 228 => 0x6, 229 => 0x6 },
	'externalflashflags' => { 224 => 0x8, 225 => 0x8, 226 => 0x8, 227 => 0x8, 229 => 0x8 },
	'externalflashguidenumber' => { 337 => 0x1203, 382 => '24.1' },
	'externalflashgvalue' => { 339 => 0x1025 },
	'externalflashmode' => { 339 => 0x1028, 382 => 0x2 },
	'externalflashreadystate' => { 228 => '9.1' },
	'externalflashstatus' => { 228 => '8.2' },
	'externalflashzoom' => { 337 => 0x1205, 339 => 0x1027 },
	'externalflashzoomoverride' => { 228 => '8.1' },
	'externalmetadatalink' => { 542 => 'ExternalMetadataLink' },
	'externalsensorbrightnessvalue' => { 353 => 0x311, 356 => 0x311, 357 => 0x311, 360 => 0x3408 },
	'extrainfoversion' => { 453 => 0x1a },
	'eyedetection' => { 2 => 0x18 },
	'eyestartaf' => { 191 => 0x40 },
	'fac100per' => { 145 => 0xe94 },
	'fac170per' => { 145 => 0xe93 },
	'fac18per' => { 145 => 0xe92 },
	'face10position' => { 116 => 0x3f4, 117 => 0x1ec, 222 => 0x28, 379 => 0x12 },
	'face10size' => { 380 => 0x12 },
	'face11position' => { 222 => 0x2c, 379 => 0x14 },
	'face11size' => { 380 => 0x14 },
	'face12position' => { 222 => 0x30, 379 => 0x16 },
	'face12size' => { 380 => 0x16 },
	'face13position' => { 379 => 0x18 },
	'face13size' => { 380 => 0x18 },
	'face14position' => { 379 => 0x1a },
	'face14size' => { 380 => 0x1a },
	'face15position' => { 379 => 0x1c },
	'face15size' => { 380 => 0x1c },
	'face16position' => { 379 => 0x1e },
	'face16size' => { 380 => 0x1e },
	'face17position' => { 379 => 0x20 },
	'face17size' => { 380 => 0x20 },
	'face18position' => { 379 => 0x22 },
	'face18size' => { 380 => 0x22 },
	'face19position' => { 379 => 0x24 },
	'face19size' => { 380 => 0x24 },
	'face1position' => { 58 => 0x8, 116 => 0xd, 117 => 0x18, 222 => 0x4, 350 => 0x1, 379 => 0x0, 426 => 0xbc, 456 => 0x1, 457 => 0x0, 458 => 0x0, 459 => 0x5b },
	'face1size' => { 380 => 0x0 },
	'face20position' => { 379 => 0x26 },
	'face20size' => { 380 => 0x26 },
	'face21position' => { 379 => 0x28 },
	'face21size' => { 380 => 0x28 },
	'face22position' => { 379 => 0x2a },
	'face22size' => { 380 => 0x2a },
	'face23position' => { 379 => 0x2c },
	'face23size' => { 380 => 0x2c },
	'face24position' => { 379 => 0x2e },
	'face24size' => { 380 => 0x2e },
	'face25position' => { 379 => 0x30 },
	'face25size' => { 380 => 0x30 },
	'face26position' => { 379 => 0x32 },
	'face26size' => { 380 => 0x32 },
	'face27position' => { 379 => 0x34 },
	'face27size' => { 380 => 0x34 },
	'face28position' => { 379 => 0x36 },
	'face28size' => { 380 => 0x36 },
	'face29position' => { 379 => 0x38 },
	'face29size' => { 380 => 0x38 },
	'face2position' => { 58 => 0xa, 116 => 0x7c, 117 => 0x4c, 222 => 0x8, 350 => 0x5, 379 => 0x2, 426 => 0xc8, 456 => 0x6, 457 => 0x20, 458 => 0x25, 459 => 0x65 },
	'face2size' => { 380 => 0x2 },
	'face30position' => { 379 => 0x3a },
	'face30size' => { 380 => 0x3a },
	'face31position' => { 379 => 0x3c },
	'face31size' => { 380 => 0x3c },
	'face32position' => { 379 => 0x3e },
	'face32size' => { 380 => 0x3e },
	'face3position' => { 58 => 0xc, 116 => 0xeb, 117 => 0x80, 222 => 0xc, 350 => 0x9, 379 => 0x4, 426 => 0xd4, 456 => 0xb, 457 => 0x40, 458 => 0x4a, 459 => 0x6f },
	'face3size' => { 380 => 0x4 },
	'face4position' => { 58 => 0xe, 116 => 0x15a, 117 => 0xb4, 222 => 0x10, 350 => 0xd, 379 => 0x6, 426 => 0xe0, 456 => 0x10, 457 => 0x60, 458 => 0x6f, 459 => 0x79 },
	'face4size' => { 380 => 0x6 },
	'face5position' => { 58 => 0x10, 116 => 0x1c9, 117 => 0xe8, 222 => 0x14, 350 => 0x11, 379 => 0x8, 426 => 0xec, 456 => 0x15, 457 => 0x80, 458 => 0x94 },
	'face5size' => { 380 => 0x8 },
	'face6position' => { 58 => 0x12, 116 => 0x238, 117 => 0x11c, 222 => 0x18, 379 => 0xa, 426 => 0xf8, 456 => 0x1a, 457 => 0xa0, 458 => 0xb9 },
	'face6size' => { 380 => 0xa },
	'face7position' => { 58 => 0x14, 116 => 0x2a7, 117 => 0x150, 222 => 0x1c, 379 => 0xc, 426 => 0x104, 456 => 0x1f, 457 => 0xc0, 458 => 0xde },
	'face7size' => { 380 => 0xc },
	'face8position' => { 58 => 0x16, 116 => 0x316, 117 => 0x184, 222 => 0x20, 379 => 0xe, 426 => 0x110, 456 => 0x24, 457 => 0xe0, 458 => 0x103 },
	'face8size' => { 380 => 0xe },
	'face9position' => { 58 => 0x18, 116 => 0x385, 117 => 0x1b8, 222 => 0x24, 379 => 0x10 },
	'face9size' => { 380 => 0x10 },
	'facebalanceorigi' => { 521 => 'FaceBalanceOrigI' },
	'facebalanceorigq' => { 521 => 'FaceBalanceOrigQ' },
	'facebalancestrength' => { 521 => 'FaceBalanceStrength' },
	'facebalancewarmth' => { 521 => 'FaceBalanceWarmth' },
	'facedetect' => { 395 => 0x76, 436 => 0x100 },
	'facedetectarea' => { 338 => 0x1201 },
	'facedetectframecrop' => { 338 => 0x1207 },
	'facedetectframesize' => { 58 => 0x3, 116 => 0x1, 117 => 0x4, 222 => 0x1, 338 => 0x1203, 395 => 0x77, 426 => 0xb6 },
	'facedetection' => { 451 => 0x30, 468 => 0x19 },
	'faceelementpositions' => { 133 => 0x4203 },
	'faceelementselected' => { 133 => 0x4005 },
	'faceelementtypes' => { 133 => 0x4201 },
	'faceid' => { 524 => 'FaceID' },
	'faceinfounknown' => { 119 => 0x2089 },
	'facename' => { 436 => 0x123 },
	'faceorientation' => { 117 => 0x8 },
	'faceposition' => { 378 => 0x2, 437 => 0x4 },
	'facepositions' => { 133 => 0x4103 },
	'facerecognition' => { 436 => 0x120 },
	'facesdetected' => { 58 => 0x2, 59 => 0x2, 60 => 0x3, 116 => 0x0, 117 => 0x2, 119 => 0x211c, 133 => 0x4100, 222 => 0x3, 338 => 0x1200, 358 => 0x3f, 378 => 0x0, 426 => 0xb5, 437 => 0x0, 456 => 0x0, 459 => 0x3, 471 => 0x30 },
	'facesrecognized' => { 351 => 0x0 },
	'facewidth' => { 59 => 0x1 },
	'fade' => { 463 => 0x2034 },
	'faithfuloutputhighlightpoint' => { 115 => 0x38 },
	'faithfuloutputshadowpoint' => { 115 => 0x39 },
	'faithfulrawcolortone' => { 115 => 0x31 },
	'faithfulrawcontrast' => { 115 => 0x33 },
	'faithfulrawhighlight' => { 115 => 0x79 },
	'faithfulrawhighlightpoint' => { 115 => 0x36 },
	'faithfulrawlinear' => { 115 => 0x34 },
	'faithfulrawsaturation' => { 115 => 0x32 },
	'faithfulrawshadow' => { 115 => 0x82 },
	'faithfulrawshadowpoint' => { 115 => 0x37 },
	'faithfulrawsharpness' => { 115 => 0x35 },
	'faithfulunsharpmaskfineness' => { 115 => 0xac },
	'faithfulunsharpmaskstrength' => { 115 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 115 => 0xae },
	'far' => { 511 => 'Far' },
	'fastresetlinetime' => { 145 => 0x1860 },
	'feedidentifier' => { 542 => 'FeedIdentifier' },
	'femicroadjustment' => { 90 => 0x111 },
	'ffid' => { 532 => 'ffid' },
	'field' => { 547 => 'field' },
	'fieldcount' => { 339 => 0x103f },
	'fieldofview' => { 421 => "FOV\x00" },
	'fifoenonepixeldelay' => { 145 => 0x1901 },
	'filecreatedate' => { 126 => 'FileCreateDate' },
	'filedatarate' => { 558 => 'fileDataRate' },
	'fileformat' => { 101 => 0x0, 139 => 0x14, 439 => [0x22,0x26], 463 => 0xb000 },
	'filegroupid' => { 126 => 'FileGroupID' },
	'fileindex' => { 7 => 0x143, 9 => 0x2d0, 11 => 0x172, 13 => 0x22c, 14 => 0x133, 15 => 0x13f, 16 => 0x1d3, 17 => 0x19b, 18 => 0x1e4, 19 => 0xd0, 20 => 0x1bb, 21 => 0x28c, 22 => 0x1db, 23 => 0x1d9, 24 => [0x270,0x274], 25 => 0x2aa, 26 => 0x2b3, 28 => 0x1eb, 29 => 0x4ae, 30 => 0xb2d, 359 => 0x0 },
	'fileindex2' => { 21 => 0x290 },
	'filemodifydate' => { 126 => 'FileModifyDate' },
	'filename' => { 126 => 'FileName' },
	'filenameasdelivered' => { 344 => 'FileNameAsDelivered' },
	'filenumber' => { 61 => 0x1, 69 => 0x8, 103 => 0x1817, 120 => 'Canon-FileNumber', 223 => 0x4, 425 => 0x10 },
	'filenumbermemory' => { 188 => 0x1a },
	'filenumbersequence' => { 313 => '12.2', 318 => '3.1', 319 => '4.1', 320 => '4.1', 322 => '11.1', 323 => '4.3', 328 => '5.2', 329 => 0x4e, 330 => 0x48, 331 => 0x48, 332 => 0x48 },
	'filepermissions' => { 126 => 'FilePermissions' },
	'filesource' => { 125 => 0xa300, 133 => 0x8000, 534 => 'FileSource' },
	'fileuserid' => { 126 => 'FileUserID' },
	'fileversion' => { 139 => 0x16 },
	'fillflashautoreduction' => { 88 => 0xe, 89 => 0xe, 96 => 0xa },
	'filllight' => { 528 => 'FillLight', 530 => 'FillLight' },
	'fillorder' => { 125 => 0x10a },
	'filmgraineffect' => { 334 => 0x538 },
	'filmmode' => { 133 => 0x1401, 355 => 0x412, 358 => 0x42 },
	'filmtype' => { 272 => 0x2 },
	'filtereffect' => { 61 => 0xe, 264 => 0x37, 265 => 0x3f, 266 => 0x47, 358 => 0xa1 },
	'filtereffectauto' => { 76 => 0xa0 },
	'filtereffectfaithful' => { 75 => 0x70, 76 => 0x70 },
	'filtereffectlandscape' => { 75 => 0x40, 76 => 0x40 },
	'filtereffectmonochrome' => { 19 => 0xff, 75 => 0x88, 76 => 0x88 },
	'filtereffectneutral' => { 75 => 0x58, 76 => 0x58 },
	'filtereffectportrait' => { 75 => 0x28, 76 => 0x28 },
	'filtereffectstandard' => { 75 => 0x10, 76 => 0x10 },
	'filtereffectuserdef1' => { 75 => 0xa0, 76 => 0xb8 },
	'filtereffectuserdef2' => { 75 => 0xb8, 76 => 0xd0 },
	'filtereffectuserdef3' => { 75 => 0xd0, 76 => 0xe8 },
	'finderdisplayduringexposure' => { 89 => 0x1 },
	'finesharpness' => { 395 => 0x70 },
	'finetuneoptcenterweighted' => { 313 => '7.2', 314 => '9.1', 316 => '9.1', 317 => '9.1', 321 => '8.1', 326 => '9.1', 327 => '9.1', 328 => '9.1', 329 => 0x25, 330 => 0x23, 331 => 0x23, 332 => 0x23 },
	'finetuneopthighlightweighted' => { 316 => '46.1', 317 => '46.1', 326 => '46.1', 327 => '46.1', 329 => 0x29, 330 => 0x27, 331 => 0x27, 332 => 0x27 },
	'finetuneoptmatrixmetering' => { 313 => '8.1', 314 => '8.2', 316 => '8.2', 317 => '8.2', 321 => '7.2', 322 => '6.1', 326 => '8.2', 327 => '8.2', 328 => '8.2', 329 => 0x23, 330 => 0x21, 331 => 0x21, 332 => 0x21 },
	'finetuneoptspotmetering' => { 313 => '8.2', 314 => '9.2', 316 => '9.2', 317 => '9.2', 321 => '8.2', 322 => '6.2', 326 => '9.2', 327 => '9.2', 328 => '9.2', 329 => 0x27, 330 => 0x25, 331 => 0x25, 332 => 0x25 },
	'finishexposure' => { 145 => 0xdbd },
	'finishfiletype' => { 145 => 0xdb8 },
	'finishlook' => { 145 => 0xdbc },
	'finishnoise' => { 145 => 0xdba },
	'finishresolution' => { 145 => 0xdb9 },
	'finishsharpening' => { 145 => 0xdbb },
	'firmware' => { 339 => 0x405, 439 => [0x8c,0x17,0x3b], 525 => 'Firmware' },
	'firmware2' => { 439 => 0x57 },
	'firmwaredate' => { 118 => 0x15, 119 => 0x2001, 423 => 0x4, 425 => 0x30 },
	'firmwareid' => { 195 => 0x0 },
	'firmwarename' => { 436 => 0xa001 },
	'firmwarerevision' => { 19 => 0xa4, 69 => 0x1e, 427 => 0x0 },
	'firmwarerevision2' => { 427 => 0xc },
	'firmwareversion' => { 7 => 0x10b, 11 => 0x136, 14 => 0xff, 15 => 0x107, 145 => [0x415,0xce5], 161 => 0x57, 163 => 'FirmwareVersion', 356 => 0x320, 358 => 0x2, 360 => 0x3109, 395 => 0x230, 421 => ['CNFV','FIRM','info'], 424 => 0x18, 425 => 0x2a, 429 => 0x2 },
	'firmwareversions' => { 404 => 0x301 },
	'firstphotodate' => { 514 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 344 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 138 => 0x16, 522 => 'FixtureIdentifier' },
	'flash' => { 120 => 'XMP-Flash', 125 => 0x9209, 159 => 0x22, 189 => 0x1f, 190 => 0x15, 425 => 0x5a, 534 => 'Flash' },
	'flashaction' => { 449 => 0x3e, 450 => 0x3e, 463 => 0x2017, 468 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 449 => 0x4c, 450 => 0x4c, 468 => 0x77 },
	'flashactionexternal' => { 468 => [0x78,0x7c] },
	'flashactivity' => { 37 => 0x1c },
	'flashbatterylevel' => { 48 => 0x249 },
	'flashbias' => { 358 => 0x24 },
	'flashbits' => { 37 => 0x1d },
	'flashburstpriority' => { 329 => 0x101, 330 => 0x111, 331 => 0x111, 332 => 0x129 },
	'flashbuttonfunction' => { 90 => 0x70e },
	'flashchargelevel' => { 339 => 0x1010 },
	'flashcolorfilter' => { 226 => 0x10, 227 => 0x10, 229 => 0x10 },
	'flashcommandermode' => { 224 => '9.1', 225 => '9.1', 226 => '9.1', 227 => '9.1', 229 => '9.1' },
	'flashcompensation' => { 145 => 0x3f3, 224 => 0xa, 225 => 0xa, 226 => 0xa, 227 => 0x27, 228 => 0xa, 229 => 0xa, 525 => 'FlashCompensation' },
	'flashcontrol' => { 449 => 0x23, 450 => 0x1f, 451 => 0x21 },
	'flashcontrolbuilt-in' => { 322 => '16.1', 323 => '23.1', 325 => '23.1', 326 => '24.1' },
	'flashcontrolmode' => { 224 => '9.2', 225 => '9.2', 226 => '9.2', 227 => '9.2', 229 => '9.2', 235 => 0x214, 250 => 0x2d4, 251 => 0x148, 252 => 0x1b8, 255 => 0x1a8, 256 => 0x1bc, 257 => 0x1bc, 334 => 0x404 },
	'flashcurtain' => { 358 => 0x48 },
	'flashdefault' => { 191 => 0x42 },
	'flashdevice' => { 339 => 0x1005 },
	'flashdistance' => { 119 => 0x2034 },
	'flashenergy' => { 125 => 0xa20b, 534 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 246 => 0x18 },
	'flashexposurecomp' => { 82 => 0xf, 133 => 0x1011, 166 => 'ExposureComp', 188 => 0x23, 193 => 0x104, 194 => 0x49c1, 246 => 0x12, 334 => 0x401, 339 => 0x1023, 395 => 0x4d, 429 => 0x100b, 439 => [0x3a,0x56], 463 => 0x104 },
	'flashexposurecomp2' => { 293 => 0x4d2 },
	'flashexposurecomp3' => { 226 => 0x1d },
	'flashexposurecomp4' => { 226 => 0x27 },
	'flashexposurecomparea' => { 314 => '38.4', 316 => '38.4', 317 => '38.4', 326 => '38.4', 327 => '38.4', 329 => 0x5d, 330 => 0x59, 331 => 0x59, 332 => 0x59 },
	'flashexposurecompset' => { 191 => 0x10, 366 => 0xe, 449 => 0x14, 450 => 0x12, 451 => 0x23, 468 => 0x1f },
	'flashexposurecompset2' => { 468 => [0x26,0x2c] },
	'flashexposureindicator' => { 191 => 0x54 },
	'flashexposureindicatorlast' => { 191 => 0x56 },
	'flashexposureindicatornext' => { 191 => 0x55 },
	'flashexposurelock' => { 61 => 0x19 },
	'flashfired' => { 147 => 0x5d, 166 => 'Fired', 188 => 0x14, 292 => '590.3', 534 => [\'Flash','FlashFired'] },
	'flashfiring' => { 90 => 0x306, 91 => 0x6, 92 => 0x7, 95 => 0x7 },
	'flashfirmwareversion' => { 335 => 0x1002 },
	'flashfocallength' => { 224 => 0xb, 225 => 0xc, 226 => 0xc, 227 => 0xc, 228 => 0xc, 229 => 0x26 },
	'flashfunction' => { 194 => 0x31, 534 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 224 => 0xe, 225 => 0xf, 226 => 0xf, 227 => 0xf, 228 => 0xf, 229 => 0xf, 235 => 0x21a, 250 => 0x2da, 251 => 0x14e, 255 => 0x1ae, 256 => 0x1c2, 257 => 0x1c2 },
	'flashgroupacompensation' => { 224 => 0x11, 225 => 0x12, 226 => 0x13, 227 => 0x28, 228 => 0x28, 229 => 0x28 },
	'flashgroupacontrolmode' => { 224 => 0xf, 225 => '16.1', 226 => '17.1', 227 => '17.1', 228 => '17.1', 229 => '17.1' },
	'flashgroupaoutput' => { 224 => 0x11, 225 => 0x12, 226 => 0x13, 227 => 0x28, 228 => 0x28, 229 => 0x28 },
	'flashgroupbcompensation' => { 224 => 0x12, 225 => 0x13, 226 => 0x14, 227 => 0x29, 228 => 0x29, 229 => 0x29 },
	'flashgroupbcontrolmode' => { 224 => 0x10, 225 => '17.1', 226 => '18.1', 227 => '18.1', 228 => '18.1', 229 => '18.1' },
	'flashgroupboutput' => { 224 => 0x12, 225 => 0x13, 226 => 0x14, 227 => 0x29, 228 => 0x29, 229 => 0x29 },
	'flashgroupccompensation' => { 225 => 0x14, 226 => 0x15, 227 => 0x2a, 228 => 0x2a, 229 => 0x2a },
	'flashgroupccontrolmode' => { 225 => '17.2', 226 => '18.2', 227 => '18.2', 228 => '18.2', 229 => '18.2' },
	'flashgroupcoutput' => { 225 => 0x14, 226 => 0x15, 227 => 0x2a, 228 => 0x2a, 229 => 0x2a },
	'flashguidenumber' => { 82 => 0xd, 100 => 0x0, 166 => 'GuideNumber' },
	'flashilluminationpattern' => { 229 => 0x25 },
	'flashintensity' => { 118 => [0x19,0x5], 334 => 0x405 },
	'flashlevel' => { 315 => 0x9, 463 => 0xb048 },
	'flashmake' => { 166 => 'Make' },
	'flashmanufacturer' => { 185 => 'FlashManufacturer' },
	'flashmastercompensation' => { 235 => 0x22e, 250 => 0x2ee, 251 => 0x162, 255 => 0x1aa, 256 => 0x1be, 257 => 0x1be },
	'flashmastercontrolmode' => { 235 => 0x22c, 250 => 0x2ec, 251 => 0x160 },
	'flashmasteroutput' => { 235 => 0x232, 250 => 0x2f2, 251 => 0x166 },
	'flashmetering' => { 188 => 0x3f, 191 => 0x1c },
	'flashmeteringmode' => { 7 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 18 => 0x15, 20 => 0x15, 22 => 0x15, 28 => 0x15 },
	'flashmeteringsegments' => { 395 => 0x20a },
	'flashmode' => { 118 => 0x4, 145 => 0x3f2, 147 => 0x5c, 158 => 0x27, 166 => 'Mode', 188 => 0x2, 189 => 0x20, 190 => 0x16, 191 => 0xf, 246 => 0x87, 334 => 0x400, 339 => 0x1004, 395 => 0xc, 402 => 0x4, 428 => 0x20, 429 => 0x100a, 438 => 0x225, 449 => 0x13, 450 => 0x7f, 451 => 0x20, 468 => 0x10, 472 => 0x1138, 473 => 0x1138, 474 => 0x1114, 475 => 0x1190, 476 => 0x116c, 477 => 0x1024, 478 => 0x21c, 479 => 0x21c, 480 => 0x211, 534 => [\'Flash','FlashMode'] },
	'flashmodebutton' => { 257 => 0x80e },
	'flashmodebuttonplaybackmode' => { 257 => 0x818 },
	'flashmodel' => { 166 => 'Model', 185 => 'FlashModel', 335 => 0x1001 },
	'flashoptions' => { 375 => 0x2 },
	'flashoptions2' => { 375 => 0x10 },
	'flashoutput' => { 48 => 0x248, 82 => 0x21, 224 => 0xa, 225 => 0xa, 226 => 0xa, 227 => 0x27, 229 => 0x21, 235 => 0x21e, 250 => 0x2de, 251 => 0x152, 255 => 0x1b2, 256 => 0x1c6, 257 => 0x1c6 },
	'flashpixversion' => { 125 => 0xa000, 534 => 'FlashpixVersion' },
	'flashredeyemode' => { 534 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 235 => 0x228, 250 => 0x2e8, 251 => 0x15c, 255 => 0x1bc, 334 => 0x403 },
	'flashreturn' => { 534 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 166 => 'SerialNumber', 335 => 0x1003 },
	'flashsetting' => { 246 => 0x8 },
	'flashshutterspeed' => { 313 => '20.2', 314 => '23.2', 316 => '23.2', 317 => '23.2', 322 => '15.2', 323 => '22.2', 324 => '7.2', 325 => '22.2', 326 => '23.2', 327 => '23.2', 328 => '23.1', 329 => 0x5b, 330 => 0x57, 331 => 0x57, 332 => 0x57 },
	'flashsource' => { 224 => 0x4, 225 => 0x4, 226 => 0x4, 227 => 0x4, 228 => 0x4, 229 => 0x4 },
	'flashstatus' => { 382 => 0x0, 468 => [0x82,0x86], 482 => 0x31, 483 => 0x39, 484 => 0x39 },
	'flashstatusbuilt-in' => { 451 => [0x87,0x287] },
	'flashstatusexternal' => { 451 => [0x88,0x288] },
	'flashsyncspeed' => { 313 => '20.1', 314 => '23.1', 316 => '23.1', 317 => '23.1', 322 => '15.1', 323 => '22.1', 325 => '22.1', 326 => '23.1', 327 => '23.1', 329 => 0x57, 330 => 0x53, 331 => 0x53, 332 => 0x53 },
	'flashsyncspeedav' => { 88 => 0x3, 90 => 0x10f, 91 => 0x2, 92 => 0x3, 93 => 0x2, 94 => 0x2, 95 => 0x3, 96 => 0x6 },
	'flashthreshold' => { 100 => 0x1 },
	'flashtype' => { 166 => 'Type', 191 => 0x59, 246 => 0x9, 335 => 0x1000 },
	'flashwarning' => { 323 => '30.1', 324 => '7.1', 328 => '31.1', 358 => 0x62 },
	'flashwirelessoption' => { 235 => 0x234, 250 => 0x2e6, 251 => 0x15a, 255 => 0x1c8 },
	'flexiblespotposition' => { 463 => 0x201d },
	'flickadvancedirection' => { 330 => 0x25f, 331 => 0x25f, 332 => 0x277 },
	'flickerreduce' => { 438 => 0x218 },
	'flickerreduction' => { 133 => 0x1446, 276 => 0x7 },
	'flickerreductionindicator' => { 271 => 0x532 },
	'flickerreductionshooting' => { 250 => 0x2d0, 252 => 0x1b4, 255 => 0x1a4, 256 => 0x1b8, 257 => 0x1b8 },
	'flightpitchdegree' => { 122 => 'FlightPitchDegree' },
	'flightrolldegree' => { 122 => 'FlightRollDegree' },
	'flightxspeed' => { 122 => 'FlightXSpeed' },
	'flightyawdegree' => { 122 => 'FlightYawDegree' },
	'flightyspeed' => { 122 => 'FlightYSpeed' },
	'flightzspeed' => { 122 => 'FlightZSpeed' },
	'fliphorizontal' => { 306 => 0x76a43206 },
	'fnumber' => { 7 => 0x3, 9 => 0x3, 11 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x3, 31 => 0x5, 32 => 0x6, 82 => 0x15, 125 => 0x829d, 144 => 0xfd04, 147 => 0x1e, 149 => 0xfa23, 151 => 0xf103, 154 => 0x13, 156 => 0x3c, 158 => 0x1c, 159 => 0x18, 161 => 0xc, 170 => 'FNumber', 188 => 0xa, 189 => 0x36, 190 => 0x47, 191 => 0x9, 194 => 0x49c7, 244 => 0x38, 357 => 0x35a, 395 => 0x13, 436 => 0xa019, 439 => [0x31,0x49], 449 => 0x1, 450 => 0x1, 468 => [0x20,0x22,0x26], 534 => 'FNumber' },
	'focaldistance' => { 512 => 'FocalDistance' },
	'focallength' => { 7 => 0x1d, 8 => 0xa, 9 => 0x23, 10 => 0x9, 11 => 0x1d, 12 => 0x9, 13 => 0x1e, 14 => 0x1d, 15 => 0x1d, 16 => 0x1e, 17 => 0x1e, 18 => 0x1e, 19 => 0x28, 20 => 0x1e, 21 => 0x23, 22 => 0x1e, 23 => 0x1e, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x23, 28 => 0x1e, 29 => 0x23, 63 => 0x1, 66 => 0x7, 119 => 0x1d, 125 => 0x920a, 154 => 0x1d, 170 => 'FocalLength', 188 => 0x12, 239 => 0xa, 240 => 0xb, 244 => [0xc,0x3c], 352 => 0x1, 395 => 0x1d, 404 => 0x403, 429 => 0x1500, 448 => 0xe, 476 => 0x1278, 477 => 0x1134, 478 => 0x32c, 479 => 0x32c, 480 => 0x30a, 534 => 'FocalLength' },
	'focallength2' => { 468 => [0x23,0x25,0x29] },
	'focallength35mm' => { 348 => 'FocalLength35mm' },
	'focallengthin35mmformat' => { 125 => 0xa405, 422 => 'camera.focal_length.35mm_equivalent', 436 => 0xa01a, 534 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 448 => 0x10 },
	'focalplaneafpointarea' => { 481 => 0x2 },
	'focalplaneafpointlocation1' => { 481 => 0x6 },
	'focalplaneafpointlocation10' => { 481 => 0x2a },
	'focalplaneafpointlocation11' => { 481 => 0x2e },
	'focalplaneafpointlocation12' => { 481 => 0x32 },
	'focalplaneafpointlocation13' => { 481 => 0x36 },
	'focalplaneafpointlocation14' => { 481 => 0x3a },
	'focalplaneafpointlocation15' => { 481 => 0x3e },
	'focalplaneafpointlocation2' => { 481 => 0xa },
	'focalplaneafpointlocation3' => { 481 => 0xe },
	'focalplaneafpointlocation4' => { 481 => 0x12 },
	'focalplaneafpointlocation5' => { 481 => 0x16 },
	'focalplaneafpointlocation6' => { 481 => 0x1a },
	'focalplaneafpointlocation7' => { 481 => 0x1e },
	'focalplaneafpointlocation8' => { 481 => 0x22 },
	'focalplaneafpointlocation9' => { 481 => 0x26 },
	'focalplaneafpointsused' => { 481 => 0x1 },
	'focalplanediagonal' => { 335 => 0x103, 339 => 0x205 },
	'focalplaneresolutionunit' => { 125 => 0xa210, 534 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 125 => 0xa20e, 534 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 63 => 0x2 },
	'focalplanexunknown' => { 63 => 0x2 },
	'focalplaneyresolution' => { 125 => 0xa20f, 534 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 63 => 0x3 },
	'focalplaneyunknown' => { 63 => 0x3 },
	'focalpointx' => { 512 => 'FocalPointX' },
	'focalpointy' => { 512 => 'FocalPointY' },
	'focaltype' => { 10 => 0x2d, 63 => 0x0 },
	'focalunits' => { 37 => 0x19 },
	'focus' => { 295 => 0x8 },
	'focusarea' => { 188 => 0x31 },
	'focusareaselection' => { 324 => '15.2' },
	'focusbracket' => { 358 => 0xbd },
	'focusbracketstepsize' => { 334 => 0x308 },
	'focuscontinuous' => { 37 => 0x20 },
	'focusdisplayaiservoandmf' => { 90 => 0x515 },
	'focusdistance' => { 170 => 'FocusDistance', 188 => 0x13, 194 => 0x49bb, 239 => 0x9, 240 => 0xa, 244 => [0xb,0x4e], 337 => 0x305, 352 => 0x0, 356 => 0x304, 357 => 0x304 },
	'focusdistancelower' => { 7 => 0x45, 9 => 0x8e, 11 => 0x45, 13 => 0x56, 14 => 0x45, 15 => 0x45, 16 => 0x52, 17 => 0x52, 18 => 0x56, 20 => 0x52, 21 => 0x8e, 22 => 0x59, 23 => 0x57, 24 => 0x8e, 25 => 0x94, 26 => 0x95, 27 => 0xa7, 28 => 0x56, 29 => 0xa7, 61 => 0x15, 82 => 0x14 },
	'focusdistancerange' => { 1 => 0xc },
	'focusdistancerangewidth' => { 244 => 0x4c },
	'focusdistanceupper' => { 7 => 0x43, 9 => 0x8c, 11 => 0x43, 13 => 0x54, 14 => 0x43, 15 => 0x43, 16 => 0x50, 17 => 0x50, 18 => 0x54, 20 => 0x50, 21 => 0x8c, 22 => 0x57, 23 => 0x55, 24 => 0x8c, 25 => 0x92, 26 => 0x93, 27 => 0xa5, 28 => 0x54, 29 => 0xa5, 61 => 0x14, 82 => 0x13 },
	'focusholdbutton' => { 191 => 0x44 },
	'focusinfoversion' => { 337 => 0x0 },
	'focusingscreen' => { 89 => 0x0, 90 => 0x80b, 95 => 0x0 },
	'focuslocation' => { 463 => 0x2027 },
	'focuslocation2' => { 463 => 0x204a },
	'focuslocked' => { 187 => 0x14 },
	'focusmode' => { 37 => 0x7, 118 => 0x3, 119 => [0x3003,0xd], 133 => 0x1021, 145 => 0x3f5, 147 => 0x38, 163 => 'FocusMode', 188 => 0x30, 190 => 0xe, 191 => 0xc, 246 => 0x7, 334 => 0x301, 339 => 0x100b, 358 => 0x7, 395 => 0xd, 402 => 0x3, 429 => 0x1006, 442 => [0xb,0x5], 448 => [0x15,0x1d], 449 => 0x4d, 450 => 0x4d, 463 => [0xb042,0xb04e,0x201b], 468 => 0x13, 489 => 0x16 },
	'focusmode2' => { 132 => '0.1', 375 => '3.1', 468 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 315 => '10.1', 446 => 0x14, 447 => 0x15, 449 => 0x10, 450 => 0xf, 451 => 0x6 },
	'focusmodeswitch' => { 191 => 0x58, 449 => 0x2e },
	'focuspeakingdisplay' => { 329 => 0x22f, 330 => 0x235, 331 => 0x235, 332 => 0x24d },
	'focuspeakinghighlightcolor' => { 329 => 0x53, 330 => 0x4b, 331 => 0x4b, 332 => 0x4b },
	'focuspeakinglevel' => { 329 => 0x51, 330 => 0x49, 331 => 0x49, 332 => 0x49 },
	'focuspixel' => { 133 => 0x1023 },
	'focuspointlock' => { 330 => 0x1d3, 331 => 0x1d3, 332 => 0x1eb },
	'focuspointpersistence' => { 329 => 0xf5, 330 => 0x105, 331 => 0x105, 332 => 0x11b },
	'focuspointwrap' => { 313 => '2.2', 314 => '2.2', 316 => '2.1', 317 => '2.1', 321 => '1.1', 322 => '2.2', 323 => '1.1', 326 => '2.2', 327 => '2.1', 328 => '2.5', 329 => 0x16, 330 => 0x16, 331 => 0x16, 332 => 0x16 },
	'focusposition' => { 1 => 0x2f, 239 => 0x8, 240 => 0x8, 395 => 0x10, 460 => 0x9bb },
	'focusposition2' => { 468 => [0x29,0x2b,0x2f], 489 => 0x2d, 492 => 0x20 },
	'focuspositionhorizontal' => { 203 => 0x2f, 204 => 0x43 },
	'focuspositionvertical' => { 203 => 0x31, 204 => 0x45 },
	'focusprocess' => { 334 => 0x302 },
	'focusrange' => { 37 => 0x12, 339 => 0x100a },
	'focusrangeindex' => { 385 => '3.1' },
	'focusresult' => { 204 => 0x4a },
	'focusringrotation' => { 90 => 0x713 },
	'focussetting' => { 439 => 0x6 },
	'focusshiftautoreset' => { 256 => 0x6da, 257 => 0x748 },
	'focusshiftexposurelock' => { 235 => 0x1b4, 250 => 0x224, 251 => 0xe8, 252 => 0x100, 255 => 0xf4, 256 => 0x104, 257 => 0x104 },
	'focusshiftinterval' => { 235 => 0x1b0, 250 => 0x220, 251 => 0xe4, 252 => 0xfc, 255 => 0xf0, 256 => 0x100, 257 => 0x100 },
	'focusshiftnumbershots' => { 235 => 0x1a8, 250 => 0x218, 251 => 0xdc, 252 => 0xf4, 255 => 0xe8, 256 => 0xf8, 257 => 0xf8 },
	'focusshiftshooting' => { 274 => 0x20 },
	'focusshiftstepwidth' => { 235 => 0x1ac, 250 => 0x21c, 251 => 0xe0, 252 => 0xf8, 255 => 0xec, 256 => 0xfc, 257 => 0xfc },
	'focusstatus' => { 448 => 0x19, 449 => 0x53, 450 => 0x53 },
	'focusstepcount' => { 337 => 0x301, 339 => 0x100e },
	'focusstepinfinity' => { 337 => 0x303, 339 => 0x103b },
	'focusstepnear' => { 337 => 0x304, 339 => 0x103c },
	'focusstepsfrominfinity' => { 244 => 0x58 },
	'focustrackinglockon' => { 313 => ['1.5','4.1'], 314 => '1.4', 321 => '0.4', 322 => '3.1', 323 => '0.4', 326 => '1.4' },
	'focuswarning' => { 133 => 0x1301 },
	'foldername' => { 188 => 0x27 },
	'foldernumber' => { 449 => 0x9a, 451 => [0x402,0x114,0x316] },
	'fontcomposite' => { 563 => [\'Fonts','FontsComposite'] },
	'fontface' => { 563 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 563 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 563 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 563 => [\'Fonts','FontsFontName'] },
	'fonts' => { 563 => 'Fonts' },
	'fonttype' => { 563 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 563 => [\'Fonts','FontsVersionString'] },
	'for' => { 411 => 'For' },
	'forcewrite' => { 126 => 'ForceWrite' },
	'format' => { 421 => "\xa9fmt", 511 => 'Format', 531 => 'format', 556 => 'Format' },
	'forwardlock' => { 553 => 'forwardlock' },
	'forwardmatrix1' => { 125 => 0xc714 },
	'forwardmatrix2' => { 125 => 0xc715 },
	'forwardmatrix3' => { 125 => 0xcd34 },
	'fossilspecimen' => { 124 => 'FossilSpecimen' },
	'fossilspecimenmaterialsampleid' => { 124 => [\'FossilSpecimen','FossilSpecimenMaterialSampleID'] },
	'framecount' => { 72 => [0x2,0x4] },
	'frameheight' => { 133 => 0x3822 },
	'framenum' => { 406 => 0xd7 },
	'framenumber' => { 133 => 0x8003, 194 => 0x3c, 395 => 0x29 },
	'framerate' => { 72 => [0x1,0x6], 125 => 0xc764, 133 => 0x3820 },
	'framereadouttime' => { 422 => 'camera.framereadouttimeinmicroseconds' },
	'framewidth' => { 133 => 0x3821 },
	'framing' => { 547 => 'framing' },
	'freebytes' => { 103 => 0x1 },
	'freememorycardimages' => { 189 => [0x37,0x54], 190 => [0x2d,0x4a], 191 => 0x32 },
	'fujiflashmode' => { 133 => 0x1010 },
	'fujimodel' => { 133 => 0x1447 },
	'fujimodel2' => { 133 => 0x1448 },
	'fullframerateplaybackintent' => { 415 => 'full-frame-rate-playback-intent' },
	'fullhdhighspeedrec' => { 133 => 0x3824 },
	'fullimagesize' => { 463 => 0xb02b },
	'fullpanoheightpixels' => { 514 => 'FullPanoHeightPixels', 515 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 514 => 'FullPanoWidthPixels', 515 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 429 => 0x100d },
	'fullsizeimage' => { 169 => 'data' },
	'fullsizeimagename' => { 169 => '1Name' },
	'fullsizeimagetype' => { 169 => '0Type' },
	'func1button' => { 316 => '14.1', 317 => '14.1', 327 => '14.1', 329 => 0x67, 330 => 0x63, 331 => 0x63, 332 => 0x63 },
	'func1buttonplaybackmode' => { 329 => 0x19f, 330 => 0x1a5, 331 => 0x1a5, 332 => 0x1bd },
	'func1buttonplusdials' => { 316 => '42.1', 317 => '42.1', 327 => '42.1' },
	'func2button' => { 316 => '80.1', 317 => '80.1', 327 => '80.1', 329 => 0x77, 330 => 0x73, 331 => 0x73, 332 => 0x73 },
	'func2buttonplaybackmode' => { 329 => 0x1a1, 330 => 0x1a7, 331 => 0x1a7, 332 => 0x1bf },
	'func2buttonplusdials' => { 316 => '81.1' },
	'func3button' => { 316 => '83.1', 331 => 0x119, 332 => 0x131 },
	'func3buttonplaybackmode' => { 331 => 0x1a9, 332 => 0x1c1 },
	'func4button' => { 331 => 0x175, 332 => 0x18d },
	'func4buttonplaybackmode' => { 331 => 0x1af, 332 => 0x1c7 },
	'funcbutton' => { 313 => ['14.1','15.1'], 314 => '14.1', 322 => '28.1', 323 => '13.1', 326 => '14.1', 328 => '14.1' },
	'funcbuttonplusdials' => { 313 => ['14.2','15.2'], 314 => '14.2', 322 => '31.1', 326 => '42.1' },
	'functionbutton' => { 320 => '13.1', 324 => '5.2' },
	'gainbase' => { 338 => 0x610 },
	'gaincontrol' => { 125 => 0xa407, 534 => 'GainControl' },
	'gainmapmax' => { 539 => 'GainMapMax' },
	'gainmapmin' => { 539 => 'GainMapMin' },
	'gamma' => { 125 => 0xa500, 145 => 0x8fe, 345 => 'gAMA', 363 => 0x11c, 535 => 'Gamma', 539 => 'Gamma' },
	'gammablackpoint' => { 111 => 0xc },
	'gammacolortone' => { 111 => 0x3 },
	'gammacompensatedvalue' => { 140 => 0x91 },
	'gammacontrast' => { 111 => 0x2 },
	'gammacurveoutputrange' => { 111 => 0xf },
	'gammahighlight' => { 111 => 0xa },
	'gammalinear' => { 109 => 0x20200 },
	'gammamidpoint' => { 111 => 0xe },
	'gammasaturation' => { 111 => 0x4 },
	'gammashadow' => { 111 => 0x9 },
	'gammasharpnessstrength' => { 111 => 0x8 },
	'gammaunsharpmaskfineness' => { 111 => 0x6 },
	'gammaunsharpmaskstrength' => { 111 => 0x5 },
	'gammaunsharpmaskthreshold' => { 111 => 0x7 },
	'gammawhitepoint' => { 111 => 0xd },
	'garminsettings' => { 421 => 'pmcc' },
	'garminsoftware' => { 421 => 'uuid' },
	'gdalmetadata' => { 125 => 0xa480 },
	'gdalnodata' => { 125 => 0xa481 },
	'geimagesize' => { 133 => 0x1304 },
	'gemake' => { 135 => 0x300 },
	'gemodel' => { 135 => 0x207 },
	'genre' => { 413 => ['gnre',"\xa9gen"], 415 => 'genre', 421 => ['gnre',"\xa9gen"], 542 => 'Genre', 548 => 'genre', 558 => 'genre' },
	'genrecvid' => { 542 => [\'Genre','GenreCvId'] },
	'genrecvtermid' => { 542 => [\'Genre','GenreCvTermId'] },
	'genrecvtermname' => { 542 => [\'Genre','GenreCvTermName'] },
	'genrecvtermrefinedabout' => { 542 => [\'Genre','GenreCvTermRefinedAbout'] },
	'genreid' => { 413 => 'geID' },
	'geography' => { 549 => 'geography' },
	'geolocate' => { 126 => 'Geolocate' },
	'geologicalcontext' => { 124 => 'GeologicalContext' },
	'geologicalcontextbed' => { 124 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 124 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 124 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 124 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 124 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 126 => 'Geosync' },
	'geotag' => { 126 => 'Geotag' },
	'geotiffasciiparams' => { 125 => 0x87b1 },
	'geotiffdirectory' => { 125 => 0x87af },
	'geotiffdoubleparams' => { 125 => 0x87b0 },
	'geotime' => { 126 => 'Geotime' },
	'giftftppriority' => { 516 => 'GIFTFtpPriority' },
	'gimbalpitchdegree' => { 122 => 'GimbalPitchDegree' },
	'gimbalreverse' => { 122 => 'GimbalReverse' },
	'gimbalrolldegree' => { 122 => 'GimbalRollDegree' },
	'gimbalyawdegree' => { 122 => 'GimbalYawDegree' },
	'globalaltitude' => { 409 => 0x419 },
	'globalangle' => { 409 => 0x40d },
	'good' => { 558 => 'good' },
	'googlehostheader' => { 413 => 'gshh' },
	'googlepingmessage' => { 413 => 'gspm' },
	'googlepingurl' => { 413 => 'gspu' },
	'googleplusuploadcode' => { 125 => 0x9009 },
	'googlesourcedata' => { 413 => 'gssd' },
	'googlestarttime' => { 413 => 'gsst' },
	'googletrackduration' => { 413 => 'gstd' },
	'goprotype' => { 421 => 'GoPr' },
	'gpsaltitude' => { 137 => 0x6, 167 => 'Altitude', 534 => 'GPSAltitude' },
	'gpsaltituderef' => { 137 => 0x5, 534 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 137 => 0x1c, 534 => 'GPSAreaInformation' },
	'gpscoordinates' => { 413 => "\xa9xyz", 415 => 'location.ISO6709', 421 => ['@xyz',"\xa9xyz"] },
	'gpsdatestamp' => { 137 => 0x1d },
	'gpsdatetime' => { 167 => 'DateTime', 534 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 137 => 0x18, 167 => 'Bearing', 534 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 137 => 0x17, 534 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 137 => 0x1a, 167 => 'Distance', 534 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 137 => 0x19, 534 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 137 => 0x14, 534 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 137 => 0x13 },
	'gpsdestlongitude' => { 137 => 0x16, 534 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 137 => 0x15 },
	'gpsdifferential' => { 137 => 0x1e, 167 => 'Differential', 534 => 'GPSDifferential' },
	'gpsdop' => { 137 => 0xb, 534 => 'GPSDOP' },
	'gpshpositioningerror' => { 137 => 0x1f, 534 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 137 => 0x11, 534 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 137 => 0x10, 534 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 120 => 'GPS-GPSLatitude', 122 => 'GpsLatitude', 137 => 0x2, 167 => 'Latitude', 534 => 'GPSLatitude' },
	'gpslatituderef' => { 137 => 0x1 },
	'gpslongitude' => { 120 => 'GPS-GPSLongitude', 122 => 'GpsLongitude', 137 => 0x4, 167 => 'Longitude', 534 => 'GPSLongitude' },
	'gpslongituderef' => { 137 => 0x3 },
	'gpslongtitude' => { 122 => 'GpsLongtitude' },
	'gpsmapdatum' => { 137 => 0x12, 167 => 'Datum', 534 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 137 => 0xa, 167 => 'MeasureMode', 534 => 'GPSMeasureMode' },
	'gpsposition' => { 120 => 'Exif-GPSPosition' },
	'gpsprocessingmethod' => { 137 => 0x1b, 534 => 'GPSProcessingMethod' },
	'gpssatellites' => { 137 => 0x8, 167 => 'Satellites', 534 => 'GPSSatellites' },
	'gpsspeed' => { 137 => 0xd, 167 => 'Speed', 534 => 'GPSSpeed' },
	'gpsspeedref' => { 137 => 0xc, 534 => 'GPSSpeedRef' },
	'gpsstatus' => { 137 => 0x9, 534 => 'GPSStatus' },
	'gpsstring' => { 145 => 0x402 },
	'gpstimestamp' => { 137 => 0x7 },
	'gpstrack' => { 137 => 0xf, 167 => 'Heading', 534 => 'GPSTrack' },
	'gpstrackref' => { 137 => 0xe, 534 => 'GPSTrackRef' },
	'gpsversionid' => { 137 => 0x0, 534 => 'GPSVersionID' },
	'gradation' => { 334 => 0x50f },
	'gradientbasedcorractive' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrblacks2012' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'] },
	'gradientbasedcorrbrightness' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrcorrectionname' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'] },
	'gradientbasedcorrcorrectionsyncid' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'] },
	'gradientbasedcorrdefringe' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrdehaze' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'] },
	'gradientbasedcorrections' => { 528 => 'GradientBasedCorrections', 530 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'] },
	'gradientbasedcorrluminancenoise' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskinputdigest' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'gradientbasedcorrmaskleft' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmaskactive' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'gradientbasedcorrmaskmaskblendmode' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmaskdigest' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'gradientbasedcorrmaskmaskinverted' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'gradientbasedcorrmaskmaskname' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'] },
	'gradientbasedcorrmaskmasks' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'] },
	'gradientbasedcorrmaskmasksalpha' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'gradientbasedcorrmaskmasksangle' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'gradientbasedcorrmaskmasksbottom' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'gradientbasedcorrmaskmaskscentervalue' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'gradientbasedcorrmaskmaskscenterweight' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'gradientbasedcorrmaskmasksdabs' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'gradientbasedcorrmaskmasksfeather' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'gradientbasedcorrmaskmasksflipped' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'gradientbasedcorrmaskmasksflow' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'gradientbasedcorrmaskmasksfullx' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'gradientbasedcorrmaskmasksfully' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'gradientbasedcorrmaskmasksinputdigest' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'gradientbasedcorrmaskmasksleft' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'gradientbasedcorrmaskmasksmaskactive' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'gradientbasedcorrmaskmasksmaskblendmode' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmasksmaskdigest' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'gradientbasedcorrmaskmasksmaskinverted' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'gradientbasedcorrmaskmasksmaskname' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'gradientbasedcorrmaskmasksmasksubtype' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksmasksyncid' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'gradientbasedcorrmaskmasksmaskversion' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'gradientbasedcorrmaskmasksmidpoint' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'gradientbasedcorrmaskmasksorigin' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'gradientbasedcorrmaskmasksperimetervalue' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'gradientbasedcorrmaskmasksradius' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'gradientbasedcorrmaskmasksreferencepoint' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'gradientbasedcorrmaskmasksright' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'gradientbasedcorrmaskmasksroundness' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'gradientbasedcorrmaskmaskssizex' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'gradientbasedcorrmaskmaskssizey' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'gradientbasedcorrmaskmaskstop' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'gradientbasedcorrmaskmasksubtype' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksvalue' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'gradientbasedcorrmaskmasksversion' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'gradientbasedcorrmaskmaskswhat' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'gradientbasedcorrmaskmaskswholeimagearea' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'gradientbasedcorrmaskmasksx' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'] },
	'gradientbasedcorrmaskmasksy' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'] },
	'gradientbasedcorrmaskmasksyncid' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'gradientbasedcorrmaskmaskszerox' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'gradientbasedcorrmaskmaskszeroy' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'gradientbasedcorrmaskmaskversion' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'gradientbasedcorrmaskmidpoint' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskorigin' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'] },
	'gradientbasedcorrmaskperimetervalue' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskrange' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'gradientbasedcorrmaskrangeareamodels' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrmaskrangeareamodelscolorsampleinfo' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrmaskrangeareamodelscomponents' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrmaskrangecoloramount' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrmaskrangedepthfeather' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrmaskrangedepthmax' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrmaskrangedepthmin' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrmaskrangeinvert' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'gradientbasedcorrmaskrangelumfeather' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrmaskrangeluminancedepthsampleinfo' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrmaskrangelummax' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrmaskrangelummin' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrmaskrangelumrange' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrmaskrangesampletype' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrmaskrangetype' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'gradientbasedcorrmaskrangeversion' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'gradientbasedcorrmaskreferencepoint' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'gradientbasedcorrmaskright' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskwholeimagearea' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'gradientbasedcorrmaskx' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrrangemask' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'] },
	'gradientbasedcorrrangemaskareamodels' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrrangemaskareamodelscolorsampleinfo' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrrangemaskareamodelscomponents' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrrangemaskcoloramount' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrrangemaskdepthfeather' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrrangemaskdepthmax' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrrangemaskdepthmin' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrrangemaskinvert' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'gradientbasedcorrrangemasklumfeather' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrrangemaskluminancedepthsampleinfo' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrrangemasklummax' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrrangemasklummin' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrrangemasklumrange' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrrangemasksampletype' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrrangemasktype' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'] },
	'gradientbasedcorrrangemaskversion' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'gradientbasedcorrsaturation' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'] },
	'gradientbasedcorrshadows2012' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtexture' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'] },
	'gradientbasedcorrtint' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrtoninghue' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrtoningsaturation' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrwhat' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'gradientbasedcorrwhites2012' => { 528 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'], 530 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'] },
	'grainamount' => { 528 => 'GrainAmount', 530 => 'GrainAmount' },
	'graineffectroughness' => { 133 => 0x1047 },
	'graineffectsize' => { 133 => 0x104c },
	'grainfrequency' => { 528 => 'GrainFrequency', 530 => 'GrainFrequency' },
	'grainseed' => { 528 => 'GrainSeed', 530 => 'GrainSeed' },
	'grainsize' => { 528 => 'GrainSize', 530 => 'GrainSize' },
	'graymixeraqua' => { 528 => 'GrayMixerAqua', 530 => 'GrayMixerAqua' },
	'graymixerblue' => { 528 => 'GrayMixerBlue', 530 => 'GrayMixerBlue' },
	'graymixergreen' => { 528 => 'GrayMixerGreen', 530 => 'GrayMixerGreen' },
	'graymixermagenta' => { 528 => 'GrayMixerMagenta', 530 => 'GrayMixerMagenta' },
	'graymixerorange' => { 528 => 'GrayMixerOrange', 530 => 'GrayMixerOrange' },
	'graymixerpurple' => { 528 => 'GrayMixerPurple', 530 => 'GrayMixerPurple' },
	'graymixerred' => { 528 => 'GrayMixerRed', 530 => 'GrayMixerRed' },
	'graymixeryellow' => { 528 => 'GrayMixerYellow', 530 => 'GrayMixerYellow' },
	'graypoint' => { 500 => 0x8021 },
	'grayresponseunit' => { 125 => 0x122 },
	'greencurvelimits' => { 114 => 0x1c4 },
	'greencurvepoints' => { 113 => 0x53, 114 => 0x19a },
	'greenghostmitigationstatus' => { 1 => 0x3f },
	'greenhsl' => { 109 => 0x20913 },
	'greenhue' => { 528 => 'GreenHue', 530 => 'GreenHue' },
	'greensaturation' => { 528 => 'GreenSaturation', 530 => 'GreenSaturation' },
	'griddisplay' => { 313 => '13.3', 314 => '4.3', 316 => '4.2', 317 => '4.2', 318 => '2.2', 322 => '10.5', 323 => '3.4', 324 => '6.1', 326 => '4.4', 327 => '4.2', 328 => '4.2' },
	'gripbatteryadload' => { 372 => 0x5 },
	'gripbatteryadnoload' => { 372 => 0x4 },
	'gripbatterypercent' => { 372 => 0x11 },
	'gripbatterystate' => { 372 => ['1.2',0x10] },
	'gripbatteryvoltage' => { 372 => 0x12 },
	'group' => { 528 => 'Group', 530 => 'Group' },
	'groupareaafillumination' => { 314 => '46.4', 317 => '47.4', 326 => '47.4' },
	'grouping' => { 413 => ['grup',"\xa9grp"], 421 => "\xa9grp" },
	'guid' => { 413 => 'GUID' },
	'h2resetblackpixels' => { 145 => 0x18a6 },
	'h3resetblackcolumns' => { 145 => 0x18ce },
	'h3resetblackpixels' => { 145 => 0x18b0 },
	'halftonehints' => { 125 => 0x141 },
	'hardlink' => { 126 => 'HardLink' },
	'hasalternative' => { 548 => 'hasAlternative' },
	'hascorrection' => { 548 => 'hasCorrection' },
	'hascorrectiona-lang' => { 548 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 548 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 548 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 528 => 'HasCrop', 530 => 'HasCrop' },
	'hasextendedxmp' => { 560 => 'HasExtendedXMP' },
	'hassettings' => { 528 => 'HasSettings', 530 => 'HasSettings' },
	'hastranslation' => { 548 => 'hasTranslation' },
	'hasvisibleoverprint' => { 563 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 563 => 'HasVisibleTransparency' },
	'hdmioutputn-log' => { 251 => 0x35a },
	'hdmioutputresolution' => { 253 => 0x710, 254 => 0x720, 255 => 0x610, 256 => 0x640, 257 => 0x6a8 },
	'hdmiviewassist' => { 331 => 0x20f, 332 => 0x227 },
	'hdr' => { 64 => 0x1, 231 => 0x4, 232 => 0x4, 250 => 0x354, 252 => 0x23a, 257 => 0x23a, 358 => 0x9e, 395 => 0x85, 463 => 0x200a },
	'hdrcapacitymax' => { 539 => 'HDRCapacityMax' },
	'hdrcapacitymin' => { 539 => 'HDRCapacityMin' },
	'hdreditmode' => { 528 => 'HDREditMode', 530 => 'HDREditMode' },
	'hdreffect' => { 64 => 0x2 },
	'hdrgain' => { 1 => 0x30 },
	'hdrgainmapversion' => { 517 => 'HDRGainMapVersion' },
	'hdrheadroom' => { 1 => 0x21 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrlevel' => { 231 => 0x5, 232 => 0x5, 250 => 0x360, 252 => 0x246, 257 => 0x246, 451 => 0x2e, 468 => 0x17 },
	'hdrlevel2' => { 231 => 0x7 },
	'hdrplusmakernote' => { 508 => 'HdrPlusMakernote' },
	'hdrpmakernote' => { 508 => 'hdrp_makernote' },
	'hdrsetting' => { 451 => 0x2d, 468 => 0x16, 472 => 0x1148, 473 => 0x1148, 474 => 0x1124, 475 => 0x11a0, 476 => 0x117c, 477 => 0x1034, 478 => 0x22c, 479 => 0x22c, 480 => 0x21f },
	'hdrsmoothing' => { 231 => 0x6 },
	'hdvideo' => { 413 => 'hdvd' },
	'headline' => { 138 => 0x69, 542 => 'Headline', 546 => 'Headline' },
	'hiddendatalength' => { 461 => 0x1 },
	'hiddendataoffset' => { 461 => 0x0 },
	'hierarchicalkeywords' => { 178 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 178 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 178 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 178 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 178 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 178 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 519 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 124 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highframerate' => { 250 => 0x16c, 252 => 0x48, 256 => 0x48, 257 => 0x48 },
	'highfrequencyflickerreduction' => { 250 => 0x386, 252 => 0x27c, 256 => 0x27c, 257 => 0x27c },
	'highisomultiplierblue' => { 363 => 0x1a },
	'highisomultipliergreen' => { 363 => 0x19 },
	'highisomultiplierred' => { 363 => 0x18 },
	'highisonoisereduction' => { 16 => 0xbc, 17 => 0xbd, 20 => 0xbd, 28 => 0xc9, 67 => 0x5, 90 => 0x202, 246 => 0xb1, 395 => 0x71, 449 => 0x2c, 450 => 0x26, 451 => 0x26, 463 => 0x2009, 468 => 0x12, 495 => 0x42 },
	'highisonoisereduction2' => { 463 => 0xb050 },
	'highlight' => { 439 => 0xf },
	'highlight2012' => { 528 => 'Highlight2012', 530 => 'Highlight2012' },
	'highlightadj' => { 109 => 0x2030c },
	'highlightcolordistortreduct' => { 500 => 0x8026 },
	'highlightlinearitylimit' => { 436 => 0xa025 },
	'highlightprotection' => { 305 => 0x6 },
	'highlightrecovery' => { 528 => 'HighlightRecovery', 530 => 'HighlightRecovery' },
	'highlights' => { 463 => 0x2033, 521 => 'Highlights' },
	'highlights2012' => { 528 => 'Highlights2012', 530 => 'Highlights2012' },
	'highlightsadj' => { 500 => 0x9019 },
	'highlightshadow' => { 358 => 0xad },
	'highlighttone' => { 133 => 0x1041 },
	'highlighttonepriority' => { 13 => 0x7, 16 => 0x7, 17 => 0x7, 18 => 0x7, 20 => 0x7, 22 => 0x7, 28 => 0x7, 67 => 0x3, 90 => 0x203 },
	'highlightwarning' => { 358 => 0x8002 },
	'highlowkeyadj' => { 395 => 0x6c },
	'highspeedsync' => { 191 => 0x5, 329 => 0x59, 330 => 0x55, 331 => 0x55, 332 => 0x55, 449 => 0x2, 450 => 0x2 },
	'hintversion' => { 421 => 'hinv' },
	'histogramxml' => { 306 => 0x83a1a25 },
	'history' => { 546 => 'History', 559 => 'History' },
	'historyaction' => { 559 => [\'History','HistoryAction'] },
	'historychanged' => { 559 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 559 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 559 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 559 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 559 => [\'History','HistoryWhen'] },
	'holefilldarkdeltathreshold' => { 145 => 0xc88 },
	'holefilldeltathreshold' => { 145 => 0xc7e },
	'hometowncity' => { 119 => 0x3006, 395 => 0x23, 401 => 0x2 },
	'hometowncitycode' => { 402 => 0x1000 },
	'hometowndst' => { 395 => 0x25, 401 => '0.2' },
	'hostcomputer' => { 125 => 0x13c },
	'hostsoftwarerendering' => { 145 => 0xce7 },
	'hue' => { 196 => 0x3b, 265 => 0x3d, 266 => 0x45, 395 => 0x67 },
	'hueadj' => { 309 => 0x2f, 500 => 0x8019 },
	'hueadjust' => { 429 => 0x1016 },
	'hueadjustment' => { 189 => 0x4a, 190 => 0x40, 246 => 0x92, 264 => 0x36 },
	'hueadjustmentaqua' => { 528 => 'HueAdjustmentAqua', 530 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 528 => 'HueAdjustmentBlue', 530 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 528 => 'HueAdjustmentGreen', 530 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 528 => 'HueAdjustmentMagenta', 530 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 528 => 'HueAdjustmentOrange', 530 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 528 => 'HueAdjustmentPurple', 530 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 528 => 'HueAdjustmentRed', 530 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 528 => 'HueAdjustmentYellow', 530 => 'HueAdjustmentYellow' },
	'huesetting' => { 342 => 0x1011 },
	'humanobservation' => { 124 => 'HumanObservation' },
	'humanobservationday' => { 124 => [\'HumanObservation','HumanObservationDay'] },
	'humanobservationearliestdate' => { 124 => [\'HumanObservation','HumanObservationEarliestDate'] },
	'humanobservationenddayofyear' => { 124 => [\'HumanObservation','HumanObservationEndDayOfYear'] },
	'humanobservationeventdate' => { 124 => [\'HumanObservation','HumanObservationEventDate'] },
	'humanobservationeventid' => { 124 => [\'HumanObservation','HumanObservationEventID'] },
	'humanobservationeventremarks' => { 124 => [\'HumanObservation','HumanObservationEventRemarks'] },
	'humanobservationeventtime' => { 124 => [\'HumanObservation','HumanObservationEventTime'] },
	'humanobservationeventtype' => { 124 => [\'HumanObservation','HumanObservationEventType'] },
	'humanobservationfieldnotes' => { 124 => [\'HumanObservation','HumanObservationFieldNotes'] },
	'humanobservationfieldnumber' => { 124 => [\'HumanObservation','HumanObservationFieldNumber'] },
	'humanobservationhabitat' => { 124 => [\'HumanObservation','HumanObservationHabitat'] },
	'humanobservationlatestdate' => { 124 => [\'HumanObservation','HumanObservationLatestDate'] },
	'humanobservationmonth' => { 124 => [\'HumanObservation','HumanObservationMonth'] },
	'humanobservationparenteventid' => { 124 => [\'HumanObservation','HumanObservationParentEventID'] },
	'humanobservationsamplesizeunit' => { 124 => [\'HumanObservation','HumanObservationSampleSizeUnit'] },
	'humanobservationsamplesizevalue' => { 124 => [\'HumanObservation','HumanObservationSampleSizeValue'] },
	'humanobservationsamplingeffort' => { 124 => [\'HumanObservation','HumanObservationSamplingEffort'] },
	'humanobservationsamplingprotocol' => { 124 => [\'HumanObservation','HumanObservationSamplingProtocol'] },
	'humanobservationstartdayofyear' => { 124 => [\'HumanObservation','HumanObservationStartDayOfYear'] },
	'humanobservationverbatimeventdate' => { 124 => [\'HumanObservation','HumanObservationVerbatimEventDate'] },
	'humanobservationyear' => { 124 => [\'HumanObservation','HumanObservationYear'] },
	'humidity' => { 125 => 0x9401, 535 => 'Humidity' },
	'icc_profile' => { 126 => 'ICC_Profile', 136 => 'ICCRGBG1/012' },
	'iccprofilename' => { 546 => 'ICCProfile' },
	'iconuri' => { 421 => 'icnu' },
	'idccreativestyle' => { 500 => 0x8000 },
	'idcpreviewlength' => { 500 => 0x202 },
	'idcpreviewstart' => { 500 => 0x201 },
	'identification' => { 124 => 'Identification' },
	'identificationid' => { 124 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 124 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 124 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 124 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 124 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 124 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifiedbyid' => { 124 => [\'Identification','IdentificationIdentifiedByID'] },
	'identifier' => { 531 => 'identifier', 556 => 'Identifier' },
	'ifcameramodel' => { 145 => 0x9c8 },
	'illuminantdata1' => { 125 => 0xcd35 },
	'illuminantdata2' => { 125 => 0xcd36 },
	'illuminantdata3' => { 125 => 0xcd37 },
	'illumination' => { 324 => '0.5', 424 => 0x48 },
	'imageabsolutex' => { 145 => 0x3fe },
	'imageabsolutey' => { 145 => 0x3ff },
	'imageadjustment' => { 246 => 0x80, 295 => 0x5 },
	'imagealterationconstraints' => { 344 => 'ImageAlterationConstraints' },
	'imagearea' => { 236 => 0x2b, 273 => 0x2b, 281 => 0x10, 284 => 0x10 },
	'imageareaoffset' => { 395 => 0x38 },
	'imageauthentication' => { 246 => 0x20 },
	'imageboundary' => { 246 => 0x16 },
	'imagecapturerequestid' => { 1 => 0x20 },
	'imagecapturetype' => { 1 => 0x14 },
	'imagecount' => { 133 => 0x1438, 246 => 0xa5, 466 => 0x11b },
	'imagecreator' => { 344 => 'ImageCreator' },
	'imagecreatorid' => { 344 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 344 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 344 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagecropx' => { 145 => 0x41f },
	'imagecropy' => { 145 => 0x420 },
	'imagedata' => { 513 => 'Data' },
	'imagedatasize' => { 246 => 0xa2 },
	'imagedescription' => { 125 => 0x10e, 554 => 'ImageDescription' },
	'imageduplicationconstraints' => { 344 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 306 => 0xfe443a45 },
	'imageeditcount' => { 395 => 0x41 },
	'imageediting' => { 395 => 0x32 },
	'imageeditingsoftware' => { 125 => 0xa43b, 535 => 'ImageEditingSoftware' },
	'imageeditor' => { 125 => 0xa438, 535 => 'ImageEditor' },
	'imageeffects' => { 429 => 0x1010 },
	'imagefileconstraints' => { 344 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 344 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 344 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 133 => 0x1436 },
	'imageheight' => { 125 => 0x101, 195 => 0xc, 404 => 0x10d, 511 => 'ImageHeight', 554 => 'ImageLength' },
	'imagehistory' => { 125 => 0x9213, 533 => 'ImageHistory' },
	'imageidnumber' => { 353 => 0x340 },
	'imagemimetype' => { 513 => 'Mime' },
	'imagenumber' => { 125 => 0x9211, 163 => 'ImageNumber', 189 => 0xae, 190 => 0x5e, 404 => 0x113, 449 => 0x9b, 451 => [0x400,'276.1',0x314], 525 => 'ImageNumber' },
	'imagenumber2' => { 190 => 0x62 },
	'imageoptimization' => { 246 => 0xa9 },
	'imageorientation' => { 138 => 0x83 },
	'imageprocessing' => { 246 => 0x1a },
	'imageprocessingfiledatecreated' => { 145 => 0xc81 },
	'imageprocessingfiletagsversionnumber' => { 145 => 0xc80 },
	'imageprocessingflags' => { 1 => 0x19 },
	'imageprocessingversion' => { 338 => 0x0 },
	'imagequality' => { 163 => 'ImageQuality', 283 => '723.2', 284 => '732.2', 292 => '708.1', 358 => 0x1 },
	'imagequality2' => { 334 => 0x603 },
	'imagerank' => { 516 => 'ImageRank' },
	'imagerbiassettlingdelaymsec' => { 145 => 0x600 },
	'imagerboardversion' => { 145 => 0x439 },
	'imagercols' => { 145 => 0x17d4 },
	'imageref' => { 540 => 'ImageRef' },
	'imageregion' => { 542 => 'ImageRegion' },
	'imageregionboundary' => { 542 => [\'ImageRegion','ImageRegionRegionBoundary'] },
	'imageregionboundaryh' => { 542 => [\'ImageRegion','ImageRegionRegionBoundaryRbH'] },
	'imageregionboundaryrx' => { 542 => [\'ImageRegion','ImageRegionRegionBoundaryRbRx'] },
	'imageregionboundaryshape' => { 542 => [\'ImageRegion','ImageRegionRegionBoundaryRbShape'] },
	'imageregionboundaryunit' => { 542 => [\'ImageRegion','ImageRegionRegionBoundaryRbUnit'] },
	'imageregionboundaryvertices' => { 542 => [\'ImageRegion','ImageRegionRegionBoundaryRbVertices'] },
	'imageregionboundaryverticesx' => { 542 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbX'] },
	'imageregionboundaryverticesy' => { 542 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbY'] },
	'imageregionboundaryw' => { 542 => [\'ImageRegion','ImageRegionRegionBoundaryRbW'] },
	'imageregionboundaryx' => { 542 => [\'ImageRegion','ImageRegionRegionBoundaryRbX'] },
	'imageregionboundaryy' => { 542 => [\'ImageRegion','ImageRegionRegionBoundaryRbY'] },
	'imageregionctype' => { 542 => [\'ImageRegion','ImageRegionRCtype'] },
	'imageregionctypeidentifier' => { 542 => [\'ImageRegion','ImageRegionRCtypeIdentifier'] },
	'imageregionctypename' => { 542 => [\'ImageRegion','ImageRegionRCtypeName'] },
	'imageregionid' => { 542 => [\'ImageRegion','ImageRegionRId'] },
	'imageregionname' => { 542 => [\'ImageRegion','ImageRegionName'] },
	'imageregionrole' => { 542 => [\'ImageRegion','ImageRegionRRole'] },
	'imageregionroleidentifier' => { 542 => [\'ImageRegion','ImageRegionRRoleIdentifier'] },
	'imageregionrolename' => { 542 => [\'ImageRegion','ImageRegionRRoleName'] },
	'imageresolution' => { 145 => 0x944 },
	'imageresolutionjpg' => { 145 => 0x945 },
	'imagereview' => { 315 => '0.4', 324 => '0.4' },
	'imagereviewmonitorofftime' => { 314 => '21.1', 316 => '21.1', 317 => '21.1', 321 => '20.1', 326 => '21.1', 327 => '21.1', 329 => 0x3b, 330 => 0x39, 331 => 0x39, 332 => 0x39 },
	'imagereviewtime' => { 313 => '25.1', 315 => '2.1', 318 => '19.1', 319 => '20.1', 320 => '20.1', 322 => '9.2', 323 => '20.1', 328 => '21.2' },
	'imagerfiledatecreated' => { 145 => 0x9c5 },
	'imagerfileproductionlevel' => { 145 => 0x9c4 },
	'imagerfiletagsversionstandard' => { 145 => 0x9c7 },
	'imagerotated' => { 158 => 0x2a },
	'imagerpowerondelaymsec' => { 145 => 0x5fd },
	'imagerrows' => { 145 => 0x17de },
	'imagesegmentlines' => { 145 => 0x184d },
	'imagesegmentstartline' => { 145 => 0x184c },
	'imagesequenceinfo' => { 125 => 0xcd44 },
	'imagesize' => { 169 => 'ImageSize' },
	'imagesizeraw' => { 246 => 0x3e },
	'imagesizerestriction' => { 551 => 'imageSizeRestriction' },
	'imagesourcedata' => { 125 => 0x935c },
	'imagespace' => { 145 => 0x909 },
	'imagestabilization' => { 37 => 0x22, 119 => 0x3020, 133 => 0x1422, 163 => 'ImageStabilization', 189 => 0xbd, 190 => 0x71, 191 => 0x57, 192 => 0x0, 193 => [0x18,0x107,0x113], 194 => 0x49c2, 246 => 0xac, 334 => 0x604, 337 => 0x1600, 358 => 0x1a, 454 => 0x12, 455 => 0x11, 463 => 0xb026 },
	'imagestabilization2' => { 453 => 0xa },
	'imagestabilizationsetting' => { 194 => 0x14, 449 => 0x3d, 450 => 0x3d, 460 => 0x14 },
	'imagestats' => { 125 => 0xcd46 },
	'imagestyle' => { 449 => 0x2d, 450 => 0x27 },
	'imagesupplier' => { 344 => 'ImageSupplier' },
	'imagesupplierid' => { 344 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 344 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 344 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 127 => 0x1 },
	'imagetemperaturemin' => { 127 => 0x2 },
	'imagetitle' => { 125 => 0xa436, 535 => 'ImageTitle' },
	'imagetone' => { 395 => 0x4f },
	'imagetype' => { 138 => 0x82, 344 => 'ImageType' },
	'imageuniqueid' => { 1 => 0x15, 69 => 0x28, 125 => 0xa420, 533 => 'ImageUniqueID', 534 => 'ImageUniqueID', 535 => 'ImageUniqueID' },
	'imagewidth' => { 125 => 0x100, 195 => 0xe, 404 => 0x10c, 511 => 'ImageWidth', 554 => 'ImageWidth' },
	'inclinationangle' => { 500 => 0x900f },
	'inclinationcorrection' => { 500 => 0x900e },
	'incrementaltemperature' => { 528 => 'IncrementalTemperature', 530 => 'IncrementalTemperature' },
	'incrementaltint' => { 528 => 'IncrementalTint', 530 => 'IncrementalTint' },
	'industry' => { 548 => 'industry', 549 => 'industry' },
	'infobuttonwhenshooting' => { 90 => 0x409 },
	'information' => { 415 => 'information', 421 => "\xa9inf" },
	'infourl' => { 421 => 'infu' },
	'infraredilluminator' => { 423 => 0x28 },
	'ingredientexclusion' => { 550 => 'ingredientExclusion' },
	'ingredients' => { 559 => 'Ingredients' },
	'ingredientsalternatepaths' => { 559 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 559 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 559 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 559 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 559 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 559 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 559 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 559 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 559 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 559 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 559 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 559 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 559 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 559 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 559 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 559 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 559 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 559 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 559 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 559 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 559 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 559 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 559 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 90 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 514 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 514 => 'InitialHorizontalFOVDegrees' },
	'initialkey' => { 186 => 'WM/InitialKey' },
	'initialverticalfovdegrees' => { 514 => 'InitialVerticalFOVDegrees' },
	'initialviewheadingdegrees' => { 514 => 'InitialViewHeadingDegrees', 515 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 514 => 'InitialViewPitchDegrees', 515 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 514 => 'InitialViewRollDegrees', 515 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 313 => '4.4' },
	'initialzoomsetting' => { 313 => '9.3', 322 => '27.3' },
	'inkset' => { 125 => 0x14c },
	'inputprofile' => { 145 => 0x1389 },
	'instanceid' => { 559 => 'InstanceID' },
	'instantplaybacksetup' => { 191 => 0x3e },
	'instantplaybacktime' => { 191 => 0x3d },
	'instructions' => { 546 => 'Instructions' },
	'instrument' => { 558 => 'instrument' },
	'integrationtime' => { 145 => 0x423 },
	'intellectualgenre' => { 541 => 'IntellectualGenre' },
	'intelligentauto' => { 463 => 0xb052, 491 => 0xd, 492 => 0xe, 493 => 0xd },
	'intelligentcontrast' => { 56 => 0x4 },
	'intelligentd-range' => { 358 => 0x79 },
	'intelligentexposure' => { 358 => 0x5d },
	'intelligentresolution' => { 358 => 0x70 },
	'interchangecolorspace' => { 140 => 0x40 },
	'intergraphmatrix' => { 125 => 0x8480 },
	'internalflash' => { 188 => 0x2b, 313 => '23.1', 315 => '8.1', 318 => '22.1', 320 => '23.1', 324 => '8.1', 328 => '24.1', 337 => 0x1208 },
	'internalflashae1' => { 339 => 0x1021 },
	'internalflashae1_0' => { 339 => 0x101d },
	'internalflashae2' => { 339 => 0x1022 },
	'internalflashae2_0' => { 339 => 0x101e },
	'internalflashmode' => { 382 => 0x1 },
	'internalflashstrength' => { 382 => 0x3 },
	'internalflashtable' => { 339 => 0x1024 },
	'internallensserialnumber' => { 436 => 0xa005 },
	'internalndfilter' => { 358 => 0x9d },
	'internalserialnumber' => { 69 => 0x96, 81 => 0x9, 133 => 0x10, 194 => 0x49dc, 333 => 0x18, 335 => 0x102, 355 => 0x500, 358 => 0x25, 374 => 0x4, 429 => 0x5, 482 => [0x7c,0xf0], 483 => 0x88, 484 => [0x88,0x8a], 485 => 0x38 },
	'interopindex' => { 125 => 0x1, 535 => 'InteroperabilityIndex' },
	'interopversion' => { 125 => 0x2 },
	'interval' => { 271 => 0x20 },
	'intervaldurationhours' => { 250 => 0x1dc, 251 => 0xa0, 252 => 0xb8 },
	'intervaldurationminutes' => { 250 => 0x1e0, 251 => 0xa4, 252 => 0xbc },
	'intervaldurationseconds' => { 250 => 0x1e4, 251 => 0xa8, 252 => 0xc0 },
	'intervalexposuresmoothing' => { 235 => 0x184, 250 => 0x1f4, 251 => 0xb8, 252 => 0xd0 },
	'intervalframe' => { 271 => 0x24 },
	'intervallength' => { 188 => 0x10 },
	'intervalmode' => { 188 => 0x26 },
	'intervalnumber' => { 188 => 0x11 },
	'intervalpriority' => { 235 => 0x186, 250 => 0x1f6, 251 => 0xba, 252 => 0xd2 },
	'intervals' => { 235 => 0x17c, 250 => 0x1ec, 251 => 0xb0, 252 => 0xc8, 255 => 0xbc, 256 => 0xcc, 257 => 0xcc },
	'intervalshooting' => { 236 => 0x24, 273 => 0x24, 274 => 0x28, 395 => 0x92 },
	'introtime' => { 558 => 'introTime' },
	'introtimescale' => { 558 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 558 => [\'introTime','introTimeValue'] },
	'ipaversion' => { 145 => 0xdae },
	'ipfcameramodel' => { 145 => 0xe4d },
	'iptc' => { 126 => 'IPTC' },
	'iptc-naa' => { 125 => 0x83bb, 363 => 0x83bb },
	'iptcbitspersample' => { 140 => 0x56 },
	'iptcdigest' => { 409 => 0x425 },
	'iptcimageheight' => { 140 => 0x1e },
	'iptcimagerotation' => { 140 => 0x66 },
	'iptcimagewidth' => { 140 => 0x14 },
	'iptclastedited' => { 542 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 140 => 0xa },
	'iptcpixelheight' => { 140 => 0x32 },
	'iptcpixelwidth' => { 140 => 0x28 },
	'isalternativeof' => { 548 => 'isAlternativeOf' },
	'isbn' => { 548 => 'isbn' },
	'iscorrectionof' => { 548 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 115 => 0x3 },
	'ismergedhdr' => { 525 => 'IsMergedHDR' },
	'ismergedpanorama' => { 525 => 'IsMergedPanorama' },
	'iso' => { 7 => 0x6, 9 => 0x6, 10 => 0x75, 11 => 0x6, 12 => 0x79, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x6, 31 => 0x0, 32 => 0x1, 118 => 0x14, 119 => [0x3014,0x14], 125 => 0x8827, 144 => 0xfd06, 145 => 0x1784, 147 => 0x60, 149 => [0xfa2e,0xfa46], 150 => [0x27,0x28], 151 => 0xf105, 154 => 0x14, 156 => 0x4e, 158 => 0x1e, 159 => 0x1a, 161 => 0x34, 163 => 'ISO', 188 => 0x8, 194 => 0x49ba, 234 => 0x0, 246 => 0x2, 358 => 0xd1, 363 => [0x17,0x37], 395 => [0x8b,0x14], 402 => 0x14, 404 => 0x105, 436 => 0xa014, 439 => 0x86, 460 => 0x6f, 468 => [0x1f,0x21,0x25], 534 => 'ISOSpeedRatings' },
	'iso2' => { 234 => 0x6, 278 => 0x265, 279 => 0x25c, 280 => 0x265, 281 => 0x221, 282 => 0x25d, 283 => 0x256, 284 => 0x25d, 287 => 0x2b5, 290 => 0x265, 294 => 0x2b5 },
	'isoauto' => { 375 => '14.4' },
	'isoautoflashlimit' => { 252 => 0x156, 255 => 0x146, 256 => 0x15a, 257 => 0x15a },
	'isoautohilimit' => { 233 => 0x5, 250 => 0x28a, 252 => 0x154, 255 => 0x144, 256 => 0x158, 257 => 0x158, 276 => 0x5, 286 => 0x18eb },
	'isoautomax' => { 462 => 0x4 },
	'isoautomin' => { 462 => 0x2 },
	'isoautominspeed' => { 395 => 0x7a },
	'isoautoshuttertime' => { 233 => 0x4, 252 => 0x15e, 255 => 0x14e, 256 => 0x162, 257 => 0x162, 276 => 0x4, 286 => 0x18ea },
	'isobutton' => { 257 => 0x796 },
	'isocalibrationgain' => { 145 => 0x89f },
	'isodisplay' => { 316 => '4.1', 317 => '4.1', 318 => '2.3', 319 => '3.3', 320 => '3.3', 323 => '3.3', 326 => '4.3', 327 => '4.1', 328 => '4.3' },
	'isoexpansion' => { 90 => 0x103, 91 => 0x7, 92 => 0x8, 95 => 0x8, 234 => 0x4 },
	'isoexpansion2' => { 234 => 0xa },
	'isofloor' => { 375 => 0x6 },
	'isoselected' => { 357 => 0x359 },
	'isoselection' => { 246 => 0xf },
	'isosensitivitystep' => { 321 => '6.2', 323 => '6.2' },
	'isosetting' => { 147 => 0x5e, 159 => 0x14, 163 => 'ISOSetting', 188 => 0x24, 189 => 0x26, 190 => 0x1c, 191 => 0x13, 196 => 0x6, 246 => 0x13, 375 => '17.3', 428 => 0x27, 449 => 0x16, 450 => 0x14, 451 => 0x2, 460 => 0x6d, 462 => 0x0 },
	'isospeed' => { 125 => 0x8833, 535 => 'ISOSpeed' },
	'isospeedexpansion' => { 89 => 0x3 },
	'isospeedincrements' => { 90 => 0x102 },
	'isospeedlatitudeyyy' => { 125 => 0x8834, 535 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 125 => 0x8835, 535 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 90 => 0x103 },
	'isostepsize' => { 313 => '6.1', 314 => '7.2', 316 => '7.2', 317 => '7.2', 322 => '4.1', 326 => '7.2', 327 => '7.2', 329 => 0x14d, 330 => 0x15d, 331 => 0x15d, 332 => 0x175 },
	'isovalue' => { 339 => 0x1001 },
	'isrc' => { 413 => 'xid ' },
	'isrccode' => { 421 => "\xa9isr" },
	'issn' => { 548 => 'issn' },
	'issueidentifier' => { 548 => 'issueIdentifier' },
	'issuename' => { 548 => 'issueName' },
	'issueteaser' => { 548 => 'issueTeaser' },
	'issuetype' => { 548 => 'issueType' },
	'istranslationof' => { 548 => 'isTranslationOf' },
	'itemsubtype' => { 185 => 'ItemSubType' },
	'itunesu' => { 413 => 'itnu' },
	'jobid' => { 138 => 0xb8 },
	'jobname' => { 536 => 'JobName' },
	'jobref' => { 557 => 'JobRef' },
	'jobrefid' => { 557 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 557 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 557 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 536 => 'JobStatus' },
	'jpeg-heifswitch' => { 463 => 0x2039 },
	'jpeghandling' => { 528 => 'JPEGHandling', 530 => 'JPEGHandling' },
	'jpegquality' => { 10 => 0x66, 358 => 0x43, 360 => 0x3034, 463 => 0xb047 },
	'jpegsize' => { 360 => 0x303a },
	'jpgcompression' => { 237 => 0x24, 246 => 0x44, 281 => '671.1' },
	'jpgfromraw' => { 103 => 0x2007, 120 => 'Exif-JpgFromRaw', 363 => 0x2e },
	'jpgfromrawlength' => { 125 => [0x117,0x202] },
	'jpgfromrawstart' => { 125 => [0x111,0x201] },
	'jpgrecordedpixels' => { 375 => '14.1' },
	'jurisdiction' => { 526 => 'jurisdiction' },
	'jxldecodespeed' => { 125 => 0xcd4b },
	'jxldistance' => { 125 => 0xcd49 },
	'jxleffort' => { 125 => 0xcd4a },
	'keepexposure' => { 330 => 0x237, 331 => 0x237, 332 => 0x24f },
	'kelvinwb_01' => { 383 => 0x5 },
	'kelvinwb_02' => { 383 => 0x9 },
	'kelvinwb_03' => { 383 => 0xd },
	'kelvinwb_04' => { 383 => 0x11 },
	'kelvinwb_05' => { 383 => 0x15 },
	'kelvinwb_06' => { 383 => 0x19 },
	'kelvinwb_07' => { 383 => 0x1d },
	'kelvinwb_08' => { 383 => 0x21 },
	'kelvinwb_09' => { 383 => 0x25 },
	'kelvinwb_10' => { 383 => 0x29 },
	'kelvinwb_11' => { 383 => 0x2d },
	'kelvinwb_12' => { 383 => 0x31 },
	'kelvinwb_13' => { 383 => 0x35 },
	'kelvinwb_14' => { 383 => 0x39 },
	'kelvinwb_15' => { 383 => 0x3d },
	'kelvinwb_16' => { 383 => 0x41 },
	'kelvinwb_daylight' => { 383 => 0x1 },
	'kerneldenominators' => { 145 => 0x933 },
	'key' => { 558 => 'key' },
	'keystonecompensation' => { 338 => 0x1900 },
	'keystonedirection' => { 338 => 0x1901 },
	'keystonevalue' => { 338 => 0x1906 },
	'keyword' => { 413 => 'keyw', 548 => 'keyword' },
	'keywordinfo' => { 178 => 'Keywords' },
	'keywords' => { 138 => 0x19, 164 => 'Keywords', 343 => 'Keywords', 411 => 'Keywords', 415 => 'keywords', 522 => 'keywords', 544 => 'Keywords', 556 => 'Keywords' },
	'killdate' => { 548 => 'killDate' },
	'killdatea-platform' => { 548 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 548 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 144 => 0xf908, 147 => 0xe, 149 => [0xfa1e,0xfa52], 155 => 0x70 },
	'kodakimagewidth' => { 144 => 0xf907, 147 => 0xc, 149 => [0xfa1d,0xfa51], 155 => 0x6c },
	'kodakinfotype' => { 144 => 0xfa00 },
	'kodaklook' => { 145 => 0xe4c },
	'kodaklookprofile' => { 145 => 0x138a },
	'kodakmaker' => { 155 => 0x8 },
	'kodakmodel' => { 147 => 0x0, 155 => 0x28 },
	'kodaktag' => { 145 => 0x3ea },
	'kodakversion' => { 145 => 0x0 },
	'label' => { 347 => 'Label', 556 => 'Label' },
	'labelname1' => { 540 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 540 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 540 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 540 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 540 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 540 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 358 => 0x6f },
	'landscapeoutputhighlightpoint' => { 115 => 0x26 },
	'landscapeoutputshadowpoint' => { 115 => 0x27 },
	'landscaperawcolortone' => { 115 => 0x1f },
	'landscaperawcontrast' => { 115 => 0x21 },
	'landscaperawhighlight' => { 115 => 0x77 },
	'landscaperawhighlightpoint' => { 115 => 0x24 },
	'landscaperawlinear' => { 115 => 0x22 },
	'landscaperawsaturation' => { 115 => 0x20 },
	'landscaperawshadow' => { 115 => 0x80 },
	'landscaperawshadowpoint' => { 115 => 0x25 },
	'landscaperawsharpness' => { 115 => 0x23 },
	'landscapeunsharpmaskfineness' => { 115 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 115 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 115 => 0xa2 },
	'language' => { 250 => 0x8fc, 253 => 0x6a2, 254 => 0x6a2, 255 => 0x592, 256 => 0x5c2, 257 => 0x5da, 531 => 'language' },
	'languageidentifier' => { 138 => 0x87 },
	'largestvalidinteriorrectheight' => { 514 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 514 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 514 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 514 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 188 => 0x1b },
	'lastkeywordiptc' => { 185 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 185 => 'LastKeywordXMP' },
	'lastphotodate' => { 514 => 'LastPhotoDate' },
	'lasturl' => { 559 => 'LastURL' },
	'lateralchromaticaberration' => { 463 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 525 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 124 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 124 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 124 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 124 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 124 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'latitude' => { 122 => 'Latitude' },
	'lc1' => { 385 => 0x2 },
	'lc10' => { 385 => 0xb },
	'lc11' => { 385 => 0xc },
	'lc12' => { 385 => 0xd },
	'lc14' => { 385 => 0xf },
	'lc15' => { 385 => 0x10 },
	'lc3' => { 385 => 0x4 },
	'lc4' => { 385 => 0x5 },
	'lc5' => { 385 => 0x6 },
	'lc6' => { 385 => 0x7 },
	'lc7' => { 385 => 0x8 },
	'lc8' => { 385 => 0x9 },
	'lcddisplayatpoweron' => { 90 => 0x811, 94 => 0xa },
	'lcddisplayreturntoshoot' => { 95 => 0x12 },
	'lcdillumination' => { 313 => '17.5', 314 => '5.2', 316 => '5.1', 317 => '5.1', 322 => '10.3', 323 => '4.2', 326 => '5.2', 327 => '5.1', 328 => '5.4', 329 => 0xf1, 330 => 0x101, 331 => 0x101, 332 => 0x117 },
	'lcdilluminationduringbulb' => { 90 => 0x408 },
	'lcdmatrix' => { 145 => 0xe74 },
	'lcdmatrixchickfix' => { 145 => 0xe75 },
	'lcdmatrixmarvin' => { 145 => 0xe76 },
	'lcdpanels' => { 89 => 0x8 },
	'lcheditor' => { 306 => 0x8ae85e },
	'legacyiptcdigest' => { 546 => 'LegacyIPTCDigest' },
	'legalcode' => { 526 => 'legalcode' },
	'lens' => { 125 => 0xfdea, 246 => 0x84, 525 => 'Lens' },
	'lensafstopbutton' => { 88 => 0x11, 89 => 0x13, 90 => 0x506, 91 => 0x10, 92 => 0x12, 95 => 0x13, 96 => 0x9 },
	'lensaperturerange' => { 439 => [0x30,0x48] },
	'lensblur' => { 528 => 'LensBlur', 530 => 'LensBlur' },
	'lensbluractive' => { 528 => [\'LensBlur','LensBlurActive'], 530 => [\'LensBlur','LensBlurActive'] },
	'lensbluramount' => { 528 => [\'LensBlur','LensBlurBlurAmount'], 530 => [\'LensBlur','LensBlurBlurAmount'] },
	'lensblurbokehaspect' => { 528 => [\'LensBlur','LensBlurBokehAspect'], 530 => [\'LensBlur','LensBlurBokehAspect'] },
	'lensblurbokehrotation' => { 528 => [\'LensBlur','LensBlurBokehRotation'], 530 => [\'LensBlur','LensBlurBokehRotation'] },
	'lensblurbokehshape' => { 528 => [\'LensBlur','LensBlurBokehShape'], 530 => [\'LensBlur','LensBlurBokehShape'] },
	'lensblurbokehshapedetail' => { 528 => [\'LensBlur','LensBlurBokehShapeDetail'], 530 => [\'LensBlur','LensBlurBokehShapeDetail'] },
	'lensblurcateyeamount' => { 528 => [\'LensBlur','LensBlurCatEyeAmount'], 530 => [\'LensBlur','LensBlurCatEyeAmount'] },
	'lensblurcateyescale' => { 528 => [\'LensBlur','LensBlurCatEyeScale'], 530 => [\'LensBlur','LensBlurCatEyeScale'] },
	'lensblurfocalrange' => { 528 => [\'LensBlur','LensBlurFocalRange'], 530 => [\'LensBlur','LensBlurFocalRange'] },
	'lensblurfocalrangesource' => { 528 => [\'LensBlur','LensBlurFocalRangeSource'], 530 => [\'LensBlur','LensBlurFocalRangeSource'] },
	'lensblurhighlightsboost' => { 528 => [\'LensBlur','LensBlurHighlightsBoost'], 530 => [\'LensBlur','LensBlurHighlightsBoost'] },
	'lensblurhighlightsthreshold' => { 528 => [\'LensBlur','LensBlurHighlightsThreshold'], 530 => [\'LensBlur','LensBlurHighlightsThreshold'] },
	'lensblursampledarea' => { 528 => [\'LensBlur','LensBlurSampledArea'], 530 => [\'LensBlur','LensBlurSampledArea'] },
	'lensblursampledrange' => { 528 => [\'LensBlur','LensBlurSampledRange'], 530 => [\'LensBlur','LensBlurSampledRange'] },
	'lensblursphericalaberration' => { 528 => [\'LensBlur','LensBlurSphericalAberration'], 530 => [\'LensBlur','LensBlurSphericalAberration'] },
	'lensblursubjectrange' => { 528 => [\'LensBlur','LensBlurSubjectRange'], 530 => [\'LensBlur','LensBlurSubjectRange'] },
	'lensblurversion' => { 528 => [\'LensBlur','LensBlurVersion'], 530 => [\'LensBlur','LensBlurVersion'] },
	'lenscontrolring' => { 329 => 0xb1, 330 => 0xad, 331 => 0xad, 332 => 0xad },
	'lenscorrectionsettings' => { 533 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 525 => 'LensDistortInfo' },
	'lensdistortionparams' => { 339 => 0x206 },
	'lensdriveend' => { 244 => 0x56 },
	'lensdrivenoaf' => { 90 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 451 => 0x3f0, 499 => 0xd },
	'lensfirmware' => { 430 => 0x20, 436 => 0xa004 },
	'lensfirmwareversion' => { 244 => 0x34, 335 => 0x204, 358 => 0x60, 451 => 0x3f3, 499 => 0x14 },
	'lensfocallength' => { 109 => 0xf0512, 385 => 0x9 },
	'lensfocalrange' => { 439 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 314 => '55.1', 316 => '52.1', 317 => '52.1', 326 => '52.1', 327 => '52.1' },
	'lensformat' => { 476 => 0x1891, 478 => 0x18bd, 479 => 0x18ed, 480 => 0x17f1, 482 => 0x106, 483 => 0x106, 494 => 0x603, 495 => 0x5d },
	'lensfstops' => { 238 => 0x7, 239 => 0xc, 240 => 0xd, 244 => 0xe, 246 => 0x8b, 385 => '0.3' },
	'lensfunc1button' => { 329 => 0xa3, 330 => 0x9f, 331 => 0x9f, 332 => 0x9f },
	'lensfunc1buttonplaybackmode' => { 254 => 0x80a, 257 => 0x810 },
	'lensfunc2button' => { 329 => 0xab, 330 => 0xa7, 331 => 0xa7, 332 => 0xa7 },
	'lensfunc2buttonplaybackmode' => { 254 => 0x80c, 257 => 0x812 },
	'lensid' => { 244 => 0x30, 525 => 'LensID' },
	'lensidnumber' => { 238 => 0x6, 239 => 0xb, 240 => 0xc, 244 => 0xd },
	'lensinfo' => { 125 => 0xa432, 391 => 0x2a, 525 => 'LensInfo', 535 => 'LensSpecification' },
	'lenskind' => { 385 => 0x1 },
	'lensmake' => { 125 => 0xa433, 170 => 'Make', 535 => 'LensMake' },
	'lensmanualdistortionamount' => { 528 => 'LensManualDistortionAmount', 530 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 185 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 439 => 0x2b },
	'lensmodel' => { 7 => 0x937, 14 => 0x92b, 15 => 0x933, 69 => 0x95, 125 => 0xa434, 170 => 'Model', 185 => 'LensModel', 241 => 0x18a, 242 => 0x18b, 243 => 0x2ac, 335 => 0x203, 391 => 0xc, 404 => 0x412, 422 => 'camera.lens_model', 535 => 'LensModel' },
	'lensmodulationoptimizer' => { 133 => 0x1045 },
	'lensmount' => { 451 => 0x99, 476 => 0x1892, 478 => 0x18be, 479 => 0x18ee, 480 => 0x17f2, 482 => 0x105, 483 => 0x105, 494 => 0x604, 495 => 0x5e },
	'lensmount2' => { 499 => 0x8 },
	'lensmounttype' => { 244 => 0x5f },
	'lenspositionabsolute' => { 244 => 0x5a },
	'lensprofilechromaticaberrationscale' => { 528 => 'LensProfileChromaticAberrationScale', 530 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 528 => 'LensProfileDigest', 530 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 528 => 'LensProfileDistortionScale', 530 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 528 => 'LensProfileEnable', 530 => 'LensProfileEnable' },
	'lensprofilefilename' => { 528 => 'LensProfileFilename', 530 => 'LensProfileFilename' },
	'lensprofileisembedded' => { 528 => 'LensProfileIsEmbedded', 530 => 'LensProfileIsEmbedded' },
	'lensprofilematchkeycameramodelname' => { 528 => 'LensProfileMatchKeyCameraModelName', 530 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 528 => 'LensProfileMatchKeyExifMake', 530 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 528 => 'LensProfileMatchKeyExifModel', 530 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 528 => 'LensProfileMatchKeyIsRaw', 530 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 528 => 'LensProfileMatchKeyLensID', 530 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 528 => 'LensProfileMatchKeyLensInfo', 530 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 528 => 'LensProfileMatchKeyLensName', 530 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 528 => 'LensProfileMatchKeySensorFormatFactor', 530 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 357 => 0x370, 528 => 'LensProfileName', 530 => 'LensProfileName' },
	'lensprofilesetup' => { 528 => 'LensProfileSetup', 530 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 528 => 'LensProfileVignettingScale', 530 => 'LensProfileVignettingScale' },
	'lensproperties' => { 335 => 0x20b },
	'lensserialnumber' => { 21 => 0x164, 35 => 0x16b, 65 => 0x0, 125 => 0xa435, 170 => 'SerialNumber', 335 => 0x202, 356 => 0x321, 358 => 0x52, 421 => 'LENS', 430 => 0x30, 525 => 'LensSerialNumber', 535 => 'LensSerialNumber' },
	'lensshutterlock' => { 191 => 0x4a },
	'lensspec' => { 446 => 0x0, 447 => 0x0, 448 => 0x0, 463 => 0xb02a },
	'lensspecfeatures' => { 482 => [0x115,0x116], 483 => [0x116,0x1ed,0x1f0,0x21c,0x21e] },
	'lenstemperature' => { 339 => 0x1008 },
	'lenstype' => { 7 => 0xe2, 8 => 0xd, 9 => 0x1a7, 10 => 0xc, 11 => 0x111, 12 => 0xc, 13 => 0x14f, 14 => 0xd6, 15 => 0xde, 16 => 0xf6, 17 => 0xea, 18 => 0xff, 19 => [0xc,0x97], 20 => 0xe6, 21 => 0x153, 22 => 0xea, 23 => 0xe8, 24 => 0x127, 25 => 0x161, 26 => 0x166, 27 => 0x184, 28 => 0x112, 29 => 0x189, 37 => 0x16, 193 => 0x10c, 194 => 0x49bd, 246 => 0x83, 335 => 0x201, 349 => 0x16, 353 => 0x310, 355 => 0x303, 356 => 0x303, 358 => 0x51, 360 => 0x3405, 386 => 0x0, 387 => 0x0, 388 => 0x1, 389 => 0x1, 390 => 0x1, 392 => 0x0, 436 => 0xa003, 439 => 0x27, 463 => 0xb027, 476 => 0x1896, 478 => 0x18c2, 479 => 0x18f2, 480 => 0x17f6, 482 => 0x109, 483 => 0x109, 494 => 0x608, 495 => 0x62 },
	'lenstype2' => { 451 => 0x3f7, 476 => 0x1893, 478 => 0x18bf, 479 => 0x18ef, 480 => 0x17f3, 482 => 0x107, 483 => 0x107, 494 => 0x605, 495 => 0x60 },
	'lenstype3' => { 499 => 0x9 },
	'lenstypemake' => { 358 => 0xc4 },
	'lenstypemodel' => { 358 => [0xc5,0xe4] },
	'lenszoomposition' => { 491 => 0x19, 492 => 0x1e, 495 => [0x342,0x34e,0x35a] },
	'levelindicator' => { 366 => 0x15 },
	'levelmeter' => { 421 => ['Lvlm','lvlm'] },
	'levelorientation' => { 393 => 0x0 },
	'license' => { 526 => 'license' },
	'licensee' => { 344 => 'Licensee' },
	'licenseeid' => { 344 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 344 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 344 => 'LicenseeImageNotes' },
	'licenseename' => { 344 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 344 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 344 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 344 => 'LicenseeTransactionID' },
	'licenseid' => { 344 => 'LicenseID' },
	'licensestartdate' => { 344 => 'LicenseStartDate' },
	'licensetransactiondate' => { 344 => 'LicenseTransactionDate' },
	'licensetype' => { 532 => 'licensetype' },
	'licensor' => { 344 => 'Licensor' },
	'licensorcity' => { 344 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 344 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 344 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 344 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 344 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 344 => 'LicensorImageID' },
	'licensorname' => { 344 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 344 => 'LicensorNotes' },
	'licensorpostalcode' => { 344 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 344 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 344 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 344 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 344 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 344 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 344 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 344 => 'LicensorTransactionID' },
	'licensorurl' => { 344 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 339 => 0x1009 },
	'lightingmode' => { 119 => 0x302a },
	'lightreading' => { 395 => 0x15 },
	'lightsource' => { 125 => 0x9208, 246 => 0x90, 342 => 0x1000, 534 => 'LightSource' },
	'lightsourcespecial' => { 438 => 0x21d },
	'lightswitch' => { 326 => '0.1', 328 => '0.1' },
	'lightvaluecenter' => { 339 => 0x103d },
	'lightvalueperiphery' => { 339 => 0x103e },
	'limitaf-areamodesel3dtracking' => { 329 => 0x143, 330 => 0x153, 331 => 0x153, 332 => 0x16b },
	'limitaf-areamodeseldynamic_l' => { 329 => 0x141, 330 => 0x151, 331 => 0x151, 332 => 0x169 },
	'limitaf-areamodeseldynamic_m' => { 329 => 0x140, 330 => 0x150, 331 => 0x150, 332 => 0x168 },
	'limitaf-areamodeseldynamic_s' => { 329 => 0x13f, 330 => 0x14f, 331 => 0x14f, 332 => 0x167 },
	'limitaf-areamodeselpinpoint' => { 329 => 0x11, 330 => 0x11, 331 => 0x11, 332 => 0x11 },
	'limitaf-areamodeselwideaf_l' => { 329 => 0x14, 330 => 0x14, 331 => 0x14, 332 => 0x14 },
	'limitaf-areamodeselwideaf_s' => { 329 => 0x13, 330 => 0x13, 331 => 0x13, 332 => 0x13 },
	'limitafareamodeselauto' => { 329 => 0x15, 330 => 0x15, 331 => 0x15, 332 => 0x15 },
	'limitafareamodeselection' => { 314 => '51.1', 316 => '49.1', 317 => '49.1', 326 => '49.1', 327 => '49.1' },
	'limitreleasemodeselc120' => { 331 => '269.4', 332 => '293.4' },
	'limitreleasemodeselc30' => { 331 => '269.3', 332 => '293.3' },
	'limitreleasemodeselch' => { 331 => '269.2', 332 => '293.2' },
	'limitreleasemodeselcl' => { 331 => '269.1', 332 => '293.1' },
	'limitreleasemodeselself' => { 331 => '269.5', 332 => '293.5' },
	'limitselectableimagearea16to9' => { 329 => 0x4d, 330 => 0x47, 331 => 0x47, 332 => 0x47 },
	'limitselectableimagearea1to1' => { 329 => 0x4c, 330 => 0x46, 331 => 0x46, 332 => 0x46 },
	'limitselectableimageareadx' => { 329 => 0x4b, 330 => 0x45, 331 => 0x45, 332 => 0x45 },
	'linearitylimitblue' => { 363 => 0x10 },
	'linearitylimitgreen' => { 363 => 0xf },
	'linearitylimitred' => { 363 => 0xe },
	'linearityuppermargin' => { 44 => 0x32c, 45 => 0x282, 46 => 0x296, 49 => [0x2ba,0x2d1,0x2d5], 51 => 0x1e5, 52 => [0x1fe,0x2de], 53 => [0x232,0x310], 54 => 0x31e },
	'linearizationtable' => { 125 => 0xc618 },
	'linearresponselimit' => { 125 => 0xc62e },
	'link' => { 548 => 'link' },
	'linkaetoafpoint' => { 375 => '14.2' },
	'linkedencodedrightsexpr' => { 542 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 542 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 542 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 542 => 'LinkedEncRightsExpr' },
	'linkvrtofocuspoint' => { 250 => 0x3ec },
	'linlogcoring' => { 145 => 0x904 },
	'lithostratigraphicterms' => { 124 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'livephotoauto' => { 415 => 'live-photo.auto' },
	'livephotovideoindex' => { 1 => 0x17 },
	'livephotovitalityscore' => { 415 => 'live-photo.vitality-score' },
	'livephotovitalityscoringversion' => { 415 => 'live-photo.vitality-scoring-version' },
	'liveview' => { 369 => 0x1fa, 377 => 0x3 },
	'liveviewaf' => { 318 => '32.1', 328 => '34.1' },
	'liveviewafareamode' => { 323 => '34.1' },
	'liveviewafmethod' => { 468 => 0x20 },
	'liveviewafmode' => { 323 => '34.2' },
	'liveviewafsetting' => { 451 => 0x36 },
	'liveviewbuttonoptions' => { 314 => '50.2', 316 => '48.2', 317 => '48.2', 326 => '48.2', 327 => '48.2' },
	'liveviewexposuresimulation' => { 90 => 0x810 },
	'liveviewfocusmode' => { 451 => [0x8b,0x28b] },
	'liveviewmetering' => { 451 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 314 => '21.2', 316 => '21.2', 317 => '21.2', 319 => '20.2', 320 => '20.2', 321 => '20.2', 323 => '20.2', 326 => '21.2', 327 => '21.2' },
	'liveviewshooting' => { 61 => 0x13 },
	'livingspecimen' => { 124 => 'LivingSpecimen' },
	'livingspecimenmaterialsampleid' => { 124 => [\'LivingSpecimen','LivingSpecimenMaterialSampleID'] },
	'localcaption' => { 138 => 0x79 },
	'localizedcameramodel' => { 125 => 0xc615 },
	'locallocationname' => { 436 => 0x30 },
	'location' => { 245 => 0x9, 358 => 0x67, 520 => 'Location', 541 => 'Location', 547 => 'location', 548 => 'location' },
	'locationaccuracyhorizontal' => { 415 => 'location.accuracy.horizontal' },
	'locationareacode' => { 527 => 'lac' },
	'locationbody' => { 415 => 'location.body' },
	'locationcreated' => { 542 => 'LocationCreated' },
	'locationcreatedcity' => { 542 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 542 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 542 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedgpsaltitude' => { 542 => [\'LocationCreated','LocationCreatedGPSAltitude'] },
	'locationcreatedgpsaltituderef' => { 542 => [\'LocationCreated','LocationCreatedGPSAltitudeRef'] },
	'locationcreatedgpslatitude' => { 542 => [\'LocationCreated','LocationCreatedGPSLatitude'] },
	'locationcreatedgpslongitude' => { 542 => [\'LocationCreated','LocationCreatedGPSLongitude'] },
	'locationcreatedidentifier' => { 542 => [\'LocationCreated','LocationCreatedIdentifier'] },
	'locationcreatedlocationid' => { 542 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedlocationname' => { 542 => [\'LocationCreated','LocationCreatedLocationName'] },
	'locationcreatedprovincestate' => { 542 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 542 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 542 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationdate' => { 415 => 'location.date' },
	'locationinformation' => { 421 => 'loci' },
	'locationinfoversion' => { 245 => 0x0 },
	'locationname' => { 415 => 'location.name', 436 => 0x31 },
	'locationnote' => { 415 => 'location.note' },
	'locationrole' => { 415 => 'location.role' },
	'locationshown' => { 542 => 'LocationShown' },
	'locationshowncity' => { 542 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 542 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 542 => [\'LocationShown','LocationShownCountryName'] },
	'locationshowngpsaltitude' => { 542 => [\'LocationShown','LocationShownGPSAltitude'] },
	'locationshowngpsaltituderef' => { 542 => [\'LocationShown','LocationShownGPSAltitudeRef'] },
	'locationshowngpslatitude' => { 542 => [\'LocationShown','LocationShownGPSLatitude'] },
	'locationshowngpslongitude' => { 542 => [\'LocationShown','LocationShownGPSLongitude'] },
	'locationshownidentifier' => { 542 => [\'LocationShown','LocationShownIdentifier'] },
	'locationshownlocationid' => { 542 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownlocationname' => { 542 => [\'LocationShown','LocationShownLocationName'] },
	'locationshownprovincestate' => { 542 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 542 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 542 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 90 => 0x709 },
	'logcomment' => { 558 => 'logComment' },
	'logscale' => { 145 => 0x902 },
	'longdescription' => { 413 => 'ldes' },
	'longexposurenoisereduction' => { 67 => 0x4, 90 => 0x201, 91 => 0x1, 92 => 0x2, 93 => 0x1, 94 => 0x1, 95 => 0x2, 96 => 0x1, 358 => 0x49, 449 => 0x2b, 450 => 0x25, 451 => 0x25, 463 => 0x2008, 468 => 0x11, 495 => 0x44 },
	'longexposurenoisereduction2' => { 61 => 0x8 },
	'longexposurenrused' => { 358 => 0xbe },
	'longitude' => { 122 => 'Longitude' },
	'look' => { 528 => 'Look', 530 => 'Look' },
	'lookamount' => { 528 => [\'Look','LookAmount'], 530 => [\'Look','LookAmount'] },
	'lookcluster' => { 528 => [\'Look','LookCluster'], 530 => [\'Look','LookCluster'] },
	'lookcopyright' => { 528 => [\'Look','LookCopyright'], 530 => [\'Look','LookCopyright'] },
	'lookgroup' => { 528 => [\'Look','LookGroup'], 530 => [\'Look','LookGroup'] },
	'lookname' => { 528 => 'LookName', 530 => 'LookName' },
	'lookparameters' => { 528 => [\'Look','LookParameters'], 530 => [\'Look','LookParameters'] },
	'lookparameterscameraprofile' => { 528 => [\'Look','LookParametersCameraProfile'], 530 => [\'Look','LookParametersCameraProfile'] },
	'lookparametersclarity2012' => { 528 => [\'Look','LookParametersClarity2012'], 530 => [\'Look','LookParametersClarity2012'] },
	'lookparametersconverttograyscale' => { 528 => [\'Look','LookParametersConvertToGrayscale'], 530 => [\'Look','LookParametersConvertToGrayscale'] },
	'lookparametershighlights2012' => { 528 => [\'Look','LookParametersHighlights2012'], 530 => [\'Look','LookParametersHighlights2012'] },
	'lookparameterslooktable' => { 528 => [\'Look','LookParametersLookTable'], 530 => [\'Look','LookParametersLookTable'] },
	'lookparametersprocessversion' => { 528 => [\'Look','LookParametersProcessVersion'], 530 => [\'Look','LookParametersProcessVersion'] },
	'lookparametersshadows2012' => { 528 => [\'Look','LookParametersShadows2012'], 530 => [\'Look','LookParametersShadows2012'] },
	'lookparameterstonecurvepv2012' => { 528 => [\'Look','LookParametersToneCurvePV2012'], 530 => [\'Look','LookParametersToneCurvePV2012'] },
	'lookparameterstonecurvepv2012blue' => { 528 => [\'Look','LookParametersToneCurvePV2012Blue'], 530 => [\'Look','LookParametersToneCurvePV2012Blue'] },
	'lookparameterstonecurvepv2012green' => { 528 => [\'Look','LookParametersToneCurvePV2012Green'], 530 => [\'Look','LookParametersToneCurvePV2012Green'] },
	'lookparameterstonecurvepv2012red' => { 528 => [\'Look','LookParametersToneCurvePV2012Red'], 530 => [\'Look','LookParametersToneCurvePV2012Red'] },
	'lookparametersversion' => { 528 => [\'Look','LookParametersVersion'], 530 => [\'Look','LookParametersVersion'] },
	'looksupportsamount' => { 528 => [\'Look','LookSupportsAmount'], 530 => [\'Look','LookSupportsAmount'] },
	'looksupportsmonochrome' => { 528 => [\'Look','LookSupportsMonochrome'], 530 => [\'Look','LookSupportsMonochrome'] },
	'looksupportsoutputreferred' => { 528 => [\'Look','LookSupportsOutputReferred'], 530 => [\'Look','LookSupportsOutputReferred'] },
	'lookuuid' => { 528 => [\'Look','LookUUID'], 530 => [\'Look','LookUUID'] },
	'loop' => { 558 => 'loop' },
	'loopstyle' => { 421 => 'LOOP' },
	'lowestbiostratigraphiczone' => { 124 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 528 => 'LuminanceAdjustmentAqua', 530 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 528 => 'LuminanceAdjustmentBlue', 530 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 528 => 'LuminanceAdjustmentGreen', 530 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 528 => 'LuminanceAdjustmentMagenta', 530 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 528 => 'LuminanceAdjustmentOrange', 530 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 528 => 'LuminanceAdjustmentPurple', 530 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 528 => 'LuminanceAdjustmentRed', 530 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 528 => 'LuminanceAdjustmentYellow', 530 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 114 => 0x150 },
	'luminancecurvepoints' => { 114 => 0x126 },
	'luminancenoiseamplitude' => { 1 => 0x1d },
	'luminancenoisereduction' => { 109 => 0x20600, 115 => 0x5f, 439 => 0x1b },
	'luminancenoisereductioncontrast' => { 528 => 'LuminanceNoiseReductionContrast', 530 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 528 => 'LuminanceNoiseReductionDetail', 530 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 115 => 0x6d },
	'luminancesmoothing' => { 528 => 'LuminanceSmoothing', 530 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 90 => [0x40b,0x40c] },
	'lyrics' => { 413 => "\xa9lyr", 421 => "\xa9lyr", 558 => 'lyrics' },
	'lyricsuri' => { 421 => 'lrcu' },
	'm16cversion' => { 353 => 0x333 },
	'macatom' => { 529 => 'macAtom' },
	'macatomapplicationcode' => { 529 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 529 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 529 => [\'macAtom','macAtomPosixProjectPath'] },
	'machineobservation' => { 124 => 'MachineObservation' },
	'machineobservationday' => { 124 => [\'MachineObservation','MachineObservationDay'] },
	'machineobservationearliestdate' => { 124 => [\'MachineObservation','MachineObservationEarliestDate'] },
	'machineobservationenddayofyear' => { 124 => [\'MachineObservation','MachineObservationEndDayOfYear'] },
	'machineobservationeventdate' => { 124 => [\'MachineObservation','MachineObservationEventDate'] },
	'machineobservationeventid' => { 124 => [\'MachineObservation','MachineObservationEventID'] },
	'machineobservationeventremarks' => { 124 => [\'MachineObservation','MachineObservationEventRemarks'] },
	'machineobservationeventtime' => { 124 => [\'MachineObservation','MachineObservationEventTime'] },
	'machineobservationeventtype' => { 124 => [\'MachineObservation','MachineObservationEventType'] },
	'machineobservationfieldnotes' => { 124 => [\'MachineObservation','MachineObservationFieldNotes'] },
	'machineobservationfieldnumber' => { 124 => [\'MachineObservation','MachineObservationFieldNumber'] },
	'machineobservationhabitat' => { 124 => [\'MachineObservation','MachineObservationHabitat'] },
	'machineobservationlatestdate' => { 124 => [\'MachineObservation','MachineObservationLatestDate'] },
	'machineobservationmonth' => { 124 => [\'MachineObservation','MachineObservationMonth'] },
	'machineobservationparenteventid' => { 124 => [\'MachineObservation','MachineObservationParentEventID'] },
	'machineobservationsamplesizeunit' => { 124 => [\'MachineObservation','MachineObservationSampleSizeUnit'] },
	'machineobservationsamplesizevalue' => { 124 => [\'MachineObservation','MachineObservationSampleSizeValue'] },
	'machineobservationsamplingeffort' => { 124 => [\'MachineObservation','MachineObservationSamplingEffort'] },
	'machineobservationsamplingprotocol' => { 124 => [\'MachineObservation','MachineObservationSamplingProtocol'] },
	'machineobservationstartdayofyear' => { 124 => [\'MachineObservation','MachineObservationStartDayOfYear'] },
	'machineobservationverbatimeventdate' => { 124 => [\'MachineObservation','MachineObservationVerbatimEventDate'] },
	'machineobservationyear' => { 124 => [\'MachineObservation','MachineObservationYear'] },
	'macro' => { 133 => 0x1020, 135 => 0x202, 158 => 0x2b, 339 => 0x202, 428 => 0x21, 438 => 0x202, 463 => 0xb040 },
	'macroled' => { 337 => 0x120a },
	'macromagnification' => { 7 => 0x1b, 11 => 0x1b, 14 => 0x1b, 15 => 0x1b, 19 => 0x1b, 20 => 0x1b, 61 => 0x10 },
	'macromode' => { 37 => 0x1, 188 => 0xb, 334 => 0x300, 358 => 0x1c, 429 => 0x1009 },
	'magentahsl' => { 109 => 0x20917 },
	'magicfilter' => { 334 => 0x52c },
	'magnifiedview' => { 92 => 0x11, 94 => 0x9 },
	'mainboardversion' => { 145 => 0x438 },
	'maindialexposurecomp' => { 324 => '0.6' },
	'mainingredient' => { 550 => 'mainIngredient' },
	'majorbrand' => { 415 => 'major_brand' },
	'majorversion' => { 518 => 'MajorVersion' },
	'make' => { 104 => 0x0, 121 => 0x1, 125 => 0x10f, 163 => 'Make', 347 => 'Make', 363 => 0x10f, 415 => 'make', 421 => ['@mak',"\xa9mak"], 547 => 'make', 554 => 'Make' },
	'makernote' => { 534 => 'MakerNote' },
	'makernoteapple' => { 123 => 'MakN', 125 => 0x927c },
	'makernotecanon' => { 87 => 'CMT3', 123 => 'MakN', 125 => 0x927c },
	'makernotecasio' => { 123 => 'MakN', 125 => 0x927c },
	'makernotecasio2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotedji' => { 123 => 'MakN', 125 => 0x927c },
	'makernotedjiinfo' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteflir' => { 123 => 'MakN', 125 => 0x927c },
	'makernotefujifilm' => { 123 => 'MakN', 125 => 0x927c },
	'makernotege' => { 123 => 'MakN', 125 => 0x927c },
	'makernotege2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotehasselblad' => { 123 => 'MakN', 125 => 0x927c },
	'makernotehp' => { 123 => 'MakN', 125 => 0x927c },
	'makernotehp2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotehp4' => { 123 => 'MakN', 125 => 0x927c },
	'makernotehp6' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteisl' => { 123 => 'MakN', 125 => 0x927c },
	'makernotejvc' => { 123 => 'MakN', 125 => 0x927c },
	'makernotejvctext' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak10' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak11' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak12' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak1a' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak1b' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak3' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak4' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak5' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak6a' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak6b' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak7' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak8a' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak8b' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak8c' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak9' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodakunknown' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekyocera' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica10' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica2' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica3' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica4' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica5' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica6' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica7' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica8' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica9' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteminolta' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteminolta2' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteminolta3' => { 123 => 'MakN', 125 => 0x927c },
	'makernotemotorola' => { 123 => 'MakN', 125 => 0x927c },
	'makernotenikon' => { 123 => 'MakN', 125 => 0x927c },
	'makernotenikon2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotenikon3' => { 123 => 'MakN', 125 => 0x927c },
	'makernotenintendo' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteoffset' => { 438 => 0xff },
	'makernoteolympus' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteolympus2' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteolympus3' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepanasonic' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepanasonic2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepanasonic3' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepentax' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepentax2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepentax3' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepentax4' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepentax5' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepentax6' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepentaxunknown' => { 421 => 'PXMN' },
	'makernotephaseone' => { 123 => 'MakN', 125 => 0x927c },
	'makernotereconyx' => { 123 => 'MakN', 125 => 0x927c },
	'makernotereconyx2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotereconyx3' => { 123 => 'MakN', 125 => 0x927c },
	'makernotericoh' => { 123 => 'MakN', 125 => 0x927c },
	'makernotericoh2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotericohpentax' => { 123 => 'MakN', 125 => 0x927c },
	'makernotericohtext' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesafety' => { 125 => 0xc635 },
	'makernotesamsung1a' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesamsung1b' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesamsung2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesanyo' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesanyoc4' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesanyopatch' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesigma' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesony' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesony2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesony3' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesony4' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesony5' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesonyericsson' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesonysrf' => { 123 => 'MakN', 125 => 0x927c },
	'makernotetype' => { 429 => 0x1 },
	'makernoteunknown' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteunknownbinary' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteunknowntext' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteversion' => { 1 => 0x1, 193 => 0x0, 246 => 0x1, 339 => 0x0, 358 => 0x8000, 433 => 0x0, 436 => 0x1, 439 => [0x1d,0x1f], 452 => 0x2000 },
	'makerurl' => { 421 => "\xa9mal" },
	'managedfrom' => { 559 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 559 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 559 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 559 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 559 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 559 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 559 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 559 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 559 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 559 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 559 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 559 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 559 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 559 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 559 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 559 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 559 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 559 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 559 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 559 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 559 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 559 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 559 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 559 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 559 => 'Manager' },
	'managervariant' => { 559 => 'ManagerVariant' },
	'manageto' => { 559 => 'ManageTo' },
	'manageui' => { 559 => 'ManageUI' },
	'manifest' => { 559 => 'Manifest' },
	'manifestlinkform' => { 559 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 559 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 559 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 559 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 559 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 559 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 559 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 559 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 559 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 559 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 559 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 559 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 559 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 559 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 559 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 559 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 559 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 559 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 559 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 559 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 559 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 559 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 559 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 559 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 559 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 559 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 559 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 559 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 334 => 0x900, 358 => 0x86 },
	'manometerreading' => { 334 => 0x901 },
	'manualafpointselectpattern' => { 90 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 337 => 0x1209 },
	'manualflashoutput' => { 37 => 0x29, 315 => '8.2', 318 => '22.2', 319 => '23.1', 320 => '23.2', 322 => '16.2', 323 => '23.2', 324 => '8.2', 325 => '23.2', 328 => '24.2', 429 => 0x100c },
	'manualflashstrength' => { 334 => 0x406 },
	'manualfocusdistance' => { 246 => 0x85, 339 => 0x100c, 438 => 0x223 },
	'manualfocuspointillumination' => { 329 => 0x17, 330 => 0x17, 331 => 0x17, 332 => 0x17 },
	'manualfocusringinafmode' => { 329 => 0x1b, 330 => 0x1a, 331 => 0x1a, 332 => 0x1a },
	'manualtv' => { 89 => 0x5, 90 => 0x705 },
	'manufacturedate' => { 198 => 0x6705, 374 => 0x1 },
	'manufacturedate1' => { 431 => 0x4 },
	'manufacturedate2' => { 431 => 0x5 },
	'manufacturer' => { 511 => 'Manufacturer', 547 => 'manufacturer' },
	'mariahchromablursize' => { 145 => 0xf0d },
	'mariahmaphithreshold' => { 145 => 0xf0c },
	'mariahmaplothreshold' => { 145 => 0xf0b },
	'mariahsigmathreshold' => { 145 => 0xf0e },
	'mariahtexturethreshold' => { 145 => 0xf0a },
	'marked' => { 544 => 'Marked', 562 => 'Marked' },
	'markers' => { 558 => 'markers' },
	'markerscomment' => { 558 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 558 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 558 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 558 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 558 => [\'markers','markersCuePointType'] },
	'markersduration' => { 558 => [\'markers','markersDuration'] },
	'markerslocation' => { 558 => [\'markers','markersLocation'] },
	'markersname' => { 558 => [\'markers','markersName'] },
	'markersprobability' => { 558 => [\'markers','markersProbability'] },
	'markersspeaker' => { 558 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 558 => [\'markers','markersStartTime'] },
	'markerstarget' => { 558 => [\'markers','markersTarget'] },
	'markerstype' => { 558 => [\'markers','markersType'] },
	'maskedareas' => { 125 => 0xc68e },
	'maskgroupbasedcorractive' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'] },
	'maskgroupbasedcorramount' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'] },
	'maskgroupbasedcorrblacks2012' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'] },
	'maskgroupbasedcorrbrightness' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'] },
	'maskgroupbasedcorrclarity' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'] },
	'maskgroupbasedcorrclarity2012' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'] },
	'maskgroupbasedcorrcontrast' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'] },
	'maskgroupbasedcorrcontrast2012' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'] },
	'maskgroupbasedcorrcorrectionname' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'] },
	'maskgroupbasedcorrcorrectionsyncid' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'] },
	'maskgroupbasedcorrdefringe' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'] },
	'maskgroupbasedcorrdehaze' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'] },
	'maskgroupbasedcorrections' => { 528 => 'MaskGroupBasedCorrections', 530 => 'MaskGroupBasedCorrections' },
	'maskgroupbasedcorrexposure' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'] },
	'maskgroupbasedcorrexposure2012' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'] },
	'maskgroupbasedcorrhighlights2012' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'] },
	'maskgroupbasedcorrhue' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'] },
	'maskgroupbasedcorrluminancenoise' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'] },
	'maskgroupbasedcorrmask' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'] },
	'maskgroupbasedcorrmaskalpha' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'] },
	'maskgroupbasedcorrmaskangle' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'] },
	'maskgroupbasedcorrmaskbottom' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'] },
	'maskgroupbasedcorrmaskcentervalue' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'] },
	'maskgroupbasedcorrmaskcenterweight' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'] },
	'maskgroupbasedcorrmaskdabs' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'] },
	'maskgroupbasedcorrmaskfeather' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'] },
	'maskgroupbasedcorrmaskflipped' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'] },
	'maskgroupbasedcorrmaskflow' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'] },
	'maskgroupbasedcorrmaskfullx' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'] },
	'maskgroupbasedcorrmaskfully' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'] },
	'maskgroupbasedcorrmaskinputdigest' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'] },
	'maskgroupbasedcorrmaskleft' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'] },
	'maskgroupbasedcorrmaskmaskactive' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'] },
	'maskgroupbasedcorrmaskmaskblendmode' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmaskdigest' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmaskinverted' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmaskname' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'] },
	'maskgroupbasedcorrmaskmasks' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'] },
	'maskgroupbasedcorrmaskmasksalpha' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'maskgroupbasedcorrmaskmasksangle' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'] },
	'maskgroupbasedcorrmaskmasksbottom' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'] },
	'maskgroupbasedcorrmaskmaskscentervalue' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'maskgroupbasedcorrmaskmaskscenterweight' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'maskgroupbasedcorrmaskmasksdabs' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'] },
	'maskgroupbasedcorrmaskmasksfeather' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'] },
	'maskgroupbasedcorrmaskmasksflipped' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'maskgroupbasedcorrmaskmasksflow' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'] },
	'maskgroupbasedcorrmaskmasksfullx' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'] },
	'maskgroupbasedcorrmaskmasksfully' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'] },
	'maskgroupbasedcorrmaskmasksinputdigest' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'maskgroupbasedcorrmaskmasksleft' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'] },
	'maskgroupbasedcorrmaskmasksmaskactive' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'maskgroupbasedcorrmaskmasksmaskblendmode' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmasksmaskdigest' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmasksmaskinverted' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmasksmaskname' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'maskgroupbasedcorrmaskmasksmasksubtype' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksmasksyncid' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmasksmaskversion' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmasksmidpoint' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'maskgroupbasedcorrmaskmasksorigin' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'maskgroupbasedcorrmaskmasksperimetervalue' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskmasksradius' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'] },
	'maskgroupbasedcorrmaskmasksreferencepoint' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'maskgroupbasedcorrmaskmasksright' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'] },
	'maskgroupbasedcorrmaskmasksroundness' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'maskgroupbasedcorrmaskmaskssizex' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'maskgroupbasedcorrmaskmaskssizey' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'maskgroupbasedcorrmaskmaskstop' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'] },
	'maskgroupbasedcorrmaskmasksubtype' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksvalue' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'maskgroupbasedcorrmaskmasksversion' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'] },
	'maskgroupbasedcorrmaskmaskswhat' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'] },
	'maskgroupbasedcorrmaskmaskswholeimagearea' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskmasksx' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'] },
	'maskgroupbasedcorrmaskmasksy' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'] },
	'maskgroupbasedcorrmaskmasksyncid' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmaskszerox' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'maskgroupbasedcorrmaskmaskszeroy' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'maskgroupbasedcorrmaskmaskversion' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmidpoint' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'] },
	'maskgroupbasedcorrmaskorigin' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'] },
	'maskgroupbasedcorrmaskperimetervalue' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskradius' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'] },
	'maskgroupbasedcorrmaskrange' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'maskgroupbasedcorrmaskrangeareamodels' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrmaskrangeareamodelscolorsampleinfo' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrmaskrangeareamodelscomponents' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrmaskrangecoloramount' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrmaskrangedepthfeather' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrmaskrangedepthmax' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrmaskrangedepthmin' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrmaskrangeinvert' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrmaskrangelumfeather' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrmaskrangeluminancedepthsampleinfo' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrmaskrangelummax' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrmaskrangelummin' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrmaskrangelumrange' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrmaskrangesampletype' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrmaskrangetype' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'maskgroupbasedcorrmaskrangeversion' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrmaskreferencepoint' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'] },
	'maskgroupbasedcorrmaskright' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'] },
	'maskgroupbasedcorrmaskroundness' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'] },
	'maskgroupbasedcorrmasksizex' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'] },
	'maskgroupbasedcorrmasksizey' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'] },
	'maskgroupbasedcorrmasktop' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'] },
	'maskgroupbasedcorrmaskvalue' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'] },
	'maskgroupbasedcorrmaskversion' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'] },
	'maskgroupbasedcorrmaskwhat' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'] },
	'maskgroupbasedcorrmaskwholeimagearea' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskx' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'] },
	'maskgroupbasedcorrmasky' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'] },
	'maskgroupbasedcorrmaskzerox' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'] },
	'maskgroupbasedcorrmaskzeroy' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'] },
	'maskgroupbasedcorrmoire' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'] },
	'maskgroupbasedcorrrangemask' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'] },
	'maskgroupbasedcorrrangemaskareamodels' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrrangemaskareamodelscolorsampleinfo' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrrangemaskareamodelscomponents' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrrangemaskcoloramount' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrrangemaskdepthfeather' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrrangemaskdepthmax' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrrangemaskdepthmin' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrrangemaskinvert' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrrangemasklumfeather' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrrangemaskluminancedepthsampleinfo' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrrangemasklummax' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrrangemasklummin' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrrangemasklumrange' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrrangemasksampletype' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrrangemasktype' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'] },
	'maskgroupbasedcorrrangemaskversion' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrsaturation' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'] },
	'maskgroupbasedcorrshadows2012' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'] },
	'maskgroupbasedcorrsharpness' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'] },
	'maskgroupbasedcorrtemperature' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'] },
	'maskgroupbasedcorrtexture' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'] },
	'maskgroupbasedcorrtint' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'] },
	'maskgroupbasedcorrtoninghue' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'] },
	'maskgroupbasedcorrtoningsaturation' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'] },
	'maskgroupbasedcorrwhat' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'] },
	'maskgroupbasedcorrwhites2012' => { 528 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'], 530 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'] },
	'masterdocumentid' => { 138 => 0xb9 },
	'mastergain' => { 272 => 0x50 },
	'materialsample' => { 124 => 'MaterialSample' },
	'materialsampleid' => { 124 => [\'MaterialSample','MaterialSampleMaterialSampleID'] },
	'matrixmetering' => { 314 => '50.1', 316 => '48.1', 317 => '48.1', 326 => '48.1', 327 => '48.1', 330 => 0x233, 331 => 0x233, 332 => 0x24b },
	'matrixselectk' => { 145 => 0x91b },
	'matrixselectthreshold' => { 145 => 0x91a },
	'matrixselectthreshold1' => { 145 => 0x91e },
	'matrixselectthreshold2' => { 145 => 0x91f },
	'matrixstructure' => { 420 => 0xa },
	'maxaperture' => { 37 => 0x1a, 145 => 0x3f9, 151 => 0x6103, 170 => 'MaxAperture', 188 => 0x17, 194 => 0x49c5, 244 => 0x36, 335 => 0x20a, 385 => '14.1' },
	'maxapertureatmaxfocal' => { 133 => 0x1407, 170 => 'MaxApertureAtMaxFocal', 238 => 0xb, 239 => 0x10, 240 => 0x11, 244 => 0x12, 335 => 0x206 },
	'maxapertureatminfocal' => { 133 => 0x1406, 238 => 0xa, 239 => 0xf, 240 => 0x10, 244 => 0x11, 335 => 0x205 },
	'maxaperturevalue' => { 125 => 0x9205, 404 => 0x414, 534 => 'MaxApertureValue' },
	'maxavailheight' => { 542 => 'MaxAvailHeight' },
	'maxavailwidth' => { 542 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 313 => 0xb, 314 => 0xc, 316 => '12.1', 317 => '12.1', 322 => 0xc, 323 => 0xb, 326 => '12.1', 327 => '12.1', 329 => 0x41, 330 => 0x3d, 331 => 0x3d, 332 => 0x3d },
	'maxfaces' => { 338 => 0x1202 },
	'maxfocallength' => { 7 => 0xe6, 8 => 0x10, 9 => 0x1ab, 10 => 0x13, 11 => 0x115, 12 => 0x13, 13 => 0x153, 14 => 0xda, 16 => 0xfa, 17 => 0xee, 18 => 0x103, 19 => 0x95, 20 => 0xea, 21 => 0x157, 22 => 0xee, 23 => 0xec, 24 => 0x12b, 25 => 0x165, 26 => 0x16a, 27 => 0x188, 28 => 0x116, 29 => 0x18d, 37 => 0x17, 133 => 0x1405, 170 => 'MaxFocalLength', 238 => 0x9, 239 => 0xe, 240 => 0xf, 244 => 0x10, 335 => 0x208, 476 => 0x127c, 477 => 0x1138, 478 => 0x330, 479 => 0x330, 480 => 0x30e },
	'maxfocallength2' => { 66 => 0x9 },
	'maximumdensityrange' => { 140 => 0x8c },
	'maxpagesize' => { 563 => 'MaxPageSize' },
	'maxpagesizeh' => { 563 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 563 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 563 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxpixelvaluethreshold' => { 145 => 0xc7d },
	'maxsamplevalue' => { 125 => 0x119 },
	'maxstorage' => { 553 => 'maxstorage' },
	'mb-d10batteries' => { 313 => '12.6' },
	'mb-d10batterytype' => { 322 => '13.3' },
	'mb-d11batterytype' => { 323 => '2.3' },
	'mb-d12batterytype' => { 326 => '3.2' },
	'mb-d80batteries' => { 324 => '6.5' },
	'mb-d80batterytype' => { 328 => '3.2' },
	'mcuversion' => { 238 => 0xc, 239 => 0x11, 240 => 0x12, 244 => 0x13 },
	'md5digest' => { 171 => 'zmd5' },
	'mditemfindercomment' => { 180 => 'MDItemFinderComment' },
	'mditemfscreationdate' => { 180 => 'MDItemFSCreationDate' },
	'mditemfslabel' => { 180 => 'MDItemFSLabel' },
	'mditemusertags' => { 180 => 'MDItemUserTags' },
	'meal' => { 550 => 'meal' },
	'measuredev' => { 28 => 0x9, 82 => 0x3, 103 => 0x1814, 163 => 'MeasuredEV' },
	'measuredev2' => { 13 => 0x8, 28 => 0x8, 82 => 0x17 },
	'measuredev3' => { 13 => 0x9 },
	'measuredlv' => { 194 => 0x690, 353 => 0x312, 356 => 0x312, 357 => 0x312, 360 => 0x3407 },
	'measuredrggb' => { 70 => 0x1 },
	'measuredrggbdata' => { 48 => 0x287 },
	'measurementaccuracy' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 124 => 'MeasurementOrFact' },
	'measurementremarks' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'measuretype' => { 511 => 'MeasureType' },
	'mechanicalshuttercount' => { 246 => 0x37 },
	'mediaclassprimaryid' => { 186 => 'WM/MediaClassPrimaryID' },
	'mediaclasssecondaryid' => { 186 => 'WM/MediaClassSecondaryID' },
	'mediaconstraints' => { 344 => 'MediaConstraints' },
	'mediacreatedate' => { 417 => 0x1 },
	'mediaeventiddate' => { 516 => 'MediaEventIdDate' },
	'mediamodifydate' => { 417 => 0x2 },
	'mediasummarycode' => { 344 => 'MediaSummaryCode' },
	'mediatype' => { 413 => 'stik' },
	'mediauid' => { 421 => 'MUID' },
	'memoaudioquality' => { 90 => 0x812 },
	'memorycardconfiguration' => { 455 => 0x16 },
	'memorycardnumber' => { 223 => 0x2 },
	'menubuttondisplayposition' => { 88 => 0xb, 91 => 0xa, 92 => 0xb, 95 => 0xb },
	'menubuttonreturn' => { 96 => 0xb },
	'menumonitorofftime' => { 313 => '26.1', 314 => '22.1', 316 => '22.1', 317 => '22.1', 321 => '21.1', 322 => '8.2', 323 => '21.1', 326 => '22.1', 327 => '22.1', 328 => '22.1', 329 => 0x39, 330 => 0x35, 331 => 0x35, 332 => 0x35 },
	'mergedimages' => { 358 => 0x76 },
	'metadataauthority' => { 542 => 'metadataAuthority' },
	'metadataauthorityidentifier' => { 542 => [\'metadataAuthority','metadataAuthorityIdentifier'] },
	'metadataauthorityname' => { 542 => [\'metadataAuthority','metadataAuthorityName'] },
	'metadatadate' => { 556 => 'MetadataDate' },
	'metadataeditingsoftware' => { 125 => 0xa43c, 535 => 'MetadataEditingSoftware' },
	'metadatalastedited' => { 542 => 'metadataLastEdited' },
	'metadatalasteditor' => { 542 => 'metadataLastEditor' },
	'metadatalasteditoridentifier' => { 542 => [\'metadataLastEditor','metadataLastEditorIdentifier'] },
	'metadatalasteditorname' => { 542 => [\'metadataLastEditor','metadataLastEditorName'] },
	'metadatamoddate' => { 558 => 'metadataModDate' },
	'metaversion' => { 471 => 0x34 },
	'meterinfo1row1' => { 464 => 0x0, 465 => 0x0 },
	'meterinfo1row2' => { 464 => 0x6c, 465 => 0x5a },
	'meterinfo1row3' => { 464 => 0xd8, 465 => 0xb4 },
	'meterinfo1row4' => { 464 => 0x144, 465 => 0x10e },
	'meterinfo1row5' => { 464 => 0x1b0, 465 => 0x168 },
	'meterinfo1row6' => { 464 => 0x21c, 465 => 0x1c2 },
	'meterinfo1row7' => { 464 => 0x288, 465 => 0x21c },
	'meterinfo2row1' => { 464 => 0x2f4, 465 => 0x276 },
	'meterinfo2row2' => { 464 => 0x378, 465 => 0x2e4 },
	'meterinfo2row3' => { 464 => 0x3fc, 465 => 0x352 },
	'meterinfo2row4' => { 464 => 0x480, 465 => 0x3c0 },
	'meterinfo2row5' => { 464 => 0x504, 465 => 0x42e },
	'meterinfo2row6' => { 464 => 0x588, 465 => 0x49c },
	'meterinfo2row7' => { 464 => 0x60c, 465 => 0x50a },
	'meterinfo2row8' => { 464 => 0x690, 465 => 0x578 },
	'meterinfo2row9' => { 464 => 0x714, 465 => 0x5e6 },
	'metering' => { 315 => '6.1' },
	'meteringmode' => { 37 => 0x11, 125 => 0x9207, 147 => 0x1c, 188 => 0x7, 189 => 0x25, 191 => 0x12, 334 => 0x202, 395 => 0x17, 439 => 0x9, 449 => 0x15, 450 => 0x13, 451 => 0x7, 468 => 0x3, 472 => 0x1174, 473 => 0x1178, 474 => 0x1154, 475 => 0x11d0, 476 => 0x11ac, 477 => 0x1064, 478 => 0x25c, 479 => 0x25c, 480 => 0x24b, 534 => 'MeteringMode' },
	'meteringmode2' => { 375 => '2.1', 463 => 0x202c },
	'meteringmode3' => { 375 => '16.1' },
	'meteringoffscaleindicator' => { 191 => 0x53 },
	'meteringtime' => { 313 => '22.2', 315 => '3.2', 318 => '17.1', 319 => '18.1', 322 => '7.3', 323 => '18.1', 324 => '3.2', 328 => '19.1' },
	'micro1version' => { 424 => 0x1f },
	'micro2version' => { 424 => 0x2d },
	'microphoneattenuator' => { 252 => 0x34e, 255 => 0x2d2, 256 => 0x2fa, 257 => 0x2fa },
	'microphonefrequencyresponse' => { 252 => 0x350, 255 => 0x2d4, 256 => 0x2fc, 257 => 0x2fc },
	'microphonejackpower' => { 252 => 0x376, 255 => 0x2fa, 256 => 0x322, 257 => 0x322 },
	'microphonesensitivity' => { 252 => 0x34c, 255 => 0x2d0, 256 => 0x2f8, 257 => 0x2f8 },
	'microvideo' => { 508 => 'MicroVideo' },
	'microvideooffset' => { 508 => 'MicroVideoOffset' },
	'microvideopresentationtimestampus' => { 508 => 'MicroVideoPresentationTimestampUs' },
	'microvideoversion' => { 508 => 'MicroVideoVersion' },
	'midrangesharpness' => { 266 => 0x3b },
	'mieversion' => { 171 => '0Vers' },
	'mime' => { 511 => 'Mime' },
	'minaperture' => { 37 => 0x1b, 145 => 0x3f8, 170 => 'MinAperture', 385 => '0.2' },
	'minaperturevalue' => { 404 => 0x415 },
	'minfocallength' => { 7 => 0xe4, 8 => 0xe, 9 => 0x1a9, 10 => 0x11, 11 => 0x113, 12 => 0x11, 13 => 0x151, 14 => 0xd8, 16 => 0xf8, 17 => 0xec, 18 => 0x101, 19 => 0x93, 20 => 0xe8, 21 => 0x155, 22 => 0xec, 23 => 0xea, 24 => 0x129, 25 => 0x163, 26 => 0x168, 27 => 0x186, 28 => 0x114, 29 => 0x18b, 37 => 0x18, 133 => 0x1404, 170 => 'MinFocalLength', 238 => 0x8, 239 => 0xd, 240 => 0xe, 244 => 0xf, 335 => 0x207, 476 => 0x127a, 477 => 0x1136, 478 => 0x32e, 479 => 0x32e, 480 => 0x30c },
	'minfocallength2' => { 66 => 0x8 },
	'minfocusdistance' => { 385 => 0x3 },
	'minimumiso' => { 358 => 0xe8 },
	'minintegrationrows' => { 145 => 0x1874 },
	'minoltadate' => { 188 => 0x15 },
	'minoltaimagesize' => { 188 => 0x4, 189 => 0xc, 190 => 0x2, 193 => 0x103 },
	'minoltamodelid' => { 188 => 0x25 },
	'minoltaquality' => { 188 => 0x5, 189 => 0xd, 190 => 0x3, 193 => [0x102,0x103] },
	'minoltatime' => { 188 => 0x16 },
	'minormodelagedisclosure' => { 344 => 'MinorModelAgeDisclosure' },
	'minorversion' => { 415 => 'minor_version', 518 => 'MinorVersion' },
	'minsamplevalue' => { 125 => 0x118 },
	'mirrorlockup' => { 88 => 0xc, 89 => 0xc, 90 => 0x60f, 91 => 0xb, 92 => 0xc, 93 => 0x6, 94 => 0x6, 95 => 0xc, 96 => 0x3 },
	'mobilecountrycode' => { 527 => 'mcc' },
	'mobilenetworkcode' => { 527 => 'mnc' },
	'moddate' => { 347 => 'modify-date', 544 => 'ModDate' },
	'modedialposition' => { 455 => 0x14 },
	'model' => { 104 => 0x6, 125 => 0x110, 163 => 'Model', 347 => 'Model', 363 => 0x110, 395 => 0x23f, 415 => 'model', 421 => ['@mod','CNMN','cmnm',"\xa9mdl","\xa9mod"], 439 => 0x84, 511 => 'Model', 547 => 'model', 554 => 'Model' },
	'modelage' => { 542 => 'ModelAge' },
	'modelid' => { 333 => 0x0 },
	'modelingflash' => { 313 => '21.4', 314 => '31.1', 316 => '31.1', 317 => '31.1', 322 => '26.4', 323 => '30.2', 324 => '7.4', 325 => '30.1', 326 => '31.1', 327 => '31.1', 328 => '31.3', 329 => 0x61, 330 => 0x5d, 331 => 0x5d, 332 => 0x5d },
	'modelreleaseid' => { 344 => 'ModelReleaseID' },
	'modelreleasestatus' => { 344 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 486 => 0x52, 487 => 0x46, 488 => 0x53 },
	'modeltiepoint' => { 125 => 0x8482 },
	'modeltransform' => { 125 => 0x85d8 },
	'modelyear' => { 547 => 'modelYear' },
	'modificationdate' => { 548 => 'modificationDate' },
	'modifiedcolortemp' => { 71 => 0x9 },
	'modifieddigitalgain' => { 71 => 0xb },
	'modifiedparamflag' => { 62 => 0x1 },
	'modifiedpicturestyle' => { 71 => 0xa },
	'modifiedsaturation' => { 334 => 0x504 },
	'modifiedsensorbluelevel' => { 71 => 0x5 },
	'modifiedsensorredlevel' => { 71 => 0x4 },
	'modifiedsharpness' => { 71 => 0x2 },
	'modifiedsharpnessfreq' => { 71 => 0x3 },
	'modifiedtonecurve' => { 71 => 0x1 },
	'modifiedwhitebalance' => { 71 => 0x8 },
	'modifiedwhitebalanceblue' => { 71 => 0x7 },
	'modifiedwhitebalancered' => { 71 => 0x6 },
	'modifydate' => { 125 => 0x132, 164 => 'ModifyDate', 343 => 'ModDate', 345 => 'tIME', 411 => 'ModDate', 418 => 0x2, 556 => 'ModifyDate' },
	'moirefilter' => { 125 => 0xfe58, 528 => 'MoireFilter', 530 => 'MoireFilter' },
	'monitorbrightness' => { 250 => 0x904, 253 => 0x69a, 254 => 0x6aa, 255 => 0x59a, 256 => 0x5ca, 257 => 0x5e2 },
	'monitordisplayoff' => { 191 => 0x4c },
	'monitormatrix' => { 145 => 0x8fc },
	'monitorofftime' => { 313 => '18.2', 315 => '3.1', 324 => '3.1' },
	'monochromecolor' => { 334 => 0x53b },
	'monochromecontrast' => { 115 => 0x3c },
	'monochromefiltereffect' => { 109 => 0x20307, 115 => 0x3a, 358 => 0xac, 395 => 0x73 },
	'monochromegraineffect' => { 358 => 0xd2 },
	'monochromelinear' => { 115 => 0x3d },
	'monochromeoutputhighlightpoint' => { 115 => 0x41 },
	'monochromeoutputshadowpoint' => { 115 => 0x42 },
	'monochromeprofilesettings' => { 334 => 0x537 },
	'monochromerawhighlight' => { 115 => 0x7a },
	'monochromerawhighlightpoint' => { 115 => 0x3f },
	'monochromerawshadow' => { 115 => 0x83 },
	'monochromerawshadowpoint' => { 115 => 0x40 },
	'monochromesharpness' => { 115 => 0x3e },
	'monochrometoning' => { 395 => 0x74 },
	'monochrometoningeffect' => { 109 => 0x20306, 115 => 0x3b },
	'monochromeunsharpmaskfineness' => { 115 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 115 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 115 => 0xb4 },
	'monochromevignetting' => { 334 => 0x53a },
	'monthdaycreated' => { 147 => 0x12, 156 => 0xe },
	'mood' => { 186 => 'WM/Mood' },
	'moonphase' => { 423 => 0x12, 424 => 0x43, 425 => 0x4c },
	'morepermissions' => { 526 => 'morePermissions' },
	'motionphoto' => { 508 => 'MotionPhoto' },
	'motionphotopresentationtimestampus' => { 508 => 'MotionPhotoPresentationTimestampUs' },
	'motionphotoversion' => { 508 => 'MotionPhotoVersion' },
	'motionphotovideo' => { 416 => 'mpvd' },
	'motionsensitivity' => { 423 => 0x29, 425 => 0x60 },
	'movementcount' => { 413 => "\xa9mvc" },
	'movementname' => { 413 => "\xa9mvn" },
	'movementnumber' => { 413 => "\xa9mvi" },
	'movieactived-lighting' => { 251 => 0x238, 252 => 0x334, 255 => 0x2b8, 256 => 0x2e0, 257 => 0x2e0 },
	'movieaelockbuttonassignment' => { 326 => '40.1' },
	'movieaf-onbutton' => { 329 => 0xd3, 330 => 0xcb, 331 => 0xcb, 332 => 0xcb },
	'movieafareamode' => { 252 => 0x342, 255 => 0x2c6, 256 => 0x2ee, 257 => 0x2ee, 330 => 0x203, 331 => 0x203, 332 => 0x21b },
	'movieafspeed' => { 329 => 0xe5, 330 => 0xdd, 331 => 0xdd, 332 => 0xdd },
	'movieafspeedapply' => { 329 => 0xe7, 330 => 0xdf, 331 => 0xdf, 332 => 0xdf },
	'movieaftrackingsensitivity' => { 329 => 0xe9, 330 => 0xe1, 331 => 0xe1, 332 => 0xe1 },
	'movieaperturelock' => { 330 => 0x259, 331 => 0x259, 332 => 0x271 },
	'movieautodistortioncontrol' => { 251 => 0x242 },
	'moviediffractioncompensation' => { 251 => 0x241 },
	'moviedxcropalert' => { 252 => 0x377, 255 => 0x2fb, 256 => 0x323, 257 => 0x323 },
	'movieelectronicvr' => { 252 => 0x348, 255 => 0x2cc, 256 => 0x2f4, 257 => 0x2f4 },
	'movieevfgrid' => { 330 => 0x21d, 331 => 0x21d, 332 => 0x235 },
	'movieflickerreduction' => { 252 => 0x33c, 255 => 0x2c0, 256 => 0x2e8, 257 => 0x2e8 },
	'moviefocusmode' => { 251 => 0x248, 252 => 0x340, 255 => 0x2c4, 256 => 0x2ec, 257 => 0x2ec },
	'moviefocuspointlock' => { 330 => 0x226, 331 => 0x226, 332 => 0x23e },
	'movieframerate' => { 250 => 0x48c, 251 => 0x1f8, 252 => 0x374, 255 => 0x2f4, 256 => 0x31c, 257 => 0x31c },
	'movieframesize' => { 250 => 0x48a, 251 => 0x1f6, 252 => 0x372, 255 => 0x2f2, 256 => 0x31a, 257 => 0x31a },
	'moviefunc1button' => { 316 => '41.1', 317 => '41.1', 327 => '41.1', 329 => 0xc7, 330 => 0xc3, 331 => 0xc3, 332 => 0xc3 },
	'moviefunc2button' => { 329 => 0xcd, 330 => 0xc7, 331 => 0xc7, 332 => 0xc7 },
	'moviefunc3button' => { 331 => 0x127, 332 => 0x13f },
	'moviefunctionbutton' => { 314 => '41.1', 326 => '41.1' },
	'moviefunctionbuttonplusdials' => { 314 => '52.1' },
	'moviehighisonoisereduction' => { 251 => 0x23c, 252 => 0x336, 255 => 0x2ba, 256 => 0x2e2, 257 => 0x2e2 },
	'moviehighlightdisplaythreshold' => { 330 => 0x215, 331 => 0x215, 332 => 0x22d },
	'moviehighreszoom' => { 252 => 0x380, 256 => 0x32c, 257 => 0x32c },
	'movieimagearea' => { 252 => 0x2da, 255 => 0x25c, 256 => 0x286, 257 => 0x286 },
	'movieisoautocontrolmanualmode' => { 252 => 0x2e8, 255 => 0x26a, 256 => 0x294, 257 => 0x294 },
	'movieisoautohilimit' => { 252 => 0x2e6, 255 => 0x268, 256 => 0x292, 257 => 0x292 },
	'movieisoautomanualmode' => { 251 => 0x204, 252 => 0x2ea, 255 => 0x26c, 256 => 0x296, 257 => 0x296 },
	'movielenscontrolring' => { 329 => 0xdf, 330 => 0xd7, 331 => 0xd7, 332 => 0xd7 },
	'moviemeteringmode' => { 252 => 0x33e, 255 => 0x2c2, 256 => 0x2ea, 257 => 0x2ea },
	'moviemidtonedisplayrange' => { 330 => 0x219, 331 => 0x219, 332 => 0x231 },
	'moviemidtonedisplayvalue' => { 330 => 0x217, 331 => 0x217, 332 => 0x22f },
	'moviemultiselector' => { 329 => 0xe1, 330 => 0xd9, 331 => 0xcf, 332 => 0xcf },
	'moviepreviewbutton' => { 314 => '41.2', 316 => '41.2', 317 => '41.2', 326 => '41.2', 327 => '41.2' },
	'moviepreviewbuttonplusdials' => { 314 => '52.2' },
	'movierecordbuttonplaybackmode' => { 329 => 0x1af, 330 => 0x1b5, 331 => 0x1b5, 332 => 0x1cd },
	'movieshutterbutton' => { 314 => '38.3', 316 => '38.3', 317 => '38.3', 326 => '38.3', 327 => '38.3' },
	'movieshutterspeedlock' => { 330 => 0x225, 331 => 0x225, 332 => 0x23d },
	'movieslowmotion' => { 250 => 0x416, 251 => 0x1fa },
	'moviesoundrecording' => { 252 => 0x34a, 255 => 0x2ce, 256 => 0x2f6, 257 => 0x2f6 },
	'moviesubjectdetection' => { 252 => 0x378, 255 => 0x2fc, 256 => 0x324, 257 => 0x324 },
	'moviesubselectorassignment' => { 314 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 314 => '53.1' },
	'movietonemap' => { 255 => 0x2ec, 256 => 0x314, 257 => 0x314 },
	'movietype' => { 235 => 0x2ca, 250 => 0x41a, 251 => 0x1fe, 252 => 0x2e4, 255 => 0x266, 256 => 0x290, 257 => 0x290 },
	'movievibrationreduction' => { 251 => 0x24e },
	'movievibrationreductionsameasphoto' => { 251 => 0x24f },
	'movievignettecontrol' => { 251 => 0x23e, 252 => 0x1b0, 255 => 0x1a0, 256 => 0x1b4, 257 => 0x1b4 },
	'movievignettecontrolsameasphoto' => { 251 => 0x240 },
	'movievrmode' => { 252 => 0x344, 255 => 0x2c8, 256 => 0x2f0, 257 => 0x2f0 },
	'moviezebrapattern' => { 330 => 0x213, 331 => 0x213, 332 => 0x22b },
	'multiburstimageheight' => { 463 => 0x1002 },
	'multiburstimagewidth' => { 463 => 0x1001 },
	'multiburstmode' => { 463 => 0x1000 },
	'multicontrollerwhilemetering' => { 90 => 0x517 },
	'multiexposure' => { 73 => 0x1, 358 => 0xb4 },
	'multiexposureautogain' => { 259 => 0x3 },
	'multiexposurecontrol' => { 73 => 0x2 },
	'multiexposuremode' => { 259 => 0x1, 260 => 0x1 },
	'multiexposureoverlaymode' => { 260 => 0x3 },
	'multiexposureshots' => { 73 => 0x3, 250 => 0x1be, 252 => 0x9a, 255 => 0x8e, 256 => 0x9c, 257 => 0x9c, 259 => 0x2, 260 => 0x2 },
	'multiframenoisereduction' => { 451 => 0x35, 463 => 0x200b, 468 => 0x15 },
	'multiframenreffect' => { 463 => 0x2023 },
	'multifunctionlock' => { 90 => 0x70f },
	'multipleexposuremode' => { 250 => 0x1bc, 252 => 0x98, 255 => 0x8c, 256 => 0x9a, 257 => 0x9a, 338 => 0x101c },
	'multipleexposureset' => { 375 => '10.1' },
	'multisample' => { 272 => 0x40 },
	'multiselector' => { 313 => '9.4', 314 => '10.3', 316 => '10.3', 317 => '10.3', 322 => '27.4', 326 => '10.3', 327 => '10.3' },
	'multiselectorliveview' => { 313 => '4.3', 316 => '37.1', 317 => '37.1', 326 => '37.1', 327 => '37.1' },
	'multiselectorliveviewmode' => { 286 => 0x18c2 },
	'multiselectorplaybackmode' => { 313 => ['13.5','9.2'], 314 => '10.2', 317 => '10.2', 322 => '27.2', 326 => '10.2', 327 => '10.2', 329 => 0xb7, 330 => 0xb3, 331 => 0xb3, 332 => 0xb3 },
	'multiselectorshootmode' => { 313 => '9.1', 314 => '10.1', 316 => '10.1', 317 => '10.1', 322 => '27.1', 326 => '10.1', 327 => '10.1', 329 => 0xb3, 330 => 0xaf, 331 => 0xaf, 332 => 0xaf },
	'multishot' => { 363 => 0x121 },
	'mute' => { 412 => 'player.movie.audio.mute', 415 => 'player.movie.audio.mute' },
	'mycolormode' => { 74 => 0x2 },
	'name' => { 421 => 'name', 528 => 'Name', 530 => 'Name' },
	'narrator' => { 413 => "\xa9nrt" },
	'nationalcatalognumber' => { 548 => 'nationalCatalogNumber' },
	'nativedigest' => { 534 => 'NativeDigest', 554 => 'NativeDigest' },
	'nativeformat' => { 523 => 'NativeFormat' },
	'ndfilter' => { 82 => 0x1c, 334 => 0x204, 429 => 0x1019 },
	'near' => { 511 => 'Near' },
	'nefbitdepth' => { 246 => 0xe22 },
	'nefcompression' => { 246 => 0x93, 247 => 0xa },
	'neflinearizationtable' => { 246 => 0x96 },
	'negativecachelargepreviewsize' => { 528 => 'NegativeCacheLargePreviewSize', 530 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 528 => 'NegativeCacheMaximumSize', 530 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 528 => 'NegativeCachePath', 530 => 'NegativeCachePath' },
	'neutraldensityfactor' => { 525 => 'NeutralDensityFactor' },
	'neutraldensityfilter' => { 395 => 0x88 },
	'neutraloutputhighlightpoint' => { 115 => 0x2f },
	'neutraloutputshadowpoint' => { 115 => 0x30 },
	'neutralrawcolortone' => { 115 => 0x28 },
	'neutralrawcontrast' => { 115 => 0x2a },
	'neutralrawhighlight' => { 115 => 0x78 },
	'neutralrawhighlightpoint' => { 115 => 0x2d },
	'neutralrawlinear' => { 115 => 0x2b },
	'neutralrawsaturation' => { 115 => 0x29 },
	'neutralrawshadow' => { 115 => 0x81 },
	'neutralrawshadowpoint' => { 115 => 0x2e },
	'neutralrawsharpness' => { 115 => 0x2c },
	'neutralunsharpmaskfineness' => { 115 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 115 => 0xa8 },
	'neutraunsharpmaskstrength' => { 115 => 0xa4 },
	'newlensdata' => { 244 => 0x2f },
	'newrawimagedigest' => { 125 => 0xc7a7 },
	'newsphotoversion' => { 140 => 0x0 },
	'nickname' => { 556 => 'Nickname' },
	'nikoncapturedata' => { 246 => 0xe01 },
	'nikoncaptureeditversions' => { 246 => 0xe13 },
	'nikoncaptureoffsets' => { 246 => 0xe0e },
	'nikoncaptureoutput' => { 246 => 0xe1e },
	'nikoncaptureversion' => { 246 => 0xe09 },
	'nikoniccprofile' => { 246 => 0xe1d },
	'nikonimagesize' => { 283 => '723.1', 284 => '732.1', 292 => 0x2c4 },
	'nikonmeteringmode' => { 209 => 0x17, 250 => 0x2d2, 251 => 0x146, 263 => 0x214 },
	'nikonsettings' => { 246 => 0x4e },
	'noisefilter' => { 334 => 0x527 },
	'noiseprofile' => { 125 => 0xc761 },
	'noisereduction' => { 133 => [0x100b,0x100e], 189 => 0xb0, 190 => 0x60, 191 => 0x3f, 246 => 0x95, 306 => 0x753dcbc0, 307 => 0x17, 334 => 0x50a, 339 => 0x103a, 358 => 0x2d, 395 => 0x49, 429 => 0x100f, 431 => 0x2a },
	'noisereduction2' => { 338 => 0x1010 },
	'noisereductionapplied' => { 125 => 0xc6f7 },
	'noisereductionintensity' => { 307 => 0x9 },
	'noisereductionmethod' => { 307 => 0x11 },
	'noisereductionmode' => { 500 => 0x801e },
	'noisereductionparametersatcapture' => { 145 => 0xe73 },
	'noisereductionparameterscamera' => { 145 => 0xe72 },
	'noisereductionparametershost3mp' => { 145 => 0xe71 },
	'noisereductionparametershost6mp' => { 145 => 0xe70 },
	'noisereductionparametershostrgb' => { 145 => 0xe6f },
	'noisereductionparameterskhufu3mp' => { 145 => 0xe65 },
	'noisereductionparameterskhufu6mp' => { 145 => 0xe64 },
	'noisereductionparameterskhufurgb' => { 145 => 0xe63 },
	'noisereductionparams' => { 363 => 0x1b },
	'noisereductionsharpness' => { 307 => 0xd },
	'noisereductionstrength' => { 358 => 0xd6 },
	'noisereductionvalue' => { 500 => 0x8027 },
	'nomemorycard' => { 313 => '22.1', 314 => '4.2', 315 => '0.3', 318 => '2.4', 319 => '3.2', 320 => '3.2', 322 => '33.7', 323 => '3.2', 324 => '0.3', 326 => '4.2', 328 => '4.5' },
	'nominalmaxaperture' => { 385 => 0xa },
	'nominalminaperture' => { 385 => '10.1' },
	'noncpulens10focallength' => { 253 => 0x6c6, 254 => 0x6d6, 257 => 0x620 },
	'noncpulens10maxaperture' => { 253 => 0x6ee, 254 => 0x738, 257 => 0x670 },
	'noncpulens11focallength' => { 253 => 0x6c8, 254 => 0x6d8, 257 => 0x624 },
	'noncpulens11maxaperture' => { 253 => 0x6f0, 254 => 0x73c, 257 => 0x674 },
	'noncpulens12focallength' => { 253 => 0x6ca, 254 => 0x6da, 257 => 0x628 },
	'noncpulens12maxaperture' => { 253 => 0x6f2, 254 => 0x740, 257 => 0x678 },
	'noncpulens13focallength' => { 253 => 0x6cc, 254 => 0x6dc, 257 => 0x62c },
	'noncpulens13maxaperture' => { 253 => 0x6f4, 254 => 0x744, 257 => 0x67c },
	'noncpulens14focallength' => { 253 => 0x6ce, 254 => 0x6de, 257 => 0x630 },
	'noncpulens14maxaperture' => { 253 => 0x6f6, 254 => 0x748, 257 => 0x680 },
	'noncpulens15focallength' => { 253 => 0x6d0, 254 => 0x6e0, 257 => 0x634 },
	'noncpulens15maxaperture' => { 253 => 0x6f8, 254 => 0x74c, 257 => 0x684 },
	'noncpulens16focallength' => { 253 => 0x6d2, 254 => 0x6e2, 257 => 0x638 },
	'noncpulens16maxaperture' => { 253 => 0x6fa, 254 => 0x750, 257 => 0x688 },
	'noncpulens17focallength' => { 253 => 0x6d4, 254 => 0x6e4, 257 => 0x63c },
	'noncpulens17maxaperture' => { 253 => 0x6fc, 254 => 0x754, 257 => 0x68c },
	'noncpulens18focallength' => { 253 => 0x6d6, 254 => 0x6e6, 257 => 0x640 },
	'noncpulens18maxaperture' => { 253 => 0x6fe, 254 => 0x758, 257 => 0x690 },
	'noncpulens19focallength' => { 253 => 0x6d8, 254 => 0x6e8, 257 => 0x644 },
	'noncpulens19maxaperture' => { 253 => 0x700, 254 => 0x75c, 257 => 0x694 },
	'noncpulens1focallength' => { 253 => 0x6b4, 254 => 0x6c4, 257 => 0x5fc },
	'noncpulens1maxaperture' => { 253 => 0x6dc, 254 => 0x714, 257 => 0x64c },
	'noncpulens20focallength' => { 253 => 0x6da, 254 => 0x6ea, 257 => 0x648 },
	'noncpulens20maxaperture' => { 253 => 0x702, 254 => 0x760, 257 => 0x698 },
	'noncpulens2focallength' => { 253 => 0x6b6, 254 => 0x6c6, 257 => 0x600 },
	'noncpulens2maxaperture' => { 253 => 0x6de, 254 => 0x718, 257 => 0x650 },
	'noncpulens3focallength' => { 253 => 0x6b8, 254 => 0x6c8, 257 => 0x604 },
	'noncpulens3maxaperture' => { 253 => 0x6e0, 254 => 0x71c, 257 => 0x654 },
	'noncpulens4focallength' => { 253 => 0x6ba, 254 => 0x6ca, 257 => 0x608 },
	'noncpulens4maxaperture' => { 253 => 0x6e2, 257 => 0x658 },
	'noncpulens5focallength' => { 253 => 0x6bc, 254 => 0x6cc, 257 => 0x60c },
	'noncpulens5maxaperture' => { 253 => 0x6e4, 254 => 0x724, 257 => 0x65c },
	'noncpulens6focallength' => { 253 => 0x6be, 254 => 0x6ce, 257 => 0x610 },
	'noncpulens6maxaperture' => { 253 => 0x6e6, 254 => 0x728, 257 => 0x660 },
	'noncpulens7focallength' => { 253 => 0x6c0, 254 => 0x6d0, 257 => 0x614 },
	'noncpulens7maxaperture' => { 253 => 0x6e8, 254 => 0x72c, 257 => 0x664 },
	'noncpulens8focallength' => { 253 => 0x6c2, 254 => 0x6d2, 257 => 0x618 },
	'noncpulens8maxaperture' => { 253 => 0x6ea, 254 => 0x730, 257 => 0x668 },
	'noncpulens9focallength' => { 253 => 0x6c4, 254 => 0x6d4, 257 => 0x61c },
	'noncpulens9maxaperture' => { 253 => 0x6ec, 254 => 0x734, 257 => 0x66c },
	'normalizedcropcorners' => { 348 => 'NormalizedCropCorners' },
	'normallinetime' => { 145 => 0x186a },
	'normalwhitelevel' => { 44 => 0x32a, 45 => 0x280, 46 => 0x294, 49 => [0x2b8,0x2cf,0x2d3], 50 => 0x569, 51 => 0x1e3, 52 => [0x1fc,0x2dc], 53 => [0x230,0x30e], 54 => 0x31c },
	'notes' => { 502 => 'Notes', 522 => 'notes' },
	'npages' => { 563 => 'NPages' },
	'nullrecord' => { 103 => 0x0 },
	'numafpoints' => { 370 => 0x2 },
	'number' => { 548 => 'number' },
	'numberofbeats' => { 558 => 'numberOfBeats' },
	'numberoffocuspoints' => { 316 => '1.3', 317 => '1.3', 320 => '0.2', 321 => '0.3', 323 => '0.3' },
	'numcafpoints' => { 373 => 0x1 },
	'numfaceelements' => { 133 => 0x4200 },
	'numfacepositions' => { 350 => 0x0 },
	'numindexentries' => { 140 => 0x54 },
	'numwbentries' => { 364 => 0x0, 365 => 0x0 },
	'object' => { 548 => 'object' },
	'objectattributereference' => { 138 => 0x4 },
	'objectcycle' => { 138 => 0x4b, 522 => 'ObjectCycle' },
	'objectdescription' => { 547 => 'objectDescription' },
	'objectdistance' => { 118 => 0x6, 119 => 0x2022 },
	'objectname' => { 138 => 0x5 },
	'objectpreviewdata' => { 138 => 0xca },
	'objectpreviewfileformat' => { 138 => 0xc8 },
	'objectpreviewfileversion' => { 138 => 0xc9 },
	'objectsubtype' => { 547 => 'objectSubtype' },
	'objecttype' => { 547 => 'objectType' },
	'objecttypereference' => { 138 => 0x3 },
	'occurrence' => { 124 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 124 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 124 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 124 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 124 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 124 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 124 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecaste' => { 124 => [\'Occurrence','OccurrenceCaste'] },
	'occurrencecatalognumber' => { 124 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedegreeofestablishment' => { 124 => [\'Occurrence','OccurrenceDegreeOfEstablishment'] },
	'occurrencedetails' => { 124 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 124 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 124 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrencegeoreferenceverificationstatus' => { 124 => [\'Occurrence','OccurrenceGeoreferenceVerificationStatus'] },
	'occurrenceid' => { 124 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 124 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 124 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 124 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceorganismquantity' => { 124 => [\'Occurrence','OccurrenceOrganismQuantity'] },
	'occurrenceorganismquantitytype' => { 124 => [\'Occurrence','OccurrenceOrganismQuantityType'] },
	'occurrenceothercatalognumbers' => { 124 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepathway' => { 124 => [\'Occurrence','OccurrencePathway'] },
	'occurrencepreparations' => { 124 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 124 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 124 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordedbyid' => { 124 => [\'Occurrence','OccurrenceRecordedByID'] },
	'occurrencerecordnumber' => { 124 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 124 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 124 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 124 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 124 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'occurrencevitality' => { 124 => [\'Occurrence','OccurrenceVitality'] },
	'oecfcolumns' => { 534 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 534 => [\'OECF','OECFNames'] },
	'oecfrows' => { 534 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 534 => [\'OECF','OECFValues'] },
	'offsaledate' => { 548 => 'offSaleDate' },
	'offsaledatea-platform' => { 548 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 548 => [\'offSaleDate','offSaleDateDate'] },
	'offsetdacvalue' => { 145 => 0x190a },
	'offsethdr' => { 539 => 'OffsetHDR' },
	'offsetschema' => { 125 => 0xea1d },
	'offsetsdr' => { 539 => 'OffsetSDR' },
	'offsettime' => { 125 => 0x9010 },
	'offsettimedigitized' => { 125 => 0x9012 },
	'offsettimeoriginal' => { 125 => 0x9011 },
	'oismode' => { 1 => 0xf },
	'okbutton' => { 323 => '15.1', 328 => '16.1' },
	'oldsubfiletype' => { 125 => 0xff },
	'olympusimageheight' => { 339 => 0x102f },
	'olympusimagewidth' => { 339 => 0x102e },
	'omenatcapturestrength' => { 145 => 0xa60 },
	'omenautostrength' => { 145 => 0xa5f },
	'omenearlystrength' => { 145 => 0xa5e },
	'omenfocallengthlimit' => { 145 => 0xa62 },
	'omeninitialipfstrength' => { 145 => 0xa5d },
	'omensurfaceindex' => { 145 => 0xa64 },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 339 => 0x302 },
	'onsaledate' => { 548 => 'onSaleDate' },
	'onsaledatea-platform' => { 548 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 548 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 548 => 'onSaleDay' },
	'onsaledaya-platform' => { 548 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 548 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 125 => 0xc740 },
	'opcodelist2' => { 125 => 0xc741 },
	'opcodelist3' => { 125 => 0xc74e },
	'opticalzoom' => { 149 => 0xfa3d, 151 => [0x6006,0xf006], 152 => 0x1000, 153 => 0xf, 156 => 0x1e, 158 => 0x20, 159 => 0x1c, 170 => 'OpticalZoom' },
	'opticalzoomcode' => { 82 => 0xa },
	'opticalzoommode' => { 358 => 0x34 },
	'opticalzoomon' => { 438 => 0x219 },
	'optionenddate' => { 551 => 'optionEndDate' },
	'opto-electricconvfactor' => { 534 => 'OECF' },
	'orangehsl' => { 109 => 0x20911 },
	'ordernumber' => { 133 => 0x8002 },
	'organisationinimagecode' => { 542 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 542 => 'OrganisationInImageName' },
	'organism' => { 124 => 'Organism' },
	'organismassociatedoccurrences' => { 124 => [\'Organism','OrganismAssociatedOccurrences'] },
	'organismassociatedorganisms' => { 124 => [\'Organism','OrganismAssociatedOrganisms'] },
	'organismid' => { 124 => [\'Organism','OrganismOrganismID'] },
	'organismname' => { 124 => [\'Organism','OrganismOrganismName'] },
	'organismpreviousidentifications' => { 124 => [\'Organism','OrganismPreviousIdentifications'] },
	'organismremarks' => { 124 => [\'Organism','OrganismOrganismRemarks'] },
	'organismscope' => { 124 => [\'Organism','OrganismOrganismScope'] },
	'organization' => { 548 => 'organization' },
	'orientation' => { 125 => 0x112, 363 => 0x112, 547 => 'orientation', 554 => 'Orientation' },
	'orientation2' => { 468 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 90 => 0x516 },
	'originalalbumtitle' => { 186 => 'WM/OriginalAlbumTitle' },
	'originalartist' => { 186 => 'WM/OriginalArtist', 413 => "\xa9ope" },
	'originalbestqualitysize' => { 125 => 0xc792 },
	'originalcreatedatetime' => { 516 => 'OriginalCreateDateTime' },
	'originaldecisiondata' => { 120 => 'Canon-OriginalDecisionData' },
	'originaldecisiondataoffset' => { 69 => 0x83 },
	'originaldefaultcropsize' => { 125 => 0xc793 },
	'originaldefaultfinalsize' => { 125 => 0xc791 },
	'originaldirectory' => { 355 => 0x408 },
	'originaldocumentid' => { 559 => 'OriginalDocumentID' },
	'originalfilename' => { 103 => 0x816, 145 => 0x3e9, 157 => 0x20, 355 => 0x407, 516 => 'OriginalFilename' },
	'originalfilepath' => { 421 => 'fsid' },
	'originalimagehash' => { 505 => 'OriginalImageHash' },
	'originalimagehashtype' => { 505 => 'OriginalImageHashType' },
	'originalimageheight' => { 84 => 0xc, 129 => 0x1 },
	'originalimagemd5' => { 505 => 'OriginalImageMD5' },
	'originalimagesize' => { 169 => 'OriginalImageSize' },
	'originalimagewidth' => { 84 => 0xb, 129 => 0x0 },
	'originallyricist' => { 186 => 'WM/OriginalLyricist' },
	'originalrawfiledata' => { 125 => 0xc68c },
	'originalrawfiledigest' => { 125 => 0xc71d },
	'originalrawfilename' => { 125 => 0xc68b },
	'originaltransmissionreference' => { 138 => 0x67 },
	'originatingprogram' => { 138 => 0x41, 522 => 'OriginatingProgram' },
	'originplatform' => { 548 => 'originPlatform' },
	'os' => { 532 => 'os' },
	'otherconditions' => { 344 => 'OtherConditions' },
	'otherconstraints' => { 344 => 'OtherConstraints' },
	'otherimage' => { 120 => 'Exif-OtherImage' },
	'otherimageinfo' => { 344 => 'OtherImageInfo' },
	'otherimagelength' => { 125 => 0x202 },
	'otherimagestart' => { 125 => 0x201 },
	'otherlicensedocuments' => { 344 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 344 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 344 => 'OtherLicenseRequirements' },
	'outcue' => { 558 => 'outCue' },
	'outcuescale' => { 558 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 558 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 210 => 0x3 },
	'outputimagewidth' => { 210 => 0x2 },
	'outputlut' => { 358 => 0xa7 },
	'outputprofile' => { 145 => 0x138b },
	'outputresolution' => { 210 => 0x4 },
	'overclockcols' => { 145 => 0x189c },
	'overclockrows' => { 145 => 0x18c4 },
	'overridelookvignette' => { 528 => 'OverrideLookVignette', 530 => 'OverrideLookVignette' },
	'owner' => { 413 => 'ownr', 562 => 'Owner' },
	'ownerid' => { 138 => 0xbc },
	'ownername' => { 15 => 0x10f, 69 => 0x9, 103 => 0x810, 125 => [0xa430,0xfde8], 163 => 'OwnerName', 525 => 'OwnerName', 535 => 'CameraOwnerName' },
	'padding' => { 125 => 0xea1c },
	'pagecount' => { 548 => 'pageCount' },
	'pageimage' => { 556 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 556 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 556 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 556 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 556 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 556 => 'PageInfo' },
	'pagename' => { 125 => 0x11d },
	'pagenumber' => { 125 => 0x129 },
	'pageprogressiondirection' => { 548 => 'pageProgressionDirection' },
	'pagerange' => { 548 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 528 => 'PaintBasedCorrections', 530 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionblacks2012' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'] },
	'paintcorrectionbrightness' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectioncorrectionname' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'] },
	'paintcorrectioncorrectionsyncid' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'] },
	'paintcorrectiondefringe' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectiondehaze' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'] },
	'paintcorrectionexposure' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'] },
	'paintcorrectionluminancenoise' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskinputdigest' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'] },
	'paintcorrectionmaskleft' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmaskactive' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'] },
	'paintcorrectionmaskmaskblendmode' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'paintcorrectionmaskmaskdigest' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'] },
	'paintcorrectionmaskmaskinverted' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'] },
	'paintcorrectionmaskmaskname' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'] },
	'paintcorrectionmaskmasks' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'] },
	'paintcorrectionmaskmasksalpha' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'paintcorrectionmaskmasksangle' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'] },
	'paintcorrectionmaskmasksbottom' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'] },
	'paintcorrectionmaskmaskscentervalue' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'paintcorrectionmaskmaskscenterweight' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'paintcorrectionmaskmasksdabs' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'] },
	'paintcorrectionmaskmasksfeather' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'] },
	'paintcorrectionmaskmasksflipped' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'paintcorrectionmaskmasksflow' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'] },
	'paintcorrectionmaskmasksfullx' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'] },
	'paintcorrectionmaskmasksfully' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'] },
	'paintcorrectionmaskmasksinputdigest' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'paintcorrectionmaskmasksleft' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'] },
	'paintcorrectionmaskmasksmaskactive' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'paintcorrectionmaskmasksmaskblendmode' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'paintcorrectionmaskmasksmaskdigest' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'paintcorrectionmaskmasksmaskinverted' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'paintcorrectionmaskmasksmaskname' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'paintcorrectionmaskmasksmasksubtype' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'paintcorrectionmaskmasksmasksyncid' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'paintcorrectionmaskmasksmaskversion' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'paintcorrectionmaskmasksmidpoint' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'paintcorrectionmaskmasksorigin' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'paintcorrectionmaskmasksperimetervalue' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'paintcorrectionmaskmasksradius' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'] },
	'paintcorrectionmaskmasksreferencepoint' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'paintcorrectionmaskmasksright' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'] },
	'paintcorrectionmaskmasksroundness' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'paintcorrectionmaskmaskssizex' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'paintcorrectionmaskmaskssizey' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'paintcorrectionmaskmaskstop' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'] },
	'paintcorrectionmaskmasksubtype' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'] },
	'paintcorrectionmaskmasksvalue' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'paintcorrectionmaskmasksversion' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'] },
	'paintcorrectionmaskmaskswhat' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'] },
	'paintcorrectionmaskmaskswholeimagearea' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'paintcorrectionmaskmasksx' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'] },
	'paintcorrectionmaskmasksy' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'] },
	'paintcorrectionmaskmasksyncid' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'paintcorrectionmaskmaskszerox' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'paintcorrectionmaskmaskszeroy' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'paintcorrectionmaskmaskversion' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'] },
	'paintcorrectionmaskmidpoint' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskorigin' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'] },
	'paintcorrectionmaskperimetervalue' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskrange' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'paintcorrectionmaskrangeareamodels' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'paintcorrectionmaskrangeareamodelscolorsampleinfo' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionmaskrangeareamodelscomponents' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionmaskrangecoloramount' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'paintcorrectionmaskrangedepthfeather' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionmaskrangedepthmax' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'paintcorrectionmaskrangedepthmin' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'paintcorrectionmaskrangeinvert' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'paintcorrectionmaskrangelumfeather' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'paintcorrectionmaskrangeluminancedepthsampleinfo' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionmaskrangelummax' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'paintcorrectionmaskrangelummin' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'paintcorrectionmaskrangelumrange' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'paintcorrectionmaskrangesampletype' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'paintcorrectionmaskrangetype' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'paintcorrectionmaskrangeversion' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'paintcorrectionmaskreferencepoint' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'] },
	'paintcorrectionmaskright' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskwholeimagearea' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'paintcorrectionmaskx' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionrangemask' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'] },
	'paintcorrectionrangemaskareamodels' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'paintcorrectionrangemaskareamodelscolorsampleinfo' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionrangemaskareamodelscomponents' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionrangemaskcoloramount' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'paintcorrectionrangemaskdepthfeather' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionrangemaskdepthmax' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'paintcorrectionrangemaskdepthmin' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'paintcorrectionrangemaskinvert' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'] },
	'paintcorrectionrangemasklumfeather' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'paintcorrectionrangemaskluminancedepthsampleinfo' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionrangemasklummax' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'paintcorrectionrangemasklummin' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'paintcorrectionrangemasklumrange' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'paintcorrectionrangemasksampletype' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'paintcorrectionrangemasktype' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'] },
	'paintcorrectionrangemaskversion' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'] },
	'paintcorrectionsaturation' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'] },
	'paintcorrectionshadows2012' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontexture' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'] },
	'paintcorrectiontint' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectiontoninghue' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectiontoningsaturation' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionwhat' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'paintcorrectionwhites2012' => { 528 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'], 530 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'] },
	'panasonicdatetime' => { 361 => 0x0 },
	'panasonicexifversion' => { 358 => 0x26 },
	'panasonicimageheight' => { 358 => 0x4c },
	'panasonicimagewidth' => { 358 => 0x4b },
	'panasonicrawversion' => { 363 => 0x1 },
	'panasonictitle' => { 125 => 0xc6d2 },
	'panasonictitle2' => { 125 => 0xc6d3 },
	'panoramaangle' => { 133 => 0x1153 },
	'panoramacropbottom' => { 469 => 0x7 },
	'panoramacropleft' => { 469 => 0x4 },
	'panoramacropright' => { 469 => 0x6 },
	'panoramacroptop' => { 469 => 0x5 },
	'panoramadirection' => { 77 => 0x5, 133 => 0x1154, 469 => 0x3 },
	'panoramaframeheight' => { 469 => 0x9 },
	'panoramaframenumber' => { 77 => 0x2 },
	'panoramaframewidth' => { 469 => 0x8 },
	'panoramafullheight' => { 469 => 0x2 },
	'panoramafullwidth' => { 469 => 0x1 },
	'panoramamode' => { 147 => 0x3c, 334 => 0x601 },
	'panoramasize3d' => { 451 => 0x38 },
	'panoramasourceheight' => { 469 => 0xb },
	'panoramasourcewidth' => { 469 => 0xa },
	'panoramicstitchcameramotion' => { 183 => 'PanoramicStitchCameraMotion', 184 => 0x1 },
	'panoramicstitchmaptype' => { 183 => 'PanoramicStitchMapType', 184 => 0x2 },
	'panoramicstitchphi0' => { 183 => 'PanoramicStitchPhi0', 184 => 0x5 },
	'panoramicstitchphi1' => { 183 => 'PanoramicStitchPhi1', 184 => 0x6 },
	'panoramicstitchtheta0' => { 183 => 'PanoramicStitchTheta0', 184 => 0x3 },
	'panoramicstitchtheta1' => { 183 => 'PanoramicStitchTheta1', 184 => 0x4 },
	'panoramicstitchversion' => { 184 => 0x0 },
	'pantry' => { 559 => 'Pantry' },
	'pantryinstanceid' => { 559 => [\'Pantry','PantryInstanceID'] },
	'parallax' => { 133 => 0xb211, 333 => 0x28 },
	'parameters' => { 347 => 'parameters' },
	'parametricdarks' => { 528 => 'ParametricDarks', 530 => 'ParametricDarks' },
	'parametrichighlights' => { 528 => 'ParametricHighlights', 530 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 528 => 'ParametricHighlightSplit', 530 => 'ParametricHighlightSplit' },
	'parametriclights' => { 528 => 'ParametricLights', 530 => 'ParametricLights' },
	'parametricmidtonesplit' => { 528 => 'ParametricMidtoneSplit', 530 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 528 => 'ParametricShadows', 530 => 'ParametricShadows' },
	'parametricshadowsplit' => { 528 => 'ParametricShadowSplit', 530 => 'ParametricShadowSplit' },
	'parentalrating' => { 186 => 'WM/ParentalRating' },
	'parentid' => { 542 => 'parentId' },
	'parentmeasurementid' => { 124 => [\'MeasurementOrFact','MeasurementOrFactParentMeasurementID'] },
	'parentmediaeventid' => { 516 => 'ParentMediaEventID' },
	'parentmeid' => { 516 => 'ParentMEID' },
	'parentproductid' => { 413 => '@ppi' },
	'parentreference1' => { 540 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 540 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 540 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 540 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 540 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 540 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentshorttitle' => { 413 => '@PST' },
	'parenttitle' => { 413 => '@pti' },
	'partialactivecols1' => { 145 => 0x17e8 },
	'partialactivecols2' => { 145 => 0x17f2 },
	'partialactiverows1' => { 145 => 0x17fc },
	'partialactiverows2' => { 145 => 0x1806 },
	'partofcompilation' => { 558 => 'partOfCompilation' },
	'patientbirthdate' => { 503 => 'PatientDOB' },
	'patientid' => { 503 => 'PatientID' },
	'patientname' => { 503 => 'PatientName' },
	'patientsex' => { 503 => 'PatientSex' },
	'patternareaheight' => { 145 => 0x963 },
	'patternareawidth' => { 145 => 0x962 },
	'patterncorrectionfactorscale' => { 145 => 0x969 },
	'patterncropcols1' => { 145 => 0x96c },
	'patterncropcols2' => { 145 => 0x96d },
	'patterncroprows1' => { 145 => 0x96a },
	'patterncroprows2' => { 145 => 0x96b },
	'patternimagerheight' => { 145 => 0x961 },
	'patternimagerwidth' => { 145 => 0x960 },
	'patternx' => { 145 => 0x966 },
	'patterny' => { 145 => 0x967 },
	'pdfversion' => { 544 => 'PDFVersion' },
	'pentaximagesize' => { 395 => 0x9 },
	'pentaxmodelid' => { 374 => 0x0, 395 => 0x5 },
	'pentaxmodeltype' => { 395 => 0x1 },
	'pentaxversion' => { 395 => 0x0 },
	'people' => { 506 => 'People', 520 => 'People' },
	'perchannelblacklevel' => { 44 => 0x157, 45 => 0x16b, 46 => 0x17f, 48 => 0xc4, 49 => [0x2b4,0x2cb,0x2cf], 50 => [0x108,0x14d], 51 => 0x1df, 52 => [0x1f8,0x2d8], 53 => [0x22c,0x30a], 54 => 0x149 },
	'performer' => { 413 => 'perf', 421 => 'perf' },
	'performerkeywords' => { 421 => "\xa9prk" },
	'performers' => { 421 => "\xa9prf" },
	'performerurl' => { 421 => "\xa9prl" },
	'period' => { 186 => 'WM/Period' },
	'peripheralillumcentralradius' => { 500 => 0x8030 },
	'peripheralillumcentralvalue' => { 500 => 0x8031 },
	'peripheralillumination' => { 109 => 0x20702, 115 => 0x68 },
	'peripheralilluminationcorr' => { 67 => 0x1, 384 => 0x2 },
	'peripheralilluminationon' => { 109 => '0x20702.0', 115 => 0x64 },
	'peripheralillumperiphvalue' => { 500 => 0x8032 },
	'peripherallighting' => { 84 => 0x2, 133 => 0x3804 },
	'peripherallightingsetting' => { 85 => 0x5 },
	'peripherallightingvalue' => { 84 => 0x6 },
	'permissions' => { 551 => 'permissions' },
	'permits' => { 526 => 'permits' },
	'person' => { 548 => 'person' },
	'personality' => { 516 => 'Personality' },
	'personheard' => { 542 => 'PersonHeard' },
	'personheardidentifier' => { 542 => [\'PersonHeard','PersonHeardIdentifier'] },
	'personheardname' => { 542 => [\'PersonHeard','PersonHeardName'] },
	'personinimage' => { 542 => 'PersonInImage' },
	'personinimagecharacteristic' => { 542 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 542 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 542 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 542 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 542 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 542 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 542 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 542 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 542 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 528 => 'PerspectiveAspect', 530 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 528 => 'PerspectiveHorizontal', 530 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 528 => 'PerspectiveRotate', 530 => 'PerspectiveRotate' },
	'perspectivescale' => { 528 => 'PerspectiveScale', 530 => 'PerspectiveScale' },
	'perspectiveupright' => { 528 => 'PerspectiveUpright', 530 => 'PerspectiveUpright' },
	'perspectivevertical' => { 528 => 'PerspectiveVertical', 530 => 'PerspectiveVertical' },
	'perspectivex' => { 528 => 'PerspectiveX', 530 => 'PerspectiveX' },
	'perspectivey' => { 528 => 'PerspectiveY', 530 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 98 => 0x1 },
	'pf10retainprogramshift' => { 98 => 0xb },
	'pf13drivepriority' => { 98 => 0xe },
	'pf14disablefocussearch' => { 98 => 0xf },
	'pf15disableafassistbeam' => { 98 => 0x10 },
	'pf16autofocuspointshoot' => { 98 => 0x11 },
	'pf17disableafpointsel' => { 98 => 0x12 },
	'pf18enableautoafpointsel' => { 98 => 0x13 },
	'pf19continuousshootspeed' => { 98 => 0x14 },
	'pf19shootingspeedhigh' => { 97 => 0xa },
	'pf19shootingspeedlow' => { 97 => 0x9 },
	'pf1disableshootingmodes' => { 98 => 0x2 },
	'pf1value' => { 97 => 0x1 },
	'pf20limitcontinousshots' => { 98 => 0x15 },
	'pf20maxcontinousshots' => { 97 => 0xb },
	'pf21enablequietoperation' => { 98 => 0x16 },
	'pf23felocktime' => { 97 => 0xd },
	'pf23postreleasetime' => { 97 => 0xe },
	'pf23settimerlengths' => { 98 => 0x18 },
	'pf23shutterbuttontime' => { 97 => 0xc },
	'pf24lightlcdduringbulb' => { 98 => 0x19 },
	'pf25aemode' => { 97 => 0xf },
	'pf25afmode' => { 97 => 0x12 },
	'pf25afpointsel' => { 97 => 0x13 },
	'pf25colormatrix' => { 97 => 0x17 },
	'pf25defaultclearsettings' => { 98 => 0x1a },
	'pf25drivemode' => { 97 => 0x11 },
	'pf25imagesize' => { 97 => 0x14 },
	'pf25meteringmode' => { 97 => 0x10 },
	'pf25parameters' => { 97 => 0x16 },
	'pf25wbmode' => { 97 => 0x15 },
	'pf26shortenreleaselag' => { 98 => 0x1b },
	'pf27reversedialrotation' => { 98 => 0x1c },
	'pf27value' => { 97 => 0x18 },
	'pf28noquickdialexpcomp' => { 98 => 0x1d },
	'pf29quickdialswitchoff' => { 98 => 0x1e },
	'pf2disablemeteringmodes' => { 98 => 0x3 },
	'pf2value' => { 97 => 0x2 },
	'pf30enlargementmode' => { 98 => 0x1f },
	'pf31originaldecisiondata' => { 98 => 0x20 },
	'pf3manualexposuremetering' => { 98 => 0x4 },
	'pf3value' => { 97 => 0x3 },
	'pf4exposuretimelimits' => { 98 => 0x5 },
	'pf4exposuretimemax' => { 97 => 0x5 },
	'pf4exposuretimemin' => { 97 => 0x4 },
	'pf5aperturelimits' => { 98 => 0x6 },
	'pf5aperturemax' => { 97 => 0x7 },
	'pf5aperturemin' => { 97 => 0x6 },
	'pf6presetshootingmodes' => { 98 => 0x7 },
	'pf7bracketcontinuousshoot' => { 98 => 0x8 },
	'pf8bracketshots' => { 97 => 0x8 },
	'pf8setbracketshots' => { 98 => 0x9 },
	'pf9changebracketsequence' => { 98 => 0xa },
	'phasedetectaf' => { 202 => 0x6 },
	'phonenumber' => { 164 => 'Phone' },
	'photoeffect' => { 37 => 0x28 },
	'photoeffecthistoryxml' => { 306 => 0xe9651831 },
	'photoeffects' => { 306 => 0xab5eca5e },
	'photoeffectsblue' => { 308 => 0x8 },
	'photoeffectsgreen' => { 308 => 0x6 },
	'photoeffectsred' => { 308 => 0x4 },
	'photoeffectstype' => { 308 => 0x0 },
	'photographer' => { 125 => 0xa437, 535 => 'Photographer' },
	'photographicsensitivity' => { 535 => 'PhotographicSensitivity' },
	'photoidentifier' => { 1 => 0x2b },
	'photoinfoplayback' => { 313 => '17.6', 322 => '33.6' },
	'photometricinterpretation' => { 125 => 0x106, 554 => 'PhotometricInterpretation' },
	'photosappfeatureflags' => { 1 => 0x1f },
	'photoshootingmenubank' => { 252 => 0x11e, 255 => 0x112, 256 => 0x122, 257 => 0x122, 258 => 0x24, 276 => 0x0 },
	'photoshootingmenubankimagearea' => { 249 => 0x6dd, 252 => 0x144, 255 => 0x134, 256 => 0x148, 257 => 0x148, 276 => '7.1' },
	'photoshopbgrthumbnail' => { 409 => 0x409 },
	'photoshopquality' => { 408 => 0x0 },
	'photoshopthumbnail' => { 409 => 0x40c },
	'photostyle' => { 358 => 0x89 },
	'picasawebgphotoid' => { 533 => 'picasawebGPhotoId' },
	'pick' => { 558 => 'pick' },
	'picklabel' => { 533 => 'PickLabel' },
	'pictinfo' => { 438 => 0x208 },
	'picturecontrol' => { 306 => 0xe2173c47 },
	'picturecontrolactive' => { 309 => 0x0 },
	'picturecontroladjust' => { 264 => 0x30, 265 => 0x30, 266 => 0x36 },
	'picturecontrolbase' => { 264 => 0x18, 265 => 0x18, 266 => 0x1c },
	'picturecontroldata' => { 246 => [0xbd,0x23] },
	'picturecontrolmode' => { 309 => 0x13 },
	'picturecontrolname' => { 264 => 0x4, 265 => 0x4, 266 => 0x8 },
	'picturecontrolquickadjust' => { 264 => 0x31, 265 => 0x31, 266 => 0x37 },
	'pictureeffect' => { 463 => 0x200e },
	'pictureeffect2' => { 472 => 0x1163, 473 => 0x1167, 474 => 0x1143, 475 => 0x11bf, 476 => 0x119b, 477 => 0x1053, 478 => 0x24b, 479 => 0x24b, 480 => 0x23c, 495 => 0x46 },
	'picturefinish' => { 189 => 0x71 },
	'picturemode' => { 133 => 0x1031, 334 => 0x520, 395 => [0xb,0x33], 439 => 0x3d },
	'picturemode2' => { 375 => 0x0 },
	'picturemodebwfilter' => { 334 => 0x525 },
	'picturemodecontrast' => { 334 => 0x523 },
	'picturemodeeffect' => { 334 => 0x52d },
	'picturemodehue' => { 334 => 0x522 },
	'picturemodesaturation' => { 334 => 0x521 },
	'picturemodesharpness' => { 334 => 0x524 },
	'picturemodetone' => { 334 => 0x526 },
	'pictureprofile' => { 472 => [0x115e,0x115f], 473 => [0x1162,0x1163], 474 => [0x113e,0x113f], 475 => [0x11ba,0x11bb], 476 => [0x1196,0x1197], 477 => [0x104e,0x104f], 478 => [0x246,0x247], 479 => [0x246,0x247], 480 => [0x237,0x238] },
	'picturestyle' => { 8 => [0x4b,0x51], 9 => 0xf4, 10 => 0x6c, 11 => 0x86, 12 => 0x73, 16 => 0xab, 17 => 0xa7, 18 => 0xb0, 19 => 0x6c, 20 => 0xa7, 21 => 0xf4, 22 => 0xb3, 24 => 0xf4, 25 => 0xfa, 27 => 0x169, 79 => 0xa, 109 => 0x20301, 115 => 0x2 },
	'picturestylepc' => { 69 => 0x4009 },
	'picturestyleuserdef' => { 69 => 0x4008 },
	'picturewizard' => { 436 => 0x21 },
	'picturewizardcolor' => { 435 => 0x1 },
	'picturewizardcontrast' => { 435 => 0x4 },
	'picturewizardmode' => { 435 => 0x0 },
	'picturewizardsaturation' => { 435 => 0x2 },
	'picturewizardsharpness' => { 435 => 0x3 },
	'pipelineversion' => { 183 => 'PipelineVersion' },
	'pitch' => { 121 => 0x6, 314 => '4.1', 326 => '4.1', 421 => ['ptch',"\xa9fpt"] },
	'pitchangle' => { 66 => 0x5, 262 => 0x4, 334 => 0x904, 348 => 'PitchAngle', 358 => 0x91, 393 => 0x2, 394 => 0x5, 434 => 0x1 },
	'pitchshift' => { 412 => 'player.movie.audio.pitchshift', 415 => 'player.movie.audio.pitchshift' },
	'pixelaspectratio' => { 414 => 'pasp' },
	'pixelclockfrequency' => { 145 => 0x40b },
	'pixelcorrectionoffset' => { 145 => 0x972 },
	'pixelcorrectionscale' => { 145 => 0x971 },
	'pixelscale' => { 125 => 0x830e },
	'pixelshiftdelay' => { 250 => 0x38c, 254 => 0x802 },
	'pixelshiftinfo' => { 463 => 0x202f },
	'pixelshiftinterval' => { 250 => 0x38e },
	'pixelshiftnumbershots' => { 250 => 0x38a, 254 => 0x800 },
	'pixelshiftoffset' => { 133 => 0x1106 },
	'pixelshiftresolution' => { 396 => 0x0 },
	'pixelshiftshooting' => { 250 => 0x388, 254 => 0x7fe },
	'pixelshiftshots' => { 133 => 0x1105 },
	'pixelsperunitx' => { 346 => 0x0 },
	'pixelsperunity' => { 346 => 0x4 },
	'pixelunits' => { 346 => 0x8 },
	'planarconfiguration' => { 125 => 0x11c, 554 => 'PlanarConfiguration' },
	'plane' => { 504 => [\'Planes','PlanesPlane'] },
	'planeboundary' => { 504 => [\'Planes','PlanesPlaneBoundary'] },
	'planeboundaryvertexcount' => { 504 => [\'Planes','PlanesPlaneBoundaryVertexCount'] },
	'planeextentx' => { 504 => [\'Planes','PlanesPlaneExtentX'] },
	'planeextentz' => { 504 => [\'Planes','PlanesPlaneExtentZ'] },
	'planepose' => { 504 => [\'Planes','PlanesPlanePose'] },
	'planeposepositionx' => { 504 => [\'Planes','PlanesPlanePosePositionX'] },
	'planeposepositiony' => { 504 => [\'Planes','PlanesPlanePosePositionY'] },
	'planeposepositionz' => { 504 => [\'Planes','PlanesPlanePosePositionZ'] },
	'planeposerotationw' => { 504 => [\'Planes','PlanesPlanePoseRotationW'] },
	'planeposerotationx' => { 504 => [\'Planes','PlanesPlanePoseRotationX'] },
	'planeposerotationy' => { 504 => [\'Planes','PlanesPlanePoseRotationY'] },
	'planeposerotationz' => { 504 => [\'Planes','PlanesPlanePoseRotationZ'] },
	'planeposetimestamp' => { 504 => [\'Planes','PlanesPlanePoseTimestamp'] },
	'planes' => { 504 => 'Planes' },
	'planningref' => { 542 => 'PlanningRef' },
	'planningrefidentifier' => { 542 => [\'PlanningRef','PlanningRefIdentifier'] },
	'planningrefname' => { 542 => [\'PlanningRef','PlanningRefName'] },
	'planningrefrole' => { 542 => [\'PlanningRef','PlanningRefRole'] },
	'platenames' => { 563 => 'PlateNames' },
	'platform' => { 548 => 'platform' },
	'playallframes' => { 421 => 'AllF' },
	'playbackbutton' => { 254 => 0x804, 257 => 0x808 },
	'playbackbuttonplaybackmode' => { 254 => 0x80e, 257 => 0x814 },
	'playbackflickdown' => { 329 => 0x149, 330 => 0x159, 331 => 0x159, 332 => 0x171 },
	'playbackflickup' => { 329 => 0x145, 330 => 0x155, 331 => 0x155, 332 => 0x16d },
	'playbackmenustime' => { 318 => '20.1', 319 => '21.1', 320 => '21.1' },
	'playbackmonitorofftime' => { 313 => '25.2', 314 => '36.1', 316 => '36.1', 317 => '36.1', 321 => '35.1', 322 => '8.1', 323 => '35.1', 326 => '36.1', 327 => '36.1', 328 => '21.1', 329 => 0x37, 330 => 0x33, 331 => 0x33, 332 => 0x33 },
	'playbackzoom' => { 314 => '37.1' },
	'playdisplay' => { 191 => 0x4e },
	'playerversion' => { 415 => 'player.version' },
	'playgap' => { 413 => 'pgap' },
	'playmode' => { 421 => 'SDLN' },
	'playselection' => { 421 => 'SelO' },
	'plusversion' => { 344 => 'Version' },
	'pmversion' => { 407 => 'PMVersion' },
	'pngwarning' => { 347 => 'Warning' },
	'podcast' => { 413 => 'pcst' },
	'podcasturl' => { 413 => 'purl' },
	'poilevel' => { 245 => 0x8 },
	'portraitimpressionbalance' => { 250 => 0x378, 252 => 0x26e, 267 => 0xa0 },
	'portraitnote' => { 508 => 'PortraitNote' },
	'portraitoutputhighlightpoint' => { 115 => 0x1d },
	'portraitoutputshadowpoint' => { 115 => 0x1e },
	'portraitrawcolortone' => { 115 => 0x16 },
	'portraitrawcontrast' => { 115 => 0x18 },
	'portraitrawhighlight' => { 115 => 0x76 },
	'portraitrawhighlightpoint' => { 115 => 0x1b },
	'portraitrawlinear' => { 115 => 0x19 },
	'portraitrawsaturation' => { 115 => 0x17 },
	'portraitrawshadow' => { 115 => 0x7f },
	'portraitrawshadowpoint' => { 115 => 0x1c },
	'portraitrawsharpness' => { 115 => 0x1a },
	'portraitrefiner' => { 119 => 0x302b },
	'portraitrequest' => { 508 => 'PortraitRequest' },
	'portraitunsharpmaskfineness' => { 115 => 0x9a },
	'portraitunsharpmaskstrength' => { 115 => 0x98 },
	'portraitunsharpmaskthreshold' => { 115 => 0x9c },
	'portraitversion' => { 508 => 'PortraitVersion' },
	'pose' => { 504 => 'Pose' },
	'poseheadingdegrees' => { 514 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 514 => 'PosePitchDegrees' },
	'posepositionx' => { 504 => [\'Pose','PosePositionX'] },
	'posepositiony' => { 504 => [\'Pose','PosePositionY'] },
	'posepositionz' => { 504 => [\'Pose','PosePositionZ'] },
	'poserolldegrees' => { 514 => 'PoseRollDegrees' },
	'poserotationw' => { 504 => [\'Pose','PoseRotationW'] },
	'poserotationx' => { 504 => [\'Pose','PoseRotationX'] },
	'poserotationy' => { 504 => [\'Pose','PoseRotationY'] },
	'poserotationz' => { 504 => [\'Pose','PoseRotationZ'] },
	'posetimestamp' => { 504 => [\'Pose','PoseTimestamp'] },
	'positiondescriptor' => { 547 => 'positionDescriptor' },
	'postalcode' => { 168 => 'PostalCode' },
	'postcropvignetteamount' => { 528 => 'PostCropVignetteAmount', 530 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 528 => 'PostCropVignetteFeather', 530 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 528 => 'PostCropVignetteHighlightContrast', 530 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 528 => 'PostCropVignetteMidpoint', 530 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 528 => 'PostCropVignetteRoundness', 530 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 528 => 'PostCropVignetteStyle', 530 => 'PostCropVignetteStyle' },
	'postfocusmerging' => { 358 => 0xbf },
	'postreleaseburstlength' => { 256 => 0x714, 257 => 0x784, 330 => 0x289 },
	'potentialface1position' => { 459 => 0xb },
	'potentialface2position' => { 459 => 0x15 },
	'potentialface3position' => { 459 => 0x1f },
	'potentialface4position' => { 459 => 0x29 },
	'potentialface5position' => { 459 => 0x33 },
	'potentialface6position' => { 459 => 0x3d },
	'potentialface7position' => { 459 => 0x47 },
	'potentialface8position' => { 459 => 0x51 },
	'poweravailable' => { 372 => '0.2' },
	'powersource' => { 372 => '0.1' },
	'poweruptime' => { 246 => 0xb6 },
	'preaf' => { 132 => '0.2' },
	'precaptureframes' => { 339 => 0x300 },
	'predictor' => { 125 => 0x13d },
	'preflashreturnstrength' => { 284 => 0x28a },
	'prefs' => { 138 => 0xdd, 407 => 'Prefs' },
	'prereadfastresetcount' => { 145 => 0x187e },
	'prereleaseburstlength' => { 256 => 0x712, 257 => 0x782, 330 => 0x287 },
	'preservedfilename' => { 559 => 'PreservedFileName' },
	'preservedspecimen' => { 124 => 'PreservedSpecimen' },
	'preservedspecimenmaterialsampleid' => { 124 => [\'PreservedSpecimen','PreservedSpecimenMaterialSampleID'] },
	'presettype' => { 528 => 'PresetType', 530 => 'PresetType' },
	'presetwhitebalance' => { 191 => 0x24, 500 => 0x8002 },
	'presetwhitebalanceadj' => { 500 => 0x8014 },
	'pressure' => { 125 => 0x9402, 535 => 'Pressure' },
	'previewapplicationname' => { 125 => 0xc716 },
	'previewapplicationversion' => { 125 => 0xc717 },
	'previewbutton' => { 313 => ['14.1','15.1'], 314 => '15.1', 316 => '15.1', 317 => '15.1', 322 => '29.1', 323 => '14.1', 326 => '15.1', 327 => '15.1' },
	'previewbuttonplusdials' => { 313 => ['14.2','15.2'], 314 => '15.2', 316 => '43.1', 317 => '43.1', 322 => '31.2', 326 => '43.1', 327 => '43.1' },
	'previewcolorspace' => { 125 => 0xc71a },
	'previewcropbottom' => { 406 => 0xef },
	'previewcropleft' => { 406 => 0xec },
	'previewcropright' => { 406 => 0xee },
	'previewcroptop' => { 406 => 0xed },
	'previewdate' => { 419 => 0x0 },
	'previewdatetime' => { 125 => 0xc71b },
	'previewimage' => { 119 => 0x2000, 120 => 'Exif-PreviewImage', 126 => 'PreviewImage', 128 => 0x4, 173 => 'data', 193 => 0x81, 339 => 0x280, 356 => 0x300, 413 => 'snal', 421 => 'mcvr', 463 => 0x2001 },
	'previewimageborders' => { 395 => 0x3e },
	'previewimageheight' => { 78 => 0x4, 149 => 0xfa58 },
	'previewimagelength' => { 78 => 0x2, 119 => 0x3, 125 => [0x117,0x202], 193 => 0x89, 268 => 0x202, 334 => 0x102, 339 => 0x1037, 395 => 0x3, 428 => 0x1e, 433 => 0x3, 439 => [0x1b,0x1d], 452 => 0x202 },
	'previewimagename' => { 173 => '1Name' },
	'previewimagesize' => { 119 => 0x2, 154 => 0x2, 173 => 'ImageSize', 395 => 0x2, 439 => [0x1c,0x1e], 463 => 0xb02c, 500 => 0x9012 },
	'previewimagestart' => { 78 => 0x5, 119 => 0x4, 125 => [0x111,0x201], 193 => 0x88, 268 => 0x201, 334 => 0x101, 339 => 0x1036, 395 => 0x4, 428 => 0x1c, 433 => 0x2, 439 => [0x1a,0x1c], 452 => 0x201 },
	'previewimagetype' => { 173 => '0Type' },
	'previewimagevalid' => { 334 => 0x100, 339 => 0x1035 },
	'previewimagewidth' => { 78 => 0x3, 149 => 0xfa57 },
	'previewquality' => { 78 => 0x1 },
	'previewsettingsdigest' => { 125 => 0xc719 },
	'previewsettingsname' => { 125 => 0xc718 },
	'primaryafpoint' => { 200 => 0x7, 201 => 0x44, 202 => 0x7, 203 => 0x38 },
	'primarychromaticities' => { 125 => 0x13f, 554 => 'PrimaryChromaticities' },
	'primaryftp' => { 516 => 'PrimaryFTP' },
	'primaryslot' => { 258 => 0x25, 276 => 0x2 },
	'printim' => { 125 => 0xc4a5 },
	'prioritysetinawb' => { 463 => 0x202b },
	'prioritysetupshutterrelease' => { 191 => 0x1d, 449 => 0x28 },
	'privatertkinfo' => { 519 => 'privateRTKInfo' },
	'processbordercolsleft' => { 145 => 0xc61 },
	'processbordercolsright' => { 145 => 0xc62 },
	'processborderrowsbottom' => { 145 => 0xc64 },
	'processborderrowstop' => { 145 => 0xc63 },
	'processingsoftware' => { 125 => 0xb },
	'processversion' => { 528 => 'ProcessVersion', 530 => 'ProcessVersion' },
	'producer' => { 186 => 'WM/Producer', 343 => 'Producer', 413 => "\xa9prd", 415 => 'producer', 421 => "\xa9prd", 544 => 'Producer' },
	'producerkeywords' => { 421 => "\xa9pdk" },
	'productcode' => { 548 => 'productCode' },
	'productid' => { 139 => 0x32, 413 => 'prID', 547 => 'productID' },
	'productidtype' => { 547 => 'productIDType' },
	'productinimage' => { 542 => 'ProductInImage' },
	'productinimagedescription' => { 542 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 542 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 542 => [\'ProductInImage','ProductInImageProductName'] },
	'productinimageproductid' => { 542 => [\'ProductInImage','ProductInImageProductId'] },
	'productioncode' => { 374 => 0x2 },
	'productorserviceconstraints' => { 344 => 'ProductOrServiceConstraints' },
	'productversion' => { 413 => 'VERS' },
	'profession' => { 548 => 'profession' },
	'profile' => { 504 => [\'Profiles','ProfilesProfile'] },
	'profilecalibrationsig' => { 125 => 0xc6f4 },
	'profilecameraindices' => { 504 => [\'Profiles','ProfilesProfileCameraIndices'] },
	'profilecopyright' => { 125 => 0xc6fe },
	'profiledynamicrange' => { 125 => 0xcd47 },
	'profileembedpolicy' => { 125 => 0xc6fd },
	'profilegaintablemap' => { 125 => 0xcd2d },
	'profilegaintablemap2' => { 125 => 0xcd40 },
	'profilegroupname' => { 125 => 0xcd48 },
	'profilehuesatmapdata1' => { 125 => 0xc6fa },
	'profilehuesatmapdata2' => { 125 => 0xc6fb },
	'profilehuesatmapdata3' => { 125 => 0xcd39 },
	'profilehuesatmapdims' => { 125 => 0xc6f9 },
	'profilehuesatmapencoding' => { 125 => 0xc7a3 },
	'profilelooktabledata' => { 125 => 0xc726 },
	'profilelooktabledims' => { 125 => 0xc725 },
	'profilelooktableencoding' => { 125 => 0xc7a4 },
	'profilename' => { 125 => 0xc6f8, 345 => 'iCCP-name' },
	'profiles' => { 504 => 'Profiles' },
	'profiletonecurve' => { 125 => 0xc6fc },
	'profiletype' => { 504 => [\'Profiles','ProfilesProfileType'] },
	'programiso' => { 358 => 0x3c },
	'programline' => { 375 => '1.1' },
	'programmode' => { 196 => 0x5 },
	'programshift' => { 246 => 0xd },
	'programversion' => { 138 => 0x46 },
	'prohibits' => { 526 => 'prohibits' },
	'projectiontype' => { 514 => 'ProjectionType', 515 => 'ProjectionType' },
	'projectname' => { 558 => 'projectName' },
	'projectref' => { 558 => 'projectRef' },
	'projectrefpath' => { 558 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 558 => [\'projectRef','projectRefType'] },
	'promotionurl' => { 186 => 'WM/PromotionURL' },
	'propertyreleaseid' => { 344 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 344 => 'PropertyReleaseStatus' },
	'provider' => { 186 => 'WM/Provider' },
	'province-state' => { 138 => 0x5f },
	'publicationdate' => { 548 => 'publicationDate' },
	'publicationdatea-platform' => { 548 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 548 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 548 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 548 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 548 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationevent' => { 542 => 'PublicationEvent' },
	'publicationeventdate' => { 542 => [\'PublicationEvent','PublicationEventDate'] },
	'publicationeventidentifier' => { 542 => [\'PublicationEvent','PublicationEventIdentifier'] },
	'publicationeventname' => { 542 => [\'PublicationEvent','PublicationEventName'] },
	'publicationname' => { 548 => 'publicationName' },
	'publisher' => { 186 => 'WM/Publisher', 413 => "\xa9pub", 415 => 'publisher', 531 => 'publisher' },
	'publishingfrequency' => { 548 => 'publishingFrequency' },
	'pulldown' => { 558 => 'pullDown' },
	'purchasedate' => { 413 => 'purd' },
	'purplehsl' => { 109 => 0x20916 },
	'pxshiftperiphedgenr' => { 500 => 0x9013 },
	'pxshiftperiphedgenrvalue' => { 500 => 0x9014 },
	'quality' => { 0 => 0x1, 37 => 0x3, 118 => 0x2, 119 => 0x3002, 133 => 0x1000, 147 => 0x9, 246 => 0x4, 295 => 0x3, 339 => 0x201, 353 => 0x300, 395 => 0x8, 402 => 0x2, 439 => 0x16, 449 => 0x56, 450 => 0x56, 451 => 0xb, 463 => [0x102,0x202e] },
	'quality2' => { 472 => 0x1170, 473 => 0x1174, 474 => 0x1150, 476 => 0x11a8, 477 => 0x1060, 478 => 0x258, 479 => 0x258, 480 => 0x247, 486 => 0x29, 487 => 0x25, 488 => 0x2a },
	'qualitybutton' => { 331 => 0x17d, 332 => 0x195 },
	'qualitybuttonplaybackmode' => { 331 => 0x1bf, 332 => 0x1d7 },
	'qualityhint' => { 1 => 0x1a },
	'qualitymode' => { 119 => 0x8 },
	'quantizationmethod' => { 140 => 0x78 },
	'quickadjust' => { 309 => 0x2a },
	'quickcontroldialinmeter' => { 90 => 0x703 },
	'quickfix' => { 306 => 0x416391c6 },
	'quickshot' => { 438 => 0x213 },
	'quiettime' => { 145 => 0x188a },
	'radialdistortioncoefficient1' => { 221 => 0x14 },
	'radialdistortioncoefficient2' => { 221 => 0x1c },
	'radialdistortioncoefficient3' => { 221 => 0x24 },
	'rads' => { 421 => 'rads' },
	'rangefinder' => { 318 => '4.1', 319 => '5.1', 320 => '5.1' },
	'rangemask' => { 528 => 'RangeMaskMapInfo', 530 => 'RangeMaskMapInfo' },
	'rangemaskmapinfo' => { 528 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'], 530 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'] },
	'rangemaskmapinfolabmax' => { 528 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'], 530 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'] },
	'rangemaskmapinfolabmin' => { 528 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'], 530 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'] },
	'rangemaskmapinfolumeq' => { 528 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'], 530 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'] },
	'rangemaskmapinforgbmax' => { 528 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'], 530 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'] },
	'rangemaskmapinforgbmin' => { 528 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'], 530 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'] },
	'rasterizedcaption' => { 138 => 0x7d },
	'rating' => { 109 => 0x10100, 125 => 0x4746, 133 => 0x1431, 406 => 0xdf, 413 => 'rtng', 421 => 'rtng', 463 => 0x2002, 522 => 'rating', 532 => 'rating', 542 => 'Rating', 548 => 'rating', 556 => 'Rating' },
	'ratingpercent' => { 125 => 0x4749, 185 => 'Rating', 413 => 'rate', 556 => 'RatingPercent' },
	'ratingregion' => { 542 => [\'Rating','RatingRatingRegion'] },
	'ratingregioncity' => { 542 => [\'Rating','RatingRatingRegionCity'] },
	'ratingregioncountrycode' => { 542 => [\'Rating','RatingRatingRegionCountryCode'] },
	'ratingregioncountryname' => { 542 => [\'Rating','RatingRatingRegionCountryName'] },
	'ratingregiongpsaltitude' => { 542 => [\'Rating','RatingRatingRegionGPSAltitude'] },
	'ratingregiongpsaltituderef' => { 542 => [\'Rating','RatingRatingRegionGPSAltitudeRef'] },
	'ratingregiongpslatitude' => { 542 => [\'Rating','RatingRatingRegionGPSLatitude'] },
	'ratingregiongpslongitude' => { 542 => [\'Rating','RatingRatingRegionGPSLongitude'] },
	'ratingregionidentifier' => { 542 => [\'Rating','RatingRatingRegionIdentifier'] },
	'ratingregionlocationid' => { 542 => [\'Rating','RatingRatingRegionLocationId'] },
	'ratingregionlocationname' => { 542 => [\'Rating','RatingRatingRegionLocationName'] },
	'ratingregionprovincestate' => { 542 => [\'Rating','RatingRatingRegionProvinceState'] },
	'ratingregionsublocation' => { 542 => [\'Rating','RatingRatingRegionSublocation'] },
	'ratingregionworldregion' => { 542 => [\'Rating','RatingRatingRegionWorldRegion'] },
	'ratingscalemaxvalue' => { 542 => [\'Rating','RatingRatingScaleMaxValue'] },
	'ratingscaleminvalue' => { 542 => [\'Rating','RatingRatingScaleMinValue'] },
	'ratingsourcelink' => { 542 => [\'Rating','RatingRatingSourceLink'] },
	'ratingvalue' => { 542 => [\'Rating','RatingRatingValue'] },
	'ratingvaluelogolink' => { 542 => [\'Rating','RatingRatingValueLogoLink'] },
	'rawandjpgrecording' => { 88 => 0x8, 193 => 0x109, 375 => 0xd },
	'rawbrightnessadj' => { 109 => 0x20001, 114 => 0x38 },
	'rawburstimagecount' => { 80 => 0x2 },
	'rawburstimagenum' => { 80 => 0x1 },
	'rawcoloradj' => { 114 => 0x2e },
	'rawcropbottom' => { 406 => 0xd4 },
	'rawcropleft' => { 406 => 0xd1 },
	'rawcropright' => { 406 => 0xd3 },
	'rawcroptop' => { 406 => 0xd2 },
	'rawcustomsaturation' => { 114 => 0x30 },
	'rawcustomtone' => { 114 => 0x34 },
	'rawdata' => { 436 => 0xa048 },
	'rawdatabyteorder' => { 436 => 0x40 },
	'rawdatacfapattern' => { 436 => 0x50 },
	'rawdatauniqueid' => { 125 => 0xc65d },
	'rawdepth' => { 195 => 0x10 },
	'rawdevartfilter' => { 341 => 0x121 },
	'rawdevautogradation' => { 341 => 0x119 },
	'rawdevcolorspace' => { 340 => 0x108, 341 => 0x109 },
	'rawdevcontrastvalue' => { 340 => 0x106, 341 => 0x105 },
	'rawdeveditstatus' => { 340 => 0x10b },
	'rawdevelopingsoftware' => { 125 => 0xa43a, 535 => 'RAWDevelopingSoftware' },
	'rawdevelopmentprocess' => { 395 => 0x62 },
	'rawdevengine' => { 340 => 0x109, 341 => 0x10b },
	'rawdevexposurebiasvalue' => { 340 => 0x100, 341 => 0x100 },
	'rawdevgradation' => { 341 => 0x112 },
	'rawdevgraypoint' => { 340 => 0x103, 341 => 0x104 },
	'rawdevmemorycoloremphasis' => { 340 => 0x105, 341 => 0x108 },
	'rawdevnoisereduction' => { 340 => 0x10a, 341 => 0x10a },
	'rawdevpicturemode' => { 341 => 0x10c },
	'rawdevpm_bwfilter' => { 341 => 0x110 },
	'rawdevpmcontrast' => { 341 => 0x10e },
	'rawdevpmnoisefilter' => { 341 => 0x120 },
	'rawdevpmpicturetone' => { 341 => 0x111 },
	'rawdevpmsaturation' => { 341 => 0x10d },
	'rawdevpmsharpness' => { 341 => 0x10f },
	'rawdevsaturation3' => { 341 => 0x113 },
	'rawdevsaturationemphasis' => { 340 => 0x104, 341 => 0x107 },
	'rawdevsettings' => { 340 => 0x10c },
	'rawdevsharpnessvalue' => { 340 => 0x107, 341 => 0x106 },
	'rawdevversion' => { 340 => 0x0, 341 => 0x0 },
	'rawdevwbfineadjustment' => { 340 => 0x102, 341 => 0x103 },
	'rawdevwhitebalance' => { 341 => 0x101 },
	'rawdevwhitebalancevalue' => { 340 => 0x101, 341 => 0x102 },
	'rawfile' => { 125 => 0xfe4c },
	'rawfilename' => { 528 => 'RawFileName', 530 => 'RawFileName' },
	'rawfiletype' => { 463 => 0x2029 },
	'rawformat' => { 363 => 0x2d, 404 => 0x10e },
	'rawimagecenter' => { 246 => 0x99 },
	'rawimagedigest' => { 125 => 0xc71c },
	'rawimagesize' => { 395 => 0x39 },
	'rawinfoversion' => { 342 => 0x0 },
	'rawjpgheight' => { 105 => 0x4 },
	'rawjpgquality' => { 61 => 0x6, 105 => 0x1 },
	'rawjpgsize' => { 61 => 0x7, 105 => 0x2 },
	'rawjpgwidth' => { 105 => 0x3 },
	'rawmeasuredrggb' => { 47 => 0x26a, 49 => 0x280, 51 => 0x194, 52 => [0x1ad,0x26b] },
	'rawrppused' => { 522 => 'rawrppused' },
	'rawtopreviewgain' => { 125 => 0xc7a8 },
	'readouttypeactual' => { 145 => 0x1903 },
	'readouttyperequested' => { 145 => 0x1902 },
	'reardisplay' => { 313 => '12.3', 314 => '6.2' },
	'recdevice' => { 542 => 'RecDevice' },
	'recdeviceattlensdescription' => { 542 => [\'RecDevice','RecDeviceAttLensDescription'] },
	'recdevicemanufacturer' => { 542 => [\'RecDevice','RecDeviceManufacturer'] },
	'recdevicemodelname' => { 542 => [\'RecDevice','RecDeviceModelName'] },
	'recdeviceownersdeviceid' => { 542 => [\'RecDevice','RecDeviceOwnersDeviceId'] },
	'recdeviceserialnumber' => { 542 => [\'RecDevice','RecDeviceSerialNumber'] },
	'recipeendingpage' => { 550 => 'recipeEndingPage' },
	'recipepagerange' => { 550 => 'recipePageRange' },
	'recipesource' => { 550 => 'recipeSource' },
	'recipestartingpage' => { 550 => 'recipeStartingPage' },
	'recipetitle' => { 550 => 'recipeTitle' },
	'recognizedface1age' => { 351 => 0x20 },
	'recognizedface1name' => { 351 => 0x4 },
	'recognizedface1position' => { 351 => 0x18 },
	'recognizedface2age' => { 351 => 0x50 },
	'recognizedface2name' => { 351 => 0x34 },
	'recognizedface2position' => { 351 => 0x48 },
	'recognizedface3age' => { 351 => 0x80 },
	'recognizedface3name' => { 351 => 0x64 },
	'recognizedface3position' => { 351 => 0x78 },
	'recognizedfaceflags' => { 358 => 0x63 },
	'recommendedexposureindex' => { 125 => 0x8832, 535 => 'RecommendedExposureIndex' },
	'record' => { 124 => 'Record' },
	'recordbasisofrecord' => { 124 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 124 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 124 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 124 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 124 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 124 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 191 => 0x4d },
	'recorddynamicproperties' => { 124 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 103 => 0x1804 },
	'recordinformationwithheld' => { 124 => [\'Record','RecordInformationWithheld'] },
	'recordingcopyright' => { 421 => "\xa9phg" },
	'recordingformat' => { 429 => 0x1000 },
	'recordingmode' => { 118 => 0x1, 402 => 0x1 },
	'recordinstitutioncode' => { 124 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 124 => [\'Record','RecordInstitutionID'] },
	'recordlabelname' => { 421 => "\xa9lab" },
	'recordlabelurl' => { 421 => "\xa9lal" },
	'recordlocationdata' => { 255 => 0x660, 256 => 0x690, 257 => 0x6f8 },
	'recordmode' => { 37 => 0x9, 119 => 0x3000 },
	'recordownerinstitutioncode' => { 124 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 438 => 0x217 },
	'redbalance' => { 339 => 0x1017, 363 => 0x11, 395 => 0x1c },
	'redcurvelimits' => { 114 => 0x18a },
	'redcurvepoints' => { 113 => 0x2d, 114 => 0x160 },
	'redeyecorrection' => { 310 => 0x0 },
	'redeyeinfo' => { 528 => 'RedEyeInfo', 530 => 'RedEyeInfo' },
	'redeyereduction' => { 191 => 0x41, 449 => 0x6a, 451 => 0x28 },
	'redeyeremoval' => { 358 => 0xb9 },
	'redhsl' => { 109 => 0x20910 },
	'redhue' => { 528 => 'RedHue', 530 => 'RedHue' },
	'redsaturation' => { 528 => 'RedSaturation', 530 => 'RedSaturation' },
	'reductionmatrix1' => { 125 => 0xc625 },
	'reductionmatrix2' => { 125 => 0xc626 },
	'reductionmatrix3' => { 125 => 0xcd3a },
	'reelname' => { 125 => 0xc789, 421 => 'reel' },
	'reference1' => { 540 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 540 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 540 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 540 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 540 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 540 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 125 => 0x214, 554 => 'ReferenceBlackWhite' },
	'referencedate' => { 138 => 0x2f },
	'referencenumber' => { 138 => 0x32 },
	'references' => { 164 => 'References' },
	'referenceservice' => { 138 => 0x2d },
	'regionappliedtodimensions' => { 179 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 179 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 179 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 179 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 179 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 179 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 179 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 179 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 179 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 179 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 179 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 179 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 344 => 'RegionConstraints' },
	'regiondescription' => { 179 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 179 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 179 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 179 => 'Regions' },
	'regioninfoacdsee' => { 501 => 'Regions' },
	'regioninfodateregionsvalid' => { 182 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 182 => 'RegionInfo' },
	'regioninforegions' => { 182 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 179 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 179 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 182 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 182 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 182 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 182 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 182 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 179 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 179 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 179 => [\'Regions','RegionsRegionListType'] },
	'registryentryrole' => { 542 => [\'RegistryId','RegistryIdRegEntryRole'] },
	'registryid' => { 542 => 'RegistryId' },
	'registryitemid' => { 542 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 542 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 162 => 'data' },
	'relatedaudiofilename' => { 162 => '1Name' },
	'relatedaudiofiletype' => { 162 => '0Type' },
	'relatedimagefileformat' => { 125 => 0x1000 },
	'relatedimageheight' => { 125 => 0x1002 },
	'relatedimagewidth' => { 125 => 0x1001 },
	'relatedresourceid' => { 124 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 125 => 0xa004, 534 => 'RelatedSoundFile' },
	'relatedvideofile' => { 176 => 'data' },
	'relatedvideofilename' => { 176 => '1Name' },
	'relatedvideofiletype' => { 176 => '0Type' },
	'relation' => { 531 => 'relation' },
	'relationshipaccordingto' => { 124 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 124 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 124 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipofresourceid' => { 124 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResourceID'] },
	'relationshipremarks' => { 124 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativealtitude' => { 122 => 'RelativeAltitude' },
	'relativepeakaudiofilepath' => { 558 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 558 => 'relativeTimestamp' },
	'relativetimestampscale' => { 558 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 558 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 313 => '17.8', 314 => '18.5', 316 => '18.4', 317 => '18.4', 322 => '33.8', 323 => '17.6', 326 => '18.5', 327 => '18.4' },
	'releasedate' => { 138 => 0x1e, 413 => 'rldt', 522 => 'ReleaseDate', 558 => 'releaseDate' },
	'releasemode' => { 119 => 0x3001, 251 => 0x5c, 286 => 0x184d, 463 => 0xb049 },
	'releasemode2' => { 472 => 0x112c, 473 => [0x112c,0x8], 474 => [0x1108,0x8], 475 => [0x1184,0x8], 476 => [0x1160,0x8], 477 => [0x4,0x1018], 478 => [0x4,0x210], 479 => [0x4,0x210], 480 => [0x4,0x208], 482 => [0x67,0x3f], 483 => [0x6b,0x6d,0x73,0x4b], 484 => [0x6b,0x4b], 485 => 0x1f, 486 => 0x10, 487 => 0x10, 488 => 0x9, 495 => 0x34 },
	'releasemode3' => { 472 => 0x1128, 473 => 0x1128, 474 => 0x1104, 475 => 0x1180, 476 => 0x115c, 477 => 0x1014, 478 => 0x20c, 479 => 0x20c, 480 => 0x204 },
	'releaseready' => { 542 => 'ReleaseReady' },
	'releasesetting' => { 103 => 0x1016 },
	'releasetime' => { 138 => 0x23, 522 => 'ReleaseTime' },
	'remoteonduration' => { 315 => '3.4', 318 => '17.2', 319 => '18.2', 320 => '18.2', 321 => '18.2', 323 => '18.2', 324 => '4.3', 328 => '19.2' },
	'renditionclass' => { 559 => 'RenditionClass' },
	'renditionof' => { 559 => 'RenditionOf' },
	'renditionofalternatepaths' => { 559 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 559 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 559 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 559 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 559 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 559 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 559 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 559 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 559 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 559 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 559 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 559 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 559 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 559 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 559 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 559 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 559 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 559 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 559 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 559 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 559 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 559 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 559 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 559 => 'RenditionParams' },
	'repeatingflashcount' => { 224 => 0xd, 225 => 0xe, 226 => 0xe, 227 => 0xe, 228 => 0xe, 229 => 0xe, 322 => '17.2', 323 => '24.2', 324 => '9.2', 325 => '24.2', 328 => '25.2' },
	'repeatingflashcountbuilt-in' => { 293 => 0x4db },
	'repeatingflashcountexternal' => { 293 => 0x4c3 },
	'repeatingflashoutput' => { 322 => '17.1', 323 => '24.1', 324 => '9.1', 325 => '24.1', 328 => '25.1' },
	'repeatingflashoutputexternal' => { 293 => 0x4c0 },
	'repeatingflashrate' => { 224 => 0xc, 225 => 0xd, 226 => 0xd, 227 => 0xd, 228 => 0xd, 229 => 0xd, 322 => '18.1', 323 => '25.1', 324 => '10.1', 325 => '25.1', 328 => '26.1' },
	'repeatingflashratebuilt-in' => { 293 => 0x4da },
	'repeatingflashrateexternal' => { 293 => 0x4c2 },
	'requirements' => { 421 => "\xa9req" },
	'requires' => { 526 => 'requires' },
	'resampleparams' => { 558 => 'resampleParams' },
	'resampleparamsquality' => { 558 => [\'resampleParams','resampleParamsQuality'] },
	'resamplingkerneldenominators050' => { 145 => 0xe50 },
	'resamplingkerneldenominators067' => { 145 => 0xe4f },
	'resamplingkerneldenominators100' => { 145 => 0xe51 },
	'resaved' => { 438 => 0x21e },
	'resetblacksegrows' => { 145 => 0x181a },
	'resolution' => { 169 => 'Resolution' },
	'resolutionmode' => { 439 => [0x87,0x4] },
	'resolutionunit' => { 125 => 0x128, 141 => 0x2, 554 => 'ResolutionUnit' },
	'resourceid' => { 124 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 124 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 124 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 90 => 0x612 },
	'restrictions' => { 551 => 'restrictions' },
	'retouchareafeather' => { 528 => [\'RetouchAreas','RetouchAreasFeather'], 530 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 528 => [\'RetouchAreas','RetouchAreasMasksAlpha'], 530 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 528 => [\'RetouchAreas','RetouchAreasMasksAngle'], 530 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 528 => [\'RetouchAreas','RetouchAreasMasksBottom'], 530 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 528 => [\'RetouchAreas','RetouchAreasMasksCenterValue'], 530 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 528 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'], 530 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 528 => [\'RetouchAreas','RetouchAreasMasksDabs'], 530 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 528 => [\'RetouchAreas','RetouchAreasMasksFeather'], 530 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 528 => [\'RetouchAreas','RetouchAreasMasksFlipped'], 530 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 528 => [\'RetouchAreas','RetouchAreasMasksFlow'], 530 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 528 => [\'RetouchAreas','RetouchAreasMasksFullX'], 530 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 528 => [\'RetouchAreas','RetouchAreasMasksFullY'], 530 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskinputdigest' => { 528 => [\'RetouchAreas','RetouchAreasMasksInputDigest'], 530 => [\'RetouchAreas','RetouchAreasMasksInputDigest'] },
	'retouchareamaskleft' => { 528 => [\'RetouchAreas','RetouchAreasMasksLeft'], 530 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmaskactive' => { 528 => [\'RetouchAreas','RetouchAreasMasksMaskActive'], 530 => [\'RetouchAreas','RetouchAreasMasksMaskActive'] },
	'retouchareamaskmaskblendmode' => { 528 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'], 530 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'] },
	'retouchareamaskmaskdigest' => { 528 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'], 530 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'] },
	'retouchareamaskmaskinverted' => { 528 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'], 530 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'] },
	'retouchareamaskmaskname' => { 528 => [\'RetouchAreas','RetouchAreasMasksMaskName'], 530 => [\'RetouchAreas','RetouchAreasMasksMaskName'] },
	'retouchareamaskmasks' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasks'], 530 => [\'RetouchAreas','RetouchAreasMasksMasks'] },
	'retouchareamaskmasksalpha' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'] },
	'retouchareamaskmasksangle' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'] },
	'retouchareamaskmasksbottom' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'] },
	'retouchareamaskmaskscentervalue' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'] },
	'retouchareamaskmaskscenterweight' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'] },
	'retouchareamaskmasksdabs' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'] },
	'retouchareamaskmasksfeather' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'] },
	'retouchareamaskmasksflipped' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'] },
	'retouchareamaskmasksflow' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'] },
	'retouchareamaskmasksfullx' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'] },
	'retouchareamaskmasksfully' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'] },
	'retouchareamaskmasksinputdigest' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'] },
	'retouchareamaskmasksleft' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'] },
	'retouchareamaskmasksmaskactive' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'] },
	'retouchareamaskmasksmaskblendmode' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'] },
	'retouchareamaskmasksmaskdigest' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'] },
	'retouchareamaskmasksmaskinverted' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'] },
	'retouchareamaskmasksmaskname' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'] },
	'retouchareamaskmasksmasksubtype' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'] },
	'retouchareamaskmasksmasksyncid' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'] },
	'retouchareamaskmasksmaskversion' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'] },
	'retouchareamaskmasksmidpoint' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'] },
	'retouchareamaskmasksorigin' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'] },
	'retouchareamaskmasksperimetervalue' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'] },
	'retouchareamaskmasksradius' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'] },
	'retouchareamaskmasksreferencepoint' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'] },
	'retouchareamaskmasksright' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksRight'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksRight'] },
	'retouchareamaskmasksroundness' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'] },
	'retouchareamaskmaskssizex' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'] },
	'retouchareamaskmaskssizey' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'] },
	'retouchareamaskmaskstop' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksTop'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksTop'] },
	'retouchareamaskmasksubtype' => { 528 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'], 530 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'] },
	'retouchareamaskmasksvalue' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'] },
	'retouchareamaskmasksversion' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'] },
	'retouchareamaskmaskswhat' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'] },
	'retouchareamaskmaskswholeimagearea' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'] },
	'retouchareamaskmasksx' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksX'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksX'] },
	'retouchareamaskmasksy' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksY'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksY'] },
	'retouchareamaskmasksyncid' => { 528 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'], 530 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'] },
	'retouchareamaskmaskszerox' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'] },
	'retouchareamaskmaskszeroy' => { 528 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'], 530 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'] },
	'retouchareamaskmaskversion' => { 528 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'], 530 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'] },
	'retouchareamaskmidpoint' => { 528 => [\'RetouchAreas','RetouchAreasMasksMidpoint'], 530 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskorigin' => { 528 => [\'RetouchAreas','RetouchAreasMasksOrigin'], 530 => [\'RetouchAreas','RetouchAreasMasksOrigin'] },
	'retouchareamaskperimetervalue' => { 528 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'], 530 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 528 => [\'RetouchAreas','RetouchAreasMasksRadius'], 530 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskrange' => { 528 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'], 530 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'] },
	'retouchareamaskrangeareamodels' => { 528 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'], 530 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'] },
	'retouchareamaskrangeareamodelscolorsampleinfo' => { 528 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 530 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'retouchareamaskrangeareamodelscomponents' => { 528 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'], 530 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'retouchareamaskrangecoloramount' => { 528 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'], 530 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'] },
	'retouchareamaskrangedepthfeather' => { 528 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'], 530 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'] },
	'retouchareamaskrangedepthmax' => { 528 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'], 530 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'] },
	'retouchareamaskrangedepthmin' => { 528 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'], 530 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'] },
	'retouchareamaskrangeinvert' => { 528 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'], 530 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'] },
	'retouchareamaskrangelumfeather' => { 528 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'], 530 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'] },
	'retouchareamaskrangeluminancedepthsampleinfo' => { 528 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 530 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'retouchareamaskrangelummax' => { 528 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'], 530 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'] },
	'retouchareamaskrangelummin' => { 528 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'], 530 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'] },
	'retouchareamaskrangelumrange' => { 528 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'], 530 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'] },
	'retouchareamaskrangesampletype' => { 528 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'], 530 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'] },
	'retouchareamaskrangetype' => { 528 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'], 530 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'] },
	'retouchareamaskrangeversion' => { 528 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'], 530 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'] },
	'retouchareamaskreferencepoint' => { 528 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'], 530 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'] },
	'retouchareamaskright' => { 528 => [\'RetouchAreas','RetouchAreasMasksRight'], 530 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 528 => [\'RetouchAreas','RetouchAreasMasksRoundness'], 530 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 528 => [\'RetouchAreas','RetouchAreasMasks'], 530 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 528 => [\'RetouchAreas','RetouchAreasMasksSizeX'], 530 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 528 => [\'RetouchAreas','RetouchAreasMasksSizeY'], 530 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 528 => [\'RetouchAreas','RetouchAreasMasksTop'], 530 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 528 => [\'RetouchAreas','RetouchAreasMasksMaskValue'], 530 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 528 => [\'RetouchAreas','RetouchAreasMasksVersion'], 530 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 528 => [\'RetouchAreas','RetouchAreasMasksWhat'], 530 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskwholeimagearea' => { 528 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'], 530 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'] },
	'retouchareamaskx' => { 528 => [\'RetouchAreas','RetouchAreasMasksX'], 530 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 528 => [\'RetouchAreas','RetouchAreasMasksY'], 530 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 528 => [\'RetouchAreas','RetouchAreasMasksZeroX'], 530 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 528 => [\'RetouchAreas','RetouchAreasMasksZeroY'], 530 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 528 => [\'RetouchAreas','RetouchAreasMethod'], 530 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 528 => [\'RetouchAreas','RetouchAreasOffsetY'], 530 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 528 => [\'RetouchAreas','RetouchAreasOpacity'], 530 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 528 => 'RetouchAreas', 530 => 'RetouchAreas' },
	'retouchareaseed' => { 528 => [\'RetouchAreas','RetouchAreasSeed'], 530 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 528 => [\'RetouchAreas','RetouchAreasSourceState'], 530 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 528 => [\'RetouchAreas','RetouchAreasSourceX'], 530 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 528 => [\'RetouchAreas','RetouchAreasSpotType'], 530 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 246 => 0x9e },
	'retouchinfo' => { 528 => 'RetouchInfo', 530 => 'RetouchInfo' },
	'retouchnefprocessing' => { 270 => 0x5 },
	'retractlensonpoweroff' => { 90 => 0x814 },
	'reuse' => { 344 => 'Reuse' },
	'reuseallowed' => { 561 => 'ReuseAllowed' },
	'reuseprohibited' => { 551 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 320 => '5.2' },
	'reversefocusring' => { 330 => 0x163, 331 => 0x163, 332 => 0x17b },
	'reverseindicators' => { 313 => '12.1', 314 => '6.1', 316 => '6.1', 317 => '6.1', 318 => '4.3', 319 => '5.2', 320 => '5.4', 322 => '33.5', 323 => '5.1', 326 => '6.1', 327 => '6.1', 328 => '6.2', 329 => 0xc5, 330 => 0xc1, 331 => 0xc1, 332 => 0xc1 },
	'reverseshutterspeedaperture' => { 320 => '5.3' },
	'revision' => { 532 => 'revision' },
	'rflensmffocusringsensitivity' => { 90 => 0x714 },
	'rflenstype' => { 61 => 0x3d },
	'rgbcurvelimits' => { 114 => 0x238 },
	'rgbcurvepoints' => { 113 => 0x7, 114 => 0x20e },
	'rgbtables' => { 125 => 0xcd3f },
	'richtextcomment' => { 537 => 'RichTextComment' },
	'ricohdate' => { 428 => 0x6 },
	'ricohimageheight' => { 428 => 0x2 },
	'ricohimagewidth' => { 428 => 0x0 },
	'rightalbedo' => { 518 => 'RightAlbedo' },
	'rightascension' => { 172 => 'RightAscension' },
	'rights' => { 531 => 'rights' },
	'rightsagent' => { 551 => 'rightsAgent' },
	'rightsowner' => { 551 => 'rightsOwner' },
	'roll' => { 121 => 0x8, 421 => ['roll',"\xa9frl"] },
	'rollangle' => { 66 => 0x4, 133 => 0x144d, 262 => 0x0, 334 => 0x903, 348 => 'RollAngle', 358 => 0x90, 393 => 0x1, 394 => 0x3, 434 => 0x2 },
	'romoperationmode' => { 103 => 0x80d },
	'rotation' => { 31 => 0x17, 32 => 0x18, 102 => 0x3, 109 => 0x10002, 114 => 0x26e, 120 => 'QuickTime-Rotation', 129 => 0x4, 172 => 'Rotation', 189 => [0x65,0x50], 190 => 0x46, 191 => 0x5a, 194 => 0x10, 271 => 0x1a, 286 => 0x3693, 292 => '590.1', 306 => 0x76a43207, 358 => 0x30, 375 => '17.2', 406 => 0xd8, 414 => 'irot', 449 => 0x3f, 450 => 0x3f, 460 => 0x10 },
	'routedto' => { 536 => 'RoutedTo' },
	'routing' => { 411 => 'Routing' },
	'routingdestinations' => { 516 => 'RoutingDestinations' },
	'routingexclusions' => { 516 => 'RoutingExclusions' },
	'routingnotes' => { 536 => 'RoutingNotes' },
	'rowsperstrip' => { 125 => 0x116 },
	'rpp' => { 522 => 'rpp' },
	'rtkflag' => { 122 => 'RtkFlag' },
	'rtkstdhgt' => { 122 => 'RtkStdHgt' },
	'rtkstdlat' => { 122 => 'RtkStdLat' },
	'rtkstdlon' => { 122 => 'RtkStdLon' },
	'safetyshift' => { 90 => 0x108 },
	'safetyshiftinavortv' => { 88 => 0x10, 89 => 0x10, 91 => 0xf, 92 => 0x10, 95 => 0x10 },
	'sameexposurefornewaperture' => { 90 => 0x112 },
	'samplebits' => { 162 => 'SampleBits' },
	'samplepagerange' => { 548 => 'samplePageRange' },
	'samplerate' => { 162 => 'SampleRate' },
	'samplesperpixel' => { 125 => 0x115, 363 => 0x8, 554 => 'SamplesPerPixel' },
	'samplestructure' => { 140 => 0x5a },
	'samsungmodelid' => { 436 => 0x3 },
	'sanyoquality' => { 438 => 0x201 },
	'sanyothumbnail' => { 438 => 0x100 },
	'saturation' => { 10 => 0x6e, 12 => 0x76, 37 => 0xe, 55 => 0x1, 68 => 0x7, 118 => 0xd, 119 => [0x3013,0x1f], 125 => [0xa409,0xfe55], 133 => 0x1003, 163 => 'Saturation', 188 => 0x1f, 189 => 0x32, 190 => 0x28, 191 => 0x1a, 196 => 0x1, 246 => 0xaa, 264 => 0x35, 265 => 0x3b, 266 => 0x43, 358 => 0x40, 360 => 0x300d, 395 => 0x1f, 402 => 0xd, 423 => 0x27, 425 => 0x58, 428 => 0x28, 429 => 0x1013, 439 => 0x10, 449 => 0x1e, 450 => 0x1b, 463 => 0x2005, 528 => 'Saturation', 530 => 'Saturation', 534 => 'Saturation' },
	'saturationadj' => { 109 => 0x20901, 114 => 0x116, 246 => 0x94, 305 => 0x1, 309 => 0x2e, 500 => 0x8016 },
	'saturationadjustmentaqua' => { 528 => 'SaturationAdjustmentAqua', 530 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 528 => 'SaturationAdjustmentBlue', 530 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 528 => 'SaturationAdjustmentGreen', 530 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 528 => 'SaturationAdjustmentMagenta', 530 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 528 => 'SaturationAdjustmentOrange', 530 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 528 => 'SaturationAdjustmentPurple', 530 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 528 => 'SaturationAdjustmentRed', 530 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 528 => 'SaturationAdjustmentYellow', 530 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 76 => 0x98 },
	'saturationfaithful' => { 19 => 0xfe, 75 => 0x68, 76 => 0x68 },
	'saturationlandscape' => { 19 => 0xfc, 75 => 0x38, 76 => 0x38 },
	'saturationmonochrome' => { 75 => 0x80, 76 => 0x80 },
	'saturationneutral' => { 19 => 0xfd, 75 => 0x50, 76 => 0x50 },
	'saturationportrait' => { 19 => 0xfb, 75 => 0x20, 76 => 0x20 },
	'saturationsetting' => { 342 => 0x1010, 451 => 0x11, 468 => 0x9 },
	'saturationstandard' => { 19 => 0xfa, 75 => 0x8, 76 => 0x8 },
	'saturationuserdef1' => { 19 => 0x100, 75 => 0x98, 76 => 0xb0 },
	'saturationuserdef2' => { 19 => 0x101, 75 => 0xb0, 76 => 0xc8 },
	'saturationuserdef3' => { 19 => 0x102, 75 => 0xc8, 76 => 0xe0 },
	'savefocusposition' => { 250 => 0x9b0 },
	'saveid' => { 559 => 'SaveID' },
	'sbaanalysiscomplete' => { 145 => 0xc35 },
	'sbablack' => { 145 => 0xc25 },
	'sbagmoffset' => { 145 => 0xc4a },
	'sbagray' => { 145 => 0xc26 },
	'sbagreenmagentabal' => { 145 => 0xc33 },
	'sbahighgray' => { 145 => 0xc46 },
	'sbailloffset' => { 145 => 0xc49 },
	'sbailluminantbal' => { 145 => 0xc34 },
	'sbalowgray' => { 145 => 0xc47 },
	'sbaneutralbal' => { 145 => 0xc32 },
	'sbawhite' => { 145 => 0xc27 },
	'scaletype' => { 558 => 'scaleType' },
	'scalingfactorheight' => { 348 => 'ScalingFactorHeight' },
	'scanimageenhancer' => { 272 => 0x60 },
	'scanningdirection' => { 140 => 0x64 },
	'scene' => { 421 => 'scen', 541 => 'Scene', 558 => 'scene' },
	'scenearea' => { 337 => 0x211, 339 => 0x1031 },
	'sceneassist' => { 246 => 0x9c },
	'scenecapturetype' => { 125 => 0xa406, 534 => 'SceneCaptureType' },
	'scenedetect' => { 337 => 0x210, 339 => 0x1030 },
	'scenedetectdata' => { 337 => 0x212, 339 => 0x1033 },
	'sceneflags' => { 1 => 0x25 },
	'scenemode' => { 149 => 0xfa02, 193 => 0x100, 246 => 0x8f, 334 => 0x509, 339 => 0x403, 358 => 0x8001, 367 => 0xf, 463 => 0xb023 },
	'scenemodeused' => { 151 => [0x6002,0xf002] },
	'scenerecognition' => { 133 => 0x1425 },
	'scenereferred' => { 538 => 'scene_referred' },
	'sceneselect' => { 438 => 0x21f },
	'scenetype' => { 125 => 0xa301, 534 => 'SceneType' },
	'screentips' => { 313 => '12.7', 314 => '5.3', 322 => '13.1', 323 => '4.4', 326 => '5.4', 328 => '5.1' },
	'scriptversion' => { 145 => 0x1770 },
	'sdrblend' => { 528 => 'SDRBlend', 530 => 'SDRBlend' },
	'sdrbrightness' => { 528 => 'SDRBrightness', 530 => 'SDRBrightness' },
	'sdrcontrast' => { 528 => 'SDRContrast', 530 => 'SDRContrast' },
	'sdrhighlights' => { 528 => 'SDRHighlights', 530 => 'SDRHighlights' },
	'sdrshadows' => { 528 => 'SDRShadows', 530 => 'SDRShadows' },
	'sdrwhites' => { 528 => 'SDRWhites', 530 => 'SDRWhites' },
	'seal' => { 125 => 0xcea1 },
	'season' => { 542 => 'Season', 547 => 'season' },
	'seasonidentifier' => { 542 => [\'Season','SeasonIdentifier'] },
	'seasonname' => { 542 => [\'Season','SeasonName'] },
	'seasonnumber' => { 542 => [\'Season','SeasonNumber'] },
	'secondaryftp' => { 516 => 'SecondaryFTP' },
	'secondaryslotfunction' => { 250 => 0x35a, 252 => 0x240, 255 => 0x22c, 256 => 0x240, 257 => 0x240, 275 => 0x13c, 286 => 0x1d0 },
	'section' => { 548 => 'section' },
	'securityclassification' => { 125 => 0x9212 },
	'selectableafpoint' => { 90 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 90 => 0x512 },
	'selfdata' => { 122 => 'SelfData' },
	'selftimer' => { 37 => 0x2, 358 => 0x2e, 438 => 0x214, 472 => 0x1134, 473 => 0x1134, 474 => 0x1110, 475 => 0x118c, 476 => 0x1168, 477 => 0x1020, 478 => 0x218, 479 => 0x218, 480 => 0x210 },
	'selftimer2' => { 82 => 0x1d },
	'selftimerinterval' => { 323 => '19.2' },
	'selftimermode' => { 125 => 0x882b },
	'selftimershotcount' => { 314 => '20.2', 316 => '20.3', 317 => '20.3', 318 => '18.2', 319 => '19.2', 320 => '19.2', 321 => '19.3', 323 => '19.3', 326 => '20.3', 327 => '20.3', 328 => '20.2', 329 => 0x31, 330 => 0x2d, 331 => 0x2d, 332 => 0x2d },
	'selftimershotinterval' => { 314 => '20.3', 316 => '20.2', 317 => '20.2', 321 => '19.2', 326 => '20.2', 327 => '20.2', 329 => 0x35, 330 => 0x31, 331 => 0x31, 332 => 0x31 },
	'selftimertime' => { 103 => 0x1806, 191 => 0x1f, 313 => '18.1', 314 => '20.1', 315 => '3.3', 316 => '20.1', 317 => '20.1', 318 => '18.1', 319 => '19.1', 320 => '19.1', 321 => '19.1', 322 => '7.2', 323 => '19.1', 324 => '3.3', 326 => '20.1', 327 => '20.1', 328 => '20.1', 329 => 0x2d, 330 => 0x2b, 331 => 0x2b, 332 => 0x2b },
	'sellingagency' => { 548 => 'sellingAgency' },
	'semanticstyle' => { 1 => 0x40 },
	'semanticstylepreset' => { 1 => 0x42 },
	'semanticstylerenderingver' => { 1 => 0x41 },
	'seminfo' => { 125 => 0x8546 },
	'sensingmethod' => { 125 => 0xa217, 534 => 'SensingMethod' },
	'sensitivityadjust' => { 395 => 0x40 },
	'sensitivitysteps' => { 375 => ['14.3','17.4'], 377 => 0x1 },
	'sensitivitytype' => { 125 => 0x8830, 535 => 'SensitivityType' },
	'sensor' => { 198 => 0x665e },
	'sensorarea' => { 339 => 0x400 },
	'sensorareas' => { 436 => 0xa010 },
	'sensorbitdepth' => { 360 => 0x312d },
	'sensorbluelevel' => { 79 => 0x5 },
	'sensorcalibration' => { 338 => 0x805 },
	'sensorcleaning' => { 96 => 0xd },
	'sensorfullheight' => { 144 => 0xf904 },
	'sensorfullwidth' => { 144 => 0xf903 },
	'sensorheight' => { 144 => 0xf901, 149 => 0xfa21, 195 => 0x8, 360 => 0x312c, 404 => 0x109, 429 => 0x1602 },
	'sensorimageheight' => { 145 => 0x3ee },
	'sensorimagewidth' => { 145 => 0x3ed },
	'sensorleftborder' => { 145 => 0x3eb },
	'sensorleftmargin' => { 404 => 0x10a },
	'sensorpixelsize' => { 246 => 0x9a },
	'sensorredlevel' => { 79 => 0x4 },
	'sensorserialnumber' => { 145 => 0x9ce },
	'sensorshield' => { 253 => 0x76b, 254 => 0x77b, 255 => 0x66d, 256 => 0x69d, 257 => 0x705 },
	'sensorsize' => { 163 => 'SensorSize', 395 => 0x35 },
	'sensortemperature' => { 337 => 0x1500, 339 => 0x1007, 400 => [0xc,0x2a], 404 => 0x210, 439 => [0x39,0x55] },
	'sensortemperature2' => { 400 => 0xe, 404 => 0x211 },
	'sensortopborder' => { 145 => 0x3ec },
	'sensortopmargin' => { 404 => 0x10b },
	'sensortype' => { 358 => 0xca },
	'sensorwidth' => { 144 => 0xf900, 149 => 0xfa20, 195 => 0xa, 360 => 0x312b, 404 => 0x108, 429 => 0x1601 },
	'sequence' => { 423 => 0x7, 424 => 0x35, 425 => 0x36 },
	'sequencefilenumber' => { 473 => 0x4, 474 => 0x4, 475 => 0x4, 476 => 0x4, 486 => 0xc, 487 => 0xc, 488 => 0x1a },
	'sequenceimagenumber' => { 473 => 0x0, 474 => 0x0, 475 => 0x0, 476 => 0x0, 486 => 0x8, 487 => 0x8, 488 => 0x12, 495 => 0x24 },
	'sequencelength' => { 486 => 0x22, 487 => 0x1e, 488 => [0x16,0x1e] },
	'sequencename' => { 547 => 'sequenceName' },
	'sequencenumber' => { 82 => 0x9, 119 => 0x301c, 133 => 0x1101, 147 => 0x1d, 293 => 0x51c, 358 => 0x2b, 451 => [0x10c,0x30c], 463 => 0xb04a, 547 => 'sequenceNumber' },
	'sequenceshotinterval' => { 438 => 0x224 },
	'sequencetotalnumber' => { 547 => 'sequenceTotalNumber' },
	'sequentialshot' => { 438 => 0x20e },
	'serialnumber' => { 69 => 0xc, 103 => 0x180b, 125 => [0xa431,0xfde9], 144 => 0xfa04, 146 => 0xfa00, 148 => 0xc354, 149 => 0xfa19, 160 => 0x0, 163 => 'SerialNumber', 198 => 0x5501, 246 => [0xa0,0x1d], 335 => 0x101, 339 => [0x404,0x101a], 353 => 0x303, 355 => 0x305, 360 => 0x3103, 395 => 0x229, 404 => 0x102, 405 => 0x407, 421 => ['SNum','slno'], 423 => 0x15, 424 => 0x4b, 425 => 0x7e, 429 => 0x5, 436 => 0xa002, 439 => 0x2, 463 => 0x2031, 525 => 'SerialNumber', 535 => 'BodySerialNumber' },
	'serialnumberformat' => { 69 => 0x15, 103 => 0x183b },
	'serialnumberhash' => { 421 => 'CAME' },
	'series' => { 542 => 'Series' },
	'seriesdatetime' => { 503 => 'SeriesDateTime' },
	'seriesdescription' => { 503 => 'SeriesDescription' },
	'seriesidentifier' => { 542 => [\'Series','SeriesIdentifier'] },
	'seriesmodality' => { 503 => 'SeriesModality' },
	'seriesname' => { 542 => [\'Series','SeriesName'] },
	'seriesnumber' => { 503 => 'SeriesNumber', 548 => 'seriesNumber' },
	'seriestitle' => { 548 => 'seriesTitle' },
	'serviceidentifier' => { 139 => 0x1e },
	'servingsize' => { 550 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 93 => 0x0, 94 => 0x0 },
	'setbuttonwhenshooting' => { 88 => 0x1, 90 => 0x704, 96 => 0xc },
	'setclockfromlocationdata' => { 255 => 0x61d, 256 => 0x64d, 257 => 0x6b5 },
	'setfunctionwhenshooting' => { 91 => 0x0, 92 => 0x1, 95 => 0x1 },
	'setting' => { 547 => 'setting' },
	'shadingcompensation' => { 334 => 0x50c, 358 => 0x8a },
	'shadingcompensation2' => { 338 => 0x1012 },
	'shadow' => { 439 => 0xe },
	'shadowadj' => { 109 => 0x2030b },
	'shadowcorrection' => { 395 => 0x79 },
	'shadowprotection' => { 305 => 0x0 },
	'shadows' => { 125 => 0xfe52, 463 => 0x2032, 521 => 'Shadows', 528 => 'Shadows', 530 => 'Shadows' },
	'shadows2012' => { 528 => 'Shadows2012', 530 => 'Shadows2012' },
	'shadowsadj' => { 500 => 0x901a },
	'shadowscale' => { 125 => 0xc633 },
	'shadowtint' => { 528 => 'ShadowTint', 530 => 'ShadowTint' },
	'shadowtone' => { 133 => 0x1040 },
	'shakereduction' => { 397 => 0x1, 398 => 0x1 },
	'shareduserrating' => { 186 => 'WM/SharedUserRating' },
	'sharpendetail' => { 528 => 'SharpenDetail', 530 => 'SharpenDetail' },
	'sharpenedgemasking' => { 528 => 'SharpenEdgeMasking', 530 => 'SharpenEdgeMasking' },
	'sharpening' => { 360 => 0x300b },
	'sharpeningadj' => { 309 => 0x2b },
	'sharpeningkernel' => { 145 => 0x92f },
	'sharpenradius' => { 528 => 'SharpenRadius', 530 => 'SharpenRadius' },
	'sharpness' => { 8 => [0x42,0x48], 10 => 0x72, 12 => 0x74, 37 => 0xf, 68 => 0x6, 79 => 0x2, 118 => 0xb, 119 => [0x3011,0x21], 125 => [0xa40a,0xfe56], 133 => 0x1001, 147 => 0x6b, 156 => 0x37, 163 => 'Sharpness', 188 => 0x21, 189 => 0x30, 190 => 0x26, 191 => 0x18, 196 => 0x3, 246 => 0x6, 264 => 0x32, 265 => 0x33, 266 => 0x39, 339 => 0x100f, 358 => 0x41, 395 => 0x21, 402 => 0xb, 423 => 0x26, 425 => 0x56, 428 => 0x22, 429 => [0x1003,0x1014], 439 => 0x11, 449 => 0x1c, 450 => 0x19, 463 => 0x2006, 495 => 0x52, 528 => 'Sharpness', 530 => 'Sharpness', 534 => 'Sharpness' },
	'sharpnessadj' => { 109 => 0x20310, 114 => 0x25a, 500 => 0x801a },
	'sharpnessadjon' => { 109 => '0x20310.0' },
	'sharpnessauto' => { 76 => 0x94 },
	'sharpnessfactor' => { 339 => 0x102a },
	'sharpnessfaithful' => { 19 => 0xf5, 75 => 0x64, 76 => 0x64 },
	'sharpnessfrequency' => { 8 => [0x41,0x47], 79 => 0x3 },
	'sharpnesslandscape' => { 19 => 0xf3, 75 => 0x34, 76 => 0x34 },
	'sharpnessmonochrome' => { 19 => 0xf6, 75 => 0x7c, 76 => 0x7c },
	'sharpnessneutral' => { 19 => 0xf4, 75 => 0x4c, 76 => 0x4c },
	'sharpnessovershoot' => { 500 => 0x801b },
	'sharpnessportrait' => { 19 => 0xf2, 75 => 0x1c, 76 => 0x1c },
	'sharpnessrange' => { 463 => 0x2035 },
	'sharpnesssetting' => { 334 => 0x506, 342 => 0x1013, 451 => 0x12, 468 => 0xa },
	'sharpnessstandard' => { 19 => 0xf1, 75 => 0x4, 76 => 0x4 },
	'sharpnessstrength' => { 109 => 0x20311 },
	'sharpnessthreshold' => { 500 => 0x801d },
	'sharpnessundershoot' => { 500 => 0x801c },
	'sharpnessuserdef1' => { 19 => 0xf7, 75 => 0x94, 76 => 0xac },
	'sharpnessuserdef2' => { 19 => 0xf8, 75 => 0xac, 76 => 0xc4 },
	'sharpnessuserdef3' => { 19 => 0xf9, 75 => 0xc4, 76 => 0xdc },
	'shiftcols' => { 145 => 0xc70 },
	'shootid' => { 547 => 'shootID' },
	'shootingdistance' => { 109 => 0x20701 },
	'shootinginfodisplay' => { 313 => '13.2', 314 => '5.1', 322 => '10.2', 323 => '4.1', 326 => '5.1', 328 => '5.3' },
	'shootinginfomonitorofftime' => { 313 => '26.2', 314 => '22.2', 316 => '22.2', 317 => '22.2', 321 => '21.2', 322 => '9.1', 323 => '21.2', 326 => '22.2', 327 => '22.2', 328 => '22.2', 329 => 0x3d, 330 => 0x37, 331 => 0x37, 332 => 0x37 },
	'shootingmode' => { 163 => 'ShootingMode', 246 => 0x89, 358 => 0x1f },
	'shootingmodesetting' => { 315 => '5.1' },
	'shortdescription' => { 532 => 'shortdescription' },
	'shortdocumentid' => { 138 => 0xba },
	'shortname' => { 528 => 'ShortName', 530 => 'ShortName' },
	'shortownername' => { 19 => 0xac },
	'shortreleasetimelag' => { 90 => 0x80d },
	'shorttitle' => { 413 => '@sti' },
	'shotdate' => { 558 => 'shotDate' },
	'shotday' => { 558 => 'shotDay' },
	'shotlocation' => { 558 => 'shotLocation' },
	'shotlogdata' => { 508 => 'shot_log_data' },
	'shotname' => { 421 => 'shot', 558 => 'shotName' },
	'shotnumber' => { 558 => 'shotNumber' },
	'shotnumbersincepowerup' => { 467 => 0x44e, 486 => 0x1a, 487 => 0x16, 488 => 0xa },
	'shotnumbersincepowerup2' => { 451 => 0x200 },
	'shotsize' => { 558 => 'shotSize' },
	'shotsperinterval' => { 235 => 0x180, 250 => 0x1f0, 251 => 0xb4, 252 => 0xcc, 255 => 0xc0, 256 => 0xd0, 257 => 0xd0 },
	'showmovement' => { 413 => 'shwm' },
	'shownevent' => { 542 => 'EventExt' },
	'showneventidentifier' => { 542 => [\'EventExt','EventExtIdentifier'] },
	'showneventname' => { 542 => [\'EventExt','EventExtName'] },
	'shutter' => { 482 => 0x20, 483 => 0x26, 484 => 0x26 },
	'shutter-aelock' => { 88 => 0x4, 90 => 0x701, 91 => 0x3, 92 => 0x4, 93 => 0x3, 94 => 0x3, 95 => 0x4, 96 => 0x2 },
	'shutteraelbutton' => { 89 => 0x4 },
	'shutterbuttonafonbutton' => { 90 => 0x701 },
	'shuttercount' => { 11 => 0x176, 30 => [0xa95,0x293], 33 => 0xaf1, 34 => 0xd29, 61 => 0x1, 246 => 0xa7, 277 => [0x6a,0x157,0x24d], 278 => 0x286, 279 => 0x279, 280 => 0x284, 281 => 0x242, 282 => 0x280, 283 => 0x276, 284 => [0x27d,0x27f], 285 => 0x246, 287 => 0x2d6, 288 => 0x321, 289 => 0xbd8, 290 => 0x287, 291 => 0x320, 292 => 0x24a, 293 => 0x5fb, 294 => 0x2d5, 395 => 0x5d, 460 => 0x846, 466 => [0x125,0x14a], 482 => 0x32, 483 => 0x3a, 484 => 0x3a, 485 => 0xa },
	'shuttercount2' => { 482 => 0x4c, 483 => [0x50,0x52,0x58], 484 => 0x50 },
	'shuttercount3' => { 482 => [0x1a0,0x1aa,0x1bd], 483 => [0x19f,0x1cb,0x1cd] },
	'shuttercurtainsync' => { 88 => 0xf, 89 => 0xf, 90 => 0x305, 91 => 0xe, 92 => 0xf, 93 => 0x8, 94 => 0x8, 95 => 0xf, 96 => 0x8 },
	'shuttermode' => { 61 => 0x17, 147 => 0x1b, 246 => 0x34 },
	'shutterreleasebuttonae-l' => { 313 => '17.7', 314 => '18.4', 316 => '78.4', 317 => '78.4', 318 => '16.1', 319 => '17.1', 320 => '17.1', 321 => '17.1', 322 => '7.1', 323 => '17.5', 326 => '18.4', 327 => '78.4', 328 => '18.2', 329 => 0x2b, 330 => 0x29, 331 => 0x29, 332 => 0x29 },
	'shutterreleasemethod' => { 103 => 0x1010 },
	'shutterreleasenocfcard' => { 88 => 0x2, 89 => 0x2, 96 => 0xf },
	'shutterreleasetiming' => { 103 => 0x1011 },
	'shutterreleasewithoutlens' => { 90 => 0x711 },
	'shutterspeedlock' => { 314 => '38.1', 316 => '38.1', 317 => '38.1', 326 => '38.1', 327 => '38.1', 329 => 0xbb, 330 => 0xb7, 331 => 0xb7, 332 => 0xb7 },
	'shutterspeedrange' => { 90 => 0x10c },
	'shutterspeedsetting' => { 191 => 0x6, 449 => 0x2f, 450 => 0x28, 451 => 0x0 },
	'shutterspeedvalue' => { 99 => 0x1, 125 => 0x9201, 339 => 0x1000, 404 => 0x400, 534 => 'ShutterSpeedValue' },
	'shuttertype' => { 133 => 0x1050, 358 => 0x9f, 395 => 0x87, 488 => [0x133,0x139,0x13f] },
	'sidecarforextension' => { 546 => 'SidecarForExtension' },
	'sigmaimpulseparameters' => { 145 => 0xe0d },
	'sigmascalingfactorcamera' => { 145 => 0xe0c },
	'sigmascalingfactorlowres' => { 145 => 0xe0b },
	'sigmasizetable' => { 145 => 0xe0f },
	'signaltonoiseratio' => { 1 => 0x27 },
	'signaltonoiseratiotype' => { 1 => 0x26 },
	'silentphotography' => { 246 => 0xbf, 250 => 0x9b7 },
	'similarityindex' => { 138 => 0xe4 },
	'singleframebracketing' => { 191 => 0x21 },
	'skilllevel' => { 550 => 'skillLevel' },
	'skintonecorrection' => { 395 => 0x95 },
	'skiplinetime' => { 145 => 0x184e },
	'slaveflashmeteringsegments' => { 395 => 0x20b },
	'slideshowname' => { 547 => 'slideshowName' },
	'slideshownumber' => { 547 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 547 => 'slideshowTotalNumber' },
	'slot2jpgsize' => { 250 => 0x364, 252 => 0x24a, 257 => 0x24a },
	'slowshutter' => { 82 => 0x8 },
	'slowsync' => { 133 => 0x1030 },
	'smartalbumcolor' => { 436 => 0x20 },
	'smartrange' => { 436 => 0xa012 },
	'smileshutter' => { 451 => 0x31 },
	'smileshuttermode' => { 451 => 0x27 },
	'smoothness' => { 125 => 0xfe57, 528 => 'Smoothness', 530 => 'Smoothness' },
	'snapshot' => { 542 => 'SnapshotLink' },
	'snapshotformat' => { 542 => [\'SnapshotLink','SnapshotLinkFormat'] },
	'snapshotheightpixels' => { 542 => [\'SnapshotLink','SnapshotLinkHeightPixels'] },
	'snapshotimagerole' => { 542 => [\'SnapshotLink','SnapshotLinkImageRole'] },
	'snapshotlink' => { 542 => [\'SnapshotLink','SnapshotLinkLink'] },
	'snapshotlinkqualifier' => { 542 => [\'SnapshotLink','SnapshotLinkLinkQualifier'] },
	'snapshots' => { 522 => 'Snapshots' },
	'snapshotusedvideoframe' => { 542 => [\'SnapshotLink','SnapshotLinkUsedVideoFrame'] },
	'snapshotusedvideoframetimeformat' => { 542 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeFormat'] },
	'snapshotusedvideoframetimevalue' => { 542 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeValue'] },
	'snapshotusedvideoframevalue' => { 542 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameValue'] },
	'snapshotwidthpixels' => { 542 => [\'SnapshotLink','SnapshotLinkWidthPixels'] },
	'softskineffect' => { 463 => 0x200f },
	'software' => { 125 => 0x131, 164 => 'Software', 347 => 'Software', 404 => 0x203, 415 => 'software', 439 => 0x18, 511 => 'Software', 554 => 'Software' },
	'softwareversion' => { 421 => ['@swr',"\xa9swr"], 438 => 0x207 },
	'soloist' => { 413 => "\xa9sol" },
	'songwriter' => { 421 => "\xa9swf" },
	'songwriterkeywords' => { 421 => "\xa9swk" },
	'sonycropsize' => { 125 => 0x74c8 },
	'sonycroptopleft' => { 125 => 0x74c7 },
	'sonydatetime' => { 471 => 0x6, 473 => 0x1b6, 474 => 0x210, 475 => 0x1fe, 476 => 0x22c },
	'sonydatetime2' => { 482 => 0x51 },
	'sonyexposuretime' => { 482 => 0x3a, 483 => 0x46, 484 => [0x66,0x46], 485 => 0x1a },
	'sonyexposuretime2' => { 495 => 0xe },
	'sonyfnumber' => { 482 => 0x3c, 483 => 0x48, 484 => [0x68,0x48], 485 => 0x1c, 495 => 0x14 },
	'sonyimageheight' => { 471 => 0x1a, 486 => 0x44, 487 => 0x3f },
	'sonyimageheightmax' => { 495 => 0x40 },
	'sonyimagesize' => { 191 => 0x3b, 449 => 0x54, 450 => 0x54, 451 => 0x9 },
	'sonyimagewidth' => { 471 => 0x1c },
	'sonyimagewidthmax' => { 495 => 0x3e },
	'sonyiso' => { 473 => 0x1218, 474 => 0x11f4, 475 => 0x1270, 476 => [0x1254,0x1258,0x1280], 477 => 0x113c, 478 => 0x344, 479 => 0x346, 480 => 0x320, 495 => 0x4 },
	'sonymaxaperture' => { 482 => 0x0, 483 => 0x0 },
	'sonymaxaperturevalue' => { 495 => 0x16 },
	'sonyminaperture' => { 482 => 0x1, 483 => 0x1 },
	'sonymodelid' => { 463 => 0xb001 },
	'sonyquality' => { 191 => 0x3c },
	'sonyrawimagesize' => { 125 => 0x7038 },
	'sonytimeminsec' => { 483 => 0x61 },
	'sortalbum' => { 413 => 'soal' },
	'sortalbumartist' => { 413 => 'soaa' },
	'sortartist' => { 413 => 'soar' },
	'sortcomposer' => { 413 => 'soco' },
	'sortname' => { 413 => 'sonm', 528 => 'SortName', 530 => 'SortName' },
	'sortshow' => { 413 => 'sosn' },
	'soundengineer' => { 413 => "\xa9sne" },
	'source' => { 138 => 0x73, 347 => 'Source', 531 => 'source', 532 => 'source', 546 => 'Source' },
	'sourcecount' => { 515 => 'SourceCount' },
	'sourcecredits' => { 421 => "\xa9src" },
	'sourcedirectoryindex' => { 381 => 0x0 },
	'sourcefileindex' => { 381 => 0x2 },
	'sourcemodified' => { 343 => 'SourceModified', 545 => 'SourceModified' },
	'sourcephotoscount' => { 514 => 'SourcePhotosCount' },
	'sourceprofileprefix' => { 145 => 0x1390 },
	'spatialfrequencyresponse' => { 534 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 534 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 534 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 534 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 534 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 558 => 'speakerPlacement' },
	'specialeffectlevel' => { 119 => 0x3030 },
	'specialeffectmode' => { 119 => 0x2076 },
	'specialeffectsetting' => { 119 => 0x3031 },
	'specialinstructions' => { 138 => 0x28 },
	'specialmode' => { 339 => 0x200, 438 => 0x200 },
	'specialoccasion' => { 550 => 'specialOccasion' },
	'specialtypeid' => { 508 => 'SpecialTypeID' },
	'spectralsensitivity' => { 125 => 0x8824, 534 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 44 => 0x32b, 45 => 0x281, 46 => 0x295, 49 => [0x2b9,0x2d0,0x2d4], 50 => [0x56a,0x296], 51 => 0x1e4, 52 => [0x1fd,0x2dd], 53 => [0x231,0x30f], 54 => 0x31d },
	'speedx' => { 121 => 0x3, 421 => "\xa9xsp" },
	'speedy' => { 121 => 0x4, 421 => "\xa9ysp" },
	'speedz' => { 121 => 0x5, 421 => "\xa9zsp" },
	'spherical' => { 515 => 'Spherical' },
	'sphericalvideoxml' => { 126 => 'SphericalVideoXML' },
	'splitcolumn' => { 404 => 0x222 },
	'splittoningbalance' => { 528 => 'SplitToningBalance', 530 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 528 => 'SplitToningHighlightHue', 530 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 528 => 'SplitToningHighlightSaturation', 530 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 528 => 'SplitToningShadowHue', 530 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 528 => 'SplitToningShadowSaturation', 530 => 'SplitToningShadowSaturation' },
	'sport' => { 548 => 'sport' },
	'spotfocuspointx' => { 188 => 0x2d },
	'spotfocuspointy' => { 188 => 0x2e },
	'spotmeteringmode' => { 37 => 0x27 },
	'spotmeterlinktoafpoint' => { 90 => 0x107 },
	'sractive' => { 375 => '17.1' },
	'srawquality' => { 37 => 0x2e },
	'srfocallength' => { 397 => 0x3 },
	'srgbrendering' => { 345 => 'sRGB' },
	'srhalfpresstime' => { 397 => 0x2 },
	'srresult' => { 397 => 0x0, 398 => 0x0 },
	'stackedimage' => { 334 => 0x804 },
	'standardmatrixcustom' => { 145 => 0x7d4 },
	'standardmatrixdaylight' => { 145 => 0x7d0 },
	'standardmatrixflash' => { 145 => 0x7d3 },
	'standardmatrixfluorescent' => { 145 => 0x7d2 },
	'standardmatrixtungsten' => { 145 => 0x7d1 },
	'standardoutputhighlightpoint' => { 115 => 0x14 },
	'standardoutputsensitivity' => { 125 => 0x8831, 535 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 115 => 0x15 },
	'standardrawcolortone' => { 115 => 0xd },
	'standardrawcontrast' => { 115 => 0xf },
	'standardrawhighlight' => { 115 => 0x75 },
	'standardrawhighlightpoint' => { 115 => 0x12 },
	'standardrawlinear' => { 115 => 0x10 },
	'standardrawsaturation' => { 115 => 0xe },
	'standardrawshadow' => { 115 => 0x7e },
	'standardrawshadowpoint' => { 115 => 0x13 },
	'standardrawsharpness' => { 115 => 0x11 },
	'standardunsharpmaskfineness' => { 115 => 0x94 },
	'standardunsharpmaskstrength' => { 115 => 0x92 },
	'standardunsharpmaskthreshold' => { 115 => 0x96 },
	'standardwhitecustom' => { 145 => 0x838 },
	'standardwhitedaylight' => { 145 => 0x834 },
	'standardwhiteflash' => { 145 => 0x837 },
	'standardwhitefluorescent' => { 145 => 0x836 },
	'standardwhitetungsten' => { 145 => 0x835 },
	'standbytimer' => { 314 => '19.1', 316 => '19.1', 317 => '19.1', 320 => '18.1', 321 => '18.1', 326 => '19.1', 327 => '19.1' },
	'starlightview' => { 330 => 0x249, 331 => 0x249, 332 => 0x261 },
	'startingpage' => { 548 => 'startingPage' },
	'startmovieshooting' => { 90 => 0x70d },
	'starttimecode' => { 421 => "\xa9TIM", 558 => 'startTimecode' },
	'starttimecodetimeformat' => { 558 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 558 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 558 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 421 => "\xa9TSZ", 558 => 'startTimeSampleSize' },
	'starttimescale' => { 421 => "\xa9TSC", 558 => 'startTimeScale' },
	'state' => { 168 => 'State', 358 => 0x6b, 546 => 'State' },
	'status' => { 506 => 'Status', 520 => 'Status' },
	'stereomode' => { 515 => 'StereoMode' },
	'stitched' => { 515 => 'Stitched' },
	'stitchingsoftware' => { 514 => 'StitchingSoftware', 515 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 472 => 0x113e, 473 => 0x113e, 474 => 0x111a, 475 => 0x1196, 476 => 0x1172, 477 => 0x102a, 478 => 0x222, 479 => 0x222, 480 => 0x217, 495 => 0xa },
	'storagemethod' => { 195 => 0x12 },
	'storebyorientation' => { 314 => '46.3', 316 => '47.3', 317 => '47.3', 326 => '47.3', 327 => '47.3', 329 => 0xd, 330 => 0xd, 331 => 0xd, 332 => 0xd },
	'storedescription' => { 413 => 'sdes' },
	'storedformat' => { 523 => 'StoredFormat' },
	'storylineidentifier' => { 542 => 'StorylineIdentifier' },
	'straightenangle' => { 306 => 0x2fc08431 },
	'streamready' => { 542 => 'StreamReady' },
	'streamtype' => { 183 => 'StreamType' },
	'stretchmode' => { 558 => 'stretchMode' },
	'studydatetime' => { 503 => 'StudyDateTime' },
	'studydescription' => { 503 => 'StudyDescription' },
	'studyid' => { 503 => 'StudyID' },
	'studyphysician' => { 503 => 'StudyPhysician' },
	'styleperiod' => { 542 => 'StylePeriod' },
	'sub-location' => { 138 => 0x5c },
	'subcommanddialframeadvancezoom' => { 257 => 0x806 },
	'subcommanddialplaybackmode' => { 330 => 0x1cf, 331 => 0x1cf, 332 => 0x1e7 },
	'subcommanddialvideoplaybackmode' => { 330 => 0x1d1, 332 => 0x1e9 },
	'subfiledata' => { 171 => 'data' },
	'subfiledirectory' => { 171 => '1Directory' },
	'subfilemimetype' => { 171 => '2MIME' },
	'subfilename' => { 171 => '1Name' },
	'subfileresource' => { 171 => 'rsrc' },
	'subfiletype' => { 125 => 0xfe, 171 => '0Type' },
	'subject' => { 343 => 'Subject', 411 => 'Subject', 531 => 'subject', 544 => 'Subject', 559 => 'subject' },
	'subjectarea' => { 125 => 0x9214, 534 => 'SubjectArea' },
	'subjectcode' => { 541 => 'SubjectCode' },
	'subjectdetection' => { 250 => 0x36e, 252 => 0x252, 255 => 0x23e, 256 => 0x252, 257 => 0x252 },
	'subjectdetectionareamf' => { 250 => 0x3ea },
	'subjectdistance' => { 125 => 0x9206, 147 => 0x3e, 534 => 'SubjectDistance' },
	'subjectdistancerange' => { 125 => 0xa40c, 534 => 'SubjectDistanceRange' },
	'subjectlocation' => { 125 => 0xa214, 534 => 'SubjectLocation' },
	'subjectmotion' => { 316 => '78.2', 317 => '78.2', 327 => '78.2', 330 => 0x103, 331 => 0x103, 332 => 0x119 },
	'subjectprogram' => { 188 => 0x22 },
	'subjectreference' => { 138 => 0xc },
	'subjecttodetect' => { 2 => 0x14 },
	'sublabels1' => { 540 => [\'TagStructure','TagStructureSubLabels'] },
	'sublabels2' => { 540 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublabels3' => { 540 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'sublabels4' => { 540 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 540 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 120 => 'Exif-SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 120 => 'Exif-SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 120 => 'Exif-SubSecModifyDate' },
	'subsectime' => { 125 => 0x9290 },
	'subsectimedigitized' => { 125 => 0x9292 },
	'subsectimeoriginal' => { 125 => 0x9291 },
	'subsection1' => { 548 => 'subsection1' },
	'subsection2' => { 548 => 'subsection2' },
	'subsection3' => { 548 => 'subsection3' },
	'subsection4' => { 548 => 'subsection4' },
	'subselector' => { 314 => '49.1', 316 => '71.1', 317 => '71.1', 327 => '71.1', 329 => 0x93, 330 => 0x8f, 331 => 0x8f, 332 => 0x8f },
	'subselectorassignment' => { 314 => '48.1' },
	'subselectorcenter' => { 316 => '72.1', 317 => '72.1', 327 => '72.1' },
	'subselectorplusdials' => { 314 => '49.2', 316 => '73.1', 317 => '73.1', 327 => '73.1' },
	'subtitle' => { 186 => 'WM/SubTitle', 413 => "\xa9st3", 421 => "\xa9snm", 548 => 'subtitle' },
	'subtitlekeywords' => { 421 => "\xa9snk" },
	'subversionfilename' => { 540 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 540 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 540 => 'SubVersions' },
	'superimposeddisplay' => { 88 => 0xa, 90 => 0x510, 91 => 0x9, 92 => 0xa, 95 => 0xa, 96 => 0xe },
	'supermacro' => { 69 => 0x1a },
	'supplementalcategories' => { 138 => 0x14, 546 => 'SupplementalCategories' },
	'supplementaltype' => { 140 => 0x37 },
	'supplementdisplayid' => { 548 => 'supplementDisplayID' },
	'supplementstartingpage' => { 548 => 'supplementStartingPage' },
	'supplementtitle' => { 548 => 'supplementTitle' },
	'supplychainsource' => { 542 => 'SupplyChainSource' },
	'supplychainsourceidentifier' => { 542 => [\'SupplyChainSource','SupplyChainSourceIdentifier'] },
	'supplychainsourcename' => { 542 => [\'SupplyChainSource','SupplyChainSourceName'] },
	'supportsamount' => { 528 => 'SupportsAmount', 530 => 'SupportsAmount' },
	'supportscolor' => { 528 => 'SupportsColor', 530 => 'SupportsColor' },
	'supportshighdynamicrange' => { 528 => 'SupportsHighDynamicRange', 530 => 'SupportsHighDynamicRange' },
	'supportsmonochrome' => { 528 => 'SupportsMonochrome', 530 => 'SupportsMonochrome' },
	'supportsnormaldynamicrange' => { 528 => 'SupportsNormalDynamicRange', 530 => 'SupportsNormalDynamicRange' },
	'supportsoutputreferred' => { 528 => 'SupportsOutputReferred', 530 => 'SupportsOutputReferred' },
	'supportsscenereferred' => { 528 => 'SupportsSceneReferred', 530 => 'SupportsSceneReferred' },
	'svisosetting' => { 375 => 0x14 },
	'swatchcoloranta' => { 563 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 563 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 563 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 563 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 563 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 563 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 563 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 563 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 563 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 563 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 563 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 563 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 563 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 563 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 563 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 563 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 563 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 563 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 563 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 358 => 0x93, 451 => 0x33 },
	'sweeppanoramafieldofview' => { 358 => 0x94 },
	'sweeppanoramasize' => { 451 => 0x32 },
	'switchtoregisteredafpoint' => { 89 => 0x12, 90 => 0x50a },
	'symlink' => { 126 => 'SymLink' },
	'syncreleasemode' => { 316 => '77.1', 317 => '77.1', 327 => '77.1', 329 => 0x45, 330 => 0x41, 331 => 0x41, 332 => 0x41 },
	'system' => { 404 => 0x204 },
	'tagged' => { 406 => 0xdd, 407 => 'Tagged', 522 => 'tagged' },
	'tagslist' => { 533 => 'TagsList' },
	'tagstructure' => { 540 => 'TagStructure' },
	'takenumber' => { 558 => 'takeNumber' },
	'tapename' => { 558 => 'tapeName' },
	'targetaperture' => { 82 => 0x4 },
	'targetaspectratio' => { 348 => 'TargetAspectRatio' },
	'targetcompressionratio' => { 101 => 0x1 },
	'targetdistancesetting' => { 103 => 0x1807 },
	'targetexposuretime' => { 82 => 0x5 },
	'targetimagetype' => { 103 => 0x100a },
	'targetprinter' => { 125 => 0x151 },
	'taxon' => { 124 => 'Taxon' },
	'taxonacceptednameusage' => { 124 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 124 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 124 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 124 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxoncultivarepithet' => { 124 => [\'Taxon','TaxonCultivarEpithet'] },
	'taxonfamily' => { 124 => [\'Taxon','TaxonFamily'] },
	'taxongenericname' => { 124 => [\'Taxon','TaxonGenericName'] },
	'taxongenus' => { 124 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 124 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 124 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfragenericepithet' => { 124 => [\'Taxon','TaxonInfragenericEpithet'] },
	'taxoninfraspecificepithet' => { 124 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 124 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 124 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 124 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 124 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 124 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 124 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 124 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 124 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 124 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 124 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 124 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 124 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 124 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 124 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 124 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 124 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 124 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 124 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 124 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 124 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubfamily' => { 124 => [\'Taxon','TaxonSubFamily'] },
	'taxonsubgenus' => { 124 => [\'Taxon','TaxonSubgenus'] },
	'taxonsubtribe' => { 124 => [\'Taxon','TaxonSubTribe'] },
	'taxonsuperfamily' => { 124 => [\'Taxon','TaxonSuperFamily'] },
	'taxontaxonomicstatus' => { 124 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxontribe' => { 124 => [\'Taxon','TaxonTribe'] },
	'taxonverbatimtaxonrank' => { 124 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 124 => [\'Taxon','TaxonVernacularName'] },
	'tda1bandwidth' => { 145 => 0x196f },
	'tda1edgepolarity' => { 145 => 0x1971 },
	'tda1gain' => { 145 => 0x1970 },
	'tda1offset' => { 145 => 0x196e },
	'tda2bandwidth' => { 145 => 0x1979 },
	'tda2edgepolarity' => { 145 => 0x197b },
	'tda2gain' => { 145 => 0x197a },
	'tda2offset' => { 145 => 0x1978 },
	'tda3bandwidth' => { 145 => 0x1983 },
	'tda3edgepolarity' => { 145 => 0x1985 },
	'tda3gain' => { 145 => 0x1984 },
	'tda3offset' => { 145 => 0x1982 },
	'tda4bandwidth' => { 145 => 0x198d },
	'tda4edgepolarity' => { 145 => 0x198f },
	'tda4gain' => { 145 => 0x198e },
	'tda4offset' => { 145 => 0x198c },
	'teaser' => { 548 => 'teaser' },
	'teleconverter' => { 193 => 0x105, 463 => 0x105 },
	'tempampgainx100' => { 145 => 0x1914 },
	'tempo' => { 558 => 'tempo' },
	'temporalcoverage' => { 542 => 'TemporalCoverage' },
	'temporalcoveragefrom' => { 542 => [\'TemporalCoverage','TemporalCoverageTempCoverageFrom'] },
	'temporalcoverageto' => { 542 => [\'TemporalCoverage','TemporalCoverageTempCoverageTo'] },
	'termsandconditionstext' => { 344 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 344 => 'TermsAndConditionsURL' },
	'testname' => { 126 => 'TestName' },
	'textencoding' => { 245 => 0x4 },
	'textlayername' => { 546 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 546 => 'TextLayers' },
	'textlayertext' => { 546 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 358 => [0x8008,0x8009,0x3b,0x3e] },
	'texture' => { 528 => 'Texture', 530 => 'Texture' },
	'three-dtrackingfacedetection' => { 316 => '1.4', 317 => '1.4', 327 => '1.4' },
	'three-dtrackingwatcharea' => { 316 => '78.1', 317 => '78.1', 327 => '78.1' },
	'thresholding' => { 125 => 0x107 },
	'thumbnailfilename' => { 103 => 0x817 },
	'thumbnailformat' => { 556 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 149 => 0xfa55, 556 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 6 => 'CNDA', 103 => 0x2008, 120 => 'Exif-ThumbnailImage', 128 => 0x3, 174 => 'data', 339 => 0x100, 413 => 'tnal', 421 => 'thmb', 556 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 174 => '1Name' },
	'thumbnailimagesize' => { 174 => 'ImageSize' },
	'thumbnailimagetype' => { 174 => '0Type' },
	'thumbnailimagevalidarea' => { 69 => 0x13 },
	'thumbnaillength' => { 125 => 0x202 },
	'thumbnailoffset' => { 125 => 0x201 },
	'thumbnailpng' => { 421 => 'thmb' },
	'thumbnails' => { 556 => 'Thumbnails' },
	'thumbnailwidth' => { 149 => 0xfa54, 556 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 548 => 'ticker' },
	'tiffhandling' => { 528 => 'TIFFHandling', 530 => 'TIFFHandling' },
	'tiffmeteringimage' => { 194 => 0x104c, 460 => 0x1110 },
	'tilelength' => { 125 => 0x143 },
	'tilewidth' => { 125 => 0x142 },
	'time' => { 145 => 0x401, 395 => 0x7 },
	'timecodes' => { 125 => 0xc763 },
	'timecreated' => { 138 => 0x3c, 147 => 0x14, 156 => 0x10, 407 => 'TimeCreated' },
	'timelapseshotnumber' => { 361 => 0x10 },
	'timeperiod' => { 548 => 'timePeriod' },
	'timerfunctionbutton' => { 315 => '5.2', 318 => '12.1', 319 => '13.1' },
	'timerlength' => { 90 => 0x80c },
	'timerrecording' => { 358 => 0x96 },
	'timescaleparams' => { 558 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 558 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 558 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 558 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 139 => 0x50 },
	'timeshot' => { 516 => 'TimeShot' },
	'timesignature' => { 558 => 'timeSignature' },
	'timesincepoweron' => { 358 => 0x29 },
	'timestamp' => { 11 => 0x45e, 19 => 0x11c, 333 => 0x8, 347 => 'TimeStamp', 358 => 0xaf, 515 => 'Timestamp', 524 => 'Timestamp', 540 => 'TimeStamp' },
	'timestamp1' => { 11 => 0x45a },
	'timezone' => { 83 => 0x1, 250 => 0x8fe, 253 => 0x694, 254 => 0x6a4, 255 => 0x594, 256 => 0x5c4, 257 => 0x5dc, 298 => 0x0, 432 => 0xa },
	'timezonecity' => { 83 => 0x2 },
	'timezonecode' => { 106 => 0x1 },
	'timezoneinfo' => { 106 => 0x2 },
	'timezoneoffset' => { 125 => 0x882a },
	'tint' => { 415 => 'player.movie.visual.tint', 528 => 'Tint', 530 => 'Tint' },
	'title' => { 164 => 'Title', 343 => 'Title', 347 => 'Title', 358 => 0x65, 411 => 'Title', 413 => ['titl',"\xa9nam"], 415 => 'title', 421 => ['titl',"\xa9nam"], 531 => 'title', 544 => 'Title', 556 => 'Title' },
	'togglestyleamount' => { 528 => 'ToggleStyleAmount', 530 => 'ToggleStyleAmount' },
	'togglestyledigest' => { 528 => 'ToggleStyleDigest', 530 => 'ToggleStyleDigest' },
	'tonecomp' => { 246 => 0x81 },
	'tonecurve' => { 79 => 0x1, 395 => 0x402, 528 => 'ToneCurve', 530 => 'ToneCurve' },
	'tonecurveactive' => { 114 => 0x110 },
	'tonecurveadobergb' => { 436 => 0xa043 },
	'tonecurveadobergbdefault' => { 436 => 0xa041 },
	'tonecurveblue' => { 528 => 'ToneCurveBlue', 530 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 500 => 0x9003 },
	'tonecurvebluey' => { 500 => 0x9007 },
	'tonecurvebrightness' => { 109 => 0x20410 },
	'tonecurvebrightnessx' => { 500 => 0x9000 },
	'tonecurvebrightnessy' => { 500 => 0x9004 },
	'tonecurvecolorspace' => { 113 => 0x0 },
	'tonecurvecontrast' => { 109 => 0x20411 },
	'tonecurvegreen' => { 528 => 'ToneCurveGreen', 530 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 500 => 0x9002 },
	'tonecurvegreeny' => { 500 => 0x9006 },
	'tonecurveinputrange' => { 113 => 0x3 },
	'tonecurveinterpolation' => { 114 => 0x159 },
	'tonecurvemode' => { 114 => 0x113 },
	'tonecurvename' => { 528 => 'ToneCurveName', 530 => 'ToneCurveName' },
	'tonecurvename2012' => { 528 => 'ToneCurveName2012', 530 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 109 => '0x20400.1' },
	'tonecurveoutputrange' => { 113 => 0x5 },
	'tonecurveprofilename' => { 145 => 0x1391 },
	'tonecurveproperty' => { 114 => 0x3c },
	'tonecurvepv2012' => { 528 => 'ToneCurvePV2012', 530 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 528 => 'ToneCurvePV2012Blue', 530 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 528 => 'ToneCurvePV2012Green', 530 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 528 => 'ToneCurvePV2012Red', 530 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 528 => 'ToneCurveRed', 530 => 'ToneCurveRed' },
	'tonecurveredx' => { 500 => 0x9001 },
	'tonecurveredy' => { 500 => 0x9005 },
	'tonecurves' => { 395 => 0x403 },
	'tonecurveshape' => { 113 => 0x1 },
	'tonecurvesrgb' => { 436 => 0xa042 },
	'tonecurvesrgbdefault' => { 436 => 0xa040 },
	'tonecurvex' => { 113 => 0xa },
	'tonecurvey' => { 113 => 0xb },
	'tonelevel' => { 334 => 0x52e },
	'tonemap' => { 250 => 0x374, 252 => 0x26a },
	'tonemapstrength' => { 528 => 'ToneMapStrength', 530 => 'ToneMapStrength' },
	'toningeffect' => { 61 => 0xf, 246 => 0xb3, 264 => 0x38, 265 => 0x40, 266 => 0x48, 429 => 0x1015 },
	'toningeffectauto' => { 76 => 0xa4 },
	'toningeffectfaithful' => { 75 => 0x74, 76 => 0x74 },
	'toningeffectlandscape' => { 75 => 0x44, 76 => 0x44 },
	'toningeffectmonochrome' => { 19 => 0x108, 75 => 0x8c, 76 => 0x8c },
	'toningeffectneutral' => { 75 => 0x5c, 76 => 0x5c },
	'toningeffectportrait' => { 75 => 0x2c, 76 => 0x2c },
	'toningeffectstandard' => { 75 => 0x14, 76 => 0x14 },
	'toningeffectuserdef1' => { 75 => 0xa4, 76 => 0xbc },
	'toningeffectuserdef2' => { 75 => 0xbc, 76 => 0xd4 },
	'toningeffectuserdef3' => { 75 => 0xd4, 76 => 0xec },
	'toningsaturation' => { 264 => 0x39, 265 => 0x41, 266 => 0x49 },
	'totalzoom' => { 147 => 0x62 },
	'touchae' => { 358 => 0xab },
	'touchfn' => { 329 => 0x154 },
	'touchfnareatall' => { 329 => 0x15b },
	'touchfnareawide' => { 329 => 0x159 },
	'touchfnrole' => { 329 => 0x155 },
	'track' => { 413 => "\xa9trk", 421 => "\xa9trk" },
	'trackcreatedate' => { 420 => 0x1 },
	'trackmodifydate' => { 420 => 0x2 },
	'trackname' => { 421 => 'tnam' },
	'tracknumber' => { 413 => 'trkn', 558 => 'trackNumber' },
	'tracks' => { 558 => 'Tracks' },
	'tracksframerate' => { 558 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 558 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 558 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 558 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 558 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 558 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 558 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 558 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 558 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 558 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 558 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 558 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 558 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 558 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 558 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 558 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 558 => [\'Tracks','TracksTrackType'] },
	'tracktype' => { 421 => 'kgtt' },
	'trailer' => { 126 => 'Trailer' },
	'trailersignature' => { 171 => 'zmie' },
	'transcript' => { 542 => 'Transcript' },
	'transcriptlink' => { 542 => 'TranscriptLink' },
	'transcriptlinklink' => { 542 => [\'TranscriptLink','TranscriptLinkLink'] },
	'transcriptlinklinkqualifier' => { 542 => [\'TranscriptLink','TranscriptLinkLinkQualifier'] },
	'transferfunction' => { 125 => 0x12d, 554 => 'TransferFunction' },
	'transfertimenormal' => { 145 => 0x1888 },
	'transfertimetest' => { 145 => 0x1889 },
	'transform' => { 358 => [0x8012,0x59] },
	'transformation' => { 543 => 'Transformation' },
	'transmissionreference' => { 546 => 'TransmissionReference' },
	'trapped' => { 343 => 'Trapped', 544 => 'Trapped' },
	'trashbuttonfunction' => { 90 => 0x710 },
	'travelday' => { 358 => 0x36 },
	'treble' => { 412 => 'player.movie.audio.treble', 415 => 'player.movie.audio.treble' },
	'triggermode' => { 423 => 0x6, 424 => 0x34, 425 => 0x34 },
	'tstop' => { 125 => 0xc772 },
	'ttl_da_adown' => { 382 => 0x5 },
	'ttl_da_aup' => { 382 => 0x4 },
	'ttl_da_bdown' => { 382 => 0x7 },
	'ttl_da_bup' => { 382 => 0x6 },
	'tungstenawb' => { 371 => 0x1 },
	'tvepisode' => { 413 => 'tves' },
	'tvepisodeid' => { 413 => 'tven' },
	'tvexposuretimesetting' => { 375 => 0x12 },
	'tvnetworkname' => { 413 => 'tvnn' },
	'tvseason' => { 413 => 'tvsn' },
	'tvshow' => { 413 => 'tvsh' },
	'type' => { 510 => 'Type', 531 => 'type', 553 => 'type' },
	'typestatus' => { 124 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 125 => 0xc614 },
	'uniquedocumentid' => { 138 => 0xbb },
	'uniquematrixauto' => { 145 => 0x7e9 },
	'uniquematrixcustom' => { 145 => 0x7e8 },
	'uniquematrixdaylight' => { 145 => 0x7e4 },
	'uniquematrixflash' => { 145 => 0x7e7 },
	'uniquematrixfluorescent' => { 145 => 0x7e6 },
	'uniquematrixtungsten' => { 145 => 0x7e5 },
	'uniqueobjectname' => { 139 => 0x64 },
	'units' => { 511 => 'Units' },
	'unknown_aacr' => { 413 => 'AACR' },
	'unknown_cdek' => { 413 => 'CDEK' },
	'unknown_cdet' => { 413 => 'CDET' },
	'unknownblock' => { 395 => 0x405 },
	'unknownblock1' => { 338 => 0x635 },
	'unknownblock2' => { 338 => 0x636 },
	'unknownblock3' => { 338 => 0x1103 },
	'unknownblock4' => { 338 => 0x1104 },
	'unknowncontrast' => { 115 => 0x45 },
	'unknowndate' => { 404 => 0x212 },
	'unknownev' => { 145 => 0x1 },
	'unknownlinear' => { 115 => 0x46 },
	'unknownnumber' => { 103 => 0x180b },
	'unknownoutputhighlightpoint' => { 115 => 0x4a },
	'unknownoutputshadowpoint' => { 115 => 0x4b },
	'unknownrawhighlight' => { 115 => 0x7b },
	'unknownrawhighlightpoint' => { 115 => 0x48 },
	'unknownrawshadow' => { 115 => 0x84 },
	'unknownrawshadowpoint' => { 115 => 0x49 },
	'unknownsharpness' => { 115 => 0x47 },
	'unknowntags' => { 421 => 'TAGS' },
	'unknowntemperature' => { 127 => 0x4 },
	'unknownthumbnail' => { 421 => 'thmb' },
	'unsharp1color' => { 311 => 0x13 },
	'unsharp1halowidth' => { 311 => 0x19 },
	'unsharp1intensity' => { 311 => 0x17 },
	'unsharp1threshold' => { 311 => 0x1b },
	'unsharp2color' => { 311 => 0x2e },
	'unsharp2halowidth' => { 311 => 0x34 },
	'unsharp2intensity' => { 311 => 0x32 },
	'unsharp2threshold' => { 311 => 0x36 },
	'unsharp3color' => { 311 => 0x49 },
	'unsharp3halowidth' => { 311 => 0x4f },
	'unsharp3intensity' => { 311 => 0x4d },
	'unsharp3threshold' => { 311 => 0x51 },
	'unsharp4color' => { 311 => 0x64 },
	'unsharp4halowidth' => { 311 => 0x6a },
	'unsharp4intensity' => { 311 => 0x68 },
	'unsharp4threshold' => { 311 => 0x6c },
	'unsharpcount' => { 311 => 0x0 },
	'unsharpmask' => { 115 => 0x90, 306 => 0x76a43200 },
	'unsharpmaskfineness' => { 79 => 0xe, 109 => 0x20309 },
	'unsharpmaskstrength' => { 109 => 0x20308 },
	'unsharpmaskthreshold' => { 79 => 0xf, 109 => 0x2030a },
	'uprightcentermode' => { 528 => 'UprightCenterMode', 530 => 'UprightCenterMode' },
	'uprightcenternormx' => { 528 => 'UprightCenterNormX', 530 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 528 => 'UprightCenterNormY', 530 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 528 => 'UprightDependentDigest', 530 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 528 => 'UprightFocalLength35mm', 530 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 528 => 'UprightFocalMode', 530 => 'UprightFocalMode' },
	'uprightfoursegments_0' => { 528 => 'UprightFourSegments_0', 530 => 'UprightFourSegments_0' },
	'uprightfoursegments_1' => { 528 => 'UprightFourSegments_1', 530 => 'UprightFourSegments_1' },
	'uprightfoursegments_2' => { 528 => 'UprightFourSegments_2', 530 => 'UprightFourSegments_2' },
	'uprightfoursegments_3' => { 528 => 'UprightFourSegments_3', 530 => 'UprightFourSegments_3' },
	'uprightfoursegmentscount' => { 528 => 'UprightFourSegmentsCount', 530 => 'UprightFourSegmentsCount' },
	'uprightguideddependentdigest' => { 528 => 'UprightGuidedDependentDigest', 530 => 'UprightGuidedDependentDigest' },
	'uprightpreview' => { 528 => 'UprightPreview', 530 => 'UprightPreview' },
	'uprighttransform_0' => { 528 => 'UprightTransform_0', 530 => 'UprightTransform_0' },
	'uprighttransform_1' => { 528 => 'UprightTransform_1', 530 => 'UprightTransform_1' },
	'uprighttransform_2' => { 528 => 'UprightTransform_2', 530 => 'UprightTransform_2' },
	'uprighttransform_3' => { 528 => 'UprightTransform_3', 530 => 'UprightTransform_3' },
	'uprighttransform_4' => { 528 => 'UprightTransform_4', 530 => 'UprightTransform_4' },
	'uprighttransform_5' => { 528 => 'UprightTransform_5', 530 => 'UprightTransform_5' },
	'uprighttransformcount' => { 528 => 'UprightTransformCount', 530 => 'UprightTransformCount' },
	'uprightversion' => { 528 => 'UprightVersion', 530 => 'UprightVersion' },
	'urgency' => { 138 => 0xa, 546 => 'Urgency' },
	'url' => { 164 => 'URL', 347 => 'URL', 409 => 0x40b, 548 => 'url' },
	'url_list' => { 409 => 0x41e },
	'urla-platform' => { 548 => [\'url','urlA-platform'] },
	'urlurl' => { 548 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 90 => 0x10a },
	'usableshootingmodes' => { 90 => 0x109 },
	'usage' => { 549 => 'usage' },
	'usageterms' => { 562 => 'UsageTerms' },
	'usbpowerdelivery' => { 250 => 0x9ac, 253 => 0x762, 254 => 0x772, 255 => 0x664, 256 => 0x694, 257 => 0x6fc },
	'usedialwithouthold' => { 329 => 0xc3, 330 => 0xbf, 331 => 0xbf, 332 => 0xbf },
	'useguidelines' => { 526 => 'useGuidelines' },
	'usepanoramaviewer' => { 514 => 'UsePanoramaViewer' },
	'usercollection' => { 415 => 'collection.user' },
	'usercomment' => { 103 => 0x805, 125 => 0x9286, 534 => 'UserComment' },
	'userdef1picturestyle' => { 19 => 0x10c, 75 => 0xd8, 76 => 0xf0 },
	'userdef2picturestyle' => { 19 => 0x10e, 75 => 0xda, 76 => 0xf2 },
	'userdef3picturestyle' => { 19 => 0x110, 75 => 0xdc, 76 => 0xf4 },
	'userfields' => { 520 => 'UserFields' },
	'userlabel' => { 423 => 0x2b, 424 => 0x5a, 425 => 0x68 },
	'userprofile' => { 353 => 0x302, 357 => 0x34c, 360 => 0x3038 },
	'userrating' => { 415 => 'rating.user', 421 => 'urat' },
	'usmlenselectronicmf' => { 2 => 0x7, 89 => 0x7, 90 => 0x501 },
	'uspsnumber' => { 548 => 'uspsNumber' },
	'utmeasting' => { 175 => 'Easting' },
	'utmmapdatum' => { 175 => 'Datum' },
	'utmnorthing' => { 175 => 'Northing' },
	'utmzone' => { 175 => 'Zone' },
	'uuid' => { 528 => 'UUID', 530 => 'UUID' },
	'uv-irfiltercorrection' => { 353 => 0x325 },
	'validbits' => { 338 => 0x611, 339 => 0x102c },
	'validcropcorners' => { 348 => 'ValidCropCorners' },
	'validpixeldepth' => { 342 => 0x611 },
	'variablelowpassfilter' => { 463 => 0x2028 },
	'variousmodes' => { 147 => 0x26 },
	'variousmodes2' => { 147 => 0x3a },
	'variprogram' => { 246 => 0xab },
	'varraydacnominalvalues' => { 145 => 0x191e },
	'vendor' => { 421 => 'vndr' },
	'vendorinfo' => { 504 => 'VendorInfo' },
	'vendorinfomanufacturer' => { 504 => [\'VendorInfo','VendorInfoManufacturer'] },
	'vendorinfomodel' => { 504 => [\'VendorInfo','VendorInfoModel'] },
	'vendorinfonotes' => { 504 => [\'VendorInfo','VendorInfoNotes'] },
	'verbatimidentification' => { 124 => [\'Identification','IdentificationVerbatimIdentification'] },
	'version' => { 133 => 0x0, 348 => 'Version', 411 => 'Version', 415 => 'version', 528 => 'Version', 530 => 'Version', 539 => 'Version' },
	'versioncreatedate' => { 500 => 0xd100 },
	'versionid' => { 559 => 'VersionID' },
	'versionidentifier' => { 548 => 'versionIdentifier' },
	'versionmodifydate' => { 500 => 0xd101 },
	'versions' => { 559 => 'Versions' },
	'versionscomments' => { 559 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 559 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 559 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 559 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 559 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 559 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 559 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 559 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 559 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 559 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 559 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 313 => '3.2', 314 => '47.2', 316 => '79.1', 331 => 0x11d, 332 => 0x135 },
	'verticalclockoverlaps' => { 145 => 0x412 },
	'verticalfuncbutton' => { 314 => '42.2', 316 => '67.1', 331 => 0x115, 332 => 0x12d },
	'verticalfuncbuttonplaybackmode' => { 331 => 0x1b7, 332 => 0x1cf },
	'verticalfuncbuttonplusdials' => { 314 => '43.1' },
	'verticalfuncplusdials' => { 316 => '68.1' },
	'verticalisobutton' => { 257 => 0x792 },
	'verticalmovieafonbutton' => { 331 => 0x1f9, 332 => 0x211 },
	'verticalmoviefuncbutton' => { 331 => 0x1e1, 332 => 0x1f9 },
	'verticalmultiselector' => { 314 => '42.1', 316 => '66.1', 317 => '66.1', 327 => '66.1', 331 => 0x18f, 332 => 0x1a7 },
	'verticalmultiselectorplaybackmode' => { 331 => 0x125, 332 => 0x13d },
	'vfdisplayillumination' => { 2 => 0x11, 90 => [0x510,0x51d] },
	'vibrance' => { 521 => 'Vibrance', 528 => 'Vibrance', 530 => 'Vibrance' },
	'vibrationreduction' => { 277 => [0x75,0x82,0x1ae], 285 => '586.1', 292 => '590.2', 296 => 0x4 },
	'videoalphamode' => { 558 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 558 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 558 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 558 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 558 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 558 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 558 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 558 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 558 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 558 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 558 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 558 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 558 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 558 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 558 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 558 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 558 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 558 => 'videoAlphaUnityIsTransparent' },
	'videobitrate' => { 542 => 'videoBitRate' },
	'videobitratemode' => { 542 => 'videoBitRateMode' },
	'videoburstmode' => { 358 => 0xbb },
	'videoburstresolution' => { 358 => 0xb3 },
	'videocodec' => { 72 => 0x74 },
	'videocolorspace' => { 558 => 'videoColorSpace' },
	'videocompression' => { 133 => 0x3806 },
	'videocompressor' => { 558 => 'videoCompressor' },
	'videodisplayaspectratio' => { 542 => 'videoDisplayAspectRatio' },
	'videoencodingprofile' => { 542 => 'videoEncodingProfile' },
	'videofieldorder' => { 558 => 'videoFieldOrder' },
	'videoframerate' => { 358 => 0x27, 558 => 'videoFrameRate' },
	'videoframesize' => { 558 => 'videoFrameSize' },
	'videoframesizeh' => { 558 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 558 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 558 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 558 => 'videoModDate' },
	'videopixelaspectratio' => { 558 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 558 => 'videoPixelDepth' },
	'videopreburst' => { 358 => 0xc1 },
	'videoquality' => { 119 => 0x4003 },
	'videorecordingmode' => { 133 => 0x3803 },
	'videoshottype' => { 542 => 'VideoShotType' },
	'videoshottypeidentifier' => { 542 => [\'VideoShotType','VideoShotTypeIdentifier'] },
	'videoshottypename' => { 542 => [\'VideoShotType','VideoShotTypeName'] },
	'videostreamscount' => { 542 => 'videoStreamsCount' },
	'viewfinder' => { 404 => 0x455 },
	'viewfinderdisplay' => { 313 => '12.4', 314 => '6.3' },
	'viewfinderwarning' => { 313 => '13.4', 323 => '3.5', 324 => '6.2', 328 => '4.4' },
	'viewfinderwarnings' => { 90 => 0x40a },
	'viewinfoduringexposure' => { 90 => 0x407 },
	'viewingmode' => { 451 => 0x2f, 468 => 0x18 },
	'viewingmode2' => { 451 => [0x85,0x285] },
	'viewmodeshoweffectsofsettings' => { 257 => 0x7d2, 330 => 0x2a9 },
	'viewpoint' => { 547 => 'viewpoint' },
	'vignetteamount' => { 528 => 'VignetteAmount', 530 => 'VignetteAmount' },
	'vignettecoefficient1' => { 297 => 0x24 },
	'vignettecoefficient2' => { 297 => 0x34 },
	'vignettecoefficient3' => { 297 => 0x44 },
	'vignettecontrol' => { 246 => 0x2a, 306 => 0x76a43205 },
	'vignettecontrolintensity' => { 306 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 525 => 'VignetteCorrectionAlreadyApplied' },
	'vignettecorrectionversion' => { 297 => 0x0 },
	'vignettemidpoint' => { 528 => 'VignetteMidpoint', 530 => 'VignetteMidpoint' },
	'vignetting' => { 429 => 0x1011, 436 => 0xa052 },
	'vignettingcorrection' => { 125 => 0x7031, 436 => 0xa053, 463 => 0x2011 },
	'vignettingcorrparams' => { 125 => 0x7032, 494 => 0x64a, 495 => [0x34a,0x350,0x35c,0x368] },
	'vignettingsetting' => { 436 => 0xa054 },
	'virtualfocallength' => { 543 => 'VirtualFocalLength' },
	'virtualhorizonstyle' => { 329 => 0x161, 330 => 0x167, 331 => 0x167, 332 => 0x17f },
	'virtualimagexcenter' => { 543 => 'VirtualImageXCenter' },
	'virtualimageycenter' => { 543 => 'VirtualImageYCenter' },
	'visualcolor' => { 542 => 'VisualColour' },
	'visualtechnique' => { 547 => 'visualTechnique' },
	'voicememo' => { 438 => 0x216 },
	'volume' => { 548 => 'volume' },
	'vr_0x66' => { 277 => 0x66 },
	'vrdoffset' => { 69 => 0xd0 },
	'vrmode' => { 250 => 0x342, 252 => 0x226, 255 => 0x212, 256 => 0x226, 257 => 0x226, 296 => 0x6 },
	'vrtype' => { 296 => 0x8 },
	'waterdepth' => { 125 => 0x9403, 535 => 'WaterDepth' },
	'wb_bluelevel3500k' => { 194 => 0x19a },
	'wb_bluelevel6500k' => { 194 => 0x18a },
	'wb_bluelevelcustom' => { 194 => 0x18e },
	'wb_bluelevelscloudy' => { 194 => 0x106 },
	'wb_bluelevelsdaylight' => { 194 => 0xea },
	'wb_bluelevelsflash' => { 194 => 0x122 },
	'wb_bluelevelsfluorescent' => { 194 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 194 => 0x254 },
	'wb_bluelevelsshade' => { 194 => 0x176 },
	'wb_bluelevelstungsten' => { 194 => 0xce },
	'wb_gbrglevels' => { 194 => 0xae, 197 => 0x4 },
	'wb_glevel' => { 338 => 0x11f },
	'wb_glevel3000k' => { 338 => 0x113 },
	'wb_glevel3300k' => { 338 => 0x114 },
	'wb_glevel3600k' => { 338 => 0x115 },
	'wb_glevel3900k' => { 338 => 0x116 },
	'wb_glevel4000k' => { 338 => 0x117 },
	'wb_glevel4300k' => { 338 => 0x118 },
	'wb_glevel4500k' => { 338 => 0x119 },
	'wb_glevel4800k' => { 338 => 0x11a },
	'wb_glevel5300k' => { 338 => 0x11b },
	'wb_glevel6000k' => { 338 => 0x11c },
	'wb_glevel6600k' => { 338 => 0x11d },
	'wb_glevel7500k' => { 338 => 0x11e },
	'wb_grbglevels' => { 214 => 0x0, 470 => 0x7303 },
	'wb_grbglevelsauto' => { 86 => 0x2, 470 => 0x7302 },
	'wb_grbglevelscloudy' => { 86 => 0x12 },
	'wb_grbglevelscustom1' => { 86 => 0x42 },
	'wb_grbglevelscustom2' => { 86 => 0x4a },
	'wb_grbglevelsdaylight' => { 86 => 0xa },
	'wb_grbglevelsflash' => { 86 => 0x32 },
	'wb_grbglevelsfluorescent' => { 86 => 0x22 },
	'wb_grbglevelsfluorhigh' => { 86 => 0x2a },
	'wb_grbglevelstungsten' => { 86 => 0x1a },
	'wb_grbglevelsunderwater' => { 86 => 0x3a },
	'wb_rbgglevels' => { 211 => 0x0 },
	'wb_rblevels' => { 215 => 0x270, 246 => 0xc, 338 => 0x100 },
	'wb_rblevels1' => { 364 => 0x2 },
	'wb_rblevels2' => { 364 => 0x5 },
	'wb_rblevels3' => { 364 => 0x8 },
	'wb_rblevels3000k' => { 338 => 0x102 },
	'wb_rblevels3300k' => { 338 => 0x103 },
	'wb_rblevels3500k' => { 194 => 0x430 },
	'wb_rblevels3600k' => { 338 => 0x104 },
	'wb_rblevels3900k' => { 338 => 0x105 },
	'wb_rblevels4' => { 364 => 0xb },
	'wb_rblevels4000k' => { 338 => 0x106 },
	'wb_rblevels4300k' => { 338 => 0x107 },
	'wb_rblevels4500k' => { 338 => 0x108 },
	'wb_rblevels4800k' => { 338 => 0x109 },
	'wb_rblevels5' => { 364 => 0xe },
	'wb_rblevels5300k' => { 338 => 0x10a },
	'wb_rblevels6' => { 364 => 0x11 },
	'wb_rblevels6000k' => { 338 => 0x10b },
	'wb_rblevels6500k' => { 194 => 0x420 },
	'wb_rblevels6600k' => { 338 => 0x10c },
	'wb_rblevels7' => { 364 => 0x14 },
	'wb_rblevels7500k' => { 338 => 0x10d },
	'wb_rblevelsauto' => { 215 => 0x272, 342 => 0x110 },
	'wb_rblevelscloudy' => { 194 => 0x3f0, 196 => 0x10, 215 => 0x296, 342 => 0x121 },
	'wb_rblevelscoolwhitef' => { 194 => 0x308, 196 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 342 => 0x132 },
	'wb_rblevelscustom' => { 194 => 0x424, 196 => 0x1c },
	'wb_rblevelscwb1' => { 338 => 0x10e },
	'wb_rblevelscwb2' => { 338 => 0x10f },
	'wb_rblevelscwb3' => { 338 => 0x110 },
	'wb_rblevelscwb4' => { 338 => 0x111 },
	'wb_rblevelsdaylight' => { 194 => [0x3ec,0x528], 196 => 0xc, 215 => 0x274 },
	'wb_rblevelsdaylightf' => { 196 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 342 => 0x130 },
	'wb_rblevelsdaywhitef' => { 196 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 342 => 0x131 },
	'wb_rblevelseveningsunlight' => { 342 => 0x124 },
	'wb_rblevelsfineweather' => { 342 => 0x122 },
	'wb_rblevelsflash' => { 194 => [0x3f4,0x304], 196 => 0x18, 215 => 0x2a4 },
	'wb_rblevelsfluorescent' => { 215 => 0x290 },
	'wb_rblevelsincandescent' => { 215 => 0x282 },
	'wb_rblevelsshade' => { 194 => 0x418, 196 => 0x20, 215 => 0x2b2, 342 => 0x120 },
	'wb_rblevelstungsten' => { 194 => 0x3e8, 196 => 0x8, 342 => 0x123 },
	'wb_rblevelsused' => { 342 => 0x100 },
	'wb_rblevelswhitef' => { 196 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 342 => 0x133 },
	'wb_redlevel3500k' => { 194 => 0x198 },
	'wb_redlevel6500k' => { 194 => 0x188 },
	'wb_redlevelcustom' => { 194 => 0x18c },
	'wb_redlevelscloudy' => { 194 => 0xf8 },
	'wb_redlevelsdaylight' => { 194 => 0xdc },
	'wb_redlevelsflash' => { 194 => 0x114 },
	'wb_redlevelsfluorescent' => { 194 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 194 => 0x1be },
	'wb_redlevelsshade' => { 194 => 0x168 },
	'wb_redlevelstungsten' => { 194 => 0xc0 },
	'wb_rgbglevels' => { 213 => 0x0 },
	'wb_rgblevels' => { 194 => [0x546,0x96], 354 => 0xd, 355 => 0x413, 360 => 0x3036, 404 => 0x107, 472 => 0x117c, 473 => 0x1180, 474 => 0x115c, 475 => 0x11d8, 476 => 0x11b4, 477 => 0x106c, 478 => 0x264, 479 => 0x264, 480 => 0x252 },
	'wb_rgblevels1' => { 365 => 0x2 },
	'wb_rgblevels2' => { 365 => 0x6 },
	'wb_rgblevels2500k' => { 470 => 0x782d },
	'wb_rgblevels3' => { 365 => 0xa },
	'wb_rgblevels3200k' => { 470 => 0x782c },
	'wb_rgblevels4' => { 365 => 0xe },
	'wb_rgblevels4500k' => { 470 => [0x7484,0x7824] },
	'wb_rgblevels5' => { 365 => 0x12 },
	'wb_rgblevels6' => { 365 => 0x16 },
	'wb_rgblevels6000k' => { 470 => 0x782b },
	'wb_rgblevels7' => { 365 => 0x1a },
	'wb_rgblevels8500k' => { 470 => 0x782a },
	'wb_rgblevelsauto' => { 440 => 0x0 },
	'wb_rgblevelscloudy' => { 470 => [0x7481,0x7821] },
	'wb_rgblevelscustom1' => { 440 => 0x15 },
	'wb_rgblevelscustom2' => { 440 => 0x18 },
	'wb_rgblevelscustom3' => { 440 => 0x1b },
	'wb_rgblevelsdaylight' => { 440 => 0x3, 470 => [0x7480,0x7820] },
	'wb_rgblevelsflash' => { 440 => 0x12, 470 => [0x7483,0x7823] },
	'wb_rgblevelsfluorescent' => { 440 => 0xf, 470 => [0x7486,0x7826] },
	'wb_rgblevelsfluorescentm1' => { 470 => 0x7829 },
	'wb_rgblevelsfluorescentp1' => { 470 => 0x7827 },
	'wb_rgblevelsfluorescentp2' => { 470 => 0x7828 },
	'wb_rgblevelsincandescent' => { 440 => 0xc },
	'wb_rgblevelsovercast' => { 440 => 0x9 },
	'wb_rgblevelsshade' => { 440 => 0x6, 470 => 0x7825 },
	'wb_rgblevelstungsten' => { 470 => [0x7482,0x7822] },
	'wb_rgblevelsunknown0' => { 441 => 0x0 },
	'wb_rgblevelsunknown1' => { 441 => 0x3 },
	'wb_rgblevelsunknown2' => { 441 => 0x6 },
	'wb_rgblevelsunknown3' => { 441 => 0x9 },
	'wb_rgblevelsunknown4' => { 441 => 0xc },
	'wb_rgblevelsunknown5' => { 441 => 0xf },
	'wb_rgblevelsunknown6' => { 441 => 0x12 },
	'wb_rgblevelsunknown7' => { 441 => 0x15 },
	'wb_rgblevelsunknown8' => { 441 => 0x18 },
	'wb_rgblevelsunknown9' => { 441 => 0x1b },
	'wb_rgbmuldaylight' => { 145 => 0x852 },
	'wb_rgbmulflash' => { 145 => 0x855 },
	'wb_rgbmulfluorescent' => { 145 => 0x854 },
	'wb_rgbmultungsten' => { 145 => 0x853 },
	'wb_rggbblacklevels' => { 38 => 0x25 },
	'wb_rggblevels' => { 125 => 0x7313, 197 => 0x4, 212 => 0x0, 216 => 0x13e8, 217 => 0x38, 470 => 0x7313 },
	'wb_rggblevelsasshot' => { 41 => 0x0, 42 => 0x0, 43 => 0x19, 44 => 0x55, 45 => 0x69, 46 => 0x69, 47 => 0x22, 48 => 0x3f, 51 => 0x3f, 52 => 0x3f, 53 => 0x3f, 54 => 0x47 },
	'wb_rggblevelsauto' => { 38 => 0x1, 41 => 0x5, 42 => 0x8, 43 => 0x1e, 44 => 0x5a, 45 => 0x6e, 47 => 0x18, 48 => 0x44, 51 => 0x44, 52 => 0x44, 53 => 0x44, 54 => 0x4c, 216 => 0x1478, 217 => 0x114, 436 => 0xa022, 470 => 0x7312 },
	'wb_rggblevelsblack' => { 436 => 0xa028 },
	'wb_rggblevelscloudy' => { 38 => 0xd, 41 => 0x1e, 42 => 0x30, 43 => 0x2d, 44 => 0xa0, 45 => 0xd7, 46 => 0x78, 47 => 0x31, 48 => 0x58, 51 => 0x71, 52 => 0x8a, 53 => 0x8f, 54 => 0x92, 216 => 0x1408, 217 => 0x60, 395 => 0x20f, 403 => 0x14 },
	'wb_rggblevelscustom' => { 38 => 0x1d, 48 => 0x80, 216 => 0x1468, 217 => 0x100 },
	'wb_rggblevelscustom1' => { 43 => 0x41 },
	'wb_rggblevelscustom2' => { 43 => 0x46 },
	'wb_rggblevelsdaylight' => { 38 => 0x5, 41 => 0x14, 42 => 0x20, 43 => 0x23, 44 => 0x96, 45 => 0xcd, 46 => 0x6e, 47 => 0x27, 48 => 0x4e, 51 => 0x67, 52 => 0x80, 53 => 0x85, 54 => 0x88, 216 => 0x13f8, 217 => 0x4c, 395 => 0x20d, 403 => 0x2 },
	'wb_rggblevelsflash' => { 38 => 0x19, 41 => 0x32, 42 => 0x50, 43 => 0x3c, 44 => 0xb4, 45 => 0xeb, 46 => 0x87, 47 => 0x45, 48 => 0x6c, 51 => 0x85, 52 => 0x9e, 53 => 0xa3, 54 => 0xa6, 216 => 0x1448, 395 => 0x214, 403 => 0x41 },
	'wb_rggblevelsfluorescent' => { 38 => 0x15, 41 => 0x28, 42 => 0x40, 43 => 0x37, 44 => 0xaa, 45 => 0xe1, 46 => 0x82, 47 => 0x3b, 48 => 0x62, 51 => 0x7b, 52 => 0x94, 53 => 0x99, 54 => 0x9c },
	'wb_rggblevelsfluorescentd' => { 217 => 0xc4, 395 => 0x211, 403 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 403 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 217 => 0xb0, 395 => 0x212, 403 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 216 => 0x1438, 217 => 0x9c, 395 => 0x213, 403 => 0x38 },
	'wb_rggblevelshtmercury' => { 217 => 0xd8 },
	'wb_rggblevelsilluminator1' => { 436 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 436 => 0xa024 },
	'wb_rggblevelskelvin' => { 38 => 0x21, 41 => 0x2d, 42 => 0x48, 44 => 0xaf, 45 => 0xe6, 47 => 0x40, 48 => 0x67, 51 => 0x80, 52 => 0x99, 53 => 0x9e, 54 => 0xa1 },
	'wb_rggblevelsmeasured' => { 41 => 0xa, 42 => 0x10, 44 => 0x5f, 45 => 0x73, 48 => 0x49, 51 => 0x49, 52 => 0x49, 53 => 0x49, 54 => 0x51 },
	'wb_rggblevelspc1' => { 47 => 0x90, 48 => 0x71 },
	'wb_rggblevelspc2' => { 47 => 0x95, 48 => 0x76 },
	'wb_rggblevelspc3' => { 47 => 0x9a, 48 => 0x7b },
	'wb_rggblevelsshade' => { 38 => 0x9, 41 => 0x19, 42 => 0x28, 43 => 0x28, 44 => 0x9b, 45 => 0xd2, 46 => 0x73, 47 => 0x2c, 48 => 0x53, 51 => 0x6c, 52 => 0x85, 53 => 0x8a, 54 => 0x8d, 217 => 0x74, 395 => 0x20e, 403 => 0xb },
	'wb_rggblevelstungsten' => { 38 => 0x11, 41 => 0x23, 42 => 0x38, 43 => 0x32, 44 => 0xa5, 45 => 0xdc, 46 => 0x7d, 47 => 0x36, 48 => 0x5d, 51 => 0x76, 52 => 0x8f, 53 => 0x94, 54 => 0x97, 216 => 0x1428, 217 => 0x88, 395 => 0x210, 403 => 0x1d },
	'wb_rggblevelsuncorrected' => { 436 => 0xa021 },
	'wb_rggblevelsunknown' => { 41 => 0xf, 42 => 0x18, 44 => 0x64, 45 => 0x78, 47 => 0x1d, 51 => 0x4e, 52 => 0x4e, 53 => 0x4e, 54 => 0x56, 403 => 0x53 },
	'wb_rggblevelsunknown10' => { 41 => 0x5f, 42 => 0x98, 44 => 0x91, 45 => 0xa5, 46 => 0xb4, 47 => 0x72, 51 => 0x9e, 52 => 0x7b, 53 => 0x7b, 54 => 0x83 },
	'wb_rggblevelsunknown11' => { 41 => 0x64, 42 => 0xa0, 44 => 0xb9, 45 => [0xaa,0xaf], 46 => 0xb9, 47 => 0x77, 51 => 0xa3, 52 => 0xa3, 53 => 0x80, 54 => 0xab },
	'wb_rggblevelsunknown12' => { 41 => 0x69, 42 => 0xa8, 44 => 0xbe, 45 => 0xb4, 46 => 0xbe, 47 => 0x7c, 51 => 0xa8, 52 => 0xa8, 53 => 0xa8, 54 => 0xb0 },
	'wb_rggblevelsunknown13' => { 41 => 0x6e, 42 => 0xb0, 44 => 0xc3, 45 => 0xb9, 46 => 0xc3, 47 => 0x81, 51 => 0xad, 52 => 0xad, 53 => 0xad, 54 => 0xb5 },
	'wb_rggblevelsunknown14' => { 44 => 0xc8, 45 => 0xbe, 46 => 0xc8, 47 => 0x86, 51 => 0xb2, 52 => 0xb2, 53 => 0xb2, 54 => 0xba },
	'wb_rggblevelsunknown15' => { 44 => 0xcd, 45 => 0xc3, 46 => 0xcd, 47 => 0x8b, 51 => 0xb7, 52 => 0xb7, 53 => 0xb7, 54 => 0xbf },
	'wb_rggblevelsunknown16' => { 44 => 0xd2, 45 => 0xc8, 46 => 0xd2, 47 => 0x9f, 52 => 0xbc, 53 => 0xbc, 54 => 0xc4 },
	'wb_rggblevelsunknown17' => { 44 => 0xd7, 45 => 0xf0, 46 => 0xd7, 52 => 0xc1, 53 => 0xc1, 54 => 0xc9 },
	'wb_rggblevelsunknown18' => { 44 => 0xdc, 45 => 0xf5, 46 => 0xdc, 52 => 0xc6, 53 => 0xc6, 54 => 0xce },
	'wb_rggblevelsunknown19' => { 44 => 0xe1, 45 => 0xfa, 46 => 0xe1, 52 => 0xcb, 53 => 0xcb, 54 => 0xd3 },
	'wb_rggblevelsunknown2' => { 41 => 0x37, 42 => 0x58, 44 => 0x69, 45 => 0x7d, 46 => 0x8c, 47 => 0x4a, 51 => 0x53, 52 => 0x53, 53 => 0x53, 54 => 0x5b },
	'wb_rggblevelsunknown20' => { 44 => 0xe6, 45 => 0xff, 46 => 0xe6, 52 => 0xd0, 53 => 0xd0, 54 => 0xd8 },
	'wb_rggblevelsunknown21' => { 44 => 0xeb, 45 => 0x104, 46 => 0xeb, 53 => 0xd5, 54 => 0xdd },
	'wb_rggblevelsunknown22' => { 44 => 0xf0, 45 => 0x109, 46 => 0xf0, 53 => 0xda, 54 => 0xe2 },
	'wb_rggblevelsunknown23' => { 44 => 0xf5, 45 => 0x10e, 46 => 0xf5, 53 => 0xdf, 54 => 0xe7 },
	'wb_rggblevelsunknown24' => { 44 => 0xfa, 45 => 0x113, 46 => 0xfa, 53 => 0xe4, 54 => 0xec },
	'wb_rggblevelsunknown25' => { 44 => 0xff, 45 => 0x118, 46 => 0xff, 53 => 0xe9, 54 => 0xf1 },
	'wb_rggblevelsunknown26' => { 44 => 0x104, 45 => 0x11d, 46 => 0x104, 53 => 0xee, 54 => 0xf6 },
	'wb_rggblevelsunknown27' => { 44 => 0x109, 45 => 0x122, 46 => 0x109, 53 => 0xf3, 54 => 0xfb },
	'wb_rggblevelsunknown28' => { 44 => 0x10e, 46 => 0x10e, 53 => 0xf8, 54 => 0x100 },
	'wb_rggblevelsunknown29' => { 44 => 0x113, 46 => 0x113, 53 => 0xfd, 54 => 0x105 },
	'wb_rggblevelsunknown3' => { 41 => 0x3c, 42 => 0x60, 44 => 0x6e, 45 => 0x82, 46 => 0x91, 47 => 0x4f, 51 => 0x58, 52 => 0x58, 53 => 0x58, 54 => 0x60 },
	'wb_rggblevelsunknown30' => { 46 => 0x118, 53 => 0x102 },
	'wb_rggblevelsunknown31' => { 46 => 0x11d },
	'wb_rggblevelsunknown32' => { 46 => 0x122 },
	'wb_rggblevelsunknown33' => { 46 => 0x127 },
	'wb_rggblevelsunknown4' => { 41 => 0x41, 42 => 0x68, 44 => 0x73, 45 => 0x87, 46 => 0x96, 47 => 0x54, 51 => 0x5d, 52 => 0x5d, 53 => 0x5d, 54 => 0x65 },
	'wb_rggblevelsunknown5' => { 41 => 0x46, 42 => 0x70, 44 => 0x78, 45 => 0x8c, 46 => 0x9b, 47 => 0x59, 51 => 0x62, 52 => 0x62, 53 => 0x62, 54 => 0x6a },
	'wb_rggblevelsunknown6' => { 41 => 0x4b, 42 => 0x78, 44 => 0x7d, 45 => 0x91, 46 => 0xa0, 47 => 0x5e, 51 => 0x8a, 52 => 0x67, 53 => 0x67, 54 => 0x6f },
	'wb_rggblevelsunknown7' => { 41 => 0x50, 42 => 0x80, 44 => 0x82, 45 => 0x96, 46 => 0xa5, 47 => 0x63, 51 => 0x8f, 52 => 0x6c, 53 => 0x6c, 54 => 0x74 },
	'wb_rggblevelsunknown8' => { 41 => 0x55, 42 => 0x88, 44 => 0x87, 45 => 0x9b, 46 => 0xaa, 47 => 0x68, 51 => 0x94, 52 => 0x71, 53 => 0x71, 54 => 0x79 },
	'wb_rggblevelsunknown9' => { 41 => 0x5a, 42 => 0x90, 44 => 0x8c, 45 => 0xa0, 46 => 0xaf, 47 => 0x6d, 51 => 0x99, 52 => 0x76, 53 => 0x76, 54 => 0x7e },
	'wb_rggblevelsuserselected' => { 403 => 0x5c },
	'wbadjblueamber' => { 109 => 0x20106 },
	'wbadjbluebalance' => { 312 => 0x8 },
	'wbadjcolortemp' => { 109 => 0x20102, 114 => 0x1a },
	'wbadjlighting' => { 312 => 0x14 },
	'wbadjmagentagreen' => { 109 => 0x20105 },
	'wbadjmode' => { 312 => 0x10 },
	'wbadjredbalance' => { 312 => 0x0 },
	'wbadjrggblevels' => { 109 => 0x20125, 114 => 0x6 },
	'wbadjtemperature' => { 312 => 0x18 },
	'wbadjtint' => { 312 => 0x25 },
	'wbbluelevel' => { 353 => 0x324, 358 => 0x8006, 363 => 0x26 },
	'wbbracketingsteps' => { 208 => 0x10, 209 => 0x10, 286 => 0x174d },
	'wbbracketmode' => { 61 => 0x9 },
	'wbbracketshotnumber' => { 194 => 0x2b, 429 => 0x101a },
	'wbbracketvalueab' => { 61 => 0xc },
	'wbbracketvaluegm' => { 61 => 0xd },
	'wbbutton' => { 254 => 0x806, 257 => 0x80a },
	'wbbuttonplaybackmode' => { 330 => 0x1c5 },
	'wbfinetuneactive' => { 114 => 0x24 },
	'wbfinetunesaturation' => { 114 => 0x28 },
	'wbfinetunetone' => { 114 => 0x2c },
	'wbgreenlevel' => { 353 => 0x323, 358 => 0x8005, 363 => 0x25 },
	'wbmediaimagesizesetting' => { 90 => 0x708 },
	'wbmode' => { 196 => 0x4, 339 => 0x1015 },
	'wbredlevel' => { 353 => 0x322, 358 => 0x8004, 363 => 0x24 },
	'wbscale' => { 197 => 0x0 },
	'wbshiftab' => { 79 => 0xc, 358 => 0x46, 376 => 0x10 },
	'wbshiftab_gm' => { 463 => 0x2014 },
	'wbshiftab_gm_precise' => { 463 => 0x2026 },
	'wbshiftcreativecontrol' => { 358 => 0x92 },
	'wbshiftgm' => { 79 => 0xd, 358 => 0x47, 376 => 0x11 },
	'wbshiftintelligentauto' => { 358 => 0x8b },
	'wbtype1' => { 364 => 0x1, 365 => 0x1 },
	'wbtype2' => { 364 => 0x4, 365 => 0x5 },
	'wbtype3' => { 364 => 0x7, 365 => 0x9 },
	'wbtype4' => { 364 => 0xa, 365 => 0xd },
	'wbtype5' => { 364 => 0xd, 365 => 0x11 },
	'wbtype6' => { 364 => 0x10, 365 => 0x15 },
	'wbtype7' => { 364 => 0x13, 365 => 0x19 },
	'webstatement' => { 562 => 'WebStatement' },
	'weightedflatsubject' => { 519 => 'weightedFlatSubject' },
	'what' => { 528 => 'What', 530 => 'What' },
	'whitebalance' => { 7 => 0x6f, 8 => [0x44,0x4a], 9 => 0xbc, 10 => 0x36, 11 => 0x5e, 12 => 0x36, 13 => 0x78, 14 => 0x6f, 15 => 0x6f, 16 => 0x73, 17 => 0x6f, 18 => 0x78, 19 => 0x54, 20 => 0x6f, 21 => 0xbc, 22 => 0x7b, 24 => 0xbc, 25 => 0xc2, 27 => 0x131, 28 => 0x77, 79 => 0x8, 82 => 0x7, 118 => 0x7, 119 => [0x19,0x2012], 125 => [0xa403,0xfe4e], 133 => 0x1002, 145 => 0x3fc, 146 => 0xfa0d, 147 => 0x40, 158 => 0x1a, 188 => 0x3, 189 => 0xe, 190 => 0x4, 191 => 0xb, 193 => 0x115, 246 => 0x5, 295 => 0x7, 353 => 0x304, 358 => 0x3, 360 => 0x3033, 395 => 0x19, 402 => 0x7, 428 => 0x26, 429 => 0x1003, 439 => [0x88,0x3c,0x7,0x58], 449 => 0xf, 450 => 0xe, 463 => [0x115,0xb054], 528 => 'WhiteBalance', 530 => 'WhiteBalance', 534 => 'WhiteBalance' },
	'whitebalance0' => { 183 => 'WhiteBalance0' },
	'whitebalance1' => { 183 => 'WhiteBalance1' },
	'whitebalance2' => { 183 => 'WhiteBalance2', 334 => 0x500 },
	'whitebalanceadj' => { 109 => 0x20101, 114 => 0x18, 306 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 371 => 0x0 },
	'whitebalancebias' => { 119 => 0x2011, 339 => 0x304, 358 => 0x23 },
	'whitebalanceblue' => { 79 => 0x7 },
	'whitebalancebracket' => { 334 => 0x502, 339 => 0x303 },
	'whitebalancebracketing' => { 191 => 0x22, 194 => 0x2c, 460 => 0x2c },
	'whitebalancebuttonplaybackmode' => { 331 => 0x1c5, 332 => 0x1dd },
	'whitebalancecomp' => { 342 => 0x1001 },
	'whitebalancedetected' => { 145 => 0x3fb },
	'whitebalancefinetune' => { 133 => 0x100a, 191 => 0x38, 193 => 0x112, 246 => [0xb,0x3f], 429 => 0x1004, 449 => 0x6, 450 => 0x5, 463 => 0x112 },
	'whitebalancemode' => { 145 => 0x3fa, 395 => 0x1a },
	'whitebalancered' => { 79 => 0x6 },
	'whitebalanceset' => { 375 => 0xa },
	'whitebalancesetting' => { 191 => 0x23, 449 => 0x5, 450 => 0x4, 451 => 0x16, 468 => 0xd },
	'whitebalancesetup' => { 436 => 0x41 },
	'whitebalancetemperature' => { 334 => 0x501 },
	'whiteboard' => { 339 => 0x301 },
	'whitelevel' => { 125 => 0xc61d, 395 => 0x7e, 470 => 0x787f },
	'whitepoint' => { 125 => 0x13e, 357 => 0x35d, 395 => 0x201, 554 => 'WhitePoint' },
	'whites2012' => { 528 => 'Whites2012', 530 => 'Whites2012' },
	'whitesadj' => { 500 => 0x9017 },
	'wideadapter' => { 429 => 0x1017 },
	'widefocuszone' => { 188 => 0x2f },
	'widerange' => { 438 => 0x20f },
	'windmode' => { 145 => 0x3f4 },
	'windnoisereduction' => { 252 => 0x352, 255 => 0x2d6, 256 => 0x2fe, 257 => 0x2fe },
	'windowlocation' => { 421 => 'WLOC' },
	'windowsatom' => { 529 => 'windowsAtom' },
	'windowsatomextension' => { 529 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 529 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 529 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 548 => 'wordCount' },
	'work' => { 413 => "\xa9wrk" },
	'workcolorspace' => { 109 => 0x10200, 114 => 0x270 },
	'workflowtag' => { 542 => 'WorkflowTag' },
	'workflowtagcvid' => { 542 => [\'WorkflowTag','WorkflowTagCvId'] },
	'workflowtagcvtermid' => { 542 => [\'WorkflowTag','WorkflowTagCvTermId'] },
	'workflowtagcvtermname' => { 542 => [\'WorkflowTag','WorkflowTagCvTermName'] },
	'workflowtagcvtermrefinedabout' => { 542 => [\'WorkflowTag','WorkflowTagCvTermRefinedAbout'] },
	'worktodo' => { 536 => 'WorkToDo' },
	'worldtimelocation' => { 358 => 0x3a, 395 => 0x22, 401 => '0.1' },
	'writer' => { 186 => 'WM/Writer' },
	'writer-editor' => { 138 => 0x7a },
	'x3filllight' => { 439 => 0x12 },
	'xattrmditemwherefroms' => { 181 => 'com.apple.metadata:kMDItemWhereFroms' },
	'xattrquarantine' => { 181 => 'com.apple.quarantine' },
	'xiaomiexifinfo' => { 415 => 'xiaomi.exifInfo.videoinfo' },
	'xiaomihdr10' => { 415 => 'com.xiaomi.hdr10' },
	'xiaomimodel' => { 125 => 0x9a00 },
	'xiaomipreviewvideocover' => { 415 => 'com.xiaomi.preview_video_cover' },
	'xiaomisettings' => { 125 => 0x9999 },
	'xilinxversion' => { 145 => 0x414 },
	'xml' => { 143 => 'xml ' },
	'xmp' => { 112 => 0xffff00f6, 126 => 'XMP', 136 => 'XMP Data/XMP' },
	'xmptoolkit' => { 555 => 'xmptk' },
	'xpauthor' => { 125 => 0x9c9d },
	'xpcomment' => { 125 => 0x9c9c },
	'xpkeywords' => { 125 => 0x9c9e },
	'xposition' => { 125 => 0x11e },
	'xpsubject' => { 125 => 0x9c9f },
	'xptitle' => { 125 => 0x9c9b },
	'xresolution' => { 125 => 0x11a, 141 => 0x3, 410 => 0x0, 554 => 'XResolution' },
	'xyresolution' => { 129 => 0x3 },
	'yaw' => { 121 => 0x7, 421 => ['_yaw',"\xa9fyw"] },
	'yawangle' => { 262 => 0x8, 434 => 0x0 },
	'ycbcrcoefficients' => { 125 => 0x211, 554 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 125 => 0x213, 554 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 125 => 0x212, 554 => 'YCbCrSubSampling' },
	'year' => { 413 => 'yrrc', 415 => 'year', 421 => 'yrrc' },
	'yearcreated' => { 147 => 0x10, 156 => 0xc },
	'yellowhsl' => { 109 => 0x20912 },
	'yield' => { 550 => 'yield' },
	'yposition' => { 125 => 0x11f },
	'yresolution' => { 125 => 0x11b, 141 => 0x5, 410 => 0x4, 554 => 'YResolution' },
	'zebrapatterntonerange' => { 330 => 0x211, 331 => 0x211, 332 => 0x229 },
	'zoneidentifier' => { 126 => 'ZoneIdentifier' },
	'zonematching' => { 193 => 0x10a, 196 => [0x3a,0x4a], 463 => 0xb024 },
	'zonematchingmode' => { 191 => 0x14 },
	'zonematchingon' => { 190 => 0x75 },
	'zonematchingvalue' => { 449 => 0x1f },
	'zoomedpreviewlength' => { 339 => 0xf05 },
	'zoomedpreviewsize' => { 339 => 0xf06 },
	'zoomedpreviewstart' => { 339 => 0xf04 },
	'zoomsourcewidth' => { 37 => 0x24 },
	'zoomstepcount' => { 337 => 0x300, 339 => 0x100d },
	'zoomtargetwidth' => { 37 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_misb' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accel360fly' => 1,
	'acceldata' => 1,
	'accelerometermatrix' => 1,
	'accelerometertime' => 1,
	'accelerometerunknown' => 1,
	'accelmode' => 1,
	'accelypr' => 1,
	'accessdate' => 1,
	'accessrights' => 1,
	'accompaniment' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acdsee-rs' => 1,
	'acidizer' => 1,
	'acidizerflags' => 1,
	'acnespotremoval' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'activebuf1cols' => 1,
	'activebuf1rows' => 1,
	'activebuf2cols' => 1,
	'activebuf2rows' => 1,
	'activecols' => 1,
	'activectemonitor1cols' => 1,
	'activectemonitor2cols' => 1,
	'activectemonitorrows' => 1,
	'activerows' => 1,
	'actor' => 1,
	'actors' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'actualsoftpostpadding' => 1,
	'actualsoftprepadding' => 1,
	'additionalinfo' => 1,
	'adjdebuginfo' => 1,
	'adjustedtbnimageheight' => 1,
	'adjustedtbnimagewidth' => 1,
	'adjustmentdata' => 1,
	'adjustmentssettingsstatisticslightmap' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aedebuginfo' => 1,
	'aeflags' => 1,
	'aehistograminfo' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'aeliveviewhistograminfo' => 1,
	'aeliveviewlocalhistogram' => 1,
	'aelocalhistogram' => 1,
	'af' => 1,
	'af-cprioritysel' => 1,
	'af-sprioritysel' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afcsettings' => 1,
	'afdebuginfo' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afpointsspecial' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aibuildnumber' => 1,
	'aicolormodel' => 1,
	'aicolorusage' => 1,
	'aicreatorversion' => 1,
	'aifileformat' => 1,
	'aimetadata' => 1,
	'ainumlayers' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'airfieldbarometricpressure' => 1,
	'airfieldelevation' => 1,
	'airspeed' => 1,
	'airtemperature' => 1,
	'airulerunits' => 1,
	'aistream' => 1,
	'aitargetresolution' => 1,
	'album2' => 1,
	'albumartistsortorder' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitlesortorder' => 1,
	'alerts' => 1,
	'alexa' => 1,
	'alexa-paireddevicename' => 1,
	'alexa-pairing' => 1,
	'alexa-privacymode' => 1,
	'alexa-wakewordlanguage' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaisused' => 1,
	'alphamask' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternatealtitude' => 1,
	'alternateduotonecolors' => 1,
	'alternateellipsoidheight' => 1,
	'alternateellipsoidheightextended' => 1,
	'alternateformattrack' => 1,
	'alternateheading' => 1,
	'alternatelatitude' => 1,
	'alternatelongitude' => 1,
	'alternatename' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'altitudefromtakeoff' => 1,
	'ambienceinfo' => 1,
	'ambisonicchannelmap' => 1,
	'ambisonicchannelordering' => 1,
	'ambisonicchannels' => 1,
	'ambisonicnormalization' => 1,
	'ambisonicorder' => 1,
	'ambisonictype' => 1,
	'amendlocalset' => 1,
	'angleaxis' => 1,
	'angleofattack' => 1,
	'angularvelocity' => 1,
	'anim' => 1,
	'animation' => 1,
	'animationcontrol' => 1,
	'animationframes' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'animationplays' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anoiselines' => 1,
	'anta' => 1,
	'apdi' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'appledataoffsets' => 1,
	'applemaildatereceived' => 1,
	'applemaildatesent' => 1,
	'applemailflagged' => 1,
	'applemailisremoteattachment' => 1,
	'applemailmessageid' => 1,
	'applemailpriority' => 1,
	'applemailread' => 1,
	'applemailrepliedto' => 1,
	'application' => 1,
	'application_riff' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationunknown' => 1,
	'applicationversion' => 1,
	'applysettingstoliveview' => 1,
	'appname' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'arcoreaccel' => 1,
	'arcoreaccel0' => 1,
	'arcorecustom' => 1,
	'arcoregyro' => 1,
	'arcoregyro0' => 1,
	'arcorevideo' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artists' => 1,
	'artisturl' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiounwarped' => 1,
	'aspectratiowarped' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantdirector' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'associateddatalist' => 1,
	'associatedimagefile' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'ast' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'atob3' => 1,
	'atom0' => 1,
	'atsccontent' => 1,
	'attachments' => 1,
	'attitude' => 1,
	'attitudetarget' => 1,
	'attr' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobluetooth' => 1,
	'audiobytes' => 1,
	'audiochannellayout' => 1,
	'audiochanneltypes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiokeys' => 1,
	'audiolayer' => 1,
	'audiolevel' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioprotuneoption' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosetting' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoridentifier' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorname' => 1,
	'authors' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'autoareaafstartingpoint' => 1,
	'autoboostscore' => 1,
	'autocaptureoffset' => 1,
	'autoisomin' => 1,
	'autolowlightduration' => 1,
	'automationanimation' => 1,
	'automationflags' => 1,
	'autopoweroff' => 1,
	'autoprotune' => 1,
	'autorotation' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'auxiliaryimageref' => 1,
	'av1configuration' => 1,
	'av1configurationversion' => 1,
	'avcconfiguration' => 1,
	'averagebitrate' => 1,
	'averageframerate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbdebuginfo' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'axml' => 1,
	'b1' => 1,
	'b2' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barcodes' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'basename' => 1,
	'baseviewpointnum' => 1,
	'basicfileinfo' => 1,
	'basisobject' => 1,
	'battery' => 1,
	'batterycapacity' => 1,
	'batterycurrent' => 1,
	'batteryinfo' => 1,
	'batterystatus' => 1,
	'batterytime' => 1,
	'batteryvoltage3' => 1,
	'batteryvoltage4' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats' => 1,
	'beats-per-minute' => 1,
	'beautycolorlevel' => 1,
	'beautyenable' => 1,
	'beautyretouchlevel' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'bibliographicreferences' => 1,
	'bikebroaccel' => 1,
	'bikebrogps' => 1,
	'billinginformation' => 1,
	'binarydata' => 1,
	'binarydatatype' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'binning' => 1,
	'birthday' => 1,
	'bitdepthchroma' => 1,
	'bitdepthluma' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitratesetting' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackadcountsperdacvolt' => 1,
	'blackclamp' => 1,
	'blackclampoffset' => 1,
	'blackcolsleft' => 1,
	'blackcolsright' => 1,
	'blackdacchannel' => 1,
	'blackdacsettlingmsec' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blackrowsbottom' => 1,
	'blackrowstop' => 1,
	'blacktarget' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'blueendpoint' => 1,
	'bluegain' => 1,
	'bluegrassscale1' => 1,
	'bluegrassscale2' => 1,
	'bluegrasstable' => 1,
	'bluemask' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetoothmacaddress' => 1,
	'bluetoothname' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'blurstrength' => 1,
	'blush' => 1,
	'bmpversion' => 1,
	'boardtemperature' => 1,
	'body' => 1,
	'bokehshape' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottomdarkrow1' => 1,
	'bottomdarkrow2' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bpm' => 1,
	'bps' => 1,
	'bracketingburstoptions' => 1,
	'bracketingcounter' => 1,
	'bracketingmode' => 1,
	'bracketingoffset' => 1,
	'bracketingstep' => 1,
	'bracketshot' => 1,
	'brain' => 1,
	'brandingimageid' => 1,
	'brandingname' => 1,
	'brdfatob0' => 1,
	'brdfatob1' => 1,
	'brdfatob2' => 1,
	'brdfatob3' => 1,
	'brdfbtoa0' => 1,
	'brdfbtoa1' => 1,
	'brdfbtoa2' => 1,
	'brdfbtoa3' => 1,
	'brdfbtod0' => 1,
	'brdfbtod1' => 1,
	'brdfbtod2' => 1,
	'brdfbtod3' => 1,
	'brdfcolorimetricparam0' => 1,
	'brdfcolorimetricparam1' => 1,
	'brdfcolorimetricparam2' => 1,
	'brdfcolorimetricparam3' => 1,
	'brdfdtob0' => 1,
	'brdfdtob1' => 1,
	'brdfdtob2' => 1,
	'brdfdtob3' => 1,
	'brdfmtob0' => 1,
	'brdfmtob1' => 1,
	'brdfmtob2' => 1,
	'brdfmtob3' => 1,
	'brdfmtos0' => 1,
	'brdfmtos1' => 1,
	'brdfmtos2' => 1,
	'brdfmtos3' => 1,
	'brdfspectralparam0' => 1,
	'brdfspectralparam1' => 1,
	'brdfspectralparam2' => 1,
	'brdfspectralparam3' => 1,
	'breakchar' => 1,
	'briefdescription' => 1,
	'brightdefectintegrationms' => 1,
	'brightdefectisocode' => 1,
	'brightdefectthreshold' => 1,
	'brightnessdata' => 1,
	'brightrowstop' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'brotliexif' => 1,
	'brotlijumb' => 1,
	'brotlixmp' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btoa3' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwf_umid' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'byteordermark' => 1,
	'byterange' => 1,
	'bytes' => 1,
	'bytesperline' => 1,
	'bytesperminute' => 1,
	'c2pa' => 1,
	'c2pasalthash' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'cafpointinfo' => 1,
	'cafpointsinfocus' => 1,
	'cafpointsselected' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'calibrationlog' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'callsign' => 1,
	'camcore' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameraifd' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraoperator' => 1,
	'camerapan' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'cameratemperaturemaxclip' => 1,
	'cameratemperaturemaxsaturated' => 1,
	'cameratemperaturemaxwarn' => 1,
	'cameratemperatureminclip' => 1,
	'cameratemperatureminsaturated' => 1,
	'cameratemperatureminwarn' => 1,
	'cameratilt' => 1,
	'camm0' => 1,
	'camm1' => 1,
	'camm2' => 1,
	'camm3' => 1,
	'camm4' => 1,
	'camm5' => 1,
	'camm6' => 1,
	'camm7' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfog5xii' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfor6' => 1,
	'canoncamerainfor6m2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncctp' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedelaytimer' => 1,
	'capturedevicefid' => 1,
	'captureheightresetblacksegnormal' => 1,
	'captureheightresetblacksegtest' => 1,
	'captureheighttest' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturewidthresetblacksegnormal' => 1,
	'capturewidthresetblacksegtest' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'car' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'catalognumber' => 1,
	'caveats' => 1,
	'cbor' => 1,
	'cbordata' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdi1' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfagreenthreshold1' => 1,
	'cfagreenthreshold2' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channel01' => 1,
	'channel01description' => 1,
	'channel01dispmax' => 1,
	'channel01dispmin' => 1,
	'channel01flags' => 1,
	'channel01id' => 1,
	'channel01interval' => 1,
	'channel01max' => 1,
	'channel01min' => 1,
	'channel01multiplier' => 1,
	'channel01name' => 1,
	'channel01num' => 1,
	'channel01offset' => 1,
	'channel01type' => 1,
	'channel01units' => 1,
	'channel0lagkernel' => 1,
	'channel1coordinates' => 1,
	'channel1flags' => 1,
	'channel1label' => 1,
	'channel1lagkernel' => 1,
	'channel2coordinates' => 1,
	'channel2flags' => 1,
	'channel2label' => 1,
	'channel2lagkernel' => 1,
	'channel3coordinates' => 1,
	'channel3flags' => 1,
	'channel3label' => 1,
	'channel3lagkernel' => 1,
	'channel4coordinates' => 1,
	'channel4flags' => 1,
	'channel4label' => 1,
	'channel5coordinates' => 1,
	'channel5flags' => 1,
	'channel5label' => 1,
	'channel6coordinates' => 1,
	'channel6flags' => 1,
	'channel6label' => 1,
	'channel7coordinates' => 1,
	'channel7flags' => 1,
	'channel7label' => 1,
	'channel8coordinates' => 1,
	'channel8flags' => 1,
	'channel8label' => 1,
	'channelcoarsegainadjust' => 1,
	'channelcolordata' => 1,
	'channelcolorindicates' => 1,
	'channelcolorspace' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelopacity' => 1,
	'channeloptions' => 1,
	'channelusage' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'character' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'checksum' => 1,
	'children' => 1,
	'chmversion' => 1,
	'choregrapher' => 1,
	'chromaformat' => 1,
	'chromasampleposition' => 1,
	'chromaticaberrationparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chrominancetable' => 1,
	'chunkcount' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'churchillnav' => 1,
	'cicodepoints' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classificationandmarkingsystem' => 1,
	'classificationcomments' => 1,
	'classificationdatapresent' => 1,
	'classificationreason' => 1,
	'classifiedby' => 1,
	'classifyingcountry' => 1,
	'classifyingcountrycodemethod' => 1,
	'classifyingcountrycodingmethoddate' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'closedcaptiontrack' => 1,
	'cmddialsaperturesetting' => 1,
	'cmddialschangemainsub' => 1,
	'cmddialschangemainsubexposure' => 1,
	'cmddialsmenuandplayback' => 1,
	'cmddialsreverserotexposurecomp' => 1,
	'cmmflags' => 1,
	'cmp1' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantinfoout' => 1,
	'colorantorder' => 1,
	'colorantorderout' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalance0219' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown1' => 1,
	'colorbalanceunknown2' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalib2' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcoefs2' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata10' => 1,
	'colordata11' => 1,
	'colordata12' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordata9' => 1,
	'colordataunknown' => 1,
	'colorencodingparams' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetricspecification' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorpopstrength' => 1,
	'colorprimaries' => 1,
	'colorprofiles' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspacename' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortemperatures' => 1,
	'colortransferfuncs' => 1,
	'colortransferfunction' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'columncount' => 1,
	'columngainfactors' => 1,
	'columnresetoffsets' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentby' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblefontname' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'componenttable' => 1,
	'composernationality' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositeimaginglocalset' => 1,
	'compositinglayerheader' => 1,
	'compositionlocation' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressioncodecs' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductors' => 1,
	'confidencemapimage' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'constantframerate' => 1,
	'constraintindicatorflags' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerversion' => 1,
	'contentbranding' => 1,
	'contentdescribes' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributorduration' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentlightlevel' => 1,
	'contentprotected' => 1,
	'contentprotectedpercent' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstatus' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastdetectaf' => 1,
	'contrastinfo' => 1,
	'controller' => 1,
	'controllevel' => 1,
	'conttake' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'coordinateunits' => 1,
	'coproducer' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coringtablebest' => 1,
	'coringtablebetter' => 1,
	'coringtablegood' => 1,
	'cornerlatitude1' => 1,
	'cornerlatitude2' => 1,
	'cornerlatitude3' => 1,
	'cornerlatitude4' => 1,
	'cornerlongitude1' => 1,
	'cornerlongitude2' => 1,
	'cornerlongitude3' => 1,
	'cornerlongitude4' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coyotesense' => 1,
	'coyotestatus' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'cr2cfapattern' => 1,
	'crc' => 1,
	'crcdevelparams' => 1,
	'crd' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapp' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatormodule' => 1,
	'creatoros' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'crgbtoerimm0spline' => 1,
	'crgbtoerimm1spline' => 1,
	'crgbtoerimm2spline' => 1,
	'crgbtoerimm3spline' => 1,
	'crgbtoerimm4spline' => 1,
	'crgbtoerimm5spline' => 1,
	'crgbtoerimm6spline' => 1,
	'crgbtoerimm7spline' => 1,
	'crgbtoerimm8spline' => 1,
	'crgbtoerimm9spline' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossbarenable' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs0' => 1,
	'cs1' => 1,
	'ctmd' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepointlabel' => 1,
	'cuepointnote' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'custominfo' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd90' => 1,
	'customsettingsoffset' => 1,
	'customsettingsz6iii' => 1,
	'customsettingsz8' => 1,
	'customsettingsz9' => 1,
	'customsettingsz9v4' => 1,
	'customtostandardpcc' => 1,
	'cxf' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'd2' => 1,
	'daccountspervolt' => 1,
	'dacgainscoarse' => 1,
	'dacgainscoarseadjpreif41' => 1,
	'dacgainsfine' => 1,
	'dacvoltages' => 1,
	'dacvoltagesflush' => 1,
	'darkcircle' => 1,
	'darkcorrectiontype' => 1,
	'darkmapscale' => 1,
	'darkrefoffsetnormal' => 1,
	'darkrefoffsettest' => 1,
	'darkthreshold' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datasize64' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'date1' => 1,
	'date2' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateencoded' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datepurchased' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetagged' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'datewritten' => 1,
	'daymat0' => 1,
	'daymat1' => 1,
	'daymat2' => 1,
	'daymat3' => 1,
	'daymat4' => 1,
	'daymat5' => 1,
	'daymat6' => 1,
	'daymat7' => 1,
	'daymat8' => 1,
	'daymat9' => 1,
	'db' => 1,
	'dblcoldcacthres1' => 1,
	'dblcoldcacthres2' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dcs3xxprocessinginfo' => 1,
	'dcs3xxprocessinginfoifd' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'declassificationdate' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultcmyk' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultsettings' => 1,
	'defaultstyle' => 1,
	'defectconcealartcorrectthres' => 1,
	'defectconcealthrestable' => 1,
	'defectcount' => 1,
	'defectlist' => 1,
	'defectlistpacked' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'delaycols' => 1,
	'delaytime' => 1,
	'delimiter' => 1,
	'delta12to8spline' => 1,
	'delta8to12spline' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'densityaltitude' => 1,
	'densityaltitudeextended' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'depthhwheight' => 1,
	'depthhwwidth' => 1,
	'depthmapdata' => 1,
	'depthmapdata2' => 1,
	'depthmapheight' => 1,
	'depthmapimage' => 1,
	'depthmapname' => 1,
	'depthmaptiff' => 1,
	'depthmapwidth' => 1,
	'depthswheight' => 1,
	'depthswwidth' => 1,
	'derivedimageref' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detectedfacebounds' => 1,
	'detectedfaceid' => 1,
	'detectedfacerollangle' => 1,
	'detectedfaceyawangle' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicecontainer' => 1,
	'deviceid' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'deviceorientation' => 1,
	'devicesettings' => 1,
	'devicesounds' => 1,
	'dex' => 1,
	'diagonalfieldofview' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'differentialpressure' => 1,
	'difftilegains24t852822' => 1,
	'difftilegains602832' => 1,
	'digestalgorithm' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalexposurebiases' => 1,
	'digitalexposuregains' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'digitalzoomamount' => 1,
	'dimensions' => 1,
	'directionalatob0' => 1,
	'directionalatob1' => 1,
	'directionalatob2' => 1,
	'directionalatob3' => 1,
	'directionalbtoa0' => 1,
	'directionalbtoa1' => 1,
	'directionalbtoa2' => 1,
	'directionalbtoa3' => 1,
	'directionalbtod0' => 1,
	'directionalbtod1' => 1,
	'directionalbtod2' => 1,
	'directionalbtod3' => 1,
	'directionaldtob0' => 1,
	'directionaldtob1' => 1,
	'directionaldtob2' => 1,
	'directionaldtob3' => 1,
	'directorofphotography' => 1,
	'directors' => 1,
	'disableflagspresent' => 1,
	'discardobjects' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distance' => 1,
	'distancefromhome' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'dji-dbg' => 1,
	'dji_dtat' => 1,
	'djidebug' => 1,
	'djimetadata' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'dmeroderadius' => 1,
	'dmfillrejthresh' => 1,
	'dmnoisescale' => 1,
	'dmnumpatches' => 1,
	'dmpixelthresholdfactor' => 1,
	'dmsmoothrejthresh' => 1,
	'dmtrimfraction' => 1,
	'dmwindowthresholdfactor' => 1,
	'docclass' => 1,
	'docflags' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'docversion' => 1,
	'dof' => 1,
	'domain' => 1,
	'donotshow' => 1,
	'dop' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'downsampleby2hor' => 1,
	'downsampleby2hor3mpdcr' => 1,
	'downsampleby2ver' => 1,
	'downsampleby2ver3mpdcr' => 1,
	'downsampleby3hor' => 1,
	'downsampleby3ver' => 1,
	'downsampleby4hor' => 1,
	'downsampleby4ver' => 1,
	'downsampleby6hor' => 1,
	'downsampleby6ver' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivesettings' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'drone-dji' => 1,
	'droneinfo' => 1,
	'dronepitch' => 1,
	'dronequaternion' => 1,
	'droneroll' => 1,
	'droneyaw' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'dtvcontent' => 1,
	'dualcameraimage' => 1,
	'dualcameraimagename' => 1,
	'dualfiles' => 1,
	'dualshotextra' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'dummycolsleft' => 1,
	'dummycolsright' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'durationsetting' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'dynamicranger128' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edgespline' => 1,
	'edgesplinehigh' => 1,
	'edgesplinelow' => 1,
	'edgesplinemed' => 1,
	'edit4data' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'ef' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectstrength' => 1,
	'effectsvisible' => 1,
	'effecttype' => 1,
	'eighteenpercentpoint' => 1,
	'eighthlanguage' => 1,
	'electricalextendermagnification' => 1,
	'electronicimagestabilization' => 1,
	'electronicstabilizationon' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimage2' => 1,
	'embeddedimageclass' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagerectangle' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedjpg' => 1,
	'embeddedpng' => 1,
	'embeddedvideo' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emergencysos' => 1,
	'emphasis' => 1,
	'empty' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encodetime' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endianness' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'erimmnonlinearityspline' => 1,
	'erimmtocrgb0spline' => 1,
	'erimmtocrgb1spline' => 1,
	'erimmtocrgb2spline' => 1,
	'erimmtocrgb3spline' => 1,
	'erimmtocrgb4spline' => 1,
	'erimmtocrgb5spline' => 1,
	'erimmtocrgb6spline' => 1,
	'erimmtocrgb7spline' => 1,
	'erimmtocrgb8spline' => 1,
	'erimmtocrgb9spline' => 1,
	'erimmtonescale0spline' => 1,
	'erimmtonescale1spline' => 1,
	'erimmtonescale2spline' => 1,
	'erimmtonescale3spline' => 1,
	'erimmtonescale4spline' => 1,
	'erimmtonescale5spline' => 1,
	'erimmtonescale6spline' => 1,
	'erimmtonescale7spline' => 1,
	'erimmtonescale8spline' => 1,
	'erimmtonescale9spline' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escapestatus' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'et' => 1,
	'evalstate' => 1,
	'eventlogcapture' => 1,
	'eventlogprocess' => 1,
	'events' => 1,
	'eventstarttime' => 1,
	'evstepinfo' => 1,
	'exefilename' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exififd' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinfo7' => 1,
	'exifinfo8' => 1,
	'exifinfo9' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expirationspan' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureheadroomfactor' => 1,
	'exposureinfo' => 1,
	'exposurereferencegain' => 1,
	'exposurereferenceoffset' => 1,
	'exposuretimes' => 1,
	'exposuretype' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedalbumname' => 1,
	'extendedartistname' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedlanguagetag' => 1,
	'extendedstreamprops' => 1,
	'extendedtracktitle' => 1,
	'extendedxmp' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'extraticklocations' => 1,
	'extremeweathermode' => 1,
	'eyebrows' => 1,
	'eyeenlarge' => 1,
	'f-stop' => 1,
	'f_' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetected' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'faceitem' => 1,
	'facenumbers' => 1,
	'facepos' => 1,
	'facerec' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'faceslimming' => 1,
	'factorywhitegainsdaylight' => 1,
	'factorywhiteoffsetsdaylight' => 1,
	'farklewhitethreshold' => 1,
	'fastseek' => 1,
	'fax' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fcc-id' => 1,
	'fdsc' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileguid' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterparametersbinary' => 1,
	'filterparameterscustomcustomdata' => 1,
	'filterparametersexportexportdata' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalflushsequence' => 1,
	'finalframeblocks' => 1,
	'finetune' => 1,
	'finishedfileprocessingrequest' => 1,
	'finishipaversion' => 1,
	'finishipfversion' => 1,
	'firmwareinfo' => 1,
	'firmwareversion51' => 1,
	'firmwareversion56' => 1,
	'firstchar' => 1,
	'firstflushsequence' => 1,
	'firstlanguage' => 1,
	'firstlines' => 1,
	'firstlinetransfertiming' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0106' => 1,
	'flashinfo0107' => 1,
	'flashinfo0300' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashmat0' => 1,
	'flashmat1' => 1,
	'flashmat2' => 1,
	'flashmat3' => 1,
	'flashmat4' => 1,
	'flashmat5' => 1,
	'flashmat6' => 1,
	'flashmat7' => 1,
	'flashmat8' => 1,
	'flashmat9' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashused' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flightdegree' => 1,
	'flightspeed' => 1,
	'flipstatus' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'flirdata' => 1,
	'fluormat0' => 1,
	'fluormat1' => 1,
	'fluormat2' => 1,
	'fluormat3' => 1,
	'fluormat4' => 1,
	'fluormat5' => 1,
	'fluormat6' => 1,
	'fluormat7' => 1,
	'fluormat8' => 1,
	'fluormat9' => 1,
	'flushtiming' => 1,
	'flyingstate' => 1,
	'focalinfo' => 1,
	'focallength35efl' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusedgemap' => 1,
	'focusframesize' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspointbrightness' => 1,
	'focuspointselectionspeed' => 1,
	'focuspos' => 1,
	'focussettings' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'follow-meanimation' => 1,
	'follow-memode' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'forcedsubtitletrack' => 1,
	'form' => 1,
	'formatsdcard' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fps' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framebaseview' => 1,
	'framecenterelevation' => 1,
	'framecenterheightaboveellipsoid' => 1,
	'framecenterlatitude' => 1,
	'framecenterlongitude' => 1,
	'framedelay' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'frameview' => 1,
	'framinggriddisplay' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fuelremaining' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullangleofattack' => 1,
	'fullname' => 1,
	'fullpitchangle' => 1,
	'fullrollangle' => 1,
	'fullscreen' => 1,
	'fullsideslipangle' => 1,
	'fusion360fly' => 1,
	'fusionmode' => 1,
	'fusionypr' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gainmapimage' => 1,
	'gammablue' => 1,
	'gammagreen' => 1,
	'gammainfo' => 1,
	'gammared' => 1,
	'gammatable' => 1,
	'gamut' => 1,
	'gamutboundarydescription0' => 1,
	'gamutboundarydescription1' => 1,
	'gamutboundarydescription2' => 1,
	'gamutboundarydescription3' => 1,
	'gapless' => 1,
	'garmingps' => 1,
	'garminmodel' => 1,
	'gaudio' => 1,
	'gaussianweights' => 1,
	'gcamera' => 1,
	'gcontainer' => 1,
	'gcreations' => 1,
	'gdepth' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generalencapsulatedobject' => 1,
	'generallevelidc' => 1,
	'generalprofileidc' => 1,
	'generalprofilespace' => 1,
	'generaltierflag' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genericflagdata01' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genprofilecompatibilityflags' => 1,
	'genr' => 1,
	'geo' => 1,
	'geob-data' => 1,
	'geob-desc' => 1,
	'geob-file' => 1,
	'geob-mime' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geolocationbearing' => 1,
	'geolocationcity' => 1,
	'geolocationcountry' => 1,
	'geolocationcountrycode' => 1,
	'geolocationdistance' => 1,
	'geolocationfeaturecode' => 1,
	'geolocationfeaturetype' => 1,
	'geolocationpopulation' => 1,
	'geolocationposition' => 1,
	'geolocationregion' => 1,
	'geolocationsubregion' => 1,
	'geolocationtimezone' => 1,
	'geolocationwarning' => 1,
	'geometricdistortionparams' => 1,
	'georegistrationlocalset' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gfocus' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gimage' => 1,
	'gimbaldegree' => 1,
	'gimbalinfo' => 1,
	'gimbalpitch' => 1,
	'gimbalroll' => 1,
	'gimbalyaw' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'gkudata' => 1,
	'glamoursettings' => 1,
	'globalinfo' => 1,
	'globalpalette' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'google' => 1,
	'googlebot' => 1,
	'gopro' => 1,
	'goprogpmf' => 1,
	'gpano' => 1,
	'gpmd_fmas' => 1,
	'gpmd_gopro' => 1,
	'gpmd_kingslim' => 1,
	'gpmd_rove' => 1,
	'gpmd_wolfbox' => 1,
	'gps' => 1,
	'gps360fly' => 1,
	'gpsaltituderaw' => 1,
	'gpsaltitudesystem' => 1,
	'gpsdata' => 1,
	'gpsdatalist' => 1,
	'gpsdatalist2' => 1,
	'gpsdatetimeraw' => 1,
	'gpsdestaltitude' => 1,
	'gpsframingaltitude' => 1,
	'gpsframinglatitude' => 1,
	'gpsframinglongitude' => 1,
	'gpshomelatitude' => 1,
	'gpshomelongitude' => 1,
	'gpshorizontalaccuracy' => 1,
	'gpsinfo' => 1,
	'gpsinfo9' => 1,
	'gpslatitude2' => 1,
	'gpslatituderaw' => 1,
	'gpslog' => 1,
	'gpslongitude2' => 1,
	'gpslongituderaw' => 1,
	'gpsmode' => 1,
	'gpspos' => 1,
	'gpsraw' => 1,
	'gpsspeed3d' => 1,
	'gpsspeedaccuracy' => 1,
	'gpsspeedraw' => 1,
	'gpsspeedx' => 1,
	'gpsspeedy' => 1,
	'gpsspeedz' => 1,
	'gpsstamp' => 1,
	'gpstargetaltitude' => 1,
	'gpstargetlatitude' => 1,
	'gpstargetlongitude' => 1,
	'gpstrackraw' => 1,
	'gpsvalid' => 1,
	'gpsvelocitydown' => 1,
	'gpsvelocityeast' => 1,
	'gpsvelocitynorth' => 1,
	'gpsvelocityup' => 1,
	'gpsverticalaccuracy' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'gravityvector' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greenendpoint' => 1,
	'greengain' => 1,
	'greenmask' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'gridsize' => 1,
	'groundrange' => 1,
	'groupareac1' => 1,
	'groupcaption' => 1,
	'groupmutualexclusion' => 1,
	'groups' => 1,
	'gsensor' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'guano' => 1,
	'gyro360fly' => 1,
	'gyromode' => 1,
	'gyroscope' => 1,
	'gyroscopeunknown' => 1,
	'gyroypr' => 1,
	'halftonedegree' => 1,
	'halftonelpi' => 1,
	'halftonelpiunit' => 1,
	'halftonemisc' => 1,
	'halftonescreen' => 1,
	'halftoneshape' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hardpostpadding' => 1,
	'hardprepadding' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasselbladexif' => 1,
	'hasselbladrawimage' => 1,
	'hasselbladxml' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdcontent' => 1,
	'hdgainmapinfo' => 1,
	'hdmibitdepth' => 1,
	'hdmiexternalrecorder' => 1,
	'hdmioutputhdr' => 1,
	'hdmioutputrange' => 1,
	'hdrgaincurve' => 1,
	'hdrgaincurvesize' => 1,
	'hdrgaininfo' => 1,
	'hdrgainmap' => 1,
	'hdrgm' => 1,
	'hdrimage' => 1,
	'hdrinfo' => 1,
	'hdrinfo2' => 1,
	'hdrinfoversion' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'hdrvideo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'headshrinking' => 1,
	'heightresolution' => 1,
	'hevcconfiguration' => 1,
	'hevcconfigurationversion' => 1,
	'hiddendata' => 1,
	'hiddeninfo' => 1,
	'hiddenslides' => 1,
	'highbitdepth' => 1,
	'highisomode' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'highnote' => 1,
	'highvelocity' => 1,
	'hindsightsettings' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintmaxoutputvalue' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'histogram' => 1,
	'historybuffersize' => 1,
	'hmaphandling' => 1,
	'hmcolrejthresh' => 1,
	'hmcolthresh' => 1,
	'hmpixthresh' => 1,
	'hmwsize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizoncontrol' => 1,
	'horizontalfieldofview' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hostsoftwareexportversion' => 1,
	'hotkey' => 1,
	'hotspotx' => 1,
	'hotspoty' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'hrnoiselines' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huawei' => 1,
	'huffmantable' => 1,
	'huffmantablelength' => 1,
	'huffmantablevalue' => 1,
	'hyperfocaldistance' => 1,
	'hyperlapsdebuginfo' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'iad1' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iccprofilelocation' => 1,
	'icingdetected' => 1,
	'icondir' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3-2' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idlesequence' => 1,
	'idletiming' => 1,
	'idsbasevalue' => 1,
	'idstring' => 1,
	'ifd0' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illuminantdetectordata' => 1,
	'illuminantdetecttable' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagecompressiontable' => 1,
	'imagecoordinatesystem' => 1,
	'imagedatadiscard' => 1,
	'imagedatahash' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imageexpansiontable' => 1,
	'imagefields' => 1,
	'imagefilecharacteristics' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imagegeometry' => 1,
	'imageheader' => 1,
	'imageheightinches' => 1,
	'imagehorizonpixelpack' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagelocation' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixeldepth' => 1,
	'imagepixelformat' => 1,
	'imagepixeloffset' => 1,
	'imagepixelstorage' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresources' => 1,
	'imagerinitialtimingcode' => 1,
	'imagerlogicprogram' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagertimingdata' => 1,
	'imagesampleformat' => 1,
	'imagesensorgain' => 1,
	'imagesourceek' => 1,
	'imagespatialextent' => 1,
	'imagestabilisation' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imagewidthinches' => 1,
	'imageworkstationmake' => 1,
	'imagingdata' => 1,
	'imdb' => 1,
	'imdb_id' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'inbandratingattributes' => 1,
	'inbandratinglevel' => 1,
	'inbandratingsystem' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexbackground' => 1,
	'indexed' => 1,
	'indexedcolortablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'indextransparent' => 1,
	'indicatedairspeed' => 1,
	'indications' => 1,
	'infirayfactory' => 1,
	'infirayisothermal' => 1,
	'infiraymixmode' => 1,
	'infirayopmode' => 1,
	'infiraypicture' => 1,
	'infiraysensor' => 1,
	'infirayversion' => 1,
	'info' => 1,
	'ingrreserved' => 1,
	'initialdelaysamples' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'inputheight' => 1,
	'inputorientation' => 1,
	'inputuniformity' => 1,
	'inputwidth' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'insta360' => 1,
	'insta360info' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'instruments' => 1,
	'insv' => 1,
	'integratetiming' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpolationcoefficients' => 1,
	'interpolationcoefficients3mp' => 1,
	'interpolationcoefficients6mp' => 1,
	'interpretedby' => 1,
	'intervaloffset' => 1,
	'inversemonitormatrix' => 1,
	'inverserimnonlinearity' => 1,
	'inversesbalog12transform' => 1,
	'inversesbalogtransform' => 1,
	'invnifnonlinearity' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isartbokeh' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoautooffset' => 1,
	'isocalibrationgaintable' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isospeeds' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemdesignatorid' => 1,
	'itemid' => 1,
	'iteminfoentry' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemproperties' => 1,
	'itempropertyassociation' => 1,
	'itempropertycontainer' => 1,
	'itemprotection' => 1,
	'itemreference' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'ixml' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg-likedata' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpegimagelength' => 1,
	'jpeginfo' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtablebest' => 1,
	'jpegqtablebetter' => 1,
	'jpegqtablegood' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jpgfromraw2' => 1,
	'jpginfooffset' => 1,
	'jplcartoifd' => 1,
	'jps' => 1,
	'jpscomment' => 1,
	'jpsflags' => 1,
	'jpslayout' => 1,
	'jpsseparation' => 1,
	'jpstype' => 1,
	'jsondata' => 1,
	'jsoninfo' => 1,
	'jsonmetadata' => 1,
	'jumbf' => 1,
	'jumbfbox' => 1,
	'jumbfdescr' => 1,
	'jumdid' => 1,
	'jumdlabel' => 1,
	'jumdsignature' => 1,
	'jumdtoggles' => 1,
	'jumdtype' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'jxlcodestream' => 1,
	'k1' => 1,
	'k2' => 1,
	'k3' => 1,
	'k4' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keepexposurewithteleconverter' => 1,
	'keepuntil' => 1,
	'keepusersettings' => 1,
	'kelvinwb' => 1,
	'kenwooddata' => 1,
	'keyalgorithm' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'keyversion' => 1,
	'kf' => 1,
	'kf8coveruri' => 1,
	'khufui0thresholds' => 1,
	'khufui1thresholds' => 1,
	'khufui2thresholds' => 1,
	'khufui3thresholds' => 1,
	'khufui4thresholds' => 1,
	'khufui5thresholds' => 1,
	'khufulinearbluemixingcoefficient' => 1,
	'khufulineargreenmixingcoefficient' => 1,
	'khufulinearredmixingcoefficient' => 1,
	'khufusigmagaussianweights' => 1,
	'khufusigmascalingfactors14mp' => 1,
	'khufusigmascalingfactors3mp' => 1,
	'khufusigmascalingfactors6mp' => 1,
	'khufuuspacec2mixingcoefficient' => 1,
	'kids' => 1,
	'kilocalories' => 1,
	'kinds' => 1,
	'kj' => 1,
	'kk' => 1,
	'klut' => 1,
	'klut12tolin12' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'labelcode' => 1,
	'labeledtext' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'languages' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'laserprfcode' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'lawrating' => 1,
	'layerblendmodes' => 1,
	'layercolors' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layerids' => 1,
	'layermodifydates' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layers' => 1,
	'layersections' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layervisible' => 1,
	'layout' => 1,
	'layoutflags' => 1,
	'lccn' => 1,
	'lcdedgemapslope' => 1,
	'lcdedgemapx1' => 1,
	'lcdedgemapx2' => 1,
	'lcdedgemapx3' => 1,
	'lcdedgemapx4' => 1,
	'lcdedgespline' => 1,
	'lcdgammatable' => 1,
	'lcdgammatablechickfix' => 1,
	'lcdgammatablemarvin' => 1,
	'lcdhistlut0' => 1,
	'lcdhistlut1' => 1,
	'lcdhistlut2' => 1,
	'lcdhistlut3' => 1,
	'lcdhistlut4' => 1,
	'lcdhistlut5' => 1,
	'lcdhistlut6' => 1,
	'lcdhistlut7' => 1,
	'lcdhistlut8' => 1,
	'lcdhistlut9' => 1,
	'lcdlinearclipvalue' => 1,
	'lcdsharpeningf1' => 1,
	'lcdsharpeningf2' => 1,
	'lcdsharpeningf3' => 1,
	'lcdsharpeningf4' => 1,
	'lcdstepyvalues' => 1,
	'lcdstepyvalueschickfix' => 1,
	'lcdstepyvaluesmarvin' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkcol1' => 1,
	'leftdarkcol2' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'leftmargin' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leglonger' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensattached' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdata0402' => 1,
	'lensdata0403' => 1,
	'lensdata0800' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensfacing' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lensnumber' => 1,
	'lenspartnumber' => 1,
	'lensprojection' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'lenstableindex' => 1,
	'levelinfo' => 1,
	'levelinfok3iii' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'ligogpsinfo' => 1,
	'ligojson' => 1,
	'limage' => 1,
	'limitaf-areamodeselautoanimals' => 1,
	'limitaf-areamodeselautopeople' => 1,
	'limitaf-areamodeseldynamic' => 1,
	'limitaf-areamodeselwidelanimals' => 1,
	'limitaf-areamodeselwidelpeople' => 1,
	'limitafareamodesel3d' => 1,
	'limitafareamodeseld105' => 1,
	'limitafareamodeseld25' => 1,
	'limitafareamodeseld49' => 1,
	'limitafareamodeseld9' => 1,
	'limitafareamodeselgroup' => 1,
	'limitafareamodeselgroupc1' => 1,
	'limitafareamodeselgroupc2' => 1,
	'limitreleasemodeselmirror-up' => 1,
	'limitreleasemodeselq' => 1,
	'limitreleasemodeseltimer' => 1,
	'limitselectableimagearea5to4' => 1,
	'lin12toklut12' => 1,
	'lin12toklut8' => 1,
	'linearitysplinetags' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'linecount' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkedfilename' => 1,
	'linkedprofilename' => 1,
	'linkerversion' => 1,
	'linkgoodput' => 1,
	'linkinfo' => 1,
	'linkquality' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'linlogtable' => 1,
	'linux' => 1,
	'lipstick' => 1,
	'listtype' => 1,
	'lit' => 1,
	'livephotoinfo' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'localpositionned' => 1,
	'locationinfo' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'loginfo' => 1,
	'loglintable' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmat0' => 1,
	'lookmat1' => 1,
	'lookmat2' => 1,
	'lookmat3' => 1,
	'lookmat4' => 1,
	'lookmat5' => 1,
	'lookmat6' => 1,
	'lookmat7' => 1,
	'lookmat8' => 1,
	'lookmat9' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopcount' => 1,
	'lotus' => 1,
	'lowlightaf' => 1,
	'lownote' => 1,
	'lowvelocity' => 1,
	'lr' => 1,
	'lslv' => 1,
	'lucasjunk' => 1,
	'lumaaverage' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'luminancetable' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'mag360fly' => 1,
	'magmode' => 1,
	'magneticfield' => 1,
	'magneticheading' => 1,
	'magneticvariation' => 1,
	'magnetometer' => 1,
	'magnetometerxyz' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'mappingxcoefficients' => 1,
	'mappingxmode' => 1,
	'mappingycoefficients' => 1,
	'mappingymode' => 1,
	'mapscale' => 1,
	'mariahthresholds' => 1,
	'mariahthresholdslow' => 1,
	'mariahthresholdsnormal' => 1,
	'mariahthresholdsstrong' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'marl' => 1,
	'marlindataversion' => 1,
	'marlindictionary' => 1,
	'marlinheader' => 1,
	'marlinvalues' => 1,
	'masksubarea' => 1,
	'masteredby' => 1,
	'mastergainadjustment' => 1,
	'matrixcoefficients' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxcontentlightlevel' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxpicaveragelightlevel' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mccdata' => 1,
	'mcdi' => 1,
	'md5signature' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemaccounthandles' => 1,
	'mditemaccountidentifier' => 1,
	'mditemacquisitionmake' => 1,
	'mditemacquisitionmodel' => 1,
	'mditemaltitude' => 1,
	'mditemaperture' => 1,
	'mditemaudiobitrate' => 1,
	'mditemaudiochannelcount' => 1,
	'mditemauthoremailaddresses' => 1,
	'mditemauthors' => 1,
	'mditembitspersample' => 1,
	'mditembundleidentifier' => 1,
	'mditemcity' => 1,
	'mditemcodecs' => 1,
	'mditemcolorspace' => 1,
	'mditemcomment' => 1,
	'mditemcontentcreationdate' => 1,
	'mditemcontentcreationdate_ranking' => 1,
	'mditemcontentcreationdateranking' => 1,
	'mditemcontentmodificationdate' => 1,
	'mditemcontenttype' => 1,
	'mditemcontenttypetree' => 1,
	'mditemcontributors' => 1,
	'mditemcopyright' => 1,
	'mditemcountry' => 1,
	'mditemcreator' => 1,
	'mditemdateadded' => 1,
	'mditemdateadded_ranking' => 1,
	'mditemdescription' => 1,
	'mditemdisplayname' => 1,
	'mditemdownloadeddate' => 1,
	'mditemdurationseconds' => 1,
	'mditememailconversationid' => 1,
	'mditemencodingapplications' => 1,
	'mditemexifgpsversion' => 1,
	'mditemexifversion' => 1,
	'mditemexposuremode' => 1,
	'mditemexposureprogram' => 1,
	'mditemexposuretimeseconds' => 1,
	'mditemflashonoff' => 1,
	'mditemfnumber' => 1,
	'mditemfocallength' => 1,
	'mditemfscontentchangedate' => 1,
	'mditemfscreatorcode' => 1,
	'mditemfsfinderflags' => 1,
	'mditemfshascustomicon' => 1,
	'mditemfsinvisible' => 1,
	'mditemfsisextensionhidden' => 1,
	'mditemfsisstationery' => 1,
	'mditemfsname' => 1,
	'mditemfsnodecount' => 1,
	'mditemfsownergroupid' => 1,
	'mditemfsowneruserid' => 1,
	'mditemfssize' => 1,
	'mditemfstypecode' => 1,
	'mditemgpsdatestamp' => 1,
	'mditemgpsstatus' => 1,
	'mditemgpstrack' => 1,
	'mditemhasalphachannel' => 1,
	'mditemidentifier' => 1,
	'mditemimagedirection' => 1,
	'mditeminterestingdate_ranking' => 1,
	'mditeminterestingdateranking' => 1,
	'mditemisapplicationmanaged' => 1,
	'mditemisexistingthread' => 1,
	'mditemislikelyjunk' => 1,
	'mditemisospeed' => 1,
	'mditemkeywords' => 1,
	'mditemkind' => 1,
	'mditemlastuseddate' => 1,
	'mditemlastuseddate_ranking' => 1,
	'mditemlatitude' => 1,
	'mditemlensmodel' => 1,
	'mditemlogicalsize' => 1,
	'mditemlongitude' => 1,
	'mditemmailboxes' => 1,
	'mditemmaildatereceived_ranking' => 1,
	'mditemmediatypes' => 1,
	'mditemnumberofpages' => 1,
	'mditemorientation' => 1,
	'mditemoriginapplicationidentifier' => 1,
	'mditemoriginmessageid' => 1,
	'mditemoriginsenderdisplayname' => 1,
	'mditemoriginsenderhandle' => 1,
	'mditemoriginsubject' => 1,
	'mditempageheight' => 1,
	'mditempagewidth' => 1,
	'mditemphysicalsize' => 1,
	'mditempixelcount' => 1,
	'mditempixelheight' => 1,
	'mditempixelwidth' => 1,
	'mditemprimaryrecipientemailaddresses' => 1,
	'mditemprofilename' => 1,
	'mditemrecipients' => 1,
	'mditemredeyeonoff' => 1,
	'mditemresolutionheightdpi' => 1,
	'mditemresolutionwidthdpi' => 1,
	'mditemsecuritymethod' => 1,
	'mditemspeed' => 1,
	'mditemstateorprovince' => 1,
	'mditemstreamable' => 1,
	'mditemsubject' => 1,
	'mditemtimestamp' => 1,
	'mditemtitle' => 1,
	'mditemtotalbitrate' => 1,
	'mditemusecount' => 1,
	'mditemuseddates' => 1,
	'mditemuserdownloadeddate' => 1,
	'mditemuserdownloadeduserhandle' => 1,
	'mditemusersharedreceiveddate' => 1,
	'mditemusersharedreceivedrecipient' => 1,
	'mditemusersharedreceivedrecipienthandle' => 1,
	'mditemusersharedreceivedsender' => 1,
	'mditemusersharedreceivedsenderhandle' => 1,
	'mditemusersharedreceivedtransport' => 1,
	'mditemversion' => 1,
	'mditemvideobitrate' => 1,
	'mditemwherefroms' => 1,
	'mditemwhitebalance' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measure' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementinputinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'mebx' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediadataoffset' => 1,
	'mediadatasize' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaismovie' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaissport' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'mediamode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediaoriginalchannelsubnumber' => 1,
	'mediaoriginalruntime' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediathumbaspectratiox' => 1,
	'mediathumbaspectratioy' => 1,
	'mediathumbheight' => 1,
	'mediathumbratingattributes' => 1,
	'mediathumbratinglevel' => 1,
	'mediathumbratingsystem' => 1,
	'mediathumbret' => 1,
	'mediathumbstride' => 1,
	'mediathumbtimestamp' => 1,
	'mediathumbwidth' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediauniqueid' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'melodicpolyphony' => 1,
	'menuoffset' => 1,
	'menusettingsoffset' => 1,
	'menusettingsoffsetz7ii' => 1,
	'menusettingsoffsetz8v1' => 1,
	'menusettingsoffsetz8v2' => 1,
	'menusettingsoffsetz9' => 1,
	'menusettingsoffsetz9v3' => 1,
	'menusettingsoffsetz9v4' => 1,
	'menusettingsz8' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'metadataversion' => 1,
	'metaformat' => 1,
	'metaimagesize' => 1,
	'metarelation' => 1,
	'metasampledesc' => 1,
	'metatype' => 1,
	'metdata' => 1,
	'meter' => 1,
	'meterinfo' => 1,
	'meteringbutton' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'mett' => 1,
	'microphonewet' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'midicontrol' => 1,
	'midicontrolversion' => 1,
	'midipitchfraction' => 1,
	'midisong' => 1,
	'midiunitynote' => 1,
	'mie' => 1,
	'miiscoreidentifier' => 1,
	'mileage' => 1,
	'mimeencoding' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumflushrows' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'minspatialsegmentationidc' => 1,
	'mintransmissiontime' => 1,
	'missionid' => 1,
	'mixedby' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modelstamp' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'monomonitormatrix' => 1,
	'monostrength' => 1,
	'monotonescaletable' => 1,
	'monouniquematrix' => 1,
	'montage' => 1,
	'month' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'moresettingsoffset' => 1,
	'mosaicpattern' => 1,
	'mouthmodify' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviefragment' => 1,
	'moviefragmentheader' => 1,
	'moviefragmentsequence' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'moviehighlightdisplaypattern' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'moviewhitebalancesameasphoto' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'mtoa0' => 1,
	'mtob0' => 1,
	'mtob1' => 1,
	'mtob2' => 1,
	'mtob3' => 1,
	'mtos0' => 1,
	'mtos1' => 1,
	'mtos2' => 1,
	'mtos3' => 1,
	'multiexp' => 1,
	'multiexposure2' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiplexdefaultvalues' => 1,
	'multiplextypearray' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multishoton' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'mynextbase-paireddevicename' => 1,
	'mynextbase-pairing' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'nbcd' => 1,
	'ncc' => 1,
	'nemoblurkernel' => 1,
	'nemodarklimit' => 1,
	'nemogainfactors' => 1,
	'nemohighlight12limit' => 1,
	'nemotilesize' => 1,
	'nestedsignalstream' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'newlines' => 1,
	'nextbasemeta' => 1,
	'nexttrackid' => 1,
	'nifnonlinearity' => 1,
	'nifnonlinearity12bit' => 1,
	'nifnonlinearity12to16' => 1,
	'nifnonlinearity16bit' => 1,
	'nifnonlinearityext' => 1,
	'nikon' => 1,
	'nikonapp' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonnefinfo' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'nine' => 1,
	'nineedits' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'noisereductionkernel' => 1,
	'noisereductionparametershostlow' => 1,
	'noisereductionparametershostnormal' => 1,
	'noisereductionparametershoststrong' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'non-primarysourcetrack' => 1,
	'normallinetransfertiming' => 1,
	'noseslimming' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nrwdata' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlicenseplate' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numberofsamples64' => 1,
	'numchanneldescriptions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numplanes' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numsampleloops' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'numtemporallayers' => 1,
	'objectcountrycodes' => 1,
	'objectcountrycodingmethod' => 1,
	'objectcountrycodingmethoddate' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectorientation' => 1,
	'objectsizeannounced' => 1,
	'observationdate' => 1,
	'observationdateend' => 1,
	'observationtime' => 1,
	'observationtimeend' => 1,
	'observer' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offset13' => 1,
	'offsetcornerlatitude1' => 1,
	'offsetcornerlatitude2' => 1,
	'offsetcornerlatitude3' => 1,
	'offsetcornerlatitude4' => 1,
	'offsetcornerlongitude1' => 1,
	'offsetcornerlongitude2' => 1,
	'offsetcornerlongitude3' => 1,
	'offsetcornerlongitude4' => 1,
	'offsetmaphorizontal' => 1,
	'offsetmapvertical' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'oleinfo' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'omenatcapturemode' => 1,
	'omenearlygobcolumns' => 1,
	'omenearlygobrows' => 1,
	'omenearlygobsurface' => 1,
	'omengradientexclusionlimits' => 1,
	'omengradientkernel' => 1,
	'omengradientkerneltaps' => 1,
	'omengradientoffset' => 1,
	'omeninitialcolumns' => 1,
	'omeninitialrows' => 1,
	'omeninitialscaling' => 1,
	'omenmeantostrength' => 1,
	'omenpercenttorationallimitsblue' => 1,
	'omenpercenttorationallimitsgob' => 1,
	'omenpercenttorationallimitsgor' => 1,
	'omenpercenttorationallimitsred' => 1,
	'omenrangeweighting' => 1,
	'omenratioclipfactors' => 1,
	'omenratioexclusionfactors' => 1,
	'omenroicoefficients' => 1,
	'omenroicoordinates' => 1,
	'omensmoothingkernel' => 1,
	'on1_settingsdata' => 1,
	'on1_settingsmetadatacreated' => 1,
	'on1_settingsmetadatamodified' => 1,
	'on1_settingsmetadataname' => 1,
	'on1_settingsmetadatapluginid' => 1,
	'on1_settingsmetadatatimestamp' => 1,
	'on1_settingsmetadatausage' => 1,
	'on1_settingsmetadatavisibletouser' => 1,
	'oneplus' => 1,
	'oneplustrailerlen' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationalmode' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'opticalvr' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'orientationdatapresent' => 1,
	'orientationinfo' => 1,
	'orientationoffset' => 1,
	'orientoffset' => 1,
	'original' => 1,
	'originalalbum' => 1,
	'originaldate' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalframerate' => 1,
	'originalimagebroker' => 1,
	'originalmedia' => 1,
	'originalmediatype' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalsoftpostpadding' => 1,
	'originalsoftprepadding' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originalyear' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherdate1' => 1,
	'otherdate2' => 1,
	'otherdate3' => 1,
	'otherfirmware' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'othermeta' => 1,
	'othername' => 1,
	'otheroffset' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherserialnumber' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputheight' => 1,
	'outputorientation' => 1,
	'outputresponse' => 1,
	'outputwidth' => 1,
	'overclockcolsright' => 1,
	'overclockrowsbottom' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parallelismtype' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parasites' => 1,
	'parentalratingreason' => 1,
	'parkingmode' => 1,
	'parrotautomation' => 1,
	'parrotfollowme' => 1,
	'parrottimestamp' => 1,
	'parrotv1' => 1,
	'parrotv2' => 1,
	'parrotv3' => 1,
	'part' => 1,
	'partialactivecolsleft' => 1,
	'partialactivecolsright' => 1,
	'partialactiverowsbottom' => 1,
	'partialactiverowstop' => 1,
	'partialjxlcodestream' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partoffset' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'patterncorrectionfactors' => 1,
	'patterncorrectiongains' => 1,
	'patterncorrectionoffsets' => 1,
	'patterngainconversiontable' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdbage' => 1,
	'pdbcreatedate' => 1,
	'pdbfilename' => 1,
	'pdbmodifydate' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'pdrversion' => 1,
	'peakbitrate' => 1,
	'peaklevelr128' => 1,
	'peaklevelsample' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'peg_info' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxdata2' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'percussivepolyphony' => 1,
	'perfmode' => 1,
	'performersortorder' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'phone' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoresolution' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'photoshopstream' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pilotingmode' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchrollyaw' => 1,
	'pittasoft' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelcorrectiongains' => 1,
	'pixelexposuretime' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'playbackflickdownrating' => 1,
	'playbackflickuprating' => 1,
	'playbackframerate' => 1,
	'playcounter' => 1,
	'playlist' => 1,
	'playlistdelay' => 1,
	'playlistindex' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'pointsize' => 1,
	'polynomialcoefficients' => 1,
	'polynomialpower' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'portraitmatrix' => 1,
	'portraitoffset' => 1,
	'portraittonescaletable' => 1,
	'poseyawdegrees' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2crd3' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'powerprofile' => 1,
	'pragma' => 1,
	'prediminanthue' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'prefersubselectorcenter' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewjxl' => 1,
	'previewjxllength' => 1,
	'previewjxlstart' => 1,
	'previewpdf' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryfileguid' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsbleedwidth' => 1,
	'printflagsbleedwidthscale' => 1,
	'printflagscrop' => 1,
	'printflagsinfo' => 1,
	'printflagsversion' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prioritysettings' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingparameters' => 1,
	'processingtime' => 1,
	'processparametersv2' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productioncopyright' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversionnumber' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledataoffset' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profilesequenceinfo' => 1,
	'profilesize' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programid' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projectidcode' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'protocol' => 1,
	'protune' => 1,
	'protuneisomode' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'ptrh' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasecurrency' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purchaseitem' => 1,
	'purchaseowner' => 1,
	'purchaseprice' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qtablelarge100pct' => 1,
	'qtablelarge25pct' => 1,
	'qtablelarge50pct' => 1,
	'qtablelarge67pct' => 1,
	'qtablemedium100pct' => 1,
	'qtablemedium25pct' => 1,
	'qtablemedium50pct' => 1,
	'qtablemedium67pct' => 1,
	'qtablesmall100pct' => 1,
	'qtablesmall25pct' => 1,
	'qtablesmall50pct' => 1,
	'qtablesmall67pct' => 1,
	'qualcomm' => 1,
	'qualcommdualcamera' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'quietshuttershootingspeed' => 1,
	'quoting' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafcompression' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rangeimagelocalset' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawburstmoderoll' => 1,
	'rawcfacomponentaverages' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawgsensor' => 1,
	'rawhistogram' => 1,
	'rawimageaspectratio' => 1,
	'rawimagecroppedsize' => 1,
	'rawimagecroptopleft' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagenumber' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawvaluerangemax' => 1,
	'rawvaluerangemin' => 1,
	'rawzoomactive' => 1,
	'rawzoomsize' => 1,
	'rawzoomtopleft' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'rearcontropaneldisplay' => 1,
	'recallshootfuncaf-on' => 1,
	'recallshootfuncafareamode' => 1,
	'recallshootfuncaperture' => 1,
	'recallshootfuncexposurecomp' => 1,
	'recallshootfuncexposuremode' => 1,
	'recallshootfuncfocustracking' => 1,
	'recallshootfunciso' => 1,
	'recallshootfuncmeteringmode' => 1,
	'recallshootfuncshutterspeed' => 1,
	'recallshootfuncwhitebalance' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingdates' => 1,
	'recordinghistory' => 1,
	'recordinglocation' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'records' => 1,
	'recordsv2' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'red1header' => 1,
	'red2header' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redcodeversion' => 1,
	'redendpoint' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmask' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reelnumber' => 1,
	'reeltimecode' => 1,
	'reference' => 1,
	'referencename' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectedtemperature' => 1,
	'reflection' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'registerreadtiming' => 1,
	'relatedimagefile' => 1,
	'relatedresources' => 1,
	'relationship' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativelocation' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'releasinginstructions' => 1,
	'remasterinfo' => 1,
	'rembrandtconsumertonescale' => 1,
	'rembrandtportraittonescale' => 1,
	'rembrandttonescale' => 1,
	'remindertime' => 1,
	'remixedby' => 1,
	'remotefuncbutton' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaingain' => 1,
	'replaygainpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replaytrackgain' => 1,
	'replaytrackpeak' => 1,
	'replayvolumelevel' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requestid' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'reservedblob2' => 1,
	'reservedblob3' => 1,
	'reservedblob4' => 1,
	'reservedblob5' => 1,
	'reservedblob6' => 1,
	'reservedblob7' => 1,
	'reservedblob8' => 1,
	'reservedblob9' => 1,
	'resolutioninfo' => 1,
	'resolutionxlengthunit' => 1,
	'resolutionxunit' => 1,
	'resolutionylengthunit' => 1,
	'resolutionyunit' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'reversingcamera' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'rgbcurves' => 1,
	'rgbtoev0' => 1,
	'rgbtoev1' => 1,
	'rgbtoev2' => 1,
	'rgbtoev3' => 1,
	'rgbtoev4' => 1,
	'rgbtoev5' => 1,
	'rgbtoev6' => 1,
	'rgbtoev7' => 1,
	'rgbtoev8' => 1,
	'rgbtoev9' => 1,
	'rgtable' => 1,
	'ricoh' => 1,
	'ricohinfo' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrdta' => 1,
	'ricohrdtb' => 1,
	'ricohrdtc' => 1,
	'ricohrdtg' => 1,
	'ricohrdtl' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'riffsize64' => 1,
	'rightdarkcol1' => 1,
	'rightdarkcol2' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rimm13toerimm12spline' => 1,
	'rimmtocrgb0spline' => 1,
	'rimmtocrgb1spline' => 1,
	'rimmtocrgb2spline' => 1,
	'rimmtocrgb3spline' => 1,
	'rimmtocrgb4spline' => 1,
	'rimmtocrgb5spline' => 1,
	'rimmtocrgb6spline' => 1,
	'rimmtocrgb7spline' => 1,
	'rimmtocrgb8spline' => 1,
	'rimmtocrgb9spline' => 1,
	'rimnonlinearity' => 1,
	'rimtonifcolortransform' => 1,
	'rimtonifscalefactor' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'rnoiselines' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'rollingshutterskewtime' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rootnote' => 1,
	'rot360fly' => 1,
	'rotationangle' => 1,
	'rotationinfooffset' => 1,
	'rotationxyz' => 1,
	'rotmode' => 1,
	'roundtripversion' => 1,
	'rovegps' => 1,
	'rowcount' => 1,
	'rowinterleavefactor' => 1,
	'rsrc' => 1,
	'rtmd' => 1,
	'rtos' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	'rvmi_grev' => 1,
	'rvmi_srev' => 1,
	'rvtlocalset' => 1,
	's2n' => 1,
	'sample' => 1,
	'sampleblacksequence' => 1,
	'sampledatetime' => 1,
	'sampledegradationpriority' => 1,
	'sampleduration' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'sampleperiod' => 1,
	'sampler' => 1,
	'samplerate2' => 1,
	'samplerdata' => 1,
	'samplerdatalen' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletime' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungcaptureinfo' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungmodel' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'samsungtrailer' => 1,
	'samsunguniqueid' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'sarmotionimagerydata' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'savefocus' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbabluebalancelut' => 1,
	'sbaexposurerecord' => 1,
	'sbagreenbalancelut' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'sbalog12transform' => 1,
	'sbalogtransform' => 1,
	'sbaredbalancelut' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scaledimu' => 1,
	'scaledpressure' => 1,
	'scalefactor' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'scav11cols' => 1,
	'scav12cols' => 1,
	'scav21cols' => 1,
	'scav22cols' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'sceneclassification' => 1,
	'scenecolorimetryestimates' => 1,
	'sceneilluminance' => 1,
	'schedulecapture' => 1,
	'schedulecapturetime' => 1,
	'scheduleitemid' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screendimming' => 1,
	'screenheight' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenplayby' => 1,
	'screensaver' => 1,
	'screenwidth' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'script' => 1,
	'scriptcommand' => 1,
	'sdc' => 1,
	'sdcardclass' => 1,
	'sdcardformat' => 1,
	'sdcardmanfdate' => 1,
	'sdcardmanfid' => 1,
	'sdcardmodelno' => 1,
	'sdcardoemid' => 1,
	'sdcardserialno' => 1,
	'sdcardsize' => 1,
	'sdcardtype' => 1,
	'sdcardusedspace' => 1,
	'sdcc-flp' => 1,
	'sealcomment' => 1,
	'sealversion' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondcam' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'securitylocalmetadataset' => 1,
	'securitysci-shiinformation' => 1,
	'securityversion' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'segheight' => 1,
	'segmentlocalset' => 1,
	'segwidth' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'semanticinstanceid' => 1,
	'semanticname' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensitivityvalue' => 1,
	'sensorbottomborder' => 1,
	'sensordata' => 1,
	'sensordefects' => 1,
	'sensorellipsoidheight' => 1,
	'sensorellipsoidheightextended' => 1,
	'sensorfieldofviewname' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorname' => 1,
	'sensorreadouttime' => 1,
	'sensorrelativeazimuthangle' => 1,
	'sensorrelativeelevationangle' => 1,
	'sensorrelativerollangle' => 1,
	'sensorrightborder' => 1,
	'sensorvelocityeast' => 1,
	'sensorvelocitynorth' => 1,
	'seqcount' => 1,
	'seqfinal' => 1,
	'seqframeinfo' => 1,
	'seqid' => 1,
	'seqindex' => 1,
	'seqlevelidx0' => 1,
	'seqprofile' => 1,
	'seqtier0' => 1,
	'seqtype' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'sequenceoffset' => 1,
	'serialinfo' => 1,
	'serialnumber2' => 1,
	'seriesuid' => 1,
	'serviceid' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'settingsoffset' => 1,
	'seventhlanguage' => 1,
	'sfsboundary' => 1,
	'sglcoldcacthres1' => 1,
	'sglcoldcacthres2' => 1,
	'sglcoldcacthres3' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'sharedwith' => 1,
	'sharpenforthumbnail' => 1,
	'sharpeningon' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shifttiming' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingmenuoffset' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod6' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod7500' => 1,
	'shotinfod780' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod850' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'shotinfoz6iii' => 1,
	'shotinfoz7ii' => 1,
	'shotinfoz8' => 1,
	'shotinfoz9' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutterangle' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sidelightstrength' => 1,
	'sideslipangle' => 1,
	'sigma' => 1,
	'sigmanoisefiltercaltablev1' => 1,
	'sigmanoisefiltertablev1' => 1,
	'sigmanoisefiltertablev1version' => 1,
	'sigmanoisethreshtablev2' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureformat' => 1,
	'signaturelength' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'singleshotdepthmap' => 1,
	'singleshotdepthmaptiff' => 1,
	'singleshotmeta' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'siunits' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'skipinfo' => 1,
	'slantrange' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'slowmotionrate' => 1,
	'slowmotionregions' => 1,
	'slowmotionregionsdurationepoch' => 1,
	'slowmotionregionsdurationflags' => 1,
	'slowmotionregionsdurationtimescale' => 1,
	'slowmotionregionsdurationvalue' => 1,
	'slowmotionregionsstarttimeepoch' => 1,
	'slowmotionregionsstarttimeflags' => 1,
	'slowmotionregionsstarttimescale' => 1,
	'slowmotionregionsstarttimevalue' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'smoother' => 1,
	'smpteformat' => 1,
	'smpteoffset' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sony_0x9416' => 1,
	'sonyfnumber2' => 1,
	'sonyhiddendata' => 1,
	'sonyrawfiletype' => 1,
	'sonytonecurve' => 1,
	'sortwith' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialaudio' => 1,
	'spatialaudioversion' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'spectralviewingconditions' => 1,
	'spectralwhitepoint' => 1,
	'speed' => 1,
	'speedrampsetting' => 1,
	'speedstamp' => 1,
	'speedunits' => 1,
	'sphericalvideo' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spinstrength' => 1,
	'spothalftone' => 1,
	'spotmeter' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'standardtocustompcc' => 1,
	'standbymonitorofftime' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startedgecode' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'staticpressure' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereoscopic3d' => 1,
	'stillimagetime' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchcolumns' => 1,
	'stitchinfo' => 1,
	'stitchrows' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'storageformatdate' => 1,
	'storageformattime' => 1,
	'storagemodel' => 1,
	'storageserialnumber' => 1,
	'storagetype' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streamid' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'structuretype' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdialframeadvance' => 1,
	'subdialframeadvancerating0' => 1,
	'subdialframeadvancerating1' => 1,
	'subdialframeadvancerating2' => 1,
	'subdialframeadvancerating3' => 1,
	'subdialframeadvancerating4' => 1,
	'subdialframeadvancerating5' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'subtitletrack' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surfacemap' => 1,
	'surroundmode' => 1,
	'surroundshotvideo' => 1,
	'surroundshotvideoname' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncronizedtrack' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'synopsis' => 1,
	'systeminfo' => 1,
	'systemtime' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag2010i' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050a' => 1,
	'tag9050b' => 1,
	'tag9050c' => 1,
	'tag9050d' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9401' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9404c' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag9406b' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'tag9416_0000' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'tailnumber' => 1,
	'take' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targeterrorestimatece90' => 1,
	'targeterrorestimatele90' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetlocationcovariancematrix' => 1,
	'targetlocationelevation' => 1,
	'targetlocationlatitude' => 1,
	'targetlocationlongitude' => 1,
	'targettrackgateheight' => 1,
	'targettrackgatewidth' => 1,
	'targetwidth' => 1,
	'targetwidthextended' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tattoo' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'teethwhitening' => 1,
	'telephonenumber' => 1,
	'telescope' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporalidnested' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'testtransfertiming' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'thanksto' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thermalcalibration' => 1,
	'thermaldata' => 1,
	'thermalparams' => 1,
	'thermalparams2' => 1,
	'thermalparams3' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailartist' => 1,
	'thumbnailbitspersample' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailcolordepth' => 1,
	'thumbnailcompressedsize' => 1,
	'thumbnailcompression' => 1,
	'thumbnailcompressiontable' => 1,
	'thumbnailcopyright' => 1,
	'thumbnaildata' => 1,
	'thumbnaildatetime' => 1,
	'thumbnaildescription' => 1,
	'thumbnailequipmake' => 1,
	'thumbnailequipmodel' => 1,
	'thumbnailexpansiontable' => 1,
	'thumbnailhash' => 1,
	'thumbnailimageheight' => 1,
	'thumbnailimagewidth' => 1,
	'thumbnailorientation' => 1,
	'thumbnailphotometricinterp' => 1,
	'thumbnailplanarconfig' => 1,
	'thumbnailplanes' => 1,
	'thumbnailprimarychromaticities' => 1,
	'thumbnailrawbytes' => 1,
	'thumbnailref' => 1,
	'thumbnailrefblackwhite' => 1,
	'thumbnailresizeratio' => 1,
	'thumbnailresolutionunit' => 1,
	'thumbnailresolutionx' => 1,
	'thumbnailresolutiony' => 1,
	'thumbnailrowsperstrip' => 1,
	'thumbnailsamplesperpixel' => 1,
	'thumbnailsoftware' => 1,
	'thumbnailstripbytecounts' => 1,
	'thumbnailstripoffsets' => 1,
	'thumbnailtiff' => 1,
	'thumbnailtransferfunction' => 1,
	'thumbnailurl' => 1,
	'thumbnailwhitepoint' => 1,
	'thumbnailycbcrcoefficients' => 1,
	'thumbnailycbcrpositioning' => 1,
	'thumbnailycbcrsubsampling' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tilegaindeterminationtable' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'time1' => 1,
	'time2' => 1,
	'timeanddate' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timecodetrack' => 1,
	'timeinfo' => 1,
	'timelapse' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamplist' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'timezonedst' => 1,
	'tipl' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'tmdb' => 1,
	'tmdb_id' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tomtomad' => 1,
	'tomtomhl' => 1,
	'tomtomid' => 1,
	'tomtommetadata' => 1,
	'tomtomvd' => 1,
	'tomtomvi' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonescale0' => 1,
	'tonescale0spline' => 1,
	'tonescale1' => 1,
	'tonescale1spline' => 1,
	'tonescale2' => 1,
	'tonescale2spline' => 1,
	'tonescale3' => 1,
	'tonescale3spline' => 1,
	'tonescale4' => 1,
	'tonescale4spline' => 1,
	'tonescale5' => 1,
	'tonescale5spline' => 1,
	'tonescale6' => 1,
	'tonescale6spline' => 1,
	'tonescale7' => 1,
	'tonescale7spline' => 1,
	'tonescale8' => 1,
	'tonescale8spline' => 1,
	'tonescale9' => 1,
	'tonescale9spline' => 1,
	'tonespaceflow' => 1,
	'tonscaletable' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topdarkrow1' => 1,
	'topdarkrow2' => 1,
	'topmag' => 1,
	'topmargin' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalparts' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackfragment' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transcripttrack' => 1,
	'transfercharacteristic' => 1,
	'transfercharacteristics' => 1,
	'transferrange' => 1,
	'transfersequence' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentcolor' => 1,
	'transparentindex' => 1,
	'transportstreamid' => 1,
	'trapindicator' => 1,
	'trashcolsright' => 1,
	'trashrowsbottom' => 1,
	'trim' => 1,
	'trueairspeed' => 1,
	'tty-ttdphone' => 1,
	'tungmat0' => 1,
	'tungmat1' => 1,
	'tungmat2' => 1,
	'tungmat3' => 1,
	'tungmat4' => 1,
	'tungmat5' => 1,
	'tungmat6' => 1,
	'tungmat7' => 1,
	'tungmat8' => 1,
	'tungmat9' => 1,
	'tuning' => 1,
	'tvdb' => 1,
	'twelvebit' => 1,
	'tx3g' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'uas_lsversionnumber' => 1,
	'uasdatalink' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'umid' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uniformresourcename' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'uniqueid' => 1,
	'uniqueidentifier' => 1,
	'unknown' => 1,
	'unknown00' => 1,
	'unknown01' => 1,
	'unknown02' => 1,
	'unknown03' => 1,
	'unknown_cndb' => 1,
	'unknown_grpl' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknownexif' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unsharpdata' => 1,
	'unshiftednote' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'unusedblackcolsleftin' => 1,
	'unusedblackcolsleftout' => 1,
	'unusedblackcolsrightin' => 1,
	'unusedblackcolsrightout' => 1,
	'unusedblackrowsbottomin' => 1,
	'unusedblackrowsbottomout' => 1,
	'unusedblackrowstopin' => 1,
	'unusedblackrowstopout' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'usermetadata' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'usertext' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usmparametershigh' => 1,
	'usmparametershost' => 1,
	'usmparametershost3mp' => 1,
	'usmparametershost6mp' => 1,
	'usmparameterslow' => 1,
	'usmparametersmed' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-c2paclaimsignature' => 1,
	'uuid-canon' => 1,
	'uuid-canon2' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-exif_bad' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-signature' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'validate' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vddimdacnominalvalues' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalaf-onbutton' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalfieldofview' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalspeed' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videofullrangeflag' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videokeys' => 1,
	'videolength' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoorientation' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotimestamp' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignetteinfo' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'vignettingparams' => 1,
	'vintagestrength' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'visualflightruleshud' => 1,
	'visualsampledesc' => 1,
	'vivo' => 1,
	'vmaphandling' => 1,
	'vmcoldropthresh' => 1,
	'vmcolthresh' => 1,
	'vmnbands' => 1,
	'vmpatchreslimit' => 1,
	'vmpixthresh' => 1,
	'vmtidataset' => 1,
	'vmwsize' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumelevelr128' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watched' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_bluelevelauto' => 1,
	'wb_cfa0_leveldaylight' => 1,
	'wb_cfa1_leveldaylight' => 1,
	'wb_cfa2_leveldaylight' => 1,
	'wb_cfa3_leveldaylight' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_redlevelauto' => 1,
	'wb_rgbcoeffsdaylight' => 1,
	'wb_rgbcoeffsflash' => 1,
	'wb_rgbcoeffsfluorescent' => 1,
	'wb_rgbcoeffstungsten' => 1,
	'wb_rgblevelsasshot' => 1,
	'wb_rgblevelscustom' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluefluorescent' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreenfluorescent' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredfluorescent' => 1,
	'wbredtungsten' => 1,
	'wbsettings' => 1,
	'wbsettings2' => 1,
	'wcsprofiles' => 1,
	'weaponfired' => 1,
	'weaponload' => 1,
	'webp_flags' => 1,
	'webpage' => 1,
	'weight' => 1,
	'what3words' => 1,
	'whitebalancematching' => 1,
	'whitebalancergb' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitening' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wi-fimacaddress' => 1,
	'wi-fipassword' => 1,
	'wi-fissid' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'wifirssi' => 1,
	'winddirection' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'windprocessing' => 1,
	'windspeed' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'word97' => 1,
	'worddocument' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wpgversion' => 1,
	'wrapmodes' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xattrapplemaildatereceived' => 1,
	'xattrapplemaildatesent' => 1,
	'xattrapplemailisremoteattachment' => 1,
	'xattrfinderinfo' => 1,
	'xattrlastuseddate' => 1,
	'xattrmditemdownloadeddate' => 1,
	'xattrmditemfindercomment' => 1,
	'xattrmdlabel' => 1,
	'xattrresourcefork' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xidiri' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmlpackets' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpdsa' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'ycrcbmatrix' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilecomment' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zisrawversion' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
	'zoomposition' => 1,
	'zoomscalenormalization' => 1,
	'zoomstrength' => 1,
	'zxif' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'gpslatitude' => 'Image::ExifTool::GPS',
	'gpslongitude' => 'Image::ExifTool::GPS',
	'gpsposition' => 'Image::ExifTool::Exif',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'rotation' => 'Image::ExifTool::QuickTime',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
    GROUPS      => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names to lookup corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level structure
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '${strName}'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                my $lcFlat = $$newInfo{FlatName} ? lc($$newInfo{FlatName}) : $lcTag;
                AddFields($tagTablePtr, $tagID, $lcFlat, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (sort { $a <=> $b } keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        no strict 'refs';
                        $reload = 1 if &$writeProc();
                    }
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2025, Phil Harvey (philharvey66 at gmail.com)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
