import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_DeleteRealtimeLogConfigCommand, se_DeleteRealtimeLogConfigCommand } from "../protocols/Aws_restXml";
export { $Command };
export class DeleteRealtimeLogConfigCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("Cloudfront2020_05_31", "DeleteRealtimeLogConfig", {})
    .n("CloudFrontClient", "DeleteRealtimeLogConfigCommand")
    .f(void 0, void 0)
    .ser(se_DeleteRealtimeLogConfigCommand)
    .de(de_DeleteRealtimeLogConfigCommand)
    .build() {
}
