/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.tools;

import java.io.Console;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.hasher.PasswordHasher;
import org.opensearch.security.hasher.PasswordHasherFactory;

public class Hasher {
    private static final String PASSWORD_OPTION = "p";
    private static final String ENV_OPTION = "env";
    private static final String ALGORITHM_OPTION = "a";
    private static final String ROUNDS_OPTION = "r";
    private static final String FUNCTION_OPTION = "f";
    private static final String LENGTH_OPTION = "l";
    private static final String ITERATIONS_OPTION = "i";
    private static final String MINOR_OPTION = "min";
    private static final String HELP_OPTION = "h";

    public static void main(String[] args) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setOptionComparator(null);
        Options options = Hasher.buildOptions();
        DefaultParser parser = new DefaultParser();
        try {
            char[] password;
            CommandLine line = parser.parse(options, args);
            if (line.hasOption(HELP_OPTION)) {
                formatter.printHelp("hash.sh", options, true);
                System.exit(0);
            }
            if (line.hasOption(PASSWORD_OPTION)) {
                password = line.getOptionValue(PASSWORD_OPTION).toCharArray();
            } else if (line.hasOption(ENV_OPTION)) {
                String pwd = System.getenv(line.getOptionValue(ENV_OPTION));
                if (pwd == null || pwd.isEmpty()) {
                    throw new Exception("No environment variable '" + line.getOptionValue(ENV_OPTION) + "' set");
                }
                password = pwd.toCharArray();
            } else {
                Console console = System.console();
                if (console == null) {
                    throw new Exception("Cannot allocate a console");
                }
                password = console.readPassword("[%s]", "Password:");
            }
            if (line.hasOption(ALGORITHM_OPTION)) {
                String algorithm = line.getOptionValue(ALGORITHM_OPTION);
                System.out.println(Hasher.hash(password, switch (algorithm.toLowerCase()) {
                    case "bcrypt" -> Hasher.getBCryptSettings(line);
                    case "pbkdf2" -> Hasher.getPBKDF2Settings(line);
                    default -> throw new Exception("Unsupported hashing algorithm: " + algorithm);
                }));
            } else {
                System.out.println(Hasher.hash(password));
            }
        }
        catch (Exception exp) {
            System.err.println("Parsing failed.  Reason: " + exp.getMessage());
            formatter.printHelp("hash.sh", options, true);
            System.exit(-1);
        }
    }

    public static String hash(char[] clearTextPassword) {
        return Hasher.hash(clearTextPassword, Settings.EMPTY);
    }

    public static String hash(char[] clearTextPassword, Settings settings) {
        PasswordHasher passwordHasher = PasswordHasherFactory.createPasswordHasher(settings);
        return passwordHasher.hash(clearTextPassword);
    }

    private static Settings getBCryptSettings(CommandLine line) throws ParseException {
        Settings.Builder settings = Settings.builder();
        settings.put("plugins.security.password.hashing.algorithm", "bcrypt");
        if (line.hasOption(ROUNDS_OPTION)) {
            settings.put("plugins.security.password.hashing.bcrypt.rounds", ((Number)line.getParsedOptionValue(ROUNDS_OPTION)).intValue());
        }
        if (line.hasOption(MINOR_OPTION)) {
            settings.put("plugins.security.password.hashing.bcrypt.minor", line.getOptionValue(MINOR_OPTION).toUpperCase());
        }
        return settings.build();
    }

    private static Settings getPBKDF2Settings(CommandLine line) throws ParseException {
        Settings.Builder settings = Settings.builder();
        settings.put("plugins.security.password.hashing.algorithm", "pbkdf2");
        if (line.hasOption(FUNCTION_OPTION)) {
            settings.put("plugins.security.password.hashing.pbkdf2.function", line.getOptionValue(FUNCTION_OPTION));
        }
        if (line.hasOption(LENGTH_OPTION)) {
            settings.put("plugins.security.password.hashing.pbkdf2.length", ((Number)line.getParsedOptionValue(LENGTH_OPTION)).intValue());
        }
        if (line.hasOption(ITERATIONS_OPTION)) {
            settings.put("plugins.security.password.hashing.pbkdf2.iterations", ((Number)line.getParsedOptionValue(ITERATIONS_OPTION)).intValue());
        }
        return settings.build();
    }

    private static Options buildOptions() {
        Options options = new Options();
        options.addOption(Option.builder((String)HELP_OPTION).longOpt("help").desc("Display the help information").argName("help").build());
        options.addOption(Option.builder((String)PASSWORD_OPTION).longOpt("password").argName("password").hasArg().desc("Cleartext password to hash").build());
        options.addOption(Option.builder((String)ENV_OPTION).argName("Environment variable name").hasArg().desc("Environment variable name to read password from").build());
        options.addOption(Option.builder((String)ALGORITHM_OPTION).longOpt("algorithm").argName("hashing algorithm").hasArg().desc("Algorithm to use for password hashing. Valid values are: BCrypt | PBKDF2. Default: BCrypt").build());
        options.addOption(Option.builder((String)ROUNDS_OPTION).longOpt("rounds").desc("Number of rounds to use in logarithmic form. Valid values are: 4 to 31. Default: 12").hasArg().argName("rounds (BCrypt)").type(Number.class).build());
        options.addOption(Option.builder((String)MINOR_OPTION).longOpt("minor").desc("Version of BCrypt algorithm to use. Valid values are: A | B | Y. Default: Y").hasArg().argName("minor (BCrypt)").build());
        options.addOption(Option.builder((String)LENGTH_OPTION).longOpt("length").desc("Desired length of the final derived key. Default: 256").hasArg().argName("length (PBKDF2)").type(Number.class).build());
        options.addOption(Option.builder((String)FUNCTION_OPTION).longOpt("function").desc("Pseudo-random function applied to the password. Valid values are SHA1 | SHA224 | SHA256 | SHA384 | SHA512. Default: SHA256").hasArg().argName("function (PBDKF2)").build());
        options.addOption(Option.builder((String)ITERATIONS_OPTION).longOpt("iterations").desc("Number of times the pseudo-random function is applied to the password. Default: 600000").hasArg().argName("iterations (PBKDF2)").type(Number.class).build());
        return options;
    }
}

