/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api.ssl;

import java.io.IOException;
import java.util.Optional;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.support.nodes.BaseNodesRequest;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.security.ssl.config.CertType;

public class CertificatesInfoNodesRequest
extends BaseNodesRequest<CertificatesInfoNodesRequest> {
    private final String certificateType;
    private final boolean inMemory;

    public CertificatesInfoNodesRequest(String certificateType, boolean inMemory, String ... nodesIds) {
        super(nodesIds);
        this.certificateType = certificateType;
        this.inMemory = inMemory;
    }

    public CertificatesInfoNodesRequest(StreamInput in) throws IOException {
        super(in);
        this.certificateType = in.readOptionalString();
        this.inMemory = in.readBoolean();
    }

    public Optional<String> certificateType() {
        return Optional.ofNullable(this.certificateType);
    }

    public boolean inMemory() {
        return this.inMemory;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.certificateType);
        out.writeBoolean(this.inMemory);
    }

    public ActionRequestValidationException validate() {
        if (!Strings.isEmpty((CharSequence)this.certificateType) && !CertType.TYPES.contains(this.certificateType)) {
            ActionRequestValidationException errorMessage = new ActionRequestValidationException();
            errorMessage.addValidationError("wrong certificate type " + this.certificateType + ". Please use one of " + String.valueOf(CertType.TYPES));
            return errorMessage;
        }
        return super.validate();
    }
}

