/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import jakarta.json.bind.JsonbException;
import java.lang.reflect.Type;
import org.eclipse.yasson.internal.Unmarshaller;
import org.eclipse.yasson.internal.model.customization.Customization;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.AbstractNumberDeserializer;

public class ShortTypeDeserializer
extends AbstractNumberDeserializer<Short> {
    public ShortTypeDeserializer(Customization customization) {
        super(Short.class, customization);
    }

    @Override
    protected Short deserialize(String jsonValue, Unmarshaller unmarshaller, Type rtType) {
        return this.deserializeFormatted(jsonValue, true, unmarshaller.getJsonbContext()).map(num -> Short.parseShort(num.toString())).orElseGet(() -> {
            try {
                return Short.parseShort(jsonValue);
            }
            catch (NumberFormatException e) {
                throw new JsonbException(Messages.getMessage(MessageKeys.DESERIALIZE_VALUE_ERROR, Short.class));
            }
        });
    }
}

