/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.highlight.extractor;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.opensearch.index.search.OpenSearchToParentBlockJoinQuery;
import org.opensearch.neuralsearch.highlight.extractor.BooleanQueryTextExtractor;
import org.opensearch.neuralsearch.highlight.extractor.HybridQueryTextExtractor;
import org.opensearch.neuralsearch.highlight.extractor.NestedQueryTextExtractor;
import org.opensearch.neuralsearch.highlight.extractor.NeuralQueryTextExtractor;
import org.opensearch.neuralsearch.highlight.extractor.QueryTextExtractor;
import org.opensearch.neuralsearch.highlight.extractor.TermQueryTextExtractor;
import org.opensearch.neuralsearch.query.HybridQuery;
import org.opensearch.neuralsearch.query.NeuralKNNQuery;

public class QueryTextExtractorRegistry {
    @Generated
    private static final Logger log = LogManager.getLogger(QueryTextExtractorRegistry.class);
    private final Map<Class<? extends Query>, QueryTextExtractor> extractors = new HashMap<Class<? extends Query>, QueryTextExtractor>();

    public QueryTextExtractorRegistry() {
        this.initialize();
    }

    private void initialize() {
        this.register(NeuralKNNQuery.class, new NeuralQueryTextExtractor());
        this.register(TermQuery.class, new TermQueryTextExtractor());
        this.register(HybridQuery.class, new HybridQueryTextExtractor(this));
        this.register(OpenSearchToParentBlockJoinQuery.class, new NestedQueryTextExtractor(this));
        this.register(BooleanQuery.class, new BooleanQueryTextExtractor(this));
    }

    public <T extends Query> void register(Class<T> queryClass, QueryTextExtractor extractor) {
        this.extractors.put(queryClass, extractor);
    }

    public String extractQueryText(Query query, String fieldName) {
        if (query == null) {
            log.warn("Cannot extract text from null query");
            return null;
        }
        Class<?> queryClass = query.getClass();
        QueryTextExtractor extractor = this.extractors.get(queryClass);
        if (extractor == null) {
            log.warn("No extractor found for query type: {}", (Object)queryClass.getName());
            return null;
        }
        return extractor.extractQueryText(query, fieldName);
    }
}

