/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.HostnameType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchTemplatePrivateDnsNameOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchTemplatePrivateDnsNameOptions> {
    private static final SdkField<String> HOSTNAME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostnameType").getter(LaunchTemplatePrivateDnsNameOptions.getter(LaunchTemplatePrivateDnsNameOptions::hostnameTypeAsString)).setter(LaunchTemplatePrivateDnsNameOptions.setter(Builder::hostnameType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostnameType").unmarshallLocationName("hostnameType").build()}).build();
    private static final SdkField<Boolean> ENABLE_RESOURCE_NAME_DNS_A_RECORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableResourceNameDnsARecord").getter(LaunchTemplatePrivateDnsNameOptions.getter(LaunchTemplatePrivateDnsNameOptions::enableResourceNameDnsARecord)).setter(LaunchTemplatePrivateDnsNameOptions.setter(Builder::enableResourceNameDnsARecord)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableResourceNameDnsARecord").unmarshallLocationName("enableResourceNameDnsARecord").build()}).build();
    private static final SdkField<Boolean> ENABLE_RESOURCE_NAME_DNS_AAAA_RECORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableResourceNameDnsAAAARecord").getter(LaunchTemplatePrivateDnsNameOptions.getter(LaunchTemplatePrivateDnsNameOptions::enableResourceNameDnsAAAARecord)).setter(LaunchTemplatePrivateDnsNameOptions.setter(Builder::enableResourceNameDnsAAAARecord)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableResourceNameDnsAAAARecord").unmarshallLocationName("enableResourceNameDnsAAAARecord").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTNAME_TYPE_FIELD, ENABLE_RESOURCE_NAME_DNS_A_RECORD_FIELD, ENABLE_RESOURCE_NAME_DNS_AAAA_RECORD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LaunchTemplatePrivateDnsNameOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String hostnameType;
    private final Boolean enableResourceNameDnsARecord;
    private final Boolean enableResourceNameDnsAAAARecord;

    private LaunchTemplatePrivateDnsNameOptions(BuilderImpl builder) {
        this.hostnameType = builder.hostnameType;
        this.enableResourceNameDnsARecord = builder.enableResourceNameDnsARecord;
        this.enableResourceNameDnsAAAARecord = builder.enableResourceNameDnsAAAARecord;
    }

    public final HostnameType hostnameType() {
        return HostnameType.fromValue(this.hostnameType);
    }

    public final String hostnameTypeAsString() {
        return this.hostnameType;
    }

    public final Boolean enableResourceNameDnsARecord() {
        return this.enableResourceNameDnsARecord;
    }

    public final Boolean enableResourceNameDnsAAAARecord() {
        return this.enableResourceNameDnsAAAARecord;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostnameTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableResourceNameDnsARecord());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableResourceNameDnsAAAARecord());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplatePrivateDnsNameOptions)) {
            return false;
        }
        LaunchTemplatePrivateDnsNameOptions other = (LaunchTemplatePrivateDnsNameOptions)obj;
        return Objects.equals(this.hostnameTypeAsString(), other.hostnameTypeAsString()) && Objects.equals(this.enableResourceNameDnsARecord(), other.enableResourceNameDnsARecord()) && Objects.equals(this.enableResourceNameDnsAAAARecord(), other.enableResourceNameDnsAAAARecord());
    }

    public final String toString() {
        return ToString.builder((String)"LaunchTemplatePrivateDnsNameOptions").add("HostnameType", (Object)this.hostnameTypeAsString()).add("EnableResourceNameDnsARecord", (Object)this.enableResourceNameDnsARecord()).add("EnableResourceNameDnsAAAARecord", (Object)this.enableResourceNameDnsAAAARecord()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostnameType": {
                return Optional.ofNullable(clazz.cast(this.hostnameTypeAsString()));
            }
            case "EnableResourceNameDnsARecord": {
                return Optional.ofNullable(clazz.cast(this.enableResourceNameDnsARecord()));
            }
            case "EnableResourceNameDnsAAAARecord": {
                return Optional.ofNullable(clazz.cast(this.enableResourceNameDnsAAAARecord()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("HostnameType", HOSTNAME_TYPE_FIELD);
        map.put("EnableResourceNameDnsARecord", ENABLE_RESOURCE_NAME_DNS_A_RECORD_FIELD);
        map.put("EnableResourceNameDnsAAAARecord", ENABLE_RESOURCE_NAME_DNS_AAAA_RECORD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplatePrivateDnsNameOptions, T> g) {
        return obj -> g.apply((LaunchTemplatePrivateDnsNameOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String hostnameType;
        private Boolean enableResourceNameDnsARecord;
        private Boolean enableResourceNameDnsAAAARecord;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplatePrivateDnsNameOptions model) {
            this.hostnameType(model.hostnameType);
            this.enableResourceNameDnsARecord(model.enableResourceNameDnsARecord);
            this.enableResourceNameDnsAAAARecord(model.enableResourceNameDnsAAAARecord);
        }

        public final String getHostnameType() {
            return this.hostnameType;
        }

        public final void setHostnameType(String hostnameType) {
            this.hostnameType = hostnameType;
        }

        @Override
        public final Builder hostnameType(String hostnameType) {
            this.hostnameType = hostnameType;
            return this;
        }

        @Override
        public final Builder hostnameType(HostnameType hostnameType) {
            this.hostnameType(hostnameType == null ? null : hostnameType.toString());
            return this;
        }

        public final Boolean getEnableResourceNameDnsARecord() {
            return this.enableResourceNameDnsARecord;
        }

        public final void setEnableResourceNameDnsARecord(Boolean enableResourceNameDnsARecord) {
            this.enableResourceNameDnsARecord = enableResourceNameDnsARecord;
        }

        @Override
        public final Builder enableResourceNameDnsARecord(Boolean enableResourceNameDnsARecord) {
            this.enableResourceNameDnsARecord = enableResourceNameDnsARecord;
            return this;
        }

        public final Boolean getEnableResourceNameDnsAAAARecord() {
            return this.enableResourceNameDnsAAAARecord;
        }

        public final void setEnableResourceNameDnsAAAARecord(Boolean enableResourceNameDnsAAAARecord) {
            this.enableResourceNameDnsAAAARecord = enableResourceNameDnsAAAARecord;
        }

        @Override
        public final Builder enableResourceNameDnsAAAARecord(Boolean enableResourceNameDnsAAAARecord) {
            this.enableResourceNameDnsAAAARecord = enableResourceNameDnsAAAARecord;
            return this;
        }

        public LaunchTemplatePrivateDnsNameOptions build() {
            return new LaunchTemplatePrivateDnsNameOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchTemplatePrivateDnsNameOptions> {
        public Builder hostnameType(String var1);

        public Builder hostnameType(HostnameType var1);

        public Builder enableResourceNameDnsARecord(Boolean var1);

        public Builder enableResourceNameDnsAAAARecord(Boolean var1);
    }
}

