"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineRoutes = defineRoutes;
var _QueryService = _interopRequireDefault(require("../services/QueryService"));
var _TranslateService = _interopRequireDefault(require("../services/TranslateService"));
var _query = require("./query");
var _translate = _interopRequireDefault(require("./translate"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function defineRoutes(router, client, openSearchServiceSetup, dataSourceEnabled, logger) {
  const translateService = new _TranslateService.default(client, dataSourceEnabled, logger);
  (0, _translate.default)(router, translateService, openSearchServiceSetup);
  const queryService = new _QueryService.default(client, dataSourceEnabled, logger);
  (0, _query.registerQueryRoute)(router, queryService);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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