"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _JSONNestedNode = _interopRequireDefault(require("./JSONNestedNode"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

// Returns the "n Items" string for this node,
// generating and caching it if it hasn't been created yet.
function createItemString(data) {
  var len = Object.getOwnPropertyNames(data).length;
  return "".concat(len, " ").concat(len !== 1 ? 'keys' : 'key');
} // Configures <JSONNestedNode> to render an Object


var JSONObjectNode = function JSONObjectNode(_ref) {
  var data = _ref.data,
      props = _objectWithoutProperties(_ref, ["data"]);

  return /*#__PURE__*/_react["default"].createElement(_JSONNestedNode["default"], _extends({}, props, {
    data: data,
    nodeType: "Object",
    nodeTypeIndicator: props.nodeType === 'Error' ? 'Error()' : '{}',
    createItemString: createItemString,
    expandable: Object.getOwnPropertyNames(data).length > 0
  }));
};

JSONObjectNode.propTypes = {
  data: _propTypes["default"].object,
  nodeType: _propTypes["default"].string
};
var _default = JSONObjectNode;
exports["default"] = _default;