"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiSuperUpdateButton", {
  enumerable: true,
  get: function get() {
    return _super_update_button.EuiSuperUpdateButton;
  }
});
exports.OuiSuperUpdateButton = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _button = require("../../button");

var _i18n = require("../../i18n");

var _tool_tip = require("../../tool_tip");

var _super_update_button = require("../../../eui_components/date_picker/super_date_picker/super_update_button");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } } /*
                                                                                                                                                                                                                                                                                                                                      * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                                      *
                                                                                                                                                                                                                                                                                                                                      * The OpenSearch Contributors require contributions made to
                                                                                                                                                                                                                                                                                                                                      * this file be licensed under the Apache-2.0 license or a
                                                                                                                                                                                                                                                                                                                                      * compatible open source license.
                                                                                                                                                                                                                                                                                                                                      *
                                                                                                                                                                                                                                                                                                                                      * Modifications Copyright OpenSearch Contributors. See
                                                                                                                                                                                                                                                                                                                                      * GitHub history for details.
                                                                                                                                                                                                                                                                                                                                      */ /*
                                                                                                                                                                                                                                                                                                                                          * Licensed to Elasticsearch B.V. under one or more contributor
                                                                                                                                                                                                                                                                                                                                          * license agreements. See the NOTICE file distributed with
                                                                                                                                                                                                                                                                                                                                          * this work for additional information regarding copyright
                                                                                                                                                                                                                                                                                                                                          * ownership. Elasticsearch B.V. licenses this file to you under
                                                                                                                                                                                                                                                                                                                                          * the Apache License, Version 2.0 (the "License"); you may
                                                                                                                                                                                                                                                                                                                                          * not use this file except in compliance with the License.
                                                                                                                                                                                                                                                                                                                                          * You may obtain a copy of the License at
                                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                                          *    http://www.apache.org/licenses/LICENSE-2.0
                                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                                          * Unless required by applicable law or agreed to in writing,
                                                                                                                                                                                                                                                                                                                                          * software distributed under the License is distributed on an
                                                                                                                                                                                                                                                                                                                                          * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
                                                                                                                                                                                                                                                                                                                                          * KIND, either express or implied.  See the License for the
                                                                                                                                                                                                                                                                                                                                          * specific language governing permissions and limitations
                                                                                                                                                                                                                                                                                                                                          * under the License.
                                                                                                                                                                                                                                                                                                                                          */

var OuiSuperUpdateButton = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(OuiSuperUpdateButton, _Component);

  var _super = _createSuper(OuiSuperUpdateButton);

  function OuiSuperUpdateButton() {
    var _this;

    (0, _classCallCheck2.default)(this, OuiSuperUpdateButton);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "_isMounted", false);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "tooltipTimeout", void 0);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "tooltip", null);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "setTootipRef", function (node) {
      _this.tooltip = node;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "showTooltip", function () {
      if (!_this._isMounted || !_this.tooltip) {
        return;
      }

      _this.tooltip.showToolTip();
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "hideTooltip", function () {
      if (!_this._isMounted || !_this.tooltip) {
        return;
      }

      _this.tooltip.hideToolTip();
    });
    return _this;
  }

  (0, _createClass2.default)(OuiSuperUpdateButton, [{
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this._isMounted = false;
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this._isMounted = true;
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      var _this2 = this;

      if (this.props.showTooltip && this.props.needsUpdate && !this.props.isDisabled && !this.props.isLoading) {
        this.showTooltip();
        this.tooltipTimeout = setTimeout(function () {
          _this2.hideTooltip();
        }, 2000);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          className = _this$props.className,
          needsUpdate = _this$props.needsUpdate,
          isLoading = _this$props.isLoading,
          isDisabled = _this$props.isDisabled,
          onClick = _this$props.onClick,
          toolTipProps = _this$props.toolTipProps,
          showTooltip = _this$props.showTooltip,
          compressed = _this$props.compressed,
          restTextProps = _this$props.textProps,
          rest = (0, _objectWithoutProperties2.default)(_this$props, ["className", "needsUpdate", "isLoading", "isDisabled", "onClick", "toolTipProps", "showTooltip", "compressed", "textProps"]);
      var classes = (0, _classnames.default)('ouiSuperUpdateButton', className);

      var buttonText = /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
        token: "ouiSuperUpdateButton.refreshButtonLabel",
        default: "Refresh"
      });

      if (needsUpdate || isLoading) {
        buttonText = isLoading ? /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
          token: "ouiSuperUpdateButton.updatingButtonLabel",
          default: "Updating"
        }) : /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
          token: "ouiSuperUpdateButton.updateButtonLabel",
          default: "Update"
        });
      }

      var tooltipContent;

      if (isDisabled) {
        tooltipContent = /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
          token: "ouiSuperUpdateButton.cannotUpdateTooltip",
          default: "Cannot update"
        });
      } else if (needsUpdate && !isLoading) {
        tooltipContent = /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
          token: "ouiSuperUpdateButton.clickToApplyTooltip",
          default: "Click to apply"
        });
      }

      return /*#__PURE__*/_react.default.createElement(_tool_tip.OuiToolTip, (0, _extends2.default)({
        ref: this.setTootipRef,
        content: tooltipContent,
        position: "bottom"
      }, toolTipProps), /*#__PURE__*/_react.default.createElement(_button.OuiButton, (0, _extends2.default)({
        className: classes,
        color: needsUpdate || isLoading ? 'success' : 'primary',
        iconType: "refresh",
        textProps: _objectSpread(_objectSpread({}, restTextProps), {}, {
          className: (0, _classnames.default)('ouiSuperUpdateButton__text', restTextProps === null || restTextProps === void 0 ? void 0 : restTextProps.className)
        }),
        isDisabled: isDisabled,
        onClick: onClick,
        isLoading: isLoading,
        size: compressed ? 's' : 'm'
      }, rest), buttonText));
    }
  }]);
  return OuiSuperUpdateButton;
}(_react.Component);
/* OUI -> EUI Aliases: Build-Time */


exports.OuiSuperUpdateButton = OuiSuperUpdateButton;
(0, _defineProperty2.default)(OuiSuperUpdateButton, "defaultProps", {
  needsUpdate: false,
  isLoading: false,
  isDisabled: false,
  showTooltip: false,
  compressed: false
});
OuiSuperUpdateButton.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  isDisabled: _propTypes.default.bool.isRequired,
  isLoading: _propTypes.default.bool.isRequired,
  needsUpdate: _propTypes.default.bool.isRequired,
  onClick: _propTypes.default.func.isRequired,

  /**
       * Passes props to `OuiToolTip`
       */
  toolTipProps: _propTypes.default.shape({
    /**
       * Passes onto the the trigger.
       */
    anchorClassName: _propTypes.default.string,

    /**
       * The in-view trigger for your tooltip.
       */
    children: _propTypes.default.element.isRequired,

    /**
       * Passes onto the tooltip itself, not the trigger.
       */
    className: _propTypes.default.string,

    /**
       * The main content of your tooltip.
       */
    content: _propTypes.default.node,

    /**
       * Common display alternatives for the anchor wrapper
       */
    display: _propTypes.default.oneOf(["inlineBlock", "block"]),

    /**
       * Delay before showing tooltip. Good for repeatable items.
       */
    delay: _propTypes.default.oneOf(["regular", "long"]).isRequired,

    /**
       * An optional title for your tooltip.
       */
    title: _propTypes.default.node,

    /**
       * Unless you provide one, this will be randomly generated.
       */
    id: _propTypes.default.string,

    /**
       * Suggested position. If there is not enough room for it this will be changed.
       */
    position: _propTypes.default.oneOf(["top", "right", "bottom", "left"]).isRequired,

    /**
       * If supplied, called when mouse movement causes the tool tip to be
       * hidden.
       */
    onMouseOut: _propTypes.default.func
  }),

  /**
       * Show the "Click to apply" tooltip
       */
  showTooltip: _propTypes.default.bool.isRequired,
  compressed: _propTypes.default.bool
};
/* OUI -> EUI Aliases: Build-Time */