/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TreeTableColumn;

class TableUtil {
    private static final double EPSILON = 1.0E-7;

    private TableUtil() {
    }

    static void removeTableColumnListener(List<? extends TableColumnBase> list, InvalidationListener invalidationListener, InvalidationListener invalidationListener2, InvalidationListener invalidationListener3, InvalidationListener invalidationListener4) {
        if (list == null) {
            return;
        }
        for (TableColumnBase tableColumnBase : list) {
            tableColumnBase.visibleProperty().removeListener(invalidationListener);
            tableColumnBase.sortableProperty().removeListener(invalidationListener2);
            tableColumnBase.comparatorProperty().removeListener(invalidationListener4);
            if (tableColumnBase instanceof TableColumn) {
                ((TableColumn)tableColumnBase).sortTypeProperty().removeListener(invalidationListener3);
            } else if (tableColumnBase instanceof TreeTableColumn) {
                ((TreeTableColumn)tableColumnBase).sortTypeProperty().removeListener(invalidationListener3);
            }
            TableUtil.removeTableColumnListener(tableColumnBase.getColumns(), invalidationListener, invalidationListener2, invalidationListener3, invalidationListener4);
        }
    }

    static void addTableColumnListener(List<? extends TableColumnBase> list, InvalidationListener invalidationListener, InvalidationListener invalidationListener2, InvalidationListener invalidationListener3, InvalidationListener invalidationListener4) {
        if (list == null) {
            return;
        }
        for (TableColumnBase tableColumnBase : list) {
            tableColumnBase.visibleProperty().addListener(invalidationListener);
            tableColumnBase.sortableProperty().addListener(invalidationListener2);
            tableColumnBase.comparatorProperty().addListener(invalidationListener4);
            if (tableColumnBase instanceof TableColumn) {
                ((TableColumn)tableColumnBase).sortTypeProperty().addListener(invalidationListener3);
            } else if (tableColumnBase instanceof TreeTableColumn) {
                ((TreeTableColumn)tableColumnBase).sortTypeProperty().addListener(invalidationListener3);
            }
            TableUtil.addTableColumnListener(tableColumnBase.getColumns(), invalidationListener, invalidationListener2, invalidationListener3, invalidationListener4);
        }
    }

    static void removeColumnsListener(List<? extends TableColumnBase> list, ListChangeListener listChangeListener) {
        if (list == null) {
            return;
        }
        for (TableColumnBase tableColumnBase : list) {
            tableColumnBase.getColumns().removeListener(listChangeListener);
            TableUtil.removeColumnsListener(tableColumnBase.getColumns(), listChangeListener);
        }
    }

    static void addColumnsListener(List<? extends TableColumnBase> list, ListChangeListener listChangeListener) {
        if (list == null) {
            return;
        }
        for (TableColumnBase tableColumnBase : list) {
            tableColumnBase.getColumns().addListener(listChangeListener);
            TableUtil.addColumnsListener(tableColumnBase.getColumns(), listChangeListener);
        }
    }

    static void handleSortFailure(ObservableList<? extends TableColumnBase> observableList, SortEventType sortEventType, Object ... objectArray) {
        if (sortEventType == SortEventType.COLUMN_SORT_TYPE_CHANGE) {
            TableColumnBase tableColumnBase = (TableColumnBase)objectArray[0];
            TableUtil.revertSortType(tableColumnBase);
        } else if (sortEventType == SortEventType.SORT_ORDER_CHANGE) {
            ListChangeListener.Change change = (ListChangeListener.Change)objectArray[0];
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            while (change.next()) {
                if (change.wasAdded()) {
                    arrayList.addAll(change.getAddedSubList());
                }
                if (!change.wasRemoved()) continue;
                arrayList2.addAll(change.getRemoved());
            }
            observableList.removeAll(arrayList);
            observableList.addAll(arrayList2);
        } else if (sortEventType == SortEventType.COLUMN_SORTABLE_CHANGE || sortEventType == SortEventType.COLUMN_COMPARATOR_CHANGE) {
            // empty if block
        }
    }

    private static void revertSortType(TableColumnBase tableColumnBase) {
        if (tableColumnBase instanceof TableColumn) {
            TableColumn tableColumn = (TableColumn)tableColumnBase;
            TableColumn.SortType sortType = tableColumn.getSortType();
            if (sortType == TableColumn.SortType.ASCENDING) {
                tableColumn.setSortType(null);
            } else if (sortType == TableColumn.SortType.DESCENDING) {
                tableColumn.setSortType(TableColumn.SortType.ASCENDING);
            } else if (sortType == null) {
                tableColumn.setSortType(TableColumn.SortType.DESCENDING);
            }
        } else if (tableColumnBase instanceof TreeTableColumn) {
            TreeTableColumn treeTableColumn = (TreeTableColumn)tableColumnBase;
            TreeTableColumn.SortType sortType = treeTableColumn.getSortType();
            if (sortType == TreeTableColumn.SortType.ASCENDING) {
                treeTableColumn.setSortType(null);
            } else if (sortType == TreeTableColumn.SortType.DESCENDING) {
                treeTableColumn.setSortType(TreeTableColumn.SortType.ASCENDING);
            } else if (sortType == null) {
                treeTableColumn.setSortType(TreeTableColumn.SortType.DESCENDING);
            }
        }
    }

    static double resize(TableColumnBase tableColumnBase, double d) {
        if (d == 0.0) {
            return 0.0;
        }
        if (!tableColumnBase.isResizable()) {
            return d;
        }
        boolean bl = d < 0.0;
        List<TableColumnBase<?, ?>> list = TableUtil.getResizableChildren(tableColumnBase, bl);
        if (list.size() > 0) {
            return TableUtil.resizeColumns(list, d);
        }
        double d2 = tableColumnBase.getWidth() + d;
        if (d2 > tableColumnBase.getMaxWidth()) {
            tableColumnBase.doSetWidth(tableColumnBase.getMaxWidth());
            return d2 - tableColumnBase.getMaxWidth();
        }
        if (d2 < tableColumnBase.getMinWidth()) {
            tableColumnBase.doSetWidth(tableColumnBase.getMinWidth());
            return d2 - tableColumnBase.getMinWidth();
        }
        tableColumnBase.doSetWidth(d2);
        return 0.0;
    }

    private static List<TableColumnBase<?, ?>> getResizableChildren(TableColumnBase<?, ?> tableColumnBase, boolean bl) {
        if (tableColumnBase == null || tableColumnBase.getColumns().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList arrayList = new ArrayList();
        for (TableColumnBase tableColumnBase2 : tableColumnBase.getColumns()) {
            if (!tableColumnBase2.isVisible() || !tableColumnBase2.isResizable()) continue;
            if (bl && tableColumnBase2.getWidth() > tableColumnBase2.getMinWidth()) {
                arrayList.add(tableColumnBase2);
                continue;
            }
            if (bl || !(tableColumnBase2.getWidth() < tableColumnBase2.getMaxWidth())) continue;
            arrayList.add(tableColumnBase2);
        }
        return arrayList;
    }

    private static double resizeColumns(List<? extends TableColumnBase<?, ?>> list, double d) {
        int n = list.size();
        double d2 = d / (double)n;
        double d3 = d;
        int n2 = 0;
        boolean bl = true;
        for (TableColumnBase<?, ?> tableColumnBase : list) {
            ++n2;
            double d4 = TableUtil.resize(tableColumnBase, d2);
            d3 = d3 - d2 + d4;
            if (d4 == 0.0) continue;
            bl = false;
            d2 = d3 / (double)(n - n2);
        }
        return bl ? 0.0 : d3;
    }

    static enum SortEventType {
        SORT_ORDER_CHANGE,
        COLUMN_SORT_TYPE_CHANGE,
        COLUMN_SORTABLE_CHANGE,
        COLUMN_COMPARATOR_CHANGE;

    }
}

