/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.awt.Color;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.openstreetmap.josm.data.gpx.GpxRoute;
import org.openstreetmap.josm.data.gpx.IGpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;

public class Line
implements Collection<WayPoint> {
    private final Collection<WayPoint> waypoints;
    private final boolean unordered;
    private final Color color;

    public Line(Collection<WayPoint> waypoints, Map<String, Object> attributes, Color color) {
        this.color = color;
        this.waypoints = Objects.requireNonNull(waypoints);
        this.unordered = attributes.isEmpty() && waypoints.stream().allMatch(x -> x.get("time") == null);
    }

    public Line(IGpxTrackSegment trackSegment, Map<String, Object> trackAttributes, Color color) {
        this(trackSegment.getWayPoints(), trackAttributes, color);
    }

    public Line(GpxRoute route) {
        this(route.routePoints, (Map<String, Object>)route.attr, null);
    }

    public boolean isUnordered() {
        return this.unordered;
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public int size() {
        return this.waypoints.size();
    }

    @Override
    public boolean isEmpty() {
        return this.waypoints.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.waypoints.contains(o);
    }

    @Override
    public Iterator<WayPoint> iterator() {
        return this.waypoints.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.waypoints.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.waypoints.toArray(a);
    }

    @Override
    public boolean add(WayPoint e) {
        return this.waypoints.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.waypoints.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.waypoints.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends WayPoint> c) {
        return this.waypoints.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.waypoints.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.waypoints.retainAll(c);
    }

    @Override
    public void clear() {
        this.waypoints.clear();
    }
}

