/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Computes an image of contours which will be the contour of the first
image.


A pixel of the source image is considered to belong to the contour if
its pixel value is equal to the input foreground value and it has in
its neighborhood at least one pixel which its pixel value is equal to
the input background value. The output image will have pixels which
will be set to the output foreground value if they belong to the
contour, otherwise they will be set to the output background value.

The neighborhood "radius" is set thanks to the radius params.
See:
 Image

 Neighborhood

 NeighborhoodOperator

 NeighborhoodIterator

 itk::simple::SimpleContourExtractor for the procedural interface

 itk::SimpleContourExtractorImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkSimpleContourExtractorImageFilter.h
*/
public class SimpleContourExtractorImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected SimpleContourExtractorImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.SimpleContourExtractorImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(SimpleContourExtractorImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(SimpleContourExtractorImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::SimpleContourExtractorImageFilter::~SimpleContourExtractorImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_SimpleContourExtractorImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::SimpleContourExtractorImageFilter::SimpleContourExtractorImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  SimpleContourExtractorImageFilter() {
    this(SimpleITKJNI.new_SimpleContourExtractorImageFilter(), true);
  }

  /**
Self&amp; itk::simple::SimpleContourExtractorImageFilter::SetInputForegroundValue(double InputForegroundValue)

Set the foreground value used in order to identify a foreground pixel
in the input image.

*/
public  void setInputForegroundValue(double InputForegroundValue) {
    SimpleITKJNI.SimpleContourExtractorImageFilter_setInputForegroundValue(swigCPtr, this, InputForegroundValue);
  }

  /**
double itk::simple::SimpleContourExtractorImageFilter::GetInputForegroundValue() const

Get the foreground value used in order to identify a foreground pixel
in the input image.

*/
public  double getInputForegroundValue() {
    return SimpleITKJNI.SimpleContourExtractorImageFilter_getInputForegroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::SimpleContourExtractorImageFilter::SetInputBackgroundValue(double InputBackgroundValue)

Set the background value used in order to identify a background pixel
in the input image.

*/
public  void setInputBackgroundValue(double InputBackgroundValue) {
    SimpleITKJNI.SimpleContourExtractorImageFilter_setInputBackgroundValue(swigCPtr, this, InputBackgroundValue);
  }

  /**
double itk::simple::SimpleContourExtractorImageFilter::GetInputBackgroundValue() const

Get the background value used in order to identify a background pixel
in the input image.

*/
public  double getInputBackgroundValue() {
    return SimpleITKJNI.SimpleContourExtractorImageFilter_getInputBackgroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::SimpleContourExtractorImageFilter::SetRadius(unsigned int value)

Set the values of the Radius vector all to value

*/
public  void setRadius(VectorUInt32 Radius) {
    SimpleITKJNI.SimpleContourExtractorImageFilter_setRadius__SWIG_0(swigCPtr, this, VectorUInt32.getCPtr(Radius), Radius);
  }

  /**
Self&amp; itk::simple::SimpleContourExtractorImageFilter::SetRadius(unsigned int value)

Set the values of the Radius vector all to value

*/
public  void setRadius(long value) {
    SimpleITKJNI.SimpleContourExtractorImageFilter_setRadius__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::SimpleContourExtractorImageFilter::GetRadius() const
*/
public  VectorUInt32 getRadius() {
    return new VectorUInt32(SimpleITKJNI.SimpleContourExtractorImageFilter_getRadius(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::SimpleContourExtractorImageFilter::SetOutputForegroundValue(double OutputForegroundValue)

Set the foreground value used in order to identify a foreground pixel
in the output image.

*/
public  void setOutputForegroundValue(double OutputForegroundValue) {
    SimpleITKJNI.SimpleContourExtractorImageFilter_setOutputForegroundValue(swigCPtr, this, OutputForegroundValue);
  }

  /**
double itk::simple::SimpleContourExtractorImageFilter::GetOutputForegroundValue() const

Get the foreground value used in order to identify a foreground pixel
in the output image.

*/
public  double getOutputForegroundValue() {
    return SimpleITKJNI.SimpleContourExtractorImageFilter_getOutputForegroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::SimpleContourExtractorImageFilter::SetOutputBackgroundValue(double OutputBackgroundValue)

Set the background value used in order to identify a background pixel
in the output image.

*/
public  void setOutputBackgroundValue(double OutputBackgroundValue) {
    SimpleITKJNI.SimpleContourExtractorImageFilter_setOutputBackgroundValue(swigCPtr, this, OutputBackgroundValue);
  }

  /**
double itk::simple::SimpleContourExtractorImageFilter::GetOutputBackgroundValue() const

Get the background value used in order to identify a background pixel
in the output image.

*/
public  double getOutputBackgroundValue() {
    return SimpleITKJNI.SimpleContourExtractorImageFilter_getOutputBackgroundValue(swigCPtr, this);
  }

  /**
std::string itk::simple::SimpleContourExtractorImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.SimpleContourExtractorImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::SimpleContourExtractorImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.SimpleContourExtractorImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::SimpleContourExtractorImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.SimpleContourExtractorImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
