/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Denoise an image using min/max curvature flow.


MinMaxCurvatureFlowImageFilter implements a curvature driven image denoising algorithm. Iso-
brightness contours in the grayscale input image are viewed as a level
set. The level set is then evolved using a curvature-based speed
function:

\\[ I_t = F_{\\mbox{minmax}} |\\nabla I| \\]

where $ F_{\\mbox{minmax}} = \\max(\\kappa,0) $ if $ \\mbox{Avg}_{\\mbox{stencil}}(x) $ is less than or equal to $ T_{threshold} $ and $ \\min(\\kappa,0) $ , otherwise. $ \\kappa $ is the mean curvature of the iso-brightness contour at point $ x $ .

In min/max curvature flow, movement is turned on or off depending on
the scale of the noise one wants to remove. Switching depends on the
average image value of a region of radius $ R $ around each point. The choice of $ R $ , the stencil radius, governs the scale of the noise to be removed.

The threshold value $ T_{threshold} $ is the average intensity obtained in the direction perpendicular to
the gradient at point $ x $ at the extrema of the local neighborhood.

This filter make use of the multi-threaded finite difference solver
hierarchy. Updates are computed using a MinMaxCurvatureFlowFunction object. A zero flux Neumann boundary condition is used when computing
derivatives near the data boundary.


WARNING:
This filter assumes that the input and output types have the same
dimensions. This filter also requires that the output image pixels are
of a real type. This filter works for any dimensional images, however
for dimensions greater than 3D, an expensive brute-force search is
used to compute the local threshold.
 Reference: "Level Set Methods and Fast Marching Methods", J.A.
Sethian, Cambridge Press, Chapter 16, Second edition, 1999.


See:
 MinMaxCurvatureFlowFunction

 CurvatureFlowImageFilter

 BinaryMinMaxCurvatureFlowImageFilter

 itk::simple::MinMaxCurvatureFlow for the procedural interface

 itk::MinMaxCurvatureFlowImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkMinMaxCurvatureFlowImageFilter.h
*/
public class MinMaxCurvatureFlowImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected MinMaxCurvatureFlowImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.MinMaxCurvatureFlowImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(MinMaxCurvatureFlowImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(MinMaxCurvatureFlowImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::MinMaxCurvatureFlowImageFilter::~MinMaxCurvatureFlowImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_MinMaxCurvatureFlowImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::MinMaxCurvatureFlowImageFilter::MinMaxCurvatureFlowImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  MinMaxCurvatureFlowImageFilter() {
    this(SimpleITKJNI.new_MinMaxCurvatureFlowImageFilter(), true);
  }

  /**
Self&amp; itk::simple::MinMaxCurvatureFlowImageFilter::SetTimeStep(double TimeStep)
*/
public  void setTimeStep(double TimeStep) {
    SimpleITKJNI.MinMaxCurvatureFlowImageFilter_setTimeStep(swigCPtr, this, TimeStep);
  }

  /**
double itk::simple::MinMaxCurvatureFlowImageFilter::GetTimeStep() const
*/
public  double getTimeStep() {
    return SimpleITKJNI.MinMaxCurvatureFlowImageFilter_getTimeStep(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::MinMaxCurvatureFlowImageFilter::SetNumberOfIterations(uint32_t NumberOfIterations)
*/
public  void setNumberOfIterations(long NumberOfIterations) {
    SimpleITKJNI.MinMaxCurvatureFlowImageFilter_setNumberOfIterations(swigCPtr, this, NumberOfIterations);
  }

  /**
uint32_t itk::simple::MinMaxCurvatureFlowImageFilter::GetNumberOfIterations() const
*/
public  long getNumberOfIterations() {
    return SimpleITKJNI.MinMaxCurvatureFlowImageFilter_getNumberOfIterations(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::MinMaxCurvatureFlowImageFilter::SetStencilRadius(int StencilRadius)

Set/Get the stencil radius.

*/
public  void setStencilRadius(int StencilRadius) {
    SimpleITKJNI.MinMaxCurvatureFlowImageFilter_setStencilRadius(swigCPtr, this, StencilRadius);
  }

  /**
int itk::simple::MinMaxCurvatureFlowImageFilter::GetStencilRadius() const

Set/Get the stencil radius.

*/
public  int getStencilRadius() {
    return SimpleITKJNI.MinMaxCurvatureFlowImageFilter_getStencilRadius(swigCPtr, this);
  }

  /**
std::string itk::simple::MinMaxCurvatureFlowImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.MinMaxCurvatureFlowImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::MinMaxCurvatureFlowImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.MinMaxCurvatureFlowImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::MinMaxCurvatureFlowImageFilter::Execute(Image &amp;&amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.MinMaxCurvatureFlowImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
