/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Labels the pixels on the border of the objects in a labeled image.


LabelContourImageFilter takes a labeled image as input, where the pixels in the objects are
the pixels with a value different of the BackgroundValue. Only the
pixels on the contours of the objects are kept. The pixels not on the
border are changed to BackgroundValue. The labels of the object are
the same in the input and in the output image.

The connectivity can be changed to minimum or maximum connectivity
with SetFullyConnected() . Full connectivity produces thicker contours.

https://doi.org/10.54294/c7d3gv


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 BinaryContourImageFilter

 itk::simple::LabelContour for the procedural interface

 itk::LabelContourImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkLabelContourImageFilter.h
*/
public class LabelContourImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected LabelContourImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.LabelContourImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(LabelContourImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(LabelContourImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::LabelContourImageFilter::~LabelContourImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_LabelContourImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::LabelContourImageFilter::LabelContourImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  LabelContourImageFilter() {
    this(SimpleITKJNI.new_LabelContourImageFilter(), true);
  }

  /**
Self&amp; itk::simple::LabelContourImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff.
For objects that are 1 pixel wide, use FullyConnectedOn.


*/
public  void setFullyConnected(boolean FullyConnected) {
    SimpleITKJNI.LabelContourImageFilter_setFullyConnected(swigCPtr, this, FullyConnected);
  }

  /**
Self&amp; itk::simple::LabelContourImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public  void fullyConnectedOn() {
    SimpleITKJNI.LabelContourImageFilter_fullyConnectedOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LabelContourImageFilter::FullyConnectedOff()
*/
public  void fullyConnectedOff() {
    SimpleITKJNI.LabelContourImageFilter_fullyConnectedOff(swigCPtr, this);
  }

  /**
bool itk::simple::LabelContourImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff.
For objects that are 1 pixel wide, use FullyConnectedOn.


*/
public  boolean getFullyConnected() {
    return SimpleITKJNI.LabelContourImageFilter_getFullyConnected(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LabelContourImageFilter::SetBackgroundValue(double BackgroundValue)

Set/Get the background value used to identify the objects and mark the
pixels not on the border of the objects.

*/
public  void setBackgroundValue(double BackgroundValue) {
    SimpleITKJNI.LabelContourImageFilter_setBackgroundValue(swigCPtr, this, BackgroundValue);
  }

  /**
double itk::simple::LabelContourImageFilter::GetBackgroundValue() const

Set/Get the background value used to identify the objects and mark the
pixels not on the border of the objects.

*/
public  double getBackgroundValue() {
    return SimpleITKJNI.LabelContourImageFilter_getBackgroundValue(swigCPtr, this);
  }

  /**
std::string itk::simple::LabelContourImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.LabelContourImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::LabelContourImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.LabelContourImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::LabelContourImageFilter::Execute(Image &amp;&amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.LabelContourImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
