/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Write out a SimpleITK image to the specified file location.


This writer tries to write the image out using the image's type to the
location specified in FileName. If writing fails, an ITK exception is
thrown.


See:
 itk::simple::WriteImage for the procedural interface


C++ includes: sitkImageFileWriter.h
*/
public class ImageFileWriter extends ProcessObject {
  private transient long swigCPtr;

  protected ImageFileWriter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ImageFileWriter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ImageFileWriter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ImageFileWriter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
itk::simple::ImageFileWriter::~ImageFileWriter() override
*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ImageFileWriter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ImageFileWriter::ImageFileWriter()
*/
public  ImageFileWriter() {
    this(SimpleITKJNI.new_ImageFileWriter(), true);
  }

  /**
std::string itk::simple::ImageFileWriter::ToString() const override

Print ourselves to string

*/
public  String toString() {
    return SimpleITKJNI.ImageFileWriter_toString(swigCPtr, this);
  }

  /**
std::string itk::simple::ImageFileWriter::GetName() const override

return user readable name of the filter

*/
public  String getName() {
    return SimpleITKJNI.ImageFileWriter_getName(swigCPtr, this);
  }

  /**
virtual std::vector&lt;std::string&gt; itk::simple::ImageFileWriter::GetRegisteredImageIOs() const

Get a vector of the names of registered itk ImageIOs.

*/
public  VectorString getRegisteredImageIOs() {
    return new VectorString(SimpleITKJNI.ImageFileWriter_getRegisteredImageIOs(swigCPtr, this), true);
  }

  public void setUseCompression(boolean UseCompression) {
    SimpleITKJNI.ImageFileWriter_setUseCompression(swigCPtr, this, UseCompression);
  }

  public boolean getUseCompression() {
    return SimpleITKJNI.ImageFileWriter_getUseCompression(swigCPtr, this);
  }

  public void useCompressionOn() {
    SimpleITKJNI.ImageFileWriter_useCompressionOn(swigCPtr, this);
  }

  public void useCompressionOff() {
    SimpleITKJNI.ImageFileWriter_useCompressionOff(swigCPtr, this);
  }

  public void setCompressionLevel(int arg0) {
    SimpleITKJNI.ImageFileWriter_setCompressionLevel(swigCPtr, this, arg0);
  }

  public int getCompressionLevel() {
    return SimpleITKJNI.ImageFileWriter_getCompressionLevel(swigCPtr, this);
  }

  public void setCompressor(String arg0) {
    SimpleITKJNI.ImageFileWriter_setCompressor(swigCPtr, this, arg0);
  }

  public String getCompressor() {
    return SimpleITKJNI.ImageFileWriter_getCompressor(swigCPtr, this);
  }

  public void setImageIO(String imageio) {
    SimpleITKJNI.ImageFileWriter_setImageIO(swigCPtr, this, imageio);
  }

  public String getImageIO() {
    return SimpleITKJNI.ImageFileWriter_getImageIO(swigCPtr, this);
  }

  public void setKeepOriginalImageUID(boolean KeepOriginalImageUID) {
    SimpleITKJNI.ImageFileWriter_setKeepOriginalImageUID(swigCPtr, this, KeepOriginalImageUID);
  }

  public boolean getKeepOriginalImageUID() {
    return SimpleITKJNI.ImageFileWriter_getKeepOriginalImageUID(swigCPtr, this);
  }

  public void keepOriginalImageUIDOn() {
    SimpleITKJNI.ImageFileWriter_keepOriginalImageUIDOn(swigCPtr, this);
  }

  public void keepOriginalImageUIDOff() {
    SimpleITKJNI.ImageFileWriter_keepOriginalImageUIDOff(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ImageFileWriter::SetFileName(const PathType &amp;fileName)
*/
public  void setFileName(String fileName) {
    SimpleITKJNI.ImageFileWriter_setFileName(swigCPtr, this, fileName);
  }

  /**
PathType itk::simple::ImageFileWriter::GetFileName() const
*/
public  String getFileName() {
    return SimpleITKJNI.ImageFileWriter_getFileName(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ImageFileWriter::Execute(const Image &amp;, const PathType &amp;inFileName, bool
useCompression, int compressionLevel)
*/
public  void execute(Image arg0) {
    SimpleITKJNI.ImageFileWriter_execute__SWIG_0(swigCPtr, this, Image.getCPtr(arg0), arg0);
  }

  /**
Self&amp; itk::simple::ImageFileWriter::Execute(const Image &amp;, const PathType &amp;inFileName, bool
useCompression, int compressionLevel)
*/
public  void execute(Image arg0, String inFileName, boolean useCompression, int compressionLevel) {
    SimpleITKJNI.ImageFileWriter_execute__SWIG_1(swigCPtr, this, Image.getCPtr(arg0), arg0, inFileName, useCompression, compressionLevel);
  }

}
