/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Implements pixel-wise generic operation of two images, or of an image
and a constant.


This class is parameterized over the types of the two input images and
the type of the output image. It is also parameterized by the
operation to be applied. A Functor style is used.

The constant must be of the same type than the pixel type of the
corresponding image. It is wrapped in a SimpleDataObjectDecorator so it can be updated through the pipeline. The SetConstant() and
GetConstant() methods are provided as shortcuts to set or get the
constant value without manipulating the decorator.


See:
 BinaryGeneratorImagFilter

 UnaryFunctorImageFilter TernaryFunctorImageFilter

 itk::simple::Equal for the procedural interface

 itk::BinaryFunctorImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkEqualImageFilter.h
*/
public class EqualImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected EqualImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.EqualImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(EqualImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(EqualImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::EqualImageFilter::~EqualImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_EqualImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::EqualImageFilter::EqualImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  EqualImageFilter() {
    this(SimpleITKJNI.new_EqualImageFilter(), true);
  }

  /**
Self&amp; itk::simple::EqualImageFilter::SetBackgroundValue(uint8_t BackgroundValue)

Set/Get the value used to mark the false pixels of the operator.

*/
public  void setBackgroundValue(short BackgroundValue) {
    SimpleITKJNI.EqualImageFilter_setBackgroundValue(swigCPtr, this, BackgroundValue);
  }

  /**
uint8_t itk::simple::EqualImageFilter::GetBackgroundValue() const

Set/Get the value used to mark the false pixels of the operator.

*/
public  short getBackgroundValue() {
    return SimpleITKJNI.EqualImageFilter_getBackgroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::EqualImageFilter::SetForegroundValue(uint8_t ForegroundValue)

Set/Get the value used to mark the true pixels of the operator.

*/
public  void setForegroundValue(short ForegroundValue) {
    SimpleITKJNI.EqualImageFilter_setForegroundValue(swigCPtr, this, ForegroundValue);
  }

  /**
uint8_t itk::simple::EqualImageFilter::GetForegroundValue() const

Set/Get the value used to mark the true pixels of the operator.

*/
public  short getForegroundValue() {
    return SimpleITKJNI.EqualImageFilter_getForegroundValue(swigCPtr, this);
  }

  /**
std::string itk::simple::EqualImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.EqualImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::EqualImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.EqualImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::EqualImageFilter::Execute(Image &amp;&amp;image1, double constant)
*/
public  Image execute(Image image1, Image image2) {
    return new Image(SimpleITKJNI.EqualImageFilter_execute__SWIG_0(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::EqualImageFilter::Execute(Image &amp;&amp;image1, double constant)
*/
public  Image execute(Image image1, double constant) {
    return new Image(SimpleITKJNI.EqualImageFilter_execute__SWIG_1(swigCPtr, this, Image.getCPtr(image1), image1, constant), true);
  }

  /**
Image itk::simple::EqualImageFilter::Execute(Image &amp;&amp;image1, double constant)
*/
public  Image execute(double constant, Image image2) {
    return new Image(SimpleITKJNI.EqualImageFilter_execute__SWIG_2(swigCPtr, this, constant, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::EqualImageFilter::Execute(Image &amp;&amp;image1, double constant)
*/
public  Image execute(Image image1, double constant, short backgroundValue, short foregroundValue) {
    return new Image(SimpleITKJNI.EqualImageFilter_execute__SWIG_3(swigCPtr, this, Image.getCPtr(image1), image1, constant, backgroundValue, foregroundValue), true);
  }

  /**
Image itk::simple::EqualImageFilter::Execute(Image &amp;&amp;image1, double constant)
*/
public  Image execute(double constant, Image image2, short backgroundValue, short foregroundValue) {
    return new Image(SimpleITKJNI.EqualImageFilter_execute__SWIG_4(swigCPtr, this, constant, Image.getCPtr(image2), image2, backgroundValue, foregroundValue), true);
  }

}
