/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Calculates the B-Spline coefficients of an image. Spline order may be
from 0 to 5.


This class defines N-Dimension B-Spline transformation. It is based
on: [1] M. Unser, "Splines: A Perfect Fit for Signal and Image
Processing," IEEE Signal Processing Magazine, vol. 16, no. 6, pp.
22-38, November 1999. [2] M. Unser, A. Aldroubi and M. Eden,
"B-Spline Signal Processing: Part I--Theory," IEEE Transactions on
Signal Processing, vol. 41, no. 2, pp. 821-832, February 1993. [3] M.
Unser, A. Aldroubi and M. Eden, "B-Spline Signal Processing: Part II
--Efficient Design and Applications," IEEE Transactions on Signal
Processing, vol. 41, no. 2, pp. 834-848, February 1993. And code obtained from bigwww.epfl.ch by Philippe Thevenaz

Limitations: Spline order must be between 0 and 5. Spline order must
be set before setting the image. Uses mirror boundary conditions.
Requires the same order of Spline for each dimension. Can only process
LargestPossibleRegion


See:
 BSplineResampleImageFunction

 itk::simple::BSplineDecomposition for the procedural interface

 itk::BSplineDecompositionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBSplineDecompositionImageFilter.h
*/
public class BSplineDecompositionImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected BSplineDecompositionImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.BSplineDecompositionImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(BSplineDecompositionImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(BSplineDecompositionImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::BSplineDecompositionImageFilter::~BSplineDecompositionImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_BSplineDecompositionImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::BSplineDecompositionImageFilter::BSplineDecompositionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  BSplineDecompositionImageFilter() {
    this(SimpleITKJNI.new_BSplineDecompositionImageFilter(), true);
  }

  /**
Self&amp; itk::simple::BSplineDecompositionImageFilter::SetSplineOrder(uint32_t SplineOrder)

Get/Sets the Spline Order, supports 0th - 5th order splines. The
default is a 3rd order spline.

*/
public  void setSplineOrder(long SplineOrder) {
    SimpleITKJNI.BSplineDecompositionImageFilter_setSplineOrder(swigCPtr, this, SplineOrder);
  }

  /**
uint32_t itk::simple::BSplineDecompositionImageFilter::GetSplineOrder() const
*/
public  long getSplineOrder() {
    return SimpleITKJNI.BSplineDecompositionImageFilter_getSplineOrder(swigCPtr, this);
  }

  /**
std::vector&lt;double&gt; itk::simple::BSplineDecompositionImageFilter::GetSplinePoles() const

Get the poles calculated for a given spline order.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  VectorDouble getSplinePoles() {
    return new VectorDouble(SimpleITKJNI.BSplineDecompositionImageFilter_getSplinePoles(swigCPtr, this), true);
  }

  /**
std::string itk::simple::BSplineDecompositionImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.BSplineDecompositionImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::BSplineDecompositionImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.BSplineDecompositionImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::BSplineDecompositionImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.BSplineDecompositionImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
