#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger
version:              1.32.1
visibility:           public
id:                   hledger-1.32.1-9372qilOyWu9DSH6djKU3R
key:                  hledger-1.32.1-9372qilOyWu9DSH6djKU3R
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Command-line interface for the hledger accounting system
description:
    The command-line interface for the hledger accounting system.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance, Console
abi:                  ab39b93a0a83494e6ad1a6819707c56a
exposed:              True
exposed-modules:
    Hledger.Cli Hledger.Cli.Anon Hledger.Cli.CliOptions
    Hledger.Cli.Commands Hledger.Cli.Commands.Accounts
    Hledger.Cli.Commands.Activity Hledger.Cli.Commands.Add
    Hledger.Cli.Commands.Aregister Hledger.Cli.Commands.Balance
    Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Check
    Hledger.Cli.Commands.Close Hledger.Cli.Commands.Codes
    Hledger.Cli.Commands.Commodities Hledger.Cli.Commands.Demo
    Hledger.Cli.Commands.Descriptions Hledger.Cli.Commands.Diff
    Hledger.Cli.Commands.Files Hledger.Cli.Commands.Help
    Hledger.Cli.Commands.Import Hledger.Cli.Commands.Incomestatement
    Hledger.Cli.Commands.Notes Hledger.Cli.Commands.Payees
    Hledger.Cli.Commands.Prices Hledger.Cli.Commands.Print
    Hledger.Cli.Commands.Register Hledger.Cli.Commands.Rewrite
    Hledger.Cli.Commands.Roi Hledger.Cli.Commands.Stats
    Hledger.Cli.Commands.Tags Hledger.Cli.CompoundBalanceCommand
    Hledger.Cli.DocFiles Hledger.Cli.Script Hledger.Cli.Utils
    Hledger.Cli.Version

hidden-modules:       Paths_hledger
import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-1.32.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-1.32.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-1.32.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger
hs-libraries:         HShledger-1.32.1-9372qilOyWu9DSH6djKU3R
depends:
    Decimal-0.5.2-EvRcqUIPT9uHP0LYQhNTSg
    Diff-0.4.1-LlG9CqI0BWmDdGO3rVr0iN
    aeson-2.1.2.1-H9spCVKCz3aBZuysSTfrjv
    ansi-terminal-1.0.2-6TxOAUbfOQrDbPnWIRhRhS base-4.17.2.1
    bytestring-0.11.5.3 cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    containers-0.6.7 data-default-0.7.1.1-HuI8bY4bNR4F11jcRg6vOi
    directory-1.3.7.1 extra-1.7.16-G4xNEo2ejjd3lhwl24aWT4
    filepath-1.4.2.2 githash-0.1.6.3-KOnYc1PfXNB5Sei8CD43OX
    hashable-1.4.4.0-Jc2uKL4S7Fl9QLNJZYpfiY haskeline-0.8.2
    hledger-lib-1.32.1-2Gte7CCcPiUJeVXAQoyGOn
    lucid-2.11.20230408-LRM4tIOFFytFc9EIuYPCvZ
    math-functions-0.3.4.4-E8iUEx01Qk9DqpLsVR97wn
    megaparsec-9.6.1-KkOPmPbRCEmCvB2XbKT9En
    microlens-0.4.13.1-BCmTOusOWAwKF1xfvNhRYd mtl-2.2.2
    process-1.6.18.0 regex-tdfa-1.3.2.4-3uSstSTaLA6FCpVbUR8EKw
    safe-0.3.21-D0Qa6qmXFrgLhocJR17U7j
    shakespeare-2.1.0.1-9xRqfg6Rm8d6zsejEr0C1H
    split-0.2.5-KcBaumhT6eFHklJKzsytdC
    tabular-0.2.2.8-GPlaI3PukxDKI4c6j3m1vm
    tasty-1.4.3-HK16IWl2qZuAE1kQP7GLN3
    temporary-1.3-8FAts4F1AmtHqh7aYyLCzN terminfo-0.4.1.5 text-2.0.2
    text-ansi-0.3.0-3Yi4juPAhH5IhfAbuYjoCT time-1.12.2
    timeit-2.0-GSLifhpRLI5Gr54jWRx5t0 transformers-0.5.6.2
    unordered-containers-0.2.20-L3M6eILO3KM5ipeNJik2xY
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    utility-ht-0.0.17.2-71byj5QpPjWBQJOAqtvJWi
    wizards-1.0.3-KdOLRFMRRl1t6euiwGd

haddock-interfaces:   /usr/share/doc/hledger/html/hledger.haddock
haddock-html:         /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

