package flash.media;

extern class AVSegmentedSource extends AVSource {
	@:flash.property var cookieHeader(never,set) : String;
	@:flash.property var masterUpdateInterval(never,set) : Int;
	@:flash.property var networkingParams(get,set) : AVNetworkingParams;
	@:flash.property var useRedirectedUrl(never,set) : Bool;
	function new() : Void;
	function addCustomHeader(headerName : String, args : flash.Vector<String>) : Void;
	function clearPauseAtPeriodEnd(periodIndex : Int) : AVResult;
	function getABRProfileCount(periodIndex : Int) : Int;
	function getABRProfileInfoAtIndex(periodIndex : Int, abrProfileIndex : Int) : AVABRProfileInfo;
	function getBackgroundPeriodInfo(periodIndex : Int) : AVPeriodInfo;
	function getBackgroundTimeline() : AVTimeline;
	function getCuePoint(periodIndex : Int, cuePointIndex : Int) : AVCuePoint;
	function getMediaPreferredStartTime() : Float;
	function getPerceivedBandwidth() : UInt;
	function getPeriodInfo(periodIndex : Int) : AVPeriodInfo;
	function getPeriodInfoWithTagsAcrossIndexes(periodIndex : Int, startPeriodIndex : Int) : AVPeriodInfo;
	function getSubscribedTag(periodIndex : Int, tagDataIndex : Int) : AVTagData;
	function getSubscribedTagForBackgroundManifest(periodIndex : Int, tagDataIndex : Int) : AVTagData;
	function getTimeline() : AVTimeline;
	function getTimelineSubscribedTag(tagDataIndex : Int) : AVTagData;
	function getTimelineSubscribedTagForBackgroundManifest(tagDataIndex : Int) : AVTagData;
	function getTrackCount(periodIndex : Int, payloadType : String) : Int;
	function getTrackInfo(periodIndex : Int, payloadType : String, trackIndex : Int) : AVTrackInfo;
	private function get_networkingParams() : AVNetworkingParams;
	function insertByLocalTime(periodIndex : Int, insertionTime : Float, handle : Int, userData : Int = 0, replaceDuration : Float = 0) : AVInsertionResult;
	function insertByVirtualTime(insertionTime : Float, handle : Int, userData : Int = 0, replaceDuration : Float = 0) : AVInsertionResult;
	function load(url : String, ?containerType : String, userData : Int = 0) : AVResult;
	function loadManifest(uri : String, userData : Int = 0, ?containerType : String) : AVResult;
	function loadWithBackgroundManifest(url : String, containerType : String, userData : Int, backgroundManifest : String) : AVResult;
	function releaseManifest(handle : Int) : AVResult;
	function removeByLocalTime(periodIndex : Int, timeStart : Float, timeEnd : Float, replaceWithMainMedia : Bool) : AVResult;
	function removeByVirtualTime(virtualTimeStart : Float, virtualTimeEnd : Float) : AVResult;
	function removeByVirtualTimeWithReplacement(virtualTimeStart : Float, virtualTimeEnd : Float, replaceWithMainMedia : Bool) : AVResult;
	function selectTrack(periodIndex : Int, payloadType : String, trackIndex : Int) : AVResult;
	function selectTrackString(periodIndex : Int, payloadType : String, trackString : String) : AVResult;
	function setABRParameters(params : AVABRParameters) : AVResult;
	function setBandwidth(bitsPerSecond : Int) : AVResult;
	function setCuePointTags(tagArray : Array<Dynamic>) : AVResult;
	function setHoldAt(time : Float) : AVResult;
	function setPauseAtPeriodEnd(periodIndex : Int, userData : Int = 0) : AVResult;
	function setSubscribedTags(tagArray : Array<Dynamic>) : AVResult;
	function setSubscribedTagsForBackgroundManifest(tagArray : Array<Dynamic>) : AVResult;
	private function set_cookieHeader(value : String) : String;
	private function set_masterUpdateInterval(value : Int) : Int;
	private function set_networkingParams(value : AVNetworkingParams) : AVNetworkingParams;
	private function set_useRedirectedUrl(value : Bool) : Bool;
	static final AUDIO : String;
	static final AUDIO_DESCRIPTION : String;
	static final AUDIO_LANGUAGE : String;
	static final AUDIO_PID : String;
	static final DASH : String;
	static final DATA : String;
	static final DATA_DESCRIPTION : String;
	static final HLS : String;
	static final VIDEO : String;
	static final VIDEO_DESCRIPTION : String;
}
