#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                   zeromq4-haskell
version:                0.8.0
visibility:             public
id:                     zeromq4-haskell-0.8.0-GbT1b2ijVFOFbNnqUyYVua
key:                    zeromq4-haskell-0.8.0-GbT1b2ijVFOFbNnqUyYVua
license:                MIT
copyright:              (c) 2010 - 2015 zeromq-haskell authors
maintainer:             Toralf Wittner <tw@dtex.org>
author:                 Toralf Wittner
stability:              experimental
homepage:               https://gitlab.com/twittner/zeromq-haskell/
synopsis:               Bindings to ZeroMQ 4.x
description:
    The 0MQ lightweight messaging kernel is a library which extends
    the standard socket interfaces with features traditionally provided
    by specialised messaging middleware products.

    0MQ sockets provide an abstraction of asynchronous message queues,
    multiple messaging patterns, message filtering (subscriptions),
    seamless access to multiple transport protocols and more.

    This library provides the Haskell language binding to 0MQ >= 4.x

category:               System, FFI
abi:                    a7f74b98af24375e24f03312c94ef25e
exposed:                True
exposed-modules:
    Data.Restricted System.ZMQ4 System.ZMQ4.Internal
    System.ZMQ4.Internal.Base System.ZMQ4.Internal.Error
    System.ZMQ4.Monadic

import-dirs:            /usr/lib/ghc-9.4.8/site-local/zeromq4-haskell-0.8.0
library-dirs:           /usr/lib/ghc-9.4.8/site-local/zeromq4-haskell-0.8.0
library-dirs-static:    /usr/lib/ghc-9.4.8/site-local/zeromq4-haskell-0.8.0
dynamic-library-dirs:   /usr/lib
data-dir:               /usr/share/haskell-zeromq4-haskell
hs-libraries:           HSzeromq4-haskell-0.8.0-GbT1b2ijVFOFbNnqUyYVua
extra-libraries:        zmq
extra-libraries-static:
    zmq stdc++ rt gnutls gmp unistring atomic hogweed gmp nettle tasn1
    idn2 unistring p11-kit leancrypto sodium pthread pgm m

include-dirs:           /usr/include/p11-kit-1 /usr/include/pgm-5.3
depends:
    async-2.2.5-7zRWRGcsDHK4x7TGVl8w2c base-4.17.2.1
    bytestring-0.11.5.3 containers-0.6.7 exceptions-0.10.5
    monad-control-1.0.3.1-Gw3XM64JSJ5ntrqlz8Emw transformers-0.5.6.2
    transformers-base-0.4.6-7U7lXEgv0cHELUGOzmogrd

haddock-interfaces:
    /usr/share/doc/haskell-zeromq4-haskell/html/zeromq4-haskell.haddock

haddock-html:           /usr/share/doc/haskell-zeromq4-haskell/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

