#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 semialign
version:              1.3
visibility:           public
id:                   semialign-1.3-9msu59GQ0a967Vof9AKyUG
key:                  semialign-1.3-9msu59GQ0a967Vof9AKyUG
license:              BSD-3-Clause
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               C. McCann, Oleg Grenrus
homepage:             https://github.com/haskellari/these
synopsis:
    Align and Zip type-classes from the common Semialign ancestor.

description:
    The major use of @These@ of this is provided by the @align@ member of
    @Semialign@ class, representing a generalized notion of "zipping with padding"
    that combines structures without truncating to the size of the smaller input.

    It turns out that @zip@ operation fits well the @Semialign@ class,
    forming lattice-like structure.

category:             Data, These
abi:                  068854058e106bd3040528d5893b7f85
exposed:              True
exposed-modules:
    Data.Align Data.Crosswalk Data.Semialign Data.Semialign.Indexed
    Data.Zip

hidden-modules:       Data.Semialign.Internal
import-dirs:          /usr/lib/ghc-9.4.8/site-local/semialign-1.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/semialign-1.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/semialign-1.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-semialign
hs-libraries:         HSsemialign-1.3-9msu59GQ0a967Vof9AKyUG
depends:
    base-4.17.2.1 containers-0.6.7
    hashable-1.4.4.0-Jc2uKL4S7Fl9QLNJZYpfiY
    indexed-traversable-0.1.4-GT0Rbq1oHbVD3nizQLAgyJ
    indexed-traversable-instances-0.1.2-HT3K2ypMIjc5JKQwro6nzl
    semigroupoids-6.0.1-Jr4qwSJRHF330Efi7HW1er
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C
    these-1.2.1-GSx5XsQPsICFRdPoOz493 transformers-0.5.6.2
    unordered-containers-0.2.20-L3M6eILO3KM5ipeNJik2xY
    vector-0.13.2.0-KDCTRjRQ0urK2B6TNAGAn8

haddock-interfaces:   /usr/share/doc/haskell-semialign/html/semialign.haddock
haddock-html:         /usr/share/doc/haskell-semialign/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

