#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 cipher-aes128
version:              0.7.0.6
visibility:           public
id:                   cipher-aes128-0.7.0.6-3ae51bhRzRHInPEziXxaSr
key:                  cipher-aes128-0.7.0.6-3ae51bhRzRHInPEziXxaSr
license:              BSD-3-Clause
copyright:            Thomas M. DuBuisson
maintainer:           thomas.dubuisson@gmail.com
author:               Thomas M. DuBuisson, Vincent Hanquez (See AUTHORS file)
homepage:             https://github.com/TomMD/cipher-aes128
synopsis:             AES and common modes using AES-NI when available.
description:
    Cipher-aes128 is an implementation of AES and common modes of operation.  It borrows Hanquez'\''s C AES code (see '\''cipher-aes'\'') but
    is unique due to including compile-time detection of
    NI compiler support, a slightly more functional interface
    for GCM operations, exposure of '\''Ptr'\'' based operations via the .Internal module, and build-in crypto-api support.
    Cipher-aes128 was originally developed as "'\''cipher-aes'\'' plus trampolines", which has since been adopted into cipher-aes.

category:             Cryptography
abi:                  1f1ee588bb390d995ad79aed6dc6acef
exposed:              True
exposed-modules:      Crypto.Cipher.AES128 Crypto.Cipher.AES128.Internal
import-dirs:          /usr/lib/ghc-9.4.8/site-local/cipher-aes128-0.7.0.6
library-dirs:         /usr/lib/ghc-9.4.8/site-local/cipher-aes128-0.7.0.6
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/cipher-aes128-0.7.0.6
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-cipher-aes128
hs-libraries:         HScipher-aes128-0.7.0.6-3ae51bhRzRHInPEziXxaSr
depends:
    base-4.17.2.1 bytestring-0.11.5.3
    cereal-0.5.8.3-H9MXf6i1TMkEAfnsx4oYbT
    crypto-api-0.13.3-L9US7GS3I02EI9rbQ94kVv
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C

haddock-interfaces:
    /usr/share/doc/haskell-cipher-aes128/html/cipher-aes128.haddock

haddock-html:         /usr/share/doc/haskell-cipher-aes128/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

