/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiUnnamedClass;

public final class JavaUnnamedClassUtil {
    public static boolean isFileWithUnnamedClass(@NotNull PsiFile file2) {
        PsiJavaFile javaFile;
        if (file2 == null) {
            JavaUnnamedClassUtil.$$$reportNull$$$0(0);
        }
        return file2 instanceof PsiJavaFile && JavaUnnamedClassUtil.getUnnamedClassFor(javaFile = (PsiJavaFile)file2) != null;
    }

    @Nullable
    public static PsiUnnamedClass getUnnamedClassFor(@NotNull PsiFile file2) {
        PsiJavaFile javaFile;
        PsiClass[] classes;
        if (file2 == null) {
            JavaUnnamedClassUtil.$$$reportNull$$$0(1);
        }
        if (file2 instanceof PsiJavaFile && (classes = (javaFile = (PsiJavaFile)file2).getClasses()).length == 1 && classes[0] instanceof PsiUnnamedClass) {
            return (PsiUnnamedClass)classes[0];
        }
        return null;
    }

    @Nullable
    public static String getJvmName(@NotNull PsiUnnamedClass unnamedClass) {
        PsiFile containingFile;
        if (unnamedClass == null) {
            JavaUnnamedClassUtil.$$$reportNull$$$0(2);
        }
        if ((containingFile = unnamedClass.getContainingFile()) == null) {
            return null;
        }
        String name2 = containingFile.getName();
        int extensionIndex = name2.lastIndexOf(".java");
        if (extensionIndex == -1) {
            return null;
        }
        String jvmName = name2.substring(0, extensionIndex);
        if (!StringUtil.isJavaIdentifier(jvmName)) {
            return null;
        }
        return jvmName;
    }

    public static String getJvmName(@NotNull String name2) {
        if (name2 == null) {
            JavaUnnamedClassUtil.$$$reportNull$$$0(3);
        }
        return StringUtil.trimEnd(name2, ".java", true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unnamedClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/JavaUnnamedClassUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileWithUnnamedClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getUnnamedClassFor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getJvmName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

