/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.gvt;

import io.sf.carte.echosvg.ext.awt.color.ColorContext;
import io.sf.carte.echosvg.gvt.ShapePainter;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.color.ColorSpace;

abstract class PaintShapePainter
implements ShapePainter {
    protected Shape shape;
    protected Paint paint;
    private ColorContext context;

    protected PaintShapePainter(Shape shape, ColorContext colorContext) {
        if (shape == null) {
            throw new IllegalArgumentException("Shape can not be null!");
        }
        if (colorContext == null) {
            throw new IllegalArgumentException("Color context can not be null!");
        }
        this.shape = shape;
        this.context = colorContext;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    public Paint getPaint() {
        if (this.paint instanceof Color) {
            Color color = (Color)this.paint;
            ColorSpace colorSpace = color.getColorSpace();
            ColorSpace colorSpace2 = this.context.getColorSpace();
            if (colorSpace2 == null) {
                if (!colorSpace.isCS_sRGB()) {
                    float[] fArray = color.getRGBComponents(null);
                    color = new Color(fArray[0], fArray[1], fArray[2], fArray[3]);
                }
            } else {
                color = new Color(colorSpace2, color.getColorComponents(colorSpace2, null), (float)color.getAlpha() / 255.0f);
            }
            return color;
        }
        return this.paint;
    }

    @Override
    public void setShape(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException();
        }
        this.shape = shape;
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }
}

