/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.os;

import com.jogamp.common.os.Platform;
import java.time.Instant;

public class Clock {
    private static final Instant t0;

    public static Instant getMonotonicTime() {
        long[] lArray = new long[]{0L, 0L};
        if (Clock.getMonotonicTimeImpl(lArray)) {
            return Instant.ofEpochSecond(lArray[0], lArray[1]);
        }
        return Instant.EPOCH;
    }

    private static native boolean getMonotonicTimeImpl(long[] var0);

    public static Instant getWallClockTime() {
        long[] lArray = new long[]{0L, 0L};
        if (Clock.getWallClockTimeImpl(lArray)) {
            return Instant.ofEpochSecond(lArray[0], lArray[1]);
        }
        return Instant.EPOCH;
    }

    private static native boolean getWallClockTimeImpl(long[] var0);

    public static Instant getMonotonicStartupTime() {
        return t0;
    }

    private static native boolean getMonotonicStartupTimeImpl(long[] var0);

    public static native long currentNanos();

    public static Instant getMonotonicNanos() {
        long l = Clock.currentNanos();
        return Instant.ofEpochSecond(l / 1000000000L, l % 1000000000L);
    }

    public static native long currentTimeMillis();

    public static native long wallClockSeconds();

    static {
        Platform.initSingleton();
        long[] lArray = new long[]{0L, 0L};
        t0 = Clock.getMonotonicStartupTimeImpl(lArray) ? Instant.ofEpochSecond(lArray[0], lArray[1]) : Instant.EPOCH;
    }
}

