/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSUnicodeRangeValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class UnicodeValue
extends TypedValue
implements CSSUnicodeRangeValue.CSSUnicodeValue {
    private static final long serialVersionUID = 1L;
    private int codePoint = 0;

    public UnicodeValue() {
        super(CSSValue.Type.UNICODE_CHARACTER);
    }

    protected UnicodeValue(UnicodeValue unicodeValue) {
        super(unicodeValue);
        this.codePoint = unicodeValue.codePoint;
    }

    @Override
    public void setCssText(String string) throws DOMException {
        throw new DOMException(7, "This property is read-only.");
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter) throws IOException {
        simpleWriter.write((CharSequence)"U+");
        simpleWriter.write((CharSequence)Integer.toHexString(this.codePoint));
    }

    @Override
    public String getCssText() {
        return "U+" + Integer.toHexString(this.codePoint);
    }

    @Override
    public String getStringValue() throws DOMException {
        return new String(this.toChars());
    }

    @Override
    public int getCodePoint() {
        return this.codePoint;
    }

    @Override
    public void setCodePoint(int n) {
        this.codePoint = n;
    }

    public char[] toChars() {
        return Character.toChars(this.codePoint);
    }

    @Override
    public int hashCode() {
        int n = 31;
        return super.hashCode() * 31 + this.codePoint;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UnicodeValue unicodeValue = (UnicodeValue)object;
        return this.codePoint == unicodeValue.codePoint;
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public UnicodeValue clone() {
        return new UnicodeValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
        }

        @Override
        void setLexicalUnit(LexicalUnit lexicalUnit) {
            UnicodeValue.this.codePoint = lexicalUnit.getIntegerValue();
            this.nextLexicalUnit = lexicalUnit.getNextLexicalUnit();
        }
    }
}

