/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.color.Illuminant;
import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.property.A98RGBColorProfile;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.ColorProfile;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.DisplayP3ColorProfile;
import io.sf.carte.doc.style.css.property.HSLColorImpl;
import io.sf.carte.doc.style.css.property.HWBColorImpl;
import io.sf.carte.doc.style.css.property.LABColorImpl;
import io.sf.carte.doc.style.css.property.LCHColorImpl;
import io.sf.carte.doc.style.css.property.LinearA98RGBColorProfile;
import io.sf.carte.doc.style.css.property.LinearDisplayP3ColorProfile;
import io.sf.carte.doc.style.css.property.LinearProPhotoRGBColorProfile;
import io.sf.carte.doc.style.css.property.LinearRec2020ColorProfile;
import io.sf.carte.doc.style.css.property.LinearSRGBColorProfile;
import io.sf.carte.doc.style.css.property.ProPhotoRGBColorProfile;
import io.sf.carte.doc.style.css.property.ProfiledColorImpl;
import io.sf.carte.doc.style.css.property.ProfiledRGBColor;
import io.sf.carte.doc.style.css.property.RGBColor;
import io.sf.carte.doc.style.css.property.Rec2020ColorProfile;
import io.sf.carte.doc.style.css.property.XYZColorImpl;
import java.util.Locale;
import org.w3c.dom.DOMException;

class ColorConverter {
    private final boolean createValue;
    private BaseColor destColor;

    public ColorConverter(boolean bl) {
        this.createValue = bl;
    }

    public BaseColor getLastColor() {
        return this.destColor;
    }

    double[] toColorSpace(BaseColor baseColor, String string, boolean bl) throws DOMException {
        double[] dArray;
        string = string.toLowerCase(Locale.ROOT);
        if (baseColor.getColorSpace().equals(string)) {
            if (this.createValue) {
                this.destColor = baseColor;
            }
            return baseColor.toNumberArray();
        }
        switch (string) {
            case "srgb": {
                dArray = baseColor.toSRGB(bl);
                if (!this.createValue) break;
                this.destColor = new RGBColor();
                break;
            }
            case "srgb-linear": {
                LinearSRGBColorProfile linearSRGBColorProfile = new LinearSRGBColorProfile();
                dArray = new double[3];
                this.convertToProfiled(linearSRGBColorProfile, baseColor, bl, dArray);
                if (!this.createValue) break;
                this.destColor = new ProfiledRGBColor("srgb-linear");
                break;
            }
            case "display-p3": {
                DisplayP3ColorProfile displayP3ColorProfile = new DisplayP3ColorProfile();
                dArray = new double[3];
                this.convertToProfiled(displayP3ColorProfile, baseColor, bl, dArray);
                if (!this.createValue) break;
                this.destColor = new ProfiledRGBColor("display-p3");
                break;
            }
            case "a98-rgb": {
                A98RGBColorProfile a98RGBColorProfile = new A98RGBColorProfile();
                dArray = new double[3];
                this.convertToProfiled(a98RGBColorProfile, baseColor, bl, dArray);
                if (!this.createValue) break;
                this.destColor = new ProfiledRGBColor("a98-rgb");
                break;
            }
            case "prophoto-rgb": {
                ProPhotoRGBColorProfile proPhotoRGBColorProfile = new ProPhotoRGBColorProfile();
                dArray = new double[3];
                this.convertToProfiled(proPhotoRGBColorProfile, baseColor, bl, dArray);
                if (!this.createValue) break;
                this.destColor = new ProfiledRGBColor("prophoto-rgb");
                break;
            }
            case "rec2020": {
                Rec2020ColorProfile rec2020ColorProfile = new Rec2020ColorProfile();
                dArray = new double[3];
                this.convertToProfiled(rec2020ColorProfile, baseColor, bl, dArray);
                if (!this.createValue) break;
                this.destColor = new ProfiledRGBColor("rec2020");
                break;
            }
            case "xyz": 
            case "xyz-d65": {
                dArray = baseColor.toXYZ(Illuminant.D65);
                if (!this.createValue) break;
                this.destColor = new XYZColorImpl(Illuminant.D65);
                break;
            }
            case "xyz-d50": {
                dArray = baseColor.toXYZ(Illuminant.D50);
                if (!this.createValue) break;
                this.destColor = new XYZColorImpl(Illuminant.D50);
                break;
            }
            case "hsl": 
            case "hsla": {
                if (baseColor.getColorModel() == CSSColorValue.ColorModel.HSL) {
                    dArray = baseColor.toNumberArray();
                } else {
                    dArray = baseColor.toSRGB(true);
                    dArray = ColorUtil.srgbToHsl(dArray[0], dArray[1], dArray[2]);
                }
                if (!this.createValue) break;
                this.destColor = new HSLColorImpl();
                break;
            }
            case "hwb": {
                if (baseColor.getColorModel() == CSSColorValue.ColorModel.HWB) {
                    dArray = baseColor.toNumberArray();
                } else {
                    double[] dArray2 = baseColor.toSRGB(true);
                    dArray = ColorUtil.srgbToHwb(dArray2);
                }
                if (!this.createValue) break;
                this.destColor = new HWBColorImpl();
                break;
            }
            case "lab": {
                dArray = new double[3];
                if (baseColor.getSpace() == BaseColor.Space.CIE_LCh) {
                    double[] dArray3 = baseColor.toNumberArray();
                    ColorUtil.lchToLab(dArray3, dArray);
                } else {
                    double[] dArray4 = baseColor.toXYZ(Illuminant.D50);
                    ColorUtil.xyzD50ToLab(dArray4, dArray);
                }
                if (!this.createValue) break;
                this.destColor = new LABColorImpl(BaseColor.Space.CIE_Lab, "lab");
                break;
            }
            case "lch": {
                double[] dArray5;
                if (baseColor.getSpace() == BaseColor.Space.CIE_Lab) {
                    dArray5 = baseColor.toNumberArray();
                } else {
                    double[] dArray6 = baseColor.toXYZ(Illuminant.D50);
                    dArray5 = new double[3];
                    ColorUtil.xyzD50ToLab(dArray6, dArray5);
                }
                dArray = new double[3];
                ColorUtil.labToLCh(dArray5, dArray);
                if (!this.createValue) break;
                this.destColor = new LCHColorImpl(BaseColor.Space.CIE_LCh, "lch");
                break;
            }
            case "oklab": {
                dArray = new double[3];
                if (baseColor.getSpace() == BaseColor.Space.OK_LCh) {
                    double[] dArray7 = baseColor.toNumberArray();
                    ColorUtil.lchToLab(dArray7, dArray);
                } else {
                    double[] dArray8 = baseColor.toXYZ(Illuminant.D65);
                    ColorUtil.xyzD65ToOkLab(dArray8, dArray);
                }
                if (!this.createValue) break;
                this.destColor = new LABColorImpl(BaseColor.Space.OK_Lab, "oklab");
                break;
            }
            case "oklch": {
                double[] dArray9;
                if (baseColor.getSpace() == BaseColor.Space.OK_Lab) {
                    dArray9 = baseColor.toNumberArray();
                } else {
                    double[] dArray10 = baseColor.toXYZ(Illuminant.D65);
                    dArray9 = new double[3];
                    ColorUtil.xyzD65ToOkLab(dArray10, dArray9);
                }
                dArray = new double[3];
                ColorUtil.labToLCh(dArray9, dArray);
                if (!this.createValue) break;
                this.destColor = new LCHColorImpl(BaseColor.Space.OK_LCh, "oklch");
                break;
            }
            case "--display-p3-linear": {
                LinearDisplayP3ColorProfile linearDisplayP3ColorProfile = new LinearDisplayP3ColorProfile();
                dArray = new double[3];
                this.convertToProfiled(linearDisplayP3ColorProfile, baseColor, bl, dArray);
                if (!this.createValue) break;
                this.destColor = new ProfiledColorImpl("--display-p3-linear", linearDisplayP3ColorProfile, dArray);
                break;
            }
            case "--a98-rgb-linear": {
                LinearA98RGBColorProfile linearA98RGBColorProfile = new LinearA98RGBColorProfile();
                dArray = new double[3];
                this.convertToProfiled(linearA98RGBColorProfile, baseColor, bl, dArray);
                if (!this.createValue) break;
                this.destColor = new ProfiledColorImpl("--a98-rgb-linear", linearA98RGBColorProfile, dArray);
                break;
            }
            case "--rec2020-linear": {
                LinearRec2020ColorProfile linearRec2020ColorProfile = new LinearRec2020ColorProfile();
                dArray = new double[3];
                this.convertToProfiled(linearRec2020ColorProfile, baseColor, bl, dArray);
                if (!this.createValue) break;
                this.destColor = new ProfiledColorImpl("--rec2020-linear", linearRec2020ColorProfile, dArray);
                break;
            }
            case "--prophoto-rgb-linear": {
                LinearProPhotoRGBColorProfile linearProPhotoRGBColorProfile = new LinearProPhotoRGBColorProfile();
                dArray = new double[3];
                this.convertToProfiled(linearProPhotoRGBColorProfile, baseColor, bl, dArray);
                if (!this.createValue) break;
                this.destColor = new ProfiledColorImpl("--prophoto-rgb-linear", linearProPhotoRGBColorProfile, dArray);
                break;
            }
            default: {
                throw new DOMException(9, "Unsupported color space: " + string);
            }
        }
        if (this.createValue) {
            this.destColor.setAlpha(baseColor.getAlpha().clone());
            this.destColor.setColorComponents(dArray);
        }
        return dArray;
    }

    private void convertToProfiled(ColorProfile colorProfile, BaseColor baseColor, boolean bl, double[] dArray) {
        double[] dArray2 = baseColor.toXYZ(colorProfile.getIlluminant());
        colorProfile.xyzToLinearRgb(dArray2, dArray);
        dArray[0] = colorProfile.gammaCompanding(dArray[0]);
        dArray[1] = colorProfile.gammaCompanding(dArray[1]);
        dArray[2] = colorProfile.gammaCompanding(dArray[2]);
        if (!ColorUtil.rangeRoundCheck(dArray) && bl) {
            double[] dArray3 = new double[3];
            if (colorProfile.getIlluminant() == Illuminant.D65) {
                dArray2 = ColorUtil.d65xyzToD50(dArray2);
            }
            ColorUtil.xyzD50ToLab(dArray2, dArray3);
            ColorUtil.labToClampedRGB(dArray3[0], dArray3[1], dArray3[2], true, colorProfile, dArray);
        }
    }
}

