/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.nsac.ArgumentCondition;
import io.sf.carte.doc.style.css.nsac.AttributeCondition;
import io.sf.carte.doc.style.css.nsac.CombinatorCondition;
import io.sf.carte.doc.style.css.nsac.CombinatorSelector;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.nsac.ConditionalSelector;
import io.sf.carte.doc.style.css.nsac.PositionalCondition;
import io.sf.carte.doc.style.css.nsac.Selector;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.parser.NSACSelectorFactory;
import io.sf.carte.util.Visitor;
import org.w3c.dom.DOMException;

public abstract class AttributeConditionVisitor
implements Visitor<AttributeCondition> {
    protected AttributeConditionVisitor() {
    }

    public void visit(SelectorList selectorList) {
        int n = selectorList.getLength();
        for (int i = 0; i < n; ++i) {
            Selector selector = selectorList.item(i);
            this.visit(selector);
        }
    }

    public void visit(Selector selector) {
        if (selector.getSelectorType() == Selector.SelectorType.CONDITIONAL) {
            Condition condition = ((ConditionalSelector)selector).getCondition();
            this.visit(condition);
        } else if (selector instanceof CombinatorSelector) {
            Selector selector2 = ((CombinatorSelector)selector).getSelector();
            this.visit(selector2);
        }
    }

    private void visit(Condition condition) {
        if (condition instanceof AttributeCondition) {
            this.visit((AttributeCondition)condition);
        } else {
            switch (condition.getConditionType()) {
                case AND: {
                    CombinatorCondition combinatorCondition = (CombinatorCondition)condition;
                    this.visit(combinatorCondition.getFirstCondition());
                    this.visit(combinatorCondition.getSecondCondition());
                    break;
                }
                case POSITIONAL: {
                    SelectorList selectorList = ((PositionalCondition)condition).getOfList();
                    if (selectorList == null) break;
                    this.visit(selectorList);
                    break;
                }
                case SELECTOR_ARGUMENT: {
                    SelectorList selectorList = ((ArgumentCondition)condition).getSelectors();
                    if (selectorList == null) break;
                    this.visit(selectorList);
                    break;
                }
            }
        }
    }

    protected void setConditionNamespaceURI(AttributeCondition attributeCondition, String string) throws DOMException {
        if (string == null) {
            throw new DOMException(15, "Null namespaceURI.");
        }
        if ((string = string.trim()).length() == 0) {
            throw new DOMException(15, "Empty namespaceURI.");
        }
        ((NSACSelectorFactory.AttributeConditionImpl)attributeCondition).setNamespaceURI(string);
    }

    protected void setConditionLocalName(AttributeCondition attributeCondition, String string) throws DOMException {
        if (string == null) {
            throw new DOMException(15, "Null local name.");
        }
        if ((string = string.trim()).length() == 0) {
            throw new DOMException(15, "Empty local name.");
        }
        ((NSACSelectorFactory.AttributeConditionImpl)attributeCondition).setLocalName(string);
    }

    protected void setConditionValue(AttributeCondition attributeCondition, String string) throws DOMException {
        if (string != null) {
            if ((string = string.trim()).length() == 0) {
                string = null;
                if (attributeCondition.getConditionType() == Condition.ConditionType.CLASS) {
                    throw new DOMException(15, "Empty value.");
                }
            }
        } else if (attributeCondition.getConditionType() == Condition.ConditionType.CLASS) {
            throw new DOMException(15, "Null value.");
        }
        ((NSACSelectorFactory.AttributeConditionImpl)attributeCondition).setValue(string);
    }

    public abstract void visit(AttributeCondition var1);
}

