/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.URIValue;
import io.sf.carte.doc.style.css.property.URIValueWrapper;
import io.sf.carte.doc.style.css.property.ValueList;
import java.net.MalformedURLException;
import java.net.URL;
import org.w3c.dom.Node;

class WrappedCSSStyleDeclaration
extends BaseCSSStyleDeclaration {
    private static final long serialVersionUID = 1L;
    private final String hrefcontext;
    private final String oldHrefContext;

    protected WrappedCSSStyleDeclaration(BaseCSSDeclarationRule baseCSSDeclarationRule) {
        super(baseCSSDeclarationRule);
        this.oldHrefContext = this.hrefcontext = WrappedCSSStyleDeclaration.getHrefContext(baseCSSDeclarationRule);
    }

    protected WrappedCSSStyleDeclaration(BaseCSSStyleDeclaration baseCSSStyleDeclaration, String string) {
        super(baseCSSStyleDeclaration);
        this.hrefcontext = WrappedCSSStyleDeclaration.getHrefContext(this.getParentRule());
        this.oldHrefContext = string;
    }

    static String getHrefContext(BaseCSSDeclarationRule baseCSSDeclarationRule) {
        URL uRL;
        String string = null;
        AbstractCSSStyleSheet abstractCSSStyleSheet = baseCSSDeclarationRule.getParentStyleSheet();
        Node node = abstractCSSStyleSheet.getOwnerNode();
        String string2 = abstractCSSStyleSheet.getHref();
        if (string2 != null) {
            if (!string2.contains("://")) {
                if (node != null) {
                    try {
                        string = new URL(((CSSDocument)node.getOwnerDocument()).getBaseURL(), string2).toExternalForm();
                    }
                    catch (MalformedURLException malformedURLException) {
                        baseCSSDeclarationRule.getStyleDeclarationErrorHandler().malformedURIValue(string2);
                    }
                }
            } else {
                string = string2;
            }
        } else if (node != null && (uRL = ((CSSDocument)node.getOwnerDocument()).getBaseURL()) != null) {
            string = uRL.toExternalForm();
        }
        return string;
    }

    @Override
    protected StyleValue getCSSValue(String string) {
        StyleValue styleValue = super.getCSSValue(string);
        if (styleValue != null) {
            styleValue = WrappedCSSStyleDeclaration.wrapCSSValue(styleValue, this.oldHrefContext, this.hrefcontext);
        }
        return styleValue;
    }

    static StyleValue wrapCSSValue(StyleValue styleValue, String string, String string2) {
        CSSValue.CssType cssType = styleValue.getCssValueType();
        if (cssType == CSSValue.CssType.LIST) {
            if (string2 != null) {
                styleValue = ((ValueList)styleValue).wrap(string, string2);
            }
        } else if (styleValue.getPrimitiveType() == CSSValue.Type.URI && string2 != null) {
            styleValue = new URIValueWrapper((URIValue)styleValue, string, string2);
        }
        return styleValue;
    }

    @Override
    public BaseCSSStyleDeclaration clone() {
        return new WrappedCSSStyleDeclaration(this.getParentRule());
    }
}

