/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.BoxValues;
import io.sf.carte.doc.style.css.CSSCanvas;
import io.sf.carte.doc.style.css.CSSComputedProperties;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSMathFunctionValue;
import io.sf.carte.doc.style.css.CSSPrimitiveValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.StyleDatabaseRequiredException;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.om.BoxModelHelper;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.doc.style.css.property.Evaluator;
import io.sf.carte.doc.style.css.property.ExpressionValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import java.util.Locale;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class SimpleBoxModel {
    SimpleBoxModel() {
    }

    protected abstract ComputedCSSStyle getComputedStyle();

    protected abstract CSSComputedProperties getRevertStyle(Condition var1);

    private StyleDatabase getStyleDatabase() {
        return this.getComputedStyle().getStyleDatabase();
    }

    private void computeSharedBoxValues(MyBoxValues myBoxValues) {
        myBoxValues.marginTop = this.computeMarginTop(myBoxValues.unitType);
        myBoxValues.marginBottom = this.computeMarginBottom(myBoxValues.unitType);
        ComputedCSSStyle computedCSSStyle = this.getComputedStyle();
        myBoxValues.paddingTop = this.computePaddingSubproperty(computedCSSStyle, PADDING.TOP, myBoxValues.unitType);
        myBoxValues.paddingRight = this.computePaddingSubproperty(computedCSSStyle, PADDING.RIGHT, myBoxValues.unitType);
        myBoxValues.paddingBottom = this.computePaddingSubproperty(computedCSSStyle, PADDING.BOTTOM, myBoxValues.unitType);
        myBoxValues.paddingLeft = this.computePaddingSubproperty(computedCSSStyle, PADDING.LEFT, myBoxValues.unitType);
        myBoxValues.borderTopWidth = this.findBorderWidthProperty(computedCSSStyle, "border-top-width", myBoxValues.unitType, "border-top-style");
        myBoxValues.borderBottomWidth = this.findBorderWidthProperty(computedCSSStyle, "border-bottom-width", myBoxValues.unitType, "border-bottom-style");
        myBoxValues.borderLeftWidth = this.findBorderWidthProperty(computedCSSStyle, "border-left-width", myBoxValues.unitType, "border-left-style");
        myBoxValues.borderRightWidth = this.findBorderWidthProperty(computedCSSStyle, "border-right-width", myBoxValues.unitType, "border-right-style");
    }

    private float computeMarginTop(short s) {
        ComputedCSSStyle computedCSSStyle = this.getComputedStyle();
        StyleValue styleValue = computedCSSStyle.getCascadedValue("margin-top");
        if (styleValue.getPrimitiveType() == CSSValue.Type.INHERIT && (computedCSSStyle = computedCSSStyle.getParentComputedStyle()) != null) {
            return computedCSSStyle.getBoxValues(s).getMarginTop();
        }
        if (computedCSSStyle != null && styleValue.getCssValueType() == CSSValue.CssType.TYPED) {
            CSSTypedValue cSSTypedValue = (CSSTypedValue)((Object)styleValue);
            if (!SimpleBoxModel.isTypedAutoOrInvalidLength(cSSTypedValue)) {
                return this.computeMarginNumberValue(computedCSSStyle, "margin-top", cSSTypedValue, s);
            }
        } else {
            CSSPropertyValueException cSSPropertyValueException = new CSSPropertyValueException("Expected primitive value for margin-top, found " + styleValue.getCssText());
            if (computedCSSStyle == null) {
                computedCSSStyle = this.getComputedStyle();
            }
            computedCSSStyle.getStyleDeclarationErrorHandler().wrongValue("margin-top", cSSPropertyValueException);
        }
        return 0.0f;
    }

    private float computeMarginBottom(short s) {
        ComputedCSSStyle computedCSSStyle = this.getComputedStyle();
        StyleValue styleValue = computedCSSStyle.getCascadedValue("margin-bottom");
        if (styleValue.getPrimitiveType() == CSSValue.Type.INHERIT && (computedCSSStyle = computedCSSStyle.getParentComputedStyle()) != null) {
            return computedCSSStyle.getBoxValues(s).getMarginBottom();
        }
        if (computedCSSStyle != null && styleValue.getCssValueType() == CSSValue.CssType.TYPED) {
            CSSTypedValue cSSTypedValue = (CSSTypedValue)((Object)styleValue);
            if (!SimpleBoxModel.isTypedAutoOrInvalidLength(cSSTypedValue)) {
                return this.computeMarginNumberValue(computedCSSStyle, "margin-bottom", cSSTypedValue, s);
            }
        } else {
            CSSPropertyValueException cSSPropertyValueException = new CSSPropertyValueException("Expected primitive value for margin-bottom, found " + styleValue.getCssText());
            if (computedCSSStyle == null) {
                computedCSSStyle = this.getComputedStyle();
            }
            computedCSSStyle.getStyleDeclarationErrorHandler().wrongValue("margin-bottom", cSSPropertyValueException);
        }
        return 0.0f;
    }

    private static boolean isTypedAutoOrInvalidLength(CSSTypedValue cSSTypedValue) {
        return cSSTypedValue.getPrimitiveType() == CSSValue.Type.IDENT && "auto".equalsIgnoreCase(cSSTypedValue.getStringValue()) || cSSTypedValue.isNegativeNumber() && !cSSTypedValue.isCalculatedNumber();
    }

    void computeInlineBox(MyBoxValues myBoxValues) throws StyleDatabaseRequiredException {
        CSSElement cSSElement;
        Object object;
        ComputedCSSStyle computedCSSStyle = this.getComputedStyle();
        StyleValue styleValue = computedCSSStyle.getCascadedValue("margin-right");
        while (styleValue.getPrimitiveType() == CSSValue.Type.INHERIT && (computedCSSStyle = computedCSSStyle.getParentComputedStyle()) != null) {
            styleValue = computedCSSStyle.getCascadedValue("margin-right");
        }
        if (computedCSSStyle == null) {
            myBoxValues.marginRight = 0.0f;
        } else if (styleValue.getCssValueType() == CSSValue.CssType.TYPED) {
            object = (CSSTypedValue)((Object)styleValue);
            if (!SimpleBoxModel.isTypedAutoOrInvalidLength((CSSTypedValue)object)) {
                myBoxValues.marginRight = this.computeMarginNumberValue(computedCSSStyle, "margin-right", (CSSTypedValue)object, myBoxValues.unitType);
            }
        } else {
            object = new CSSPropertyValueException("Expected primitive value for margin-right, found " + styleValue.getCssText());
            computedCSSStyle.getStyleDeclarationErrorHandler().wrongValue("margin-right", (CSSPropertyValueException)object);
            myBoxValues.marginRight = 0.0f;
        }
        computedCSSStyle = this.getComputedStyle();
        styleValue = computedCSSStyle.getCascadedValue("margin-left");
        while (styleValue.getPrimitiveType() == CSSValue.Type.INHERIT && (computedCSSStyle = computedCSSStyle.getParentComputedStyle()) != null) {
            styleValue = computedCSSStyle.getCascadedValue("margin-left");
        }
        if (computedCSSStyle == null) {
            myBoxValues.marginLeft = 0.0f;
        } else if (styleValue.getCssValueType() == CSSValue.CssType.TYPED) {
            object = (CSSTypedValue)((Object)styleValue);
            if (!SimpleBoxModel.isTypedAutoOrInvalidLength((CSSTypedValue)object)) {
                myBoxValues.marginLeft = this.computeMarginNumberValue(computedCSSStyle, "margin-left", (CSSTypedValue)object, myBoxValues.unitType);
            }
        } else {
            object = new CSSPropertyValueException("Expected primitive value for margin-left, found " + styleValue.getCssText());
            computedCSSStyle.getStyleDeclarationErrorHandler().wrongValue("margin-left", (CSSPropertyValueException)object);
            myBoxValues.marginLeft = 0.0f;
        }
        object = this.getComputedStyle().getOwnerNode();
        if (object != null && object.getNodeType() == 1 && "img".equals((cSSElement = (CSSElement)object).getTagName()) && cSSElement.hasAttribute("width")) {
            String string = cSSElement.getAttribute("width");
            try {
                myBoxValues.width = Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = "Could not parse value of 'width' attribute for img element";
                CSSPropertyValueException cSSPropertyValueException = new CSSPropertyValueException(string2, numberFormatException);
                cSSPropertyValueException.setValueText(string);
                cSSElement.getOwnerDocument().getErrorHandler().computedStyleError(cSSElement, "width", cSSPropertyValueException);
            }
            if (myBoxValues.unitType != 3) {
                myBoxValues.width = NumberValue.floatValueConversion(myBoxValues.width, (short)3, myBoxValues.unitType);
            }
        }
    }

    public BoxValues getComputedBox(short s) throws DOMException, StyleDatabaseRequiredException {
        String string = this.getComputedStyle().getDisplay();
        if ("block".equalsIgnoreCase(string) || "list-item".equalsIgnoreCase(string)) {
            MyBoxValues myBoxValues = new MyBoxValues(s);
            this.computeSharedBoxValues(myBoxValues);
            this.computeBlockBox(myBoxValues);
            return myBoxValues;
        }
        if ("table".equalsIgnoreCase(string)) {
            MyTableBoxValues myTableBoxValues = new MyTableBoxValues(s);
            this.computeSharedBoxValues(myTableBoxValues);
            String string2 = this.getComputedStyle().getPropertyValue("table-layout");
            if ("auto".equalsIgnoreCase(string2)) {
                this.computeTableBox(myTableBoxValues);
                return myTableBoxValues;
            }
            this.computeBlockBox(myTableBoxValues);
            return myTableBoxValues;
        }
        if ("table-cell".equalsIgnoreCase(string) || "table-row".equalsIgnoreCase(string)) {
            MyTableItemBoxValues myTableItemBoxValues = new MyTableItemBoxValues(s);
            this.computeTableCellBox(myTableItemBoxValues);
            return myTableItemBoxValues;
        }
        MyBoxValues myBoxValues = new MyBoxValues(s);
        this.computeSharedBoxValues(myBoxValues);
        this.computeInlineBox(myBoxValues);
        return myBoxValues;
    }

    void computeBlockBox(MyBoxValues myBoxValues) throws StyleDatabaseRequiredException {
        Object object;
        Object object2;
        boolean bl = false;
        ComputedCSSStyle computedCSSStyle = this.getComputedStyle();
        StyleValue styleValue = computedCSSStyle.getCascadedValue("margin-right");
        while (styleValue.getPrimitiveType() == CSSValue.Type.INHERIT && (computedCSSStyle = computedCSSStyle.getParentComputedStyle()) != null) {
            styleValue = computedCSSStyle.getCascadedValue("margin-right");
        }
        if (styleValue.getCssValueType() == CSSValue.CssType.TYPED) {
            object2 = (CSSTypedValue)((Object)styleValue);
            bl = SimpleBoxModel.isTypedAutoOrInvalidLength((CSSTypedValue)object2);
            if (!bl) {
                myBoxValues.marginRight = this.computeMarginNumberValue(computedCSSStyle, "margin-right", (CSSTypedValue)object2, myBoxValues.unitType);
            }
        } else {
            object2 = new CSSPropertyValueException("Expected primitive value for margin-right, found " + styleValue.getCssText());
            computedCSSStyle.getStyleDeclarationErrorHandler().wrongValue("margin-right", (CSSPropertyValueException)object2);
            myBoxValues.marginRight = 0.0f;
        }
        computedCSSStyle = this.getComputedStyle();
        boolean bl2 = false;
        styleValue = computedCSSStyle.getCascadedValue("margin-left");
        while (styleValue.getPrimitiveType() == CSSValue.Type.INHERIT && (computedCSSStyle = computedCSSStyle.getParentComputedStyle()) != null) {
            styleValue = computedCSSStyle.getCascadedValue("margin-left");
        }
        if (styleValue.getCssValueType() == CSSValue.CssType.TYPED) {
            object = (CSSTypedValue)((Object)styleValue);
            bl2 = SimpleBoxModel.isTypedAutoOrInvalidLength((CSSTypedValue)object);
            if (!bl2) {
                myBoxValues.marginLeft = this.computeMarginNumberValue(computedCSSStyle, "margin-left", (CSSTypedValue)object, myBoxValues.unitType);
            }
        } else {
            object = new CSSPropertyValueException("Expected primitive value for margin-left, found " + styleValue.getCssText());
            computedCSSStyle.getStyleDeclarationErrorHandler().wrongValue("margin-left", (CSSPropertyValueException)object);
            myBoxValues.marginLeft = 0.0f;
        }
        computedCSSStyle = this.getComputedStyle();
        styleValue = computedCSSStyle.getCascadedValue("width");
        if (styleValue == null || styleValue.getCssValueType() != CSSValue.CssType.TYPED || SimpleBoxModel.isTypedAutoOrInvalidLength((CSSTypedValue)(object = (CSSTypedValue)((Object)styleValue)))) {
            ComputedCSSStyle computedCSSStyle2;
            if (bl) {
                myBoxValues.marginRight = 0.0f;
            }
            if (bl2) {
                myBoxValues.marginLeft = 0.0f;
            }
            float f = (computedCSSStyle2 = SimpleBoxModel.findContainingBlockStyle(computedCSSStyle)) == null ? this.deviceDocumentWidth("width is auto, and cannot find top block width.", "auto", myBoxValues.unitType) : this.computeWidth(computedCSSStyle2, myBoxValues.unitType);
            myBoxValues.width = f - (myBoxValues.marginLeft + myBoxValues.marginRight + myBoxValues.borderLeftWidth + myBoxValues.borderRightWidth + myBoxValues.paddingLeft + myBoxValues.paddingRight);
        } else {
            myBoxValues.width = this.computeNonAutoWidth(computedCSSStyle, (CSSTypedValue)object, myBoxValues.unitType);
            ComputedCSSStyle computedCSSStyle3 = SimpleBoxModel.findContainingBlockStyle(computedCSSStyle);
            float f = computedCSSStyle3 == null ? (this.isRootBox() ? myBoxValues.width : this.deviceDocumentWidth("width is auto, and cannot find top block width.", "auto", myBoxValues.unitType)) : this.computeWidth(computedCSSStyle3, myBoxValues.unitType);
            float f2 = f - myBoxValues.width;
            f2 -= myBoxValues.borderLeftWidth + myBoxValues.borderRightWidth + myBoxValues.paddingLeft + myBoxValues.paddingRight;
            if (bl) {
                if (f2 < 0.0f) {
                    myBoxValues.marginRight = 0.0f;
                    myBoxValues.marginLeft = 0.0f;
                } else if (bl2) {
                    myBoxValues.marginLeft = myBoxValues.marginRight = f2 / 2.0f;
                } else if (f2 < myBoxValues.marginLeft) {
                    myBoxValues.marginLeft = f2;
                    myBoxValues.marginRight = 0.0f;
                } else {
                    myBoxValues.marginRight = f2 - myBoxValues.marginLeft;
                }
            } else if (bl2) {
                if (f2 < 0.0f) {
                    myBoxValues.marginRight = 0.0f;
                    myBoxValues.marginLeft = 0.0f;
                } else if (f2 < myBoxValues.marginRight) {
                    myBoxValues.marginRight = f2;
                    myBoxValues.marginLeft = 0.0f;
                } else {
                    myBoxValues.marginLeft = f2;
                }
            } else if ((f2 -= myBoxValues.marginLeft + myBoxValues.marginRight) < 0.0f) {
                if ("ltr".equalsIgnoreCase(computedCSSStyle.getPropertyValue("direction"))) {
                    myBoxValues.marginRight = (f2 += myBoxValues.marginRight) > 0.0f ? f2 : 0.0f;
                } else {
                    myBoxValues.marginLeft = (f2 += myBoxValues.marginLeft) > 0.0f ? f2 : 0.0f;
                }
            }
        }
    }

    private void computeTableBox(MyTableBoxValues myTableBoxValues) {
        block25: {
            float f;
            float[] fArray;
            int n;
            float f2;
            block23: {
                boolean bl;
                float f3;
                Object object;
                block26: {
                    block24: {
                        int n2;
                        this.computeBlockBox(myTableBoxValues);
                        f2 = this.computeCapmin(myTableBoxValues.unitType);
                        ComputedCSSStyle computedCSSStyle = this.getComputedStyle();
                        CSSElement cSSElement = computedCSSStyle.getOwnerNode();
                        NodeList nodeList = cSSElement.getElementsByTagName("tbody");
                        nodeList = nodeList.getLength() > 0 ? nodeList.item(0).getChildNodes() : cSSElement.getChildNodes();
                        n = 0;
                        int n3 = nodeList.getLength();
                        for (int i = 0; i < n3; ++i) {
                            CSSElement cSSElement2;
                            object = nodeList.item(i);
                            if (object.getNodeType() != 1 || !"tr".equalsIgnoreCase((cSSElement2 = (CSSElement)object).getTagName()) || (n2 = cSSElement2.getChildNodes().getLength()) <= n) continue;
                            n = n2;
                        }
                        fArray = new float[n];
                        object = new float[n];
                        float f4 = 0.0f;
                        for (n2 = 0; n2 < n3; ++n2) {
                            CSSElement cSSElement3;
                            Node node = nodeList.item(n2);
                            if (node.getNodeType() != 1 || !"tr".equalsIgnoreCase((cSSElement3 = (CSSElement)node).getTagName())) continue;
                            computedCSSStyle = (ComputedCSSStyle)cSSElement3.getOwnerDocument().getStyleSheet().getComputedStyle(cSSElement3, null);
                            BoxValues boxValues = computedCSSStyle.getBoxValues(myTableBoxValues.unitType);
                            float f5 = boxValues.getBorderLeftWidth() + boxValues.getBorderRightWidth() + boxValues.getMarginLeft() + boxValues.getMarginRight() + boxValues.getPaddingLeft() + boxValues.getPaddingRight();
                            if (f4 < f5) {
                                f4 = f5;
                            }
                            NodeList nodeList2 = cSSElement3.getChildNodes();
                            int n4 = nodeList2.getLength();
                            int n5 = 0;
                            for (int i = 0; i < n4; ++i) {
                                float[] fArray2;
                                Node node2 = nodeList2.item(i);
                                if (node2.getNodeType() != 1) continue;
                                CSSElement cSSElement4 = (CSSElement)node2;
                                computedCSSStyle = (ComputedCSSStyle)cSSElement3.getOwnerDocument().getStyleSheet().getComputedStyle(cSSElement4, null);
                                if (!"table-cell".equalsIgnoreCase(computedCSSStyle.getPropertyValue("display"))) continue;
                                int n6 = 1;
                                String string = cSSElement4.getAttribute("colspan");
                                if (string.length() != 0) {
                                    n6 = Integer.parseInt(string);
                                }
                                if ((fArray2 = this.computeChildContentWidth(cSSElement4, n6, computedCSSStyle, myTableBoxValues.unitType))[0] > object[n5]) {
                                    object[n5] = fArray2[0];
                                }
                                if (fArray2[1] > fArray[n5]) {
                                    fArray[n5] = fArray2[1];
                                }
                                n5 += n6;
                            }
                        }
                        f = f4 += myTableBoxValues.getBorderLeftWidth() + myTableBoxValues.getBorderRightWidth() + myTableBoxValues.getMarginLeft() + myTableBoxValues.getMarginRight() + myTableBoxValues.getPaddingLeft() + myTableBoxValues.getPaddingRight();
                        f3 = f4;
                        for (int i = 0; i < n; ++i) {
                            f += fArray[i];
                            f3 += object[i];
                        }
                        myTableBoxValues.colwidth = new float[n];
                        StyleValue styleValue = computedCSSStyle.getCascadedValue("width");
                        if (styleValue != null && styleValue.getCssValueType() == CSSValue.CssType.TYPED && !SimpleBoxModel.isTypedAutoOrInvalidLength((CSSTypedValue)((Object)styleValue))) break block23;
                        if (!(f2 < myTableBoxValues.getWidth()) || !(f3 < myTableBoxValues.getWidth())) break block24;
                        if (f3 > f2) {
                            myTableBoxValues.width = f3;
                            for (int i = 0; i < n; ++i) {
                                myTableBoxValues.colwidth[i] = (float)object[i];
                            }
                        } else {
                            myTableBoxValues.width = f2;
                            float f6 = f2 / f3;
                            for (int i = 0; i < n; ++i) {
                                myTableBoxValues.colwidth[i] = (float)(object[i] * f6);
                            }
                        }
                        break block25;
                    }
                    bl = true;
                    if (f > myTableBoxValues.width) {
                        myTableBoxValues.width = f;
                        for (int i = 0; i < n; ++i) {
                            myTableBoxValues.colwidth[i] = fArray[i];
                        }
                        bl = false;
                    }
                    if (!(f2 > myTableBoxValues.width)) break block26;
                    float f7 = f2 / myTableBoxValues.width;
                    myTableBoxValues.width = f2;
                    int n7 = 0;
                    while (n7 < n) {
                        int n8 = n7++;
                        myTableBoxValues.colwidth[n8] = myTableBoxValues.colwidth[n8] * f7;
                    }
                    break block25;
                }
                if (!bl) break block25;
                for (int i = 0; i < n; ++i) {
                    myTableBoxValues.colwidth[i] = (float)object[i];
                }
                BoxModelHelper.shrinkTo(myTableBoxValues, fArray, f, f3, myTableBoxValues.width);
                float f8 = 0.0f;
                for (int i = 0; i < n; ++i) {
                    f8 += myTableBoxValues.colwidth[i];
                }
                myTableBoxValues.width = f8;
                break block25;
            }
            if (f > myTableBoxValues.width) {
                myTableBoxValues.width = f;
                for (int i = 0; i < n; ++i) {
                    myTableBoxValues.colwidth[i] = fArray[i];
                }
            } else {
                float f9 = myTableBoxValues.width / f;
                for (int i = 0; i < n; ++i) {
                    myTableBoxValues.colwidth[i] = fArray[i] * f9;
                }
            }
            if (f2 > myTableBoxValues.width) {
                float f10 = f2 / myTableBoxValues.width;
                myTableBoxValues.width = f2;
                int n9 = 0;
                while (n9 < n) {
                    int n10 = n9++;
                    myTableBoxValues.colwidth[n10] = myTableBoxValues.colwidth[n10] * f10;
                }
            }
        }
    }

    private float computeCapmin(short s) {
        CSSCanvas cSSCanvas = this.getComputedStyle().getOwnerNode().getOwnerDocument().getCanvas();
        ComputedCSSStyle computedCSSStyle = this.getComputedStyle();
        CSSElement cSSElement = computedCSSStyle.getOwnerNode();
        NodeList nodeList = cSSElement.getElementsByTagName("caption");
        float f = 0.0f;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            CSSElement cSSElement2 = (CSSElement)nodeList.item(i);
            NodeList nodeList2 = cSSElement2.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                String string;
                Node node = nodeList2.item(j);
                if (node.getNodeType() == 1) {
                    CSSElement cSSElement3 = (CSSElement)node;
                    computedCSSStyle = (ComputedCSSStyle)cSSElement3.getOwnerDocument().getStyleSheet().getComputedStyle(cSSElement3, null);
                    if (!"inline".equalsIgnoreCase(computedCSSStyle.getDisplay())) {
                        throw new DOMException(9, "Only inline elements are supported in caption");
                    }
                    string = node.getTextContent();
                } else {
                    string = node.getNodeType() == 3 || node.getNodeType() == 4 ? node.getTextContent() : null;
                }
                float f2 = 0.0f;
                if (string != null) {
                    string = BoxModelHelper.contractSpaces(string.trim());
                    f2 = cSSCanvas != null ? NumberValue.floatValueConversion(cSSCanvas.stringWidth(string, computedCSSStyle), (short)6, s) : BoxModelHelper.computeNodeMinimumWidth(string, computedCSSStyle, s);
                }
                if (!(f2 > f)) continue;
                f = f2;
            }
        }
        return f;
    }

    private float[] computeChildContentWidth(CSSElement cSSElement, int n, ComputedCSSStyle computedCSSStyle, short s) {
        float[] fArray = new float[]{0.0f, 0.0f};
        NodeList nodeList = cSSElement.getChildNodes();
        int n2 = nodeList.getLength();
        for (int i = 0; i < n2; ++i) {
            Object object;
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                object = this.computeTextWidth(node.getTextContent(), n, computedCSSStyle, s);
                fArray[0] = fArray[0] + object[0];
                fArray[1] = fArray[1] + object[1];
                continue;
            }
            if (node.getNodeType() != 1) continue;
            object = (CSSElement)node;
            computedCSSStyle = (ComputedCSSStyle)object.getOwnerDocument().getStyleSheet().getComputedStyle((CSSElement)object, null);
            float f = this.computeWidth(computedCSSStyle, s);
            fArray[0] = fArray[0] + f;
            fArray[1] = fArray[1] + f;
        }
        return fArray;
    }

    private float[] computeTextWidth(String string, int n, ComputedCSSStyle computedCSSStyle, short s) {
        float[] fArray = new float[]{0.0f, 0.0f};
        string = BoxModelHelper.contractSpaces(string.trim());
        CSSCanvas cSSCanvas = this.getComputedStyle().getOwnerNode().getOwnerDocument().getCanvas();
        fArray[0] = cSSCanvas != null ? NumberValue.floatValueConversion(cSSCanvas.stringWidth(string, computedCSSStyle), (short)6, s) : BoxModelHelper.computeTextWidth(string, computedCSSStyle, s);
        BoxValues boxValues = computedCSSStyle.getBoxValues(s);
        float f = boxValues.getBorderLeftWidth() + boxValues.getBorderRightWidth() + boxValues.getMarginLeft() + boxValues.getMarginRight() + boxValues.getPaddingLeft() + boxValues.getPaddingRight();
        fArray[0] = fArray[0] + f;
        fArray[1] = cSSCanvas != null ? BoxModelHelper.computeNodeMinimumWidth(string, computedCSSStyle, cSSCanvas, s) / (float)n + f : BoxModelHelper.computeNodeMinimumWidth(string, computedCSSStyle, s) / (float)n + f;
        return fArray;
    }

    private void computeTableCellBox(MyBoxValues myBoxValues) {
        this.computeSharedBoxValues(myBoxValues);
        this.computeInlineBox(myBoxValues);
    }

    private float deviceDocumentWidth(String string, String string2, short s) throws StyleDatabaseRequiredException {
        Object object;
        Object object2;
        StyleDatabase styleDatabase = this.getStyleDatabase();
        Document document = this.getComputedStyle().getOwnerNode().getOwnerDocument();
        if (document != null && (object2 = document.getCanvas()) != null && (object = object2.getViewport()) != null) {
            float f = object.getViewportWidth();
            return NumberValue.floatValueConversion(f, styleDatabase.getNaturalUnit(), s);
        }
        if (styleDatabase == null) {
            if (document != null && (object2 = document.getTargetMedium()) != null) {
                if ("print".equals(object2)) {
                    return 595.0f;
                }
                if ("screen".equals(object2)) {
                    return 1440.0f;
                }
                if ("handheld".equals(object2)) {
                    return 270.0f;
                }
            }
            object = new StyleDatabaseRequiredException("No style database, " + string);
            ((StyleDatabaseRequiredException)object).setValueText(string2);
            throw object;
        }
        return NumberValue.floatValueConversion(styleDatabase.getDeviceWidth(), styleDatabase.getNaturalUnit(), s);
    }

    private float computeMarginNumberValue(ComputedCSSStyle computedCSSStyle, String string, CSSTypedValue cSSTypedValue, short s) throws StyleDatabaseRequiredException {
        float f;
        try {
            f = this.floatValue(computedCSSStyle, string, cSSTypedValue, s, true);
            if (f < 0.0f) {
                f = 0.0f;
            }
        }
        catch (DOMException dOMException) {
            CSSPropertyValueException cSSPropertyValueException = new CSSPropertyValueException("Expected number, found " + cSSTypedValue.getCssText());
            computedCSSStyle.getStyleDeclarationErrorHandler().wrongValue(string, cSSPropertyValueException);
            f = 0.0f;
        }
        return f;
    }

    private float floatValue(ComputedCSSStyle computedCSSStyle, String string, CSSTypedValue cSSTypedValue, short s, boolean bl) throws DOMException {
        float f;
        CSSValue.Type type;
        if (s < 0) {
            if (this.getStyleDatabase() == null) {
                StyleDatabaseRequiredException styleDatabaseRequiredException = new StyleDatabaseRequiredException("Requested natural unit, but no style database was set.");
                styleDatabaseRequiredException.setValueText(cSSTypedValue.getCssText());
                throw styleDatabaseRequiredException;
            }
            s = this.getStyleDatabase().getNaturalUnit();
        }
        if ((type = cSSTypedValue.getPrimitiveType()) == CSSValue.Type.EXPRESSION) {
            f = this.calcValue(computedCSSStyle, string, (ExpressionValue)cSSTypedValue, s, bl);
        } else if (type == CSSValue.Type.MATH_FUNCTION) {
            f = this.functionValue(computedCSSStyle, string, (CSSMathFunctionValue)cSSTypedValue, s, bl);
        } else if (type == CSSValue.Type.NUMERIC) {
            f = cSSTypedValue.getUnitType() == 2 ? this.percentageValue(computedCSSStyle, cSSTypedValue, s, bl) : cSSTypedValue.getFloatValue(s);
        } else {
            throw new DOMException(15, "Unable to evaluate value of type: " + (Object)((Object)type));
        }
        return f;
    }

    private float percentageValue(ComputedCSSStyle computedCSSStyle, CSSTypedValue cSSTypedValue, short s, boolean bl) {
        if ((computedCSSStyle = SimpleBoxModel.findContainingBlockStyle(computedCSSStyle)) == null) {
            if (bl) {
                return this.deviceDocumentWidth("no enclosing block, and value is percentage.", cSSTypedValue.getCssText(), s) * cSSTypedValue.getFloatValue((short)2) / 100.0f;
            }
            this.getComputedStyle().getStyleDeclarationErrorHandler().noContainingBlock(this.getComputedStyle().getDisplay(), this.getComputedStyle().getOwnerNode());
            return 0.0f;
        }
        return this.computeWidth(computedCSSStyle, s) * cSSTypedValue.getFloatValue((short)2) / 100.0f;
    }

    private static ComputedCSSStyle findContainingBlockStyle(ComputedCSSStyle computedCSSStyle) {
        String string = computedCSSStyle.getPropertyValue("position");
        if ("fixed".equalsIgnoreCase(string)) {
            return null;
        }
        if ("absolute".equalsIgnoreCase(string)) {
            throw new DOMException(9, "position: absolute is not supported");
        }
        String string2 = computedCSSStyle.getPropertyValue("display");
        if ("table-cell".equalsIgnoreCase(string2)) {
            while ((computedCSSStyle = computedCSSStyle.getParentComputedStyle()) != null && !"table".equalsIgnoreCase(string2 = computedCSSStyle.getPropertyValue("display"))) {
            }
        } else {
            while ((computedCSSStyle = computedCSSStyle.getParentComputedStyle()) != null) {
                string2 = computedCSSStyle.getPropertyValue("display");
                if (!"block".equals(string2 = string2.toLowerCase(Locale.ROOT)) && !"list-item".equals(string2) && !"table".equals(string2) && !string2.startsWith("table-")) continue;
            }
        }
        return computedCSSStyle;
    }

    private boolean isRootBox() {
        return this.getComputedStyle().getOwnerNode().getParentNode().getNodeType() != 1;
    }

    private float calcValue(ComputedCSSStyle computedCSSStyle, String string, ExpressionValue expressionValue, short s, boolean bl) {
        BoxEvaluator boxEvaluator = new BoxEvaluator(computedCSSStyle, string, bl);
        CSSTypedValue cSSTypedValue = boxEvaluator.evaluateExpression(expressionValue);
        if (cSSTypedValue.isNegativeNumber()) {
            return 0.0f;
        }
        return cSSTypedValue.getFloatValue(s);
    }

    private float functionValue(ComputedCSSStyle computedCSSStyle, String string, CSSMathFunctionValue cSSMathFunctionValue, short s, boolean bl) {
        BoxEvaluator boxEvaluator = new BoxEvaluator(computedCSSStyle, string, bl);
        return boxEvaluator.evaluateFunction(cSSMathFunctionValue).getFloatValue(s);
    }

    private float computeWidth(ComputedCSSStyle computedCSSStyle, short s) throws StyleDatabaseRequiredException {
        CSSTypedValue cSSTypedValue;
        StyleValue styleValue = computedCSSStyle.getCascadedValue("width");
        if (styleValue == null || styleValue.getCssValueType() != CSSValue.CssType.TYPED || SimpleBoxModel.isTypedAutoOrInvalidLength(cSSTypedValue = (CSSTypedValue)((Object)styleValue))) {
            float f;
            StyleValue styleValue2 = computedCSSStyle.getCascadedValue("margin-left");
            StyleValue styleValue3 = computedCSSStyle.getCascadedValue("margin-right");
            float f2 = this.findWidthautoBoxProperty(computedCSSStyle, "margin-left", styleValue2, s);
            float f3 = this.findBorderWidthProperty(computedCSSStyle, "border-left-width", s, "border-left-style");
            float f4 = this.computePaddingSubproperty(computedCSSStyle, PADDING.LEFT, s);
            float f5 = this.computePaddingSubproperty(computedCSSStyle, PADDING.RIGHT, s);
            float f6 = this.findBorderWidthProperty(computedCSSStyle, "border-right-width", s, "border-right-style");
            float f7 = this.findWidthautoBoxProperty(computedCSSStyle, "margin-right", styleValue3, s);
            ComputedCSSStyle computedCSSStyle2 = SimpleBoxModel.findContainingBlockStyle(computedCSSStyle);
            if (computedCSSStyle2 == null) {
                f = this.deviceDocumentWidth("width is auto, and cannot find top block width.", "auto", s);
            } else {
                String string = computedCSSStyle2.getPropertyValue("display").toLowerCase(Locale.ROOT);
                if ("table".equals(string) || string.startsWith("table-")) {
                    styleValue = computedCSSStyle2.getCascadedValue("width");
                    if (styleValue == null || styleValue.getCssValueType() != CSSValue.CssType.TYPED || SimpleBoxModel.isTypedAutoOrInvalidLength(cSSTypedValue = (CSSTypedValue)((Object)styleValue)) || cSSTypedValue.getUnitType() == 2) {
                        throw new DOMException(9, "Automatic tables not supported by this box model");
                    }
                    f = this.computeNonAutoWidth(computedCSSStyle2, cSSTypedValue, s);
                } else {
                    f = this.computeWidth(computedCSSStyle2, s);
                }
            }
            return f - (f2 + f7 + f3 + f6 + f4 + f5);
        }
        return this.computeNonAutoWidth(computedCSSStyle, cSSTypedValue, s);
    }

    private float computeNonAutoWidth(ComputedCSSStyle computedCSSStyle, CSSTypedValue cSSTypedValue, short s) throws DOMException, StyleDatabaseRequiredException {
        float f;
        try {
            f = this.floatValue(computedCSSStyle, "width", cSSTypedValue, s, true);
        }
        catch (DOMException dOMException) {
            CSSPropertyValueException cSSPropertyValueException = new CSSPropertyValueException("Expected number, found " + cSSTypedValue.getCssText());
            computedCSSStyle.getStyleDeclarationErrorHandler().wrongValue("width", cSSPropertyValueException);
            f = 0.0f;
        }
        return f;
    }

    private float findWidthautoBoxProperty(ComputedCSSStyle computedCSSStyle, String string, CSSValue cSSValue, short s) throws StyleDatabaseRequiredException, DOMException {
        if (cSSValue != null && !SimpleBoxModel.isAutoOrInvalidLength(cSSValue)) {
            while (cSSValue.getPrimitiveType() == CSSValue.Type.INHERIT) {
                if ((computedCSSStyle = SimpleBoxModel.findContainingBlockStyle(computedCSSStyle)) != null) {
                    cSSValue = computedCSSStyle.getCascadedValue(string);
                    continue;
                }
                cSSValue = null;
                break;
            }
            if (cSSValue != null) {
                if (cSSValue.getCssValueType() != CSSValue.CssType.TYPED) {
                    throw new DOMException(12, "Unexpected width value: " + cSSValue.getCssText());
                }
                CSSTypedValue cSSTypedValue = (CSSTypedValue)cSSValue;
                return this.findNumericBoxProperty(computedCSSStyle, string, cSSTypedValue, s);
            }
        }
        return 0.0f;
    }

    private static boolean isAutoOrInvalidLength(CSSValue cSSValue) {
        return cSSValue.getCssValueType() == CSSValue.CssType.TYPED && SimpleBoxModel.isTypedAutoOrInvalidLength((CSSTypedValue)cSSValue);
    }

    private float findBorderWidthProperty(ComputedCSSStyle computedCSSStyle, String string, short s, String string2) throws StyleDatabaseRequiredException, DOMException {
        StyleValue styleValue = computedCSSStyle.getCascadedValue(string2);
        if (styleValue == null || styleValue.getPrimitiveType() != CSSValue.Type.IDENT || "none".equalsIgnoreCase(((CSSTypedValue)((Object)styleValue)).getStringValue())) {
            return 0.0f;
        }
        StyleValue styleValue2 = computedCSSStyle.getCascadedValue(string);
        if (styleValue2 != null) {
            while (styleValue2.getPrimitiveType() == CSSValue.Type.INHERIT) {
                if ((computedCSSStyle = SimpleBoxModel.findContainingBlockStyle(computedCSSStyle)) != null) {
                    styleValue2 = computedCSSStyle.getCascadedValue(string);
                    continue;
                }
                styleValue2 = null;
                break;
            }
            if (styleValue2 != null) {
                float f;
                if (styleValue2.getCssValueType() != CSSValue.CssType.TYPED) {
                    throw new DOMException(12, "Unexpected border-width value: " + styleValue2.getCssText());
                }
                CSSTypedValue cSSTypedValue = (CSSTypedValue)((Object)styleValue2);
                if (cSSTypedValue.getPrimitiveType() == CSSValue.Type.IDENT) {
                    short s2;
                    if (this.getStyleDatabase() == null) {
                        if (this.getComplianceMode() != CSSDocument.ComplianceMode.QUIRKS) {
                            StyleDatabaseRequiredException styleDatabaseRequiredException = new StyleDatabaseRequiredException("No style database, and " + string + " value is an identifier.");
                            styleDatabaseRequiredException.setValueText(styleValue2.getCssText());
                            throw styleDatabaseRequiredException;
                        }
                        float f2 = this.getComputedStyle().getComputedFontSize();
                        String string3 = cSSTypedValue.getStringValue();
                        f = string3.equalsIgnoreCase("thin") ? (float)Math.floor(1.0 + (double)f2 * 0.05) : (string3.equalsIgnoreCase("thick") ? (float)Math.floor(4.0 + (double)f2 * 0.15) : (float)Math.floor(2.0 + (double)f2 * 0.1));
                        s2 = 6;
                    } else {
                        s2 = this.getStyleDatabase().getNaturalUnit();
                        f = this.getStyleDatabase().getWidthSize(cSSTypedValue.getStringValue(), computedCSSStyle.getComputedFontSize());
                    }
                    if (s != s2) {
                        f = NumberValue.floatValueConversion(f, s2, s);
                    }
                } else {
                    f = this.findNumericBoxProperty(computedCSSStyle, string, cSSTypedValue, s);
                }
                return f;
            }
        }
        return 0.0f;
    }

    private CSSDocument.ComplianceMode getComplianceMode() {
        CSSDocument cSSDocument;
        CSSElement cSSElement = this.getComputedStyle().getOwnerNode();
        if (cSSElement != null && (cSSDocument = (CSSDocument)cSSElement.getOwnerDocument()) != null) {
            return cSSDocument.getComplianceMode();
        }
        return CSSDocument.ComplianceMode.STRICT;
    }

    private float findNumericBoxProperty(ComputedCSSStyle computedCSSStyle, String string, CSSTypedValue cSSTypedValue, short s) throws StyleDatabaseRequiredException {
        float f;
        try {
            f = this.floatValue(computedCSSStyle, string, cSSTypedValue, s, true);
        }
        catch (DOMException dOMException) {
            CSSPropertyValueException cSSPropertyValueException = new CSSPropertyValueException("Expected number, found " + cSSTypedValue.getCssText());
            computedCSSStyle.getStyleDeclarationErrorHandler().wrongValue(string, cSSPropertyValueException);
            f = 0.0f;
        }
        return f;
    }

    private float computePaddingSubproperty(ComputedCSSStyle computedCSSStyle, PADDING pADDING, short s) throws StyleDatabaseRequiredException {
        float f;
        String string;
        switch (pADDING.ordinal()) {
            case 0: {
                string = "padding-top";
                break;
            }
            case 1: {
                string = "padding-right";
                break;
            }
            case 2: {
                string = "padding-bottom";
                break;
            }
            default: {
                string = "padding-left";
            }
        }
        StyleValue styleValue = computedCSSStyle.getCascadedValue(string);
        if (styleValue.getPrimitiveType() == CSSValue.Type.INHERIT) {
            if ((computedCSSStyle = computedCSSStyle.getParentComputedStyle()) != null) {
                float f2;
                BoxValues boxValues = computedCSSStyle.getBoxValues(s);
                switch (pADDING.ordinal()) {
                    case 0: {
                        f2 = boxValues.getPaddingTop();
                        break;
                    }
                    case 1: {
                        f2 = boxValues.getPaddingRight();
                        break;
                    }
                    case 2: {
                        f2 = boxValues.getPaddingBottom();
                        break;
                    }
                    default: {
                        f2 = boxValues.getPaddingLeft();
                    }
                }
                return f2;
            }
            this.getComputedStyle().getStyleDeclarationErrorHandler().noContainingBlock(this.getComputedStyle().getDisplay(), this.getComputedStyle().getOwnerNode());
            return 0.0f;
        }
        if (styleValue.getCssValueType() != CSSValue.CssType.TYPED) {
            throw new DOMException(12, "Unexpected padding value: " + styleValue.getCssText());
        }
        CSSTypedValue cSSTypedValue = (CSSTypedValue)((Object)styleValue);
        try {
            f = this.floatValue(computedCSSStyle, string, cSSTypedValue, s, false);
            if (f < 0.0f) {
                f = 0.0f;
            }
        }
        catch (DOMException dOMException) {
            CSSPropertyValueException cSSPropertyValueException = new CSSPropertyValueException("Expected number, found " + cSSTypedValue.getCssText());
            computedCSSStyle.getStyleDeclarationErrorHandler().wrongValue(string, cSSPropertyValueException);
            f = 0.0f;
        }
        return f;
    }

    private class BoxEvaluator
    extends Evaluator {
        private final ComputedCSSStyle styledecl;
        private final String propertyName;
        private final boolean useDeviceDocumentWidth;

        private BoxEvaluator(ComputedCSSStyle computedCSSStyle, String string, boolean bl) {
            this.styledecl = computedCSSStyle;
            this.propertyName = string;
            this.useDeviceDocumentWidth = bl;
        }

        @Override
        protected CSSTypedValue absoluteTypedValue(CSSTypedValue cSSTypedValue) {
            return this.styledecl.absoluteTypedValue(this.propertyName, (TypedValue)cSSTypedValue, false);
        }

        @Override
        protected StyleValue absoluteProxyValue(CSSPrimitiveValue cSSPrimitiveValue) {
            return this.styledecl.replaceProxyValue(this.propertyName, cSSPrimitiveValue);
        }

        @Override
        protected float percentage(CSSTypedValue cSSTypedValue, short s) throws DOMException {
            return SimpleBoxModel.this.percentageValue(this.styledecl, cSSTypedValue, s, this.useDeviceDocumentWidth);
        }
    }

    static class MyBoxValues
    implements BoxValues {
        final short unitType;
        float marginTop = 0.0f;
        float marginRight = 0.0f;
        float marginBottom = 0.0f;
        float marginLeft = 0.0f;
        float paddingTop = 0.0f;
        float paddingRight = 0.0f;
        float paddingBottom = 0.0f;
        float paddingLeft = 0.0f;
        float borderTopWidth = 0.0f;
        float borderBottomWidth = 0.0f;
        float borderRightWidth = 0.0f;
        float borderLeftWidth = 0.0f;
        float width = Float.MIN_VALUE;

        MyBoxValues(short s) {
            this.unitType = s;
        }

        @Override
        public float getMarginTop() {
            return this.marginTop;
        }

        @Override
        public float getMarginRight() {
            return this.marginRight;
        }

        @Override
        public float getMarginBottom() {
            return this.marginBottom;
        }

        @Override
        public float getMarginLeft() {
            return this.marginLeft;
        }

        @Override
        public float getPaddingTop() {
            return this.paddingTop;
        }

        @Override
        public float getPaddingRight() {
            return this.paddingRight;
        }

        @Override
        public float getPaddingBottom() {
            return this.paddingBottom;
        }

        @Override
        public float getPaddingLeft() {
            return this.paddingLeft;
        }

        @Override
        public float getBorderTopWidth() {
            return this.borderTopWidth;
        }

        @Override
        public float getBorderRightWidth() {
            return this.borderRightWidth;
        }

        @Override
        public float getBorderBottomWidth() {
            return this.borderBottomWidth;
        }

        @Override
        public float getBorderLeftWidth() {
            return this.borderLeftWidth;
        }

        @Override
        public float getWidth() {
            return this.width;
        }

        @Override
        public short getUnitType() {
            return this.unitType;
        }
    }

    static class MyTableBoxValues
    extends MyBoxValues
    implements BoxValues.TableBoxValues {
        float[] colwidth;

        MyTableBoxValues(short s) {
            super(s);
        }

        @Override
        public float[] getColumnsContentWidth() {
            return this.colwidth;
        }
    }

    static class MyTableItemBoxValues
    extends MyBoxValues {
        MyTableItemBoxValues(short s) {
            super(s);
        }

        @Override
        public float getWidth() {
            throw new DOMException(9, "Operation not supported by this box model. Please compute box for table and cast to TableBoxValues.");
        }
    }

    private static enum PADDING {
        TOP,
        RIGHT,
        BOTTOM,
        LEFT;

    }
}

