/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.ElementList;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import java.util.Iterator;
import java.util.LinkedList;
import org.w3c.dom.Node;

class DOMElementLinkedList
extends LinkedList<DOMElement>
implements ElementList {
    private static final long serialVersionUID = 2L;

    DOMElementLinkedList() {
    }

    @Override
    public boolean contains(Node node) {
        return super.contains(node);
    }

    @Override
    public DOMElement item(int n) {
        if (n < 0 || n >= this.size()) {
            return null;
        }
        return (DOMElement)this.get(n);
    }

    @Override
    public int getLength() {
        return this.size();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.size() * 32 + 40);
        Iterator iterator = this.iterator();
        if (iterator.hasNext()) {
            stringBuilder.append(((DOMElement)iterator.next()).toString());
        }
        while (iterator.hasNext()) {
            stringBuilder.append(',').append(((DOMElement)iterator.next()).toString());
        }
        return stringBuilder.toString();
    }

    void fillQuerySelectorList(SelectorList selectorList, Node node) {
        for (Node node2 = node; node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1) continue;
            DOMElement dOMElement = (DOMElement)node2;
            if (dOMElement.matches(selectorList, null)) {
                this.add(dOMElement);
            }
            this.fillQuerySelectorList(selectorList, dOMElement.getFirstChild());
        }
    }
}

