/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.svg;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.ListValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import io.sf.carte.echosvg.css.engine.value.svg.ColorManager;
import io.sf.carte.echosvg.css.engine.value.svg.SVGValueConstants;
import org.w3c.dom.DOMException;

public class SVGColorManager
extends ColorManager {
    protected String property;
    protected Value defaultValue;

    public SVGColorManager(String string) {
        this(string, ValueConstants.BLACK_RGB_VALUE);
    }

    public SVGColorManager(String string, Value value) {
        this.property = string;
        this.defaultValue = value;
    }

    @Override
    public boolean isInheritedProperty() {
        return false;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return true;
    }

    @Override
    public int getPropertyType() {
        return 6;
    }

    @Override
    public String getPropertyName() {
        return this.property;
    }

    @Override
    public Value getDefaultValue() {
        return this.defaultValue.clone();
    }

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        if (lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && lexicalUnit.getStringValue().equalsIgnoreCase("currentcolor")) {
            return SVGValueConstants.CURRENTCOLOR_VALUE;
        }
        Value value = super.createValue(lexicalUnit, cSSEngine);
        if ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) == null) {
            return value;
        }
        throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
    }

    @Override
    public Value computeValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n, StyleMap styleMap, Value value) {
        if (value.isIdentifier("currentcolor")) {
            styleMap.putColorRelative(n, true);
            int n2 = cSSEngine.getColorIndex();
            return cSSEngine.getComputedStyle(cSSStylableElement, string, n2);
        }
        if (value.getCssValueType() == CSSValue.CssType.LIST) {
            Value value2 = value.item(0);
            Value value3 = super.computeValue(cSSStylableElement, string, cSSEngine, n, styleMap, value2);
            if (value3 != value2) {
                ListValue listValue = new ListValue(' ');
                listValue.append(value3);
                listValue.append(value.item(1));
                return listValue;
            }
            return value;
        }
        return super.computeValue(cSSStylableElement, string, cSSEngine, n, styleMap, value);
    }
}

