/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.dom;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.echosvg.css.dom.CSSOMSVGColor;
import io.sf.carte.echosvg.css.engine.value.AbstractValueModificationHandler;
import io.sf.carte.echosvg.css.engine.value.ColorValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueModificationHandler;
import org.w3c.dom.DOMException;

public class CSSOMSVGPaint
extends CSSOMSVGColor {
    public CSSOMSVGPaint(CSSOMSVGColor.ValueProvider valueProvider) {
        super(valueProvider);
    }

    @Override
    public void setModificationHandler(ValueModificationHandler valueModificationHandler) {
        if (!(valueModificationHandler instanceof PaintModificationHandler)) {
            throw new IllegalArgumentException();
        }
        super.setModificationHandler(valueModificationHandler);
    }

    @Override
    public short getColorType() {
        throw new DOMException(15, "");
    }

    public short getPaintType() {
        Value value = this.valueProvider.getValue();
        block0 : switch (value.getCssValueType()) {
            case TYPED: {
                switch (value.getPrimitiveType()) {
                    case IDENT: {
                        String string = value.getIdentifierValue();
                        if (string.equalsIgnoreCase("none")) {
                            return 101;
                        }
                        if (string.equalsIgnoreCase("currentcolor")) {
                            return 102;
                        }
                        return 1;
                    }
                    case COLOR: {
                        ColorValue colorValue = value.getColorValue();
                        switch (colorValue.getCSSColorSpace()) {
                            case "rgb": {
                                return 1;
                            }
                        }
                        break block0;
                    }
                    case URI: {
                        return 107;
                    }
                }
                break;
            }
            case LIST: {
                Value value2 = value.item(0);
                Value value3 = value.item(1);
                switch (value2.getPrimitiveType()) {
                    case IDENT: {
                        return 2;
                    }
                    case URI: {
                        if (value3.getCssValueType() == CSSValue.CssType.LIST) {
                            return 106;
                        }
                        switch (value3.getPrimitiveType()) {
                            case IDENT: {
                                String string = value3.getIdentifierValue();
                                if (string.equalsIgnoreCase("none")) {
                                    return 103;
                                }
                                if (string.equalsIgnoreCase("currentcolor")) {
                                    return 104;
                                }
                                return 105;
                            }
                            case COLOR: {
                                ColorValue colorValue = value3.getColorValue();
                                switch (colorValue.getCSSColorSpace()) {
                                    case "rgb": {
                                        return 105;
                                    }
                                }
                            }
                        }
                        break block0;
                    }
                    case COLOR: {
                        ColorValue colorValue = value2.getColorValue();
                        switch (colorValue.getCSSColorSpace()) {
                            case "rgb": {
                                return 2;
                            }
                        }
                    }
                }
            }
        }
        return 0;
    }

    @Override
    public String getURIValue() throws DOMException {
        return this.getUri();
    }

    public String getUri() {
        switch (this.getPaintType()) {
            case 107: {
                return this.valueProvider.getValue().getURIValue();
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                return this.valueProvider.getValue().item(0).getStringValue();
            }
        }
        throw new InternalError();
    }

    public void setUri(String string) {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        ((PaintModificationHandler)this.handler).uriValueChanged(string);
    }

    public void setPaint(short s, String string, String string2, String string3) {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        ((PaintModificationHandler)this.handler).paintChanged(s, string, string2, string3);
    }

    public abstract class AbstractModificationHandler
    extends AbstractValueModificationHandler
    implements PaintModificationHandler {
        @Override
        public void uriValueChanged(String string) {
            this.setPropertyText("url(" + string + ") none");
        }

        @Override
        public void paintChanged(short s, String string, String string2, String string3) {
            switch (s) {
                case 101: {
                    this.setPropertyText("none");
                    break;
                }
                case 102: {
                    this.setPropertyText("currentcolor");
                    break;
                }
                case 1: {
                    this.setPropertyText(string2);
                    break;
                }
                case 2: {
                    this.setPropertyText(string2 + ' ' + string3);
                    break;
                }
                case 107: {
                    this.setPropertyText("url(" + string + ')');
                    break;
                }
                case 103: {
                    this.setPropertyText("url(" + string + ") none");
                    break;
                }
                case 104: {
                    this.setPropertyText("url(" + string + ") currentcolor");
                    break;
                }
                case 105: {
                    this.setPropertyText("url(" + string + ") " + string2);
                    break;
                }
                case 106: {
                    this.setPropertyText("url(" + string + ") " + string2 + ' ' + string3);
                }
            }
        }
    }

    public static interface PaintModificationHandler
    extends ValueModificationHandler {
        public void uriValueChanged(String var1);

        public void paintChanged(short var1, String var2, String var3, String var4);
    }
}

