/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.dom;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.echosvg.css.engine.value.CSSVal;
import io.sf.carte.echosvg.css.engine.value.ColorFunction;
import io.sf.carte.echosvg.css.engine.value.ColorValue;
import io.sf.carte.echosvg.css.engine.value.NumericValue;
import io.sf.carte.echosvg.css.engine.value.RGBColorValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueModificationHandler;
import org.w3c.css.om.typed.CSSColorValue;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.svg.SVGICCColor;
import org.w3c.dom.svg.SVGNumber;
import org.w3c.dom.svg.SVGNumberList;

public class CSSOMSVGColor
implements CSSVal,
CSSColorValue,
SVGICCColor,
SVGNumberList {
    protected ValueProvider valueProvider;
    protected ValueModificationHandler handler;

    public CSSOMSVGColor(ValueProvider valueProvider) {
        this.valueProvider = valueProvider;
    }

    public void setModificationHandler(ValueModificationHandler valueModificationHandler) {
        this.handler = valueModificationHandler;
    }

    public String getCssText() {
        return this.valueProvider.getValue().getCssText();
    }

    public void setCssText(String string) throws DOMException {
        throw new DOMException(7, "");
    }

    public String toString() {
        return this.getCssText();
    }

    public CSSValue.CssType getCssValueType() {
        return CSSValue.CssType.TYPED;
    }

    public CSSValue.Type getPrimitiveType() {
        return this.valueProvider.getValue().getPrimitiveType();
    }

    @Override
    public float getFloatValue() {
        return this.valueProvider.getValue().getFloatValue();
    }

    @Override
    public int getLength() {
        return this.valueProvider.getValue().getLength();
    }

    @Override
    public Value item(int n) {
        this.valueProvider.getValue().setModificationHandler(this.handler);
        return this.valueProvider.getValue().item(n);
    }

    @Override
    public String getIdentifierValue() throws DOMException {
        return this.valueProvider.getValue().getIdentifierValue();
    }

    @Override
    public String getStringValue() throws DOMException {
        return this.valueProvider.getValue().getStringValue();
    }

    @Override
    public String getURIValue() throws DOMException {
        return this.valueProvider.getValue().getURIValue();
    }

    @Override
    public Value clone() {
        return this.valueProvider.getValue().clone();
    }

    public short getColorType() {
        Value value = this.valueProvider.getValue();
        switch (value.getCssValueType()) {
            case TYPED: {
                switch (value.getPrimitiveType()) {
                    case IDENT: {
                        if ("currentcolor".equalsIgnoreCase(value.getIdentifierValue())) {
                            return 3;
                        }
                        return 1;
                    }
                    case COLOR: {
                        ColorValue colorValue = value.getColorValue();
                        switch (colorValue.getCSSColorSpace()) {
                            case "rgb": {
                                return 1;
                            }
                        }
                        throw new IllegalStateException("Found unexpected color type:" + colorValue.getCSSColorSpace());
                    }
                }
                throw new IllegalStateException("Found unexpected PrimitiveType:" + value.getPrimitiveType());
            }
            case LIST: {
                return 2;
            }
        }
        throw new IllegalStateException("Found unexpected CssValueType:" + value.getCssValueType());
    }

    public RGBColor getRGBColor() {
        throw new DOMException(9, "Legacy value API not supported.");
    }

    public ColorValue getCSSColorValue() {
        this.valueProvider.getValue().setModificationHandler(this.handler);
        return this.valueProvider.getValue().getColorValue();
    }

    public String getCSSColorSpace() {
        return this.getCSSColorValue().getCSSColorSpace();
    }

    public NumericValue getAlpha() {
        return this.getCSSColorValue().getAlpha();
    }

    public void setAlpha(double d) {
        this.getCSSColorValue().setAlpha(d);
    }

    public NumericValue getR() {
        return this.getRGBColorValue().getR();
    }

    RGBColorValue getRGBColorValue() {
        ColorValue colorValue = this.getCSSColorValue();
        if ("rgb".equals(colorValue.getCSSColorSpace())) {
            return (RGBColorValue)colorValue;
        }
        throw new DOMException(15, "Not an RGB color.");
    }

    public NumericValue getG() {
        return this.getRGBColorValue().getG();
    }

    public NumericValue getB() {
        return this.getRGBColorValue().getB();
    }

    public void setRGBColor(String string) {
        throw new DOMException(7, "");
    }

    public SVGICCColor getICCColor() {
        return this;
    }

    public void setRGBColorICCColor(String string, String string2) {
        throw new DOMException(7, "");
    }

    public void setColor(short s, String string, String string2) {
        throw new DOMException(7, "");
    }

    public String getColorProfile() {
        return this.getCSSColorValue().getCSSColorSpace();
    }

    public void setColorProfile(String string) throws DOMException {
        throw new DOMException(7, "");
    }

    public SVGNumberList getColors() {
        return this;
    }

    public int getNumberOfItems() {
        ColorValue colorValue = this.getCSSColorValue();
        if (!(colorValue instanceof ColorFunction)) {
            throw new DOMException(15, "");
        }
        return ((ColorFunction)colorValue).getChannels().getLength();
    }

    public void clear() throws DOMException {
        throw new DOMException(7, "");
    }

    public SVGNumber initialize(SVGNumber sVGNumber) throws DOMException {
        throw new DOMException(7, "");
    }

    public SVGNumber getItem(int n) throws DOMException {
        if (this.getColorType() != 2) {
            throw new DOMException(1, "");
        }
        int n2 = this.getNumberOfItems();
        if (n < 0 || n >= n2) {
            throw new DOMException(1, "");
        }
        ColorValue colorValue = this.getCSSColorValue();
        if (!(colorValue instanceof ColorFunction)) {
            throw new DOMException(15, "");
        }
        float f = ((NumericValue)((ColorFunction)colorValue).getChannels().item(n)).getFloatValue();
        ColorNumber colorNumber = new ColorNumber(f);
        return colorNumber;
    }

    public SVGNumber insertItemBefore(SVGNumber sVGNumber, int n) throws DOMException {
        throw new DOMException(7, "");
    }

    public SVGNumber replaceItem(SVGNumber sVGNumber, int n) throws DOMException {
        throw new DOMException(7, "");
    }

    public SVGNumber removeItem(int n) throws DOMException {
        throw new DOMException(7, "");
    }

    public SVGNumber appendItem(SVGNumber sVGNumber) throws DOMException {
        throw new DOMException(7, "");
    }

    protected class ColorNumber
    implements SVGNumber {
        protected float value;

        public ColorNumber(float f) {
            this.value = f;
        }

        public float getValue() {
            return this.value;
        }

        public void setValue(float f) {
            throw new DOMException(7, "");
        }
    }

    public static interface ValueProvider {
        public Value getValue();
    }
}

